-- measurement pos unit
update measurement_position mp
set mp.mat_selling_price_per_unit = (select mat_selling_price_per_unit from QUOTATION_POSITION qp where qp.id = mp.QUOTATION_POSITION_ID)
where mp.QUOTATION_POSITION_ID IS NOT NULL AND
      mp.MEASUREMENT_ID IN (select id from MEASUREMENT m where m.LAST_ORIGIN = 'QUANTE_V2');

-- measurement pos agg
update measurement_position
set mat_selling_price_agg = round((product * mat_selling_price_per_unit), 2)
where material_factor IS NOT NULL
  AND mat_purchase_inc_disc_per_unit IS NOT NULL
  AND abs((product * mat_selling_price_per_unit) - mat_selling_price_agg) >= 0.01
  AND MEASUREMENT_ID IN (select id from MEASUREMENT m where m.LAST_ORIGIN = 'QUANTE_V2');
;

-- measurement agg
update measurement m
set m.mat_selling_price_overall = (select nvl(sum(mp.mat_selling_price_agg), 0) from measurement_position mp where m.id = mp.measurement_id)
where id > 0
;

-- Q2
update fr_aufmasspos
set pos_mat_vk = round(produkt * mat_vk, 2)
where lf_nr_a in (select lf_nr_a from btr_aufmass where status  = 'vorläufig')
  AND pos_mat_vk != round(produkt * mat_vk, 2);

delete from change_event;