select *
from (select measuremen0_.id                           as col_0_0_,
             measuremen0_.measurement_number           as col_1_0_,
             measuremen0_.updated_on                   as col_2_0_,
             measuremen0_.updated_by                   as col_3_0_,
             measuremen0_.construction_site            as col_4_0_,
             measuremen0_.measurement_state            as col_5_0_,
             measuremen0_.project_execution_start_date as col_6_0_,
             measuremen0_.project_execution_end_date   as col_7_0_,
             measuremen0_.accounting_month             as col_8_0_,
             quotation1_.commission_number             as col_9_0_,
             quotation1_.quotation_number              as col_10_0_,
             quotation1_.cost_center_external          as col_11_0_,
             releaseord2_.name                         as col_12_0_,
             measuremen0_.wage_overall                 as col_13_0_,
             measuremen0_.value_overall                as col_14_0_,
             measuremen0_.company_wage_overall         as col_15_0_,
             measuremen0_.mat_purchase_price_overall   as col_16_0_,
             businessun5_.cost_center                  as col_17_0_
      from MEASUREMENT measuremen0_
               left outer join QUOTATION quotation1_ on measuremen0_.quotation_id = quotation1_.id
               left outer join RELEASE_ORDER releaseord2_ on measuremen0_.id = releaseord2_.measurement_id
               left outer join SYS_USER user3_ on measuremen0_.assigned_user_id = user3_.id
               left outer join USER_BUSINESS_UNIT userbusine4_ on user3_.id = userbusine4_.user_id and
                                                                  (measuremen0_.accounting_month >=
                                                                   userbusine4_.VALID_BEGIN and
                                                                   measuremen0_.accounting_month <=
                                                                   userbusine4_.VALID_END)
               left outer join BUSINESS_UNIT businessun5_ on userbusine4_.business_unit_id = businessun5_.id
      where (businessun5_.cost_center in (?))
        and (measuremen0_.measurement_state in (?, ?, ?, ?))
        and measuremen0_.accounting_month >= ?
        and measuremen0_.accounting_month <= ?
      order by measuremen0_.measurement_number asc)
where rownum <= ?