/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.validator.payroll;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import de.qfm.erp.service.model.exception.request.UpdateRejectException;
import de.qfm.erp.service.model.internal.employee.payroll.PayrollStateChangeBucket;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.internal.message.EMessageKey;
import de.qfm.erp.service.model.internal.message.Message;
import de.qfm.erp.service.model.internal.message.Translatable;
import de.qfm.erp.service.model.jpa.employee.payroll.EPayrollMonthState;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonth;
import de.qfm.erp.service.model.jpa.user.EPrivilege;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.service.security.UserService;
import de.qfm.erp.service.service.service.MessageService;
import de.qfm.erp.service.service.validator.payroll.PayrollBeforeStateChangeValidator;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import lombok.NonNull;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Service
@Order(value=0)
public class PayrollStateChangePrivilegedValidator
extends PayrollBeforeStateChangeValidator {
    private final UserService userService;
    private final MessageService messageService;

    public boolean validate(@NonNull PayrollStateChangeBucket stateChangeBucket) {
        EPayrollMonthState stateOld;
        if (stateChangeBucket == null) {
            throw new NullPointerException("stateChangeBucket is marked non-null but is null");
        }
        PayrollMonth payrollMonth = stateChangeBucket.getPayrollMonth();
        EPayrollMonthState stateNew = stateChangeBucket.getPayrollMonthStateNew();
        if (!Objects.equals(stateNew, stateOld = (EPayrollMonthState)MoreObjects.firstNonNull((Object)payrollMonth.getPayrollMonthState(), (Object)EPayrollMonthState.UNKNOWN))) {
            String stateOldTranslated = this.messageService.getDE((Translatable)stateOld, new Object[0]);
            String stateNewTranslated = this.messageService.getDE((Translatable)stateNew, new Object[0]);
            if (Objects.equals(stateOld, EPayrollMonthState.UNRELEASED) && Objects.equals(stateNew, EPayrollMonthState.RELEASED)) {
                if (this.userService.hasPrivilege(EPrivilege.PAYROLL_MONTH_STATE__UNRELEASED_TO_RELEASED)) {
                    return true;
                }
                throw new UpdateRejectException((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.PAYROLL_MONTH__STATE), (Object)stateNew, String.format("Payroll Month State cannot be changed from: %s to %s, you are not privileged", stateOld, stateNew), Message.of((EMessageKey)EMessageKey.RULE_PAYROLL_MONTH_STATE_CHANGE_MISSING_PRIVILEGE, (List)ImmutableList.of((Object)stateOldTranslated, (Object)stateNewTranslated)));
            }
            if (Objects.equals(stateOld, EPayrollMonthState.RELEASED) && Objects.equals(stateNew, EPayrollMonthState.UNRELEASED)) {
                boolean alreadyExported;
                LocalDateTime exportedOn = payrollMonth.getExportedOn();
                User exportedBy = payrollMonth.getExportedBy();
                boolean bl = alreadyExported = null != exportedOn || null != exportedBy;
                if (alreadyExported) {
                    if (this.userService.hasPrivilege(EPrivilege.PAYROLL_MONTH_STATE__RELEASED_TO_UNRELEASED__EXPORTED)) {
                        return true;
                    }
                    throw new UpdateRejectException((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.PAYROLL_MONTH__STATE), (Object)stateNew, String.format("Payroll Month State cannot be changed from: %s to %s, you are not privileged because its already exported", stateOld, stateNew), Message.of((EMessageKey)EMessageKey.RULE_PAYROLL_MONTH_STATE_CHANGE_MISSING_PRIVILEGE__ALREADY_EXPORTED, (List)ImmutableList.of((Object)stateOldTranslated, (Object)stateNewTranslated)));
                }
                if (this.userService.hasPrivilege(EPrivilege.PAYROLL_MONTH_STATE__RELEASED_TO_UNRELEASED)) {
                    return true;
                }
                throw new UpdateRejectException((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.PAYROLL_MONTH__STATE), (Object)stateNew, String.format("Payroll Month State cannot be changed from: %s to %s, you are not privileged", stateOld, stateNew), Message.of((EMessageKey)EMessageKey.RULE_PAYROLL_MONTH_STATE_CHANGE_MISSING_PRIVILEGE, (List)ImmutableList.of((Object)stateOldTranslated, (Object)stateNewTranslated)));
            }
        }
        return true;
    }

    public PayrollStateChangePrivilegedValidator(UserService userService, MessageService messageService) {
        this.userService = userService;
        this.messageService = messageService;
    }
}

