/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.validator.payroll;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import de.qfm.erp.service.helper.PayrollMonthHelper;
import de.qfm.erp.service.helper.UserHelper;
import de.qfm.erp.service.model.exception.request.UpdateRejectException;
import de.qfm.erp.service.model.internal.employee.payroll.PayrollMonthResetBucket;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.internal.message.EMessageKey;
import de.qfm.erp.service.model.internal.message.Message;
import de.qfm.erp.service.model.jpa.employee.payroll.EPayrollItemClazz;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonth;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.service.handler.PayrollMonthHandler;
import de.qfm.erp.service.service.validator.payroll.PayrollBeforeResetValidator;
import java.time.YearMonth;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Service
@Order(value=2)
public class PayrollOnResetDisallowChangeIncentiveValidator
extends PayrollBeforeResetValidator {
    private static final Joiner USER_FULL_NAME_JOINER = Joiner.on((char)',').skipNulls();
    private final PayrollMonthHandler payrollMonthHandler;

    public boolean validate(@NonNull PayrollMonthResetBucket resetBucket) {
        if (resetBucket == null) {
            throw new NullPointerException("resetBucket is marked non-null but is null");
        }
        PayrollMonth payrollMonth = resetBucket.getPayrollMonth();
        YearMonth accountingMonth = YearMonth.from(payrollMonth.getAccountingMonth());
        List payrollMonthItems = payrollMonth.getPayrollMonthItems();
        List incentivePayrollMonthItems = (List)payrollMonthItems.stream().filter(EPayrollItemClazz.INCENTIVE_PREDICATE).collect(ImmutableList.toImmutableList());
        ImmutableSet.Builder usersToValidateBuilder = ImmutableSet.builder();
        incentivePayrollMonthItems.forEach(payrollMonthItem -> {
            User recipientExisting;
            if (null != payrollMonthItem && null != (recipientExisting = payrollMonthItem.getRecipient())) {
                usersToValidateBuilder.add((Object)recipientExisting);
            }
        });
        ImmutableSet usersToValidate = usersToValidateBuilder.build();
        Function userBooleanFunction = PayrollMonthHelper.usersInReleasedStateFn((YearMonth)accountingMonth, (Iterable)usersToValidate, (arg_0, arg_1) -> ((PayrollMonthHandler)this.payrollMonthHandler).releasedPayrollMonthsByUsersAndAccountingMonth(arg_0, arg_1));
        HashSet usersAlreadyReleased = Sets.newHashSet();
        for (User user : usersToValidate) {
            if (!((Boolean)userBooleanFunction.apply(user)).booleanValue()) continue;
            usersAlreadyReleased.add(user);
        }
        if (!Iterables.isEmpty((Iterable)usersAlreadyReleased)) {
            Set userFullNames = usersAlreadyReleased.stream().filter(Objects::nonNull).map(UserHelper::asString).collect(Collectors.toSet());
            String usersJoined = USER_FULL_NAME_JOINER.join(userFullNames);
            throw new UpdateRejectException((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.PAYROLL_MONTH_ITEM__RECIPIENT), (Object)usersJoined, String.format("Payroll Month cannot be reset, there is an assigned incentive wage on (an) Employee(s), which already have released: %s", usersJoined), Message.of((EMessageKey)EMessageKey.RULE_PAYROLL_MONTH_RESET__INCENTIVE_WAGE__RECIPIENT_IN_RELEASED_STATE, (List)ImmutableList.of(userFullNames)));
        }
        return true;
    }

    public PayrollOnResetDisallowChangeIncentiveValidator(PayrollMonthHandler payrollMonthHandler) {
        this.payrollMonthHandler = payrollMonthHandler;
    }
}

