/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.validator.payroll;

import com.google.common.collect.ImmutableList;
import de.leancoders.common.helper.DateTimeHelper;
import de.qfm.erp.service.model.exception.request.UpdateRejectException;
import de.qfm.erp.service.model.internal.employee.payroll.AttendanceResetBucket;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.internal.message.EMessageKey;
import de.qfm.erp.service.model.internal.message.Message;
import de.qfm.erp.service.model.jpa.employee.attendance.Attendance;
import de.qfm.erp.service.model.jpa.employee.attendance.EAttendanceOrigin;
import de.qfm.erp.service.service.validator.payroll.AttendanceBeforeResetValidator;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.List;
import lombok.NonNull;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Service
@Order(value=2)
public class AttendanceResetFollowingMonthDisallowedValidator
extends AttendanceBeforeResetValidator {
    public boolean validate(@NonNull AttendanceResetBucket resetBucket) {
        if (resetBucket == null) {
            throw new NullPointerException("resetBucket is marked non-null but is null");
        }
        EAttendanceOrigin origin = resetBucket.getOrigin();
        Attendance attendance = resetBucket.getAttendance();
        YearMonth attendanceMonth = YearMonth.from(attendance.getDate());
        YearMonth currentMonth = YearMonth.now();
        boolean originIsBadWeather = EAttendanceOrigin.BAD_WEATHER == origin;
        boolean attendanceMonthIsBeforeCurrentMonth = attendanceMonth.isBefore(currentMonth);
        if (originIsBadWeather && attendanceMonthIsBeforeCurrentMonth) {
            String dateAsString = DateTimeHelper.toIsoDate((LocalDate)attendance.getDate());
            throw new UpdateRejectException((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.PAYROLL_MONTH__ATTENDANCE__DATE), (Object)dateAsString, "Attendance cannot be updated, you try to reset/delete an Bad Weather Attendance, where the Date is not in the current month", Message.of((EMessageKey)EMessageKey.RULE_ATTENDANCE_RESET_BAD_WEATHER_TOO_LATE, (List)ImmutableList.of((Object)dateAsString)));
        }
        return true;
    }
}

