/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.validator.measurement;

import com.google.common.base.Joiner;
import de.qfm.erp.common.request.measurement.MeasurementPositionModificationItem;
import de.qfm.erp.common.request.measurement.MeasurementUpdateRequest;
import de.qfm.erp.service.model.exception.request.UpdateRejectException;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.internal.message.EMessageKey;
import de.qfm.erp.service.model.internal.message.Message;
import de.qfm.erp.service.model.jpa.measurement.Measurement;
import de.qfm.erp.service.model.jpa.measurement.type.EMeasurementType;
import de.qfm.erp.service.model.jpa.measurement.type.EMeasurementViewType;
import de.qfm.erp.service.service.validator.Validator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.springframework.stereotype.Service;

@Service
public class MeasurementUpdateRequestValidator
extends Validator<MeasurementUpdateRequest, Measurement> {
    private static final Joiner SEQUENTIAL_NUMBER_JOINER = Joiner.on((String)", ").skipNulls();

    public boolean validate(@NonNull MeasurementUpdateRequest measurementUpdateRequest) {
        if (measurementUpdateRequest == null) {
            throw new NullPointerException("measurementUpdateRequest is marked non-null but is null");
        }
        String measurementTypeCandidate = measurementUpdateRequest.getMeasurementType();
        EMeasurementType measurementType = EMeasurementType.lookupFailing((String)measurementTypeCandidate);
        String measurementViewTypeCandidate = measurementUpdateRequest.getMeasurementViewType();
        EMeasurementViewType measurementViewType = EMeasurementViewType.lookupFailing((String)measurementViewTypeCandidate);
        List duplicateSequentialNumbers = measurementUpdateRequest.getMeasurementPositions().stream().map(MeasurementPositionModificationItem::getSequenceNumberMeasurementStandard).collect(Collectors.groupingBy(e -> e, Collectors.counting())).entrySet().stream().filter(entry -> ((Long)entry.getValue()).intValue() > 1).collect(Collectors.toList());
        if (!duplicateSequentialNumbers.isEmpty()) {
            String detail = SEQUENTIAL_NUMBER_JOINER.join(duplicateSequentialNumbers.stream().map(Map.Entry::getKey).iterator());
            throw new UpdateRejectException((FieldName)FieldNamesFactory.cascadedFieldName((FieldName[])new FieldName[]{FieldNamesFactory.simpleFieldName((EField)EField.MEASUREMENT_POSITIONS), FieldNamesFactory.simpleFieldName((EField)EField.POSITION_SEQUENTIAL_NUMBER_STANDARD)}), (Object)detail, String.format("The Standard Sequential Numbers: %s are duplicated in request", detail), Message.of((EMessageKey)EMessageKey.DUPLICATE_MEASUREMENT_POSITION__SEQUENTIAL_NUMBER, (String)detail));
        }
        return true;
    }
}

