/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.validator.measurement;

import com.google.common.collect.ImmutableList;
import de.qfm.erp.service.configuration.ApplicationConfig;
import de.qfm.erp.service.model.exception.request.BusinessRuleValidationException;
import de.qfm.erp.service.model.exception.request.RequestValidationException;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.SimpleFieldName;
import de.qfm.erp.service.model.internal.measurement.MeasurementModificationBucket;
import de.qfm.erp.service.model.internal.message.EMessageKey;
import de.qfm.erp.service.model.internal.message.Message;
import de.qfm.erp.service.model.jpa.measurement.Measurement;
import de.qfm.erp.service.service.validator.measurement.MeasurementBeforeMergeValidator;
import java.util.List;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Service
@Order(value=-200)
public class MeasurementMeasurementNumberChangeBeforeMergeValidator
extends MeasurementBeforeMergeValidator {
    private final ApplicationConfig applicationConfig;

    public boolean validate(@NonNull MeasurementModificationBucket measurementModificationBucket) {
        if (measurementModificationBucket == null) {
            throw new NullPointerException("measurementModificationBucket is marked non-null but is null");
        }
        boolean updateMeasurementNumberAllowed = measurementModificationBucket.isUpdateMeasurementNumberAllowed();
        String measurementNumber = measurementModificationBucket.getMeasurementNumber();
        Measurement measurement = (Measurement)measurementModificationBucket.getEntity();
        String measurementNumberInDatabase = StringUtils.trimToEmpty((String)measurement.getMeasurementNumber());
        String measurementNumberInRequest = StringUtils.trimToEmpty((String)measurementNumber);
        if (!updateMeasurementNumberAllowed && StringUtils.isNotBlank((CharSequence)measurementNumberInDatabase) && !StringUtils.equalsIgnoreCase((CharSequence)measurementNumberInDatabase, (CharSequence)measurementNumberInRequest)) {
            SimpleFieldName fieldName = SimpleFieldName.of((EField)EField.MEASUREMENT__MEASUREMENT_NUMBER);
            String fieldPath = fieldName.path();
            String messageText = String.format("Field: %s cannot be changed, DB Value: %s, Request Value: %s", fieldPath, measurementNumberInDatabase, measurementNumberInRequest);
            Message message = Message.of((EMessageKey)EMessageKey.RULE_MEASUREMENT_NUMBER_PREVENT_UPDATE, (List)ImmutableList.of((Object)measurementNumberInDatabase, (Object)measurementNumberInRequest));
            ImmutableList details = ImmutableList.of((Object)RequestValidationException.Detail.of((FieldName)fieldName, (Object)measurementNumberInRequest, (String)messageText, (Message)message, (List)ImmutableList.of()));
            throw new BusinessRuleValidationException("Business Rules Validation Error", (List)details);
        }
        return true;
    }

    public MeasurementMeasurementNumberChangeBeforeMergeValidator(ApplicationConfig applicationConfig) {
        this.applicationConfig = applicationConfig;
    }
}

