/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.validator.measurement;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import de.leancoders.common.helper.DateTimeHelper;
import de.qfm.erp.common.request.measurement.MeasurementModificationRequest;
import de.qfm.erp.service.configuration.ApplicationConfig;
import de.qfm.erp.service.model.exception.request.BusinessRuleValidationException;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.internal.measurement.MeasurementModificationBucket;
import de.qfm.erp.service.model.jpa.measurement.Measurement;
import de.qfm.erp.service.service.validator.measurement.MeasurementBeforeMergeValidator;
import java.time.LocalDate;
import java.util.List;
import lombok.NonNull;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Service
@Order(value=-100)
public class MeasurementHeadConsistencyBeforeMergeValidator
extends MeasurementBeforeMergeValidator {
    private static final String MSG_ALLOWED_CONFIGURED_RANGE = "allowed configured range of this value";
    private static final String MSG_TOO_FAR_FROM_PROJECT_END = "Too far from Project End";
    private final ApplicationConfig applicationConfig;

    public boolean validate(@NonNull MeasurementModificationBucket measurementModificationBucket) {
        boolean equal;
        if (measurementModificationBucket == null) {
            throw new NullPointerException("measurementModificationBucket is marked non-null but is null");
        }
        Measurement measurement = (Measurement)measurementModificationBucket.getEntity();
        MeasurementModificationRequest updateRequest = (MeasurementModificationRequest)measurementModificationBucket.getRequest();
        ImmutableList.Builder detailBuilder = ImmutableList.builder();
        LocalDate projectExecutionStartDatePersisted = measurement.getProjectExecutionStartDate();
        LocalDate projectExecutionEndDatePersisted = measurement.getProjectExecutionEndDate();
        LocalDate accountingMonthPersisted = measurement.getAccountingMonth();
        LocalDate projectExecutionStartDateRequested = updateRequest.getProjectExecutionStartDate();
        LocalDate projectExecutionEndDateRequested = updateRequest.getProjectExecutionEndDate();
        LocalDate accountingMonthRequested = updateRequest.getAccountingMonth();
        boolean bl = equal = Objects.equal((Object)projectExecutionStartDatePersisted, (Object)projectExecutionStartDateRequested) && Objects.equal((Object)projectExecutionEndDatePersisted, (Object)projectExecutionEndDateRequested) && Objects.equal((Object)accountingMonthPersisted, (Object)accountingMonthRequested);
        if (!equal) {
            Range accountingMonthRange = Range.closed((Comparable)projectExecutionStartDateRequested.minusDays(this.applicationConfig.getValidationAccountingMinusDays()), (Comparable)projectExecutionEndDateRequested.plusDays(this.applicationConfig.getValidationAccountingPlusDays()));
            Range allowedConstructionDateRange = Range.closed((Comparable)DateTimeHelper.today().minusDays(this.applicationConfig.getValidationConstructionMinusDays()), (Comparable)DateTimeHelper.today().plusDays(this.applicationConfig.getValidationConstructionPlusDays()));
            detailBuilder.addAll((Iterable)this.checkWithinRangeIfSet((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.ACCOUNTING_MONTH), accountingMonthRequested, accountingMonthRange, MSG_ALLOWED_CONFIGURED_RANGE));
            detailBuilder.addAll((Iterable)this.checkWithinRangeIfSet((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.PROJECT_EXECUTION_START_DATE), projectExecutionStartDateRequested, allowedConstructionDateRange, MSG_ALLOWED_CONFIGURED_RANGE));
            detailBuilder.addAll((Iterable)this.checkWithinRangeIfSet((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.PROJECT_EXECUTION_END_DATE), projectExecutionEndDateRequested, allowedConstructionDateRange, MSG_ALLOWED_CONFIGURED_RANGE));
            detailBuilder.addAll((Iterable)this.checkDateFollowsDate((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.PROJECT_EXECUTION_START_DATE), (FieldName)FieldNamesFactory.simpleFieldName((EField)EField.PROJECT_EXECUTION_END_DATE), updateRequest.getProjectExecutionStartDate(), updateRequest.getProjectExecutionEndDate()));
            Range allowedConstructionDateRangeAfterProjectEnd = Range.closed((Comparable)projectExecutionStartDateRequested.minusDays(this.applicationConfig.getValidationConstructionAccountingMinusDays()), (Comparable)projectExecutionEndDateRequested.plusDays(this.applicationConfig.getValidationConstructionAccountingPlusDays()));
            detailBuilder.addAll((Iterable)this.checkWithinRangeIfSet((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.ACCOUNTING_MONTH), accountingMonthRequested, allowedConstructionDateRangeAfterProjectEnd, MSG_TOO_FAR_FROM_PROJECT_END));
            ImmutableList details = detailBuilder.build();
            if (!details.isEmpty()) {
                throw new BusinessRuleValidationException("Business Rules Validation Error", (List)details);
            }
        }
        return true;
    }

    public MeasurementHeadConsistencyBeforeMergeValidator(ApplicationConfig applicationConfig) {
        this.applicationConfig = applicationConfig;
    }
}

