/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.validator.invoice;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import de.qfm.erp.service.model.internal.invoice.InvoiceValidationBucket;
import de.qfm.erp.service.model.internal.message.EMessageKey;
import de.qfm.erp.service.model.internal.message.Message;
import de.qfm.erp.service.model.internal.validation.ValidationResult;
import de.qfm.erp.service.model.jpa.invoice.EInvoiceState;
import de.qfm.erp.service.model.jpa.invoice.Invoice;
import de.qfm.erp.service.service.validator.invoice.InvoiceBeforeChangeValidator;
import de.qfm.erp.service.service.validator.invoice.InvoiceBeforeStateChangeValidator;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class InvoiceAccountingValidator
extends InvoiceBeforeStateChangeValidator {
    public InvoiceAccountingValidator() {
        super((Iterable)ImmutableSet.of((Object)InvoiceBeforeChangeValidator.EInvoiceValidatorProperty.PDF, (Object)InvoiceBeforeChangeValidator.EInvoiceValidatorProperty.UPDATE));
    }

    public Iterable<ValidationResult> validate(@NonNull InvoiceValidationBucket bucket) {
        if (bucket == null) {
            throw new NullPointerException("bucket is marked non-null but is null");
        }
        ImmutableList.Builder validationResultBuilder = ImmutableList.builder();
        Invoice invoice = bucket.getInvoice();
        EInvoiceState invoiceStateNew = bucket.getInvoiceStateNew();
        if (null != invoice && invoiceStateNew == EInvoiceState.ACCOUNTED) {
            ImmutableList financeMissing;
            ImmutableList.Builder financeMissingBuilder = ImmutableList.builder();
            if (StringUtils.isBlank((CharSequence)invoice.getFinanceCompanyNumber())) {
                financeMissingBuilder.add((Object)"Firmennummer (010)");
            }
            if (null == invoice.getFinanceTimeForPayment()) {
                financeMissingBuilder.add((Object)"Zahlungsfrist");
            }
            if (StringUtils.isBlank((CharSequence)invoice.getFinanceDebtorAccountNumber())) {
                financeMissingBuilder.add((Object)"Debitorenkontonummer");
            }
            if (null == invoice.getFinanceTaxKey()) {
                financeMissingBuilder.add((Object)"Steuerschl\u00fcssel");
            }
            if (!Iterables.isEmpty((Iterable)(financeMissing = financeMissingBuilder.build()))) {
                validationResultBuilder.add((Object)ValidationResult.error((Message)Message.of((EMessageKey)EMessageKey.RULE_INVOICE__MISSING_FINANCE_DATA, (String)COMMA_JOINER.join((Iterable)financeMissing))));
            }
        }
        return validationResultBuilder.build();
    }
}

