/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.validator;

import com.google.common.collect.ImmutableList;
import de.qfm.erp.common.request.UpdateRequest;
import de.qfm.erp.service.model.exception.request.EnumNotFoundException;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.jpa.EntityBase;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import lombok.NonNull;

public abstract class Validator<T extends UpdateRequest, V extends EntityBase> {
    public abstract boolean validate(@NonNull T var1);

    @Nonnull
    public static EnumNotFoundException throwEnumException(@NonNull FieldName fieldName, @NonNull String candidate, @NonNull Class<?> clazz, @NonNull Supplier<Collection<String>> allowedKeysSupplier) {
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (allowedKeysSupplier == null) {
            throw new NullPointerException("allowedKeysSupplier is marked non-null but is null");
        }
        ImmutableList allowedKeys = ImmutableList.copyOf(allowedKeysSupplier.get());
        String message = String.format("Value: %s for Enum Type: %s cannot be found, expecting one of: %s", candidate, clazz, allowedKeys);
        return new EnumNotFoundException(fieldName, (Object)candidate, message, (List)allowedKeys);
    }
}

