/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service.xls;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import com.google.common.primitives.Ints;
import de.leancoders.common.helper.DateTimeHelper;
import de.qfm.erp.service.model.internal.payroll.ProjectBasedWageIncentiveWageItem;
import de.qfm.erp.service.model.internal.payroll.ProjectBasedWageReportBucket;
import de.qfm.erp.service.model.internal.xlsx.CellStyles;
import de.qfm.erp.service.service.service.DateTimeHelperService;
import de.qfm.erp.service.service.service.xls.AbstractXlsExportService;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ProjectWageReportXlsExportService
extends AbstractXlsExportService {
    private static final Logger log = LogManager.getLogger(ProjectWageReportXlsExportService.class);
    public static final int S1_NAME_COL_IDX = 0;
    public static final int S1_PNO_COL_IDX = 1;
    public static final int S1_SUM_COL_IDX = 2;
    public static final int S1_WAGE_ACCOUNT_COL_IDX = 4;
    public static final int S2_SENDER_PNR_COL_IDX = 0;
    public static final int S2_SENDER_NAME_COL_IDX = 1;
    public static final int S2_SENDER_CC_COL_IDX = 2;
    public static final int S2_RECIPIENT_PNR_COL_IDX = 3;
    public static final int S2_RECIPIENT_NAME_COL_IDX = 4;
    public static final int S2_RECIPIENT_CC_COL_IDX = 5;
    public static final int S2_STAGE_NUMBER = 6;
    public static final int S2_STAGE_ALIAS = 7;
    public static final int S2_STAGE_PROJECT_NAME = 8;
    public static final int S2_STAGE_PROJECT_REF_ID = 9;
    public static final int S2_STAGE_WAGE = 10;

    @Nonnull
    public SXSSFWorkbook detailXLS(@NonNull YearMonth accountingMonth, @NonNull String costCenter, @NonNull Map<String, String> projectMapping, @NonNull Iterable<ProjectBasedWageReportBucket> buckets) {
        if (accountingMonth == null) {
            throw new NullPointerException("accountingMonth is marked non-null but is null");
        }
        if (costCenter == null) {
            throw new NullPointerException("costCenter is marked non-null but is null");
        }
        if (projectMapping == null) {
            throw new NullPointerException("projectMapping is marked non-null but is null");
        }
        if (buckets == null) {
            throw new NullPointerException("buckets is marked non-null but is null");
        }
        SXSSFWorkbook workbook = new SXSSFWorkbook();
        workbook.setCompressTempFiles(true);
        SXSSFSheet sheet1 = workbook.createSheet("Lohnr\u00fcckstellungen");
        sheet1.setRandomAccessWindowSize(100);
        SXSSFSheet sheet2 = workbook.createSheet("Lohn ausbezahlt");
        sheet2.setRandomAccessWindowSize(100);
        Font topHeaderFont = workbook.createFont();
        topHeaderFont.setBold(true);
        Font detailsFont = workbook.createFont();
        detailsFont.setBold(false);
        CellStyle headerStyle = workbook.createCellStyle();
        headerStyle.setFont(topHeaderFont);
        CellStyle detailsStyle = workbook.createCellStyle();
        detailsStyle.setFont(detailsFont);
        CellStyles cellStylesSheet1 = CellStyles.create((CellStyle)headerStyle, (CellStyle)detailsStyle, (CellStyle)CellStyles.decimal0CellStyle((SXSSFSheet)sheet1, (CellStyle)detailsStyle), (CellStyle)CellStyles.decimal2CellStyle((SXSSFSheet)sheet1, (CellStyle)detailsStyle), (CellStyle)CellStyles.formulaCellStyle((SXSSFSheet)sheet1, (CellStyle)detailsStyle));
        CellStyles cellStylesSheet2 = CellStyles.create((CellStyle)headerStyle, (CellStyle)detailsStyle, (CellStyle)CellStyles.decimal0CellStyle((SXSSFSheet)sheet2, (CellStyle)detailsStyle), (CellStyle)CellStyles.decimal2CellStyle((SXSSFSheet)sheet2, (CellStyle)detailsStyle), (CellStyle)CellStyles.formulaCellStyle((SXSSFSheet)sheet2, (CellStyle)detailsStyle));
        AtomicInteger rowNumSheet1 = new AtomicInteger();
        SXSSFRow row1 = ProjectWageReportXlsExportService.newRow((SXSSFSheet)sheet1, (AtomicInteger)rowNumSheet1);
        ProjectWageReportXlsExportService.createText((CellStyle)headerStyle, (String)"Lohr\u00fcckstellungen Kst.:", (SXSSFRow)row1, (int)0);
        ProjectWageReportXlsExportService.createText((CellStyle)headerStyle, (String)costCenter, (SXSSFRow)row1, (int)1);
        SXSSFRow row2 = ProjectWageReportXlsExportService.newRow((SXSSFSheet)sheet1, (AtomicInteger)rowNumSheet1);
        ProjectWageReportXlsExportService.createText((CellStyle)headerStyle, (String)"Zeitraum:", (SXSSFRow)row2, (int)0);
        ProjectWageReportXlsExportService.createText((CellStyle)headerStyle, (String)DateTimeHelperService.germanMonthDotYear((LocalDate)accountingMonth.atDay(1)), (SXSSFRow)row2, (int)1);
        SXSSFRow row3 = ProjectWageReportXlsExportService.newRow((SXSSFSheet)sheet1, (AtomicInteger)rowNumSheet1);
        ProjectWageReportXlsExportService.createText((CellStyle)headerStyle, (String)"Erstellungsdatum:", (SXSSFRow)row3, (int)0);
        ProjectWageReportXlsExportService.createText((CellStyle)headerStyle, (String)DateTimeHelperService.germanDate((LocalDate)DateTimeHelper.today()), (SXSSFRow)row3, (int)1);
        ImmutableSet projectNames = (ImmutableSet)Streams.stream(buckets).flatMap(item -> item.getWageInProjects().keySet().stream()).collect(ImmutableSet.toImmutableSet());
        SXSSFRow row4 = ProjectWageReportXlsExportService.newRow((SXSSFSheet)sheet1, (AtomicInteger)rowNumSheet1);
        SXSSFRow row5 = ProjectWageReportXlsExportService.newRow((SXSSFSheet)sheet1, (AtomicInteger)rowNumSheet1);
        ProjectWageReportXlsExportService.createText((CellStyle)headerStyle, (String)"R\u00fcckstellungen Lohn projektbezogen", (SXSSFRow)row5, (int)5);
        SXSSFRow row6 = ProjectWageReportXlsExportService.newRow((SXSSFSheet)sheet1, (AtomicInteger)rowNumSheet1);
        SXSSFRow row7 = ProjectWageReportXlsExportService.newRow((SXSSFSheet)sheet1, (AtomicInteger)rowNumSheet1);
        ProjectWageReportXlsExportService.createText((CellStyle)headerStyle, (String)"Mitarbeiter", (SXSSFRow)row7, (int)0);
        ProjectWageReportXlsExportService.createText((CellStyle)headerStyle, (String)"PNr", (SXSSFRow)row7, (int)1);
        ProjectWageReportXlsExportService.createText((CellStyle)headerStyle, (String)"Summe R\u00fcckstellungen", (SXSSFRow)row7, (int)2);
        ProjectWageReportXlsExportService.createText((CellStyle)headerStyle, (String)"Guthaben", (SXSSFRow)row7, (int)4);
        int projectStartIndex = 5;
        int index = 5;
        log.info("projectNames: {}", (Object)projectNames);
        log.info("projectMapping: {}", projectMapping);
        for (String projectName : projectNames) {
            String referenceId = projectMapping.getOrDefault(projectName, "");
            Integer projectNumber = this.integerValue(referenceId);
            ProjectWageReportXlsExportService.createNumber((CellStyles)cellStylesSheet1, (Integer)projectNumber, (SXSSFRow)row6, (int)index);
            ProjectWageReportXlsExportService.createText((CellStyle)headerStyle, (String)projectName, (SXSSFRow)row7, (int)index);
            ++index;
        }
        HashMap projectColumnIndex = Maps.newHashMap();
        index = 5;
        for (Object projectName : projectNames) {
            projectColumnIndex.put(projectName, index++);
        }
        ArrayList detailRows = Lists.newArrayList();
        for (ProjectBasedWageReportBucket stageWageItem : buckets) {
            SXSSFRow detailRow = ProjectWageReportXlsExportService.newRow((SXSSFSheet)sheet1, (AtomicInteger)rowNumSheet1);
            boolean snapShotData = stageWageItem.isSnapShotData();
            ProjectWageReportXlsExportService.createText((CellStyle)detailsStyle, (String)String.format("%s %s %s", stageWageItem.getFirstName(), stageWageItem.getLastName(), snapShotData ? "*" : ""), (SXSSFRow)detailRow, (int)0);
            ProjectWageReportXlsExportService.createNumber((CellStyles)cellStylesSheet1, (Integer)stageWageItem.getPersonalNumber(), (SXSSFRow)detailRow, (int)1);
            ProjectWageReportXlsExportService.numericFormula((CellStyles)cellStylesSheet1, (String)ProjectWageReportXlsExportService.sumForRowIndex((SXSSFRow)detailRow, (Pair)Pair.of((Object)4, (Object)(5 + projectColumnIndex.size() - 1))), (SXSSFRow)detailRow, (int)2);
            Object wageAccountBalance = stageWageItem.getWageAccountBalance();
            ProjectWageReportXlsExportService.createNumber((CellStyles)cellStylesSheet1, (BigDecimal)wageAccountBalance, (SXSSFRow)detailRow, (int)4);
            Map wageInProjects = stageWageItem.getWageInProjects();
            for (String projectName : projectNames) {
                if (!wageInProjects.containsKey(projectName)) continue;
                BigDecimal wageInProject = (BigDecimal)wageInProjects.get(projectName);
                Integer colIdx = (Integer)projectColumnIndex.get(projectName);
                ProjectWageReportXlsExportService.createNumber((CellStyles)cellStylesSheet2, (BigDecimal)wageInProject, (SXSSFRow)detailRow, (int)colIdx);
            }
            detailRows.add(detailRow);
        }
        SXSSFRow row8 = ProjectWageReportXlsExportService.newRow((SXSSFSheet)sheet1, (AtomicInteger)rowNumSheet1);
        SXSSFRow row9 = ProjectWageReportXlsExportService.newRow((SXSSFSheet)sheet1, (AtomicInteger)rowNumSheet1);
        ProjectWageReportXlsExportService.createText((CellStyle)headerStyle, (String)"Summe", (SXSSFRow)row9, (int)0);
        if (!detailRows.isEmpty()) {
            String sumFormula = ProjectWageReportXlsExportService.sumForColIndex((List)detailRows, (Integer)2);
            ProjectWageReportXlsExportService.numericFormula((CellStyles)cellStylesSheet1, (String)sumFormula, (SXSSFRow)row9, (int)2);
            String wageAccountFormula = ProjectWageReportXlsExportService.sumForColIndex((List)detailRows, (Integer)4);
            ProjectWageReportXlsExportService.numericFormula((CellStyles)cellStylesSheet1, (String)wageAccountFormula, (SXSSFRow)row9, (int)4);
            for (String projectName : projectNames) {
                Integer prjIdx = (Integer)projectColumnIndex.get(projectName);
                String prjFormula = ProjectWageReportXlsExportService.sumForColIndex((List)detailRows, (Integer)prjIdx);
                ProjectWageReportXlsExportService.numericFormula((CellStyles)cellStylesSheet1, (String)prjFormula, (SXSSFRow)row9, (int)prjIdx);
            }
        }
        ImmutableList.Builder columnWidthsBuilder = ImmutableList.builder();
        columnWidthsBuilder.add((Object[])new Integer[]{100, 50, 150, 30});
        projectNames.forEach(item -> columnWidthsBuilder.add((Object)100));
        ImmutableList columnWidths = columnWidthsBuilder.build();
        int colWidthIdx = 0;
        for (Integer columnWidth : columnWidths) {
            sheet1.setColumnWidth(colWidthIdx++, columnWidth * 75);
        }
        AtomicInteger rowNumSheet2 = new AtomicInteger();
        SXSSFRow s2Row1 = ProjectWageReportXlsExportService.newRow((SXSSFSheet)sheet2, (AtomicInteger)rowNumSheet2);
        ProjectWageReportXlsExportService.createText((CellStyle)headerStyle, (String)"Sender PNr", (SXSSFRow)s2Row1, (int)0);
        ProjectWageReportXlsExportService.createText((CellStyle)headerStyle, (String)"Sender Name", (SXSSFRow)s2Row1, (int)1);
        ProjectWageReportXlsExportService.createText((CellStyle)headerStyle, (String)"Sender KST", (SXSSFRow)s2Row1, (int)2);
        ProjectWageReportXlsExportService.createText((CellStyle)headerStyle, (String)"Empf\u00e4nger PNr", (SXSSFRow)s2Row1, (int)3);
        ProjectWageReportXlsExportService.createText((CellStyle)headerStyle, (String)"Empf\u00e4nger Name", (SXSSFRow)s2Row1, (int)4);
        ProjectWageReportXlsExportService.createText((CellStyle)headerStyle, (String)"Empf\u00e4nger KST", (SXSSFRow)s2Row1, (int)5);
        ProjectWageReportXlsExportService.createText((CellStyle)headerStyle, (String)"Stage Number", (SXSSFRow)s2Row1, (int)6);
        ProjectWageReportXlsExportService.createText((CellStyle)headerStyle, (String)"Stage Alias", (SXSSFRow)s2Row1, (int)7);
        ProjectWageReportXlsExportService.createText((CellStyle)headerStyle, (String)"Projektteam Name", (SXSSFRow)s2Row1, (int)8);
        ProjectWageReportXlsExportService.createText((CellStyle)headerStyle, (String)"Projektteam Nummer", (SXSSFRow)s2Row1, (int)9);
        ProjectWageReportXlsExportService.createText((CellStyle)headerStyle, (String)"Wert", (SXSSFRow)s2Row1, (int)10);
        for (ProjectBasedWageReportBucket bucket : buckets) {
            Iterable incentiveWages = bucket.getIncentiveWages();
            for (ProjectBasedWageIncentiveWageItem incentiveWage : incentiveWages) {
                SXSSFRow detailRow = ProjectWageReportXlsExportService.newRow((SXSSFSheet)sheet2, (AtomicInteger)rowNumSheet2);
                ProjectWageReportXlsExportService.createNumber((CellStyles)cellStylesSheet2, (Integer)incentiveWage.getSenderPersonalNumber(), (SXSSFRow)detailRow, (int)0);
                ProjectWageReportXlsExportService.createText((CellStyle)detailsStyle, (String)incentiveWage.getSenderFullName(), (SXSSFRow)detailRow, (int)1);
                Integer senderCostCenter = this.integerValue(incentiveWage.getSenderCostCenter());
                ProjectWageReportXlsExportService.createNumber((CellStyles)cellStylesSheet2, (Integer)senderCostCenter, (SXSSFRow)detailRow, (int)2);
                ProjectWageReportXlsExportService.createNumber((CellStyles)cellStylesSheet2, (Integer)incentiveWage.getRecipientPersonalNumber(), (SXSSFRow)detailRow, (int)3);
                ProjectWageReportXlsExportService.createText((CellStyle)detailsStyle, (String)incentiveWage.getRecipientFullName(), (SXSSFRow)detailRow, (int)4);
                Integer recipientCostCenter = this.integerValue(incentiveWage.getRecipientCostCenter());
                ProjectWageReportXlsExportService.createNumber((CellStyles)cellStylesSheet2, (Integer)recipientCostCenter, (SXSSFRow)detailRow, (int)5);
                ProjectWageReportXlsExportService.createText((CellStyle)detailsStyle, (String)incentiveWage.getStageNumber(), (SXSSFRow)detailRow, (int)6);
                ProjectWageReportXlsExportService.createText((CellStyle)detailsStyle, (String)incentiveWage.getStageAlias(), (SXSSFRow)detailRow, (int)7);
                ProjectWageReportXlsExportService.createText((CellStyle)detailsStyle, (String)incentiveWage.getStageProjectName(), (SXSSFRow)detailRow, (int)8);
                Integer proReferenceId = this.integerValue(incentiveWage.getStageProjectReferenceId());
                ProjectWageReportXlsExportService.createNumber((CellStyles)cellStylesSheet2, (Integer)proReferenceId, (SXSSFRow)detailRow, (int)9);
                ProjectWageReportXlsExportService.createNumber((CellStyles)cellStylesSheet2, (BigDecimal)incentiveWage.getAmount(), (SXSSFRow)detailRow, (int)10);
            }
        }
        sheet1.setDisplayGridlines(true);
        sheet2.setDisplayGridlines(true);
        sheet1.getForceFormulaRecalculation();
        sheet2.getForceFormulaRecalculation();
        return workbook;
    }

    @Nullable
    private Integer integerValue(@Nullable String input) {
        if (null != input) {
            try {
                return Ints.tryParse((String)input);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Nonnull
    private static String sumForColIndex(@NonNull List<SXSSFRow> detailRows, @NonNull Integer index) {
        if (detailRows == null) {
            throw new NullPointerException("detailRows is marked non-null but is null");
        }
        if (index == null) {
            throw new NullPointerException("index is marked non-null but is null");
        }
        String firstI1 = new CellAddress((Cell)detailRows.get(0).getCell(index.intValue(), Row.MissingCellPolicy.CREATE_NULL_AS_BLANK)).formatAsString();
        String lastI1 = new CellAddress((Cell)detailRows.get(detailRows.size() - 1).getCell(index.intValue(), Row.MissingCellPolicy.CREATE_NULL_AS_BLANK)).formatAsString();
        return String.format("SUM(%s:%s)", firstI1, lastI1);
    }

    @Nonnull
    private static String sumForRowIndex(@NonNull SXSSFRow detailRow, @NonNull Pair<Integer, Integer> index) {
        if (detailRow == null) {
            throw new NullPointerException("detailRow is marked non-null but is null");
        }
        if (index == null) {
            throw new NullPointerException("index is marked non-null but is null");
        }
        String firstI1 = new CellAddress((Cell)detailRow.getCell(((Integer)index.getLeft()).intValue(), Row.MissingCellPolicy.CREATE_NULL_AS_BLANK)).formatAsString();
        String lastI1 = new CellAddress((Cell)detailRow.getCell(((Integer)index.getRight()).intValue(), Row.MissingCellPolicy.CREATE_NULL_AS_BLANK)).formatAsString();
        return String.format("SUM(%s:%s)", firstI1, lastI1);
    }
}

