/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service.xls;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import de.qfm.erp.service.model.internal.message.Translatable;
import de.qfm.erp.service.model.internal.quotation.BillOfQuantitiesMeasurementExport;
import de.qfm.erp.service.model.jpa.measurement.Measurement;
import de.qfm.erp.service.model.jpa.measurement.MeasurementPosition;
import de.qfm.erp.service.model.jpa.measurement.ReleaseOrder;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.service.service.DateTimeHelperService;
import de.qfm.erp.service.service.service.MessageService;
import de.qfm.erp.service.service.service.xls.AbstractXlsExportService;
import de.qfm.erp.service.service.service.xls.BillOfQuantitiesMeasurementXlsSubContractorExportService;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import liquibase.util.StringUtil;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class BillOfQuantitiesMeasurementXlsSubContractorExportService
extends AbstractXlsExportService {
    private static final Logger log = LogManager.getLogger(BillOfQuantitiesMeasurementXlsSubContractorExportService.class);
    private final MessageService messageService;

    @Autowired
    public BillOfQuantitiesMeasurementXlsSubContractorExportService(MessageService messageService) {
        this.messageService = messageService;
    }

    @Nonnull
    public XSSFWorkbook detailXLS(@NonNull XSSFWorkbook workbook, @NonNull String companyName, @NonNull String measurementSheetName, @NonNull String positionSheetName, @NonNull Measurement measurement, @NonNull Stream<BillOfQuantitiesMeasurementExport> billOfQuantitiesMeasurementExportStream) {
        if (workbook == null) {
            throw new NullPointerException("workbook is marked non-null but is null");
        }
        if (companyName == null) {
            throw new NullPointerException("companyName is marked non-null but is null");
        }
        if (measurementSheetName == null) {
            throw new NullPointerException("measurementSheetName is marked non-null but is null");
        }
        if (positionSheetName == null) {
            throw new NullPointerException("positionSheetName is marked non-null but is null");
        }
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        if (billOfQuantitiesMeasurementExportStream == null) {
            throw new NullPointerException("billOfQuantitiesMeasurementExportStream is marked non-null but is null");
        }
        String remarks = measurement.getRemarks();
        ReleaseOrder releaseOrder = measurement.getReleaseOrder();
        String releaseOrderText = null != releaseOrder ? releaseOrder.getName() : "";
        String constructionSite = measurement.getConstructionSite();
        String projectExecutionStartDateTxt = DateTimeHelperService.germanDate((LocalDate)measurement.getProjectExecutionStartDate());
        String projectExecutionEndDateTxt = DateTimeHelperService.germanDate((LocalDate)measurement.getProjectExecutionEndDate());
        User assignedUser = measurement.getAssignedUser();
        String personalNumber = null != assignedUser ? Integer.toString(assignedUser.getPersonalNumber()) : "";
        String fullName = null != assignedUser ? assignedUser.getFullName() : "";
        Quotation stage = measurement.getQuotation();
        String stageNumber = StringUtils.trimToEmpty((String)stage.getQNumber());
        String stageAlias = StringUtils.trimToEmpty((String)stage.getAlias());
        Integer version = stage.getVersion();
        String stageVersionAsString = null != version ? StringUtils.trimToEmpty((String)version.toString()) : "";
        XSSFSheet measurementSheet = workbook.getSheet(measurementSheetName);
        BillOfQuantitiesMeasurementXlsSubContractorExportService.updateText((XSSFSheet)measurementSheet, (String)"A2", (String)companyName);
        BillOfQuantitiesMeasurementXlsSubContractorExportService.updateText((XSSFSheet)measurementSheet, (String)"C5", (String)releaseOrderText);
        BillOfQuantitiesMeasurementXlsSubContractorExportService.updateText((XSSFSheet)measurementSheet, (String)"C6", (String)constructionSite);
        BillOfQuantitiesMeasurementXlsSubContractorExportService.updateText((XSSFSheet)measurementSheet, (String)"C10", (String)projectExecutionStartDateTxt);
        BillOfQuantitiesMeasurementXlsSubContractorExportService.updateText((XSSFSheet)measurementSheet, (String)"G10", (String)projectExecutionEndDateTxt);
        BillOfQuantitiesMeasurementXlsSubContractorExportService.updateText((XSSFSheet)measurementSheet, (String)"R5", (String)personalNumber);
        BillOfQuantitiesMeasurementXlsSubContractorExportService.updateText((XSSFSheet)measurementSheet, (String)"U5", (String)fullName);
        BillOfQuantitiesMeasurementXlsSubContractorExportService.updateText((XSSFSheet)measurementSheet, (String)"R6", (String)stageNumber);
        BillOfQuantitiesMeasurementXlsSubContractorExportService.updateText((XSSFSheet)measurementSheet, (String)"R8", (String)stageAlias);
        BillOfQuantitiesMeasurementXlsSubContractorExportService.updateText((XSSFSheet)measurementSheet, (String)"R9", (String)stageVersionAsString);
        BillOfQuantitiesMeasurementXlsSubContractorExportService.updateText((XSSFSheet)measurementSheet, (String)"C13", (String)remarks);
        List measurementPositions = (List)MoreObjects.firstNonNull((Object)measurement.getMeasurementPositions(), (Object)ImmutableList.of());
        int positionIndex = 19;
        for (MeasurementPosition measurementPosition : measurementPositions) {
            BillOfQuantitiesMeasurementXlsSubContractorExportService.updateText((XSSFSheet)measurementSheet, (String)("A" + positionIndex), (String)measurementPosition.getSurrogatePositionNumber());
            BillOfQuantitiesMeasurementXlsSubContractorExportService.updateBigDecimal((XSSFSheet)measurementSheet, (String)("B" + positionIndex), (BigDecimal)measurementPosition.getAmount());
            BillOfQuantitiesMeasurementXlsSubContractorExportService.updateBigDecimal((XSSFSheet)measurementSheet, (String)("C" + positionIndex), (BigDecimal)measurementPosition.getFactor1());
            BillOfQuantitiesMeasurementXlsSubContractorExportService.updateBigDecimal((XSSFSheet)measurementSheet, (String)("E" + positionIndex), (BigDecimal)measurementPosition.getFactor2());
            BillOfQuantitiesMeasurementXlsSubContractorExportService.updateBigDecimal((XSSFSheet)measurementSheet, (String)("F" + positionIndex), (BigDecimal)measurementPosition.getFactor3());
            BillOfQuantitiesMeasurementXlsSubContractorExportService.updateText((XSSFSheet)measurementSheet, (String)("R" + positionIndex), (String)measurementPosition.getRemarks());
            ++positionIndex;
        }
        XSSFSheet positionSheet = workbook.getSheet(positionSheetName);
        CellAddress cellAddressA1 = new CellAddress("A1");
        XSSFRow rowA1 = positionSheet.getRow(cellAddressA1.getRow());
        BillOfQuantitiesMeasurementXlsSubContractorExportService.updateText((String)stageNumber, (XSSFRow)rowA1, (int)cellAddressA1.getColumn());
        AtomicInteger rowNum = new AtomicInteger(3);
        billOfQuantitiesMeasurementExportStream.forEach(exportItem -> {
            XSSFRow detailRow = positionSheet.getRow(rowNum.getAndIncrement());
            block4: for (BoQColumn boQColumn : BoQColumn.values()) {
                BoQColumnType boQColumnType = boQColumn.getBoQColumnType();
                Object value = boQColumn.getFn().apply(exportItem);
                Object valueToUse = value instanceof Translatable ? this.messageService.getDE((Translatable)value, new Object[0]) : value;
                switch (boQColumnType.ordinal()) {
                    case 1: {
                        BigDecimal bdValue = valueToUse instanceof BigDecimal ? (BigDecimal)valueToUse : BigDecimal.ZERO;
                        BillOfQuantitiesMeasurementXlsSubContractorExportService.updateNumber((BigDecimal)bdValue, (XSSFRow)detailRow, (int)boQColumn.index);
                        continue block4;
                    }
                    case 0: 
                    case 2: {
                        String stringValue = valueToUse instanceof String ? (String)valueToUse : "";
                        BillOfQuantitiesMeasurementXlsSubContractorExportService.updateText((String)stringValue, (XSSFRow)detailRow, (int)boQColumn.index);
                    }
                }
            }
        });
        workbook.setForceFormulaRecalculation(true);
        return workbook;
    }

    private static void updateBigDecimal(@NonNull XSSFSheet sheet, @NonNull String address, @Nullable BigDecimal value) {
        if (sheet == null) {
            throw new NullPointerException("sheet is marked non-null but is null");
        }
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        if (null != value) {
            CellAddress cellAddress = new CellAddress(address);
            XSSFRow row = sheet.getRow(cellAddress.getRow());
            BillOfQuantitiesMeasurementXlsSubContractorExportService.updateNumber((BigDecimal)value, (XSSFRow)row, (int)cellAddress.getColumn());
        }
    }

    private static void updateText(@NonNull XSSFSheet sheet, @NonNull String address, @NonNull String value) {
        if (sheet == null) {
            throw new NullPointerException("sheet is marked non-null but is null");
        }
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        CellAddress cellAddress = new CellAddress(address);
        XSSFRow row = sheet.getRow(cellAddress.getRow());
        BillOfQuantitiesMeasurementXlsSubContractorExportService.updateText((String)value, (XSSFRow)row, (int)cellAddress.getColumn());
    }

    @Nonnull
    private Optional<String> textValue(@NonNull Sheet sheet, @NonNull String cellAddressString) {
        if (sheet == null) {
            throw new NullPointerException("sheet is marked non-null but is null");
        }
        if (cellAddressString == null) {
            throw new NullPointerException("cellAddressString is marked non-null but is null");
        }
        CellAddress cellAddress = new CellAddress(cellAddressString);
        Row row = sheet.getRow(cellAddress.getRow());
        Cell cell = row.getCell(cellAddress.getColumn());
        return BillOfQuantitiesMeasurementXlsSubContractorExportService.textValue((Cell)cell);
    }

    @Nonnull
    protected static Optional<String> textValue(@NonNull Row row, int cellIndex) {
        if (row == null) {
            throw new NullPointerException("row is marked non-null but is null");
        }
        return BillOfQuantitiesMeasurementXlsSubContractorExportService.textValue((Cell)row.getCell(cellIndex));
    }

    @Nonnull
    protected static Optional<String> textValue(@NonNull Cell cell) {
        if (cell == null) {
            throw new NullPointerException("cell is marked non-null but is null");
        }
        switch (1.$SwitchMap$org$apache$poi$ss$usermodel$CellType[cell.getCellType().ordinal()]) {
            case 1: {
                return Optional.of(cell.getStringCellValue());
            }
            case 2: {
                return Optional.of(((XSSFCell)cell).getRawValue());
            }
            case 3: {
                break;
            }
            case 4: {
                CellType cachedFormulaResultType = cell.getCachedFormulaResultType();
                if (cachedFormulaResultType == CellType.ERROR) {
                    byte by = cell.getErrorCellValue();
                    break;
                }
                if (cachedFormulaResultType == CellType.STRING) {
                    return Optional.of(cell.getStringCellValue());
                }
                if (cachedFormulaResultType == CellType.NUMERIC) break;
                log.warn("TODO: {}", (Object)cell.getCellType().name());
                break;
            }
            case 5: {
                log.warn("ERROR Cell: {}", (Object)cell.getErrorCellValue());
                break;
            }
            default: {
                return Optional.of(cell.getStringCellValue());
            }
        }
        return Optional.empty();
    }

    private static String key(@NonNull String input) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        return StringUtil.trimToEmpty((String)StringUtils.lowerCase((String)input));
    }
}

