/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service.xls;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import de.leancoders.common.helper.DateTimeHelper;
import de.qfm.erp.service.model.internal.quotation.BillOfQuantitiesMeasurementExport;
import de.qfm.erp.service.service.service.DateTimeHelperService;
import de.qfm.erp.service.service.service.MessageService;
import de.qfm.erp.service.service.service.xls.AbstractXlsExportService;
import de.qfm.erp.service.service.service.xls.BillOfQuantitiesMeasurementXlsCluster35ExportService;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import liquibase.util.StringUtil;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class BillOfQuantitiesMeasurementXlsCluster35ExportService
extends AbstractXlsExportService {
    private static final Logger log = LogManager.getLogger(BillOfQuantitiesMeasurementXlsCluster35ExportService.class);
    private final MessageService messageService;

    @Autowired
    public BillOfQuantitiesMeasurementXlsCluster35ExportService(MessageService messageService) {
        this.messageService = messageService;
    }

    @Nonnull
    public XSSFWorkbook detailXLS(@NonNull XSSFWorkbook workbook, @NonNull String measurementSheetName, @NonNull String measurementNumber, @NonNull Iterable<BillOfQuantitiesMeasurementExport> billOfQuantitiesMeasurementExports) {
        if (workbook == null) {
            throw new NullPointerException("workbook is marked non-null but is null");
        }
        if (measurementSheetName == null) {
            throw new NullPointerException("measurementSheetName is marked non-null but is null");
        }
        if (measurementNumber == null) {
            throw new NullPointerException("measurementNumber is marked non-null but is null");
        }
        if (billOfQuantitiesMeasurementExports == null) {
            throw new NullPointerException("billOfQuantitiesMeasurementExports is marked non-null but is null");
        }
        XSSFSheet measurementSheet = workbook.getSheet(measurementSheetName);
        CellAddress cellAddressB1 = new CellAddress("B1");
        XSSFRow rowB1 = measurementSheet.getRow(cellAddressB1.getRow());
        BillOfQuantitiesMeasurementXlsCluster35ExportService.updateText((String)measurementNumber, (XSSFRow)rowB1, (int)cellAddressB1.getColumn());
        CellAddress cellAddressB2 = new CellAddress("B2");
        XSSFRow rowB2 = measurementSheet.getRow(cellAddressB2.getRow());
        String todayAsString = DateTimeHelperService.germanDate((LocalDate)DateTimeHelper.today());
        BillOfQuantitiesMeasurementXlsCluster35ExportService.updateText((String)todayAsString, (XSSFRow)rowB2, (int)cellAddressB2.getColumn());
        LinkedHashMap rowMappingBuilder = Maps.newLinkedHashMap();
        for (int i = 10; i < 200; ++i) {
            String value;
            Optional valueCandidate;
            XSSFCell cell;
            XSSFRow detailRow = measurementSheet.getRow(i);
            if (null == detailRow || null == (cell = detailRow.getCell(0)) || !(valueCandidate = BillOfQuantitiesMeasurementXlsCluster35ExportService.textValue((Row)detailRow, (int)BoQColumn.POSITION_NUMBER.columnIndex())).isPresent() || !StringUtils.isNotBlank((CharSequence)(value = (String)valueCandidate.get()))) continue;
            String key = BillOfQuantitiesMeasurementXlsCluster35ExportService.key((String)value);
            rowMappingBuilder.put(key, detailRow);
        }
        ImmutableMap rowMapping = ImmutableMap.copyOf((Map)rowMappingBuilder);
        ImmutableListMultimap positionsBySPN = Multimaps.index(billOfQuantitiesMeasurementExports, BillOfQuantitiesMeasurementExport::getSurrogatePositionNumber);
        ImmutableSet spns = positionsBySPN.keySet();
        for (String spn : spns) {
            ImmutableList billOfQuantitiesMeasurementExportsForSPN = positionsBySPN.get((Object)spn);
            String key = BillOfQuantitiesMeasurementXlsCluster35ExportService.key((String)spn);
            BigDecimal productSum = billOfQuantitiesMeasurementExportsForSPN.stream().map(BillOfQuantitiesMeasurementExport::getProduct).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            XSSFRow cells = (XSSFRow)rowMapping.get((Object)key);
            if (null == cells) continue;
            BillOfQuantitiesMeasurementXlsCluster35ExportService.updateNumber((BigDecimal)productSum, (XSSFRow)cells, (int)BoQColumn.AMOUNT.columnIndex());
        }
        workbook.setForceFormulaRecalculation(true);
        return workbook;
    }

    @Nonnull
    private Optional<String> textValue(@NonNull Sheet sheet, @NonNull String cellAddressString) {
        if (sheet == null) {
            throw new NullPointerException("sheet is marked non-null but is null");
        }
        if (cellAddressString == null) {
            throw new NullPointerException("cellAddressString is marked non-null but is null");
        }
        CellAddress cellAddress = new CellAddress(cellAddressString);
        Row row = sheet.getRow(cellAddress.getRow());
        Cell cell = row.getCell(cellAddress.getColumn());
        return BillOfQuantitiesMeasurementXlsCluster35ExportService.textValue((Cell)cell);
    }

    @Nonnull
    protected static Optional<String> textValue(@NonNull Row row, int cellIndex) {
        if (row == null) {
            throw new NullPointerException("row is marked non-null but is null");
        }
        return BillOfQuantitiesMeasurementXlsCluster35ExportService.textValue((Cell)row.getCell(cellIndex));
    }

    @Nonnull
    protected static Optional<String> textValue(@NonNull Cell cell) {
        if (cell == null) {
            throw new NullPointerException("cell is marked non-null but is null");
        }
        switch (1.$SwitchMap$org$apache$poi$ss$usermodel$CellType[cell.getCellType().ordinal()]) {
            case 1: {
                return Optional.of(cell.getStringCellValue());
            }
            case 2: {
                return Optional.of(((XSSFCell)cell).getRawValue());
            }
            case 3: {
                break;
            }
            case 4: {
                CellType cachedFormulaResultType = cell.getCachedFormulaResultType();
                if (cachedFormulaResultType == CellType.ERROR) {
                    byte by = cell.getErrorCellValue();
                    break;
                }
                if (cachedFormulaResultType == CellType.STRING) {
                    return Optional.of(cell.getStringCellValue());
                }
                if (cachedFormulaResultType == CellType.NUMERIC) break;
                log.warn("TODO: {}", (Object)cell.getCellType().name());
                break;
            }
            case 5: {
                log.warn("ERROR Cell: {}", (Object)cell.getErrorCellValue());
                break;
            }
            default: {
                return Optional.of(cell.getStringCellValue());
            }
        }
        return Optional.empty();
    }

    private static String key(@NonNull String input) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        return StringUtil.trimToEmpty((String)StringUtils.lowerCase((String)input));
    }
}

