/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service.print;

import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import de.qfm.erp.service.configuration.PrintLayoutConfig;
import de.qfm.erp.service.model.internal.print.CompanyPrintInfo;
import de.qfm.erp.service.model.internal.print.EPrintFontSize;
import de.qfm.erp.service.model.internal.print.PrintConfiguration;
import de.qfm.erp.service.model.internal.print.PrintFonts;
import de.qfm.erp.service.model.internal.print.PrintInfo;
import de.qfm.erp.service.model.internal.print.PrintSetup;
import de.qfm.erp.service.model.internal.print.UserPrintInfo;
import de.qfm.erp.service.model.internal.print.qentity.EStagePrintFeature;
import de.qfm.erp.service.model.internal.print.qentity.QStagePositionPrintGroup;
import de.qfm.erp.service.model.internal.print.qentity.QStagePositionPrintRow;
import de.qfm.erp.service.model.internal.print.qentity.QStagePrintConfiguration;
import de.qfm.erp.service.model.internal.print.qentity.QStagePrintInfo;
import de.qfm.erp.service.model.jpa.configuration.ConfigurationCompany;
import de.qfm.erp.service.model.jpa.quotation.EStagePrintBoilerPlate;
import de.qfm.erp.service.model.jpa.shared.EAlternativePositionType;
import de.qfm.erp.service.model.jpa.shared.EPositionType;
import de.qfm.erp.service.service.route.impl.PrintHelper;
import de.qfm.erp.service.service.security.UserService;
import de.qfm.erp.service.service.service.DateTimeHelperService;
import de.qfm.erp.service.service.service.MessageService;
import de.qfm.erp.service.service.service.print.AbstractPrintService;
import de.qfm.erp.service.service.service.print.QStageQuotationPrintService;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.vandeseer.easytable.TableDrawer;
import org.vandeseer.easytable.settings.HorizontalAlignment;
import org.vandeseer.easytable.settings.VerticalAlignment;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.ImageCell;
import org.vandeseer.easytable.structure.cell.TextCell;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class QStageQuotationPrintService
extends AbstractPrintService<QStagePrintInfo, QStagePrintConfiguration> {
    private static final Logger log = LogManager.getLogger(QStageQuotationPrintService.class);
    public static final Splitter LONG_TEXT_SPLITTER = Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)System.lineSeparator())).trimResults();
    protected static final float MM_PER_UNIT = 2.83f;
    protected static final float STAGE_MARGIN_TOP_BOTTOM = 48.11f;
    protected static final float STAGE_MARGIN_LEFT_RIGHT = 67.92f;
    protected static final float FOOTER_MARGIN_LEFT_RIGHT = 70.75f;
    protected static final float LOGO_HEADER_DISTANCE = 36.79f;
    protected static final float HEADER_TEXT_SPACE = 2.83f;
    protected static final Color TEXT_COLOR = Color.BLACK;
    protected static final int SENDER_FONT_SIZE = 7;
    protected static final int RECIPIENT_FONT_SIZE = 10;
    protected static final int META_FONT_SIZE = 8;
    protected static final int COVER_LETTER_FONT_SIZE = 10;
    protected static final Iterable<Integer> GROUP_SUMS_TO_PRINT_LEVELS = ImmutableSet.of((Object)0, (Object)1);
    private static final Set<String> AUTHORITY_TO_SIGN_HIDE = ImmutableSet.of((Object)"GF");
    private final MessageService messageService;
    private final PrintLayoutConfig printLayoutConfig;

    @Autowired
    public QStageQuotationPrintService(UserService userService, MessageService messageService, DateTimeHelperService dateTimeHelperService, PrintHelper printHelper, PrintLayoutConfig printLayoutConfig) {
        super(userService, dateTimeHelperService, printHelper);
        this.messageService = messageService;
        this.printLayoutConfig = printLayoutConfig;
    }

    protected static float maxWidth(@NonNull PDRectangle mediaBox) {
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        return mediaBox.getWidth() - 135.84f;
    }

    protected static float footerMaxWidth(@NonNull PDRectangle mediaBox) {
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        return mediaBox.getWidth() - 141.5f;
    }

    protected static float printHeader(@Nonnull PDPageContentStream contentStream, @Nonnull PDPage page, @Nonnull Iterable<Table> headers) {
        PDRectangle mediaBox = page.getMediaBox();
        float yOffset = mediaBox.getHeight() - 48.11f;
        for (Table header : headers) {
            TableDrawer.builder().page(page).contentStream(contentStream).startX(67.92f).startY(yOffset).table(header).build().draw();
            yOffset -= header.getHeight();
        }
        return yOffset;
    }

    @Nonnull
    protected static TextCell footerCell(@NonNull PrintFonts printFonts, int fontSize, @NonNull Color textColor, @Nullable String text) {
        if (printFonts == null) {
            throw new NullPointerException("printFonts is marked non-null but is null");
        }
        if (textColor == null) {
            throw new NullPointerException("textColor is marked non-null but is null");
        }
        return QStageQuotationPrintService.footerCell((PDFont)printFonts.getRegular(), (int)fontSize, (Color)textColor, (String)text);
    }

    @Nonnull
    protected static TextCell footerCell(@NonNull PDFont font, int fontSize, @NonNull Color textColor, @Nullable String text) {
        if (font == null) {
            throw new NullPointerException("font is marked non-null but is null");
        }
        if (textColor == null) {
            throw new NullPointerException("textColor is marked non-null but is null");
        }
        String validText = QStageQuotationPrintService.validText((String)text);
        return ((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().font(font)).fontSize(Integer.valueOf(fontSize))).colSpan(1)).rowSpan(1)).padding(0.0f)).horizontalAlignment(HorizontalAlignment.LEFT)).text(validText).textColor(textColor)).lineSpacing(0.5f)).borderWidthTop(0.0f)).borderWidthLeft(0.0f)).borderWidthRight(0.0f)).borderWidthBottom(0.0f)).build();
    }

    protected static float maxDetailsHeight(PDRectangle mediaBox, float headerHeight, float footerHeight, float optionalNeededSpace, float marginTop, float marginBottom) {
        return mediaBox.getHeight() - (marginTop + marginBottom + headerHeight + 10.0f + footerHeight + optionalNeededSpace);
    }

    public byte[] generatePDF(@NonNull QStagePrintInfo printInfo, @NonNull QStagePrintConfiguration printConfiguration, @NonNull EPrintFontSize printFontSize, @NonNull ConfigurationCompany configurationCompany) {
        byte[] byArray;
        block23: {
            if (printInfo == null) {
                throw new NullPointerException("printInfo is marked non-null but is null");
            }
            if (printConfiguration == null) {
                throw new NullPointerException("printConfiguration is marked non-null but is null");
            }
            if (printFontSize == null) {
                throw new NullPointerException("printFontSize is marked non-null but is null");
            }
            if (configurationCompany == null) {
                throw new NullPointerException("configurationCompany is marked non-null but is null");
            }
            PDRectangle mediaBox = new PDRectangle(PDRectangle.A4.getWidth(), PDRectangle.A4.getHeight());
            Iterable responsiblePrintInfos = printInfo.getResponsiblePrintInfos();
            String responsibleUsersFullName = this.concat(responsiblePrintInfos, UserPrintInfo::getFullName);
            PDDocument document = this.document((PrintInfo)printInfo, (PrintConfiguration)printConfiguration, responsibleUsersFullName);
            try {
                PrintSetup printSetup = PrintHelper.printSetup((PrintLayoutConfig)this.printLayoutConfig, (ConfigurationCompany)configurationCompany, (EPrintFontSize)printFontSize, (PDDocument)document, PrintLayoutConfig::getStageLogoPadding, PrintLayoutConfig::getStageLogoHeight, PrintLayoutConfig::getStageLogoFileBuffer);
                PDImageXObject pdImageXObject = PDImageXObject.createFromByteArray((PDDocument)document, (byte[])printSetup.getLogoBuffer(), (String)"");
                Table footer = this.legalCompanyFooter(mediaBox, printSetup);
                Table blankHeaderP1 = this.headersP1(printInfo, pdImageXObject, mediaBox, printSetup, 0, 0);
                Table blankHeaderP2 = this.headersP2(printInfo, pdImageXObject, mediaBox, printSetup, 0, 0);
                float heightHeader0 = blankHeaderP1.getHeight();
                float heightHeader1 = blankHeaderP2.getHeight();
                float maxDetailsHeightFirstPage = QStageQuotationPrintService.maxDetailsHeight((PDRectangle)mediaBox, (float)heightHeader0, (float)footer.getHeight(), (float)10.0f, (float)48.11f, (float)48.11f);
                float maxDetailsHeightRest = QStageQuotationPrintService.maxDetailsHeight((PDRectangle)mediaBox, (float)heightHeader1, (float)0.0f, (float)10.0f, (float)48.11f, (float)48.11f);
                Table coverSheet = this.coverSheet(printInfo, mediaBox, printSetup);
                Table details = this.details(printInfo, mediaBox, printSetup);
                Table discounts = this.discounts(printInfo, mediaBox, printSetup);
                Table summarization = this.summarization(printInfo, mediaBox, printSetup);
                Table signatures = this.signatures(printInfo, mediaBox, printSetup);
                Table subTotals = this.subTotals(printInfo, mediaBox, printSetup);
                Iterable additionalTables = (Iterable)MoreObjects.firstNonNull((Object)printInfo.getAdditionalTables(), (Object)ImmutableSet.of());
                ImmutableList.Builder allTablesBuilder = ImmutableList.builder();
                allTablesBuilder.add((Object)AbstractPrintService.PrintPlanInput.of((String)"coverSheet", (Table)coverSheet, (boolean)false, (int)0, (float)0.0f));
                allTablesBuilder.add((Object)AbstractPrintService.PrintPlanInput.of((String)"signatures", (Table)signatures, (boolean)false, (int)0, (float)10.0f));
                allTablesBuilder.add((Object)AbstractPrintService.PrintPlanInput.of((String)"details", (Table)details, (boolean)true, (int)3, (float)0.0f));
                allTablesBuilder.add((Object)AbstractPrintService.PrintPlanInput.of((String)"discounts", (Table)discounts, (boolean)false, (int)0, (float)0.0f));
                allTablesBuilder.add((Object)AbstractPrintService.PrintPlanInput.of((String)"summarization", (Table)summarization, (boolean)false, (int)0, (float)10.0f));
                allTablesBuilder.add((Object)AbstractPrintService.PrintPlanInput.of((String)"subTotals", (Table)subTotals, (boolean)false, (int)0, (float)10.0f));
                additionalTables.forEach(table -> allTablesBuilder.add((Object)AbstractPrintService.PrintPlanInput.of((String)"additional tables", (Table)table, (boolean)false, (int)0, (float)10.0f)));
                ImmutableList allTables = allTablesBuilder.build();
                Multimap printPlan = QStageQuotationPrintService.printPlan((Iterable)allTables, (float)maxDetailsHeightFirstPage, (float)maxDetailsHeightRest);
                if (details.getRows().isEmpty()) {
                    QStageQuotationPrintService.printEmptyPage((PDDocument)document, (PDRectangle)mediaBox, (List)ImmutableList.of());
                } else {
                    TreeSet pages = Sets.newTreeSet((Iterable)printPlan.keySet());
                    int pageCount = pages.size();
                    for (Integer pageNumber : pages) {
                        ImmutableList headers;
                        if (pageNumber == 0) {
                            Table headersP1 = this.headersP1(printInfo, pdImageXObject, mediaBox, printSetup, 1 + pageNumber, pageCount);
                            headers = ImmutableList.of((Object)headersP1);
                        } else {
                            Table headersP2 = this.headersP2(printInfo, pdImageXObject, mediaBox, printSetup, 1 + pageNumber, pageCount);
                            headers = ImmutableList.of((Object)headersP2);
                        }
                        PDPage pdPage = QStageQuotationPrintService.page((PDDocument)document, (PDRectangle)mediaBox);
                        Collection printPlanOutputs = printPlan.get((Object)pageNumber);
                        try (PDPageContentStream contentStream = new PDPageContentStream(document, pdPage);){
                            float yOffset = QStageQuotationPrintService.printHeader((PDPageContentStream)contentStream, (PDPage)pdPage, (Iterable)headers);
                            for (AbstractPrintService.PrintPlanOutput printPlanOutput : printPlanOutputs) {
                                Table table2 = printPlanOutput.getTable();
                                float marginAfterTable = printPlanOutput.getMarginAfterTable();
                                TableDrawer.builder().page(pdPage).contentStream(contentStream).startX(67.92f).startY(yOffset -= marginAfterTable).table(table2).build().draw();
                                yOffset -= table2.getHeight();
                            }
                            if (pageNumber != 0) continue;
                            yOffset -= this.printFooter(contentStream, pdPage, footer);
                        }
                    }
                }
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                document.save((OutputStream)outputStream);
                byArray = outputStream.toByteArray();
                if (document == null) break block23;
            }
            catch (Throwable throwable) {
                try {
                    if (document != null) {
                        try {
                            document.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return new byte[0];
                }
            }
            document.close();
        }
        return byArray;
    }

    @Nonnull
    private String concat(@NonNull Iterable<UserPrintInfo> userPrintInfos, Function<UserPrintInfo, String> fn) {
        if (userPrintInfos == null) {
            throw new NullPointerException("userPrintInfos is marked non-null but is null");
        }
        return Streams.stream(userPrintInfos).filter(Objects::nonNull).map(fn).filter(Objects::nonNull).collect(Collectors.joining(", "));
    }

    @Nonnull
    public PDDocumentInformation apply(@NonNull PDDocumentInformation documentInformation, @NonNull QStagePrintInfo printInfo, @NonNull QStagePrintConfiguration printConfiguration) {
        if (documentInformation == null) {
            throw new NullPointerException("documentInformation is marked non-null but is null");
        }
        if (printInfo == null) {
            throw new NullPointerException("printInfo is marked non-null but is null");
        }
        if (printConfiguration == null) {
            throw new NullPointerException("printConfiguration is marked non-null but is null");
        }
        documentInformation.setKeywords("TODO");
        documentInformation.setTitle(String.format("QUOTATION: %s", UUID.randomUUID()));
        documentInformation.setSubject(String.format("EMPLOYEE: %s", UUID.randomUUID()));
        return documentInformation;
    }

    @Nonnull
    private Table headersP1(@NonNull QStagePrintInfo printInfo, @NonNull PDImageXObject pdImageXObject, @NonNull PDRectangle mediaBox, @NonNull PrintSetup printSetup, int page, int pageCount) throws IOException {
        String procurementNumber;
        if (printInfo == null) {
            throw new NullPointerException("printInfo is marked non-null but is null");
        }
        if (pdImageXObject == null) {
            throw new NullPointerException("pdImageXObject is marked non-null but is null");
        }
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        PrintFonts printFonts = printSetup.getPrintFonts();
        CompanyPrintInfo senderPrintInfo = printInfo.getSenderPrintInfo();
        CompanyPrintInfo recipientPrintInfo = printInfo.getRecipientPrintInfo();
        PDFont fontRegular = printFonts.getRegular();
        PDFont fontBold = printFonts.getBold();
        float header1Width = printSetup.getHeaderColumn1Width().floatValue();
        float header2Width = printSetup.getHeaderColumn2Width().floatValue();
        float header3Width = printSetup.getHeaderColumn3Width().floatValue();
        float header4Width = printSetup.getHeaderColumn4Width().floatValue();
        ImmutableList columnWidths = ImmutableList.of((Object)Float.valueOf(header1Width), (Object)Float.valueOf(header2Width), (Object)Float.valueOf(header3Width), (Object)Float.valueOf(header4Width));
        int columnCount = columnWidths.size();
        Table.TableBuilder header1Builder = QStageQuotationPrintService.table((Float)Float.valueOf(QStageQuotationPrintService.maxWidth((PDRectangle)mediaBox)), (Iterable)columnWidths);
        header1Builder.addRow(Row.builder().add((AbstractCell)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)ImageCell.builder().horizontalAlignment(HorizontalAlignment.LEFT)).padding(0.0f)).paddingLeft(printSetup.getLogoPaddingLeft())).verticalAlignment(VerticalAlignment.MIDDLE)).image(pdImageXObject).maxHeight((float)printSetup.getLogoHeight()).borderWidth(0.0f)).colSpan(2)).build()).add((AbstractCell)QStageQuotationPrintService.emptyCell((int)8, (int)2)).build());
        header1Builder.addRow(Row.builder().fontSize(Integer.valueOf(1)).height(Float.valueOf(36.79f)).add((AbstractCell)QStageQuotationPrintService.emptyCell((int)1, (int)columnCount)).build());
        String senderRow1Left = StringUtils.trimToEmpty((String)Joiner.on((String)" ").skipNulls().join((Object)StringUtils.trimToEmpty((String)senderPrintInfo.getCustomerName1()), (Object)StringUtils.trimToEmpty((String)senderPrintInfo.getCustomerName2()), new Object[0]));
        String senderRow2Left = StringUtils.trimToEmpty((String)Joiner.on((String)" ").skipNulls().join((Object)StringUtils.trimToEmpty((String)senderPrintInfo.getCustomerStreet()), (Object)StringUtils.trimToEmpty((String)senderPrintInfo.getCustomerStreetNo()), new Object[0]));
        String senderRow2Right = StringUtils.trimToEmpty((String)Joiner.on((String)" ").skipNulls().join((Object)StringUtils.trimToEmpty((String)senderPrintInfo.getCustomerZipCode()), (Object)StringUtils.trimToEmpty((String)senderPrintInfo.getCustomerCity()), new Object[0]));
        String senderRow2 = String.format("%s | %s", senderRow2Left, senderRow2Right);
        String recipientOriginalRow1 = StringUtils.trimToEmpty((String)recipientPrintInfo.getCustomerName1());
        String recipientOriginalRow2 = StringUtils.trimToEmpty((String)recipientPrintInfo.getCustomerName2());
        String recipientOriginalRow3 = StringUtils.trimToEmpty((String)recipientPrintInfo.getCustomerName3());
        String recipientOriginalRow4 = StringUtils.trimToEmpty((String)Joiner.on((String)" ").skipNulls().join((Object)StringUtils.trimToEmpty((String)recipientPrintInfo.getCustomerStreet()), (Object)StringUtils.trimToEmpty((String)recipientPrintInfo.getCustomerStreetNo()), new Object[0]));
        String recipientOriginalRow5 = StringUtils.trimToEmpty((String)Joiner.on((String)" ").skipNulls().join((Object)StringUtils.trimToEmpty((String)recipientPrintInfo.getCustomerZipCode()), (Object)StringUtils.trimToEmpty((String)recipientPrintInfo.getCustomerCity()), new Object[0]));
        String recipientRefRow1 = "";
        String recipientRefRow2 = "";
        String recipientRefRow3 = "";
        String recipientRefRow4 = "";
        String recipientRefRow5 = "";
        header1Builder.addRow(Row.builder().add((AbstractCell)QStageQuotationPrintService.descriptionCell((int)7, (PDFont)fontRegular, (Color)TEXT_COLOR, (int)2, (int)2, (String)(senderRow1Left + "\n" + senderRow2))).add((AbstractCell)QStageQuotationPrintService.descriptionCell((int)8, (PDFont)fontBold, (Color)TEXT_COLOR, (String)"Datum")).add((AbstractCell)QStageQuotationPrintService.emptyCell((int)8)).build());
        String pageString = this.messageService.get(EStagePrintBoilerPlate.GENERIC__PAGE);
        String referenceDateString = DateTimeHelperService.germanFullDate((LocalDate)printInfo.getSubmissionOfBidDate());
        String dateAndPage = String.format("%s | %s %s/%s", referenceDateString, pageString, page, pageCount);
        header1Builder.addRow(Row.builder().add((AbstractCell)QStageQuotationPrintService.descriptionCell((PDFont)fontRegular, (int)8, (String)dateAndPage, (int)2, (int)1, (Color)TEXT_COLOR, (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)ImmutableMap.of())).build());
        header1Builder.addRow(Row.builder().fontSize(Integer.valueOf(1)).height(Float.valueOf(2.83f)).add((AbstractCell)QStageQuotationPrintService.emptyCell((int)1, (int)columnCount)).build());
        String yourReferenceLabel = this.messageService.get(EStagePrintBoilerPlate.STAGE__YOUR_REFERENCE_LABEL);
        header1Builder.addRow(Row.builder().add((AbstractCell)QStageQuotationPrintService.descriptionCell((int)10, (PDFont)fontRegular, (Color)TEXT_COLOR, (String)recipientOriginalRow1)).add((AbstractCell)QStageQuotationPrintService.descriptionCell((int)10, (PDFont)fontRegular, (Color)TEXT_COLOR, (String)"")).add((AbstractCell)QStageQuotationPrintService.descriptionCell((int)8, (PDFont)fontBold, (Color)TEXT_COLOR, (int)2, (VerticalAlignment)VerticalAlignment.BOTTOM, (String)yourReferenceLabel)).build());
        header1Builder.addRow(Row.builder().add((AbstractCell)QStageQuotationPrintService.descriptionCell((int)10, (PDFont)fontRegular, (Color)TEXT_COLOR, (String)recipientOriginalRow2)).add((AbstractCell)QStageQuotationPrintService.descriptionCell((int)10, (PDFont)fontRegular, (Color)TEXT_COLOR, (String)"")).add((AbstractCell)QStageQuotationPrintService.descriptionCell((int)8, (PDFont)fontRegular, (Color)TEXT_COLOR, (int)2, (String)printInfo.getStageNumber())).build());
        if (StringUtils.isNotBlank((CharSequence)recipientOriginalRow3) || StringUtils.isNotBlank((CharSequence)"")) {
            header1Builder.addRow(Row.builder().add((AbstractCell)QStageQuotationPrintService.descriptionCell((int)10, (PDFont)fontRegular, (Color)TEXT_COLOR, (String)recipientOriginalRow3)).add((AbstractCell)QStageQuotationPrintService.descriptionCell((int)10, (PDFont)fontRegular, (Color)TEXT_COLOR, (String)"")).add((AbstractCell)QStageQuotationPrintService.emptyCell((int)10, (int)2)).build());
        }
        String procurementNumberLabel = StringUtils.isNotBlank((CharSequence)(procurementNumber = printInfo.getProcurementNumber())) ? this.messageService.get(EStagePrintBoilerPlate.STAGE__PROCUREMENT_NUMBER_LABEL) : "";
        header1Builder.addRow(Row.builder().add((AbstractCell)QStageQuotationPrintService.descriptionCell((int)10, (PDFont)fontRegular, (Color)TEXT_COLOR, (String)recipientOriginalRow4)).add((AbstractCell)QStageQuotationPrintService.descriptionCell((int)10, (PDFont)fontRegular, (Color)TEXT_COLOR, (String)"")).add((AbstractCell)QStageQuotationPrintService.descriptionCell((int)8, (PDFont)fontBold, (Color)TEXT_COLOR, (int)2, (String)procurementNumberLabel)).build());
        header1Builder.addRow(Row.builder().add((AbstractCell)QStageQuotationPrintService.descriptionCell((int)10, (PDFont)fontRegular, (Color)TEXT_COLOR, (String)recipientOriginalRow5)).add((AbstractCell)QStageQuotationPrintService.descriptionCell((int)10, (PDFont)fontRegular, (Color)TEXT_COLOR, (String)"")).add((AbstractCell)QStageQuotationPrintService.descriptionCell((int)8, (PDFont)fontRegular, (Color)TEXT_COLOR, (int)2, (String)procurementNumber)).build());
        Iterable responsiblePrintInfos = printInfo.getResponsiblePrintInfos();
        Optional<UserPrintInfo> responsibleUserPrintInfo = Streams.stream((Iterable)responsiblePrintInfos).findFirst();
        String fullName = responsibleUserPrintInfo.map(UserPrintInfo::getFullName).orElse("");
        String phone = responsibleUserPrintInfo.map(UserPrintInfo::getPhone).orElse("");
        String cellular = responsibleUserPrintInfo.map(UserPrintInfo::getCellular).orElse("");
        String mail = responsibleUserPrintInfo.map(UserPrintInfo::getEmail).orElse("");
        this.headerP1Right(EStagePrintBoilerPlate.STAGE__RESPONSIBLE_USER_FULL_NAME_LABEL, fullName, printFonts).forEach(arg_0 -> ((Table.TableBuilder)header1Builder).addRow(arg_0));
        this.headerP1Right(EStagePrintBoilerPlate.STAGE__PHONE_LABEL, phone, printFonts).forEach(arg_0 -> ((Table.TableBuilder)header1Builder).addRow(arg_0));
        this.headerP1Right(EStagePrintBoilerPlate.STAGE__CELLULAR_LABEL, cellular, printFonts).forEach(arg_0 -> ((Table.TableBuilder)header1Builder).addRow(arg_0));
        this.headerP1Right(EStagePrintBoilerPlate.STAGE__EMAIL_LABEL, mail, printFonts).forEach(arg_0 -> ((Table.TableBuilder)header1Builder).addRow(arg_0));
        for (int i = 0; i < 3; ++i) {
            header1Builder.addRow(Row.builder().add((AbstractCell)QStageQuotationPrintService.emptyCell((int)8, (int)columnCount)).build());
        }
        return header1Builder.build();
    }

    @Nonnull
    private Iterable<Row> headerP1Right(@NonNull EStagePrintBoilerPlate label, @NonNull String value, @NonNull PrintFonts printFonts) {
        if (label == null) {
            throw new NullPointerException("label is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (printFonts == null) {
            throw new NullPointerException("printFonts is marked non-null but is null");
        }
        if (StringUtils.isNotBlank((CharSequence)value)) {
            String labelTxt = StringUtils.isNotBlank((CharSequence)value) ? this.messageService.get(label) : "";
            PDFont fontBold = printFonts.getBold();
            PDFont fontRegular = printFonts.getRegular();
            return ImmutableList.of((Object)Row.builder().add((AbstractCell)QStageQuotationPrintService.emptyCell((int)8, (int)2)).add((AbstractCell)QStageQuotationPrintService.descriptionCell((int)8, (PDFont)fontBold, (Color)TEXT_COLOR, (int)2, (String)labelTxt)).build(), (Object)Row.builder().add((AbstractCell)QStageQuotationPrintService.emptyCell((int)8, (int)2)).add((AbstractCell)QStageQuotationPrintService.descriptionCell((int)8, (PDFont)fontRegular, (Color)TEXT_COLOR, (int)2, (String)value)).build());
        }
        return ImmutableList.of();
    }

    @Nonnull
    private Iterable<Row> paymentConditions(@NonNull QStagePrintInfo printInfo, @NonNull PrintFonts printFonts, int columnCount) {
        if (printInfo == null) {
            throw new NullPointerException("printInfo is marked non-null but is null");
        }
        if (printFonts == null) {
            throw new NullPointerException("printFonts is marked non-null but is null");
        }
        ImmutableList.Builder rowBuilder = ImmutableList.builder();
        Iterable stagePrintFeatures = printInfo.getStagePrintFeatures();
        if (Iterables.contains((Iterable)stagePrintFeatures, (Object)EStagePrintFeature.OPTION_QUOTATION_PRINT_PAYMENT_CONDITIONS)) {
            Integer financeTimeForPayment = printInfo.getFinanceTimeForPayment();
            Integer financeCashDiscountTime1 = printInfo.getFinanceCashDiscountTime1();
            BigDecimal financeCashDiscount1 = printInfo.getFinanceCashDiscount1();
            Integer financeCashDiscountTime2 = printInfo.getFinanceCashDiscountTime2();
            BigDecimal financeCashDiscount2 = printInfo.getFinanceCashDiscount2();
            String paymentConditionsR1 = this.paymentConditions(financeTimeForPayment);
            String paymentConditionsR2 = this.cashDiscount(financeCashDiscountTime1, financeCashDiscount1);
            String paymentConditionsR3 = this.cashDiscount(financeCashDiscountTime2, financeCashDiscount2);
            if (StringUtils.isNotBlank((CharSequence)paymentConditionsR1) || StringUtils.isNotBlank((CharSequence)paymentConditionsR2) || StringUtils.isNotBlank((CharSequence)paymentConditionsR3)) {
                rowBuilder.add((Object)Row.builder().add((AbstractCell)QStageQuotationPrintService.descriptionCell((int)10, (PDFont)printFonts.getBold(), (Color)TEXT_COLOR, (int)columnCount, (String)this.messageService.get(EStagePrintBoilerPlate.STAGE__PAYMENT_CONDITIONS_LABEL))).build());
                if (StringUtils.isNotBlank((CharSequence)paymentConditionsR1)) {
                    rowBuilder.add((Object)Row.builder().add((AbstractCell)QStageQuotationPrintService.descriptionCell((int)10, (PrintFonts)printFonts, (Color)TEXT_COLOR, (int)columnCount, (String)paymentConditionsR1)).build());
                }
                if (StringUtils.isNotBlank((CharSequence)paymentConditionsR2)) {
                    rowBuilder.add((Object)Row.builder().add((AbstractCell)QStageQuotationPrintService.descriptionCell((int)10, (PrintFonts)printFonts, (Color)TEXT_COLOR, (int)columnCount, (String)paymentConditionsR2)).build());
                }
                if (StringUtils.isNotBlank((CharSequence)paymentConditionsR3)) {
                    rowBuilder.add((Object)Row.builder().add((AbstractCell)QStageQuotationPrintService.descriptionCell((int)10, (PrintFonts)printFonts, (Color)TEXT_COLOR, (int)columnCount, (String)paymentConditionsR3)).build());
                }
            }
        }
        return rowBuilder.build();
    }

    @Nonnull
    private String paymentConditions(@NonNull Integer financeTimeForPayment) {
        if (financeTimeForPayment == null) {
            throw new NullPointerException("financeTimeForPayment is marked non-null but is null");
        }
        String label = this.messageService.get(EStagePrintBoilerPlate.STAGE__N_DAYS_WITHOUT_DISCOUNT);
        return 0 != financeTimeForPayment ? String.format("%s %s", financeTimeForPayment, label) : "";
    }

    @Nonnull
    private String cashDiscount(@Nullable Integer financeCashDiscountTime, @Nullable BigDecimal financeCashDiscount) {
        if (null != financeCashDiscountTime && null != financeCashDiscount && financeCashDiscount.compareTo(BigDecimal.ZERO) != 0) {
            String discountAsString = PrintHelper.asString((BigDecimal)financeCashDiscount, (String)"0,00", (boolean)true);
            return String.format("%s Tage %s %%", financeCashDiscountTime, discountAsString);
        }
        return "";
    }

    @Nonnull
    private Table headersP2(@NonNull QStagePrintInfo printInfo, @NonNull PDImageXObject pdImageXObject, @NonNull PDRectangle mediaBox, @NonNull PrintSetup printSetup, int page, int pageCount) throws IOException {
        if (printInfo == null) {
            throw new NullPointerException("printInfo is marked non-null but is null");
        }
        if (pdImageXObject == null) {
            throw new NullPointerException("pdImageXObject is marked non-null but is null");
        }
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        PrintFonts printFonts = printSetup.getPrintFonts();
        PDFont fontRegular = printFonts.getRegular();
        PDFont fontBold = printFonts.getBold();
        Table.TableBuilder header1Builder = QStageQuotationPrintService.table((Float)Float.valueOf(QStageQuotationPrintService.maxWidth((PDRectangle)mediaBox)), (Iterable)ImmutableList.of((Object)Float.valueOf(0.67f), (Object)Float.valueOf(0.17f), (Object)Float.valueOf(0.16f)));
        header1Builder.addRow(Row.builder().add((AbstractCell)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)ImageCell.builder().horizontalAlignment(HorizontalAlignment.LEFT)).padding(0.0f)).paddingLeft(printSetup.getLogoPaddingLeft())).verticalAlignment(VerticalAlignment.MIDDLE)).image(pdImageXObject).maxHeight((float)printSetup.getLogoHeight()).borderWidth(0.0f)).build()).add((AbstractCell)QStageQuotationPrintService.emptyCell((int)8, (int)2)).build());
        header1Builder.addRow(Row.builder().fontSize(Integer.valueOf(1)).height(Float.valueOf(36.79f)).add((AbstractCell)QStageQuotationPrintService.emptyCell((int)1, (int)3)).build());
        header1Builder.addRow(Row.builder().add((AbstractCell)QStageQuotationPrintService.emptyCell((int)8)).add((AbstractCell)QStageQuotationPrintService.descriptionCell((int)8, (PDFont)fontBold, (Color)TEXT_COLOR, (int)2, (String)this.messageService.get(EStagePrintBoilerPlate.GENERIC__DATE))).build());
        String pageString = this.messageService.get(EStagePrintBoilerPlate.GENERIC__PAGE);
        String referenceDateString = DateTimeHelperService.germanFullDate((LocalDate)printInfo.getSubmissionOfBidDate());
        String dateAndPage = String.format("%s | %s %s/%s", referenceDateString, pageString, page, pageCount);
        header1Builder.addRow(Row.builder().add((AbstractCell)QStageQuotationPrintService.emptyCell((int)8)).add((AbstractCell)QStageQuotationPrintService.descriptionCell((PDFont)fontRegular, (int)8, (String)dateAndPage, (int)2, (int)1, (Color)TEXT_COLOR, (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)ImmutableMap.of())).build());
        String coverLetterSubject1st = printInfo.getCoverLetterSubject1st();
        header1Builder.addRow(Row.builder().add((AbstractCell)QStageQuotationPrintService.emptyCell((int)8)).add((AbstractCell)QStageQuotationPrintService.descriptionCell((int)8, (PDFont)fontRegular, (Color)TEXT_COLOR, (int)2, (String)coverLetterSubject1st)).build());
        header1Builder.addRow(Row.builder().add((AbstractCell)QStageQuotationPrintService.emptyCell((int)8, (int)3)).build());
        return header1Builder.build();
    }

    private float printFooter(@NonNull PDPageContentStream contentStream, @NonNull PDPage page, @NonNull Table footer) {
        if (contentStream == null) {
            throw new NullPointerException("contentStream is marked non-null but is null");
        }
        if (page == null) {
            throw new NullPointerException("page is marked non-null but is null");
        }
        if (footer == null) {
            throw new NullPointerException("footer is marked non-null but is null");
        }
        float footerHeight = footer.getHeight();
        float yOffset = 48.11f + footerHeight;
        TableDrawer.builder().page(page).contentStream(contentStream).startX(70.75f).startY(yOffset).table(footer).build().draw();
        return yOffset -= footer.getHeight();
    }

    @Nonnull
    private Table details(@NonNull QStagePrintInfo printInfo, @NonNull PDRectangle mediaBox, @NonNull PrintSetup printSetup) {
        if (printInfo == null) {
            throw new NullPointerException("printInfo is marked non-null but is null");
        }
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        PrintFonts printFonts = printSetup.getPrintFonts();
        Iterable stagePrintFeatures = printInfo.getStagePrintFeatures();
        boolean priceBreakDown = Iterables.contains((Iterable)printInfo.getStagePrintFeatures(), (Object)EStagePrintFeature.OPTION_QUOTATION_PRICE_PER_UNIT_BREAK_DOWN);
        Iterable printGroups = (Iterable)MoreObjects.firstNonNull((Object)printInfo.getPositionPrintGroups(), (Object)ImmutableList.of());
        ImmutableList columnWidths = priceBreakDown ? ImmutableList.of((Object)Float.valueOf(0.125f), (Object)Float.valueOf(0.0625f), (Object)Float.valueOf(0.09375f), (Object)Float.valueOf(0.0625f), (Object)Float.valueOf(0.1875f), (Object)Float.valueOf(0.0625f), (Object)Float.valueOf(0.0625f), (Object)Float.valueOf(0.125f), (Object)Float.valueOf(0.15625f)) : ImmutableList.of((Object)Float.valueOf(0.125f), (Object)Float.valueOf(0.0625f), (Object)Float.valueOf(0.125f), (Object)Float.valueOf(0.0625f), (Object)Float.valueOf(0.34375f), (Object)Float.valueOf(0.125f), (Object)Float.valueOf(0.15625f));
        int columnCount = Iterables.size((Iterable)columnWidths);
        Table.TableBuilder tableBuilder = QStageQuotationPrintService.table((Float)Float.valueOf(QStageQuotationPrintService.maxWidth((PDRectangle)mediaBox)), (Iterable)columnWidths);
        tableBuilder.addRow(this.hLineB(columnCount));
        Row.RowBuilder rowBuilder = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER);
        PDFont fontBold = printFonts.getBold();
        rowBuilder.add((AbstractCell)QStageQuotationPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)this.messageService.get(EStagePrintBoilerPlate.STAGE__POS_POSNR_LABEL))).add((AbstractCell)QStageQuotationPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)this.messageService.get(EStagePrintBoilerPlate.STAGE__POS_ALT_LABEL))).add((AbstractCell)QStageQuotationPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)this.messageService.get(EStagePrintBoilerPlate.STAGE__POS_AMOUNT_LABEL), (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)QStageQuotationPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)this.messageService.get(EStagePrintBoilerPlate.STAGE__POS_UNIT_LABEL), (HorizontalAlignment)HorizontalAlignment.LEFT)).add((AbstractCell)QStageQuotationPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)this.messageService.get(EStagePrintBoilerPlate.STAGE__POS_SHORT_TEXT_LABEL)));
        if (priceBreakDown) {
            rowBuilder.add((AbstractCell)QStageQuotationPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)this.messageService.get(EStagePrintBoilerPlate.STAGE__POS_MAT_SELLING_PRICE_LABEL), (HorizontalAlignment)HorizontalAlignment.LEFT)).add((AbstractCell)QStageQuotationPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)this.messageService.get(EStagePrintBoilerPlate.STAGE__POS_COMPANY_WAGE_LABEL), (HorizontalAlignment)HorizontalAlignment.LEFT));
        }
        rowBuilder.add((AbstractCell)QStageQuotationPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)this.messageService.get(EStagePrintBoilerPlate.STAGE__POS_PRICE_PER_UNIT_LABEL), (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)QStageQuotationPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)this.messageService.get(EStagePrintBoilerPlate.STAGE__POS_PRICE_OVERALL_LABEL), (HorizontalAlignment)HorizontalAlignment.RIGHT)).build();
        Row headline1 = rowBuilder.build();
        tableBuilder.addRow(headline1);
        tableBuilder.addRow(this.hLineT(columnCount));
        Iterable rows = this.rows(stagePrintFeatures, printSetup, printGroups, (Iterable)columnWidths);
        rows.forEach(arg_0 -> ((Table.TableBuilder)tableBuilder).addRow(arg_0));
        tableBuilder.addRow(Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)QStageQuotationPrintService.emptyCell((PrintSetup)printSetup, (int)columnCount)).build());
        return tableBuilder.build();
    }

    @Nonnull
    private Iterable<Row> rows(@NonNull Iterable<EStagePrintFeature> stagePrintFeatures, @NonNull PrintSetup printSetup, @NonNull Iterable<QStagePositionPrintGroup> printGroups, @NonNull Iterable<Float> columnWidths) {
        if (stagePrintFeatures == null) {
            throw new NullPointerException("stagePrintFeatures is marked non-null but is null");
        }
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        if (printGroups == null) {
            throw new NullPointerException("printGroups is marked non-null but is null");
        }
        if (columnWidths == null) {
            throw new NullPointerException("columnWidths is marked non-null but is null");
        }
        boolean headlineBold = Iterables.contains(stagePrintFeatures, (Object)EStagePrintFeature.OPTION_QUOTATION_INDENT_LEVEL_AS_HEADLINE);
        boolean showLongText = Iterables.contains(stagePrintFeatures, (Object)EStagePrintFeature.OPTION_QUOTATION_SHOW_LONG_TEXT);
        boolean priceBreakDown = Iterables.contains(stagePrintFeatures, (Object)EStagePrintFeature.OPTION_QUOTATION_PRICE_PER_UNIT_BREAK_DOWN);
        int columnCount = Iterables.size(columnWidths);
        ImmutableList.Builder rowsBuilder = ImmutableList.builder();
        for (QStagePositionPrintGroup printGroup : printGroups) {
            if (printGroup.isEmpty()) continue;
            Iterable sortedRows = printGroup.getSortedRows();
            PrintFonts printFonts = printSetup.getPrintFonts();
            if (printGroup.isPrintAsGroup() && !printGroup.isGenerated()) {
                PDFont fontRegular = printFonts.getRegular();
                PDFont fontBold = printFonts.getBold();
                String printGroupKey = printGroup.getKey();
                String printGroupName = printGroup.getName();
                String printGroupDetail = showLongText ? printGroup.getDetail() : "";
                Row headerRowP = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)QStageQuotationPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)(headlineBold ? fontBold : fontRegular), (Color)TEXT_COLOR, (int)4, (String)printGroupKey, (HorizontalAlignment)HorizontalAlignment.LEFT)).add((AbstractCell)QStageQuotationPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)(headlineBold ? fontBold : fontRegular), (Color)TEXT_COLOR, (int)(columnCount - 4), (String)printGroupName, (HorizontalAlignment)HorizontalAlignment.LEFT)).build();
                rowsBuilder.add((Object)headerRowP);
                if (StringUtils.isNotBlank((CharSequence)printGroupDetail)) {
                    Row headerRowD = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)QStageQuotationPrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (int)4, (String)"", (HorizontalAlignment)HorizontalAlignment.LEFT)).add((AbstractCell)QStageQuotationPrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (int)(columnCount - 4), (String)printGroupDetail, (HorizontalAlignment)HorizontalAlignment.LEFT)).build();
                    rowsBuilder.add((Object)headerRowD);
                }
            }
            for (QStagePositionPrintRow printRow : sortedRows) {
                BigDecimal product = printRow.getOrderedAmount();
                String unit = printRow.getUnit();
                String amount = PrintHelper.asString((BigDecimal)product, (String)"", (boolean)true);
                EPositionType positionType = (EPositionType)MoreObjects.firstNonNull((Object)printRow.getPositionType(), (Object)EPositionType.UNKNOWN);
                EAlternativePositionType alternativePositionType = (EAlternativePositionType)MoreObjects.firstNonNull((Object)printRow.getAlternativePositionType(), (Object)EAlternativePositionType.NO);
                boolean flagAlternativePosition = alternativePositionType.showAsAlternative();
                boolean flagCalculate = alternativePositionType.calculate();
                String pricePerUnit = PrintHelper.asString((BigDecimal)printRow.getPricePerUnit(), (String)"", (boolean)true);
                String priceAggregated = flagCalculate ? PrintHelper.asString((BigDecimal)printRow.getPriceAggregated(), (String)"", (boolean)true) : this.messageService.get(EStagePrintBoilerPlate.STAGE__POS_NOT_INCLUDED_PRICE);
                String materialSellingPricePerUnit = PrintHelper.asString((BigDecimal)printRow.getMaterialSellingPricePerUnit(), (String)"", (boolean)true);
                BigDecimal safeCompanyWagePerUnit = (BigDecimal)MoreObjects.firstNonNull((Object)printRow.getCompanyWagePerUnit(), (Object)BigDecimal.ZERO);
                BigDecimal safeExternalServiceSellingPricePerUnit = (BigDecimal)MoreObjects.firstNonNull((Object)printRow.getExternalServiceSellingPricePerUnit(), (Object)BigDecimal.ZERO);
                BigDecimal fakeCompanyWagePerUnit = safeCompanyWagePerUnit.add(safeExternalServiceSellingPricePerUnit).setScale(2, RoundingMode.HALF_UP);
                String fakeCompanyWagePerUnitTxt = PrintHelper.asString((BigDecimal)fakeCompanyWagePerUnit, (String)"", (boolean)true);
                String positionNumber = StringUtils.trimToEmpty((String)printRow.getPositionNumber());
                String shortText = StringUtils.trimToEmpty((String)printRow.getShortText());
                String longText = StringUtils.trimToEmpty((String)printRow.getLongText());
                Color bg = DEFAULT_BG_COLOR_DETAILS;
                ArrayList parts = Lists.newArrayList();
                parts.add(Pair.of((Object)EDetailRowType.SHORT_TEXT, (Object)shortText));
                String bidderComplement = StringUtils.trimToEmpty((String)printRow.getBidderComplement());
                if (StringUtils.isNotBlank((CharSequence)bidderComplement)) {
                    parts.add(Pair.of((Object)EDetailRowType.BIDDER_COMPLEMENT, (Object)bidderComplement));
                }
                if (showLongText) {
                    LONG_TEXT_SPLITTER.split((CharSequence)longText).forEach(item -> parts.add(Pair.of((Object)EDetailRowType.LONG_TEXT, (Object)item)));
                }
                for (int i = 0; i < parts.size(); ++i) {
                    Pair rowToPrint = (Pair)parts.get(i);
                    EDetailRowType detailRowType = (EDetailRowType)rowToPrint.getLeft();
                    String textFragment = (String)rowToPrint.getRight();
                    PDFont textFragmentFont = headlineBold && positionType == EPositionType.COMMENT ? printFonts.getBold() : (EDetailRowType.BIDDER_COMPLEMENT == detailRowType ? printFonts.getItalic() : printFonts.getRegular());
                    boolean first = i == 0;
                    Row.RowBuilder rowBuilder = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER);
                    if (positionType == EPositionType.REMARK) {
                        Color color = printRow.isFormatColorFlag() ? (Color)MoreObjects.firstNonNull((Object)printRow.getFormatColor(), (Object)TEXT_COLOR) : TEXT_COLOR;
                        PDFont font = printRow.isFormatBoldFlag() ? printFonts.getBold() : printFonts.getRegular();
                        Row row = Row.builder().backgroundColor(DETAIL_BG_COLOR_UNEVEN).add((AbstractCell)QStageQuotationPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)font, (Color)color, (int)columnCount, (String)shortText, (HorizontalAlignment)HorizontalAlignment.LEFT)).build();
                        rowsBuilder.add((Object)row);
                        continue;
                    }
                    rowBuilder.add((AbstractCell)QStageQuotationPrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (Color)bg, (String)(first ? positionNumber : ""), (HorizontalAlignment)HorizontalAlignment.LEFT)).add((AbstractCell)QStageQuotationPrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (Color)bg, (String)(first ? (flagAlternativePosition ? this.messageService.get(EStagePrintBoilerPlate.STAGE__POS_ALT_FLAG) : "") : ""), (HorizontalAlignment)HorizontalAlignment.LEFT)).add((AbstractCell)QStageQuotationPrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (Color)bg, (String)(first ? amount : ""), (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)QStageQuotationPrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (Color)bg, (String)(first ? unit : ""), (HorizontalAlignment)HorizontalAlignment.LEFT)).add((AbstractCell)QStageQuotationPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)textFragmentFont, (Color)TEXT_COLOR, (Color)bg, (String)textFragment, (HorizontalAlignment)HorizontalAlignment.LEFT));
                    if (priceBreakDown) {
                        rowBuilder.add((AbstractCell)QStageQuotationPrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (Color)bg, (String)(first ? materialSellingPricePerUnit : ""), (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)QStageQuotationPrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (Color)bg, (String)(first ? fakeCompanyWagePerUnitTxt : ""), (HorizontalAlignment)HorizontalAlignment.RIGHT));
                    }
                    rowBuilder.add((AbstractCell)QStageQuotationPrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (Color)bg, (String)(first ? pricePerUnit : ""), (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)QStageQuotationPrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (Color)bg, (String)(first ? priceAggregated : ""), (HorizontalAlignment)HorizontalAlignment.RIGHT));
                    Row row = rowBuilder.build();
                    rowsBuilder.add((Object)row);
                }
            }
            rowsBuilder.add((Object)this.hLineB(Iterables.size(columnWidths)));
            Iterable children = printGroup.getChildren();
            Iterable childrenRows = this.rows(stagePrintFeatures, printSetup, children, columnWidths);
            rowsBuilder.addAll(childrenRows);
            if (!printGroup.isPrintAsGroup() || printGroup.isGenerated() || !Iterables.contains((Iterable)GROUP_SUMS_TO_PRINT_LEVELS, (Object)printGroup.getLevel())) continue;
            String title = printGroup.getName();
            String priceWithoutDiscountSum = PrintHelper.asString((BigDecimal)printGroup.getPriceWithoutDiscountSum(), (String)"", (boolean)true);
            String priceWithDiscountTxt = this.messageService.get(EStagePrintBoilerPlate.STAGE__PRICE_WITH_DISCOUNT_LABEL);
            String priceWithDiscountLabel = String.format("%s %s", priceWithDiscountTxt, title);
            Row aggregationRow1 = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)QStageQuotationPrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (int)(columnCount - 1), (String)priceWithDiscountLabel, (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)QStageQuotationPrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (int)1, (String)priceWithoutDiscountSum, (HorizontalAlignment)HorizontalAlignment.RIGHT)).build();
            rowsBuilder.add((Object)aggregationRow1);
            rowsBuilder.add((Object)this.hLineB(Iterables.size(columnWidths)));
            Row blankRow = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)QStageQuotationPrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (int)columnCount, (String)"", (HorizontalAlignment)HorizontalAlignment.LEFT)).build();
            rowsBuilder.add((Object)blankRow);
        }
        return rowsBuilder.build();
    }

    @Nonnull
    private Table coverSheet(@NonNull QStagePrintInfo printInfo, @NonNull PDRectangle mediaBox, @NonNull PrintSetup printSetup) {
        Iterable paymentConditions;
        LocalDate bindingPeriod;
        if (printInfo == null) {
            throw new NullPointerException("printInfo is marked non-null but is null");
        }
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        PrintFonts printFonts = printSetup.getPrintFonts();
        PDFont fontBold = printFonts.getBold();
        ImmutableList columnWidths = ImmutableList.of((Object)Float.valueOf(0.25f), (Object)Float.valueOf(0.125f), (Object)Float.valueOf(0.1875f), (Object)Float.valueOf(0.4375f));
        int columnCount = Iterables.size((Iterable)columnWidths);
        Table.TableBuilder tableBuilder = QStageQuotationPrintService.table((Float)Float.valueOf(QStageQuotationPrintService.maxWidth((PDRectangle)mediaBox)), (Iterable)columnWidths);
        tableBuilder.addRow(Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)QStageQuotationPrintService.descriptionCell((int)10, (PDFont)fontBold, (Color)TEXT_COLOR, (int)columnCount, (String)printInfo.getCoverLetterSubject1st(), (HorizontalAlignment)HorizontalAlignment.LEFT)).build());
        this.boilerPlate(10, printFonts, columnCount, printInfo.getCoverLetterSubject2nd(), arg_0 -> ((Table.TableBuilder)tableBuilder).addRow(arg_0));
        tableBuilder.addRow(Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)QStageQuotationPrintService.emptyCell((int)10, (int)columnCount)).build());
        this.boilerPlate(10, printFonts, columnCount, printInfo.getCoverLetterTitle(), arg_0 -> ((Table.TableBuilder)tableBuilder).addRow(arg_0));
        for (int i = 0; i < 2; ++i) {
            tableBuilder.addRow(Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)QStageQuotationPrintService.emptyCell((int)10, (int)columnCount)).build());
        }
        this.boilerPlate(10, printFonts, columnCount, printInfo.getCoverLetterBody1(), arg_0 -> ((Table.TableBuilder)tableBuilder).addRow(arg_0));
        BigDecimal netValue = printInfo.getPriceWithDiscountSum();
        BigDecimal grossValue = printInfo.getPriceGrossWithDiscountSum();
        String netValueString = PrintHelper.asCurrency((BigDecimal)netValue, (String)"0,00", (boolean)true);
        String grossValueString = PrintHelper.asCurrency((BigDecimal)grossValue, (String)"0,00", (boolean)true);
        String netLabelTxt = this.messageService.get(EStagePrintBoilerPlate.STAGE__NET_LABEL);
        String netLabel = String.format("%s (%s)", netValueString, StringUtils.lowerCase((String)netLabelTxt));
        String grossLabelTxt = this.messageService.get(EStagePrintBoilerPlate.STAGE__GROSS_LABEL);
        String grossLabel = String.format("%s:", grossLabelTxt);
        tableBuilder.addRow(Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)QStageQuotationPrintService.emptyCell((int)10)).add((AbstractCell)QStageQuotationPrintService.descriptionCell((int)10, (PDFont)fontBold, (Color)TEXT_COLOR, (int)2, (String)netLabel, (HorizontalAlignment)HorizontalAlignment.LEFT)).add((AbstractCell)QStageQuotationPrintService.emptyCell((int)10)).build());
        tableBuilder.addRow(Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)QStageQuotationPrintService.emptyCell((int)10, (int)columnCount)).build());
        this.boilerPlate(10, printFonts, columnCount, printInfo.getCoverLetterBody2(), arg_0 -> ((Table.TableBuilder)tableBuilder).addRow(arg_0));
        tableBuilder.addRow(Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)QStageQuotationPrintService.emptyCell((int)10, (int)columnCount)).build());
        Iterable stagePrintFeatures = printInfo.getStagePrintFeatures();
        if (Iterables.contains((Iterable)stagePrintFeatures, (Object)EStagePrintFeature.OPTION_QUOTATION_PRINT_PROJECT_EXECUTION)) {
            LocalDate projectExecutionStartDate = printInfo.getProjectExecutionStartDate();
            LocalDate projectExecutionEndDate = printInfo.getProjectExecutionEndDate();
            if (null != projectExecutionStartDate || null != projectExecutionEndDate) {
                String projectExecutionStartDateTxt = null != projectExecutionStartDate ? DateTimeHelperService.germanDate((LocalDate)projectExecutionStartDate) : "";
                String projectExecutionEndDateTxt = null != projectExecutionEndDate ? DateTimeHelperService.germanDate((LocalDate)projectExecutionEndDate) : "";
                String projectExecutionParagraph = this.messageService.get(EStagePrintBoilerPlate.STAGE__PROJECT_EXECUTION, new Object[]{projectExecutionStartDateTxt, projectExecutionEndDateTxt});
                tableBuilder.addRow(Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)QStageQuotationPrintService.descriptionCell((int)10, (PrintFonts)printFonts, (Color)TEXT_COLOR, (int)columnCount, (String)projectExecutionParagraph, (HorizontalAlignment)HorizontalAlignment.LEFT)).build());
                tableBuilder.addRow(Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)QStageQuotationPrintService.emptyCell((int)10, (int)columnCount)).build());
            }
        }
        if (Iterables.contains((Iterable)stagePrintFeatures, (Object)EStagePrintFeature.OPTION_QUOTATION_PRINT_BINDING_PERIOD) && null != (bindingPeriod = printInfo.getBindingPeriodDate())) {
            String bindingPeriodTxt = DateTimeHelperService.germanDate((LocalDate)bindingPeriod);
            String bindingPeriodLabel = this.messageService.get(EStagePrintBoilerPlate.STAGE__BINDING_PERIOD, new Object[]{bindingPeriodTxt});
            tableBuilder.addRow(Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)QStageQuotationPrintService.descriptionCell((int)10, (PrintFonts)printFonts, (Color)TEXT_COLOR, (int)columnCount, (String)bindingPeriodLabel, (HorizontalAlignment)HorizontalAlignment.LEFT)).build());
            tableBuilder.addRow(Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)QStageQuotationPrintService.emptyCell((int)10, (int)columnCount)).build());
        }
        if (Iterables.contains((Iterable)stagePrintFeatures, (Object)EStagePrintFeature.OPTION_QUOTATION_PRINT_AUTOGRAPH_PARAGRAPH)) {
            String autographTxt = this.messageService.get(EStagePrintBoilerPlate.STAGE__AUTOGRAPH_PARAGRAPH);
            tableBuilder.addRow(Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)QStageQuotationPrintService.descriptionCell((int)10, (PrintFonts)printFonts, (Color)TEXT_COLOR, (int)columnCount, (String)autographTxt, (HorizontalAlignment)HorizontalAlignment.LEFT)).build());
            tableBuilder.addRow(Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)QStageQuotationPrintService.emptyCell((int)10, (int)columnCount)).build());
        }
        if (Iterables.contains((Iterable)stagePrintFeatures, (Object)EStagePrintFeature.OPTION_QUOTATION_PRINT_VOB_PARAGRAPH)) {
            String vobTxt = this.messageService.get(EStagePrintBoilerPlate.STAGE__VOB_PARAGRAPH);
            tableBuilder.addRow(Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)QStageQuotationPrintService.descriptionCell((int)10, (PrintFonts)printFonts, (Color)TEXT_COLOR, (int)columnCount, (String)vobTxt, (HorizontalAlignment)HorizontalAlignment.LEFT)).build());
            tableBuilder.addRow(Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)QStageQuotationPrintService.emptyCell((int)10, (int)columnCount)).build());
        }
        if (Iterables.contains((Iterable)stagePrintFeatures, (Object)EStagePrintFeature.OPTION_QUOTATION_PRINT_PAYMENT_CONDITIONS) && !Iterables.isEmpty((Iterable)(paymentConditions = this.paymentConditions(printInfo, printFonts, columnCount)))) {
            paymentConditions.forEach(arg_0 -> ((Table.TableBuilder)tableBuilder).addRow(arg_0));
            tableBuilder.addRow(Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)QStageQuotationPrintService.emptyCell((int)10, (int)columnCount)).build());
        }
        tableBuilder.addRow(Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)QStageQuotationPrintService.emptyCell((int)10, (int)columnCount)).build());
        return tableBuilder.build();
    }

    private void boilerPlate(int fontSize, @NonNull PrintFonts printFonts, int columnCount, @NonNull String value, @NonNull Consumer<Row> rowConsumer) {
        if (printFonts == null) {
            throw new NullPointerException("printFonts is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (rowConsumer == null) {
            throw new NullPointerException("rowConsumer is marked non-null but is null");
        }
        if (StringUtils.isNotBlank((CharSequence)value)) {
            rowConsumer.accept(Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)QStageQuotationPrintService.descriptionCell((int)fontSize, (PrintFonts)printFonts, (Color)TEXT_COLOR, (int)columnCount, (String)value, (HorizontalAlignment)HorizontalAlignment.LEFT)).build());
            rowConsumer.accept(Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)QStageQuotationPrintService.emptyCell((int)fontSize, (int)columnCount)).build());
        }
    }

    @Nonnull
    private Table summarization(@NonNull QStagePrintInfo printInfo, @NonNull PDRectangle mediaBox, @NonNull PrintSetup printSetup) {
        if (printInfo == null) {
            throw new NullPointerException("printInfo is marked non-null but is null");
        }
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        ImmutableList columnWidths = ImmutableList.of((Object)Float.valueOf(0.59375f), (Object)Float.valueOf(0.09375f), (Object)Float.valueOf(0.09375f), (Object)Float.valueOf(0.09375f), (Object)Float.valueOf(0.15625f));
        int columnAmount = Iterables.size((Iterable)columnWidths);
        Table.TableBuilder tableBuilder = QStageQuotationPrintService.table((Float)Float.valueOf(QStageQuotationPrintService.maxWidth((PDRectangle)mediaBox)), (Iterable)columnWidths);
        BigDecimal vat = (BigDecimal)MoreObjects.firstNonNull((Object)printInfo.getFinanceVAT(), (Object)BigDecimal.ZERO);
        BigDecimal sumNet = printInfo.getPriceWithDiscountSum();
        BigDecimal sumVAT = printInfo.getVatValueWithDiscountSum();
        BigDecimal sumGross = printInfo.getPriceGrossWithDiscountSum();
        String netLabelTxt = this.messageService.get(EStagePrintBoilerPlate.STAGE__NET_LABEL);
        String vatLabelTxt = this.messageService.get(EStagePrintBoilerPlate.STAGE__VAT_LABEL);
        String valueOverallLabelTxt = this.messageService.get(EStagePrintBoilerPlate.STAGE__VALUE_OVERALL_LABEL);
        Row sumNetRow = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)QStageQuotationPrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (int)(columnAmount - 2), (String)netLabelTxt, (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)QStageQuotationPrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)"", (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)QStageQuotationPrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)PrintHelper.asString((BigDecimal)sumNet, (String)"", (boolean)true), (HorizontalAlignment)HorizontalAlignment.RIGHT)).build();
        tableBuilder.addRow(sumNetRow);
        Row sumVATRow = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)QStageQuotationPrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (int)(columnAmount - 2), (String)vatLabelTxt, (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)QStageQuotationPrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)String.format("%s %%", PrintHelper.asString((BigDecimal)vat, (String)"", (boolean)true)), (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)QStageQuotationPrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)PrintHelper.asString((BigDecimal)sumVAT, (String)"", (boolean)true), (HorizontalAlignment)HorizontalAlignment.RIGHT)).build();
        tableBuilder.addRow(sumVATRow);
        tableBuilder.addRow(this.hLineB((Iterable)ImmutableList.of((Object)Pair.of((Object)1, (Object)false), (Object)Pair.of((Object)4, (Object)true))));
        Row sumGrossRow = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)QStageQuotationPrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (int)(columnAmount - 2), (String)valueOverallLabelTxt, (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)QStageQuotationPrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)"", (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)QStageQuotationPrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)PrintHelper.asString((BigDecimal)sumGross, (String)"", (boolean)true), (HorizontalAlignment)HorizontalAlignment.RIGHT)).build();
        tableBuilder.addRow(sumGrossRow);
        tableBuilder.addRow(this.hLineTB((Iterable)ImmutableList.of((Object)Pair.of((Object)1, (Object)false), (Object)Pair.of((Object)4, (Object)true))));
        return tableBuilder.build();
    }

    @Nonnull
    private Table discounts(@NonNull QStagePrintInfo printInfo, @NonNull PDRectangle mediaBox, @NonNull PrintSetup printSetup) {
        boolean hasDiscount;
        if (printInfo == null) {
            throw new NullPointerException("printInfo is marked non-null but is null");
        }
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        ImmutableList columnWidths = ImmutableList.of((Object)Float.valueOf(0.59375f), (Object)Float.valueOf(0.09375f), (Object)Float.valueOf(0.09375f), (Object)Float.valueOf(0.09375f), (Object)Float.valueOf(0.15625f));
        int columnAmount = Iterables.size((Iterable)columnWidths);
        Table.TableBuilder tableBuilder = QStageQuotationPrintService.table((Float)Float.valueOf(QStageQuotationPrintService.maxWidth((PDRectangle)mediaBox)), (Iterable)columnWidths);
        BigDecimal discount = printInfo.getDiscount();
        boolean bl = hasDiscount = discount.compareTo(BigDecimal.ZERO) != 0;
        if (hasDiscount) {
            BigDecimal priceWithoutDiscountSum = printInfo.getPriceWithoutDiscountSum();
            BigDecimal priceWithDiscount = printInfo.getPriceWithDiscountSum();
            BigDecimal discountValue = priceWithoutDiscountSum.subtract(priceWithDiscount).setScale(2, RoundingMode.HALF_UP);
            String discountName = discount.compareTo(BigDecimal.ZERO) < 0 ? "Zuschlag" : "Nachlass";
            BigDecimal discountValuePrint = discountValue.negate();
            BigDecimal discountAbs = discount.abs();
            Row discountRow = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)QStageQuotationPrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (int)(columnAmount - 2), (String)discountName, (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)QStageQuotationPrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)String.format("%s %%", PrintHelper.asString((BigDecimal)discountAbs, (String)"", (boolean)true)), (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)QStageQuotationPrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)PrintHelper.asString((BigDecimal)discountValuePrint, (String)"", (boolean)true), (HorizontalAlignment)HorizontalAlignment.RIGHT)).build();
            tableBuilder.addRow(discountRow);
            tableBuilder.addRow(this.hLineB(5));
        }
        return tableBuilder.build();
    }

    @Nonnull
    private Table subTotals(@NonNull QStagePrintInfo printInfo, @NonNull PDRectangle mediaBox, @NonNull PrintSetup printSetup) {
        if (printInfo == null) {
            throw new NullPointerException("printInfo is marked non-null but is null");
        }
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        Iterable printGroups = (Iterable)MoreObjects.firstNonNull((Object)printInfo.getPositionPrintGroups(), (Object)ImmutableList.of());
        ImmutableList columnWidths = ImmutableList.of((Object)Float.valueOf(0.1875f), (Object)Float.valueOf(0.5625f), (Object)Float.valueOf(0.25f));
        int columnAmount = Iterables.size((Iterable)columnWidths);
        Table.TableBuilder tableBuilder = QStageQuotationPrintService.table((Float)Float.valueOf(QStageQuotationPrintService.maxWidth((PDRectangle)mediaBox)), (Iterable)columnWidths);
        if (Iterables.contains((Iterable)printInfo.getStagePrintFeatures(), (Object)EStagePrintFeature.OPTION_QUOTATION_ATTACHMENT_SUBTOTALS)) {
            tableBuilder.addRow(Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)QStageQuotationPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)printSetup.getPrintFonts().getBold(), (Color)TEXT_COLOR, (int)columnAmount, (String)"Anhang der Zwischensummen", (HorizontalAlignment)HorizontalAlignment.CENTER)).build());
            tableBuilder.addRow(Row.builder().add((AbstractCell)QStageQuotationPrintService.emptyCell((PrintSetup)printSetup, (int)columnAmount)).build());
            String titleLabel = this.messageService.get(EStagePrintBoilerPlate.GROUPING_LEVEL_TITLE);
            String nameLabel = this.messageService.get(EStagePrintBoilerPlate.GROUPING_LEVEL_NAME);
            String sumLabel = this.messageService.get(EStagePrintBoilerPlate.GROUPING_LEVEL_SUM);
            tableBuilder.addRow(Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)QStageQuotationPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)printSetup.getPrintFonts().getBold(), (Color)TEXT_COLOR, (String)titleLabel, (HorizontalAlignment)HorizontalAlignment.LEFT)).add((AbstractCell)QStageQuotationPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)printSetup.getPrintFonts().getBold(), (Color)TEXT_COLOR, (String)nameLabel, (HorizontalAlignment)HorizontalAlignment.LEFT)).add((AbstractCell)QStageQuotationPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)printSetup.getPrintFonts().getBold(), (Color)TEXT_COLOR, (String)sumLabel, (HorizontalAlignment)HorizontalAlignment.RIGHT)).build());
            tableBuilder.addRow(this.hLineB(columnAmount));
            for (QStagePositionPrintGroup printGroup : printGroups) {
                int level = printGroup.getLevel();
                String key = printGroup.getKey();
                String name = printGroup.getName();
                BigDecimal priceWithDiscountSum = printGroup.getPriceWithDiscountSum();
                String priceWithoutDiscountSumTxt = PrintHelper.asCurrency((BigDecimal)priceWithDiscountSum, (String)"", (boolean)true);
                tableBuilder.addRow(Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)QStageQuotationPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)printSetup.getPrintFonts().getBold(), (Color)TEXT_COLOR, (String)key, (HorizontalAlignment)HorizontalAlignment.LEFT)).add((AbstractCell)QStageQuotationPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)printSetup.getPrintFonts().getBold(), (Color)TEXT_COLOR, (String)name, (HorizontalAlignment)HorizontalAlignment.LEFT)).add((AbstractCell)QStageQuotationPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)printSetup.getPrintFonts().getBold(), (Color)TEXT_COLOR, (String)priceWithoutDiscountSumTxt, (HorizontalAlignment)HorizontalAlignment.RIGHT)).build());
            }
            tableBuilder.addRow(this.hLineB((Iterable)ImmutableList.of((Object)Pair.of((Object)2, (Object)false), (Object)Pair.of((Object)1, (Object)true))));
            BigDecimal priceWithoutDiscountSum = printInfo.getPriceWithoutDiscountSum();
            String priceWithoutDiscountSumTxt = PrintHelper.asCurrency((BigDecimal)priceWithoutDiscountSum, (String)"", (boolean)true);
            tableBuilder.addRow(Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)QStageQuotationPrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (int)(columnAmount - 1), (String)"", (HorizontalAlignment)HorizontalAlignment.LEFT)).add((AbstractCell)QStageQuotationPrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)priceWithoutDiscountSumTxt, (HorizontalAlignment)HorizontalAlignment.RIGHT)).build());
            tableBuilder.addRow(this.hLineTB((Iterable)ImmutableList.of((Object)Pair.of((Object)2, (Object)false), (Object)Pair.of((Object)1, (Object)true))));
        }
        return tableBuilder.build();
    }

    @Nonnull
    private Table signatures(@NonNull QStagePrintInfo printInfo, @NonNull PDRectangle mediaBox, @NonNull PrintSetup printSetup) {
        if (printInfo == null) {
            throw new NullPointerException("printInfo is marked non-null but is null");
        }
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        PrintFonts printFonts = printSetup.getPrintFonts();
        Iterable stagePrintFeatures = printInfo.getStagePrintFeatures();
        boolean noSignature = Iterables.contains((Iterable)stagePrintFeatures, (Object)EStagePrintFeature.OPTION_QUOTATION_NO_SIGNATURE);
        ImmutableList columnWidths = ImmutableList.of((Object)Float.valueOf(0.25f), (Object)Float.valueOf(0.125f), (Object)Float.valueOf(0.25f), (Object)Float.valueOf(0.125f), (Object)Float.valueOf(0.25f));
        int columnAmount = Iterables.size((Iterable)columnWidths);
        Table.TableBuilder tableBuilder = QStageQuotationPrintService.table((Float)Float.valueOf(QStageQuotationPrintService.maxWidth((PDRectangle)mediaBox)), (Iterable)columnWidths);
        if (noSignature) {
            String noSignatureParagraph = this.messageService.get(EStagePrintBoilerPlate.STAGE__NO_SIGNATURE_PARAGRAPH);
            tableBuilder.addRow(Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)QStageQuotationPrintService.descriptionCell((int)10, (PrintFonts)printFonts, (Color)TEXT_COLOR, (int)columnAmount, (String)noSignatureParagraph, (HorizontalAlignment)HorizontalAlignment.LEFT)).build());
        } else {
            this.boilerPlate(10, printFonts, columnAmount, printInfo.getCoverLetterBody3(), arg_0 -> ((Table.TableBuilder)tableBuilder).addRow(arg_0));
            Iterable signaturePrintInfos = printInfo.getSignaturePrintInfos();
            Iterable signaturePartitions = Iterables.partition((Iterable)signaturePrintInfos, (int)3);
            for (List signaturePartition : signaturePartitions) {
                int size = Iterables.size((Iterable)signaturePartition);
                UserPrintInfo userPrintInfo1 = size > 0 ? (UserPrintInfo)signaturePartition.get(0) : null;
                UserPrintInfo userPrintInfo2 = size > 1 ? (UserPrintInfo)signaturePartition.get(1) : null;
                UserPrintInfo userPrintInfo3 = size > 2 ? (UserPrintInfo)signaturePartition.get(2) : null;
                boolean user1Set = null != userPrintInfo1;
                boolean user2Set = null != userPrintInfo2;
                boolean user3Set = null != userPrintInfo3;
                String signature1 = user1Set ? this.signature(userPrintInfo1) : "";
                String signature2 = user2Set ? this.signature(userPrintInfo2) : "";
                String signature3 = user3Set ? this.signature(userPrintInfo3) : "";
                for (int i = 0; i < 5; ++i) {
                    tableBuilder.addRow(Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)QStageQuotationPrintService.emptyCell((int)10, (int)columnAmount)).build());
                }
                tableBuilder.addRow(this.hLineB((Iterable)ImmutableList.of((Object)Pair.of((Object)1, (Object)user1Set), (Object)Pair.of((Object)1, (Object)false), (Object)Pair.of((Object)1, (Object)user2Set), (Object)Pair.of((Object)1, (Object)false), (Object)Pair.of((Object)1, (Object)user3Set))));
                tableBuilder.addRow(Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)QStageQuotationPrintService.descriptionCell((int)10, (PrintFonts)printFonts, (Color)TEXT_COLOR, (int)1, (String)signature1, (HorizontalAlignment)HorizontalAlignment.LEFT)).add((AbstractCell)QStageQuotationPrintService.descriptionCell((int)10, (PrintFonts)printFonts, (Color)TEXT_COLOR, (int)1, (String)"", (HorizontalAlignment)HorizontalAlignment.LEFT)).add((AbstractCell)QStageQuotationPrintService.descriptionCell((int)10, (PrintFonts)printFonts, (Color)TEXT_COLOR, (int)1, (String)signature2, (HorizontalAlignment)HorizontalAlignment.LEFT)).add((AbstractCell)QStageQuotationPrintService.descriptionCell((int)10, (PrintFonts)printFonts, (Color)TEXT_COLOR, (int)1, (String)"", (HorizontalAlignment)HorizontalAlignment.LEFT)).add((AbstractCell)QStageQuotationPrintService.descriptionCell((int)10, (PrintFonts)printFonts, (Color)TEXT_COLOR, (int)1, (String)signature3, (HorizontalAlignment)HorizontalAlignment.LEFT)).build());
            }
        }
        return tableBuilder.build();
    }

    @Nonnull
    private String signature(@NonNull UserPrintInfo userPrintInfo) {
        if (userPrintInfo == null) {
            throw new NullPointerException("userPrintInfo is marked non-null but is null");
        }
        String authorityToSign = StringUtils.trimToEmpty((String)userPrintInfo.getAuthorityToSign());
        String hiddenAuthorityToSign = AUTHORITY_TO_SIGN_HIDE.contains(StringUtils.upperCase((String)authorityToSign)) ? "" : authorityToSign;
        String fullName = StringUtils.joinWith((String)" ", (Object[])new Object[]{StringUtils.trimToEmpty((String)userPrintInfo.getFirstName()), StringUtils.trimToEmpty((String)userPrintInfo.getLastName())});
        return StringUtils.trimToEmpty((String)StringUtils.joinWith((String)" ", (Object[])new Object[]{hiddenAuthorityToSign, fullName}));
    }
}

