/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service.print;

import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import de.leancoders.common.helper.DateTimeHelper;
import de.qfm.erp.service.configuration.PrintLayoutConfig;
import de.qfm.erp.service.model.internal.print.CompanyPrintInfo;
import de.qfm.erp.service.model.internal.print.EPrintFontSize;
import de.qfm.erp.service.model.internal.print.PrintConfiguration;
import de.qfm.erp.service.model.internal.print.PrintFonts;
import de.qfm.erp.service.model.internal.print.PrintInfo;
import de.qfm.erp.service.model.internal.print.PrintSetup;
import de.qfm.erp.service.model.internal.print.UserPrintInfo;
import de.qfm.erp.service.model.internal.print.qentity.QStagePositionPrintGroup;
import de.qfm.erp.service.model.internal.print.qentity.QStagePrintConfiguration;
import de.qfm.erp.service.model.internal.print.qentity.QStagePrintInfo;
import de.qfm.erp.service.model.jpa.configuration.ConfigurationCompany;
import de.qfm.erp.service.model.jpa.quotation.EQStageType;
import de.qfm.erp.service.service.route.impl.PrintHelper;
import de.qfm.erp.service.service.security.UserService;
import de.qfm.erp.service.service.service.DateTimeHelperService;
import de.qfm.erp.service.service.service.MessageService;
import de.qfm.erp.service.service.service.print.AbstractPrintService;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.vandeseer.easytable.TableDrawer;
import org.vandeseer.easytable.settings.HorizontalAlignment;
import org.vandeseer.easytable.settings.VerticalAlignment;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.ImageCell;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class QStageLongTextPrintService
extends AbstractPrintService<QStagePrintInfo, QStagePrintConfiguration> {
    private static final Logger log = LogManager.getLogger(QStageLongTextPrintService.class);
    protected static final float MM_PER_UNIT = 2.83f;
    protected static final float STAGE_MARGIN_LEFT_RIGHT = 70.75f;
    protected static final float STAGE_MARGIN_TOP_BOTTOM = 14.15f;
    protected static final float FOOTER_MARGIN_LEFT_RIGHT = 70.75f;
    protected static final float LOGO_HEADER_DISTANCE = 36.79f;
    protected static final float HEADER_TEXT_SPACE = 2.83f;
    protected static final float HEADER_TO_CONTENT_SPACE = 8.49f;
    protected static final Color TEXT_COLOR = Color.BLACK;
    protected static final int SENDER_FONT_SIZE = 7;
    private static final Map<EQStageType, String> QSTAGE_TYPE_NUMBER_NAMING = ImmutableMap.builder().put((Object)EQStageType.INQUIRY, (Object)"Anfrage").put((Object)EQStageType.CALCULATION, (Object)"Kalkulation").put((Object)EQStageType.QUOTATION, (Object)"Angebot").put((Object)EQStageType.COMMISSION, (Object)"Auftrag").put((Object)EQStageType.COMMISSION__ADDENDUM, (Object)"Nachtrag").put((Object)EQStageType.COMMISSION__COST_ESTIMATE, (Object)"Kostensch\u00e4tzung").put((Object)EQStageType.COMMISSION__COST_UNIT, (Object)"Unterkostentr\u00e4ger").put((Object)EQStageType.COMMISSION__COST_UNIT__CE, (Object)"Unterkostentr\u00e4ger").build();
    private final PrintLayoutConfig printLayoutConfig;

    @Autowired
    public QStageLongTextPrintService(UserService userService, MessageService messageService, DateTimeHelperService dateTimeHelperService, PrintHelper printHelper, PrintLayoutConfig printLayoutConfig) {
        super(userService, dateTimeHelperService, printHelper);
        this.printLayoutConfig = printLayoutConfig;
    }

    public byte[] generatePDF(@NonNull QStagePrintInfo printInfo, @NonNull QStagePrintConfiguration printConfiguration, @NonNull EPrintFontSize printFontSize, @NonNull ConfigurationCompany configurationCompany) {
        byte[] byArray;
        block23: {
            if (printInfo == null) {
                throw new NullPointerException("printInfo is marked non-null but is null");
            }
            if (printConfiguration == null) {
                throw new NullPointerException("printConfiguration is marked non-null but is null");
            }
            if (printFontSize == null) {
                throw new NullPointerException("printFontSize is marked non-null but is null");
            }
            if (configurationCompany == null) {
                throw new NullPointerException("configurationCompany is marked non-null but is null");
            }
            PDRectangle mediaBox = new PDRectangle(PDRectangle.A4.getWidth(), PDRectangle.A4.getHeight());
            Iterable responsiblePrintInfos = printInfo.getResponsiblePrintInfos();
            String responsibleUsersFullName = this.concat(responsiblePrintInfos, UserPrintInfo::getFullName);
            PDDocument document = this.document((PrintInfo)printInfo, (PrintConfiguration)printConfiguration, responsibleUsersFullName);
            try {
                PrintSetup printSetup = PrintHelper.printSetup((PrintLayoutConfig)this.printLayoutConfig, (ConfigurationCompany)configurationCompany, (EPrintFontSize)printFontSize, (PDDocument)document, PrintLayoutConfig::getStageLogoPadding, PrintLayoutConfig::getStageLogoHeight, PrintLayoutConfig::getStageLogoFileBuffer);
                PDImageXObject pdImageXObject = PDImageXObject.createFromByteArray((PDDocument)document, (byte[])printSetup.getLogoBuffer(), (String)"");
                Table footer = this.legalCompanyFooter(mediaBox, printSetup);
                Table blankHeaderP1 = this.headersP1(printInfo, pdImageXObject, mediaBox, printSetup, 0, 0);
                Table blankHeaderP2 = this.headersP2(printInfo, pdImageXObject, mediaBox, printSetup, 0, 0);
                float heightHeader0 = blankHeaderP1.getHeight();
                float heightHeader1 = blankHeaderP2.getHeight();
                float maxDetailsHeightFirstPage = QStageLongTextPrintService.maxDetailsHeight((PDRectangle)mediaBox, (float)heightHeader0, (float)footer.getHeight(), (float)10.0f, (float)14.15f, (float)14.15f);
                float maxDetailsHeightRest = QStageLongTextPrintService.maxDetailsHeight((PDRectangle)mediaBox, (float)heightHeader1, (float)0.0f, (float)10.0f, (float)14.15f, (float)14.15f);
                Table details = this.details(printInfo, mediaBox, printSetup);
                Iterable additionalTables = (Iterable)MoreObjects.firstNonNull((Object)printInfo.getAdditionalTables(), (Object)ImmutableSet.of());
                ImmutableList.Builder allTablesBuilder = ImmutableList.builder();
                allTablesBuilder.add((Object)AbstractPrintService.PrintPlanInput.of((String)"details", (Table)details, (boolean)false, (int)3, (float)0.0f));
                additionalTables.forEach(table -> allTablesBuilder.add((Object)AbstractPrintService.PrintPlanInput.of((String)"additionalTables", (Table)table, (boolean)false, (int)0, (float)10.0f)));
                ImmutableList allTables = allTablesBuilder.build();
                Multimap printPlan = QStageLongTextPrintService.printPlan((Iterable)allTables, (float)maxDetailsHeightFirstPage, (float)maxDetailsHeightRest);
                if (details.getRows().isEmpty()) {
                    QStageLongTextPrintService.printEmptyPage((PDDocument)document, (PDRectangle)mediaBox, (List)ImmutableList.of());
                } else {
                    TreeSet pages = Sets.newTreeSet((Iterable)printPlan.keySet());
                    int pageCount = pages.size();
                    for (Integer pageNumber : pages) {
                        ImmutableList headers;
                        if (pageNumber == 0) {
                            Table headersP1 = this.headersP1(printInfo, pdImageXObject, mediaBox, printSetup, 1 + pageNumber, pageCount);
                            headers = ImmutableList.of((Object)headersP1);
                        } else {
                            Table headersP2 = this.headersP2(printInfo, pdImageXObject, mediaBox, printSetup, 1 + pageNumber, pageCount);
                            headers = ImmutableList.of((Object)headersP2);
                        }
                        PDPage pdPage = QStageLongTextPrintService.page((PDDocument)document, (PDRectangle)mediaBox);
                        PDExtendedGraphicsState alpha = new PDExtendedGraphicsState();
                        alpha.setNonStrokingAlphaConstant(Float.valueOf(0.2f));
                        Collection printPlanOutputs = printPlan.get((Object)pageNumber);
                        try (PDPageContentStream contentStream = new PDPageContentStream(document, pdPage);){
                            float yOffset = QStageLongTextPrintService.printHeader((PDPageContentStream)contentStream, (PDPage)pdPage, (Iterable)headers);
                            for (AbstractPrintService.PrintPlanOutput printPlanOutput : printPlanOutputs) {
                                Table table2 = printPlanOutput.getTable();
                                float marginAfterTable = printPlanOutput.getMarginAfterTable();
                                TableDrawer.builder().page(pdPage).contentStream(contentStream).startX(70.75f).startY(yOffset -= marginAfterTable).table(table2).build().draw();
                                yOffset -= table2.getHeight();
                            }
                            if (pageNumber != 0) continue;
                            yOffset -= this.printFooter(contentStream, pdPage, footer);
                        }
                    }
                }
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                document.save((OutputStream)outputStream);
                byArray = outputStream.toByteArray();
                if (document == null) break block23;
            }
            catch (Throwable throwable) {
                try {
                    if (document != null) {
                        try {
                            document.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return new byte[0];
                }
            }
            document.close();
        }
        return byArray;
    }

    @Nonnull
    private String concat(@NonNull Iterable<UserPrintInfo> userPrintInfos, Function<UserPrintInfo, String> fn) {
        if (userPrintInfos == null) {
            throw new NullPointerException("userPrintInfos is marked non-null but is null");
        }
        return Streams.stream(userPrintInfos).filter(Objects::nonNull).map(fn).filter(Objects::nonNull).collect(Collectors.joining(", "));
    }

    @Nonnull
    public PDDocumentInformation apply(@NonNull PDDocumentInformation documentInformation, @NonNull QStagePrintInfo printInfo, @NonNull QStagePrintConfiguration printConfiguration) {
        if (documentInformation == null) {
            throw new NullPointerException("documentInformation is marked non-null but is null");
        }
        if (printInfo == null) {
            throw new NullPointerException("printInfo is marked non-null but is null");
        }
        if (printConfiguration == null) {
            throw new NullPointerException("printConfiguration is marked non-null but is null");
        }
        documentInformation.setKeywords("TODO");
        documentInformation.setTitle(String.format("QUOTATION: %s", UUID.randomUUID()));
        documentInformation.setSubject(String.format("EMPLOYEE: %s", UUID.randomUUID()));
        return documentInformation;
    }

    protected static float maxWidth(@NonNull PDRectangle mediaBox) {
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        return mediaBox.getWidth() - 141.5f;
    }

    protected static float footerMaxWidth(@NonNull PDRectangle mediaBox) {
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        return mediaBox.getWidth() - 141.5f;
    }

    @Nonnull
    private Table headersP1(@NonNull QStagePrintInfo printInfo, @NonNull PDImageXObject pdImageXObject, @NonNull PDRectangle mediaBox, @NonNull PrintSetup printSetup, int page, int pageCount) throws IOException {
        UserPrintInfo responsibleUserPrintInfo;
        String responsibleUserFullName;
        if (printInfo == null) {
            throw new NullPointerException("printInfo is marked non-null but is null");
        }
        if (pdImageXObject == null) {
            throw new NullPointerException("pdImageXObject is marked non-null but is null");
        }
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        CompanyPrintInfo senderPrintInfo = printInfo.getSenderPrintInfo();
        CompanyPrintInfo recipientPrintInfo = printInfo.getRecipientPrintInfo();
        PrintFonts printFonts = printSetup.getPrintFonts();
        PDFont fontBold = printFonts.getBold();
        float header1Width = printSetup.getHeaderColumn1Width().floatValue();
        float header2Width = printSetup.getHeaderColumn2Width().floatValue();
        float header3Width = printSetup.getHeaderColumn3Width().floatValue();
        float header4Width = printSetup.getHeaderColumn4Width().floatValue();
        ImmutableList columnWidths = ImmutableList.of((Object)Float.valueOf(header1Width), (Object)Float.valueOf(header2Width), (Object)Float.valueOf(header3Width), (Object)Float.valueOf(header4Width));
        int columns = columnWidths.size();
        Table.TableBuilder header1Builder = QStageLongTextPrintService.table((Float)Float.valueOf(QStageLongTextPrintService.maxWidth((PDRectangle)mediaBox)), (Iterable)columnWidths);
        header1Builder.addRow(Row.builder().add((AbstractCell)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)ImageCell.builder().horizontalAlignment(HorizontalAlignment.LEFT)).padding(0.0f)).paddingLeft(printSetup.getLogoPaddingLeft())).verticalAlignment(VerticalAlignment.MIDDLE)).image(pdImageXObject).maxHeight((float)printSetup.getLogoHeight()).borderWidth(0.0f)).colSpan(2)).build()).add((AbstractCell)QStageLongTextPrintService.emptyCell((PrintSetup)printSetup)).add((AbstractCell)QStageLongTextPrintService.emptyCell((PrintSetup)printSetup)).build());
        header1Builder.addRow(Row.builder().fontSize(Integer.valueOf(1)).height(Float.valueOf(36.79f)).add((AbstractCell)QStageLongTextPrintService.emptyCell((int)1, (int)4)).build());
        String senderRow1Left = StringUtils.trimToEmpty((String)Joiner.on((String)" ").skipNulls().join((Object)StringUtils.trimToEmpty((String)senderPrintInfo.getCustomerName1()), (Object)StringUtils.trimToEmpty((String)senderPrintInfo.getCustomerName2()), new Object[0]));
        String senderRow2Left = StringUtils.trimToEmpty((String)Joiner.on((String)" ").skipNulls().join((Object)StringUtils.trimToEmpty((String)senderPrintInfo.getCustomerStreet()), (Object)StringUtils.trimToEmpty((String)senderPrintInfo.getCustomerStreetNo()), new Object[0]));
        String senderRow2Right = StringUtils.trimToEmpty((String)Joiner.on((String)" ").skipNulls().join((Object)StringUtils.trimToEmpty((String)senderPrintInfo.getCustomerZipCode()), (Object)StringUtils.trimToEmpty((String)senderPrintInfo.getCustomerCity()), new Object[0]));
        String senderRow2 = String.format("%s | %s", senderRow2Left, senderRow2Right);
        String recipientOriginalRow1 = StringUtils.trimToEmpty((String)recipientPrintInfo.getCustomerName1());
        String recipientOriginalRow2 = StringUtils.trimToEmpty((String)recipientPrintInfo.getCustomerName2());
        String recipientOriginalRow3 = StringUtils.trimToEmpty((String)recipientPrintInfo.getCustomerName3());
        String recipientOriginalRow4 = StringUtils.trimToEmpty((String)Joiner.on((String)" ").skipNulls().join((Object)StringUtils.trimToEmpty((String)recipientPrintInfo.getCustomerStreet()), (Object)StringUtils.trimToEmpty((String)recipientPrintInfo.getCustomerStreetNo()), new Object[0]));
        String recipientOriginalRow5 = StringUtils.trimToEmpty((String)Joiner.on((String)" ").skipNulls().join((Object)StringUtils.trimToEmpty((String)recipientPrintInfo.getCustomerZipCode()), (Object)StringUtils.trimToEmpty((String)recipientPrintInfo.getCustomerCity()), new Object[0]));
        header1Builder.addRow(Row.builder().add((AbstractCell)QStageLongTextPrintService.descriptionCell((int)7, (PrintFonts)printFonts, (Color)TEXT_COLOR, (int)2, (int)2, (String)(senderRow1Left + "\n" + senderRow2))).add((AbstractCell)QStageLongTextPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)"Datum")).add((AbstractCell)QStageLongTextPrintService.emptyCell((PrintSetup)printSetup)).build());
        String referenceDateString = DateTimeHelperService.germanFullDate((LocalDate)printInfo.getSubmissionOfBidDate());
        String dateAndPage = String.format("%s | Seite %s/%s", referenceDateString, page, pageCount);
        header1Builder.addRow(Row.builder().add((AbstractCell)QStageLongTextPrintService.descriptionCell((PrintFonts)printFonts, (int)printSetup.getDetailsFontSize(), (String)dateAndPage, (int)2, (int)1, (Color)TEXT_COLOR, (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)ImmutableMap.of())).build());
        header1Builder.addRow(Row.builder().fontSize(Integer.valueOf(1)).height(Float.valueOf(2.83f)).add((AbstractCell)QStageLongTextPrintService.emptyCell((int)1, (int)4)).build());
        EQStageType qStageType = printInfo.getStageType();
        header1Builder.addRow(Row.builder().add((AbstractCell)QStageLongTextPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)recipientOriginalRow1)).add((AbstractCell)QStageLongTextPrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)"")).add((AbstractCell)QStageLongTextPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)"QNummer")).add((AbstractCell)QStageLongTextPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)printInfo.getStageNumber())).build());
        Iterable responsiblePrintInfos = printInfo.getResponsiblePrintInfos();
        if (!Iterables.isEmpty((Iterable)responsiblePrintInfos) && StringUtils.isNotBlank((CharSequence)(responsibleUserFullName = (responsibleUserPrintInfo = (UserPrintInfo)responsiblePrintInfos.iterator().next()).getFullName()))) {
            header1Builder.addRow(Row.builder().add((AbstractCell)QStageLongTextPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)recipientOriginalRow2)).add((AbstractCell)QStageLongTextPrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)"")).add((AbstractCell)QStageLongTextPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)"Ihr Kontakt")).add((AbstractCell)QStageLongTextPrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)responsibleUserFullName)).build());
        }
        if (StringUtils.isNotBlank((CharSequence)recipientOriginalRow3)) {
            header1Builder.addRow(Row.builder().add((AbstractCell)QStageLongTextPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)recipientOriginalRow3)).add((AbstractCell)QStageLongTextPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (int)3, (String)"")).build());
        }
        header1Builder.addRow(Row.builder().add((AbstractCell)QStageLongTextPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)recipientOriginalRow4)).add((AbstractCell)QStageLongTextPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)"")).add((AbstractCell)QStageLongTextPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (int)2, (String)"Bearbeiter")).build());
        String responsibleFullNames = Joiner.on((String)", ").join(Streams.stream((Iterable)printInfo.getResponsiblePrintInfos()).map(UserPrintInfo::getFullName).filter(StringUtils::isNotBlank).iterator());
        header1Builder.addRow(Row.builder().add((AbstractCell)QStageLongTextPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)recipientOriginalRow5)).add((AbstractCell)QStageLongTextPrintService.emptyCell((PrintSetup)printSetup)).add((AbstractCell)QStageLongTextPrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (int)2, (String)responsibleFullNames)).build());
        LocalDate projectExecutionStartDate = printInfo.getProjectExecutionStartDate();
        LocalDate projectExecutionEndDate = printInfo.getProjectExecutionEndDate();
        String projectExecutionStartDateString = null != projectExecutionStartDate ? DateTimeHelperService.germanDate((LocalDate)projectExecutionStartDate) : "";
        String projectExecutionEndDateString = null != projectExecutionEndDate ? DateTimeHelperService.germanDate((LocalDate)projectExecutionEndDate) : "";
        String projectExecutionPeriod = Joiner.on((String)" - ").skipNulls().join((Object)projectExecutionStartDateString, (Object)projectExecutionEndDateString, new Object[0]);
        header1Builder.addRow(Row.builder().add((AbstractCell)QStageLongTextPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (int)2, (String)"Betreff")).add((AbstractCell)QStageLongTextPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (int)2, (String)"Leistungszeitraum")).build());
        header1Builder.addRow(Row.builder().add((AbstractCell)QStageLongTextPrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (int)2, (String)printInfo.getName())).add((AbstractCell)QStageLongTextPrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (int)2, (String)projectExecutionPeriod)).build());
        header1Builder.addRow(Row.builder().add((AbstractCell)QStageLongTextPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (int)4, (String)"Beschreibung")).build());
        header1Builder.addRow(Row.builder().add((AbstractCell)QStageLongTextPrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (int)4, (String)"TODO")).build());
        header1Builder.addRow(Row.builder().fontSize(Integer.valueOf(1)).height(Float.valueOf(2.83f)).add((AbstractCell)QStageLongTextPrintService.emptyCell((int)1, (int)4)).build());
        header1Builder.addRow(Row.builder().add((AbstractCell)QStageLongTextPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (int)4, (String)"LANGTEXTE", (HorizontalAlignment)HorizontalAlignment.CENTER)).build());
        header1Builder.addRow(Row.builder().fontSize(Integer.valueOf(1)).height(Float.valueOf(2.83f)).add((AbstractCell)QStageLongTextPrintService.emptyCell((int)1, (int)4)).build());
        header1Builder.addRow(Row.builder().fontSize(Integer.valueOf(1)).height(Float.valueOf(8.49f)).add((AbstractCell)QStageLongTextPrintService.emptyCell((int)1, (int)4)).build());
        return header1Builder.build();
    }

    @Nonnull
    private String cashDiscount(@Nullable Integer financeCashDiscountTime, @Nullable BigDecimal financeCashDiscount) {
        if (null != financeCashDiscountTime && null != financeCashDiscount && financeCashDiscount.compareTo(BigDecimal.ZERO) != 0) {
            String discountAsString = PrintHelper.asString((BigDecimal)financeCashDiscount, (String)"0,00", (boolean)true);
            return String.format("%s Tage %s %%", financeCashDiscountTime, discountAsString);
        }
        return "";
    }

    @Nonnull
    private Table headersP2(@NonNull QStagePrintInfo printInfo, @NonNull PDImageXObject pdImageXObject, @NonNull PDRectangle mediaBox, @NonNull PrintSetup printSetup, int page, int pageCount) throws IOException {
        if (printInfo == null) {
            throw new NullPointerException("printInfo is marked non-null but is null");
        }
        if (pdImageXObject == null) {
            throw new NullPointerException("pdImageXObject is marked non-null but is null");
        }
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        PrintFonts printFonts = printSetup.getPrintFonts();
        PDFont fontRegular = printFonts.getRegular();
        PDFont fontBold = printFonts.getBold();
        Table.TableBuilder header1Builder = QStageLongTextPrintService.table((Float)Float.valueOf(QStageLongTextPrintService.maxWidth((PDRectangle)mediaBox)), (Iterable)ImmutableList.of((Object)Float.valueOf(0.67f), (Object)Float.valueOf(0.17f), (Object)Float.valueOf(0.16f)));
        header1Builder.addRow(Row.builder().add((AbstractCell)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)ImageCell.builder().horizontalAlignment(HorizontalAlignment.LEFT)).padding(0.0f)).paddingLeft(printSetup.getLogoPaddingLeft())).verticalAlignment(VerticalAlignment.MIDDLE)).image(pdImageXObject).maxHeight((float)printSetup.getLogoHeight()).borderWidth(0.0f)).build()).add((AbstractCell)QStageLongTextPrintService.emptyCell((PrintSetup)printSetup, (int)2)).build());
        header1Builder.addRow(Row.builder().fontSize(Integer.valueOf(1)).height(Float.valueOf(36.79f)).add((AbstractCell)QStageLongTextPrintService.emptyCell((int)1, (int)3)).build());
        header1Builder.addRow(Row.builder().add((AbstractCell)QStageLongTextPrintService.emptyCell((PrintSetup)printSetup)).add((AbstractCell)QStageLongTextPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (int)2, (String)"Datum")).build());
        String referenceDateString = DateTimeHelperService.germanFullDate((LocalDate)DateTimeHelper.today());
        String dateAndPage = String.format("%s | Seite %s/%s", referenceDateString, page, pageCount);
        header1Builder.addRow(Row.builder().add((AbstractCell)QStageLongTextPrintService.emptyCell((PrintSetup)printSetup)).add((AbstractCell)QStageLongTextPrintService.descriptionCell((PDFont)fontRegular, (int)printSetup.getDetailsFontSize(), (String)dateAndPage, (int)2, (int)1, (Color)TEXT_COLOR, (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)ImmutableMap.of())).build());
        EQStageType eqStageType = printInfo.getStageType();
        String invoiceNumberName = QSTAGE_TYPE_NUMBER_NAMING.getOrDefault(eqStageType, "<name fehlt>");
        header1Builder.addRow(Row.builder().add((AbstractCell)QStageLongTextPrintService.emptyCell((PrintSetup)printSetup)).add((AbstractCell)QStageLongTextPrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (int)2, (String)invoiceNumberName)).build());
        header1Builder.addRow(Row.builder().add((AbstractCell)QStageLongTextPrintService.emptyCell((PrintSetup)printSetup)).add((AbstractCell)QStageLongTextPrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (int)2, (String)printInfo.getStageNumber())).build());
        header1Builder.addRow(Row.builder().add((AbstractCell)QStageLongTextPrintService.emptyCell((PrintSetup)printSetup, (int)3)).build());
        return header1Builder.build();
    }

    protected static float printHeader(@Nonnull PDPageContentStream contentStream, @Nonnull PDPage page, @Nonnull Iterable<Table> headers) {
        PDRectangle mediaBox = page.getMediaBox();
        float yOffset = mediaBox.getHeight() - 14.15f;
        for (Table header : headers) {
            TableDrawer.builder().page(page).contentStream(contentStream).startX(70.75f).startY(yOffset).table(header).build().draw();
            yOffset -= header.getHeight();
        }
        return yOffset;
    }

    private float printFooter(@NonNull PDPageContentStream contentStream, @NonNull PDPage page, @NonNull Table footer) {
        if (contentStream == null) {
            throw new NullPointerException("contentStream is marked non-null but is null");
        }
        if (page == null) {
            throw new NullPointerException("page is marked non-null but is null");
        }
        if (footer == null) {
            throw new NullPointerException("footer is marked non-null but is null");
        }
        float footerHeight = footer.getHeight();
        float yOffset = 14.15f + footerHeight;
        TableDrawer.builder().page(page).contentStream(contentStream).startX(70.75f).startY(yOffset).table(footer).build().draw();
        return yOffset -= footer.getHeight();
    }

    @Nonnull
    private Table details(@NonNull QStagePrintInfo printInfo, @NonNull PDRectangle mediaBox, @NonNull PrintSetup printSetup) {
        if (printInfo == null) {
            throw new NullPointerException("printInfo is marked non-null but is null");
        }
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        PrintFonts printFonts = printSetup.getPrintFonts();
        PDFont fontBold = printFonts.getBold();
        Iterable printGroups = (Iterable)MoreObjects.firstNonNull((Object)printInfo.getPositionPrintGroups(), (Object)ImmutableList.of());
        ImmutableList columnWidths = ImmutableList.of((Object)Float.valueOf(0.125f), (Object)Float.valueOf(0.125f), (Object)Float.valueOf(0.0625f), (Object)Float.valueOf(0.6875f));
        int columnCount = Iterables.size((Iterable)columnWidths);
        Table.TableBuilder tableBuilder = QStageLongTextPrintService.table((Float)Float.valueOf(QStageLongTextPrintService.maxWidth((PDRectangle)mediaBox)), (Iterable)columnWidths);
        tableBuilder.addRow(this.hLineB(columnCount));
        Row headline1 = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)QStageLongTextPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)"Pos.", (HorizontalAlignment)HorizontalAlignment.LEFT)).add((AbstractCell)QStageLongTextPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)"Menge", (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)QStageLongTextPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)"EH", (HorizontalAlignment)HorizontalAlignment.LEFT)).add((AbstractCell)QStageLongTextPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)"Art der Leistung", (HorizontalAlignment)HorizontalAlignment.LEFT)).build();
        tableBuilder.addRow(headline1);
        tableBuilder.addRow(this.hLineT(columnCount));
        for (QStagePositionPrintGroup printGroup : printGroups) {
            Iterable rows = this.printGroupsTables(printSetup, printGroup, columnCount, true);
            rows.forEach(arg_0 -> ((Table.TableBuilder)tableBuilder).addRow(arg_0));
        }
        tableBuilder.addRow(Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)QStageLongTextPrintService.emptyCell((PrintSetup)printSetup, (int)columnCount)).build());
        return tableBuilder.build();
    }

    private Iterable<Row> printGroupsTables(@NonNull PrintSetup printSetup, @NonNull QStagePositionPrintGroup printGroup, int columnCount, boolean printEmptyGroups) {
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        if (printGroup == null) {
            throw new NullPointerException("printGroup is marked non-null but is null");
        }
        ImmutableList.Builder rowBuilder = ImmutableList.builder();
        Iterable sortedRows = printGroup.getSortedRows();
        for (Object item : sortedRows) {
            BigDecimal product = item.getOrderedAmount();
            String unit = item.getUnit();
            String amount = PrintHelper.asString((BigDecimal)product, (String)"", (boolean)true);
            String positionNumber = item.getPositionNumber();
            String shortText = item.getShortText();
            String longText = item.getLongText();
            String bidderComplement = item.getBidderComplement();
            Row detail1 = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)QStageLongTextPrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)positionNumber, (HorizontalAlignment)HorizontalAlignment.LEFT)).add((AbstractCell)QStageLongTextPrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)amount, (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)QStageLongTextPrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)unit, (HorizontalAlignment)HorizontalAlignment.LEFT)).add((AbstractCell)QStageLongTextPrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)shortText, (HorizontalAlignment)HorizontalAlignment.LEFT)).build();
            rowBuilder.add((Object)detail1);
            if (StringUtils.isNotBlank((CharSequence)bidderComplement)) {
                Row detail2 = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)QStageLongTextPrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (int)3, (String)"", (HorizontalAlignment)HorizontalAlignment.LEFT)).add((AbstractCell)QStageLongTextPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)printSetup.getPrintFonts().getItalic(), (Color)TEXT_COLOR, (String)bidderComplement, (HorizontalAlignment)HorizontalAlignment.LEFT)).build();
                rowBuilder.add((Object)detail2);
            }
            List parts = Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)System.lineSeparator())).trimResults().splitToList((CharSequence)longText);
            for (String part : parts) {
                Row detail = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)QStageLongTextPrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)"Langtext:", (HorizontalAlignment)HorizontalAlignment.LEFT)).add((AbstractCell)QStageLongTextPrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (int)3, (String)part, (HorizontalAlignment)HorizontalAlignment.LEFT)).build();
                rowBuilder.add((Object)detail);
            }
        }
        rowBuilder.add((Object)this.hLineB(columnCount));
        Iterable children = (Iterable)MoreObjects.firstNonNull((Object)printGroup.getChildren(), (Object)ImmutableList.of());
        for (QStagePositionPrintGroup child : children) {
            rowBuilder.addAll(this.printGroupsTables(printSetup, child, columnCount, printEmptyGroups));
        }
        if (printGroup.isPrintAsGroup()) {
            String title = printGroup.getName();
            String priceSum = PrintHelper.asString((BigDecimal)printGroup.getPriceWithoutDiscountSum(), (String)"", (boolean)true);
            Row aggregationRow1 = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)QStageLongTextPrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (int)(columnCount - 1), (String)title, (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)QStageLongTextPrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (int)1, (String)priceSum, (HorizontalAlignment)HorizontalAlignment.RIGHT)).build();
            rowBuilder.add((Object)aggregationRow1);
            rowBuilder.add((Object)this.hLineB(columnCount));
            Row blankRow = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)QStageLongTextPrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (int)columnCount, (String)"", (HorizontalAlignment)HorizontalAlignment.LEFT)).build();
            rowBuilder.add((Object)blankRow);
        }
        return rowBuilder.build();
    }

    protected static float maxDetailsHeight(PDRectangle mediaBox, float headerHeight, float footerHeight, float optionalNeededSpace, float marginTop, float marginBottom) {
        return mediaBox.getHeight() - (marginTop + marginBottom + headerHeight + 10.0f + footerHeight + optionalNeededSpace);
    }
}

