/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service.print;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import de.qfm.erp.service.configuration.PrintLayoutConfig;
import de.qfm.erp.service.model.internal.print.CompanyPrintInfo;
import de.qfm.erp.service.model.internal.print.EPrintFontSize;
import de.qfm.erp.service.model.internal.print.PrintConfiguration;
import de.qfm.erp.service.model.internal.print.PrintFonts;
import de.qfm.erp.service.model.internal.print.PrintInfo;
import de.qfm.erp.service.model.internal.print.PrintSetup;
import de.qfm.erp.service.model.internal.print.UserPrintInfo;
import de.qfm.erp.service.model.internal.print.qentity.QStagePositionPrintGroup;
import de.qfm.erp.service.model.internal.print.qentity.QStagePositionPrintRow;
import de.qfm.erp.service.model.internal.print.qentity.QStagePrintConfiguration;
import de.qfm.erp.service.model.internal.print.qentity.QStagePrintInfo;
import de.qfm.erp.service.model.jpa.configuration.ConfigurationCompany;
import de.qfm.erp.service.model.jpa.quotation.EQStageType;
import de.qfm.erp.service.model.jpa.quotation.EStagePrintBoilerPlate;
import de.qfm.erp.service.model.jpa.shared.EAlternativePositionType;
import de.qfm.erp.service.service.route.impl.PrintHelper;
import de.qfm.erp.service.service.security.UserService;
import de.qfm.erp.service.service.service.DateTimeHelperService;
import de.qfm.erp.service.service.service.MessageService;
import de.qfm.erp.service.service.service.print.AbstractPrintService;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.vandeseer.easytable.TableDrawer;
import org.vandeseer.easytable.settings.HorizontalAlignment;
import org.vandeseer.easytable.settings.VerticalAlignment;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.ImageCell;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class QStageCalculationPrintService
extends AbstractPrintService<QStagePrintInfo, QStagePrintConfiguration> {
    private static final Logger log = LogManager.getLogger(QStageCalculationPrintService.class);
    protected static final float MM_PER_UNIT = 2.83f;
    protected static final float STAGE_MARGIN_LEFT_RIGHT = 70.75f;
    protected static final float STAGE_MARGIN_TOP_BOTTOM = 48.11f;
    protected static final float LOGO_HEADER_DISTANCE = 36.79f;
    protected static final float HEADER_TEXT_SPACE = 2.83f;
    protected static final Color TEXT_COLOR = Color.BLACK;
    protected static final int RECIPIENT_FONT_SIZE = 8;
    protected static final int META_FONT_SIZE = 8;
    private static final Map<EQStageType, String> QSTAGE_TYPE_NUMBER_NAMING = ImmutableMap.builder().put((Object)EQStageType.INQUIRY, (Object)"Anfrage").put((Object)EQStageType.CALCULATION, (Object)"Kalkulation").put((Object)EQStageType.QUOTATION, (Object)"Angebot").put((Object)EQStageType.COMMISSION, (Object)"Auftrag").put((Object)EQStageType.COMMISSION__ADDENDUM, (Object)"Nachtrag").put((Object)EQStageType.COMMISSION__COST_ESTIMATE, (Object)"Kostensch\u00e4tzung").put((Object)EQStageType.COMMISSION__COST_UNIT, (Object)"Unterkostentr\u00e4ger").put((Object)EQStageType.COMMISSION__COST_UNIT__CE, (Object)"Unterkostentr\u00e4ger").build();
    private final MessageService messageService;
    private final PrintLayoutConfig printLayoutConfig;

    @Autowired
    public QStageCalculationPrintService(MessageService messageService, UserService userService, DateTimeHelperService dateTimeHelperService, PrintHelper printHelper, PrintLayoutConfig printLayoutConfig) {
        super(userService, dateTimeHelperService, printHelper);
        this.messageService = messageService;
        this.printLayoutConfig = printLayoutConfig;
    }

    public byte[] generatePDF(@NonNull QStagePrintInfo printInfo, @NonNull QStagePrintConfiguration printConfiguration, @NonNull EPrintFontSize printFontSize, @NonNull ConfigurationCompany configurationCompany) {
        byte[] byArray;
        block23: {
            if (printInfo == null) {
                throw new NullPointerException("printInfo is marked non-null but is null");
            }
            if (printConfiguration == null) {
                throw new NullPointerException("printConfiguration is marked non-null but is null");
            }
            if (printFontSize == null) {
                throw new NullPointerException("printFontSize is marked non-null but is null");
            }
            if (configurationCompany == null) {
                throw new NullPointerException("configurationCompany is marked non-null but is null");
            }
            PDRectangle mediaBox = new PDRectangle(PDRectangle.A4.getHeight(), PDRectangle.A4.getWidth());
            Iterable responsiblePrintInfos = printInfo.getResponsiblePrintInfos();
            String responsibleUsersFullName = this.concat(responsiblePrintInfos, UserPrintInfo::getFullName);
            PDDocument document = this.document((PrintInfo)printInfo, (PrintConfiguration)printConfiguration, responsibleUsersFullName);
            try {
                PrintSetup printSetup = PrintHelper.printSetup((PrintLayoutConfig)this.printLayoutConfig, (ConfigurationCompany)configurationCompany, (EPrintFontSize)printFontSize, (PDDocument)document, PrintLayoutConfig::getStageLogoPadding, PrintLayoutConfig::getStageLogoHeight, PrintLayoutConfig::getStageLogoFileBuffer);
                PDImageXObject pdImageXObject = PDImageXObject.createFromByteArray((PDDocument)document, (byte[])printSetup.getLogoBuffer(), (String)"");
                Table blankHeaderP1 = this.headersP1(printInfo, pdImageXObject, mediaBox, printSetup, 0, 0);
                Table blankHeaderP2 = this.headersP2(printInfo, pdImageXObject, mediaBox, printSetup, 0, 0);
                float heightHeader0 = blankHeaderP1.getHeight();
                float heightHeader1 = blankHeaderP2.getHeight();
                float maxDetailsHeightFirstPage = QStageCalculationPrintService.maxDetailsHeight((PDRectangle)mediaBox, (float)heightHeader0, (float)0.0f, (float)10.0f, (float)48.11f, (float)48.11f);
                float maxDetailsHeightRest = QStageCalculationPrintService.maxDetailsHeight((PDRectangle)mediaBox, (float)heightHeader1, (float)0.0f, (float)10.0f, (float)48.11f, (float)48.11f);
                Table details = this.details(printInfo, printConfiguration, mediaBox, printSetup);
                Iterable additionalTables = (Iterable)MoreObjects.firstNonNull((Object)printInfo.getAdditionalTables(), (Object)ImmutableSet.of());
                ImmutableList.Builder allTablesBuilder = ImmutableList.builder();
                allTablesBuilder.add((Object)AbstractPrintService.PrintPlanInput.of((String)"details", (Table)details, (boolean)false, (int)3, (float)0.0f));
                additionalTables.forEach(table -> allTablesBuilder.add((Object)AbstractPrintService.PrintPlanInput.of((String)"table", (Table)table, (boolean)false, (int)0, (float)10.0f)));
                ImmutableList allTables = allTablesBuilder.build();
                Multimap printPlan = QStageCalculationPrintService.printPlan((Iterable)allTables, (float)maxDetailsHeightFirstPage, (float)maxDetailsHeightRest);
                if (details.getRows().isEmpty()) {
                    QStageCalculationPrintService.printEmptyPage((PDDocument)document, (PDRectangle)mediaBox, (List)ImmutableList.of());
                } else {
                    TreeSet pages = Sets.newTreeSet((Iterable)printPlan.keySet());
                    int pageCount = pages.size();
                    for (Integer pageNumber : pages) {
                        ImmutableList headers;
                        if (pageNumber == 0) {
                            Table headersP1 = this.headersP1(printInfo, pdImageXObject, mediaBox, printSetup, 1 + pageNumber, pageCount);
                            headers = ImmutableList.of((Object)headersP1);
                        } else {
                            Table headersP2 = this.headersP2(printInfo, pdImageXObject, mediaBox, printSetup, 1 + pageNumber, pageCount);
                            headers = ImmutableList.of((Object)headersP2);
                        }
                        PDPage pdPage = QStageCalculationPrintService.page((PDDocument)document, (PDRectangle)mediaBox);
                        PDExtendedGraphicsState alpha = new PDExtendedGraphicsState();
                        alpha.setNonStrokingAlphaConstant(Float.valueOf(0.2f));
                        Collection printPlanOutputs = printPlan.get((Object)pageNumber);
                        try (PDPageContentStream contentStream = new PDPageContentStream(document, pdPage);){
                            float yOffset = QStageCalculationPrintService.printHeader((PDPageContentStream)contentStream, (PDPage)pdPage, (Iterable)headers);
                            for (AbstractPrintService.PrintPlanOutput printPlanOutput : printPlanOutputs) {
                                Table table2 = printPlanOutput.getTable();
                                float marginAfterTable = printPlanOutput.getMarginAfterTable();
                                TableDrawer.builder().page(pdPage).contentStream(contentStream).startX(70.75f).startY(yOffset -= marginAfterTable).table(table2).build().draw();
                                yOffset -= table2.getHeight();
                            }
                        }
                    }
                }
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                document.save((OutputStream)outputStream);
                byArray = outputStream.toByteArray();
                if (document == null) break block23;
            }
            catch (Throwable throwable) {
                try {
                    if (document != null) {
                        try {
                            document.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return new byte[0];
                }
            }
            document.close();
        }
        return byArray;
    }

    @Nonnull
    private String concat(@NonNull Iterable<UserPrintInfo> userPrintInfos, Function<UserPrintInfo, String> fn) {
        if (userPrintInfos == null) {
            throw new NullPointerException("userPrintInfos is marked non-null but is null");
        }
        return Streams.stream(userPrintInfos).filter(Objects::nonNull).map(fn).filter(Objects::nonNull).collect(Collectors.joining(", "));
    }

    @Nonnull
    public PDDocumentInformation apply(@NonNull PDDocumentInformation documentInformation, @NonNull QStagePrintInfo printInfo, @NonNull QStagePrintConfiguration printConfiguration) {
        if (documentInformation == null) {
            throw new NullPointerException("documentInformation is marked non-null but is null");
        }
        if (printInfo == null) {
            throw new NullPointerException("printInfo is marked non-null but is null");
        }
        if (printConfiguration == null) {
            throw new NullPointerException("printConfiguration is marked non-null but is null");
        }
        documentInformation.setKeywords("TODO");
        documentInformation.setTitle(String.format("QUOTATION: %s", UUID.randomUUID()));
        documentInformation.setSubject(String.format("EMPLOYEE: %s", UUID.randomUUID()));
        return documentInformation;
    }

    protected static float maxWidth(@NonNull PDRectangle mediaBox) {
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        return mediaBox.getWidth() - 141.5f;
    }

    @Nonnull
    private Table headersP1(@NonNull QStagePrintInfo printInfo, @NonNull PDImageXObject pdImageXObject, @NonNull PDRectangle mediaBox, @NonNull PrintSetup printSetup, int page, int pageCount) throws IOException {
        if (printInfo == null) {
            throw new NullPointerException("printInfo is marked non-null but is null");
        }
        if (pdImageXObject == null) {
            throw new NullPointerException("pdImageXObject is marked non-null but is null");
        }
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        CompanyPrintInfo recipientPrintInfo = printInfo.getRecipientPrintInfo();
        PrintFonts printFonts = printSetup.getPrintFonts();
        PDFont fontRegular = printFonts.getRegular();
        PDFont fontBold = printFonts.getBold();
        float header1Width = printSetup.getHeaderColumn1Width().floatValue();
        float header2Width = printSetup.getHeaderColumn2Width().floatValue();
        float header3Width = printSetup.getHeaderColumn3Width().floatValue();
        float header4Width = printSetup.getHeaderColumn4Width().floatValue();
        ImmutableList columnWidths = ImmutableList.of((Object)Float.valueOf(header1Width), (Object)Float.valueOf(header2Width), (Object)Float.valueOf(header3Width), (Object)Float.valueOf(header4Width));
        int columns = columnWidths.size();
        Table.TableBuilder header1Builder = QStageCalculationPrintService.table((Float)Float.valueOf(QStageCalculationPrintService.maxWidth((PDRectangle)mediaBox)), (Iterable)columnWidths);
        header1Builder.addRow(Row.builder().add((AbstractCell)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)ImageCell.builder().horizontalAlignment(HorizontalAlignment.LEFT)).padding(0.0f)).paddingLeft(printSetup.getLogoPaddingLeft())).verticalAlignment(VerticalAlignment.MIDDLE)).image(pdImageXObject).maxHeight((float)printSetup.getLogoHeight()).borderWidth(0.0f)).colSpan(2)).build()).add((AbstractCell)QStageCalculationPrintService.emptyCell((int)8, (int)2)).build());
        header1Builder.addRow(Row.builder().fontSize(Integer.valueOf(1)).height(Float.valueOf(36.79f)).add((AbstractCell)QStageCalculationPrintService.emptyCell((int)1, (int)columns)).build());
        String recipientOriginalRow1 = StringUtils.trimToEmpty((String)recipientPrintInfo.getCustomerName1());
        String recipientOriginalRow2 = StringUtils.trimToEmpty((String)recipientPrintInfo.getCustomerName2());
        String recipientOriginalRow3 = StringUtils.trimToEmpty((String)recipientPrintInfo.getCustomerName3());
        String recipientOriginalRow4 = StringUtils.trimToEmpty((String)Joiner.on((String)" ").skipNulls().join((Object)StringUtils.trimToEmpty((String)recipientPrintInfo.getCustomerStreet()), (Object)StringUtils.trimToEmpty((String)recipientPrintInfo.getCustomerStreetNo()), new Object[0]));
        String recipientOriginalRow5 = StringUtils.trimToEmpty((String)Joiner.on((String)" ").skipNulls().join((Object)StringUtils.trimToEmpty((String)recipientPrintInfo.getCustomerZipCode()), (Object)StringUtils.trimToEmpty((String)recipientPrintInfo.getCustomerCity()), new Object[0]));
        header1Builder.addRow(Row.builder().add((AbstractCell)QStageCalculationPrintService.descriptionCell((int)8, (PDFont)fontBold, (Color)TEXT_COLOR, (String)recipientOriginalRow1)).add((AbstractCell)QStageCalculationPrintService.descriptionCell((int)8, (PDFont)fontBold, (Color)TEXT_COLOR, (String)"")).add((AbstractCell)QStageCalculationPrintService.descriptionCell((int)8, (PDFont)fontBold, (Color)TEXT_COLOR, (String)"Datum")).add((AbstractCell)QStageCalculationPrintService.emptyCell((int)8)).build());
        String pageString = this.messageService.get(EStagePrintBoilerPlate.GENERIC__PAGE);
        String referenceDateString = DateTimeHelperService.germanFullDate((LocalDate)printInfo.getSubmissionOfBidDate());
        String dateAndPage = String.format("%s | %s %s/%s", referenceDateString, pageString, page, pageCount);
        header1Builder.addRow(Row.builder().add((AbstractCell)QStageCalculationPrintService.descriptionCell((int)8, (PDFont)fontBold, (Color)TEXT_COLOR, (String)recipientOriginalRow2)).add((AbstractCell)QStageCalculationPrintService.descriptionCell((int)8, (PDFont)fontBold, (Color)TEXT_COLOR, (String)"")).add((AbstractCell)QStageCalculationPrintService.descriptionCell((int)8, (PDFont)fontRegular, (Color)TEXT_COLOR, (String)dateAndPage)).add((AbstractCell)QStageCalculationPrintService.emptyCell((int)8)).build());
        if (StringUtils.isNotBlank((CharSequence)recipientOriginalRow3)) {
            header1Builder.addRow(Row.builder().add((AbstractCell)QStageCalculationPrintService.descriptionCell((int)8, (PDFont)fontBold, (Color)TEXT_COLOR, (String)recipientOriginalRow3)).add((AbstractCell)QStageCalculationPrintService.descriptionCell((int)8, (PDFont)fontBold, (Color)TEXT_COLOR, (String)"")).add((AbstractCell)QStageCalculationPrintService.descriptionCell((int)8, (PDFont)fontRegular, (Color)TEXT_COLOR, (String)dateAndPage)).add((AbstractCell)QStageCalculationPrintService.emptyCell((int)8)).build());
        }
        header1Builder.addRow(Row.builder().fontSize(Integer.valueOf(1)).height(Float.valueOf(2.83f)).add((AbstractCell)QStageCalculationPrintService.emptyCell((int)1, (int)columns)).build());
        String yourReferenceLabel = this.messageService.get(EStagePrintBoilerPlate.STAGE__YOUR_REFERENCE_LABEL);
        header1Builder.addRow(Row.builder().add((AbstractCell)QStageCalculationPrintService.descriptionCell((int)8, (PDFont)fontBold, (Color)TEXT_COLOR, (String)recipientOriginalRow4)).add((AbstractCell)QStageCalculationPrintService.descriptionCell((int)8, (PDFont)fontBold, (Color)TEXT_COLOR, (String)"")).add((AbstractCell)QStageCalculationPrintService.descriptionCell((int)8, (PDFont)fontBold, (Color)TEXT_COLOR, (int)2, (VerticalAlignment)VerticalAlignment.BOTTOM, (String)yourReferenceLabel)).build());
        header1Builder.addRow(Row.builder().add((AbstractCell)QStageCalculationPrintService.descriptionCell((int)8, (PDFont)fontBold, (Color)TEXT_COLOR, (String)recipientOriginalRow5)).add((AbstractCell)QStageCalculationPrintService.descriptionCell((int)8, (PDFont)fontBold, (Color)TEXT_COLOR, (String)"")).add((AbstractCell)QStageCalculationPrintService.descriptionCell((int)8, (PDFont)fontRegular, (Color)TEXT_COLOR, (int)2, (String)printInfo.getStageNumber())).build());
        header1Builder.addRow(Row.builder().fontSize(Integer.valueOf(1)).height(Float.valueOf(2.83f)).add((AbstractCell)QStageCalculationPrintService.emptyCell((int)1, (int)columns)).build());
        String orderDescriptionInternal = printInfo.getOrderDescriptionInternal();
        header1Builder.addRow(Row.builder().add((AbstractCell)QStageCalculationPrintService.descriptionCell((int)8, (PDFont)fontBold, (Color)TEXT_COLOR, (int)columns, (String)"Auftragsbezeichnung")).build());
        header1Builder.addRow(Row.builder().add((AbstractCell)QStageCalculationPrintService.descriptionCell((int)8, (PrintFonts)printFonts, (Color)TEXT_COLOR, (int)columns, (String)orderDescriptionInternal)).build());
        header1Builder.addRow(Row.builder().add((AbstractCell)QStageCalculationPrintService.descriptionCell((int)8, (PDFont)fontBold, (Color)TEXT_COLOR, (int)columns, (String)"Angebotskalkulation / internes Angebot", (HorizontalAlignment)HorizontalAlignment.CENTER)).build());
        return header1Builder.build();
    }

    @Nonnull
    private Table headersP2(@NonNull QStagePrintInfo printInfo, @NonNull PDImageXObject pdImageXObject, @NonNull PDRectangle mediaBox, @NonNull PrintSetup printSetup, int page, int pageCount) throws IOException {
        if (printInfo == null) {
            throw new NullPointerException("printInfo is marked non-null but is null");
        }
        if (pdImageXObject == null) {
            throw new NullPointerException("pdImageXObject is marked non-null but is null");
        }
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        PrintFonts printFonts = printSetup.getPrintFonts();
        PDFont fontRegular = printFonts.getRegular();
        PDFont fontBold = printFonts.getBold();
        Table.TableBuilder header1Builder = QStageCalculationPrintService.table((Float)Float.valueOf(QStageCalculationPrintService.maxWidth((PDRectangle)mediaBox)), (Iterable)ImmutableList.of((Object)Float.valueOf(0.67f), (Object)Float.valueOf(0.17f), (Object)Float.valueOf(0.16f)));
        header1Builder.addRow(Row.builder().add((AbstractCell)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)ImageCell.builder().horizontalAlignment(HorizontalAlignment.LEFT)).padding(0.0f)).paddingLeft(printSetup.getLogoPaddingLeft())).verticalAlignment(VerticalAlignment.MIDDLE)).image(pdImageXObject).maxHeight((float)printSetup.getLogoHeight()).borderWidth(0.0f)).rowSpan(4)).build()).add((AbstractCell)QStageCalculationPrintService.descriptionCell((int)8, (PDFont)fontBold, (Color)TEXT_COLOR, (String)"Datum")).add((AbstractCell)QStageCalculationPrintService.emptyCell((int)8)).build());
        String referenceDateString = DateTimeHelperService.germanFullDate((LocalDate)printInfo.getSubmissionOfBidDate());
        String dateAndPage = String.format("%s | Seite %s/%s", referenceDateString, page, pageCount);
        header1Builder.addRow(Row.builder().add((AbstractCell)QStageCalculationPrintService.descriptionCell((PDFont)fontRegular, (int)8, (String)dateAndPage, (int)2, (int)1, (Color)TEXT_COLOR, (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)ImmutableMap.of())).build());
        EQStageType eqStageType = printInfo.getStageType();
        String stageTypeName = QSTAGE_TYPE_NUMBER_NAMING.getOrDefault(eqStageType, "<name fehlt>");
        header1Builder.addRow(Row.builder().add((AbstractCell)QStageCalculationPrintService.descriptionCell((int)8, (PDFont)fontRegular, (Color)TEXT_COLOR, (int)2, (String)stageTypeName)).build());
        header1Builder.addRow(Row.builder().add((AbstractCell)QStageCalculationPrintService.descriptionCell((int)8, (PDFont)fontRegular, (Color)TEXT_COLOR, (int)2, (String)printInfo.getStageNumber())).build());
        header1Builder.addRow(Row.builder().add((AbstractCell)QStageCalculationPrintService.emptyCell((int)8, (int)3)).build());
        return header1Builder.build();
    }

    protected static float printHeader(@Nonnull PDPageContentStream contentStream, @Nonnull PDPage page, @Nonnull Iterable<Table> headers) {
        PDRectangle mediaBox = page.getMediaBox();
        float yOffset = mediaBox.getHeight() - 48.11f;
        for (Table header : headers) {
            TableDrawer.builder().page(page).contentStream(contentStream).startX(70.75f).startY(yOffset).table(header).build().draw();
            yOffset -= header.getHeight();
        }
        return yOffset;
    }

    @Nonnull
    private Table details(@NonNull QStagePrintInfo printInfo, @NonNull QStagePrintConfiguration printConfiguration, @NonNull PDRectangle mediaBox, @NonNull PrintSetup printSetup) {
        if (printInfo == null) {
            throw new NullPointerException("printInfo is marked non-null but is null");
        }
        if (printConfiguration == null) {
            throw new NullPointerException("printConfiguration is marked non-null but is null");
        }
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        PrintFonts printFonts = printSetup.getPrintFonts();
        PDFont fontBold = printFonts.getBold();
        BigDecimal materialPurchasePriceSum = printInfo.getMaterialPurchasePriceSum();
        BigDecimal materialSellingPriceSum = printInfo.getMaterialSellingPriceSum();
        BigDecimal materialPercentageWAvgOrig = printInfo.getMaterialPercentageWeightedAverage();
        BigDecimal materialPercentageWAvg = BigDecimal.ZERO.compareTo(materialPercentageWAvgOrig) == 0 ? BigDecimal.ZERO : materialPercentageWAvgOrig.subtract(BigDecimal.valueOf(100L));
        String materialPurchasePriceSumString = PrintHelper.asString((BigDecimal)materialPurchasePriceSum, (String)"", (boolean)true);
        String materialSellingPriceSumString = PrintHelper.asString((BigDecimal)materialSellingPriceSum, (String)"", (boolean)true);
        String materialSurplusString = PrintHelper.asPercentage((BigDecimal)materialPercentageWAvg, (String)"", (boolean)true);
        BigDecimal squadWageSum = printInfo.getSquadWageSum();
        BigDecimal companyWageSum = printInfo.getCompanyWageSum();
        BigDecimal wagePercentageWAvg = printInfo.getWagePercentageWeightedAverage();
        String squadWageSumString = PrintHelper.asString((BigDecimal)squadWageSum, (String)"", (boolean)true);
        String companyWageSumString = PrintHelper.asString((BigDecimal)companyWageSum, (String)"", (boolean)true);
        String wageFactorString = PrintHelper.asString((BigDecimal)wagePercentageWAvg.divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP), (String)"", (boolean)true);
        BigDecimal externalServicePurchasePriceSum = printInfo.getExternalServicePurchasePriceSum();
        BigDecimal externalServiceSellingPriceSum = printInfo.getExternalServiceSellingPriceSum();
        BigDecimal externalServiceWAvgOrig = printInfo.getExternalServicePercentageWeightedAverage();
        BigDecimal externalServiceWAvg = BigDecimal.ZERO.compareTo(externalServiceWAvgOrig) == 0 ? BigDecimal.ZERO : externalServiceWAvgOrig.subtract(BigDecimal.valueOf(100L));
        String externalServicePurchasePriceSumString = PrintHelper.asString((BigDecimal)externalServicePurchasePriceSum, (String)"", (boolean)true);
        String externalServiceSellingPriceSumString = PrintHelper.asString((BigDecimal)externalServiceSellingPriceSum, (String)"", (boolean)true);
        String externalServiceFactorString = PrintHelper.asPercentage((BigDecimal)externalServiceWAvg, (String)"", (boolean)true);
        BigDecimal sellingPriceSum = printInfo.getPriceWithoutDiscountSum();
        String sellingPriceSumString = PrintHelper.asString((BigDecimal)sellingPriceSum, (String)"", (boolean)true);
        Iterable printGroups = (Iterable)MoreObjects.firstNonNull((Object)printInfo.getPositionPrintGroups(), (Object)ImmutableList.of());
        ImmutableList columnWidths = ImmutableList.of((Object)Float.valueOf(0.0625f), (Object)Float.valueOf(0.0625f), (Object)Float.valueOf(0.125f), (Object)Float.valueOf(0.0625f), (Object)Float.valueOf(0.0625f), (Object)Float.valueOf(0.0625f), (Object)Float.valueOf(0.0625f), (Object)Float.valueOf(0.0625f), (Object)Float.valueOf(0.0625f), (Object)Float.valueOf(0.0625f), (Object)Float.valueOf(0.0625f), (Object)Float.valueOf(0.0625f), (Object[])new Float[]{Float.valueOf(0.0625f), Float.valueOf(0.0625f)});
        int columnCount = Iterables.size((Iterable)columnWidths);
        Table.TableBuilder tableBuilder = QStageCalculationPrintService.table((Float)Float.valueOf(QStageCalculationPrintService.maxWidth((PDRectangle)mediaBox)), (Iterable)columnWidths);
        tableBuilder.addRow(this.hLineB(columnCount));
        Row headline1a = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)QStageCalculationPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)"", (HorizontalAlignment)HorizontalAlignment.LEFT)).add((AbstractCell)QStageCalculationPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)"", (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)QStageCalculationPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)"", (HorizontalAlignment)HorizontalAlignment.LEFT)).add((AbstractCell)QStageCalculationPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (int)3, (String)"Material", (HorizontalAlignment)HorizontalAlignment.CENTER)).add((AbstractCell)QStageCalculationPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (int)3, (String)"Lohn", (HorizontalAlignment)HorizontalAlignment.CENTER)).add((AbstractCell)QStageCalculationPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (int)3, (String)"Fremdleistung", (HorizontalAlignment)HorizontalAlignment.CENTER)).add((AbstractCell)QStageCalculationPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)"", (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)QStageCalculationPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)"", (HorizontalAlignment)HorizontalAlignment.RIGHT)).build();
        tableBuilder.addRow(headline1a);
        Row headline1b = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)QStageCalculationPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)"Pos.", (HorizontalAlignment)HorizontalAlignment.LEFT)).add((AbstractCell)QStageCalculationPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)"Menge", (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)QStageCalculationPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)"Bezeichnung", (HorizontalAlignment)HorizontalAlignment.LEFT)).add((AbstractCell)QStageCalculationPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)"EK", (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)QStageCalculationPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)"Aufschlag", (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)QStageCalculationPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)"VK", (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)QStageCalculationPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)"EL", (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)QStageCalculationPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)"Faktor", (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)QStageCalculationPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)"FL", (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)QStageCalculationPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)"EK", (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)QStageCalculationPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)"Aufschlag", (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)QStageCalculationPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)"VK", (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)QStageCalculationPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)"EP", (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)QStageCalculationPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)"GP", (HorizontalAlignment)HorizontalAlignment.RIGHT)).build();
        tableBuilder.addRow(headline1b);
        tableBuilder.addRow(this.hLineT(columnCount));
        Row headline2 = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)QStageCalculationPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (int)3, (String)"Gesamtsumme/Faktor", (HorizontalAlignment)HorizontalAlignment.LEFT)).add((AbstractCell)QStageCalculationPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)materialPurchasePriceSumString, (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)QStageCalculationPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)materialSurplusString, (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)QStageCalculationPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)materialSellingPriceSumString, (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)QStageCalculationPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)squadWageSumString, (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)QStageCalculationPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)wageFactorString, (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)QStageCalculationPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)companyWageSumString, (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)QStageCalculationPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)externalServicePurchasePriceSumString, (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)QStageCalculationPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)externalServiceFactorString, (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)QStageCalculationPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)externalServiceSellingPriceSumString, (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)QStageCalculationPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)"", (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)QStageCalculationPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)sellingPriceSumString, (HorizontalAlignment)HorizontalAlignment.RIGHT)).build();
        tableBuilder.addRow(headline2);
        tableBuilder.addRow(this.hLineT(columnCount));
        for (QStagePositionPrintGroup printGroup : printGroups) {
            Iterable rows = this.printGroupsTables(printSetup, columnCount, printGroup, true);
            rows.forEach(arg_0 -> ((Table.TableBuilder)tableBuilder).addRow(arg_0));
        }
        tableBuilder.addRow(Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)QStageCalculationPrintService.emptyCell((PrintSetup)printSetup, (int)columnCount)).build());
        return tableBuilder.build();
    }

    @Nonnull
    private Iterable<Row> printGroupsTables(@NonNull PrintSetup printSetup, int columnCount, @NonNull QStagePositionPrintGroup printGroup, boolean printEmptyGroups) {
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        if (printGroup == null) {
            throw new NullPointerException("printGroup is marked non-null but is null");
        }
        if (!printEmptyGroups && printGroup.isEmpty()) {
            return ImmutableList.of();
        }
        PDFont fontBold = printSetup.getPrintFonts().getBold();
        ImmutableList.Builder rowBuilder = ImmutableList.builder();
        Iterable sortedRows = printGroup.getSortedRows();
        if (printGroup.isPrintAsGroup()) {
            String title = printGroup.getName();
            Row groupRow = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)QStageCalculationPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (int)columnCount, (String)title, (HorizontalAlignment)HorizontalAlignment.LEFT)).build();
            rowBuilder.add((Object)groupRow);
        }
        for (QStagePositionPrintRow printRow : sortedRows) {
            BigDecimal product = printRow.getOrderedAmount();
            String amount = PrintHelper.asString((BigDecimal)product, (String)"", (boolean)true);
            String squadWagePerUnit = PrintHelper.asString((BigDecimal)printRow.getSquadWagePerUnit(), (String)"", (boolean)false);
            BigDecimal wagePercentage = printRow.getWagePercentage();
            String wageFactorString = null != wagePercentage ? PrintHelper.asString((BigDecimal)wagePercentage.divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP), (String)"", (boolean)true) : "";
            String companyWagePerUnit = PrintHelper.asString((BigDecimal)printRow.getCompanyWagePerUnit(), (String)"", (boolean)false);
            String materialPurchasePricePerUnit = PrintHelper.asString((BigDecimal)printRow.getMaterialPurchasePricePerUnit(), (String)"", (boolean)true);
            BigDecimal materialPercentage = printRow.getMaterialPercentage();
            String materialSurplusString = null != materialPercentage ? PrintHelper.asPercentage((BigDecimal)materialPercentage.subtract(BigDecimal.valueOf(100L)), (String)"", (boolean)true) : "";
            String materialSellingPricePerUnit = PrintHelper.asString((BigDecimal)printRow.getMaterialSellingPricePerUnit(), (String)"", (boolean)true);
            String externalServicePurchasePricePerUnit = PrintHelper.asString((BigDecimal)printRow.getExternalServicePurchasePricePerUnit(), (String)"", (boolean)true);
            BigDecimal externalServicePercentage = printRow.getExternalServicePercentage();
            String externalServiceSurplusString = null != externalServicePercentage ? PrintHelper.asPercentage((BigDecimal)externalServicePercentage.subtract(BigDecimal.valueOf(100L)), (String)"", (boolean)true) : "";
            String externalServiceSellingPricePerUnit = PrintHelper.asString((BigDecimal)printRow.getExternalServiceSellingPricePerUnit(), (String)"", (boolean)true);
            EAlternativePositionType alternativePositionType = (EAlternativePositionType)MoreObjects.firstNonNull((Object)printRow.getAlternativePositionType(), (Object)EAlternativePositionType.NO);
            boolean flagAlternativePosition = EAlternativePositionType.YES__EXCLUDE_FROM_CALCULATION == alternativePositionType;
            String pricePerUnit = PrintHelper.asString((BigDecimal)printRow.getPricePerUnit(), (String)"", (boolean)true);
            String priceAggregated = flagAlternativePosition ? "NEP" : PrintHelper.asString((BigDecimal)printRow.getPriceAggregated(), (String)"", (boolean)true);
            String positionNumber = printRow.getPositionNumber();
            String shortText = printRow.getShortText();
            Row detail = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)QStageCalculationPrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)positionNumber, (HorizontalAlignment)HorizontalAlignment.LEFT)).add((AbstractCell)QStageCalculationPrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)amount, (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)QStageCalculationPrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)shortText, (HorizontalAlignment)HorizontalAlignment.LEFT)).add((AbstractCell)QStageCalculationPrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)materialPurchasePricePerUnit, (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)QStageCalculationPrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)materialSurplusString, (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)QStageCalculationPrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)materialSellingPricePerUnit, (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)QStageCalculationPrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)squadWagePerUnit, (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)QStageCalculationPrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)wageFactorString, (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)QStageCalculationPrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)companyWagePerUnit, (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)QStageCalculationPrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)externalServicePurchasePricePerUnit, (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)QStageCalculationPrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)externalServiceSurplusString, (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)QStageCalculationPrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)externalServiceSellingPricePerUnit, (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)QStageCalculationPrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)pricePerUnit, (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)QStageCalculationPrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)priceAggregated, (HorizontalAlignment)HorizontalAlignment.RIGHT)).build();
            rowBuilder.add((Object)detail);
        }
        rowBuilder.add((Object)this.hLineB(columnCount));
        Iterable children = (Iterable)MoreObjects.firstNonNull((Object)printGroup.getChildren(), (Object)ImmutableList.of());
        for (QStagePositionPrintGroup child : children) {
            rowBuilder.addAll(this.printGroupsTables(printSetup, columnCount, child, printEmptyGroups));
        }
        return rowBuilder.build();
    }

    protected static float maxDetailsHeight(PDRectangle mediaBox, float headerHeight, float footerHeight, float optionalNeededSpace, float marginTop, float marginBottom) {
        return mediaBox.getHeight() - (marginTop + marginBottom + headerHeight + 10.0f + footerHeight + optionalNeededSpace);
    }
}

