/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service.print;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import de.qfm.erp.service.configuration.PrintLayoutConfig;
import de.qfm.erp.service.model.internal.message.Translatable;
import de.qfm.erp.service.model.internal.print.EPrintFontSize;
import de.qfm.erp.service.model.internal.print.PrintConfiguration;
import de.qfm.erp.service.model.internal.print.PrintFonts;
import de.qfm.erp.service.model.internal.print.PrintInfo;
import de.qfm.erp.service.model.internal.print.PrintSetup;
import de.qfm.erp.service.model.internal.print.payroll.PayrollMonthAttendance;
import de.qfm.erp.service.model.internal.print.payroll.PayrollMonthAttendanceInfo;
import de.qfm.erp.service.model.internal.print.payroll.PayrollMonthPrintConfiguration;
import de.qfm.erp.service.model.jpa.configuration.ConfigurationCompany;
import de.qfm.erp.service.model.jpa.employee.attendance.EAttendanceDayType;
import de.qfm.erp.service.service.route.impl.PrintHelper;
import de.qfm.erp.service.service.security.UserService;
import de.qfm.erp.service.service.service.DateTimeHelperService;
import de.qfm.erp.service.service.service.MessageService;
import de.qfm.erp.service.service.service.print.AbstractPrintService;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Duration;
import java.time.LocalTime;
import java.time.YearMonth;
import java.util.List;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.vandeseer.easytable.TableDrawer;
import org.vandeseer.easytable.settings.HorizontalAlignment;
import org.vandeseer.easytable.settings.VerticalAlignment;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.ImageCell;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class PayrollMonthAttendancePrintService
extends AbstractPrintService<PayrollMonthAttendanceInfo, PayrollMonthPrintConfiguration> {
    private static final Iterable<EAttendanceDayType> NO_PRINT = ImmutableSet.of((Object)EAttendanceDayType.NONE);
    private final MessageService messageService;
    private final PrintLayoutConfig printLayoutConfig;

    @Autowired
    public PayrollMonthAttendancePrintService(@NonNull MessageService messageService, @NonNull UserService userService, @NonNull DateTimeHelperService dateTimeHelperService, @NonNull PrintHelper printHelper, PrintLayoutConfig printLayoutConfig) {
        super(userService, dateTimeHelperService, printHelper);
        if (messageService == null) {
            throw new NullPointerException("messageService is marked non-null but is null");
        }
        if (userService == null) {
            throw new NullPointerException("userService is marked non-null but is null");
        }
        if (dateTimeHelperService == null) {
            throw new NullPointerException("dateTimeHelperService is marked non-null but is null");
        }
        if (printHelper == null) {
            throw new NullPointerException("printHelper is marked non-null but is null");
        }
        this.messageService = messageService;
        this.printLayoutConfig = printLayoutConfig;
    }

    @Nonnull
    public PDDocumentInformation apply(@NonNull PDDocumentInformation documentInformation, @NonNull PayrollMonthAttendanceInfo printInfo, @NonNull PayrollMonthPrintConfiguration printConfiguration) {
        if (documentInformation == null) {
            throw new NullPointerException("documentInformation is marked non-null but is null");
        }
        if (printInfo == null) {
            throw new NullPointerException("printInfo is marked non-null but is null");
        }
        if (printConfiguration == null) {
            throw new NullPointerException("printConfiguration is marked non-null but is null");
        }
        YearMonth accountingMonth = printInfo.getAccountingMonth();
        String yearMonthsAsString = PayrollMonthAttendancePrintService.accountingMonthAsString((YearMonth)accountingMonth);
        Long userId = printInfo.getEmployeeUserId();
        String userFullName = printInfo.getEmployeeFullName();
        documentInformation.setKeywords("TODO");
        documentInformation.setTitle(String.format("Anwesenheit: %s", yearMonthsAsString));
        documentInformation.setSubject(String.format("Mitarbeiter: %s", userFullName));
        return documentInformation;
    }

    @Nonnull
    private List<Table> headers(@NonNull PayrollMonthAttendanceInfo payrollMonthAttendanceInfo, @NonNull PrintConfiguration printConfiguration, @NonNull PDDocument document, @NonNull PDRectangle mediaBox, @NonNull PrintSetup printSetup) throws IOException {
        if (payrollMonthAttendanceInfo == null) {
            throw new NullPointerException("payrollMonthAttendanceInfo is marked non-null but is null");
        }
        if (printConfiguration == null) {
            throw new NullPointerException("printConfiguration is marked non-null but is null");
        }
        if (document == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        byte[] logoBuffer = printSetup.getLogoBuffer();
        PrintFonts printFonts = printSetup.getPrintFonts();
        PDImageXObject pdImageXObject = PDImageXObject.createFromByteArray((PDDocument)document, (byte[])logoBuffer, (String)"");
        YearMonth accountingMonth = payrollMonthAttendanceInfo.getAccountingMonth();
        String accountingMonthAsString = PayrollMonthAttendancePrintService.accountingMonthAsString((YearMonth)accountingMonth);
        String employeeName = StringUtils.trimToEmpty((String)payrollMonthAttendanceInfo.getEmployeeFullName());
        Table.TableBuilder header1Builder = PayrollMonthAttendancePrintService.table((PDRectangle)mediaBox, (Iterable)ImmutableList.of((Object)Float.valueOf(0.9f), (Object)Float.valueOf(0.1f)));
        String title = String.format("Anwesenheit %s / %s", employeeName, accountingMonthAsString);
        Row header1Row1 = Row.builder().add((AbstractCell)PayrollMonthAttendancePrintService.titleCell((PrintSetup)printSetup, (PDFont)printFonts.getRegular(), (String)title)).add((AbstractCell)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)ImageCell.builder().horizontalAlignment(HorizontalAlignment.CENTER)).padding(0.0f)).paddingLeft(printSetup.getLogoPaddingLeft())).verticalAlignment(VerticalAlignment.MIDDLE)).image(pdImageXObject).maxHeight((float)printSetup.getLogoHeight()).borderWidth(0.25f)).build()).build();
        header1Builder.addRow(header1Row1);
        Table header = header1Builder.build();
        return ImmutableList.of((Object)header);
    }

    @Nonnull
    private Table footer(@NonNull PrintConfiguration printConfiguration, @NonNull PrintSetup printSetup, @NonNull PDRectangle mediaBox) {
        if (printConfiguration == null) {
            throw new NullPointerException("printConfiguration is marked non-null but is null");
        }
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        PrintFonts printFonts = printSetup.getPrintFonts();
        Table.TableBuilder footerTableBuilder = PayrollMonthAttendancePrintService.table((PDRectangle)mediaBox, (Iterable)ImmutableList.of((Object)Float.valueOf(0.8f), (Object)Float.valueOf(0.2f)));
        Row.RowBuilder r1Builder = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER);
        r1Builder.add((AbstractCell)PayrollMonthAttendancePrintService.detailHeader((PrintSetup)printSetup, (String)"", (int)1, (Iterable)ImmutableList.of()));
        r1Builder.add((AbstractCell)PayrollMonthAttendancePrintService.detailHeader((PrintSetup)printSetup, (String)"Datum / Unterschrift", (int)1, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)T));
        Row r1 = r1Builder.build();
        footerTableBuilder.addRow(r1);
        return footerTableBuilder.build();
    }

    public byte[] generatePDF(@NonNull PayrollMonthAttendanceInfo printInfo, @NonNull PayrollMonthPrintConfiguration printConfiguration, @NonNull EPrintFontSize printFontSize, @NonNull ConfigurationCompany configurationCompany) {
        byte[] byArray;
        block20: {
            if (printInfo == null) {
                throw new NullPointerException("printInfo is marked non-null but is null");
            }
            if (printConfiguration == null) {
                throw new NullPointerException("printConfiguration is marked non-null but is null");
            }
            if (printFontSize == null) {
                throw new NullPointerException("printFontSize is marked non-null but is null");
            }
            if (configurationCompany == null) {
                throw new NullPointerException("configurationCompany is marked non-null but is null");
            }
            PDRectangle mediaBox = new PDRectangle(PDRectangle.A4.getHeight(), PDRectangle.A4.getWidth());
            PDDocument document = this.document((PrintInfo)printInfo, (PrintConfiguration)printConfiguration);
            try {
                PrintSetup printSetup = PrintHelper.printSetup((PrintLayoutConfig)this.printLayoutConfig, (ConfigurationCompany)configurationCompany, (EPrintFontSize)printFontSize, (PDDocument)document, PrintLayoutConfig::getPayrollLogoPadding, PrintLayoutConfig::getPayrollLogoHeight, PrintLayoutConfig::getPayrollLogoBuffer);
                List headers = this.headers(printInfo, (PrintConfiguration)printConfiguration, document, mediaBox, printSetup);
                Table footer = this.footer((PrintConfiguration)printConfiguration, printSetup, mediaBox);
                List details = this.details(printInfo, printConfiguration, printSetup, mediaBox);
                if (details.isEmpty()) {
                    PayrollMonthAttendancePrintService.printEmptyPage((PDDocument)document, (PDRectangle)mediaBox, (List)ImmutableList.of());
                } else {
                    for (Table detailsTable : details) {
                        PDPage page = PayrollMonthAttendancePrintService.page((PDDocument)document, (PDRectangle)mediaBox);
                        try (PDPageContentStream contentStream = new PDPageContentStream(document, page);){
                            float yOffset = PayrollMonthAttendancePrintService.printHeader((PDPageContentStream)contentStream, (PDPage)page, (Iterable)headers);
                            TableDrawer.builder().page(page).contentStream(contentStream).startX(20.0f).startY(yOffset -= 10.0f).table(detailsTable).build().draw();
                            yOffset -= detailsTable.getHeight();
                            yOffset -= this.printFooter(contentStream, page, footer);
                        }
                    }
                }
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                document.save((OutputStream)outputStream);
                byArray = outputStream.toByteArray();
                if (document == null) break block20;
            }
            catch (Throwable throwable) {
                try {
                    if (document != null) {
                        try {
                            document.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return new byte[0];
                }
            }
            document.close();
        }
        return byArray;
    }

    private float printFooter(@NonNull PDPageContentStream contentStream, @NonNull PDPage page, @NonNull Table footer) {
        if (contentStream == null) {
            throw new NullPointerException("contentStream is marked non-null but is null");
        }
        if (page == null) {
            throw new NullPointerException("page is marked non-null but is null");
        }
        if (footer == null) {
            throw new NullPointerException("footer is marked non-null but is null");
        }
        PDRectangle mediaBox = page.getMediaBox();
        float footerHeight = footer.getHeight();
        float yOffset = 30.0f + footerHeight;
        TableDrawer.builder().page(page).contentStream(contentStream).startX(20.0f).startY(yOffset).table(footer).build().draw();
        return yOffset -= footer.getHeight();
    }

    @Nonnull
    private List<Table> details(@NonNull PayrollMonthAttendanceInfo printInfo, @NonNull PayrollMonthPrintConfiguration printConfiguration, @NonNull PrintSetup printSetup, @NonNull PDRectangle mediaBox) {
        if (printInfo == null) {
            throw new NullPointerException("printInfo is marked non-null but is null");
        }
        if (printConfiguration == null) {
            throw new NullPointerException("printConfiguration is marked non-null but is null");
        }
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        PrintFonts printFonts = printSetup.getPrintFonts();
        int detailsFontSize = printSetup.getDetailsFontSize();
        ImmutableList columnWidths = ImmutableList.of((Object)Float.valueOf(0.03125f), (Object)Float.valueOf(0.0625f), (Object)Float.valueOf(0.03125f), (Object)Float.valueOf(0.03125f), (Object)Float.valueOf(0.03125f), (Object)Float.valueOf(0.03125f), (Object)Float.valueOf(0.03125f), (Object)Float.valueOf(0.15625f), (Object)Float.valueOf(0.15625f));
        Table.TableBuilder tableBuilder = PayrollMonthAttendancePrintService.table((PDRectangle)mediaBox, (Iterable)columnWidths);
        Row headline1 = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)PayrollMonthAttendancePrintService.detailHeader((PrintSetup)printSetup, (String)"Tag", (int)1, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)TLR)).add((AbstractCell)PayrollMonthAttendancePrintService.detailHeader((PrintSetup)printSetup, (String)"IST", (int)1, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)TLR)).add((AbstractCell)PayrollMonthAttendancePrintService.detailHeader((PrintSetup)printSetup, (String)"Beginn", (int)1, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)TLR)).add((AbstractCell)PayrollMonthAttendancePrintService.detailHeader((PrintSetup)printSetup, (String)"Ende", (int)1, (HorizontalAlignment)HorizontalAlignment.CENTER, (Iterable)TLR)).add((AbstractCell)PayrollMonthAttendancePrintService.detailHeader((PrintSetup)printSetup, (String)"Pause", (int)1, (HorizontalAlignment)HorizontalAlignment.CENTER, (Iterable)TLR)).add((AbstractCell)PayrollMonthAttendancePrintService.detailHeader((PrintSetup)printSetup, (String)"Arbeit", (int)1, (HorizontalAlignment)HorizontalAlignment.CENTER, (Iterable)TLR)).add((AbstractCell)PayrollMonthAttendancePrintService.detailHeader((PrintSetup)printSetup, (String)"SW", (int)1, (HorizontalAlignment)HorizontalAlignment.CENTER, (Iterable)TLR)).add((AbstractCell)PayrollMonthAttendancePrintService.detailHeader((PrintSetup)printSetup, (String)"Projekt/Baustelle", (int)1, (HorizontalAlignment)HorizontalAlignment.CENTER, (Iterable)TLR)).add((AbstractCell)PayrollMonthAttendancePrintService.detailHeader((PrintSetup)printSetup, (String)"Bemerkung", (int)1, (HorizontalAlignment)HorizontalAlignment.CENTER, (Iterable)TLR)).build();
        tableBuilder.addRow(headline1);
        Iterable attendances = printInfo.getAttendances();
        ImmutableList attendancesSorted = Ordering.from((l, r) -> Ordering.natural().compare((Object)l.getDayOfMonth(), (Object)r.getDayOfMonth())).immutableSortedCopy(attendances);
        for (PayrollMonthAttendance item : attendancesSorted) {
            EAttendanceDayType employeeDayType = item.getEmployeeDayType();
            String day = Integer.toString(item.getDayOfMonth());
            String employeeDayTypeString = !Iterables.contains((Iterable)NO_PRINT, (Object)employeeDayType) ? this.messageService.get((Translatable)employeeDayType, new Object[0]) : "";
            String beginAsString = PayrollMonthAttendancePrintService.formatTime((LocalTime)item.getWorkStart());
            String endAsString = PayrollMonthAttendancePrintService.formatTime((LocalTime)item.getWorkEnd());
            String breakAsString = PayrollMonthAttendancePrintService.formatDuration((Duration)item.getBreakDuration());
            String workAsString = PayrollMonthAttendancePrintService.formatDuration((Duration)item.getWorkDuration());
            String kugAsString = PayrollMonthAttendancePrintService.formatDuration((Duration)item.getBadWeatherDuration());
            String constructionSite = StringUtils.trimToEmpty((String)item.getConstructionSite());
            String remarks = StringUtils.trimToEmpty((String)item.getRemarks());
            Color dayColor = PayrollMonthAttendancePrintService.attendanceBGColor((PayrollMonthAttendance)item, (Color)DEFAULT_BG_COLOR_DETAILS);
            Row detail = Row.builder().backgroundColor(dayColor).add((AbstractCell)PayrollMonthAttendancePrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)day, (Color)dayColor, (HorizontalAlignment)HorizontalAlignment.LEFT)).add((AbstractCell)PayrollMonthAttendancePrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)employeeDayTypeString, (Color)dayColor, (HorizontalAlignment)HorizontalAlignment.LEFT)).add((AbstractCell)PayrollMonthAttendancePrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)beginAsString, (Color)dayColor, (HorizontalAlignment)HorizontalAlignment.LEFT)).add((AbstractCell)PayrollMonthAttendancePrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)endAsString, (Color)dayColor, (HorizontalAlignment)HorizontalAlignment.LEFT)).add((AbstractCell)PayrollMonthAttendancePrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)breakAsString, (Color)dayColor, (HorizontalAlignment)HorizontalAlignment.LEFT)).add((AbstractCell)PayrollMonthAttendancePrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)workAsString, (Color)dayColor, (HorizontalAlignment)HorizontalAlignment.LEFT)).add((AbstractCell)PayrollMonthAttendancePrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)kugAsString, (Color)dayColor, (HorizontalAlignment)HorizontalAlignment.LEFT)).add((AbstractCell)PayrollMonthAttendancePrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)constructionSite, (Color)dayColor, (HorizontalAlignment)HorizontalAlignment.LEFT)).add((AbstractCell)PayrollMonthAttendancePrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)remarks, (Color)dayColor, (HorizontalAlignment)HorizontalAlignment.LEFT)).build();
            tableBuilder.addRow(detail);
        }
        Table table = tableBuilder.build();
        return ImmutableList.of((Object)table);
    }
}

