/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service.print;

import com.google.common.collect.ImmutableList;
import de.leancoders.common.helper.IterableHelper;
import de.qfm.erp.service.configuration.PrintLayoutConfig;
import de.qfm.erp.service.model.internal.pdfbox.ECellPrintOption;
import de.qfm.erp.service.model.internal.pdfbox.EValueSource;
import de.qfm.erp.service.model.internal.print.EPrintFontSize;
import de.qfm.erp.service.model.internal.print.PrintConfiguration;
import de.qfm.erp.service.model.internal.print.PrintFonts;
import de.qfm.erp.service.model.internal.print.PrintInfo;
import de.qfm.erp.service.model.internal.print.PrintSetup;
import de.qfm.erp.service.model.internal.print.measurement.MeasurementPositionPrintStandard;
import de.qfm.erp.service.model.internal.print.measurement.MeasurementPrintConfiguration;
import de.qfm.erp.service.model.internal.print.measurement.MeasurementPrintInfo;
import de.qfm.erp.service.model.internal.print.measurement.MeasurementPrintStandard;
import de.qfm.erp.service.model.internal.print.measurement.MeasurementStandardPrintConfiguration;
import de.qfm.erp.service.model.jpa.configuration.ConfigurationCompany;
import de.qfm.erp.service.service.route.impl.PrintHelper;
import de.qfm.erp.service.service.security.UserService;
import de.qfm.erp.service.service.service.DateTimeHelperService;
import de.qfm.erp.service.service.service.print.MeasurementPrintService;
import de.qfm.erp.service.service.service.print.MeasurementStandardPrintService;
import de.qfm.erp.service.service.service.print.PrintColumn;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.List;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.springframework.stereotype.Service;
import org.vandeseer.easytable.TableDrawer;
import org.vandeseer.easytable.settings.HorizontalAlignment;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.cell.AbstractCell;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class MeasurementStandardPrintService
extends MeasurementPrintService<MeasurementPrintStandard, MeasurementStandardPrintConfiguration> {
    protected static final Iterable<PrintColumn<MeasurementPositionPrintStandard>> STANDARD_COLUMNS_WITH_WAGE = ImmutableList.copyOf((Object[])EStandardDetailColumn.values());
    protected static final Iterable<PrintColumn<MeasurementPositionPrintStandard>> STANDARD_COLUMNS_WITHOUT_WAGE = ImmutableList.copyOf(IterableHelper.stream((Iterable)STANDARD_COLUMNS_WITH_WAGE).filter(item -> item != EStandardDetailColumn.SQUAD_WAGE).iterator());
    private final PrintLayoutConfig printLayoutConfig;

    protected MeasurementStandardPrintService(@NonNull UserService userService, @NonNull DateTimeHelperService dateTimeHelperService, @NonNull PrintHelper printHelper, PrintLayoutConfig printLayoutConfig) {
        super(userService, dateTimeHelperService, printHelper);
        if (userService == null) {
            throw new NullPointerException("userService is marked non-null but is null");
        }
        if (dateTimeHelperService == null) {
            throw new NullPointerException("dateTimeHelperService is marked non-null but is null");
        }
        if (printHelper == null) {
            throw new NullPointerException("printHelper is marked non-null but is null");
        }
        this.printLayoutConfig = printLayoutConfig;
    }

    @Nonnull
    public byte[] generatePDF(@NonNull MeasurementPrintStandard measurementPrintStandard, @NonNull MeasurementStandardPrintConfiguration printConfiguration, @NonNull EPrintFontSize printFontSize, @NonNull ConfigurationCompany configurationCompany) {
        byte[] byArray;
        block19: {
            if (measurementPrintStandard == null) {
                throw new NullPointerException("measurementPrintStandard is marked non-null but is null");
            }
            if (printConfiguration == null) {
                throw new NullPointerException("printConfiguration is marked non-null but is null");
            }
            if (printFontSize == null) {
                throw new NullPointerException("printFontSize is marked non-null but is null");
            }
            if (configurationCompany == null) {
                throw new NullPointerException("configurationCompany is marked non-null but is null");
            }
            PDRectangle mediaBox = new PDRectangle(PDRectangle.A4.getHeight(), PDRectangle.A4.getWidth());
            PDDocument document = this.document((PrintInfo)measurementPrintStandard, (PrintConfiguration)printConfiguration);
            try {
                PrintSetup printSetup = PrintHelper.printSetup((PrintLayoutConfig)this.printLayoutConfig, (ConfigurationCompany)configurationCompany, (EPrintFontSize)printFontSize, (PDDocument)document, PrintLayoutConfig::getMeasurementLogoPadding, PrintLayoutConfig::getMeasurementLogoHeight, PrintLayoutConfig::getMeasurementLogoBuffer);
                PrintFonts printFonts = printSetup.getPrintFonts();
                Table footer = MeasurementStandardPrintService.footer((MeasurementPrintConfiguration)printConfiguration, (PrintSetup)printSetup, (PDFont)printFonts.getRegular(), (PDRectangle)mediaBox);
                List headers = this.header((MeasurementPrintInfo)measurementPrintStandard, (PrintConfiguration)printConfiguration, document, mediaBox, printSetup);
                float headerHeight = MeasurementStandardPrintService.height((Iterable)headers);
                float footerHeight = footer.getHeight();
                float maxDetailsHeight = MeasurementStandardPrintService.maxDetailsHeight((PDRectangle)mediaBox, (float)headerHeight, (float)footerHeight, (float)0.0f);
                boolean isWageToBePrinted = this.isWageToBePrinted((PrintConfiguration)printConfiguration);
                Iterable columns = isWageToBePrinted ? STANDARD_COLUMNS_WITH_WAGE : STANDARD_COLUMNS_WITHOUT_WAGE;
                Table details = this.standardDetails(measurementPrintStandard, printSetup, (PrintConfiguration)printConfiguration, columns, mediaBox);
                Iterable pagedTables = MeasurementStandardPrintService.splitVertically((Iterable)ImmutableList.of((Object)details), (int)1, (float)maxDetailsHeight, (float)maxDetailsHeight);
                for (Iterable tablesOnPage : pagedTables) {
                    PDPage page = MeasurementStandardPrintService.page((PDDocument)document, (PDRectangle)mediaBox);
                    try (PDPageContentStream contentStream = new PDPageContentStream(document, page);){
                        float yOffset = MeasurementStandardPrintService.printHeader((PDPageContentStream)contentStream, (PDPage)page, (Iterable)headers);
                        yOffset -= 10.0f;
                        for (Table table : tablesOnPage) {
                            TableDrawer.builder().page(page).contentStream(contentStream).startX(20.0f).startY(yOffset).table(table).build().draw();
                            yOffset -= table.getHeight();
                            yOffset -= 10.0f;
                        }
                    }
                }
                MeasurementStandardPrintService.writeMeta((PrintSetup)printSetup, (PDDocument)document, (Table)footer);
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                document.save((OutputStream)outputStream);
                byArray = outputStream.toByteArray();
                if (document == null) break block19;
            }
            catch (Throwable throwable) {
                try {
                    if (document != null) {
                        try {
                            document.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return new byte[0];
                }
            }
            document.close();
        }
        return byArray;
    }

    @Nonnull
    private Table standardDetails(@NonNull MeasurementPrintStandard measurementPrintStandard, @NonNull PrintSetup printSetup, @NonNull PrintConfiguration printConfiguration, @NonNull Iterable<PrintColumn<MeasurementPositionPrintStandard>> columns, @NonNull PDRectangle mediaBox) {
        if (measurementPrintStandard == null) {
            throw new NullPointerException("measurementPrintStandard is marked non-null but is null");
        }
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        if (printConfiguration == null) {
            throw new NullPointerException("printConfiguration is marked non-null but is null");
        }
        if (columns == null) {
            throw new NullPointerException("columns is marked non-null but is null");
        }
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        int fontSize = printSetup.getDetailsFontSize();
        List measurementPositions = measurementPrintStandard.getMeasurementPositions();
        ImmutableList columnsList = ImmutableList.copyOf(columns);
        ImmutableList columnWidths = ImmutableList.copyOf(IterableHelper.stream(columns).map(PrintColumn::getWidth).iterator());
        ImmutableList columnNames = ImmutableList.copyOf(IterableHelper.stream(columns).map(PrintColumn::getName).iterator());
        Table.TableBuilder tableBuilder = MeasurementStandardPrintService.table((PDRectangle)mediaBox, (Iterable)columnWidths);
        Row.RowBuilder headlineBuilder = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER);
        columnNames.forEach(item -> headlineBuilder.add((AbstractCell)MeasurementStandardPrintService.detailHeader((PrintSetup)printSetup, (String)item)));
        Row headline = headlineBuilder.build();
        tableBuilder.addRow(headline);
        for (MeasurementPositionPrintStandard measurementPositionPrintStandard : measurementPositions) {
            Row.RowBuilder rowBuilder = Row.builder();
            columnsList.forEach(column -> {
                boolean valueCell = column.isValueCell();
                String text = (String)column.getTextFn().apply(measurementPositionPrintStandard);
                BigDecimal value = (BigDecimal)column.getValueFn().apply(measurementPositionPrintStandard);
                EValueSource source = column.getSource();
                if (valueCell) {
                    String rowKey = Long.toString(measurementPositionPrintStandard.getId());
                    String columnKey = source.name();
                    rowBuilder.add((AbstractCell)MeasurementStandardPrintService.valueCell((PDFont)printSetup.getPrintFonts().getRegular(), (int)fontSize, (String)rowKey, (String)columnKey, (BigDecimal)value, (EValueSource)source, (HorizontalAlignment)HorizontalAlignment.RIGHT, (Iterable)ALL, (Iterable)ImmutableList.of((Object)ECellPrintOption.HIDE_ZERO_VALUE)));
                } else {
                    rowBuilder.add((AbstractCell)MeasurementStandardPrintService.descriptionCell((PrintFonts)printSetup.getPrintFonts(), (int)fontSize, (String)text, (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT));
                }
            });
            Row detail = rowBuilder.build();
            tableBuilder.addRow(detail);
        }
        return tableBuilder.build();
    }
}

