/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service.print;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import de.leancoders.common.helper.IterableHelper;
import de.qfm.erp.service.configuration.PrintLayoutConfig;
import de.qfm.erp.service.model.internal.pdfbox.ECellPrintOption;
import de.qfm.erp.service.model.internal.pdfbox.EValueSource;
import de.qfm.erp.service.model.internal.print.AddendumGroupPrice;
import de.qfm.erp.service.model.internal.print.EPrintFontSize;
import de.qfm.erp.service.model.internal.print.PrintConfiguration;
import de.qfm.erp.service.model.internal.print.PrintFonts;
import de.qfm.erp.service.model.internal.print.PrintInfo;
import de.qfm.erp.service.model.internal.print.PrintSetup;
import de.qfm.erp.service.model.internal.print.measurement.MeasurementPositionPrintPreliminaryStandard;
import de.qfm.erp.service.model.internal.print.measurement.MeasurementPreliminaryStandardPrintConfiguration;
import de.qfm.erp.service.model.internal.print.measurement.MeasurementPrintConfiguration;
import de.qfm.erp.service.model.internal.print.measurement.MeasurementPrintPreliminaryStandard;
import de.qfm.erp.service.model.jpa.configuration.ConfigurationCompany;
import de.qfm.erp.service.service.route.impl.PrintHelper;
import de.qfm.erp.service.service.security.UserService;
import de.qfm.erp.service.service.service.DateTimeHelperService;
import de.qfm.erp.service.service.service.print.AbstractPrintService;
import de.qfm.erp.service.service.service.print.MeasurementPreliminaryStandardPrintService;
import de.qfm.erp.service.service.service.print.MeasurementPrintService;
import de.qfm.erp.service.service.service.print.PrintColumn;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.springframework.stereotype.Service;
import org.vandeseer.easytable.TableDrawer;
import org.vandeseer.easytable.settings.HorizontalAlignment;
import org.vandeseer.easytable.settings.VerticalAlignment;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.ImageCell;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class MeasurementPreliminaryStandardPrintService
extends MeasurementPrintService<MeasurementPrintPreliminaryStandard, MeasurementPreliminaryStandardPrintConfiguration> {
    private final PrintLayoutConfig printLayoutConfig;

    protected MeasurementPreliminaryStandardPrintService(@NonNull UserService userService, @NonNull DateTimeHelperService dateTimeHelperService, @NonNull PrintHelper printHelper, PrintLayoutConfig printLayoutConfig) {
        super(userService, dateTimeHelperService, printHelper);
        if (userService == null) {
            throw new NullPointerException("userService is marked non-null but is null");
        }
        if (dateTimeHelperService == null) {
            throw new NullPointerException("dateTimeHelperService is marked non-null but is null");
        }
        if (printHelper == null) {
            throw new NullPointerException("printHelper is marked non-null but is null");
        }
        this.printLayoutConfig = printLayoutConfig;
    }

    @Nonnull
    public byte[] generatePDF(@NonNull MeasurementPrintPreliminaryStandard measurementPrint, @NonNull MeasurementPreliminaryStandardPrintConfiguration printConfiguration, @NonNull EPrintFontSize printFontSize, @NonNull ConfigurationCompany configurationCompany) {
        Object object;
        block21: {
            if (measurementPrint == null) {
                throw new NullPointerException("measurementPrint is marked non-null but is null");
            }
            if (printConfiguration == null) {
                throw new NullPointerException("printConfiguration is marked non-null but is null");
            }
            if (printFontSize == null) {
                throw new NullPointerException("printFontSize is marked non-null but is null");
            }
            if (configurationCompany == null) {
                throw new NullPointerException("configurationCompany is marked non-null but is null");
            }
            PDRectangle mediaBox = new PDRectangle(PDRectangle.A4.getHeight(), PDRectangle.A4.getWidth());
            PDDocument document = this.document((PrintInfo)measurementPrint, (PrintConfiguration)printConfiguration);
            try {
                PrintSetup printSetup = PrintHelper.printSetup((PrintLayoutConfig)this.printLayoutConfig, (ConfigurationCompany)configurationCompany, (EPrintFontSize)printFontSize, (PDDocument)document, PrintLayoutConfig::getMeasurementLogoPadding, PrintLayoutConfig::getMeasurementLogoHeight, PrintLayoutConfig::getMeasurementLogoBuffer);
                Table footer = MeasurementPreliminaryStandardPrintService.footer((MeasurementPrintConfiguration)printConfiguration, (PrintSetup)printSetup, (PDRectangle)mediaBox);
                List headers = this.header(measurementPrint, document, mediaBox, printSetup);
                float headerHeight = MeasurementPreliminaryStandardPrintService.height((Iterable)headers);
                float footerHeight = footer.getHeight();
                float maxDetailsHeight = MeasurementPreliminaryStandardPrintService.maxDetailsHeight((PDRectangle)mediaBox, (float)headerHeight, (float)footerHeight, (float)0.0f);
                ImmutableList columns = ImmutableList.copyOf((Object[])EStandardDetailColumn.values());
                Table details = this.standardDetails(measurementPrint, printSetup, (Iterable)columns, mediaBox);
                Table discounts = this.discounts(measurementPrint, mediaBox, printSetup);
                ImmutableList.Builder allTablesBuilder = ImmutableList.builder();
                allTablesBuilder.add((Object)AbstractPrintService.PrintPlanInput.of((String)"details", (Table)details, (boolean)false, (int)1, (float)10.0f));
                allTablesBuilder.add((Object)AbstractPrintService.PrintPlanInput.of((String)"discounts", (Table)discounts, (boolean)false, (int)0, (float)10.0f));
                ImmutableList allTables = allTablesBuilder.build();
                Multimap printPlan = MeasurementPreliminaryStandardPrintService.printPlan((Iterable)allTables, (float)maxDetailsHeight, (float)maxDetailsHeight);
                if (details.getRows().isEmpty()) {
                    MeasurementPreliminaryStandardPrintService.printEmptyPage((PDDocument)document, (PDRectangle)mediaBox, (List)ImmutableList.of());
                } else {
                    TreeSet pages = Sets.newTreeSet((Iterable)printPlan.keySet());
                    for (Integer pageNumber : pages) {
                        PDPage pdPage = MeasurementPreliminaryStandardPrintService.page((PDDocument)document, (PDRectangle)mediaBox);
                        Collection printPlanOutputs = printPlan.get((Object)pageNumber);
                        try (PDPageContentStream contentStream = new PDPageContentStream(document, pdPage);){
                            float yOffset = MeasurementPreliminaryStandardPrintService.printHeader((PDPageContentStream)contentStream, (PDPage)pdPage, (Iterable)headers);
                            yOffset -= 10.0f;
                            for (AbstractPrintService.PrintPlanOutput printPlanOutput : printPlanOutputs) {
                                Table table = printPlanOutput.getTable();
                                float marginAfterTable = printPlanOutput.getMarginAfterTable();
                                TableDrawer.builder().page(pdPage).contentStream(contentStream).startX(20.0f).startY(yOffset -= marginAfterTable).table(table).build().draw();
                                yOffset -= table.getHeight();
                            }
                        }
                    }
                }
                MeasurementPreliminaryStandardPrintService.writeMeta((PrintSetup)printSetup, (PDDocument)document, (Table)footer);
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                document.save((OutputStream)outputStream);
                object = outputStream.toByteArray();
                if (document == null) break block21;
            }
            catch (Throwable throwable) {
                try {
                    if (document != null) {
                        try {
                            document.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return new byte[0];
                }
            }
            document.close();
        }
        return object;
    }

    @Nonnull
    protected List<Table> header(@NonNull MeasurementPrintPreliminaryStandard measurementPrintInfo, @NonNull PDDocument document, @NonNull PDRectangle mediaBox, @NonNull PrintSetup printSetup) throws IOException {
        if (measurementPrintInfo == null) {
            throw new NullPointerException("measurementPrintInfo is marked non-null but is null");
        }
        if (document == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        byte[] logoBuffer = printSetup.getLogoBuffer();
        PDImageXObject pdImageXObject = PDImageXObject.createFromByteArray((PDDocument)document, (byte[])logoBuffer, (String)"");
        Table.TableBuilder header1Builder = MeasurementPreliminaryStandardPrintService.table((PDRectangle)mediaBox, (Iterable)ImmutableList.of((Object)Float.valueOf(0.15f), (Object)Float.valueOf(0.6f), (Object)Float.valueOf(0.25f)));
        String valueOverallAsString = PrintHelper.asCurrency((BigDecimal)measurementPrintInfo.getValueOverallWithDiscount(), (String)"", (boolean)true);
        Row header1Row1 = Row.builder().add((AbstractCell)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)ImageCell.builder().horizontalAlignment(HorizontalAlignment.CENTER)).padding(0.0f)).paddingLeft(printSetup.getLogoPaddingLeft())).verticalAlignment(VerticalAlignment.MIDDLE)).image(pdImageXObject).maxHeight((float)printSetup.getLogoHeight()).borderWidth(0.25f)).build()).add((AbstractCell)MeasurementPreliminaryStandardPrintService.titleCell((PrintSetup)printSetup, (String)"Summenaufma\u00df")).add((AbstractCell)MeasurementPreliminaryStandardPrintService.titleCell((PrintSetup)printSetup, (String)valueOverallAsString)).build();
        header1Builder.addRow(header1Row1);
        String releaseOrderName = StringUtils.trimToEmpty((String)measurementPrintInfo.getReleaseOrderName());
        String personResponsibleAtCustomer = measurementPrintInfo.getPersonResponsibleAtCustomer();
        Table.TableBuilder header2Builder = MeasurementPreliminaryStandardPrintService.table((PDRectangle)mediaBox, (Iterable)ImmutableList.of((Object)Float.valueOf(0.125f), (Object)Float.valueOf(0.3f), (Object)Float.valueOf(0.225f), (Object)Float.valueOf(0.15f), (Object)Float.valueOf(0.2f)));
        String orderDescriptionCustomer = measurementPrintInfo.getOrderDescriptionCustomer();
        String orderNumber = measurementPrintInfo.getOrderNumber();
        boolean orderDescriptionSet = StringUtils.isNotBlank((CharSequence)orderDescriptionCustomer);
        boolean orderNumberSet = StringUtils.isNotBlank((CharSequence)orderNumber);
        ArrayList orderLabelParts = Lists.newArrayList();
        if (orderDescriptionSet) {
            orderLabelParts.add("Auftrag");
        }
        if (orderNumberSet) {
            orderLabelParts.add("Bestellnummer");
        }
        String orderLabel = StringUtils.join((Iterable)orderLabelParts, (String)"; ");
        ArrayList orderValueParts = Lists.newArrayList();
        if (orderDescriptionSet) {
            orderValueParts.add(orderDescriptionCustomer);
        }
        if (orderNumberSet) {
            orderValueParts.add(orderNumber);
        }
        String orderValue = StringUtils.join((Iterable)orderValueParts, (String)"; ");
        Row header2Row1 = Row.builder().add((AbstractCell)MeasurementPreliminaryStandardPrintService.headerCell((PrintSetup)printSetup, (String)String.format("%s:", orderLabel), (Iterable)TLB)).add((AbstractCell)MeasurementPreliminaryStandardPrintService.headerCell((PrintSetup)printSetup, (String)orderValue, (Iterable)TB)).add((AbstractCell)MeasurementPreliminaryStandardPrintService.headerCell((PrintSetup)printSetup, (String)"", (Iterable)TB)).add((AbstractCell)MeasurementPreliminaryStandardPrintService.headerCell((PrintSetup)printSetup, (String)"Kostentr\u00e4ger:", (Iterable)TLB)).add((AbstractCell)MeasurementPreliminaryStandardPrintService.headerCell((PrintSetup)printSetup, (String)measurementPrintInfo.getQuotationNumber(), (Iterable)TBR)).build();
        Row header2Row2 = Row.builder().add((AbstractCell)MeasurementPreliminaryStandardPrintService.headerCell((PrintSetup)printSetup, (String)"Abruf:", (Iterable)TLB)).add((AbstractCell)MeasurementPreliminaryStandardPrintService.headerCell((PrintSetup)printSetup, (String)releaseOrderName, (Iterable)TB)).add((AbstractCell)MeasurementPreliminaryStandardPrintService.headerCell((PrintSetup)printSetup, (String)"", (Iterable)TB)).add((AbstractCell)MeasurementPreliminaryStandardPrintService.headerCell((PrintSetup)printSetup, (String)"", (Iterable)TLB)).add((AbstractCell)MeasurementPreliminaryStandardPrintService.headerCell((PrintSetup)printSetup, (String)"", (Iterable)TBR)).build();
        Range projectExecutionRange = measurementPrintInfo.getProjectExecutionRange();
        LocalDate projectExecutionFrom = (LocalDate)projectExecutionRange.lowerEndpoint();
        String projectExecutionFromString = DateTimeHelperService.germanDate((LocalDate)projectExecutionFrom);
        LocalDate projectExecutionTo = (LocalDate)projectExecutionRange.upperEndpoint();
        String projectExecutionToString = DateTimeHelperService.germanDate((LocalDate)projectExecutionTo);
        String projectExecutionRangeString = String.format("%s - %s", projectExecutionFromString, projectExecutionToString);
        Row header2Row3 = Row.builder().add((AbstractCell)MeasurementPreliminaryStandardPrintService.headerCell((PrintSetup)printSetup, (String)"Ansprechpartner:", (Iterable)TLB)).add((AbstractCell)MeasurementPreliminaryStandardPrintService.headerCell((PrintSetup)printSetup, (String)personResponsibleAtCustomer, (Iterable)TB)).add((AbstractCell)MeasurementPreliminaryStandardPrintService.headerCell((PrintSetup)printSetup, (String)"", (Iterable)TB)).add((AbstractCell)MeasurementPreliminaryStandardPrintService.headerCell((PrintSetup)printSetup, (String)"Ausf\u00fchrungszeitraum:", (Iterable)TLB)).add((AbstractCell)MeasurementPreliminaryStandardPrintService.headerCell((PrintSetup)printSetup, (String)projectExecutionRangeString, (Iterable)TBR)).build();
        String measurementNumbersString = Joiner.on((String)", ").join(measurementPrintInfo.getMeasurementNumbers());
        Row header2Row4 = Row.builder().add((AbstractCell)MeasurementPreliminaryStandardPrintService.headerCell((PrintSetup)printSetup, (String)"Aufma\u00dfnummern:", (Iterable)TLB)).add((AbstractCell)MeasurementPreliminaryStandardPrintService.headerCell((PrintSetup)printSetup, (String)measurementNumbersString, (Iterable)TBR, (int)4)).build();
        header2Builder.addRow(header2Row1);
        header2Builder.addRow(header2Row2);
        header2Builder.addRow(header2Row3);
        header2Builder.addRow(header2Row4);
        return ImmutableList.of((Object)header1Builder.build(), (Object)header2Builder.build());
    }

    @Nonnull
    private Table standardDetails(@NonNull MeasurementPrintPreliminaryStandard measurementPrintStandard, @NonNull PrintSetup printSetup, @NonNull Iterable<PrintColumn<MeasurementPositionPrintPreliminaryStandard>> columns, @NonNull PDRectangle mediaBox) {
        if (measurementPrintStandard == null) {
            throw new NullPointerException("measurementPrintStandard is marked non-null but is null");
        }
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        if (columns == null) {
            throw new NullPointerException("columns is marked non-null but is null");
        }
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        PrintFonts printFonts = printSetup.getPrintFonts();
        int fontSize = printSetup.getDetailsFontSize();
        List measurementPositions = measurementPrintStandard.getPositions();
        ImmutableList columnsList = ImmutableList.copyOf(columns);
        ImmutableList columnWidths = ImmutableList.copyOf(IterableHelper.stream(columns).map(PrintColumn::getWidth).iterator());
        ImmutableList columnNames = ImmutableList.copyOf(IterableHelper.stream(columns).map(PrintColumn::getName).iterator());
        Table.TableBuilder tableBuilder = MeasurementPreliminaryStandardPrintService.table((PDRectangle)mediaBox, (Iterable)columnWidths);
        Row.RowBuilder headlineBuilder = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER);
        columnNames.forEach(item -> headlineBuilder.add((AbstractCell)MeasurementPreliminaryStandardPrintService.detailHeader((PrintSetup)printSetup, (String)item)));
        Row headline = headlineBuilder.build();
        tableBuilder.addRow(headline);
        for (MeasurementPositionPrintPreliminaryStandard measurementPositionPrintStandard : measurementPositions) {
            Row.RowBuilder rowBuilder = Row.builder();
            columnsList.forEach(column -> {
                boolean valueCell = column.isValueCell();
                String text = (String)column.getTextFn().apply(measurementPositionPrintStandard);
                BigDecimal value = (BigDecimal)column.getValueFn().apply(measurementPositionPrintStandard);
                EValueSource source = column.getSource();
                if (valueCell) {
                    String rowKey = measurementPositionPrintStandard.getSurrogatePositionNumber();
                    String columnKey = source.name();
                    rowBuilder.add((AbstractCell)MeasurementPreliminaryStandardPrintService.valueCell((PDFont)printFonts.getRegular(), (int)fontSize, (String)rowKey, (String)columnKey, (BigDecimal)value, (EValueSource)source, (HorizontalAlignment)HorizontalAlignment.RIGHT, (Iterable)ALL, (Iterable)ImmutableList.of((Object)ECellPrintOption.HIDE_ZERO_VALUE)));
                } else {
                    rowBuilder.add((AbstractCell)MeasurementPreliminaryStandardPrintService.descriptionCell((PrintFonts)printFonts, (int)fontSize, (String)text, (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT));
                }
            });
            Row detail = rowBuilder.build();
            tableBuilder.addRow(detail);
        }
        return tableBuilder.build();
    }

    @Nonnull
    private Table discounts(@NonNull MeasurementPrintPreliminaryStandard measurementPrintPreliminaryStandard, @NonNull PDRectangle mediaBox, @NonNull PrintSetup printSetup) {
        if (measurementPrintPreliminaryStandard == null) {
            throw new NullPointerException("measurementPrintPreliminaryStandard is marked non-null but is null");
        }
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        PrintFonts printFonts = printSetup.getPrintFonts();
        Iterable groupPrices = measurementPrintPreliminaryStandard.getGroupPrices();
        ImmutableList columnWidths = ImmutableList.of((Object)Float.valueOf(0.5f), (Object)Float.valueOf(0.0625f), (Object)Float.valueOf(0.0625f));
        int columnAmount = Iterables.size((Iterable)columnWidths);
        Table.TableBuilder tableBuilder = MeasurementPreliminaryStandardPrintService.table((Float)Float.valueOf(MeasurementPreliminaryStandardPrintService.maxWidth((PDRectangle)mediaBox)), (Iterable)columnWidths);
        BigDecimal valueOverall = measurementPrintPreliminaryStandard.getValueOverallWithoutDiscount();
        Row sumNetWithoutDiscountRow = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)MeasurementPreliminaryStandardPrintService.descriptionCell((PrintSetup)printSetup, (Color)DETAIL_TEXT_COLOR, (String)"Summe in EUR:", (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)MeasurementPreliminaryStandardPrintService.descriptionCell((PrintSetup)printSetup, (Color)DETAIL_TEXT_COLOR, (String)"", (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)MeasurementPreliminaryStandardPrintService.descriptionCell((PrintSetup)printSetup, (Color)DETAIL_TEXT_COLOR, (String)PrintHelper.asString((BigDecimal)valueOverall, (String)"", (boolean)true), (HorizontalAlignment)HorizontalAlignment.RIGHT)).build();
        tableBuilder.addRow(sumNetWithoutDiscountRow);
        for (AddendumGroupPrice addendumGroupPrice : groupPrices) {
            Long addendumNumber = (Long)MoreObjects.firstNonNull((Object)addendumGroupPrice.getAddendumNumber(), (Object)0L);
            BigDecimal sumNetOriginal = addendumGroupPrice.getPriceAggregated();
            BigDecimal discount = addendumGroupPrice.getDiscount();
            BigDecimal discountValue = addendumGroupPrice.getDiscountValue();
            String title = PrintHelper.addendumName((Long)addendumNumber);
            boolean hasDiscount = discount.compareTo(BigDecimal.ZERO) != 0;
            if (!hasDiscount) continue;
            Row sumNetRow = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)MeasurementPreliminaryStandardPrintService.descriptionCell((PrintSetup)printSetup, (Color)DETAIL_TEXT_COLOR, (int)(columnAmount - 2), (String)(title + " in EUR:"), (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)MeasurementPreliminaryStandardPrintService.descriptionCell((PrintSetup)printSetup, (Color)DETAIL_TEXT_COLOR, (String)"", (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)MeasurementPreliminaryStandardPrintService.descriptionCell((PrintSetup)printSetup, (Color)DETAIL_TEXT_COLOR, (String)PrintHelper.asString((BigDecimal)sumNetOriginal, (String)"", (boolean)true), (HorizontalAlignment)HorizontalAlignment.RIGHT)).build();
            tableBuilder.addRow(sumNetRow);
            String discountName = PrintHelper.discountName((BigDecimal)discount);
            BigDecimal discountAbs = discount.abs();
            BigDecimal discountValueNegated = discountValue.negate();
            Row discountRow = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)MeasurementPreliminaryStandardPrintService.descriptionCell((PrintSetup)printSetup, (Color)DETAIL_TEXT_COLOR, (int)(columnAmount - 2), (String)(discountName + " in EUR:"), (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)MeasurementPreliminaryStandardPrintService.descriptionCell((PrintSetup)printSetup, (Color)DETAIL_TEXT_COLOR, (String)String.format("%s %%", PrintHelper.asString((BigDecimal)discountAbs, (String)"", (boolean)true)), (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)MeasurementPreliminaryStandardPrintService.descriptionCell((PrintSetup)printSetup, (Color)DETAIL_TEXT_COLOR, (String)PrintHelper.asString((BigDecimal)discountValueNegated, (String)"", (boolean)true), (HorizontalAlignment)HorizontalAlignment.RIGHT)).build();
            tableBuilder.addRow(discountRow);
        }
        BigDecimal valueOverallWithDiscount = IterableHelper.stream((Iterable)groupPrices).map(AddendumGroupPrice::getPriceAggregatedWithDiscount).reduce(BigDecimal.ZERO, BigDecimal::add);
        Row sumNetWithDiscountRow = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)MeasurementPreliminaryStandardPrintService.descriptionCell((PrintSetup)printSetup, (Color)DETAIL_TEXT_COLOR, (String)"Summenaufma\u00dfwert Netto in EUR:", (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)MeasurementPreliminaryStandardPrintService.descriptionCell((PrintSetup)printSetup, (Color)DETAIL_TEXT_COLOR, (String)"", (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)MeasurementPreliminaryStandardPrintService.descriptionCell((PrintSetup)printSetup, (Color)DETAIL_TEXT_COLOR, (String)PrintHelper.asString((BigDecimal)valueOverallWithDiscount, (String)"", (boolean)true), (HorizontalAlignment)HorizontalAlignment.RIGHT)).build();
        tableBuilder.addRow(sumNetWithDiscountRow);
        tableBuilder.addRow(this.hLineTB((Iterable)ImmutableList.of((Object)Pair.of((Object)2, (Object)false), (Object)Pair.of((Object)1, (Object)true))));
        return tableBuilder.build();
    }
}

