/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service.print;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import de.qfm.erp.service.configuration.PrintLayoutConfig;
import de.qfm.erp.service.model.internal.print.EPrintFontSize;
import de.qfm.erp.service.model.internal.print.PrintConfiguration;
import de.qfm.erp.service.model.internal.print.PrintFonts;
import de.qfm.erp.service.model.internal.print.PrintInfo;
import de.qfm.erp.service.model.internal.print.PrintSetup;
import de.qfm.erp.service.model.internal.print.measurement.MeasurementCumulativePrintGroup;
import de.qfm.erp.service.model.internal.print.measurement.MeasurementCumulativePrintInfo;
import de.qfm.erp.service.model.internal.print.measurement.MeasurementCumulativePrintRow;
import de.qfm.erp.service.model.internal.print.payroll.MeasurementCumulativePrintConfiguration;
import de.qfm.erp.service.model.jpa.configuration.ConfigurationCompany;
import de.qfm.erp.service.service.route.impl.PrintHelper;
import de.qfm.erp.service.service.security.UserService;
import de.qfm.erp.service.service.service.DateTimeHelperService;
import de.qfm.erp.service.service.service.print.AbstractPrintService;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.vandeseer.easytable.TableDrawer;
import org.vandeseer.easytable.settings.HorizontalAlignment;
import org.vandeseer.easytable.settings.VerticalAlignment;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.ImageCell;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class MeasurementCumulativePrintService
extends AbstractPrintService<MeasurementCumulativePrintInfo, MeasurementCumulativePrintConfiguration> {
    protected static final float INVOICE_MARGIN_LEFT_RIGHT = 70.75f;
    protected static final float INVOICE_MARGIN_TOP_BOTTOM = 48.11f;
    protected static final float LOGO_HEADER_DISTANCE = 36.79f;
    private final PrintLayoutConfig printLayoutConfig;

    @Autowired
    public MeasurementCumulativePrintService(UserService userService, DateTimeHelperService dateTimeHelperService, PrintHelper printHelper, PrintLayoutConfig printLayoutConfig) {
        super(userService, dateTimeHelperService, printHelper);
        this.printLayoutConfig = printLayoutConfig;
    }

    @Nonnull
    public PDDocumentInformation apply(@NonNull PDDocumentInformation documentInformation, @NonNull MeasurementCumulativePrintInfo printInfo, @NonNull MeasurementCumulativePrintConfiguration printConfiguration) {
        if (documentInformation == null) {
            throw new NullPointerException("documentInformation is marked non-null but is null");
        }
        if (printInfo == null) {
            throw new NullPointerException("printInfo is marked non-null but is null");
        }
        if (printConfiguration == null) {
            throw new NullPointerException("printConfiguration is marked non-null but is null");
        }
        documentInformation.setKeywords("TODO");
        documentInformation.setTitle(String.format("INVOICE: %s", UUID.randomUUID()));
        documentInformation.setSubject(String.format("EMPLOYEE: %s", UUID.randomUUID()));
        return documentInformation;
    }

    protected static float maxWidth(@NonNull PDRectangle mediaBox) {
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        return mediaBox.getWidth() - 141.5f;
    }

    @Nonnull
    private Table headersP1(@NonNull MeasurementCumulativePrintInfo printInfo, @NonNull PDDocument document, @NonNull PDRectangle mediaBox, @NonNull PrintSetup printSetup, int page, int pageCount) throws IOException {
        if (printInfo == null) {
            throw new NullPointerException("printInfo is marked non-null but is null");
        }
        if (document == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        PrintFonts printFonts = printSetup.getPrintFonts();
        byte[] logoBuffer = printSetup.getLogoBuffer();
        PDImageXObject pdImageXObject = PDImageXObject.createFromByteArray((PDDocument)document, (byte[])logoBuffer, (String)"");
        ImmutableList columns = ImmutableList.of((Object)Float.valueOf(0.67f), (Object)Float.valueOf(0.17f), (Object)Float.valueOf(0.16f));
        int columnCount = columns.size();
        Table.TableBuilder headerBuilder = MeasurementCumulativePrintService.table((Float)Float.valueOf(MeasurementCumulativePrintService.maxWidth((PDRectangle)mediaBox)), (Iterable)columns);
        headerBuilder.addRow(Row.builder().add((AbstractCell)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)ImageCell.builder().horizontalAlignment(HorizontalAlignment.LEFT)).padding(0.0f)).paddingLeft(printSetup.getLogoPaddingLeft())).verticalAlignment(VerticalAlignment.MIDDLE)).image(pdImageXObject).maxHeight((float)printSetup.getLogoHeight()).borderWidth(0.0f)).build()).add((AbstractCell)MeasurementCumulativePrintService.emptyCell((PrintSetup)printSetup, (int)2)).build());
        String measurementListLabel = StringUtils.trimToEmpty((String)String.format("Aufma\u00dfliste %s", printInfo.isCumulativePrint() ? "(kumuliert)" : ""));
        headerBuilder.addRow(Row.builder().add((AbstractCell)MeasurementCumulativePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)printFonts.getBold(), (Color)FOOTER_TEXT_COLOR, (String)measurementListLabel)).add((AbstractCell)MeasurementCumulativePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)printFonts.getBold(), (Color)FOOTER_TEXT_COLOR, (String)"Datum")).add((AbstractCell)MeasurementCumulativePrintService.emptyCell((PrintSetup)printSetup)).build());
        LocalDate invoiceDate = printInfo.getInvoiceDate();
        String germanFullDate = null != invoiceDate ? DateTimeHelperService.germanFullDate((LocalDate)invoiceDate) : "";
        String dateAndPage = String.format("%s | Seite %s/%s", germanFullDate, page, pageCount);
        headerBuilder.addRow(Row.builder().add((AbstractCell)MeasurementCumulativePrintService.emptyCell((PrintSetup)printSetup)).add((AbstractCell)MeasurementCumulativePrintService.descriptionCell((PrintFonts)printFonts, (int)printSetup.getDetailsFontSize(), (String)dateAndPage, (int)2, (int)1, (Color)FOOTER_TEXT_COLOR, (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)ImmutableMap.of())).build());
        ImmutableList measurementNumbers = ImmutableList.sortedCopyOf((Iterable)printInfo.getMeasurementNumbers());
        String measurementLabel = measurementNumbers.size() > 1 ? "Aufma\u00dfe" : "Aufma\u00df";
        headerBuilder.addRow(Row.builder().add((AbstractCell)MeasurementCumulativePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)printFonts.getBold(), (Color)FOOTER_TEXT_COLOR, (String)measurementLabel)).add((AbstractCell)MeasurementCumulativePrintService.emptyCell((PrintSetup)printSetup, (int)2)).build());
        String measurementNumberString = Joiner.on((String)", ").skipNulls().join((Iterable)measurementNumbers);
        headerBuilder.addRow(Row.builder().add((AbstractCell)MeasurementCumulativePrintService.descriptionCell((PrintSetup)printSetup, (Color)FOOTER_TEXT_COLOR, (String)measurementNumberString)).add((AbstractCell)MeasurementCumulativePrintService.emptyCell((PrintSetup)printSetup, (int)2)).build());
        headerBuilder.addRow(Row.builder().add((AbstractCell)MeasurementCumulativePrintService.emptyCell((PrintSetup)printSetup, (int)columnCount)).build());
        return headerBuilder.build();
    }

    @Nonnull
    private Table headersP2(@NonNull MeasurementCumulativePrintInfo printInfo, @NonNull PDDocument document, @NonNull PDRectangle mediaBox, @NonNull PrintSetup printSetup, int page, int pageCount) throws IOException {
        if (printInfo == null) {
            throw new NullPointerException("printInfo is marked non-null but is null");
        }
        if (document == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        PrintFonts printFonts = printSetup.getPrintFonts();
        byte[] logoBuffer = printSetup.getLogoBuffer();
        PDFont fontsBold = printFonts.getBold();
        PDImageXObject pdImageXObject = PDImageXObject.createFromByteArray((PDDocument)document, (byte[])logoBuffer, (String)"");
        ImmutableList columns = ImmutableList.of((Object)Float.valueOf(0.67f), (Object)Float.valueOf(0.17f), (Object)Float.valueOf(0.16f));
        int columnCount = columns.size();
        Table.TableBuilder headerBuilder = MeasurementCumulativePrintService.table((Float)Float.valueOf(MeasurementCumulativePrintService.maxWidth((PDRectangle)mediaBox)), (Iterable)columns);
        headerBuilder.addRow(Row.builder().add((AbstractCell)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)ImageCell.builder().horizontalAlignment(HorizontalAlignment.LEFT)).padding(0.0f)).paddingLeft(printSetup.getLogoPaddingLeft())).verticalAlignment(VerticalAlignment.MIDDLE)).image(pdImageXObject).maxHeight((float)printSetup.getLogoHeight()).borderWidth(0.0f)).build()).add((AbstractCell)MeasurementCumulativePrintService.emptyCell((PrintSetup)printSetup, (int)2)).build());
        headerBuilder.addRow(Row.builder().fontSize(Integer.valueOf(1)).height(Float.valueOf(36.79f)).add((AbstractCell)MeasurementCumulativePrintService.emptyCell((int)1, (int)columns.size())).build());
        String measurementListLabel = StringUtils.trimToEmpty((String)String.format("Aufma\u00dfliste %s", printInfo.isCumulativePrint() ? "(kumuliert)" : ""));
        headerBuilder.addRow(Row.builder().add((AbstractCell)MeasurementCumulativePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontsBold, (Color)FOOTER_TEXT_COLOR, (String)measurementListLabel)).add((AbstractCell)MeasurementCumulativePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontsBold, (Color)FOOTER_TEXT_COLOR, (String)"Datum")).add((AbstractCell)MeasurementCumulativePrintService.emptyCell((PrintSetup)printSetup)).build());
        LocalDate invoiceDate = printInfo.getInvoiceDate();
        String germanFullDate = null != invoiceDate ? DateTimeHelperService.germanFullDate((LocalDate)invoiceDate) : "";
        String dateAndPage = String.format("%s | Seite %s/%s", germanFullDate, page, pageCount);
        headerBuilder.addRow(Row.builder().add((AbstractCell)MeasurementCumulativePrintService.emptyCell((PrintSetup)printSetup)).add((AbstractCell)MeasurementCumulativePrintService.descriptionCell((PrintFonts)printFonts, (int)printSetup.getDetailsFontSize(), (String)dateAndPage, (int)2, (int)1, (Color)FOOTER_TEXT_COLOR, (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)ImmutableMap.of())).build());
        headerBuilder.addRow(Row.builder().add((AbstractCell)MeasurementCumulativePrintService.emptyCell((PrintSetup)printSetup, (int)columnCount)).build());
        return headerBuilder.build();
    }

    public byte[] generatePDF(@NonNull MeasurementCumulativePrintInfo printInfo, @NonNull MeasurementCumulativePrintConfiguration printConfiguration, @NonNull EPrintFontSize printFontSize, @NonNull ConfigurationCompany configurationCompany) {
        byte[] byArray;
        block22: {
            if (printInfo == null) {
                throw new NullPointerException("printInfo is marked non-null but is null");
            }
            if (printConfiguration == null) {
                throw new NullPointerException("printConfiguration is marked non-null but is null");
            }
            if (printFontSize == null) {
                throw new NullPointerException("printFontSize is marked non-null but is null");
            }
            if (configurationCompany == null) {
                throw new NullPointerException("configurationCompany is marked non-null but is null");
            }
            PDRectangle mediaBox = new PDRectangle(PDRectangle.A4.getWidth(), PDRectangle.A4.getHeight());
            String primaryResponsibleUserFullName = StringUtils.trimToEmpty((String)printInfo.getPrimaryResponsibleUserFullName());
            PDDocument document = this.document((PrintInfo)printInfo, (PrintConfiguration)printConfiguration, primaryResponsibleUserFullName);
            try {
                PrintSetup printSetup = PrintHelper.printSetup((PrintLayoutConfig)this.printLayoutConfig, (ConfigurationCompany)configurationCompany, (EPrintFontSize)printFontSize, (PDDocument)document, PrintLayoutConfig::getMeasurementCumulativeLogoPadding, PrintLayoutConfig::getMeasurementCumulativeLogoHeight, PrintLayoutConfig::getMeasurementCumulativeLogoBuffer);
                Table footer = this.legalCompanyFooter(mediaBox, printSetup);
                Table blankHeaderP1 = this.headersP1(printInfo, document, mediaBox, printSetup, 0, 0);
                Table blankHeaderP2 = this.headersP2(printInfo, document, mediaBox, printSetup, 0, 0);
                float maxDetailsHeightFirstPage = MeasurementCumulativePrintService.maxDetailsHeight((PDRectangle)mediaBox, (float)blankHeaderP1.getHeight(), (float)footer.getHeight(), (float)0.0f);
                float maxDetailsHeightRest = MeasurementCumulativePrintService.maxDetailsHeight((PDRectangle)mediaBox, (float)blankHeaderP2.getHeight(), (float)footer.getHeight(), (float)0.0f);
                Table details = this.details(printInfo, mediaBox, printSetup);
                if (details.getRows().isEmpty()) {
                    MeasurementCumulativePrintService.printEmptyPage((PDDocument)document, (PDRectangle)mediaBox, (List)ImmutableList.of());
                } else {
                    List pagedTables = MeasurementCumulativePrintService.splitVertically((Table)details, (int)3, (float)maxDetailsHeightFirstPage, (float)maxDetailsHeightRest);
                    int pages = Iterables.size((Iterable)pagedTables);
                    for (int pageNumber = 0; pageNumber < pages; ++pageNumber) {
                        ImmutableList headers;
                        Table detailsTable = (Table)Iterables.get((Iterable)pagedTables, (int)pageNumber);
                        if (pageNumber == 0) {
                            Table headersP1 = this.headersP1(printInfo, document, mediaBox, printSetup, 1 + pageNumber, pages);
                            headers = ImmutableList.of((Object)headersP1);
                        } else {
                            Table headersP2 = this.headersP2(printInfo, document, mediaBox, printSetup, 1 + pageNumber, pages);
                            headers = ImmutableList.of((Object)headersP2);
                        }
                        PDPage page = MeasurementCumulativePrintService.page((PDDocument)document, (PDRectangle)mediaBox);
                        try (PDPageContentStream contentStream = new PDPageContentStream(document, page);){
                            float yOffset = MeasurementCumulativePrintService.printHeader((PDPageContentStream)contentStream, (PDPage)page, (Iterable)headers);
                            TableDrawer.builder().page(page).contentStream(contentStream).startX(70.75f).startY(yOffset -= 10.0f).table(detailsTable).build().draw();
                            yOffset -= detailsTable.getHeight();
                            if (pageNumber != 0) continue;
                            yOffset -= this.printFooter(contentStream, page, footer);
                            continue;
                        }
                    }
                }
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                document.save((OutputStream)outputStream);
                byArray = outputStream.toByteArray();
                if (document == null) break block22;
            }
            catch (Throwable throwable) {
                try {
                    if (document != null) {
                        try {
                            document.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return new byte[0];
                }
            }
            document.close();
        }
        return byArray;
    }

    protected static float printHeader(@Nonnull PDPageContentStream contentStream, @Nonnull PDPage page, @Nonnull Iterable<Table> headers) {
        PDRectangle mediaBox = page.getMediaBox();
        float yOffset = mediaBox.getHeight() - 48.11f;
        for (Table header : headers) {
            TableDrawer.builder().page(page).contentStream(contentStream).startX(70.75f).startY(yOffset).table(header).build().draw();
            yOffset -= header.getHeight();
        }
        return yOffset;
    }

    private float printFooter(@NonNull PDPageContentStream contentStream, @NonNull PDPage page, @NonNull Table footer) {
        if (contentStream == null) {
            throw new NullPointerException("contentStream is marked non-null but is null");
        }
        if (page == null) {
            throw new NullPointerException("page is marked non-null but is null");
        }
        if (footer == null) {
            throw new NullPointerException("footer is marked non-null but is null");
        }
        float footerHeight = footer.getHeight();
        float yOffset = 48.11f + footerHeight;
        TableDrawer.builder().page(page).contentStream(contentStream).startX(70.75f).startY(yOffset).table(footer).build().draw();
        return yOffset -= footer.getHeight();
    }

    @Nonnull
    public Table details(@NonNull MeasurementCumulativePrintInfo printInfo, @NonNull PDRectangle mediaBox, @NonNull PrintSetup printSetup) {
        if (printInfo == null) {
            throw new NullPointerException("printInfo is marked non-null but is null");
        }
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        PrintFonts printFonts = printSetup.getPrintFonts();
        PDFont fontBold = printFonts.getBold();
        Iterable printGroups = (Iterable)MoreObjects.firstNonNull((Object)printInfo.getMeasurementCumulativePrintGroups(), (Object)ImmutableList.of());
        ImmutableList columnWidths = ImmutableList.of((Object)Float.valueOf(0.15625f), (Object)Float.valueOf(0.09375f), (Object)Float.valueOf(0.1875f), (Object)Float.valueOf(0.1875f), (Object)Float.valueOf(0.125f), (Object)Float.valueOf(0.09375f), (Object)Float.valueOf(0.15625f));
        Table.TableBuilder tableBuilder = MeasurementCumulativePrintService.table((Float)Float.valueOf(MeasurementCumulativePrintService.maxWidth((PDRectangle)mediaBox)), (Iterable)columnWidths);
        tableBuilder.addRow(this.hLineB(Iterables.size((Iterable)columnWidths)));
        Row headline1 = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)MeasurementCumulativePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)FOOTER_TEXT_COLOR, (String)"Positionsnummer")).add((AbstractCell)MeasurementCumulativePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)FOOTER_TEXT_COLOR, (String)"Aufma\u00df")).add((AbstractCell)MeasurementCumulativePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)FOOTER_TEXT_COLOR, (String)"Bemerkung", (HorizontalAlignment)HorizontalAlignment.LEFT)).add((AbstractCell)MeasurementCumulativePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)FOOTER_TEXT_COLOR, (String)"Name", (HorizontalAlignment)HorizontalAlignment.LEFT)).add((AbstractCell)MeasurementCumulativePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)FOOTER_TEXT_COLOR, (String)"Faktoren", (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)MeasurementCumulativePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)FOOTER_TEXT_COLOR, (String)"EH", (HorizontalAlignment)HorizontalAlignment.LEFT)).add((AbstractCell)MeasurementCumulativePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)FOOTER_TEXT_COLOR, (String)"Produkt", (HorizontalAlignment)HorizontalAlignment.RIGHT)).build();
        tableBuilder.addRow(headline1);
        tableBuilder.addRow(this.hLineT(Iterables.size((Iterable)columnWidths)));
        for (MeasurementCumulativePrintGroup printGroup : printGroups) {
            Iterable printRows = printGroup.getRows();
            for (MeasurementCumulativePrintRow item : printRows) {
                String productAsString = PrintHelper.asString((BigDecimal)item.getProduct(), (String)"0,00", (boolean)true);
                String measurementNumber = item.getMeasurementNumber();
                String positionNumber = item.getSurrogatePositionNumber();
                String remarks = this.maxLength(item.getRemarks(), 50);
                String shortText = this.maxLength(item.getShortText(), 50);
                String amount = Joiner.on((char)'x').skipNulls().join((Object)item.getAmount(), (Object)item.getFactor1(), new Object[]{item.getFactor2(), item.getFactor3()});
                String unit = StringUtils.trimToEmpty((String)item.getUnit());
                Row detail = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)MeasurementCumulativePrintService.descriptionCell((PrintSetup)printSetup, (Color)FOOTER_TEXT_COLOR, (String)positionNumber, (HorizontalAlignment)HorizontalAlignment.LEFT)).add((AbstractCell)MeasurementCumulativePrintService.descriptionCell((PrintSetup)printSetup, (Color)FOOTER_TEXT_COLOR, (String)measurementNumber, (HorizontalAlignment)HorizontalAlignment.LEFT)).add((AbstractCell)MeasurementCumulativePrintService.descriptionCell((PrintSetup)printSetup, (Color)FOOTER_TEXT_COLOR, (String)remarks, (HorizontalAlignment)HorizontalAlignment.LEFT)).add((AbstractCell)MeasurementCumulativePrintService.descriptionCell((PrintSetup)printSetup, (Color)FOOTER_TEXT_COLOR, (String)shortText, (HorizontalAlignment)HorizontalAlignment.LEFT)).add((AbstractCell)MeasurementCumulativePrintService.descriptionCell((PrintSetup)printSetup, (Color)FOOTER_TEXT_COLOR, (String)amount, (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)MeasurementCumulativePrintService.descriptionCell((PrintSetup)printSetup, (Color)FOOTER_TEXT_COLOR, (String)unit, (HorizontalAlignment)HorizontalAlignment.LEFT)).add((AbstractCell)MeasurementCumulativePrintService.descriptionCell((PrintSetup)printSetup, (Color)FOOTER_TEXT_COLOR, (String)productAsString, (HorizontalAlignment)HorizontalAlignment.RIGHT)).build();
                tableBuilder.addRow(detail);
            }
            String productAsString = PrintHelper.asString((BigDecimal)printGroup.getProduct(), (String)"", (boolean)true);
            Row aggregationRow1 = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)MeasurementCumulativePrintService.descriptionCell((PrintSetup)printSetup, (Color)FOOTER_TEXT_COLOR, (int)(Iterables.size((Iterable)columnWidths) - 1), (String)"Summe:", (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)MeasurementCumulativePrintService.descriptionCell((PrintSetup)printSetup, (Color)FOOTER_TEXT_COLOR, (int)1, (String)productAsString, (HorizontalAlignment)HorizontalAlignment.RIGHT)).build();
            tableBuilder.addRow(aggregationRow1);
            tableBuilder.addRow(this.hLineB(Iterables.size((Iterable)columnWidths)));
        }
        return tableBuilder.build();
    }

    @Nonnull
    private String maxLength(@NonNull String value, int length) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        String suffix = StringUtils.length((CharSequence)value) > length ? "..." : "";
        return StringUtils.left((String)value, (int)length) + suffix;
    }
}

