/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service.print;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import com.google.common.primitives.Floats;
import com.google.common.primitives.Ints;
import de.leancoders.common.helper.IterableHelper;
import de.qfm.erp.service.helper.BigDecimalHelper;
import de.qfm.erp.service.helper.DurationHelper;
import de.qfm.erp.service.model.internal.pdfbox.EBooleanPrintOption;
import de.qfm.erp.service.model.internal.pdfbox.ECellPrintOption;
import de.qfm.erp.service.model.internal.pdfbox.EValueSource;
import de.qfm.erp.service.model.internal.pdfbox.ValuedTextCell;
import de.qfm.erp.service.model.internal.print.EPrintFontSize;
import de.qfm.erp.service.model.internal.print.PrintConfiguration;
import de.qfm.erp.service.model.internal.print.PrintFonts;
import de.qfm.erp.service.model.internal.print.PrintInfo;
import de.qfm.erp.service.model.internal.print.PrintSetup;
import de.qfm.erp.service.model.internal.print.payroll.AttendanceReportPrintStandard;
import de.qfm.erp.service.model.internal.print.payroll.BadWeatherReportPrintStandard;
import de.qfm.erp.service.model.internal.print.payroll.PayrollMonthAttendance;
import de.qfm.erp.service.model.jpa.configuration.ConfigurationCompany;
import de.qfm.erp.service.model.jpa.employee.attendance.EAggregatedAttendanceDayType;
import de.qfm.erp.service.model.jpa.generic.EDay;
import de.qfm.erp.service.model.jpa.generic.EDayType;
import de.qfm.erp.service.model.jpa.user.EPrivilege;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.service.route.impl.PrintHelper;
import de.qfm.erp.service.service.security.UserService;
import de.qfm.erp.service.service.service.AbstractDocumentOutputService;
import de.qfm.erp.service.service.service.DateTimeHelperService;
import de.qfm.erp.service.service.service.print.AbstractPrintService;
import java.awt.Color;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Currency;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.font.Standard14Fonts;
import org.vandeseer.easytable.TableDrawer;
import org.vandeseer.easytable.settings.HorizontalAlignment;
import org.vandeseer.easytable.settings.VerticalAlignment;
import org.vandeseer.easytable.structure.Column;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.TextCell;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class AbstractPrintService<T extends PrintInfo, V extends PrintConfiguration>
extends AbstractDocumentOutputService {
    protected static final Boolean HIDE_NOT_RELEVANT_INFORMATION = Boolean.TRUE;
    protected static final String NO_ROW_KEY = "no-row-key";
    protected static final String NO_COLUMN_KEY = "no-column-key";
    private static final PrintFonts EMPTY_PRINT_FONTS = PrintFonts.of((PDFont)new PDType1Font(Standard14Fonts.FontName.HELVETICA), (PDFont)new PDType1Font(Standard14Fonts.FontName.HELVETICA_BOLD), (PDFont)new PDType1Font(Standard14Fonts.FontName.HELVETICA_OBLIQUE));
    protected static final float MARGIN_HEADER_TOP = 20.0f;
    protected static final float MARGIN_FOOTER_BOTTOM = 30.0f;
    protected static final float MARGIN_META_BOTTOM = 20.0f;
    protected static final float MARGIN_LEFT_RIGHT = 20.0f;
    protected static final float MARGIN_BETWEEN_TABLES = 10.0f;
    protected static final float TOO_SMALL_TO_START_TABLE = 10.0f;
    protected static final float MM_PER_UNIT = 2.83f;
    protected static final float FOOTER_MARGIN_LEFT_RIGHT = 70.75f;
    protected static final Color FOOTER_TEXT_COLOR = Color.BLACK;
    protected static final float NORMAL_BORDER_WIDTH = 0.25f;
    protected static final float BOLD_BORDER_WIDTH = 0.75f;
    protected static final float NO_BORDER_WIDTH = 0.0f;
    protected static final int DETAIL_PADDING = 2;
    protected static final int AGGREGATION_PADDING = 2;
    protected static final int NO_SPAN = 1;
    protected static final Color DETAIL_FILLUP_BORDER_COLOR = Color.BLACK;
    protected static final Color DETAIL_TEXT_COLOR = Color.BLACK;
    protected static final Color DETAIL_BG_COLOR_HEADER = new Color(255, 255, 255);
    protected static final Color DETAIL_BG_COLOR_UNEVEN = new Color(240, 240, 240);
    protected static final Color DETAIL_BG_COLOR_EVEN = new Color(255, 255, 255);
    protected static final Color DEFAULT_BG_COLOR_DETAILS = new Color(255, 255, 255);
    protected static final Color DEFAULT_BG_COLOR_AGGREGATION = new Color(255, 255, 255);
    protected static final Color HIGHLIGHT_BG_COLOR_BANKING_HOLIDAY = new Color(225, 225, 225);
    protected static final Color HIGHLIGHT_BG_COLOR_WEEKEND = new Color(225, 225, 225);
    protected static final float W_1_16 = 0.0625f;
    protected static final float W_2_16 = 0.125f;
    protected static final float W_3_16 = 0.1875f;
    protected static final float W_4_16 = 0.25f;
    protected static final float W_1_12 = 0.083333336f;
    protected static final float W_2_12 = 0.16666667f;
    protected static final float W_3_12 = 0.25f;
    protected static final float W_4_12 = 0.33333334f;
    protected static final float W_1_32 = 0.03125f;
    protected static final float W_32_32 = 1.0f;
    protected static final float W_31_32 = 0.96875f;
    protected static final float W_28_32 = 0.875f;
    protected static final float W_24_32 = 0.75f;
    protected static final float W_22_32 = 0.6875f;
    protected static final float W_21_32 = 0.65625f;
    protected static final float W_20_32 = 0.625f;
    protected static final float W_19_32 = 0.59375f;
    protected static final float W_18_32 = 0.5625f;
    protected static final float W_16_32 = 0.5f;
    protected static final float W_15_32 = 0.46875f;
    protected static final float W_14_32 = 0.4375f;
    protected static final float W_12_32 = 0.375f;
    protected static final float W_11_32 = 0.34375f;
    protected static final float W_10_32 = 0.3125f;
    protected static final float W_8_32 = 0.25f;
    protected static final float W_7_32 = 0.21875f;
    protected static final float W_6_32 = 0.1875f;
    protected static final float W_5_32 = 0.15625f;
    protected static final float W_4_32 = 0.125f;
    protected static final float W_3_32 = 0.09375f;
    protected static final float W_2_32 = 0.0625f;
    protected static final Iterable<EBorder> ALL = ImmutableSet.copyOf((Object[])EBorder.values());
    protected static final Iterable<EBorder> T = ImmutableSet.of((Object)EBorder.TOP);
    protected static final Iterable<EBorder> L = ImmutableSet.of((Object)EBorder.LEFT);
    protected static final Iterable<EBorder> B = ImmutableSet.of((Object)EBorder.BOTTOM);
    protected static final Iterable<EBorder> R = ImmutableSet.of((Object)EBorder.RIGHT);
    protected static final Iterable<EBorder> LB = ImmutableSet.of((Object)EBorder.LEFT, (Object)EBorder.BOTTOM);
    protected static final Iterable<EBorder> LR = ImmutableSet.of((Object)EBorder.LEFT, (Object)EBorder.RIGHT);
    protected static final Iterable<EBorder> TL = ImmutableSet.of((Object)EBorder.TOP, (Object)EBorder.LEFT);
    protected static final Iterable<EBorder> TR = ImmutableSet.of((Object)EBorder.TOP, (Object)EBorder.RIGHT);
    protected static final Iterable<EBorder> RB = ImmutableSet.of((Object)EBorder.RIGHT, (Object)EBorder.BOTTOM);
    protected static final Iterable<EBorder> TLB = ImmutableSet.of((Object)EBorder.TOP, (Object)EBorder.LEFT, (Object)EBorder.BOTTOM);
    protected static final Iterable<EBorder> TLR = ImmutableSet.of((Object)EBorder.TOP, (Object)EBorder.LEFT, (Object)EBorder.RIGHT);
    protected static final Iterable<EBorder> TBR = ImmutableSet.of((Object)EBorder.TOP, (Object)EBorder.BOTTOM, (Object)EBorder.RIGHT);
    protected static final Iterable<EBorder> TB = ImmutableSet.of((Object)EBorder.TOP, (Object)EBorder.BOTTOM);
    protected static final Iterable<EBorder> LRB = ImmutableSet.of((Object)EBorder.LEFT, (Object)EBorder.RIGHT, (Object)EBorder.BOTTOM);
    protected static final Iterable<EBorder> TRB = ImmutableSet.of((Object)EBorder.TOP, (Object)EBorder.RIGHT, (Object)EBorder.BOTTOM);
    protected final UserService userService;
    protected final DateTimeHelperService dateTimeHelperService;
    protected final PrintHelper printHelper;
    private static final CharMatcher VALID_CHARS = CharMatcher.inRange((char)' ', (char)'~').or(CharMatcher.anyOf((CharSequence)"!\n\"#\u20ac$%&'()*+,-./0123456789:;<=>?@[\\]^_`{|}~\u2022\u00a1\u00a2\u00a3\u00a4\u00a5\u00a6\u00a7\u00a8\u00a9\u00aa\u00ab\u00ac\u00ae\u00af\u00b0\u00b1\u00b2\u00b3\u00b4\u00b5\u00b6\u00b7\u00b8\u00b9\u00ba\u00bb\u00bc\u00bd\u00be\u00bf\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00c6\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d0\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u00d7\u00d8\u00d9\u00da\u00db\u00dc\u00dd\u00de\u00df\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e6\u00e7\u00e8\u00e9\u00ea\u00eb\u011f\u00ec\u00ed\u00ee\u00ef\u00f0\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f7\u00f8\u00f9\u00fa\u00fb\u00fc\u00fd\u00fe")).and(CharMatcher.is((char)'\t').negate()).precomputed();
    private static final DateTimeFormatter HOUR_MINUTE_FORMATTER = DateTimeFormatter.ofPattern("HH:mm");
    private static final Set<EDayType> HIGHLIGHT_DAY_TYPE = ImmutableSet.of((Object)EDayType.BANKING_HOLIDAY);
    private static final Set<EDay> HIGHLIGHT_DAY = ImmutableSet.of((Object)EDay.SATURDAY, (Object)EDay.SUNDAY);
    public static final int MIN_SPACE_LEFT = 5;

    @Nonnull
    public abstract PDDocumentInformation apply(@NonNull PDDocumentInformation var1, @NonNull T var2, @NonNull V var3);

    public abstract byte[] generatePDF(@NonNull T var1, @NonNull V var2, @NonNull EPrintFontSize var3, @NonNull ConfigurationCompany var4);

    @Nonnull
    protected PDDocument document(@NonNull T printInfo, @NonNull V printConfiguration) {
        if (printInfo == null) {
            throw new NullPointerException("printInfo is marked non-null but is null");
        }
        if (printConfiguration == null) {
            throw new NullPointerException("printConfiguration is marked non-null but is null");
        }
        User user = this.userService.authenticatedUser();
        return this.document(printInfo, printConfiguration, user.getFullName());
    }

    @Nonnull
    protected PDDocument document(@NonNull T printInfo, @NonNull V printConfiguration, @NonNull String fullName) {
        if (printInfo == null) {
            throw new NullPointerException("printInfo is marked non-null but is null");
        }
        if (printConfiguration == null) {
            throw new NullPointerException("printConfiguration is marked non-null but is null");
        }
        if (fullName == null) {
            throw new NullPointerException("fullName is marked non-null but is null");
        }
        PDDocumentInformation info = new PDDocumentInformation();
        info.setAuthor(fullName);
        info.setCreationDate(Calendar.getInstance(Locale.GERMAN));
        info.setCreator("AppQ - PDF/Druck");
        info.setProducer("AppQ - eine QFM Anwendung");
        PDDocument document = new PDDocument();
        document.setDocumentInformation(this.apply(info, printInfo, printConfiguration));
        return document;
    }

    protected static void printEmptyPage(@NonNull PDDocument document, @NonNull PDRectangle mediaBox, @NonNull List<Table> headers) throws IOException {
        if (document == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        if (headers == null) {
            throw new NullPointerException("headers is marked non-null but is null");
        }
        PDPage page = AbstractPrintService.page((PDDocument)document, (PDRectangle)mediaBox);
        try (PDPageContentStream contentStream = new PDPageContentStream(document, page);){
            AbstractPrintService.printHeader((PDPageContentStream)contentStream, (PDPage)page, headers);
        }
    }

    protected static float printHeader(@Nonnull PDPageContentStream contentStream, @Nonnull PDPage page, @Nonnull Iterable<Table> headers) {
        PDRectangle mediaBox = page.getMediaBox();
        float yOffset = mediaBox.getHeight() - 20.0f;
        for (Table header : headers) {
            TableDrawer.builder().page(page).contentStream(contentStream).startX(20.0f).startY(yOffset).table(header).build().draw();
            yOffset -= header.getHeight();
        }
        return yOffset;
    }

    protected static float height(@NonNull Table table) {
        if (table == null) {
            throw new NullPointerException("table is marked non-null but is null");
        }
        return table.getHeight();
    }

    protected static float width(@NonNull Table table) {
        if (table == null) {
            throw new NullPointerException("table is marked non-null but is null");
        }
        return IterableHelper.sum((Iterable)ImmutableList.copyOf(table.getColumns().stream().map(Column::getWidth).iterator()));
    }

    protected static boolean almostSame(float left, float right) {
        Range r1 = Range.closed((Comparable)Float.valueOf(left * 0.99f), (Comparable)Float.valueOf(left * 1.01f));
        Range r2 = Range.closed((Comparable)Float.valueOf(right * 0.99f), (Comparable)Float.valueOf(right * 1.01f));
        return r1.isConnected(r2);
    }

    protected static float maxDetailsHeight(PDRectangle mediaBox, float headerHeight, float footerHeight, float optionalNeededSpace) {
        return AbstractPrintService.maxDetailsHeight((PDRectangle)mediaBox, (float)headerHeight, (float)footerHeight, (float)optionalNeededSpace, (float)20.0f, (float)30.0f);
    }

    protected static float maxDetailsHeight(PDRectangle mediaBox, float headerHeight, float footerHeight, float optionalNeededSpace, float marginTop, float marginBottom) {
        return mediaBox.getHeight() - (2.0f * (marginTop + marginBottom) + headerHeight + 20.0f + footerHeight + optionalNeededSpace);
    }

    protected static float maxDetailsWidth(PDRectangle mediaBox) {
        return mediaBox.getWidth() - 40.0f;
    }

    @Nonnull
    protected static PDPage page(@NonNull PDDocument document, @NonNull PDRectangle mediaBox) {
        if (document == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        PDPage page = new PDPage(mediaBox);
        document.addPage(page);
        return page;
    }

    @Nonnull
    protected static String nullSafeString(@Nullable Integer value) {
        return null != value ? Integer.toString(value) : "";
    }

    @Nonnull
    protected static String nullSafeString(@Nullable BigDecimal value) {
        return null != value ? BigDecimalHelper.asString((BigDecimal)value) : "";
    }

    @Nonnull
    protected static String validText(@Nullable String input) {
        String trimmed = StringUtils.trimToEmpty((String)input);
        return VALID_CHARS.retainFrom((CharSequence)trimmed);
    }

    @Nonnull
    protected static String nullSafeCurrency(@Nullable BigDecimal value, @NonNull Currency currency) {
        if (currency == null) {
            throw new NullPointerException("currency is marked non-null but is null");
        }
        return null != value ? String.format("%s %s", BigDecimalHelper.asString((BigDecimal)value), currency.getCurrencyCode()) : "";
    }

    @VisibleForTesting
    protected static String safeSubString(String candidate, int maxHeaderTextLength) {
        return StringUtils.trimToEmpty((String)StringUtils.left((String)StringUtils.trimToEmpty((String)candidate), (int)maxHeaderTextLength));
    }

    protected static float rowHeight(@NonNull Iterable<Row> headers) {
        if (headers == null) {
            throw new NullPointerException("headers is marked non-null but is null");
        }
        return IterableHelper.stream(headers).map(Row::getHeight).reduce(Float.valueOf(0.0f), Float::sum).floatValue();
    }

    protected static float height(@NonNull Iterable<Table> tables) {
        if (tables == null) {
            throw new NullPointerException("tables is marked non-null but is null");
        }
        return IterableHelper.stream(tables).map(Table::getHeight).reduce(Float.valueOf(0.0f), Float::sum).floatValue();
    }

    protected static float maxWidth(@NonNull PDRectangle mediaBox) {
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        return mediaBox.getWidth() - 40.0f;
    }

    @Nonnull
    protected static Table.TableBuilder table(@NonNull PDRectangle mediaBox, @NonNull Iterable<Float> values) {
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        float maxWidth = AbstractPrintService.maxWidth((PDRectangle)mediaBox);
        return AbstractPrintService.table((Float)Float.valueOf(maxWidth), values);
    }

    @Nonnull
    protected static Table.TableBuilder table(@NonNull Float maxWidth, @NonNull Iterable<Float> values) {
        if (maxWidth == null) {
            throw new NullPointerException("maxWidth is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        float valuesSum = IterableHelper.sum(values);
        ImmutableList ratios = ImmutableList.copyOf(IterableHelper.stream(values).map(item -> Float.valueOf(item.floatValue() / valuesSum)).iterator());
        float[] widths = new float[ratios.size()];
        for (int i = 0; i < ratios.size(); ++i) {
            widths[i] = ((Float)ratios.get(i)).floatValue() * maxWidth.floatValue();
        }
        return Table.builder().addColumnsOfWidth(widths);
    }

    @Nonnull
    protected static TextCell legalCompanyFooterCell(@NonNull PrintFonts printFonts, int fontSize, @NonNull Color textColor, @Nullable String text) {
        if (printFonts == null) {
            throw new NullPointerException("printFonts is marked non-null but is null");
        }
        if (textColor == null) {
            throw new NullPointerException("textColor is marked non-null but is null");
        }
        return AbstractPrintService.legalCompanyFooterCell((PDFont)printFonts.getRegular(), (int)fontSize, (Color)textColor, (String)text);
    }

    @Nonnull
    protected static TextCell legalCompanyFooterCell(@NonNull PDFont font, int fontSize, @NonNull Color textColor, @Nullable String text) {
        if (font == null) {
            throw new NullPointerException("font is marked non-null but is null");
        }
        if (textColor == null) {
            throw new NullPointerException("textColor is marked non-null but is null");
        }
        String validText = AbstractPrintService.validText((String)text);
        return ((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().font(font)).fontSize(Integer.valueOf(fontSize))).colSpan(1)).rowSpan(1)).padding(0.0f)).horizontalAlignment(HorizontalAlignment.LEFT)).text(validText).textColor(textColor)).lineSpacing(0.5f)).borderWidthTop(0.0f)).borderWidthLeft(0.0f)).borderWidthRight(0.0f)).borderWidthBottom(0.0f)).build();
    }

    @Nonnull
    protected static TextCell footerCell(@NonNull PrintSetup printSetup, @NonNull PDFont font, @Nullable String text, @NonNull Iterable<EBorder> borders) {
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        if (font == null) {
            throw new NullPointerException("font is marked non-null but is null");
        }
        if (borders == null) {
            throw new NullPointerException("borders is marked non-null but is null");
        }
        return AbstractPrintService.footerCell((PrintSetup)printSetup, (PDFont)font, (String)StringUtils.trimToEmpty((String)text), borders, (HorizontalAlignment)HorizontalAlignment.LEFT, (int)1);
    }

    @Nonnull
    protected static TextCell footerCell(@NonNull PrintSetup printSetup, @NonNull PDFont font, @NonNull String text, @NonNull Iterable<EBorder> borders, HorizontalAlignment horizontalAlignment, int colSpan) {
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        if (font == null) {
            throw new NullPointerException("font is marked non-null but is null");
        }
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (borders == null) {
            throw new NullPointerException("borders is marked non-null but is null");
        }
        ImmutableSet s = ImmutableSet.copyOf(borders);
        int footerFontSize = printSetup.getFooterFontSize();
        boolean top = s.contains(EBorder.TOP);
        boolean left = s.contains(EBorder.LEFT);
        boolean right = s.contains(EBorder.RIGHT);
        boolean bottom = s.contains(EBorder.BOTTOM);
        return ((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().text(StringUtils.trimToEmpty((String)text)).padding(2.0f)).horizontalAlignment(horizontalAlignment)).borderWidthTop(top ? 0.25f : 0.0f)).borderWidthLeft(left ? 0.25f : 0.0f)).borderWidthRight(right ? 0.25f : 0.0f)).borderWidthBottom(bottom ? 0.25f : 0.0f)).font(font)).fontSize(Integer.valueOf(footerFontSize))).colSpan(colSpan)).build();
    }

    @Nonnull
    protected static TextCell borderCell(@NonNull Iterable<EBorder> borders, int rowSpan, int colSpan) {
        if (borders == null) {
            throw new NullPointerException("borders is marked non-null but is null");
        }
        ImmutableSet s = ImmutableSet.copyOf(borders);
        boolean top = s.contains(EBorder.TOP);
        boolean left = s.contains(EBorder.LEFT);
        boolean right = s.contains(EBorder.RIGHT);
        boolean bottom = s.contains(EBorder.BOTTOM);
        return ((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().text("").padding(0.0f)).borderWidthTop(top ? 0.25f : 0.0f)).borderWidthLeft(left ? 0.25f : 0.0f)).borderWidthRight(right ? 0.25f : 0.0f)).borderWidthBottom(bottom ? 0.25f : 0.0f)).fontSize(Integer.valueOf(1))).textHeight(Float.valueOf(1.0f))).minHeight(1.0f)).rowSpan(rowSpan)).colSpan(colSpan)).build();
    }

    @Nonnull
    protected static TextCell metaCell(@NonNull PrintSetup printSetup, @NonNull HorizontalAlignment horizontalAlignment, @Nullable String text, @NonNull Iterable<EBorder> borders) {
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        if (horizontalAlignment == null) {
            throw new NullPointerException("horizontalAlignment is marked non-null but is null");
        }
        if (borders == null) {
            throw new NullPointerException("borders is marked non-null but is null");
        }
        ImmutableSet s = ImmutableSet.copyOf(borders);
        int fontSize = printSetup.getMetaFontSize();
        boolean top = s.contains(EBorder.TOP);
        boolean left = s.contains(EBorder.LEFT);
        boolean right = s.contains(EBorder.RIGHT);
        boolean bottom = s.contains(EBorder.BOTTOM);
        return ((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().text(StringUtils.trimToEmpty((String)text)).padding(2.0f)).horizontalAlignment(horizontalAlignment)).borderWidthTop(top ? 0.25f : 0.0f)).borderWidthLeft(left ? 0.25f : 0.0f)).borderWidthRight(right ? 0.25f : 0.0f)).borderWidthBottom(bottom ? 0.25f : 0.0f)).fontSize(Integer.valueOf(fontSize))).build();
    }

    @Nonnull
    protected static TextCell titleCell(@NonNull PrintSetup printSetup, @Nullable String text) {
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        return AbstractPrintService.titleCell((PrintSetup)printSetup, (PDFont)printSetup.getPrintFonts().getRegular(), (String)text);
    }

    @Nonnull
    protected static TextCell titleCell(@NonNull PrintSetup printSetup, @NonNull PDFont pdFont, @Nullable String text) {
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        if (pdFont == null) {
            throw new NullPointerException("pdFont is marked non-null but is null");
        }
        return AbstractPrintService.titleCell((PrintSetup)printSetup, (PDFont)pdFont, (String)text, (Map)AbstractPrintService.defaultBorder((Iterable)ALL), (int)1);
    }

    @Nonnull
    protected static TextCell titleCell(@NonNull PrintSetup printSetup, @NonNull PDFont pdFont, @Nullable String text, @NonNull Map<EBorder, Float> borders, int rowSpan) {
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        if (pdFont == null) {
            throw new NullPointerException("pdFont is marked non-null but is null");
        }
        if (borders == null) {
            throw new NullPointerException("borders is marked non-null but is null");
        }
        int titleFontSize = printSetup.getTitleFontSize();
        float top = borders.getOrDefault(EBorder.TOP, Float.valueOf(0.0f)).floatValue();
        float left = borders.getOrDefault(EBorder.LEFT, Float.valueOf(0.0f)).floatValue();
        float right = borders.getOrDefault(EBorder.RIGHT, Float.valueOf(0.0f)).floatValue();
        float bottom = borders.getOrDefault(EBorder.BOTTOM, Float.valueOf(0.0f)).floatValue();
        return ((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().horizontalAlignment(HorizontalAlignment.CENTER)).verticalAlignment(VerticalAlignment.MIDDLE)).font(pdFont)).fontSize(Integer.valueOf(titleFontSize))).text(StringUtils.trimToEmpty((String)text)).borderWidthTop(top)).borderWidthLeft(left)).borderWidthRight(right)).borderWidthBottom(bottom)).rowSpan(rowSpan)).build();
    }

    @Nonnull
    protected static TextCell headerCell(@NonNull PrintSetup printSetup, @Nullable String text, @NonNull Iterable<EBorder> borders) {
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        if (borders == null) {
            throw new NullPointerException("borders is marked non-null but is null");
        }
        return AbstractPrintService.headerCell((PrintSetup)printSetup, (PDFont)printSetup.getPrintFonts().getBold(), (String)text, borders);
    }

    @Nonnull
    protected static TextCell headerCell(@NonNull PrintSetup printSetup, @NonNull PDFont font, @Nullable String text, @NonNull Iterable<EBorder> borders) {
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        if (font == null) {
            throw new NullPointerException("font is marked non-null but is null");
        }
        if (borders == null) {
            throw new NullPointerException("borders is marked non-null but is null");
        }
        return AbstractPrintService.headerCell((PrintSetup)printSetup, (PDFont)font, (String)text, borders, (int)1, (HorizontalAlignment)HorizontalAlignment.LEFT);
    }

    @Nonnull
    protected static TextCell headerCell(@NonNull PrintSetup printSetup, @Nullable String text, @NonNull Iterable<EBorder> borders, int colspan) {
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        if (borders == null) {
            throw new NullPointerException("borders is marked non-null but is null");
        }
        return AbstractPrintService.headerCell((PrintSetup)printSetup, (PDFont)printSetup.getPrintFonts().getBold(), (String)text, borders, (int)colspan, (HorizontalAlignment)HorizontalAlignment.LEFT);
    }

    @Nonnull
    protected static TextCell headerCell(@NonNull PrintSetup printSetup, @NonNull PDFont font, @Nullable String text, @NonNull Iterable<EBorder> borders, int colspan) {
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        if (font == null) {
            throw new NullPointerException("font is marked non-null but is null");
        }
        if (borders == null) {
            throw new NullPointerException("borders is marked non-null but is null");
        }
        return AbstractPrintService.headerCell((PrintSetup)printSetup, (PDFont)font, (String)text, borders, (int)colspan, (HorizontalAlignment)HorizontalAlignment.LEFT);
    }

    @Nonnull
    protected static TextCell headerCell(@NonNull PrintSetup printSetup, @Nullable String text, @NonNull Iterable<EBorder> borders, int colspan, @NonNull HorizontalAlignment horizontalAlignment) {
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        if (borders == null) {
            throw new NullPointerException("borders is marked non-null but is null");
        }
        if (horizontalAlignment == null) {
            throw new NullPointerException("horizontalAlignment is marked non-null but is null");
        }
        HashMap map = Maps.newHashMap();
        borders.forEach(item -> map.put(item, Float.valueOf(0.25f)));
        return AbstractPrintService.headerCell((PrintSetup)printSetup, (PDFont)printSetup.getPrintFonts().getBold(), (String)text, (Map)map, (int)colspan, (int)1, (HorizontalAlignment)horizontalAlignment, (VerticalAlignment)VerticalAlignment.MIDDLE);
    }

    @Nonnull
    protected static TextCell headerCell(@NonNull PrintSetup printSetup, @NonNull PDFont font, @Nullable String text, @NonNull Iterable<EBorder> borders, int colspan, int rowSpan, @NonNull HorizontalAlignment horizontalAlignment, @NonNull VerticalAlignment verticalAlignment) {
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        if (font == null) {
            throw new NullPointerException("font is marked non-null but is null");
        }
        if (borders == null) {
            throw new NullPointerException("borders is marked non-null but is null");
        }
        if (horizontalAlignment == null) {
            throw new NullPointerException("horizontalAlignment is marked non-null but is null");
        }
        if (verticalAlignment == null) {
            throw new NullPointerException("verticalAlignment is marked non-null but is null");
        }
        HashMap map = Maps.newHashMap();
        borders.forEach(item -> map.put(item, Float.valueOf(0.25f)));
        return AbstractPrintService.headerCell((PrintSetup)printSetup, (PDFont)font, (String)text, (Map)map, (int)colspan, (int)rowSpan, (HorizontalAlignment)horizontalAlignment, (VerticalAlignment)verticalAlignment);
    }

    @Nonnull
    protected static TextCell headerCell(@NonNull PrintSetup printSetup, @NonNull PDFont font, @Nullable String text, @NonNull Iterable<EBorder> borders, int colspan, @NonNull HorizontalAlignment horizontalAlignment) {
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        if (font == null) {
            throw new NullPointerException("font is marked non-null but is null");
        }
        if (borders == null) {
            throw new NullPointerException("borders is marked non-null but is null");
        }
        if (horizontalAlignment == null) {
            throw new NullPointerException("horizontalAlignment is marked non-null but is null");
        }
        HashMap map = Maps.newHashMap();
        borders.forEach(item -> map.put(item, Float.valueOf(0.25f)));
        return AbstractPrintService.headerCell((PrintSetup)printSetup, (PDFont)font, (String)text, (Map)map, (int)colspan, (int)1, (HorizontalAlignment)horizontalAlignment, (VerticalAlignment)VerticalAlignment.MIDDLE);
    }

    @Nonnull
    protected static TextCell headerCell(@NonNull PrintSetup printSetup, @Nullable String text, @NonNull Map<EBorder, Float> borders, int colspan, @NonNull HorizontalAlignment horizontalAlignment) {
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        if (borders == null) {
            throw new NullPointerException("borders is marked non-null but is null");
        }
        if (horizontalAlignment == null) {
            throw new NullPointerException("horizontalAlignment is marked non-null but is null");
        }
        return AbstractPrintService.headerCell((PrintSetup)printSetup, (PDFont)printSetup.getPrintFonts().getBold(), (String)text, borders, (int)colspan, (int)1, (HorizontalAlignment)horizontalAlignment, (VerticalAlignment)VerticalAlignment.MIDDLE);
    }

    @Nonnull
    protected static TextCell headerCell(@NonNull PrintSetup printSetup, @NonNull PDFont font, @Nullable String text, @NonNull Map<EBorder, Float> borders, int colspan, int rowSpan, @NonNull HorizontalAlignment horizontalAlignment, @NonNull VerticalAlignment verticalAlignment) {
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        if (font == null) {
            throw new NullPointerException("font is marked non-null but is null");
        }
        if (borders == null) {
            throw new NullPointerException("borders is marked non-null but is null");
        }
        if (horizontalAlignment == null) {
            throw new NullPointerException("horizontalAlignment is marked non-null but is null");
        }
        if (verticalAlignment == null) {
            throw new NullPointerException("verticalAlignment is marked non-null but is null");
        }
        int headerFontSize = printSetup.getHeaderFontSize();
        float top = borders.getOrDefault(EBorder.TOP, Float.valueOf(0.0f)).floatValue();
        float left = borders.getOrDefault(EBorder.LEFT, Float.valueOf(0.0f)).floatValue();
        float right = borders.getOrDefault(EBorder.RIGHT, Float.valueOf(0.0f)).floatValue();
        float bottom = borders.getOrDefault(EBorder.BOTTOM, Float.valueOf(0.0f)).floatValue();
        return ((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().text(StringUtils.trimToEmpty((String)text)).padding(2.0f)).colSpan(colspan)).rowSpan(rowSpan)).horizontalAlignment(horizontalAlignment)).verticalAlignment(verticalAlignment)).borderWidthTop(top)).borderWidthLeft(left)).borderWidthRight(right)).borderWidthBottom(bottom)).font(font)).fontSize(Integer.valueOf(headerFontSize))).build();
    }

    @Nonnull
    protected static ValuedTextCell detailHeader(@NonNull PrintSetup printSetup, @Nullable String text) {
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        return AbstractPrintService.detailHeader((PrintSetup)printSetup, (PDFont)printSetup.getPrintFonts().getBold(), (String)text, (int)1, (int)1, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)ALL);
    }

    @Nonnull
    protected static ValuedTextCell detailHeader(@NonNull PrintSetup printSetup, @Nullable String text, int colSpan) {
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        return AbstractPrintService.detailHeader((PrintSetup)printSetup, (PDFont)printSetup.getPrintFonts().getBold(), (String)text, (int)colSpan, (int)1, (HorizontalAlignment)HorizontalAlignment.LEFT, (Iterable)ALL);
    }

    @Nonnull
    protected static ValuedTextCell detailHeader(@NonNull PrintSetup printSetup, @Nullable String text, int rowSpan, Iterable<EBorder> borders) {
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        return AbstractPrintService.detailHeader((PrintSetup)printSetup, (PDFont)printSetup.getPrintFonts().getBold(), (String)text, (int)1, (int)rowSpan, (HorizontalAlignment)HorizontalAlignment.LEFT, borders);
    }

    @Nonnull
    protected static ValuedTextCell detailHeader(@NonNull PrintSetup printSetup, @Nullable String text, int colSpan, @NonNull HorizontalAlignment horizontalAlignment, @NonNull Iterable<EBorder> borders) {
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        if (horizontalAlignment == null) {
            throw new NullPointerException("horizontalAlignment is marked non-null but is null");
        }
        if (borders == null) {
            throw new NullPointerException("borders is marked non-null but is null");
        }
        return AbstractPrintService.detailHeader((PrintSetup)printSetup, (PDFont)printSetup.getPrintFonts().getBold(), (String)text, (int)colSpan, (int)1, (HorizontalAlignment)horizontalAlignment, borders);
    }

    @Nonnull
    protected static ValuedTextCell detailHeader(@NonNull PrintSetup printSetup, @NonNull PDFont font, @Nullable String text, int colSpan, int rowSpan, @NonNull HorizontalAlignment horizontalAlignment, @NonNull Iterable<EBorder> borders) {
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        if (font == null) {
            throw new NullPointerException("font is marked non-null but is null");
        }
        if (horizontalAlignment == null) {
            throw new NullPointerException("horizontalAlignment is marked non-null but is null");
        }
        if (borders == null) {
            throw new NullPointerException("borders is marked non-null but is null");
        }
        int headerFontSize = printSetup.getHeaderFontSize();
        HashMap map = Maps.newHashMap();
        borders.forEach(item -> map.put(item, Float.valueOf(0.25f)));
        return AbstractPrintService.genericCell((PDFont)font, (int)headerFontSize, (String)"no-row-key", (String)"no-column-key", (String)text, (BigDecimal)BigDecimal.ZERO, (EValueSource)EValueSource.IGNORE, (int)colSpan, (int)rowSpan, (Color)DETAIL_TEXT_COLOR, (Color)DETAIL_BG_COLOR_HEADER, (HorizontalAlignment)horizontalAlignment, (Map)map);
    }

    @Nonnull
    protected static ValuedTextCell emptyCell(@NonNull PrintSetup printSetup) {
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        int fontSize = printSetup.getDetailsFontSize();
        return AbstractPrintService.descriptionCell((PrintFonts)EMPTY_PRINT_FONTS, (int)fontSize, (String)StringUtils.trimToEmpty((String)""), (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)ImmutableMap.of());
    }

    @Nonnull
    protected static ValuedTextCell emptyCell(int fontSize) {
        return AbstractPrintService.descriptionCell((PrintFonts)EMPTY_PRINT_FONTS, (int)fontSize, (String)StringUtils.trimToEmpty((String)""), (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)ImmutableMap.of());
    }

    @Nonnull
    protected static ValuedTextCell emptyCell(@NonNull PrintSetup printSetup, int colSpan) {
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        int fontSize = printSetup.getDetailsFontSize();
        return AbstractPrintService.emptyCell((int)fontSize, (int)colSpan);
    }

    @Nonnull
    protected static ValuedTextCell emptyCell(int fontSize, int colSpan) {
        return AbstractPrintService.descriptionCell((PrintFonts)EMPTY_PRINT_FONTS, (int)fontSize, (String)StringUtils.trimToEmpty((String)""), (int)colSpan, (int)1, (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)ImmutableMap.of());
    }

    @Nonnull
    protected static ValuedTextCell descriptionCell(@NonNull PrintSetup printSetup, @Nullable String text) {
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        return AbstractPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)printSetup.getPrintFonts().getRegular(), (String)text);
    }

    @Nonnull
    protected static ValuedTextCell descriptionCell(@NonNull PrintSetup printSetup, @NonNull PDFont font, @Nullable String text) {
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        if (font == null) {
            throw new NullPointerException("font is marked non-null but is null");
        }
        int fontSize = printSetup.getDetailsFontSize();
        return AbstractPrintService.descriptionCell((PDFont)font, (int)fontSize, (String)StringUtils.trimToEmpty((String)text), (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT);
    }

    @Nonnull
    protected static ValuedTextCell descriptionCell(@NonNull PrintSetup printSetup, @NonNull Color textColor, @Nullable String text) {
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        if (textColor == null) {
            throw new NullPointerException("textColor is marked non-null but is null");
        }
        return AbstractPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)printSetup.getPrintFonts().getRegular(), (Color)textColor, (String)text);
    }

    @Nonnull
    protected static ValuedTextCell descriptionCell(@NonNull PrintSetup printSetup, @NonNull PDFont font, @NonNull Color textColor, @Nullable String text) {
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        if (font == null) {
            throw new NullPointerException("font is marked non-null but is null");
        }
        if (textColor == null) {
            throw new NullPointerException("textColor is marked non-null but is null");
        }
        int fontSize = printSetup.getDetailsFontSize();
        return AbstractPrintService.descriptionCell((int)fontSize, (PDFont)font, (Color)textColor, (String)text);
    }

    @Nonnull
    protected static ValuedTextCell descriptionCell(@NonNull PrintFonts printFonts, int fontSize, @NonNull Color textColor, @Nullable String text) {
        if (printFonts == null) {
            throw new NullPointerException("printFonts is marked non-null but is null");
        }
        if (textColor == null) {
            throw new NullPointerException("textColor is marked non-null but is null");
        }
        return AbstractPrintService.genericCell((PDFont)printFonts.getRegular(), (int)fontSize, (String)"no-row-key", (String)"no-column-key", (String)StringUtils.trimToEmpty((String)text), (BigDecimal)BigDecimal.ZERO, (EValueSource)EValueSource.IGNORE, (int)1, (int)1, (Color)textColor, (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)ImmutableMap.of());
    }

    @Nonnull
    protected static ValuedTextCell descriptionCell(int fontSize, @NonNull PDFont font, @NonNull Color textColor, @Nullable String text) {
        if (font == null) {
            throw new NullPointerException("font is marked non-null but is null");
        }
        if (textColor == null) {
            throw new NullPointerException("textColor is marked non-null but is null");
        }
        return AbstractPrintService.genericCell((PDFont)font, (int)fontSize, (String)"no-row-key", (String)"no-column-key", (String)StringUtils.trimToEmpty((String)text), (BigDecimal)BigDecimal.ZERO, (EValueSource)EValueSource.IGNORE, (int)1, (int)1, (Color)textColor, (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)ImmutableMap.of());
    }

    @Nonnull
    protected static ValuedTextCell descriptionCell(@NonNull PrintSetup printSetup, @NonNull Color textColor, @Nullable String text, @NonNull HorizontalAlignment horizontalAlignment) {
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        if (textColor == null) {
            throw new NullPointerException("textColor is marked non-null but is null");
        }
        if (horizontalAlignment == null) {
            throw new NullPointerException("horizontalAlignment is marked non-null but is null");
        }
        int fontSize = printSetup.getDetailsFontSize();
        return AbstractPrintService.genericCell((PDFont)printSetup.getPrintFonts().getRegular(), (int)fontSize, (String)"no-row-key", (String)"no-column-key", (String)StringUtils.trimToEmpty((String)text), (BigDecimal)BigDecimal.ZERO, (EValueSource)EValueSource.IGNORE, (int)1, (int)1, (Color)textColor, (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)horizontalAlignment, (Map)ImmutableMap.of());
    }

    @Nonnull
    protected static ValuedTextCell descriptionCell(@NonNull PrintSetup printSetup, @NonNull PDFont font, @NonNull Color textColor, @Nullable String text, @NonNull HorizontalAlignment horizontalAlignment) {
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        if (font == null) {
            throw new NullPointerException("font is marked non-null but is null");
        }
        if (textColor == null) {
            throw new NullPointerException("textColor is marked non-null but is null");
        }
        if (horizontalAlignment == null) {
            throw new NullPointerException("horizontalAlignment is marked non-null but is null");
        }
        int fontSize = printSetup.getDetailsFontSize();
        return AbstractPrintService.genericCell((PDFont)font, (int)fontSize, (String)"no-row-key", (String)"no-column-key", (String)StringUtils.trimToEmpty((String)text), (BigDecimal)BigDecimal.ZERO, (EValueSource)EValueSource.IGNORE, (int)1, (int)1, (Color)textColor, (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)horizontalAlignment, (Map)ImmutableMap.of());
    }

    protected static ValuedTextCell descriptionCell(@NonNull PrintSetup printSetup, @NonNull Color textColor, @NonNull Color backColor, @Nullable String text, @NonNull HorizontalAlignment horizontalAlignment) {
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        if (textColor == null) {
            throw new NullPointerException("textColor is marked non-null but is null");
        }
        if (backColor == null) {
            throw new NullPointerException("backColor is marked non-null but is null");
        }
        if (horizontalAlignment == null) {
            throw new NullPointerException("horizontalAlignment is marked non-null but is null");
        }
        return AbstractPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)printSetup.getPrintFonts().getRegular(), (Color)textColor, (Color)backColor, (String)text, (HorizontalAlignment)horizontalAlignment);
    }

    @Nonnull
    protected static ValuedTextCell descriptionCell(@NonNull PrintSetup printSetup, @NonNull PDFont font, @NonNull Color textColor, @NonNull Color backColor, @Nullable String text, @NonNull HorizontalAlignment horizontalAlignment) {
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        if (font == null) {
            throw new NullPointerException("font is marked non-null but is null");
        }
        if (textColor == null) {
            throw new NullPointerException("textColor is marked non-null but is null");
        }
        if (backColor == null) {
            throw new NullPointerException("backColor is marked non-null but is null");
        }
        if (horizontalAlignment == null) {
            throw new NullPointerException("horizontalAlignment is marked non-null but is null");
        }
        int fontSize = printSetup.getDetailsFontSize();
        return AbstractPrintService.genericCell((PDFont)font, (int)fontSize, (String)"no-row-key", (String)"no-column-key", (String)StringUtils.trimToEmpty((String)text), (BigDecimal)BigDecimal.ZERO, (EValueSource)EValueSource.IGNORE, (int)1, (int)1, (Color)textColor, (Color)backColor, (HorizontalAlignment)horizontalAlignment, (Map)ImmutableMap.of());
    }

    @Nonnull
    protected static ValuedTextCell descriptionCell(@NonNull PrintSetup printSetup, @NonNull Color textColor, int colSpan, @Nullable String text) {
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        if (textColor == null) {
            throw new NullPointerException("textColor is marked non-null but is null");
        }
        return AbstractPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)printSetup.getPrintFonts().getRegular(), (Color)textColor, (int)colSpan, (String)text);
    }

    @Nonnull
    protected static ValuedTextCell descriptionCell(int fontSize, @NonNull PrintFonts printFonts, @NonNull Color textColor, int colSpan, @Nullable String text) {
        if (printFonts == null) {
            throw new NullPointerException("printFonts is marked non-null but is null");
        }
        if (textColor == null) {
            throw new NullPointerException("textColor is marked non-null but is null");
        }
        return AbstractPrintService.descriptionCell((int)fontSize, (PDFont)printFonts.getRegular(), (Color)textColor, (int)colSpan, (String)text);
    }

    @Nonnull
    protected static ValuedTextCell descriptionCell(@NonNull PrintSetup printSetup, @NonNull PDFont font, @NonNull Color textColor, int colSpan, @Nullable String text) {
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        if (font == null) {
            throw new NullPointerException("font is marked non-null but is null");
        }
        if (textColor == null) {
            throw new NullPointerException("textColor is marked non-null but is null");
        }
        return AbstractPrintService.descriptionCell((PrintSetup)printSetup, (PDFont)font, (Color)textColor, (int)colSpan, (String)text, (HorizontalAlignment)HorizontalAlignment.LEFT);
    }

    @Nonnull
    protected static ValuedTextCell descriptionCell(@NonNull PrintSetup printSetup, @NonNull Color textColor, int colSpan, @Nullable String text, @NonNull HorizontalAlignment horizontalAlignment) {
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        if (textColor == null) {
            throw new NullPointerException("textColor is marked non-null but is null");
        }
        if (horizontalAlignment == null) {
            throw new NullPointerException("horizontalAlignment is marked non-null but is null");
        }
        int fontSize = printSetup.getDetailsFontSize();
        return AbstractPrintService.genericCell((PDFont)printSetup.getPrintFonts().getRegular(), (int)fontSize, (String)"no-row-key", (String)"no-column-key", (String)StringUtils.trimToEmpty((String)text), (BigDecimal)BigDecimal.ZERO, (EValueSource)EValueSource.IGNORE, (int)colSpan, (int)1, (Color)textColor, (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)horizontalAlignment, (Map)ImmutableMap.of());
    }

    @Nonnull
    protected static ValuedTextCell descriptionCell(int fontSize, @NonNull PrintFonts printFonts, @NonNull Color textColor, int colSpan, @Nullable String text, @NonNull HorizontalAlignment horizontalAlignment) {
        if (printFonts == null) {
            throw new NullPointerException("printFonts is marked non-null but is null");
        }
        if (textColor == null) {
            throw new NullPointerException("textColor is marked non-null but is null");
        }
        if (horizontalAlignment == null) {
            throw new NullPointerException("horizontalAlignment is marked non-null but is null");
        }
        return AbstractPrintService.genericCell((PDFont)printFonts.getRegular(), (int)fontSize, (String)"no-row-key", (String)"no-column-key", (String)StringUtils.trimToEmpty((String)text), (BigDecimal)BigDecimal.ZERO, (EValueSource)EValueSource.IGNORE, (int)colSpan, (int)1, (Color)textColor, (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)horizontalAlignment, (Map)ImmutableMap.of());
    }

    @Nonnull
    protected static ValuedTextCell descriptionCell(@NonNull PrintSetup printSetup, @NonNull PDFont font, @NonNull Color textColor, int colSpan, @Nullable String text, @NonNull HorizontalAlignment horizontalAlignment) {
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        if (font == null) {
            throw new NullPointerException("font is marked non-null but is null");
        }
        if (textColor == null) {
            throw new NullPointerException("textColor is marked non-null but is null");
        }
        if (horizontalAlignment == null) {
            throw new NullPointerException("horizontalAlignment is marked non-null but is null");
        }
        int fontSize = printSetup.getDetailsFontSize();
        return AbstractPrintService.genericCell((PDFont)font, (int)fontSize, (String)"no-row-key", (String)"no-column-key", (String)StringUtils.trimToEmpty((String)text), (BigDecimal)BigDecimal.ZERO, (EValueSource)EValueSource.IGNORE, (int)colSpan, (int)1, (Color)textColor, (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)horizontalAlignment, (Map)ImmutableMap.of());
    }

    @Nonnull
    protected static ValuedTextCell descriptionCell(int fontSize, @NonNull PDFont font, @NonNull Color textColor, int colSpan, @Nullable String text, @NonNull HorizontalAlignment horizontalAlignment) {
        if (font == null) {
            throw new NullPointerException("font is marked non-null but is null");
        }
        if (textColor == null) {
            throw new NullPointerException("textColor is marked non-null but is null");
        }
        if (horizontalAlignment == null) {
            throw new NullPointerException("horizontalAlignment is marked non-null but is null");
        }
        return AbstractPrintService.genericCell((PDFont)font, (int)fontSize, (String)"no-row-key", (String)"no-column-key", (String)StringUtils.trimToEmpty((String)text), (BigDecimal)BigDecimal.ZERO, (EValueSource)EValueSource.IGNORE, (int)colSpan, (int)1, (Color)textColor, (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)horizontalAlignment, (Map)ImmutableMap.of());
    }

    @Nonnull
    protected static ValuedTextCell descriptionCell(@NonNull PrintSetup printSetup, @NonNull PDFont font, @NonNull Color textColor, int colSpan, @Nullable String text, @NonNull HorizontalAlignment horizontalAlignment, @NonNull Map<EBorder, Float> borders) {
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        if (font == null) {
            throw new NullPointerException("font is marked non-null but is null");
        }
        if (textColor == null) {
            throw new NullPointerException("textColor is marked non-null but is null");
        }
        if (horizontalAlignment == null) {
            throw new NullPointerException("horizontalAlignment is marked non-null but is null");
        }
        if (borders == null) {
            throw new NullPointerException("borders is marked non-null but is null");
        }
        int fontSize = printSetup.getDetailsFontSize();
        return AbstractPrintService.genericCell((PDFont)font, (int)fontSize, (String)"no-row-key", (String)"no-column-key", (String)StringUtils.trimToEmpty((String)text), (BigDecimal)BigDecimal.ZERO, (EValueSource)EValueSource.IGNORE, (int)colSpan, (int)1, (Color)textColor, (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)horizontalAlignment, borders);
    }

    @Nonnull
    protected static ValuedTextCell descriptionCell(@NonNull PrintSetup printSetup, @NonNull PDFont font, @NonNull Color textColor, @Nullable String text, @NonNull HorizontalAlignment horizontalAlignment, @NonNull Map<EBorder, Float> borders) {
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        if (font == null) {
            throw new NullPointerException("font is marked non-null but is null");
        }
        if (textColor == null) {
            throw new NullPointerException("textColor is marked non-null but is null");
        }
        if (horizontalAlignment == null) {
            throw new NullPointerException("horizontalAlignment is marked non-null but is null");
        }
        if (borders == null) {
            throw new NullPointerException("borders is marked non-null but is null");
        }
        int fontSize = printSetup.getDetailsFontSize();
        return AbstractPrintService.genericCell((PDFont)font, (int)fontSize, (String)"no-row-key", (String)"no-column-key", (String)StringUtils.trimToEmpty((String)text), (BigDecimal)BigDecimal.ZERO, (EValueSource)EValueSource.IGNORE, (int)1, (int)1, (Color)textColor, (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)horizontalAlignment, borders);
    }

    @Nonnull
    protected static ValuedTextCell descriptionCell(int fontSize, @NonNull PDFont font, @NonNull Color textColor, int colSpan, @Nullable String text) {
        if (font == null) {
            throw new NullPointerException("font is marked non-null but is null");
        }
        if (textColor == null) {
            throw new NullPointerException("textColor is marked non-null but is null");
        }
        return AbstractPrintService.genericCell((PDFont)font, (int)fontSize, (String)"no-row-key", (String)"no-column-key", (String)StringUtils.trimToEmpty((String)text), (BigDecimal)BigDecimal.ZERO, (EValueSource)EValueSource.IGNORE, (int)colSpan, (int)1, (Color)textColor, (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)ImmutableMap.of());
    }

    @Nonnull
    protected static ValuedTextCell descriptionCell(int fontSize, @NonNull PDFont font, @NonNull Color textColor, int colSpan, @NonNull VerticalAlignment verticalAlignment, @Nullable String text) {
        if (font == null) {
            throw new NullPointerException("font is marked non-null but is null");
        }
        if (textColor == null) {
            throw new NullPointerException("textColor is marked non-null but is null");
        }
        if (verticalAlignment == null) {
            throw new NullPointerException("verticalAlignment is marked non-null but is null");
        }
        return AbstractPrintService.genericCell((PDFont)font, (int)fontSize, (String)"no-row-key", (String)"no-column-key", (String)StringUtils.trimToEmpty((String)text), (BigDecimal)BigDecimal.ZERO, (EValueSource)EValueSource.IGNORE, (int)colSpan, (int)1, (Color)textColor, (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (VerticalAlignment)verticalAlignment, (Map)ImmutableMap.of());
    }

    @Nonnull
    protected static ValuedTextCell descriptionCell(int fontSize, @NonNull PrintFonts printFonts, @NonNull Color textColor, int colSpan, int rowSpan, @Nullable String text) {
        if (printFonts == null) {
            throw new NullPointerException("printFonts is marked non-null but is null");
        }
        if (textColor == null) {
            throw new NullPointerException("textColor is marked non-null but is null");
        }
        return AbstractPrintService.descriptionCell((int)fontSize, (PDFont)printFonts.getRegular(), (Color)textColor, (int)colSpan, (int)rowSpan, (String)text);
    }

    @Nonnull
    protected static ValuedTextCell descriptionCell(int fontSize, @NonNull PDFont font, @NonNull Color textColor, int colSpan, int rowSpan, @Nullable String text) {
        if (font == null) {
            throw new NullPointerException("font is marked non-null but is null");
        }
        if (textColor == null) {
            throw new NullPointerException("textColor is marked non-null but is null");
        }
        return AbstractPrintService.genericCell((PDFont)font, (int)fontSize, (String)"no-row-key", (String)"no-column-key", (String)StringUtils.trimToEmpty((String)text), (BigDecimal)BigDecimal.ZERO, (EValueSource)EValueSource.IGNORE, (int)colSpan, (int)rowSpan, (Color)textColor, (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)ImmutableMap.of());
    }

    @Nonnull
    protected static ValuedTextCell descriptionCell(int fontSize, @NonNull PDFont font, @Nullable String text) {
        if (font == null) {
            throw new NullPointerException("font is marked non-null but is null");
        }
        return AbstractPrintService.descriptionCell((PDFont)font, (int)fontSize, (String)StringUtils.trimToEmpty((String)text), (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)ImmutableMap.of());
    }

    @Nonnull
    protected static ValuedTextCell descriptionCell(@NonNull PrintFonts printFonts, int fontSize, @Nullable String text, @NonNull Color backgroundColor, @NonNull HorizontalAlignment horizontalAlignment) {
        if (printFonts == null) {
            throw new NullPointerException("printFonts is marked non-null but is null");
        }
        if (backgroundColor == null) {
            throw new NullPointerException("backgroundColor is marked non-null but is null");
        }
        if (horizontalAlignment == null) {
            throw new NullPointerException("horizontalAlignment is marked non-null but is null");
        }
        return AbstractPrintService.descriptionCell((PDFont)printFonts.getRegular(), (int)fontSize, (String)StringUtils.trimToEmpty((String)text), (Color)backgroundColor, (HorizontalAlignment)horizontalAlignment);
    }

    @Nonnull
    protected static ValuedTextCell descriptionCell(@NonNull PDFont font, int fontSize, @Nullable String text, @NonNull Color backgroundColor, @NonNull HorizontalAlignment horizontalAlignment) {
        if (font == null) {
            throw new NullPointerException("font is marked non-null but is null");
        }
        if (backgroundColor == null) {
            throw new NullPointerException("backgroundColor is marked non-null but is null");
        }
        if (horizontalAlignment == null) {
            throw new NullPointerException("horizontalAlignment is marked non-null but is null");
        }
        return AbstractPrintService.descriptionCell((PDFont)font, (int)fontSize, (String)StringUtils.trimToEmpty((String)text), (Color)backgroundColor, (HorizontalAlignment)horizontalAlignment, (Map)AbstractPrintService.defaultBorder((Iterable)ALL));
    }

    @Nonnull
    protected static ValuedTextCell descriptionCell(@NonNull PrintFonts printFonts, int fontSize, @Nullable String text, @NonNull Color backgroundColor, @NonNull HorizontalAlignment horizontalAlignment, @NonNull Iterable<EBorder> borders) {
        if (printFonts == null) {
            throw new NullPointerException("printFonts is marked non-null but is null");
        }
        if (backgroundColor == null) {
            throw new NullPointerException("backgroundColor is marked non-null but is null");
        }
        if (horizontalAlignment == null) {
            throw new NullPointerException("horizontalAlignment is marked non-null but is null");
        }
        if (borders == null) {
            throw new NullPointerException("borders is marked non-null but is null");
        }
        return AbstractPrintService.descriptionCell((PDFont)printFonts.getRegular(), (int)fontSize, (String)text, (Color)backgroundColor, (HorizontalAlignment)horizontalAlignment, borders);
    }

    @Nonnull
    protected static ValuedTextCell descriptionCell(@NonNull PDFont font, int fontSize, @Nullable String text, @NonNull Color backgroundColor, @NonNull HorizontalAlignment horizontalAlignment, @NonNull Iterable<EBorder> borders) {
        if (font == null) {
            throw new NullPointerException("font is marked non-null but is null");
        }
        if (backgroundColor == null) {
            throw new NullPointerException("backgroundColor is marked non-null but is null");
        }
        if (horizontalAlignment == null) {
            throw new NullPointerException("horizontalAlignment is marked non-null but is null");
        }
        if (borders == null) {
            throw new NullPointerException("borders is marked non-null but is null");
        }
        Map defaultBorder = AbstractPrintService.defaultBorder(borders);
        return AbstractPrintService.genericCell((PDFont)font, (int)fontSize, (String)"no-row-key", (String)"no-column-key", (String)text, (BigDecimal)BigDecimal.ZERO, (EValueSource)EValueSource.IGNORE, (int)1, (int)1, (Color)DETAIL_TEXT_COLOR, (Color)backgroundColor, (HorizontalAlignment)horizontalAlignment, (Map)defaultBorder);
    }

    @Nonnull
    protected static ValuedTextCell descriptionCell(PDFont font, int fontSize, @Nullable String text, @NonNull Color backgroundColor, @NonNull HorizontalAlignment horizontalAlignment, @NonNull Map<EBorder, Float> borders) {
        if (backgroundColor == null) {
            throw new NullPointerException("backgroundColor is marked non-null but is null");
        }
        if (horizontalAlignment == null) {
            throw new NullPointerException("horizontalAlignment is marked non-null but is null");
        }
        if (borders == null) {
            throw new NullPointerException("borders is marked non-null but is null");
        }
        return AbstractPrintService.genericCell((PDFont)font, (int)fontSize, (String)"no-row-key", (String)"no-column-key", (String)text, (BigDecimal)BigDecimal.ZERO, (EValueSource)EValueSource.IGNORE, (int)1, (int)1, (Color)DETAIL_TEXT_COLOR, (Color)backgroundColor, (HorizontalAlignment)horizontalAlignment, borders);
    }

    @Nonnull
    protected static ValuedTextCell descriptionCell(@NonNull PrintFonts printFonts, int fontSize, @Nullable String text, @NonNull Color backgroundColor, @NonNull HorizontalAlignment horizontalAlignment, @NonNull Map<EBorder, Float> borders) {
        if (printFonts == null) {
            throw new NullPointerException("printFonts is marked non-null but is null");
        }
        if (backgroundColor == null) {
            throw new NullPointerException("backgroundColor is marked non-null but is null");
        }
        if (horizontalAlignment == null) {
            throw new NullPointerException("horizontalAlignment is marked non-null but is null");
        }
        if (borders == null) {
            throw new NullPointerException("borders is marked non-null but is null");
        }
        return AbstractPrintService.descriptionCell((PDFont)printFonts.getRegular(), (int)fontSize, (String)text, (Color)backgroundColor, (HorizontalAlignment)horizontalAlignment, borders);
    }

    @Nonnull
    protected static ValuedTextCell descriptionCell(@NonNull PrintFonts printFonts, int fontSize, @Nullable String text, int colSpan, int rowSpan, @NonNull Color backgroundColor, @NonNull HorizontalAlignment horizontalAlignment, @NonNull Iterable<EBorder> borders) {
        if (printFonts == null) {
            throw new NullPointerException("printFonts is marked non-null but is null");
        }
        if (backgroundColor == null) {
            throw new NullPointerException("backgroundColor is marked non-null but is null");
        }
        if (horizontalAlignment == null) {
            throw new NullPointerException("horizontalAlignment is marked non-null but is null");
        }
        if (borders == null) {
            throw new NullPointerException("borders is marked non-null but is null");
        }
        Map defaultBorder = AbstractPrintService.defaultBorder(borders);
        return AbstractPrintService.descriptionCell((PrintFonts)printFonts, (int)fontSize, (String)text, (int)colSpan, (int)rowSpan, (Color)backgroundColor, (HorizontalAlignment)horizontalAlignment, (Map)defaultBorder);
    }

    @Nonnull
    protected static ValuedTextCell descriptionCell(PrintFonts printFonts, int fontSize, @Nullable String text, int colSpan, int rowSpan, @NonNull Color textColor, @NonNull Color backgroundColor, @NonNull HorizontalAlignment horizontalAlignment, @NonNull Map<EBorder, Float> borders) {
        if (textColor == null) {
            throw new NullPointerException("textColor is marked non-null but is null");
        }
        if (backgroundColor == null) {
            throw new NullPointerException("backgroundColor is marked non-null but is null");
        }
        if (horizontalAlignment == null) {
            throw new NullPointerException("horizontalAlignment is marked non-null but is null");
        }
        if (borders == null) {
            throw new NullPointerException("borders is marked non-null but is null");
        }
        return AbstractPrintService.genericCell((PDFont)printFonts.getRegular(), (int)fontSize, (String)"no-row-key", (String)"no-column-key", (String)text, (BigDecimal)BigDecimal.ZERO, (EValueSource)EValueSource.IGNORE, (int)colSpan, (int)rowSpan, (Color)textColor, (Color)backgroundColor, (HorizontalAlignment)horizontalAlignment, borders);
    }

    @Nonnull
    protected static ValuedTextCell descriptionCell(PDFont font, int fontSize, @Nullable String text, int colSpan, int rowSpan, @NonNull Color textColor, @NonNull Color backgroundColor, @NonNull HorizontalAlignment horizontalAlignment, @NonNull Map<EBorder, Float> borders) {
        if (textColor == null) {
            throw new NullPointerException("textColor is marked non-null but is null");
        }
        if (backgroundColor == null) {
            throw new NullPointerException("backgroundColor is marked non-null but is null");
        }
        if (horizontalAlignment == null) {
            throw new NullPointerException("horizontalAlignment is marked non-null but is null");
        }
        if (borders == null) {
            throw new NullPointerException("borders is marked non-null but is null");
        }
        return AbstractPrintService.genericCell((PDFont)font, (int)fontSize, (String)"no-row-key", (String)"no-column-key", (String)text, (BigDecimal)BigDecimal.ZERO, (EValueSource)EValueSource.IGNORE, (int)colSpan, (int)rowSpan, (Color)textColor, (Color)backgroundColor, (HorizontalAlignment)horizontalAlignment, borders);
    }

    @Nonnull
    protected static ValuedTextCell descriptionCell(@NonNull PrintFonts printFonts, int fontSize, @Nullable String text, int colSpan, int rowSpan, @NonNull Color backgroundColor, @NonNull HorizontalAlignment horizontalAlignment, @NonNull Map<EBorder, Float> borders) {
        if (printFonts == null) {
            throw new NullPointerException("printFonts is marked non-null but is null");
        }
        if (backgroundColor == null) {
            throw new NullPointerException("backgroundColor is marked non-null but is null");
        }
        if (horizontalAlignment == null) {
            throw new NullPointerException("horizontalAlignment is marked non-null but is null");
        }
        if (borders == null) {
            throw new NullPointerException("borders is marked non-null but is null");
        }
        return AbstractPrintService.descriptionCell((PDFont)printFonts.getRegular(), (int)fontSize, (String)text, (int)colSpan, (int)rowSpan, (Color)DETAIL_TEXT_COLOR, (Color)backgroundColor, (HorizontalAlignment)horizontalAlignment, borders);
    }

    @Nonnull
    protected static ValuedTextCell valueCell(@NonNull PDFont font, int fontSize, @NonNull String rowKey, @NonNull String columnKey, @Nullable BigDecimal value, @NonNull EValueSource source, @NonNull HorizontalAlignment horizontalAlignment, @NonNull Iterable<EBorder> borders, @NonNull Iterable<ECellPrintOption> cellPrintOptions) {
        if (font == null) {
            throw new NullPointerException("font is marked non-null but is null");
        }
        if (rowKey == null) {
            throw new NullPointerException("rowKey is marked non-null but is null");
        }
        if (columnKey == null) {
            throw new NullPointerException("columnKey is marked non-null but is null");
        }
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (horizontalAlignment == null) {
            throw new NullPointerException("horizontalAlignment is marked non-null but is null");
        }
        if (borders == null) {
            throw new NullPointerException("borders is marked non-null but is null");
        }
        if (cellPrintOptions == null) {
            throw new NullPointerException("cellPrintOptions is marked non-null but is null");
        }
        return AbstractPrintService.valueCell((PDFont)font, (int)fontSize, (String)rowKey, (String)columnKey, (BigDecimal)value, (EValueSource)source, (int)1, (int)1, (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)horizontalAlignment, borders, cellPrintOptions);
    }

    @Nonnull
    protected static ValuedTextCell valueCell(@NonNull PDFont font, int fontSize, @NonNull String rowKey, @NonNull String columnKey, @Nullable BigDecimal value, @NonNull EValueSource source, int colSpan, int rowSpan, @NonNull Color backgroundColor, @NonNull HorizontalAlignment horizontalAlignment, @NonNull Iterable<EBorder> borders, @NonNull Iterable<ECellPrintOption> cellPrintOptions) {
        if (font == null) {
            throw new NullPointerException("font is marked non-null but is null");
        }
        if (rowKey == null) {
            throw new NullPointerException("rowKey is marked non-null but is null");
        }
        if (columnKey == null) {
            throw new NullPointerException("columnKey is marked non-null but is null");
        }
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (backgroundColor == null) {
            throw new NullPointerException("backgroundColor is marked non-null but is null");
        }
        if (horizontalAlignment == null) {
            throw new NullPointerException("horizontalAlignment is marked non-null but is null");
        }
        if (borders == null) {
            throw new NullPointerException("borders is marked non-null but is null");
        }
        if (cellPrintOptions == null) {
            throw new NullPointerException("cellPrintOptions is marked non-null but is null");
        }
        boolean hideZeroOption = Iterables.contains(cellPrintOptions, (Object)ECellPrintOption.HIDE_ZERO_VALUE);
        boolean containsZero = value == null || BigDecimal.ZERO.compareTo(value) == 0;
        boolean hideZero = hideZeroOption && containsZero;
        String text = hideZero ? "" : AbstractPrintService.nullSafeString((BigDecimal)value);
        BigDecimal nullSafeValue = (BigDecimal)MoreObjects.firstNonNull((Object)value, (Object)BigDecimal.ZERO);
        Map defaultBorder = AbstractPrintService.defaultBorder(borders);
        return AbstractPrintService.genericCell((PDFont)font, (int)fontSize, (String)rowKey, (String)columnKey, (String)text, (BigDecimal)nullSafeValue, (EValueSource)source, (int)colSpan, (int)rowSpan, (Color)DETAIL_TEXT_COLOR, (Color)backgroundColor, (HorizontalAlignment)horizontalAlignment, (Map)defaultBorder);
    }

    @Nonnull
    protected static ValuedTextCell genericCell(@NonNull PDFont font, int fontSize, @NonNull String rowKey, @NonNull String columnKey, @Nullable String text, @NonNull BigDecimal value, @NonNull EValueSource source, int colSpan, int rowSpan, @NonNull Color textColor, @NonNull Color backgroundColor, @NonNull HorizontalAlignment horizontalAlignment, @NonNull Map<EBorder, Float> borders) {
        if (font == null) {
            throw new NullPointerException("font is marked non-null but is null");
        }
        if (rowKey == null) {
            throw new NullPointerException("rowKey is marked non-null but is null");
        }
        if (columnKey == null) {
            throw new NullPointerException("columnKey is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (textColor == null) {
            throw new NullPointerException("textColor is marked non-null but is null");
        }
        if (backgroundColor == null) {
            throw new NullPointerException("backgroundColor is marked non-null but is null");
        }
        if (horizontalAlignment == null) {
            throw new NullPointerException("horizontalAlignment is marked non-null but is null");
        }
        if (borders == null) {
            throw new NullPointerException("borders is marked non-null but is null");
        }
        return AbstractPrintService.genericCell((PDFont)font, (int)fontSize, (String)rowKey, (String)columnKey, (String)text, (BigDecimal)value, (EValueSource)source, (int)colSpan, (int)rowSpan, (Color)textColor, (Color)backgroundColor, (HorizontalAlignment)horizontalAlignment, (VerticalAlignment)VerticalAlignment.TOP, borders);
    }

    @Nonnull
    protected static ValuedTextCell genericCell(@NonNull PDFont font, int fontSize, @NonNull String rowKey, @NonNull String columnKey, @Nullable String text, @NonNull BigDecimal value, @NonNull EValueSource source, int colSpan, int rowSpan, @NonNull Color textColor, @NonNull Color backgroundColor, @NonNull HorizontalAlignment horizontalAlignment, @NonNull VerticalAlignment verticalAlignment, @NonNull Map<EBorder, Float> borders) {
        if (font == null) {
            throw new NullPointerException("font is marked non-null but is null");
        }
        if (rowKey == null) {
            throw new NullPointerException("rowKey is marked non-null but is null");
        }
        if (columnKey == null) {
            throw new NullPointerException("columnKey is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (textColor == null) {
            throw new NullPointerException("textColor is marked non-null but is null");
        }
        if (backgroundColor == null) {
            throw new NullPointerException("backgroundColor is marked non-null but is null");
        }
        if (horizontalAlignment == null) {
            throw new NullPointerException("horizontalAlignment is marked non-null but is null");
        }
        if (verticalAlignment == null) {
            throw new NullPointerException("verticalAlignment is marked non-null but is null");
        }
        if (borders == null) {
            throw new NullPointerException("borders is marked non-null but is null");
        }
        float top = borders.getOrDefault(EBorder.TOP, Float.valueOf(0.0f)).floatValue();
        float left = borders.getOrDefault(EBorder.LEFT, Float.valueOf(0.0f)).floatValue();
        float right = borders.getOrDefault(EBorder.RIGHT, Float.valueOf(0.0f)).floatValue();
        float bottom = borders.getOrDefault(EBorder.BOTTOM, Float.valueOf(0.0f)).floatValue();
        String validText = AbstractPrintService.validText((String)text);
        return ((ValuedTextCell.ValuedTextCellBuilder)((ValuedTextCell.ValuedTextCellBuilder)((ValuedTextCell.ValuedTextCellBuilder)((ValuedTextCell.ValuedTextCellBuilder)((ValuedTextCell.ValuedTextCellBuilder)((ValuedTextCell.ValuedTextCellBuilder)((ValuedTextCell.ValuedTextCellBuilder)((ValuedTextCell.ValuedTextCellBuilder)((ValuedTextCell.ValuedTextCellBuilder)((ValuedTextCell.ValuedTextCellBuilder)((ValuedTextCell.ValuedTextCellBuilder)((ValuedTextCell.ValuedTextCellBuilder)((ValuedTextCell.ValuedTextCellBuilder)((ValuedTextCell.ValuedTextCellBuilder)ValuedTextCell.builder().font(font)).fontSize(Integer.valueOf(fontSize))).colSpan(colSpan)).rowSpan(rowSpan)).padding(3.0f)).horizontalAlignment(horizontalAlignment)).verticalAlignment(verticalAlignment)).value(value).source(source).rowKey(rowKey).columnKey(columnKey).text(validText).textColor(textColor)).lineSpacing(0.5f)).backgroundColor(backgroundColor)).borderWidthTop(top)).borderWidthLeft(left)).borderWidthRight(right)).borderWidthBottom(bottom)).build();
    }

    @Nonnull
    private static TextCell fillUpCell(@NonNull PrintSetup printSetup, @NonNull Iterable<EBorder> borders) {
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        if (borders == null) {
            throw new NullPointerException("borders is marked non-null but is null");
        }
        return AbstractPrintService.fillUpCell((PrintSetup)printSetup, (int)1, borders);
    }

    @Nonnull
    private static TextCell fillUpCell(@NonNull PrintSetup printSetup, int colSpan, @NonNull Iterable<EBorder> borders) {
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        if (borders == null) {
            throw new NullPointerException("borders is marked non-null but is null");
        }
        int detailsFontSize = printSetup.getDetailsFontSize();
        ImmutableSet s = ImmutableSet.copyOf(borders);
        boolean top = s.contains(EBorder.TOP);
        boolean left = s.contains(EBorder.LEFT);
        boolean right = s.contains(EBorder.RIGHT);
        boolean bottom = s.contains(EBorder.BOTTOM);
        return ((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().colSpan(colSpan)).padding(2.0f)).font(EMPTY_PRINT_FONTS.getRegular())).fontSize(Integer.valueOf(detailsFontSize))).text("").borderColor(DETAIL_FILLUP_BORDER_COLOR)).borderWidthTop(top ? 0.25f : 0.0f)).borderWidthLeft(left ? 0.25f : 0.0f)).borderWidthRight(right ? 0.25f : 0.0f)).borderWidthBottom(bottom ? 0.25f : 0.0f)).build();
    }

    @Nonnull
    protected static List<Table> splitVertically(@NonNull Table input, int rowsToCopy, float sizeOnFirstPage, float sizeOnNextPages) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        ImmutableList.Builder tableListBuilder = ImmutableList.builder();
        List columns = input.getColumns();
        List rows = input.getRows();
        ArrayList headers = Lists.newArrayList(rows.subList(0, rowsToCopy));
        List allDetailRows = rows.subList(rowsToCopy, rows.size());
        if (!allDetailRows.isEmpty()) {
            float headerSize = AbstractPrintService.rowHeight((Iterable)headers);
            ArrayList<ArrayList> partitions = new ArrayList<ArrayList>();
            ArrayList currentPartition = new ArrayList();
            float currentSize = 0.0f;
            ArrayList stack = Lists.newArrayList(allDetailRows);
            ArrayList currentBatch = new ArrayList();
            while (!stack.isEmpty()) {
                Row row = (Row)stack.get(0);
                int n = row.getCells().stream().map(AbstractCell::getRowSpan).max(Ints::compare).orElse(1);
                List selectedRows = stack.subList(0, n);
                currentBatch.addAll(selectedRows);
                float rowHeight = currentBatch.stream().map(Row::getHeight).reduce(Float.valueOf(0.0f), Float::sum).floatValue();
                float sizeOnPage = partitions.isEmpty() ? sizeOnFirstPage : sizeOnNextPages;
                float spaceNeeded = headerSize + rowHeight + currentSize;
                if (spaceNeeded >= sizeOnPage) {
                    if (!currentPartition.isEmpty()) {
                        partitions.add(Lists.newArrayList(currentPartition));
                    }
                    currentPartition.clear();
                    currentSize = 0.0f;
                }
                currentPartition.addAll(currentBatch);
                currentSize += rowHeight;
                currentBatch.clear();
                stack.removeAll(selectedRows);
            }
            if (!currentPartition.isEmpty()) {
                partitions.add(Lists.newArrayList(currentPartition));
            }
            for (List list : partitions) {
                ImmutableList allRows = ImmutableList.builder().addAll((Iterable)headers).addAll((Iterable)list).build();
                List widths = columns.stream().map(Column::getWidth).collect(Collectors.toList());
                Table.TableBuilder partitionTableBuilder = AbstractPrintService.table((Float)Float.valueOf(input.getWidth()), widths);
                allRows.forEach(arg_0 -> ((Table.TableBuilder)partitionTableBuilder).addRow(arg_0));
                Table partitionTable = partitionTableBuilder.build();
                tableListBuilder.add((Object)partitionTable);
            }
        }
        return tableListBuilder.build();
    }

    @Nonnull
    protected static Iterable<Iterable<Table>> splitVertically(@NonNull Iterable<Table> allTables, int rowsToCopy, float maxSizeOnPage, float sizeBetweenTables) {
        if (allTables == null) {
            throw new NullPointerException("allTables is marked non-null but is null");
        }
        return AbstractPrintService.splitVertically(allTables, (int)rowsToCopy, (float)maxSizeOnPage, (float)sizeBetweenTables, (boolean)false);
    }

    @Nonnull
    protected static Iterable<Iterable<Table>> splitVertically(@NonNull Iterable<Table> allTables, int rowsToCopy, float maxSizeOnPage, float sizeBetweenTables, boolean pagePerTable) {
        ImmutableList allPages;
        if (allTables == null) {
            throw new NullPointerException("allTables is marked non-null but is null");
        }
        boolean everyTableSmallerThanHeight = true;
        for (Table allTable : allTables) {
            if (!(maxSizeOnPage < allTable.getHeight())) continue;
            everyTableSmallerThanHeight = false;
            break;
        }
        if (pagePerTable && everyTableSmallerThanHeight) {
            return ImmutableList.of(allTables);
        }
        ImmutableList.Builder allPagesBuilder = ImmutableList.builder();
        float availableSizeOnCurrentPage = maxSizeOnPage;
        ArrayList currentPageBuilder = Lists.newArrayList();
        for (Table table : allTables) {
            if (pagePerTable) {
                availableSizeOnCurrentPage = maxSizeOnPage;
            }
            List subTables = AbstractPrintService.splitVertically((Table)table, (int)rowsToCopy, (float)availableSizeOnCurrentPage, (float)maxSizeOnPage);
            for (Table subTable : subTables) {
                float subTableHeight = subTable.getHeight();
                if (availableSizeOnCurrentPage < subTableHeight) {
                    if (!currentPageBuilder.isEmpty()) {
                        allPagesBuilder.add((Object)ImmutableList.copyOf((Collection)currentPageBuilder));
                    }
                    currentPageBuilder.clear();
                    availableSizeOnCurrentPage = maxSizeOnPage;
                }
                currentPageBuilder.add(subTable);
                availableSizeOnCurrentPage -= subTableHeight;
                if (!((availableSizeOnCurrentPage -= sizeBetweenTables) < 10.0f)) continue;
                allPagesBuilder.add((Object)ImmutableList.copyOf((Collection)currentPageBuilder));
                currentPageBuilder.clear();
                availableSizeOnCurrentPage = maxSizeOnPage;
            }
        }
        if (!currentPageBuilder.isEmpty()) {
            allPagesBuilder.add((Object)ImmutableList.copyOf((Collection)currentPageBuilder));
        }
        return (allPages = allPagesBuilder.build()).isEmpty() ? ImmutableList.of((Object)ImmutableList.of()) : allPages;
    }

    protected boolean isValueToBePrinted(@NonNull PrintConfiguration printConfiguration) {
        if (printConfiguration == null) {
            throw new NullPointerException("printConfiguration is marked non-null but is null");
        }
        boolean hasWagePrivilege = this.userService.hasPrivilege(EPrivilege.MEASUREMENT__ALL_ATTRIBUTES_VISIBLE);
        return hasWagePrivilege && Iterables.contains((Iterable)printConfiguration.getBooleanPrintOptions(), (Object)EBooleanPrintOption.PRINT_OVERALL_VALUE_ENABLED);
    }

    protected boolean isWageToBePrinted(@NonNull PrintConfiguration printConfiguration) {
        if (printConfiguration == null) {
            throw new NullPointerException("printConfiguration is marked non-null but is null");
        }
        return Iterables.contains((Iterable)printConfiguration.getBooleanPrintOptions(), (Object)EBooleanPrintOption.PRINT_INTERNAL_WAGE_ENABLED);
    }

    protected boolean isSquadToBePrinted(@NonNull PrintConfiguration printConfiguration) {
        if (printConfiguration == null) {
            throw new NullPointerException("printConfiguration is marked non-null but is null");
        }
        return Iterables.contains((Iterable)printConfiguration.getBooleanPrintOptions(), (Object)EBooleanPrintOption.PRINT_SQUAD_ENABLED);
    }

    @Nonnull
    protected static Table pageSection(@NonNull PrintSetup printSetup, @NonNull PDRectangle mediaBox, int page, int maxPages) {
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        float part_28_32 = 0.75f;
        Table.TableBuilder metaBuilder = AbstractPrintService.table((PDRectangle)mediaBox, (Iterable)ImmutableList.of((Object)Float.valueOf(0.125f), (Object)Float.valueOf(0.75f), (Object)Float.valueOf(0.125f)));
        Row metaRow1 = Row.builder().add((AbstractCell)AbstractPrintService.metaCell((PrintSetup)printSetup, (HorizontalAlignment)HorizontalAlignment.LEFT, (String)"", (Iterable)ImmutableList.of())).add((AbstractCell)AbstractPrintService.metaCell((PrintSetup)printSetup, (HorizontalAlignment)HorizontalAlignment.CENTER, (String)"", (Iterable)ImmutableList.of())).add((AbstractCell)AbstractPrintService.metaCell((PrintSetup)printSetup, (HorizontalAlignment)HorizontalAlignment.RIGHT, (String)String.format("Seite: %s / %s", page, maxPages), (Iterable)ImmutableList.of())).build();
        metaBuilder.addRow(metaRow1);
        return metaBuilder.build();
    }

    @Nonnull
    protected static Table aggregationTable(@NonNull PrintSetup printSetup, @NonNull PDFont font, @NonNull Table referenceTable, int colSpan, @NonNull String name, @NonNull Iterable<Column> fillUpColumns, @NonNull Function<ValuedTextCell, BigDecimal> fn) {
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        if (font == null) {
            throw new NullPointerException("font is marked non-null but is null");
        }
        if (referenceTable == null) {
            throw new NullPointerException("referenceTable is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (fillUpColumns == null) {
            throw new NullPointerException("fillUpColumns is marked non-null but is null");
        }
        if (fn == null) {
            throw new NullPointerException("fn is marked non-null but is null");
        }
        int fontSize = printSetup.getAggregationFontSize();
        List dataColumns = referenceTable.getColumns();
        List rows = referenceTable.getRows();
        ImmutableList allColumns = ImmutableList.builder().addAll((Iterable)dataColumns).addAll(fillUpColumns).build();
        LinkedHashSet columnKeys = Sets.newLinkedHashSet();
        HashMap aggregation = Maps.newHashMap();
        for (Row row : rows) {
            List cells = row.getCells();
            for (AbstractCell cell : cells) {
                ValuedTextCell valuedTextCell;
                if (!(cell instanceof ValuedTextCell) || EValueSource.IGNORE == (valuedTextCell = (ValuedTextCell)cell).getSource()) continue;
                String columnKey = valuedTextCell.getColumnKey();
                BigDecimal value = fn.apply(valuedTextCell);
                BigDecimal existing = aggregation.getOrDefault(columnKey, BigDecimal.ZERO);
                aggregation.put(columnKey, existing.add(value));
                columnKeys.add(columnKey);
            }
        }
        Table.TableBuilder tableBuilder = Table.builder().columns((List)allColumns);
        Row.RowBuilder rowBuilder = Row.builder();
        Map defaultBorder = AbstractPrintService.defaultBorder((Iterable)ALL);
        rowBuilder.add((AbstractCell)AbstractPrintService.genericCell((PDFont)font, (int)fontSize, (String)"no-row-key", (String)"no-column-key", (String)name, (BigDecimal)BigDecimal.ZERO, (EValueSource)EValueSource.IGNORE, (int)colSpan, (int)1, (Color)DETAIL_TEXT_COLOR, (Color)DEFAULT_BG_COLOR_AGGREGATION, (HorizontalAlignment)HorizontalAlignment.RIGHT, (Map)defaultBorder));
        for (String columnKey : columnKeys) {
            BigDecimal aggregatedValue = aggregation.getOrDefault(columnKey, BigDecimal.ZERO);
            rowBuilder.add((AbstractCell)AbstractPrintService.valueCell((PDFont)font, (int)fontSize, (String)"no-row-key", (String)"no-column-key", (BigDecimal)aggregatedValue, (EValueSource)EValueSource.AGGREGATION, (HorizontalAlignment)HorizontalAlignment.RIGHT, (Iterable)ALL, (Iterable)ImmutableList.of()));
        }
        for (Column fillUpColumn : fillUpColumns) {
            rowBuilder.add((AbstractCell)AbstractPrintService.fillUpCell((PrintSetup)printSetup, (int)1, (Iterable)TRB));
        }
        tableBuilder.addRow(rowBuilder.build());
        return tableBuilder.build();
    }

    @Nonnull
    protected static Table aggregationTable(@NonNull PrintSetup printSetup, @NonNull PDFont font, @NonNull Table referenceTable, @NonNull Multimap<String, BigDecimal> posProductsPerSPN, int colSpan, @NonNull String name, @NonNull Iterable<Column> fillUpColumns, @NonNull Function<ValuedTextCell, BigDecimal> fn) {
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        if (font == null) {
            throw new NullPointerException("font is marked non-null but is null");
        }
        if (referenceTable == null) {
            throw new NullPointerException("referenceTable is marked non-null but is null");
        }
        if (posProductsPerSPN == null) {
            throw new NullPointerException("posProductsPerSPN is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (fillUpColumns == null) {
            throw new NullPointerException("fillUpColumns is marked non-null but is null");
        }
        if (fn == null) {
            throw new NullPointerException("fn is marked non-null but is null");
        }
        int fontSize = printSetup.getAggregationFontSize();
        List dataColumns = referenceTable.getColumns();
        List rows = referenceTable.getRows();
        ImmutableList allColumns = ImmutableList.builder().addAll((Iterable)dataColumns).addAll(fillUpColumns).build();
        LinkedHashSet columnKeys = Sets.newLinkedHashSet();
        HashMap aggregation = Maps.newHashMap();
        for (Row row : rows) {
            List cells = row.getCells();
            for (AbstractCell cell : cells) {
                ValuedTextCell valuedTextCell;
                if (!(cell instanceof ValuedTextCell) || EValueSource.AMOUNT != (valuedTextCell = (ValuedTextCell)cell).getSource()) continue;
                String columnKey = valuedTextCell.getColumnKey();
                BigDecimal value = posProductsPerSPN.get((Object)columnKey).stream().reduce(BigDecimal.ZERO, BigDecimal::add);
                if (!aggregation.containsKey(columnKey)) {
                    aggregation.put(columnKey, value);
                }
                columnKeys.add(columnKey);
            }
            if (aggregation.isEmpty()) continue;
            break;
        }
        Table.TableBuilder tableBuilder = Table.builder().columns((List)allColumns);
        Row.RowBuilder rowBuilder = Row.builder();
        Map defaultBorder = AbstractPrintService.defaultBorder((Iterable)ALL);
        rowBuilder.add((AbstractCell)AbstractPrintService.genericCell((PDFont)font, (int)fontSize, (String)"no-row-key", (String)"no-column-key", (String)name, (BigDecimal)BigDecimal.ZERO, (EValueSource)EValueSource.IGNORE, (int)colSpan, (int)1, (Color)DETAIL_TEXT_COLOR, (Color)DEFAULT_BG_COLOR_AGGREGATION, (HorizontalAlignment)HorizontalAlignment.RIGHT, (Map)defaultBorder));
        for (String columnKey : columnKeys) {
            BigDecimal aggregatedValue = aggregation.getOrDefault(columnKey, BigDecimal.ZERO);
            rowBuilder.add((AbstractCell)AbstractPrintService.valueCell((PDFont)font, (int)fontSize, (String)"no-row-key", (String)"no-column-key", (BigDecimal)aggregatedValue, (EValueSource)EValueSource.AGGREGATION, (HorizontalAlignment)HorizontalAlignment.RIGHT, (Iterable)ALL, (Iterable)ImmutableList.of()));
        }
        for (Column fillUpColumn : fillUpColumns) {
            rowBuilder.add((AbstractCell)AbstractPrintService.fillUpCell((PrintSetup)printSetup, (int)1, (Iterable)TRB));
        }
        tableBuilder.addRow(rowBuilder.build());
        return tableBuilder.build();
    }

    @Nonnull
    protected static Table fillUpTableBelow(@NonNull PrintSetup printSetup, @NonNull Table referenceTable, int colSpan, float maxDetailsHeight) {
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        if (referenceTable == null) {
            throw new NullPointerException("referenceTable is marked non-null but is null");
        }
        float tableHeight = referenceTable.getHeight();
        List rows = referenceTable.getRows();
        float rowHeight = rows.stream().map(Row::getHeight).min(Floats::compare).orElse(Float.valueOf(printSetup.getDetailsFontSize())).floatValue();
        float spaceLeft = maxDetailsHeight - tableHeight - 10.0f;
        int neededRows = Math.round(spaceLeft / rowHeight);
        ImmutableList columns = ImmutableList.copyOf((Collection)referenceTable.getColumns());
        int columnAmount = columns.size();
        Table.TableBuilder tableBuilder = Table.builder().columns((List)columns);
        for (int i = 0; i < neededRows; ++i) {
            Row row = AbstractPrintService.fillUpRow((PrintSetup)printSetup, (int)columnAmount, (int)colSpan, (Iterable)LRB);
            tableBuilder.addRow(row);
        }
        return tableBuilder.build();
    }

    @Nonnull
    protected static Table fillUpTableRight(@NonNull PrintSetup printSetup, @NonNull Table referenceTable, @NonNull PDRectangle mediaBox, float maxDetailsHeight) {
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        if (referenceTable == null) {
            throw new NullPointerException("referenceTable is marked non-null but is null");
        }
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        float tableHeight = referenceTable.getHeight();
        List rows = referenceTable.getRows();
        List columns = referenceTable.getColumns();
        float colWidth = ((Column)columns.get(0)).getWidth();
        float maxWidth = AbstractPrintService.maxWidth((PDRectangle)mediaBox);
        float existingColumnWidth = IterableHelper.sum((Iterable)columns.stream().map(Column::getWidth).collect(Collectors.toList()));
        float widthToFill = maxWidth - existingColumnWidth;
        int colsNeeded = Math.round(widthToFill / colWidth);
        float rowHeight = rows.stream().map(Row::getHeight).min(Floats::compare).orElse(Float.valueOf(printSetup.getDetailsFontSize())).floatValue();
        float spaceLeft = maxDetailsHeight - tableHeight - 10.0f;
        int rowsNeeded = Math.round(spaceLeft / rowHeight);
        ImmutableList colsFillUpDefinition = ImmutableList.copyOf(IntStream.range(0, colsNeeded).mapToObj(x -> Float.valueOf(0.083333336f)).iterator());
        Table.TableBuilder tableBuilder = AbstractPrintService.table((Float)Float.valueOf(widthToFill), (Iterable)colsFillUpDefinition);
        for (Row existingRow : rows) {
            Row.RowBuilder rowBuilder = Row.builder().height(Float.valueOf(existingRow.getHeight()));
            for (int i = 0; i < colsNeeded; ++i) {
                rowBuilder.add((AbstractCell)AbstractPrintService.fillUpCell((PrintSetup)printSetup, (Iterable)TRB));
            }
            Row row = rowBuilder.build();
            tableBuilder.addRow(row);
        }
        for (int i = 0; i < rowsNeeded; ++i) {
            Row row = AbstractPrintService.fillUpRow((PrintSetup)printSetup, (int)colsNeeded, (int)1, (Iterable)TRB);
            tableBuilder.addRow(row);
        }
        return tableBuilder.build();
    }

    @Nonnull
    protected static Row fillUpRow(@NonNull PrintSetup printSetup, int columns, int colSpan, @NonNull Iterable<EBorder> borders) {
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        if (borders == null) {
            throw new NullPointerException("borders is marked non-null but is null");
        }
        Row.RowBuilder rowBuilder = Row.builder();
        rowBuilder.add((AbstractCell)AbstractPrintService.fillUpCell((PrintSetup)printSetup, (int)colSpan, borders));
        for (int i = colSpan; i < columns; ++i) {
            rowBuilder.add((AbstractCell)AbstractPrintService.fillUpCell((PrintSetup)printSetup, borders));
        }
        return rowBuilder.build();
    }

    protected static void writeMeta(@NonNull PrintSetup printSetup, @NonNull PDDocument document, @NonNull Table footer) {
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        if (document == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        if (footer == null) {
            throw new NullPointerException("footer is marked non-null but is null");
        }
        AbstractPrintService.writeFooter((PDDocument)document, (Table)footer);
        AbstractPrintService.writePageNumber((PrintSetup)printSetup, (PDDocument)document);
    }

    protected static void writePageNumber(@NonNull PrintSetup printSetup, @NonNull PDDocument document) {
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        if (document == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        AtomicInteger currentPage = new AtomicInteger(1);
        int maxPages = document.getPages().getCount();
        for (PDPage page : document.getPages()) {
            PDRectangle mediaBox = page.getMediaBox();
            try (PDPageContentStream contentStream = new PDPageContentStream(document, page, PDPageContentStream.AppendMode.APPEND, true, true);){
                Table meta = AbstractPrintService.pageSection((PrintSetup)printSetup, (PDRectangle)mediaBox, (int)currentPage.getAndIncrement(), (int)maxPages);
                float metaHeight = meta.getHeight();
                TableDrawer.builder().page(page).contentStream(contentStream).startX(20.0f).startY(20.0f + metaHeight).table(meta).build().draw();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected static float writeAggregation(@NonNull PDPage page, @NonNull PDPageContentStream contentStream, float aggregationBaseOffset, @NonNull Iterable<Table> aggregationTables) {
        if (page == null) {
            throw new NullPointerException("page is marked non-null but is null");
        }
        if (contentStream == null) {
            throw new NullPointerException("contentStream is marked non-null but is null");
        }
        if (aggregationTables == null) {
            throw new NullPointerException("aggregationTables is marked non-null but is null");
        }
        float aggregationsHeight = IterableHelper.stream(aggregationTables).map(Table::getHeight).reduce(Float.valueOf(0.0f), Float::sum).floatValue();
        float baseYOffset = aggregationsHeight + aggregationBaseOffset;
        for (Table aggregationTable : aggregationTables) {
            TableDrawer.builder().page(page).contentStream(contentStream).startX(20.0f).startY(baseYOffset).table(aggregationTable).build().draw();
            baseYOffset -= aggregationTable.getHeight();
        }
        return aggregationsHeight;
    }

    protected static void writeFooter(@NonNull PDDocument document, @NonNull Table footer) {
        if (document == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        if (footer == null) {
            throw new NullPointerException("footer is marked non-null but is null");
        }
        for (PDPage page : document.getPages()) {
            try (PDPageContentStream contentStream = new PDPageContentStream(document, page, PDPageContentStream.AppendMode.APPEND, true, true);){
                float footerHeight = footer.getHeight();
                TableDrawer.builder().page(page).contentStream(contentStream).startX(20.0f).startY(30.0f + footerHeight).table(footer).build().draw();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Nonnull
    protected static Map<EBorder, Float> defaultBorder(@NonNull Iterable<EBorder> borders) {
        if (borders == null) {
            throw new NullPointerException("borders is marked non-null but is null");
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        borders.forEach(item -> builder.put(item, (Object)Float.valueOf(0.25f)));
        return builder.build();
    }

    @Nonnull
    protected static Map<EBorder, Float> defaultBorder(@NonNull Iterable<EBorder> borders, float sizePresent, float sizeNotPresent) {
        if (borders == null) {
            throw new NullPointerException("borders is marked non-null but is null");
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (EBorder border : EBorder.values()) {
            if (Iterables.contains(borders, (Object)border)) {
                builder.put((Object)border, (Object)Float.valueOf(sizePresent));
                continue;
            }
            builder.put((Object)border, (Object)Float.valueOf(sizeNotPresent));
        }
        return builder.build();
    }

    @Nonnull
    protected static String formatDuration(@Nullable Duration duration) {
        if (null != duration) {
            BigDecimal hours = DurationHelper.hours((Duration)duration);
            return BigDecimalHelper.asString((BigDecimal)hours, (int)2);
        }
        return "";
    }

    @Nonnull
    protected static String durationAsHourString(@NonNull Duration duration) {
        if (duration == null) {
            throw new NullPointerException("duration is marked non-null but is null");
        }
        return BigDecimalHelper.asString((BigDecimal)DurationHelper.hours((Duration)duration));
    }

    @Nonnull
    protected static String formatTime(@Nullable LocalTime localTime) {
        if (null != localTime) {
            return HOUR_MINUTE_FORMATTER.format(localTime);
        }
        return "";
    }

    @Nonnull
    protected static Color attendanceBGColor(@NonNull AttendanceReportPrintStandard attendanceReportPrintStandard, @NonNull Color rowColor) {
        if (attendanceReportPrintStandard == null) {
            throw new NullPointerException("attendanceReportPrintStandard is marked non-null but is null");
        }
        if (rowColor == null) {
            throw new NullPointerException("rowColor is marked non-null but is null");
        }
        EDay day = attendanceReportPrintStandard.getDay();
        EDayType dayType = attendanceReportPrintStandard.getDayType();
        return AbstractPrintService.attendanceBGColor((Color)rowColor, (EDay)day, (EDayType)dayType);
    }

    @Nonnull
    protected static Color attendanceBGColor(@NonNull BadWeatherReportPrintStandard printStandard, @NonNull Color rowColor) {
        if (printStandard == null) {
            throw new NullPointerException("printStandard is marked non-null but is null");
        }
        if (rowColor == null) {
            throw new NullPointerException("rowColor is marked non-null but is null");
        }
        EDay day = printStandard.getDay();
        EDayType dayType = printStandard.getDayType();
        return AbstractPrintService.attendanceBGColor((Color)rowColor, (EDay)day, (EDayType)dayType);
    }

    @Nonnull
    protected static Color attendanceBGColor(@NonNull PayrollMonthAttendance payrollMonthAttendance, @NonNull Color rowColor) {
        if (payrollMonthAttendance == null) {
            throw new NullPointerException("payrollMonthAttendance is marked non-null but is null");
        }
        if (rowColor == null) {
            throw new NullPointerException("rowColor is marked non-null but is null");
        }
        EDay day = payrollMonthAttendance.getDay();
        EDayType dayType = payrollMonthAttendance.getDayType();
        return AbstractPrintService.attendanceBGColor((Color)rowColor, (EDay)day, (EDayType)dayType);
    }

    @Nonnull
    private static Color attendanceBGColor(@NonNull Color rowColor, @NonNull EDay day, @NonNull EDayType dayType) {
        if (rowColor == null) {
            throw new NullPointerException("rowColor is marked non-null but is null");
        }
        if (day == null) {
            throw new NullPointerException("day is marked non-null but is null");
        }
        if (dayType == null) {
            throw new NullPointerException("dayType is marked non-null but is null");
        }
        boolean highlightDay = HIGHLIGHT_DAY.contains(day);
        boolean highlightDayType = HIGHLIGHT_DAY_TYPE.contains(dayType);
        return highlightDayType ? HIGHLIGHT_BG_COLOR_BANKING_HOLIDAY : (highlightDay ? HIGHLIGHT_BG_COLOR_WEEKEND : rowColor);
    }

    @Nonnull
    protected static Duration durationSum(@NonNull Map<EAggregatedAttendanceDayType, Duration> durationsAggregated) {
        if (durationsAggregated == null) {
            throw new NullPointerException("durationsAggregated is marked non-null but is null");
        }
        Duration workingHours = durationsAggregated.getOrDefault(EAggregatedAttendanceDayType.AGG_WORK, Duration.ZERO);
        Duration vacationHours = durationsAggregated.getOrDefault(EAggregatedAttendanceDayType.AGG_VACATION, Duration.ZERO);
        Duration sickHours = durationsAggregated.getOrDefault(EAggregatedAttendanceDayType.AGG_SICK, Duration.ZERO);
        Duration childSickHours = durationsAggregated.getOrDefault(EAggregatedAttendanceDayType.AGG_CHILD_SICK_LEAVE, Duration.ZERO);
        Duration badWeatherHours = durationsAggregated.getOrDefault(EAggregatedAttendanceDayType.AGG_BAD_WEATHER, Duration.ZERO);
        Duration sickBadWeatherHours = durationsAggregated.getOrDefault(EAggregatedAttendanceDayType.AGG_BAD_WEATHER_SICK, Duration.ZERO);
        Duration absentHours = durationsAggregated.getOrDefault(EAggregatedAttendanceDayType.AGG_ABSENT, Duration.ZERO);
        Duration absentHoursEffective = absentHours.isNegative() ? Duration.ZERO : absentHours;
        Duration absentHoursIncludingChild = absentHoursEffective.plus(childSickHours);
        return workingHours.plus(vacationHours).plus(sickHours).plus(badWeatherHours).plus(sickBadWeatherHours).plus(absentHoursIncludingChild);
    }

    @Nonnull
    protected Row hLineB(int colSpan) {
        return Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).fontSize(Integer.valueOf(1)).height(Float.valueOf(1.0f)).add((AbstractCell)AbstractPrintService.borderCell((Iterable)B, (int)1, (int)colSpan)).build();
    }

    @Nonnull
    protected Row hLineB(@NonNull Iterable<Pair<Integer, Boolean>> lineConfig) {
        if (lineConfig == null) {
            throw new NullPointerException("lineConfig is marked non-null but is null");
        }
        return this.hLine(lineConfig, B);
    }

    @Nonnull
    protected Row hLineTB(@NonNull Iterable<Pair<Integer, Boolean>> lineConfig) {
        if (lineConfig == null) {
            throw new NullPointerException("lineConfig is marked non-null but is null");
        }
        return this.hLine(lineConfig, TB);
    }

    @Nonnull
    protected Row hLine(Iterable<Pair<Integer, Boolean>> lineConfig, @NonNull Iterable<EBorder> borders) {
        if (borders == null) {
            throw new NullPointerException("borders is marked non-null but is null");
        }
        Row.RowBuilder builder = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).fontSize(Integer.valueOf(1)).height(Float.valueOf(1.0f));
        for (Pair<Integer, Boolean> border : lineConfig) {
            Boolean enabled = (Boolean)border.getRight();
            Integer colspan = (Integer)border.getLeft();
            if (Boolean.TRUE == enabled) {
                builder.add((AbstractCell)AbstractPrintService.borderCell(borders, (int)1, (int)colspan));
                continue;
            }
            builder.add((AbstractCell)AbstractPrintService.emptyCell((int)1, (int)colspan));
        }
        return builder.build();
    }

    @Nonnull
    protected Row hLineT(int colSpan) {
        return Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).fontSize(Integer.valueOf(1)).height(Float.valueOf(1.0f)).add((AbstractCell)AbstractPrintService.borderCell((Iterable)T, (int)1, (int)colSpan)).build();
    }

    @Nonnull
    protected Row hlineTB(int colSpan) {
        return Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).fontSize(Integer.valueOf(1)).height(Float.valueOf(1.0f)).add((AbstractCell)AbstractPrintService.borderCell((Iterable)TB, (int)1, (int)colSpan)).build();
    }

    @Nonnull
    protected static Multimap<Integer, PrintPlanOutput> printPlan(@NonNull Iterable<PrintPlanInput> printPlanInputs, float maxDetailsHeightFirstPage, float maxDetailsHeightRest) {
        if (printPlanInputs == null) {
            throw new NullPointerException("printPlanInputs is marked non-null but is null");
        }
        ArrayListMultimap pagesBuilder = ArrayListMultimap.create();
        int currentPage = 0;
        float availableSizeOnPage = maxDetailsHeightFirstPage;
        for (PrintPlanInput printPlanInput : printPlanInputs) {
            Table table = printPlanInput.getTable();
            int rowsToCopyOnSplit = printPlanInput.getRowsToCopyOnSplit();
            float marginAfterTable = printPlanInput.getMarginAfterTable();
            boolean forcePageBreak = printPlanInput.isForcePageBreak();
            float height = table.getHeight();
            boolean enoughSpace = availableSizeOnPage - height > 5.0f;
            boolean currentPageIsEmpty = pagesBuilder.get((Object)currentPage).isEmpty();
            if (!(currentPageIsEmpty || enoughSpace && !forcePageBreak)) {
                ++currentPage;
                availableSizeOnPage = maxDetailsHeightRest;
            }
            if (enoughSpace) {
                pagesBuilder.put((Object)currentPage, (Object)PrintPlanOutput.of((Table)table, (float)marginAfterTable));
                availableSizeOnPage -= height;
                availableSizeOnPage -= marginAfterTable;
                continue;
            }
            List tablesSplitted = AbstractPrintService.splitVertically((Table)table, (int)rowsToCopyOnSplit, (float)availableSizeOnPage, (float)maxDetailsHeightRest);
            for (Table currentTableFromSplit : tablesSplitted) {
                pagesBuilder.put((Object)currentPage++, (Object)PrintPlanOutput.of((Table)currentTableFromSplit, (float)marginAfterTable));
                float currentTableHeight = currentTableFromSplit.getHeight();
                availableSizeOnPage = currentPage < 2 ? maxDetailsHeightFirstPage : maxDetailsHeightRest;
                availableSizeOnPage -= currentTableHeight;
                availableSizeOnPage -= marginAfterTable;
            }
            if (availableSizeOnPage > 5.0f) {
                --currentPage;
                continue;
            }
            availableSizeOnPage = maxDetailsHeightRest;
        }
        return ImmutableMultimap.copyOf((Multimap)pagesBuilder);
    }

    @Nonnull
    protected Table legalCompanyFooter(@NonNull PDRectangle mediaBox, @NonNull PrintSetup printSetup) {
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        int footerFontSize = printSetup.getFooterFontSize();
        PrintFonts printFonts = printSetup.getPrintFonts();
        String footerColumn1 = StringUtils.trimToEmpty((String)printSetup.getFooterColumn1());
        String footerColumn2 = StringUtils.trimToEmpty((String)printSetup.getFooterColumn2());
        String footerColumn3 = StringUtils.trimToEmpty((String)printSetup.getFooterColumn3());
        String footerColumn4 = StringUtils.trimToEmpty((String)printSetup.getFooterColumn4());
        String footerColumn5 = StringUtils.trimToEmpty((String)printSetup.getFooterColumn5());
        Float footerColumn1Width = printSetup.getFooterColumn1Width();
        Float footerColumn2Width = printSetup.getFooterColumn2Width();
        Float footerColumn3Width = printSetup.getFooterColumn3Width();
        Float footerColumn4Width = printSetup.getFooterColumn4Width();
        Float footerColumn5Width = printSetup.getFooterColumn5Width();
        Table.TableBuilder footerBuilder = AbstractPrintService.table((Float)Float.valueOf(AbstractPrintService.footerMaxWidth((PDRectangle)mediaBox)), (Iterable)ImmutableList.of((Object)footerColumn1Width, (Object)footerColumn2Width, (Object)footerColumn3Width, (Object)footerColumn4Width, (Object)footerColumn5Width));
        footerBuilder.addRow(Row.builder().add((AbstractCell)AbstractPrintService.legalCompanyFooterCell((PrintFonts)printFonts, (int)footerFontSize, (Color)FOOTER_TEXT_COLOR, (String)footerColumn1)).add((AbstractCell)AbstractPrintService.legalCompanyFooterCell((PrintFonts)printFonts, (int)footerFontSize, (Color)FOOTER_TEXT_COLOR, (String)footerColumn2)).add((AbstractCell)AbstractPrintService.legalCompanyFooterCell((PrintFonts)printFonts, (int)footerFontSize, (Color)FOOTER_TEXT_COLOR, (String)footerColumn3)).add((AbstractCell)AbstractPrintService.legalCompanyFooterCell((PrintFonts)printFonts, (int)footerFontSize, (Color)FOOTER_TEXT_COLOR, (String)footerColumn4)).add((AbstractCell)AbstractPrintService.legalCompanyFooterCell((PrintFonts)printFonts, (int)footerFontSize, (Color)FOOTER_TEXT_COLOR, (String)footerColumn5)).build());
        return footerBuilder.build();
    }

    protected static float footerMaxWidth(@NonNull PDRectangle mediaBox) {
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        return mediaBox.getWidth() - 141.5f;
    }

    protected AbstractPrintService(UserService userService, DateTimeHelperService dateTimeHelperService, PrintHelper printHelper) {
        this.userService = userService;
        this.dateTimeHelperService = dateTimeHelperService;
        this.printHelper = printHelper;
    }

    public UserService getUserService() {
        return this.userService;
    }

    public DateTimeHelperService getDateTimeHelperService() {
        return this.dateTimeHelperService;
    }

    public PrintHelper getPrintHelper() {
        return this.printHelper;
    }
}

