/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service.gaeb;

import com.google.common.base.MoreObjects;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.thoughtworks.xstream.XStream;
import de.qfm.erp.service.helper.XMLHelper;
import de.qfm.erp.service.model.external.gaeb.x83.Award;
import de.qfm.erp.service.model.external.gaeb.x83.AwardInfo;
import de.qfm.erp.service.model.external.gaeb.x83.BoQ;
import de.qfm.erp.service.model.external.gaeb.x83.BoQBkdn;
import de.qfm.erp.service.model.external.gaeb.x83.BoQBody;
import de.qfm.erp.service.model.external.gaeb.x83.BoQInfo;
import de.qfm.erp.service.model.external.gaeb.x83.GAEB;
import de.qfm.erp.service.model.external.gaeb.x83.ProjectInfo;
import de.qfm.erp.service.model.internal.gaeb.GaebExtractResult;
import de.qfm.erp.service.model.internal.gaeb.ItemFormat;
import de.qfm.erp.service.repository.FileStoreRepository;
import de.qfm.erp.service.service.mapper.GaebX83Mapper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.time.LocalDate;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class GaebX83ImportService {
    private static final Logger log = LogManager.getLogger(GaebX83ImportService.class);
    private final GaebX83Mapper gaebX83Mapper;
    private final XStream xStream;

    @Autowired
    public GaebX83ImportService(GaebX83Mapper gaebX83Mapper, @Qualifier(value="xStreamX83") XStream xStream, FileStoreRepository fileStoreRepository) {
        this.gaebX83Mapper = gaebX83Mapper;
        this.xStream = xStream;
    }

    @NonNull
    public GaebExtractResult handleX83(byte[] buffer) {
        Stopwatch sw = Stopwatch.createStarted();
        log.info("GAEB 0: {}", (Object)sw.elapsed(TimeUnit.MILLISECONDS));
        byte[] bufferFormatted = XMLHelper.prettyPrintByTransformer((byte[])buffer, (boolean)false);
        GAEB gaeb = (GAEB)this.xStream.fromXML((InputStream)new ByteArrayInputStream(bufferFormatted));
        log.info("GAEB 1: {}", (Object)sw.elapsed(TimeUnit.MILLISECONDS));
        Award award = gaeb.getAward();
        BoQBody boQBody = award.getBoQ().getBoQBody();
        log.info("GAEB 2: {}", (Object)sw.elapsed(TimeUnit.MILLISECONDS));
        Iterable descriptions = this.gaebX83Mapper.descriptions(award);
        BoQ boQ = gaeb.getAward().getBoQ();
        BoQInfo boQInfo = boQ.getBoQInfo();
        List bkdn = boQInfo.getBkdn();
        ImmutableList.Builder itemFormatBuilder = ImmutableList.builder();
        ImmutableList.Builder levelsFormatBuilder = ImmutableList.builder();
        AtomicInteger index = new AtomicInteger(1);
        for (BoQBkdn boQBkdn : bkdn) {
            int length = (Integer)MoreObjects.firstNonNull((Object)boQBkdn.getLength(), (Object)-1);
            String label = StringUtils.trimToEmpty((String)boQBkdn.getLblBoQBkdn());
            boolean numeric = StringUtils.equalsIgnoreCase((CharSequence)boQBkdn.getNum(), (CharSequence)"yes");
            String align = StringUtils.trimToEmpty((String)boQBkdn.getAlignment());
            if (StringUtils.equalsIgnoreCase((CharSequence)"BoQLevel", (CharSequence)boQBkdn.getType())) {
                levelsFormatBuilder.add((Object)ItemFormat.level((int)index.getAndIncrement(), (String)label, (int)length, (String)align, (boolean)numeric));
                continue;
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)"Item", (CharSequence)boQBkdn.getType())) continue;
            itemFormatBuilder.add((Object)ItemFormat.position((String)label, (int)length, (String)align, (boolean)numeric));
        }
        ImmutableList levelFormats = levelsFormatBuilder.build();
        ImmutableList itemFormats = itemFormatBuilder.build();
        List positions = this.gaebX83Mapper.positions(boQBody, (List)ImmutableList.of());
        log.info("GAEB 3: {}", (Object)sw.elapsed(TimeUnit.MILLISECONDS));
        ProjectInfo projectInfo = gaeb.getProjectInfo();
        String projectName = null != projectInfo ? StringUtils.trimToEmpty((String)projectInfo.getName()) : "";
        String projectLabel = null != projectInfo ? StringUtils.trimToEmpty((String)projectInfo.getLabel()) : "";
        String projectCurrency = null != projectInfo ? StringUtils.trimToEmpty((String)projectInfo.getCurrency()) : "";
        String projectCurrencyLabel = null != projectInfo ? StringUtils.trimToEmpty((String)projectInfo.getCurrencyLabel()) : "";
        AwardInfo awardInfo = award.getAwardInfo();
        String awardCurrency = awardInfo.getCurrency();
        String awardCurrencyLabel = StringUtils.trimToEmpty((String)awardInfo.getCurrencyLabel());
        LocalDate boQInfoDate = boQInfo.getDate();
        return GaebExtractResult.of((String)projectLabel, (String)projectName, (String)projectCurrency, (String)projectCurrencyLabel, (LocalDate)boQInfoDate, (String)awardCurrency, (String)awardCurrencyLabel, (Iterable)itemFormats, (Iterable)levelFormats, (Iterable)descriptions, (List)positions);
    }
}

