/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service.er2;

import com.google.common.collect.ImmutableList;
import de.qfm.erp.service.model.internal.quotation.EER2OutputType;
import de.qfm.erp.service.model.internal.quotation.ER2InvoiceInputBucket;
import de.qfm.erp.service.model.jpa.invoice.EInvoiceType;
import de.qfm.erp.service.model.jpa.invoice.Invoice;
import de.qfm.erp.service.service.service.ConfigService;
import de.qfm.erp.service.service.service.er2.ER2InvoiceService;
import de.qfm.erp.service.service.service.er2.ER2ServiceInternalInvoice;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Order(value=-2147483648)
public class ER2ServiceInternalInvoice
extends ER2InvoiceService {
    private final ConfigService configService;

    @Autowired
    public ER2ServiceInternalInvoice(@NonNull ConfigService configService) {
        super(EER2OutputType.NORMAL, EInvoiceType.INTERNAL_INVOICE);
        if (configService == null) {
            throw new NullPointerException("configService is marked non-null but is null");
        }
        this.configService = configService;
    }

    @Nonnull
    public Iterable<Iterable<String>> generate(@NonNull Invoice invoice) {
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        return this.er2Rows(invoice);
    }

    @Nonnull
    private static String fromCCToAddressSuffix(@NonNull ER2InvoiceInputBucket er2InvoiceInputBucket) {
        if (er2InvoiceInputBucket == null) {
            throw new NullPointerException("er2InvoiceInputBucket is marked non-null but is null");
        }
        Invoice invoice = er2InvoiceInputBucket.getInvoice();
        String costCenter = StringUtils.trimToEmpty((String)invoice.getCostCenter());
        String addressSuffix = ER2ServiceInternalInvoice.addressSuffix((Invoice)invoice);
        return String.format("%s an %s", addressSuffix, costCenter);
    }

    @Nonnull
    private Iterable<Iterable<String>> er2Rows(@NonNull Invoice invoice) {
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        String stageOrEntityNumberPrefix = this.configService.getStageOrEntityNumberPrefix();
        ER2InvoiceInputBucket er2InvoiceInputBucket = ER2InvoiceInputBucket.of((String)stageOrEntityNumberPrefix, (Invoice)invoice);
        ImmutableList.Builder rowsBuilder = ImmutableList.builder();
        ImmutableList.Builder fPartsBuilder = ImmutableList.builder();
        for (ER2F er2F : ER2F.values()) {
            String value = StringUtils.trimToEmpty((String)((String)er2F.getFn().apply(er2InvoiceInputBucket)));
            fPartsBuilder.add((Object)value);
        }
        ImmutableList fParts = fPartsBuilder.build();
        ImmutableList.Builder iPartsBuilder = ImmutableList.builder();
        for (ER2I er2I : ER2I.values()) {
            String value = StringUtils.trimToEmpty((String)((String)er2I.getFn().apply(er2InvoiceInputBucket)));
            iPartsBuilder.add((Object)value);
        }
        ImmutableList iParts = iPartsBuilder.build();
        ImmutableList.Builder kSenderPartsBuilder = ImmutableList.builder();
        for (ER2K_SENDER eR2K_SENDER : ER2K_SENDER.values()) {
            String value = StringUtils.trimToEmpty((String)((String)eR2K_SENDER.getFn().apply(er2InvoiceInputBucket)));
            kSenderPartsBuilder.add((Object)value);
        }
        ImmutableList kSenderParts = kSenderPartsBuilder.build();
        ImmutableList.Builder gPartRowsBuilder = ImmutableList.builder();
        ImmutableList.Builder gPartsBuilder = ImmutableList.builder();
        for (ER2G eR2G : ER2G.values()) {
            String value = StringUtils.trimToEmpty((String)((String)eR2G.getFn().apply(er2InvoiceInputBucket)));
            gPartsBuilder.add((Object)value);
        }
        ImmutableList immutableList = gPartsBuilder.build();
        gPartRowsBuilder.add((Object)immutableList);
        ImmutableList gPartRows = gPartRowsBuilder.build();
        ImmutableList.Builder kRecipientPartsBuilder = ImmutableList.builder();
        for (ER2K_RECIPIENT er2KRecipient : ER2K_RECIPIENT.values()) {
            String value = StringUtils.trimToEmpty((String)((String)er2KRecipient.getFn().apply(er2InvoiceInputBucket)));
            kRecipientPartsBuilder.add((Object)value);
        }
        ImmutableList immutableList2 = kRecipientPartsBuilder.build();
        ImmutableList.Builder aPartsBuilder = ImmutableList.builder();
        for (ER2A er2A : ER2A.values()) {
            String value = StringUtils.trimToEmpty((String)((String)er2A.getFn().apply(invoice)));
            aPartsBuilder.add((Object)value);
        }
        ImmutableList aParts = aPartsBuilder.build();
        ImmutableList.Builder zbPartsBuilder = ImmutableList.builder();
        for (ER2ZB er2ZB : ER2ZB.values()) {
            String value = StringUtils.trimToEmpty((String)((String)er2ZB.getFn().apply(er2InvoiceInputBucket)));
            zbPartsBuilder.add((Object)value);
        }
        ImmutableList zbParts = zbPartsBuilder.build();
        rowsBuilder.add((Object)fParts);
        rowsBuilder.add((Object)zbParts);
        rowsBuilder.add((Object)kSenderParts);
        rowsBuilder.addAll((Iterable)gPartRows);
        rowsBuilder.add((Object)zbParts);
        rowsBuilder.add((Object)immutableList2);
        return rowsBuilder.build();
    }
}

