/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service.er2;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import de.qfm.erp.service.helper.InvoiceHelper;
import de.qfm.erp.service.model.internal.quotation.EER2OutputType;
import de.qfm.erp.service.model.internal.quotation.ER2InvoiceInputBucket;
import de.qfm.erp.service.model.jpa.invoice.EInvoiceState;
import de.qfm.erp.service.model.jpa.invoice.EInvoiceType;
import de.qfm.erp.service.model.jpa.invoice.Invoice;
import de.qfm.erp.service.service.service.er2.ER2InvoiceService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class ER2InvoiceService {
    protected static final Set<EInvoiceState> NEGATE_INVOICE_STATES = ImmutableSet.of((Object)EInvoiceState.CANCELLED);
    protected static final Set<EInvoiceType> NEGATE_INVOICE_TYPES = ImmutableSet.of((Object)EInvoiceType.CREDIT_VOUCHER);
    protected static final DateTimeFormatter DDMMYYYY = DateTimeFormatter.ofPattern("ddMMyyyy");
    protected static final DateTimeFormatter MMYYYY = DateTimeFormatter.ofPattern("MMyyyy");
    protected static final CharMatcher STR = CharMatcher.ascii().or(CharMatcher.anyOf((CharSequence)"\u00e4\u00f6\u00fc\u00df\u00c4\u00d6\u00dc")).and(CharMatcher.anyOf((CharSequence)",").negate()).precomputed();
    protected static final CharMatcher INT = CharMatcher.inRange((char)'0', (char)'9').precomputed();
    protected static final CharMatcher DEC = CharMatcher.inRange((char)'0', (char)'9').or(CharMatcher.anyOf((CharSequence)".")).precomputed();
    private final EER2OutputType outputType;
    private final Iterable<EInvoiceType> invoiceTypes;
    private static final DecimalFormat NUMBER_FORMAT;
    private static final CharMatcher ADDRESS_SUFFIX_CM;

    protected ER2InvoiceService(@NonNull EER2OutputType outputType, @NonNull EInvoiceType invoiceType) {
        if (outputType == null) {
            throw new NullPointerException("outputType is marked non-null but is null");
        }
        if (invoiceType == null) {
            throw new NullPointerException("invoiceType is marked non-null but is null");
        }
        this.outputType = outputType;
        this.invoiceTypes = ImmutableSet.of((Object)invoiceType);
    }

    protected ER2InvoiceService(@NonNull EER2OutputType outputType, @NonNull Iterable<EInvoiceType> invoiceTypes) {
        if (outputType == null) {
            throw new NullPointerException("outputType is marked non-null but is null");
        }
        if (invoiceTypes == null) {
            throw new NullPointerException("invoiceTypes is marked non-null but is null");
        }
        this.outputType = outputType;
        this.invoiceTypes = ImmutableSet.copyOf(invoiceTypes);
    }

    @Nonnull
    public abstract Iterable<Iterable<String>> generate(@NonNull Invoice var1);

    @Nonnull
    public static String er2BigDecimalAsString(@Nullable BigDecimal bigDecimal) {
        BigDecimal valueWithScale = ((BigDecimal)MoreObjects.firstNonNull((Object)bigDecimal, (Object)BigDecimal.ZERO)).setScale(2, RoundingMode.HALF_UP);
        NUMBER_FORMAT.setMinimumFractionDigits(2);
        NUMBER_FORMAT.setMaximumFractionDigits(2);
        return NUMBER_FORMAT.format(valueWithScale);
    }

    @Nonnull
    protected static String invoiceType(@NonNull Invoice invoice) {
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        EInvoiceType invoiceType = invoice.getInvoiceType();
        switch (1.$SwitchMap$de$qfm$erp$service$model$jpa$invoice$EInvoiceType[invoiceType.ordinal()]) {
            case 1: {
                return "SR";
            }
            case 2: {
                return "TSR";
            }
            case 3: {
                return "ABR";
            }
        }
        return "";
    }

    @Nonnull
    @VisibleForTesting
    protected static String addressSuffix(@NonNull Invoice invoice) {
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        String addressSuffix = StringUtils.trimToEmpty((String)invoice.getInvoiceAddressSuffix());
        return ADDRESS_SUFFIX_CM.replaceFrom((CharSequence)addressSuffix, (CharSequence)" ");
    }

    @Nonnull
    public static String accountingText(@NonNull ER2InvoiceInputBucket bucket, @NonNull Function<Invoice, BigDecimal> secRetFN) {
        if (bucket == null) {
            throw new NullPointerException("bucket is marked non-null but is null");
        }
        if (secRetFN == null) {
            throw new NullPointerException("secRetFN is marked non-null but is null");
        }
        Invoice invoice = bucket.getInvoice();
        String invoiceName = invoice.getInvoiceName();
        String costUnit = ER2InvoiceService.costUnit((ER2InvoiceInputBucket)bucket);
        ArrayList parts = Lists.newArrayList();
        BigDecimal securityRetentionPercent = (BigDecimal)MoreObjects.firstNonNull((Object)secRetFN.apply(invoice), (Object)BigDecimal.ZERO);
        if (BigDecimal.ZERO.compareTo(securityRetentionPercent) == 0) {
            parts.add("OHNE SB");
        } else {
            String securityRetentionPercentAsString = ER2InvoiceService.er2BigDecimalAsString((BigDecimal)securityRetentionPercent);
            parts.add("%s%% SB".formatted(securityRetentionPercentAsString));
        }
        if (StringUtils.isNotBlank((CharSequence)invoiceName)) {
            parts.add(invoiceName);
        }
        if (StringUtils.isNotBlank((CharSequence)costUnit)) {
            parts.add(costUnit);
        }
        return Joiner.on((String)" - ").join((Iterable)parts);
    }

    @Nonnull
    protected static String costUnit(@NonNull ER2InvoiceInputBucket er2InvoiceInputBucket) {
        if (er2InvoiceInputBucket == null) {
            throw new NullPointerException("er2InvoiceInputBucket is marked non-null but is null");
        }
        Invoice invoice = er2InvoiceInputBucket.getInvoice();
        EInvoiceType invoiceType = invoice.getInvoiceType();
        if (EInvoiceType.CREDIT_VOUCHER == invoiceType) {
            String orderDescription = invoice.getOrderDescription();
            return StringUtils.trimToEmpty((String)StringUtils.remove((String)orderDescription, (String)"/"));
        }
        return InvoiceHelper.costUnitDiamant((ER2InvoiceInputBucket)er2InvoiceInputBucket);
    }

    @Deprecated
    @Nonnull
    public static String accountingText(@NonNull Invoice invoice, @NonNull Function<Invoice, BigDecimal> secRetFN) {
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        if (secRetFN == null) {
            throw new NullPointerException("secRetFN is marked non-null but is null");
        }
        boolean flagSecurityRetention = (Boolean)MoreObjects.firstNonNull((Object)invoice.getFlagSecurityRetention(), (Object)false);
        String invoiceName = invoice.getInvoiceName();
        String costUnit = InvoiceHelper.costUnitER2Invoice((Invoice)invoice);
        if (flagSecurityRetention) {
            return String.format("%s%% SB - %s - %s", ER2InvoiceService.er2BigDecimalAsString((BigDecimal)secRetFN.apply(invoice)), invoiceName, costUnit);
        }
        return String.format("OHNE SB - %s - %s", invoiceName, costUnit);
    }

    public EER2OutputType getOutputType() {
        return this.outputType;
    }

    public Iterable<EInvoiceType> getInvoiceTypes() {
        return this.invoiceTypes;
    }

    static {
        DecimalFormatSymbols otherSymbols = new DecimalFormatSymbols(Locale.GERMAN);
        otherSymbols.setDecimalSeparator('.');
        otherSymbols.setGroupingSeparator(',');
        NUMBER_FORMAT = new DecimalFormat("#######0.00", otherSymbols);
        ADDRESS_SUFFIX_CM = CharMatcher.breakingWhitespace();
    }
}

