/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service.csv;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import de.leancoders.common.helper.DateTimeHelper;
import de.qfm.erp.service.helper.ASCIIFoldingHelper;
import de.qfm.erp.service.helper.EmployeeHelper;
import de.qfm.erp.service.helper.IMeasurementComparators;
import de.qfm.erp.service.model.internal.csv.ECsvExportType;
import de.qfm.erp.service.model.jpa.measurement.Measurement;
import de.qfm.erp.service.model.jpa.measurement.MeasurementPosition;
import de.qfm.erp.service.model.jpa.measurement.PssReleaseOrder;
import de.qfm.erp.service.model.jpa.measurement.ReleaseOrder;
import de.qfm.erp.service.model.jpa.measurement.type.EMeasurementType;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.service.security.UserService;
import de.qfm.erp.service.service.service.csv.MeasurementCsvExportWriter;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class MeasurementCsvExportWriteTelekom
extends MeasurementCsvExportWriter {
    private static final String COL_JOIN_CHAR = ";";
    private static final CharMatcher UNSAFE_CHARS = CharMatcher.ascii().and(CharMatcher.anyOf((CharSequence)"\n\r").negate()).and(CharMatcher.isNot((char)';')).and(CharMatcher.isNot((char)'\"')).negate();
    private static final Joiner COL_JOINER = Joiner.on((String)";").useForNull("");
    private static final Joiner FACTOR_JOINER = Joiner.on((String)"*").skipNulls();
    @VisibleForTesting
    static final DecimalFormat NUMBER_FORMAT;
    private final UserService userService;
    private static final CharMatcher ALLOWED_PO_NUMBER_CHARS;

    public ECsvExportType svExportType() {
        return ECsvExportType.TELEKOM;
    }

    public Function<String, String> colCharFn() {
        return s -> {
            boolean contains = StringUtils.contains((CharSequence)s, (CharSequence)";");
            if (contains) {
                return String.format("\"%s\"", s);
            }
            return s;
        };
    }

    public Joiner colJoiner() {
        return COL_JOINER;
    }

    @Nonnull
    public Stream<Iterable<String>> prepare(@NonNull Measurement measurement) {
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        User user = this.userService.authenticatedUser();
        String lastName = user.getLastName();
        String measurementNumber = measurement.getMeasurementNumber();
        ReleaseOrder releaseOrder = measurement.getReleaseOrder();
        PssReleaseOrder pssReleaseOrder = releaseOrder.getPssReleaseOrder();
        String releaseOrderNumber = null != pssReleaseOrder ? StringUtils.trimToEmpty((String)pssReleaseOrder.getReleaseOrderNumber()) : "";
        String releaseOrderProjectNumber = null != pssReleaseOrder ? StringUtils.trimToEmpty((String)pssReleaseOrder.getProjectNumber()) : "";
        EMeasurementType measurementType = measurement.getMeasurementType();
        LocalDate projectExecutionStartDate = measurement.getProjectExecutionStartDate();
        String projectExecutionStartDateAsIso = DateTimeHelper.toIsoDate((LocalDate)projectExecutionStartDate);
        LocalDate projectExecutionEndDate = measurement.getProjectExecutionEndDate();
        String projectExecutionEndDateAsIso = DateTimeHelper.toIsoDate((LocalDate)projectExecutionEndDate);
        String constructionSite = measurement.getConstructionSite();
        User assignedUser = measurement.getAssignedUser();
        LocalDate accountingMonth = measurement.getAccountingMonth();
        String currentCostCenter = EmployeeHelper.currentCostCenterNotFailing((User)assignedUser, (LocalDate)accountingMonth).orElse("n/a");
        String poNumber = MeasurementCsvExportWriteTelekom.poNumber((String)releaseOrderNumber, (String)releaseOrderProjectNumber);
        String poItem = MeasurementCsvExportWriteTelekom.safeString((String)"10", (int)10);
        String finalMark = measurementType == EMeasurementType.MAIN ? MeasurementCsvExportWriteTelekom.safeString((String)"Yes", (int)10) : MeasurementCsvExportWriteTelekom.safeString((String)"No", (int)10);
        String lzVon = projectExecutionStartDateAsIso;
        String lzBis = projectExecutionEndDateAsIso;
        String safeMeasurementNumber = MeasurementCsvExportWriteTelekom.safeString((String)measurementNumber, (int)7);
        String txz01 = MeasurementCsvExportWriteTelekom.safeString((String)String.format("Kst. %s #%s", currentCostCenter, safeMeasurementNumber), (int)40);
        String sbnaman = MeasurementCsvExportWriteTelekom.safeString((String)lastName, (int)12);
        String dlort = MeasurementCsvExportWriteTelekom.safeString((String)constructionSite, (int)25);
        List measurementPositions = (List)MoreObjects.firstNonNull((Object)measurement.getMeasurementPositions(), (Object)ImmutableList.of());
        ImmutableList sortedMeasurementPositions = ImmutableList.sortedCopyOf((Comparator)IMeasurementComparators.MEASUREMENT_POSITION_COMPARATOR, (Iterable)measurementPositions);
        ArrayList srvPosList = Lists.newArrayList();
        ArrayList mengeList = Lists.newArrayList();
        ArrayList longTextList = Lists.newArrayList();
        ArrayList sectionTextList = Lists.newArrayList();
        sortedMeasurementPositions.forEach(mp -> {
            String positionNumber = MeasurementCsvExportWriteTelekom.safeString((String)mp.getQuotationPositionNumber(), (int)25);
            String positionRemarks = MeasurementCsvExportWriteTelekom.safeString((String)mp.getRemarks(), (int)250);
            srvPosList.add(positionNumber);
            String factorAsString = MeasurementCsvExportWriteTelekom.safeString((String)this.factorAsString(mp), (int)25);
            mengeList.add(factorAsString);
            longTextList.add(positionRemarks);
            sectionTextList.add("");
        });
        String srvpos = COL_JOINER.join((Iterable)srvPosList);
        String menge = COL_JOINER.join((Iterable)mengeList);
        String longText = COL_JOINER.join((Iterable)longTextList);
        String sectionText = COL_JOINER.join((Iterable)sectionTextList);
        ImmutableList header = ImmutableList.of((Object)"po_number", (Object)"po_item", (Object)"finalMark", (Object)"lzvon", (Object)"lzbis", (Object)"txz01", (Object)"sbnaman", (Object)"dlort", (Object)"srvpos", (Object)"menge", (Object)"longText", (Object)"sectionText", (Object[])new String[0]);
        ImmutableList row = ImmutableList.of((Object)poNumber, (Object)poItem, (Object)finalMark, (Object)lzVon, (Object)lzBis, (Object)txz01, (Object)sbnaman, (Object)dlort, (Object)srvpos, (Object)menge, (Object)longText, (Object)sectionText, (Object[])new String[0]);
        return Stream.of(header, row);
    }

    @Nonnull
    private String factorAsString(@NonNull MeasurementPosition measurementPosition) {
        if (measurementPosition == null) {
            throw new NullPointerException("measurementPosition is marked non-null but is null");
        }
        BigDecimal amount = measurementPosition.getAmount();
        BigDecimal factor1 = measurementPosition.getFactor1();
        BigDecimal factor2 = measurementPosition.getFactor2();
        BigDecimal factor3 = measurementPosition.getFactor3();
        ArrayList parts = Lists.newArrayList();
        MeasurementCsvExportWriteTelekom.asString((BigDecimal)amount).ifPresent(parts::add);
        MeasurementCsvExportWriteTelekom.asString((BigDecimal)factor1).ifPresent(parts::add);
        MeasurementCsvExportWriteTelekom.asString((BigDecimal)factor2).ifPresent(parts::add);
        MeasurementCsvExportWriteTelekom.asString((BigDecimal)factor3).ifPresent(parts::add);
        return FACTOR_JOINER.join((Iterable)parts);
    }

    @Nonnull
    private static Optional<String> asString(@Nullable BigDecimal bigDecimal) {
        return Optional.ofNullable(bigDecimal).map(NUMBER_FORMAT::format);
    }

    @Nonnull
    private static String safeString(@Nullable String input, int maxLength) {
        return StringUtils.trimToEmpty((String)StringUtils.left((String)UNSAFE_CHARS.replaceFrom((CharSequence)ASCIIFoldingHelper.foldString((String)StringUtils.trimToEmpty((String)input)), (CharSequence)"_"), (int)maxLength));
    }

    @Nonnull
    @VisibleForTesting
    static String poNumber(@NonNull String releaseOrderNumber, @NonNull String projectNumber) {
        if (releaseOrderNumber == null) {
            throw new NullPointerException("releaseOrderNumber is marked non-null but is null");
        }
        if (projectNumber == null) {
            throw new NullPointerException("projectNumber is marked non-null but is null");
        }
        String projectNumberROCandidate = StringUtils.substringBefore((String)projectNumber, (String)"-");
        String releaseOrderNumberFallback = StringUtils.trimToEmpty((String)ALLOWED_PO_NUMBER_CHARS.retainFrom((CharSequence)projectNumberROCandidate));
        String releaseOrderNumberWOSuffix = StringUtils.substringBefore((String)releaseOrderNumber, (String)"-");
        String releaseOrderNumberPrimary = StringUtils.trimToEmpty((String)ALLOWED_PO_NUMBER_CHARS.retainFrom((CharSequence)releaseOrderNumberWOSuffix));
        if (StringUtils.isNotBlank((CharSequence)releaseOrderNumberPrimary)) {
            return releaseOrderNumberPrimary;
        }
        return releaseOrderNumberFallback;
    }

    public MeasurementCsvExportWriteTelekom(UserService userService) {
        this.userService = userService;
    }

    static {
        DecimalFormat numberFormat3 = new DecimalFormat("###0.000");
        numberFormat3.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.ENGLISH));
        NUMBER_FORMAT = numberFormat3;
        ALLOWED_PO_NUMBER_CHARS = CharMatcher.inRange((char)'0', (char)'9');
    }
}

