/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import de.qfm.erp.service.model.internal.quotation.StageBudget;
import de.qfm.erp.service.model.internal.quotation.StageBudgetResult;
import de.qfm.erp.service.model.jpa.quotation.EQStageState;
import de.qfm.erp.service.model.jpa.quotation.EQStageType;
import de.qfm.erp.service.model.jpa.quotation.QEntity;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.service.handler.StageHandler;
import de.qfm.erp.service.service.service.ConfigService;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class StageHelperService {
    private final ConfigService configService;
    private final StageHandler stageHandler;
    private final Pattern entityNumberWOQMatcher = Pattern.compile("[0-9]{6}");
    private final Pattern stageNumberWOQMatcher = Pattern.compile("[0-9]{10}");
    private Pattern entityNumberWQMatcher = null;
    private Pattern stageNumberWQMatcher = null;
    private static final Function<StageBudget, BigDecimal> FN = input -> {
        BigDecimal orderValue = input.getOrderValue();
        BigDecimal orderValueEstimate = input.getOrderValueEstimate();
        return null != orderValue ? orderValue : (null != orderValueEstimate ? orderValueEstimate : BigDecimal.ZERO);
    };
    public static final Pattern COST_UNIT_NUMBER_WD_MATCHER = Pattern.compile("[0-9]{2}/[0-9]{3}/[0-9]{3}");
    public static final Pattern COST_UNIT_NUMBER_WOD_MATCHER = Pattern.compile("[0-9]{2}[0-9]{3}[0-9]{3}");

    @Autowired
    public StageHelperService(ConfigService configService, StageHandler stageHandler) {
        this.configService = configService;
        this.stageHandler = stageHandler;
    }

    private static Predicate<StageBudget> stageBudgetFN() {
        return item -> {
            boolean isCommType = Iterables.contains((Iterable)EQStageType.BUDGET_TYPES_COMMISSION, (Object)item.getStageType());
            boolean isAddType = Iterables.contains((Iterable)EQStageType.BUDGET_TYPES_ADDENDUM, (Object)item.getStageType());
            return isCommType || isAddType && (Boolean)MoreObjects.firstNonNull((Object)item.getFlagBudgetRelevant(), (Object)false) != false;
        };
    }

    @Nonnull
    public BigDecimal budget(@NonNull Quotation stage) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        Iterable stageBudgets = this.budgets(stage).getStageBudgets();
        return Streams.stream((Iterable)stageBudgets).map(FN).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    @Nonnull
    public StageBudgetResult budgets(@NonNull Quotation stage) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        EQStageType stageType = stage.getStageType();
        EQStageState stageState = stage.getStageState();
        if (EQStageType.COMMISSION == stageType) {
            boolean flagCrossVersionOrderValue = (Boolean)MoreObjects.firstNonNull((Object)stage.getFlagCrossVersionOrderValue(), (Object)false);
            if (flagCrossVersionOrderValue) {
                Iterable allBudgets = this.stageHandler.budgets((Iterable)ImmutableList.of(), (Iterable)ImmutableSet.of((Object)stage.getQEntity()), EQStageType.BUDGET_TYPES_ALL, EQStageState.BUDGET_STATES__IGNORE_VERSION);
                ImmutableList stageBudgets = (ImmutableList)Streams.stream((Iterable)allBudgets).filter(StageHelperService.stageBudgetFN()).collect(ImmutableList.toImmutableList());
                return StageBudgetResult.of((Iterable)stageBudgets, (Iterable)allBudgets);
            }
            Integer version = stage.getVersion();
            QEntity entity = stage.getQEntity();
            ImmutableList allBudgets = null != entity ? this.stageHandler.budgets((Iterable)ImmutableList.of(), (Iterable)ImmutableSet.of((Object)stage.getQEntity()), EQStageType.BUDGET_TYPES_ALL, EQStageState.BUDGET_STATES__CONSIDER_VERSION) : ImmutableList.of();
            ImmutableList stageBudgets = (ImmutableList)Streams.stream((Iterable)allBudgets).filter(StageHelperService.stageBudgetFN()).filter(item -> Objects.equals(version, item.getVersion())).collect(ImmutableList.toImmutableList());
            return StageBudgetResult.of((Iterable)stageBudgets, (Iterable)allBudgets);
        }
        long stageId = stage.getId();
        Integer version = stage.getVersion();
        Boolean flagBudgetRelevant = (Boolean)MoreObjects.firstNonNull((Object)stage.getFlagBudgetRelevant(), (Object)false);
        Boolean flagCrossVersionOrderValue = (Boolean)MoreObjects.firstNonNull((Object)stage.getFlagCrossVersionOrderValue(), (Object)false);
        StageBudget stageBudget = new StageBudget(Long.valueOf(stageId), version, stageType, stageState, flagBudgetRelevant, flagCrossVersionOrderValue, stage.getOrderValue(), stage.getOrderValueEstimate(), stage.getBudgetAllowedOverdraftPercent(), stage.getBudgetAllowedOverdraftValue());
        return StageBudgetResult.of((Iterable)ImmutableSet.of((Object)stageBudget), (Iterable)ImmutableSet.of((Object)stageBudget));
    }

    @Nonnull
    public Pattern entityNumberWQMatcher() {
        if (null == this.entityNumberWQMatcher) {
            String stageOrEntityNumberPrefix1 = this.configService.getStageOrEntityNumberPrefix();
            this.entityNumberWQMatcher = Pattern.compile("(?i)" + stageOrEntityNumberPrefix1 + "[0-9]{6}");
        }
        return this.entityNumberWQMatcher;
    }

    @Nonnull
    public Pattern stageNumberWQMatcher() {
        if (null == this.stageNumberWQMatcher) {
            String stageOrEntityNumberPrefix1 = this.configService.getStageOrEntityNumberPrefix();
            this.stageNumberWQMatcher = Pattern.compile("(?i)" + stageOrEntityNumberPrefix1 + "[0-9]{10}");
        }
        return this.stageNumberWQMatcher;
    }

    public boolean entityNumberPattern(@NonNull String query) {
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        int length = StringUtils.length((CharSequence)query);
        return length == 7 && this.entityNumberWQMatcher().matcher(StringUtils.lowerCase((String)query)).matches() || length == 6 && this.entityNumberWOQMatcher.matcher(StringUtils.lowerCase((String)query)).matches();
    }

    public boolean stageNumberPattern(String query) {
        int length = StringUtils.length((CharSequence)query);
        return length == 11 && this.stageNumberWQMatcher().matcher(query).matches() || length == 10 && this.stageNumberWOQMatcher.matcher(query).matches();
    }

    public boolean costUnitNumberPattern(@NonNull String query) {
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        int length = StringUtils.length((CharSequence)query);
        return length == 10 && COST_UNIT_NUMBER_WD_MATCHER.matcher(query).matches() || length == 8 && COST_UNIT_NUMBER_WOD_MATCHER.matcher(query).matches();
    }

    @Nonnull
    public String costUnit(@NonNull String costUnitCandidate) {
        if (costUnitCandidate == null) {
            throw new NullPointerException("costUnitCandidate is marked non-null but is null");
        }
        boolean isStageNumberPattern = this.stageNumberPattern(costUnitCandidate);
        boolean isCostUnitNumberPattern = this.costUnitNumberPattern(costUnitCandidate);
        String costUnit = costUnitCandidate;
        if (isStageNumberPattern) {
            String stageOrEntityNumberPrefix = this.configService.getStageOrEntityNumberPrefix();
            costUnit = StringUtils.removeStart((String)costUnitCandidate, (String)stageOrEntityNumberPrefix);
        }
        if (isCostUnitNumberPattern) {
            costUnit = StringUtils.remove((String)costUnitCandidate, (String)"/");
        }
        return costUnit;
    }
}

