/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import de.leancoders.common.helper.DateTimeHelper;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.invoice.EntityNumber;
import de.qfm.erp.service.model.jpa.invoice.StageNumber;
import de.qfm.erp.service.model.jpa.quotation.EQStageNumberType;
import de.qfm.erp.service.model.jpa.quotation.EQStageType;
import de.qfm.erp.service.service.handler.EntityFactory;
import de.qfm.erp.service.service.handler.EntityNumberHandler;
import de.qfm.erp.service.service.handler.StageNumberHandler;
import de.qfm.erp.service.service.service.ConfigService;
import de.qfm.erp.service.service.service.QNumberService;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class QNumberService {
    private static final Logger log = LogManager.getLogger(QNumberService.class);
    private final EntityFactory entityFactory;
    private final EntityNumberHandler entityNumberHandler;
    private final StageNumberHandler stageNumberHandler;
    private final ConfigService configService;
    public static final int STAGE_NUMBER_PADDING = 4;
    public static final String STAGE_NUMBER_PAD_WITH = "0";
    public static final int ENTITY_NUMBER_PADDING = 4;
    public static final String ENTITY_NUMBER_PAD_WITH = "0";

    @Nonnull
    public synchronized EntityNumber determineNextQNumber() {
        int year = DateTimeHelper.today().getYear();
        EntityNumber entityNumber = this.entityNumberHandler.byYearNotFailing(Integer.valueOf(year)).orElseGet(() -> this.entityFactory.entityNumber(year));
        Long currentNumber = (Long)MoreObjects.firstNonNull((Object)entityNumber.getCurrentValue(), (Object)0L);
        Long nextNumber = 1L + currentNumber;
        entityNumber.setCurrentValue(nextNumber);
        return (EntityNumber)this.entityNumberHandler.update((EntityBase)entityNumber);
    }

    @Nonnull
    public synchronized StageNumber determineNextQNumber(@NonNull String entityNumber, @NonNull EQStageType stageType) {
        if (entityNumber == null) {
            throw new NullPointerException("entityNumber is marked non-null but is null");
        }
        if (stageType == null) {
            throw new NullPointerException("stageType is marked non-null but is null");
        }
        EQStageNumberType stageNumberType = (EQStageNumberType)EQStageNumberType.TYPE_MAPPING.get(stageType);
        StageNumber stageNumber = this.stageNumberHandler.byEntityNumberAndStageType(entityNumber, stageNumberType).orElseGet(() -> this.entityFactory.stageNumber(entityNumber, stageNumberType));
        Long start = EQStageNumberType.COST_UNIT == stageNumberType ? 0L : -1L;
        Long currentNumber = (Long)MoreObjects.firstNonNull((Object)stageNumber.getCurrentValue(), (Object)start);
        Long nextNumber = 1L + currentNumber;
        stageNumber.setCurrentValue(nextNumber);
        return (StageNumber)this.stageNumberHandler.update((EntityBase)stageNumber);
    }

    public static String format(@NonNull StageNumber stageNumber) {
        if (stageNumber == null) {
            throw new NullPointerException("stageNumber is marked non-null but is null");
        }
        String entityNumberAsString = stageNumber.getEntityNumber();
        EQStageNumberType stageType = stageNumber.getStageNumberType();
        Long currentValue = stageNumber.getCurrentValue();
        return QNumberService.format((String)entityNumberAsString, (String)(switch (1.$SwitchMap$de$qfm$erp$service$model$jpa$quotation$EQStageNumberType[stageType.ordinal()]) {
            case 1 -> "X";
            case 2 -> "KA";
            case 3 -> "A";
            case 4 -> "";
            case 5 -> "";
            case 6 -> "N";
            default -> "x";
        }), (Long)currentValue);
    }

    @VisibleForTesting
    public static String format(@NonNull String entityNumberAsString, @NonNull String infix, @NonNull Long nextNumber) {
        if (entityNumberAsString == null) {
            throw new NullPointerException("entityNumberAsString is marked non-null but is null");
        }
        if (infix == null) {
            throw new NullPointerException("infix is marked non-null but is null");
        }
        if (nextNumber == null) {
            throw new NullPointerException("nextNumber is marked non-null but is null");
        }
        String numberAsString = Long.toString(nextNumber);
        int infixLen = StringUtils.length((CharSequence)infix);
        String numberPadded = StringUtils.leftPad((String)numberAsString, (int)(4 - infixLen), (String)"0");
        return String.format("%s%s%s", entityNumberAsString, infix, numberPadded);
    }

    @Nonnull
    public String format(@NonNull EntityNumber entityNumber) {
        if (entityNumber == null) {
            throw new NullPointerException("entityNumber is marked non-null but is null");
        }
        String stageOrEntityNumberPrefix = this.configService.getStageOrEntityNumberPrefix();
        Integer year = entityNumber.getYear();
        Long number = entityNumber.getCurrentValue();
        return QNumberService.format((String)stageOrEntityNumberPrefix, (Integer)year, (Long)number);
    }

    @Nonnull
    public static String format(@NonNull String prefix, @NonNull Integer year, @NonNull Long number) {
        if (prefix == null) {
            throw new NullPointerException("prefix is marked non-null but is null");
        }
        if (year == null) {
            throw new NullPointerException("year is marked non-null but is null");
        }
        if (number == null) {
            throw new NullPointerException("number is marked non-null but is null");
        }
        String numberAsString = Long.toString(number);
        String numberAsStringLPad = StringUtils.leftPad((String)numberAsString, (int)4, (String)"0");
        String yearAsString = Integer.toString(year);
        String yearAsSubbed = StringUtils.right((String)yearAsString, (int)2);
        return String.format("%s%s%s", prefix, yearAsSubbed, numberAsStringLPad);
    }

    public QNumberService(EntityFactory entityFactory, EntityNumberHandler entityNumberHandler, StageNumberHandler stageNumberHandler, ConfigService configService) {
        this.entityFactory = entityFactory;
        this.entityNumberHandler = entityNumberHandler;
        this.stageNumberHandler = stageNumberHandler;
        this.configService = configService;
    }
}

