/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service;

import com.google.common.base.MoreObjects;
import de.qfm.erp.service.model.internal.history.HistoryField;
import de.qfm.erp.service.model.internal.message.EMessageKey;
import de.qfm.erp.service.model.internal.message.Message;
import de.qfm.erp.service.model.internal.message.Translatable;
import de.qfm.erp.service.model.jpa.employee.payroll.EPayrollMonthMessageKeys;
import de.qfm.erp.service.model.jpa.quotation.EStagePrintBoilerPlate;
import de.qfm.erp.service.model.jpa.user.EPrivilege;
import de.qfm.erp.service.model.search.IndexField;
import java.util.Locale;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;

@Component
public class MessageService {
    private static final Logger log = LogManager.getLogger(MessageService.class);
    private static final String ENTITY_PATTERN = "entity.%s";
    private static final String FIELD_PATTERN = "field.%s";
    private static final Object[] EMPTY = new Object[0];
    private final MessageSource messageSourceHistory;
    private final MessageSource messageSourceStandard;
    private final MessageSource messageSourcePayrollMonth;
    private final MessageSource messageSourcePrivileges;
    private final MessageSource messageSourcePrint;
    private final MessageSource messageSourceIndexFields;

    @Autowired
    public MessageService(@Qualifier(value="messageSourceHistory") MessageSource messageSourceHistory, @Qualifier(value="messageSourceIndexFields") MessageSource messageSourceIndexFields, @Qualifier(value="messageSource") MessageSource messageSourceStandard, @Qualifier(value="messageSourcePayrollMonth") MessageSource messageSourcePayrollMonth, @Qualifier(value="messageSourcePrivileges") MessageSource messageSourcePrivileges, @Qualifier(value="messageSourcePrint") MessageSource messageSourcePrint) {
        this.messageSourceHistory = messageSourceHistory;
        this.messageSourceIndexFields = messageSourceIndexFields;
        this.messageSourceStandard = messageSourceStandard;
        this.messageSourcePayrollMonth = messageSourcePayrollMonth;
        this.messageSourcePrivileges = messageSourcePrivileges;
        this.messageSourcePrint = messageSourcePrint;
    }

    @Nonnull
    public String translateField(@NonNull String field) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        return this.translatePattern(field, FIELD_PATTERN);
    }

    public String translateEnum(@NonNull String prefix, @NonNull String field) {
        if (prefix == null) {
            throw new NullPointerException("prefix is marked non-null but is null");
        }
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        String pattern = prefix + "%s";
        return this.translatePattern(StringUtils.lowerCase((String)field), pattern);
    }

    @Nonnull
    public String translatePattern(@NonNull String field, @NonNull String pattern) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        Locale locale = LocaleContextHolder.getLocale();
        String lookupKey = String.format(pattern, field);
        try {
            return (String)MoreObjects.firstNonNull((Object)this.messageSourceStandard.getMessage(lookupKey, EMPTY, locale), (Object)"");
        }
        catch (NoSuchMessageException nsme) {
            log.warn("Message Key not found for Field: {} and Locale: {}, returning Original; ErrorMsg: {}", (Object)field, (Object)locale, (Object)nsme.getMessage());
            return lookupKey;
        }
    }

    @Nonnull
    public String translate(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        Locale locale = LocaleContextHolder.getLocale();
        try {
            return (String)MoreObjects.firstNonNull((Object)this.messageSourceStandard.getMessage(key, EMPTY, locale), (Object)"");
        }
        catch (NoSuchMessageException nsme) {
            log.warn("Translation not found for Key: {} and Locale: {}, returning Original; ErrorMsg: {}", (Object)key, (Object)locale, (Object)nsme.getMessage());
            return key;
        }
    }

    @Nonnull
    public String get(@NonNull Message message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        return this.get((Translatable)message.getMessageKey(), message.getValues().toArray());
    }

    @Nonnull
    public String get(@NonNull EMessageKey messageKey) {
        if (messageKey == null) {
            throw new NullPointerException("messageKey is marked non-null but is null");
        }
        return this.get((Translatable)messageKey, EMPTY);
    }

    @Nonnull
    public String get(@NonNull Translatable translatable, Object ... params) {
        if (translatable == null) {
            throw new NullPointerException("translatable is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        Locale locale = LocaleContextHolder.getLocale();
        return this.getForLocale(translatable, locale, params);
    }

    @Nonnull
    public String getDE(@NonNull Translatable translatable, Object ... params) {
        if (translatable == null) {
            throw new NullPointerException("translatable is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        Locale locale = Locale.GERMAN;
        return this.getForLocale(translatable, locale, params);
    }

    @Nonnull
    public String getEN(@NonNull Translatable translatable, Object ... params) {
        if (translatable == null) {
            throw new NullPointerException("translatable is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        Locale locale = Locale.ENGLISH;
        return this.getForLocale(translatable, locale, params);
    }

    @Nonnull
    private String getForLocale(@NonNull Translatable translatable, @NonNull Locale locale, @NonNull Object[] params) {
        if (translatable == null) {
            throw new NullPointerException("translatable is marked non-null but is null");
        }
        if (locale == null) {
            throw new NullPointerException("locale is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        String messageCode = translatable.messageCode();
        try {
            return (String)MoreObjects.firstNonNull((Object)this.messageSourceStandard.getMessage(messageCode, params, locale), (Object)"");
        }
        catch (NoSuchMessageException nsme) {
            log.warn("Message Key not found for Message Code: {} and Locale: {}, returning Original; Error: {}", (Object)messageCode, (Object)locale, (Object)nsme.getMessage());
            return messageCode;
        }
    }

    @Nonnull
    public String getDE(@NonNull EPrivilege privilege) {
        if (privilege == null) {
            throw new NullPointerException("privilege is marked non-null but is null");
        }
        Locale locale = Locale.GERMAN;
        return this.getForLocale(privilege, locale);
    }

    @Nonnull
    public String getEN(@NonNull EPrivilege privilege) {
        if (privilege == null) {
            throw new NullPointerException("privilege is marked non-null but is null");
        }
        Locale locale = Locale.ENGLISH;
        return this.getForLocale(privilege, locale);
    }

    @Nonnull
    private String getForLocale(@NonNull EPrivilege privilege, @NonNull Locale locale) {
        if (privilege == null) {
            throw new NullPointerException("privilege is marked non-null but is null");
        }
        if (locale == null) {
            throw new NullPointerException("locale is marked non-null but is null");
        }
        String messageCode = privilege.messageCode();
        try {
            return (String)MoreObjects.firstNonNull((Object)this.messageSourcePrivileges.getMessage(messageCode, new Object[0], locale), (Object)"");
        }
        catch (NoSuchMessageException nsme) {
            log.warn("Message Key not found for Message Code: {} and Locale: {}, returning Original; Error: {}", (Object)messageCode, (Object)locale, (Object)nsme.getMessage());
            return messageCode;
        }
    }

    @Nonnull
    public String get(@NonNull EStagePrintBoilerPlate item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return this.get(item, new Object[0]);
    }

    @Nonnull
    public String get(@NonNull EStagePrintBoilerPlate item, Object ... params) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        Locale locale = Locale.GERMAN;
        return this.getForLocale(item, locale, params);
    }

    @Nonnull
    private String getForLocale(@NonNull EStagePrintBoilerPlate item, @NonNull Locale locale, @NonNull Object[] params) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        if (locale == null) {
            throw new NullPointerException("locale is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        String messageCode = item.messageCode();
        try {
            return (String)MoreObjects.firstNonNull((Object)this.messageSourcePrint.getMessage(messageCode, params, locale), (Object)"");
        }
        catch (NoSuchMessageException nsme) {
            log.warn("Message Key not found for Message Code: {} and Locale: {}, returning Original; Error: {}", (Object)messageCode, (Object)locale, (Object)nsme.getMessage());
            return messageCode;
        }
    }

    @Nonnull
    public String get(@NonNull HistoryField item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        Locale locale = LocaleContextHolder.getLocale();
        return this.getForLocale(item, locale, new Object[0]);
    }

    @Nonnull
    public String getDE(@NonNull HistoryField item, Object ... params) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        return this.getForLocale(item, Locale.GERMAN, params);
    }

    @Nonnull
    private String getForLocale(@NonNull HistoryField item, @NonNull Locale locale, @NonNull Object[] params) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        if (locale == null) {
            throw new NullPointerException("locale is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        String messageCode = item.messageCode();
        try {
            return (String)MoreObjects.firstNonNull((Object)this.messageSourceHistory.getMessage(messageCode, params, locale), (Object)"");
        }
        catch (NoSuchMessageException nsme) {
            log.warn("Message Key not found for Message Code: {} and Locale: {}, returning Original; Error: {}", (Object)messageCode, (Object)locale, (Object)nsme.getMessage());
            return messageCode;
        }
    }

    @Nonnull
    public String get(@NonNull IndexField item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        Locale locale = LocaleContextHolder.getLocale();
        return this.getForLocale(item, locale, new Object[0]);
    }

    @Nonnull
    public String get(@NonNull IndexField item, Object ... params) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        Locale locale = LocaleContextHolder.getLocale();
        return this.getForLocale(item, locale, params);
    }

    @Nonnull
    private String getForLocale(@NonNull IndexField item, @NonNull Locale locale, @NonNull Object[] params) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        if (locale == null) {
            throw new NullPointerException("locale is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        String messageCode = item.messageCode();
        try {
            return (String)MoreObjects.firstNonNull((Object)this.messageSourceIndexFields.getMessage(messageCode, params, locale), (Object)"");
        }
        catch (NoSuchMessageException nsme) {
            log.warn("Message Key not found for Message Code: {} and Locale: {}, returning Original; Error: {}", (Object)messageCode, (Object)locale, (Object)nsme.getMessage());
            return messageCode;
        }
    }

    @Nonnull
    public String get(@NonNull EPayrollMonthMessageKeys item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        Locale locale = LocaleContextHolder.getLocale();
        return this.getForLocale(item, locale, new Object[0]);
    }

    @Nonnull
    private String getForLocale(@NonNull EPayrollMonthMessageKeys item, @NonNull Locale locale, @NonNull Object[] params) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        if (locale == null) {
            throw new NullPointerException("locale is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        String messageCode = item.messageCode();
        try {
            return (String)MoreObjects.firstNonNull((Object)this.messageSourcePayrollMonth.getMessage(messageCode, params, locale), (Object)"");
        }
        catch (NoSuchMessageException nsme) {
            log.warn("Message Key not found for Message Code: {} and Locale: {}, returning Original; Error: {}", (Object)messageCode, (Object)locale, (Object)nsme.getMessage());
            return messageCode;
        }
    }
}

