/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import de.qfm.erp.service.configuration.CompanyConfig;
import de.qfm.erp.service.configuration.FileStoreConfig;
import de.qfm.erp.service.model.internal.dms.InvoiceFileStoreBucket;
import de.qfm.erp.service.model.internal.dms.InvoiceFileStoreResult;
import de.qfm.erp.service.model.jpa.invoice.EInvoiceState;
import de.qfm.erp.service.model.jpa.invoice.EInvoiceType;
import de.qfm.erp.service.service.service.FileStoreService;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class LFSFileStoreService
implements FileStoreService {
    private static final Logger log = LogManager.getLogger(LFSFileStoreService.class);
    private static final CharMatcher FILE_NAME = CharMatcher.inRange((char)'a', (char)'z').or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.inRange((char)'0', (char)'9')).or(CharMatcher.anyOf((CharSequence)"_.")).precomputed();
    private static final DateTimeFormatter FILE_NAME_DATE = DateTimeFormatter.ofPattern("yyyyMMdd");
    private final CompanyConfig companyConfig;
    private final FileStoreConfig fileStoreConfig;

    @Nonnull
    public InvoiceFileStoreResult pushSilent(@NonNull InvoiceFileStoreBucket bucket) {
        if (bucket == null) {
            throw new NullPointerException("bucket is marked non-null but is null");
        }
        try {
            return this.push(bucket);
        }
        catch (IOException e) {
            log.error("Error writing LFS File: {}, Error: {}", (Object)bucket, (Object)e.getMessage(), (Object)e);
            return InvoiceFileStoreResult.of((boolean)false, null, (String)"", (String)"", (String)e.getMessage());
        }
    }

    @Nonnull
    public InvoiceFileStoreResult push(@NonNull InvoiceFileStoreBucket bucket) throws IOException {
        if (bucket == null) {
            throw new NullPointerException("bucket is marked non-null but is null");
        }
        log.info("Processing Invoice Bucket: {}", (Object)bucket);
        if (this.fileStoreConfig.isInvoiceFileStoreEnabled()) {
            String fileName = LFSFileStoreService.fileName((InvoiceFileStoreBucket)bucket, (String)"pdf");
            byte[] originalFileContent = bucket.getBuffer();
            Path folderPath = this.fileStoreConfig.getFileStoreInvoicePath();
            if (folderPath.toFile().exists()) {
                Path filePath = Path.of(folderPath.toString(), fileName);
                Path filePathR = Files.write(filePath, originalFileContent, new OpenOption[0]);
                String fullPath = filePath.toString();
                return InvoiceFileStoreResult.of((boolean)true, (LocalDateTime)LocalDateTime.now(), (String)fullPath, (String)fileName, (String)"");
            }
            String msg = String.format("Cannot write File as Folder does not Exist: %s", folderPath);
            log.error(msg);
            return InvoiceFileStoreResult.of((boolean)false, (LocalDateTime)LocalDateTime.now(), (String)"", (String)fileName, (String)msg);
        }
        String msg = "LFS Output NOT enabled";
        log.error("LFS Output NOT enabled");
        return InvoiceFileStoreResult.of((boolean)false, (LocalDateTime)LocalDateTime.now(), (String)"", (String)"", (String)"LFS Output NOT enabled");
    }

    @VisibleForTesting
    static String fileName(@NonNull InvoiceFileStoreBucket bucket, @NonNull String suffix) {
        if (bucket == null) {
            throw new NullPointerException("bucket is marked non-null but is null");
        }
        if (suffix == null) {
            throw new NullPointerException("suffix is marked non-null but is null");
        }
        EInvoiceType invoiceType = bucket.getInvoiceType();
        EInvoiceState invoiceState = bucket.getInvoiceState();
        String creditVoucherInfix = EInvoiceType.CREDIT_VOUCHER == invoiceType ? "GUN_" : "";
        String cancelPrefix = EInvoiceState.CANCELLED == invoiceState ? "Storno_" : "";
        String invoiceNumber = bucket.getInvoiceNumber();
        LocalDate invoiceDate = bucket.getInvoiceDate();
        String fileNameDate = FILE_NAME_DATE.format(invoiceDate);
        String costUnit = bucket.getCostUnit();
        String yearAsString = Integer.toString(invoiceDate.getYear());
        String fileName = StringUtils.trimToEmpty((String)String.format("%s%s%s_%s_%s_%s.%s", cancelPrefix, creditVoucherInfix, invoiceNumber, fileNameDate, costUnit, yearAsString, suffix));
        return FILE_NAME.negate().replaceFrom((CharSequence)fileName, (CharSequence)"_");
    }

    @Autowired
    public LFSFileStoreService(CompanyConfig companyConfig, FileStoreConfig fileStoreConfig) {
        this.companyConfig = companyConfig;
        this.fileStoreConfig = fileStoreConfig;
    }
}

