/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service;

import de.leancoders.common.helper.DateTimeHelper;
import de.qfm.erp.service.configuration.ApplicationConfig;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.history.type.EEntityClass;
import de.qfm.erp.service.model.jpa.navigation.EEntityUsageType;
import de.qfm.erp.service.model.jpa.navigation.EntityUsage;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.service.handler.EntityFactory;
import de.qfm.erp.service.service.handler.EntityUsageHandler;
import de.qfm.erp.service.service.security.UserService;
import de.qfm.erp.service.service.service.EntityUsageService;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.springframework.stereotype.Service;

@Service
public class EntityUsageServiceImpl
implements EntityUsageService {
    private final ApplicationConfig applicationConfig;
    private final UserService userService;
    private final EntityFactory entityFactory;
    private final EntityUsageHandler entityUsageHandler;

    @Nonnull
    public Optional<EntityUsage> entity(@NonNull EEntityClass entityClass, @NonNull Long id, @NonNull EEntityUsageType entityUsageType) {
        if (entityClass == null) {
            throw new NullPointerException("entityClass is marked non-null but is null");
        }
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (entityUsageType == null) {
            throw new NullPointerException("entityUsageType is marked non-null but is null");
        }
        if (this.applicationConfig.isEntityUsageTracking()) {
            User user = this.userService.authenticatedUser();
            this.clean(user, entityClass, id);
            EntityUsage entityUsage = this.entityFactory.entityUsage();
            entityUsage.setEntityClass(entityClass);
            entityUsage.setEntityId(id);
            entityUsage.setEntityUsageType(entityUsageType);
            entityUsage.setUser(user);
            return Optional.of((EntityUsage)this.entityUsageHandler.update((EntityBase)entityUsage));
        }
        return Optional.empty();
    }

    private void clean(@NonNull User user, @NonNull EEntityClass entityClass, @NonNull Long id) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (entityClass == null) {
            throw new NullPointerException("entityClass is marked non-null but is null");
        }
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (this.applicationConfig.isEntityUsageTracking()) {
            int entityUsageTrackingCleanupTTLHours = this.applicationConfig.getEntityUsageTrackingCleanupTTLHours();
            LocalDateTime now = DateTimeHelper.now();
            LocalDateTime nowMinusTTL = now.minus(entityUsageTrackingCleanupTTLHours, ChronoUnit.HOURS);
            this.entityUsageHandler.clean(user, entityClass, id, nowMinusTTL);
        }
    }

    public EntityUsageServiceImpl(ApplicationConfig applicationConfig, UserService userService, EntityFactory entityFactory, EntityUsageHandler entityUsageHandler) {
        this.applicationConfig = applicationConfig;
        this.userService = userService;
        this.entityFactory = entityFactory;
        this.entityUsageHandler = entityUsageHandler;
    }
}

