/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service;

import de.qfm.erp.service.model.jpa.history.type.EEntityClass;
import de.qfm.erp.service.model.jpa.measurement.Measurement;
import de.qfm.erp.service.model.jpa.navigation.EEntityUsageType;
import de.qfm.erp.service.model.jpa.navigation.EntityUsage;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;

public interface EntityUsageService {
    @Nonnull
    default public Optional<EntityUsage> open(@NonNull Measurement measurement) {
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        return this.entity(measurement, EEntityUsageType.OPEN);
    }

    default public Optional<EntityUsage> update(@NonNull Measurement measurement) {
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        return this.entity(measurement, EEntityUsageType.UPDATE);
    }

    @Nonnull
    default public Optional<EntityUsage> open(@NonNull Quotation quotation) {
        if (quotation == null) {
            throw new NullPointerException("quotation is marked non-null but is null");
        }
        return this.entity(quotation, EEntityUsageType.OPEN);
    }

    @Nonnull
    default public Optional<EntityUsage> reference(@NonNull Quotation quotation) {
        if (quotation == null) {
            throw new NullPointerException("quotation is marked non-null but is null");
        }
        return this.entity(quotation, EEntityUsageType.REFERENCE);
    }

    default public Optional<EntityUsage> update(@NonNull Quotation quotation) {
        if (quotation == null) {
            throw new NullPointerException("quotation is marked non-null but is null");
        }
        return this.entity(quotation, EEntityUsageType.UPDATE);
    }

    @Nonnull
    default public Optional<EntityUsage> entity(@NonNull Measurement measurement, @NonNull EEntityUsageType entityUsageType) {
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        if (entityUsageType == null) {
            throw new NullPointerException("entityUsageType is marked non-null but is null");
        }
        return this.entity(EEntityClass.MEASUREMENT, measurement.getId(), entityUsageType);
    }

    @Nonnull
    default public Optional<EntityUsage> entity(@NonNull Quotation quotation, @NonNull EEntityUsageType entityUsageType) {
        if (quotation == null) {
            throw new NullPointerException("quotation is marked non-null but is null");
        }
        if (entityUsageType == null) {
            throw new NullPointerException("entityUsageType is marked non-null but is null");
        }
        return this.entity(EEntityClass.QUOTATION, quotation.getId(), entityUsageType);
    }

    @Nonnull
    public Optional<EntityUsage> entity(@NonNull EEntityClass var1, @NonNull Long var2, @NonNull EEntityUsageType var3);
}

