/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import de.qfm.erp.service.model.internal.dms.InvoiceDMSBucket;
import de.qfm.erp.service.model.internal.dms.InvoiceDMSResult;
import de.qfm.erp.service.model.jpa.invoice.EInvoiceState;
import de.qfm.erp.service.model.jpa.invoice.EInvoiceType;
import de.qfm.erp.service.service.service.DMSService;
import de.qfm.erp.service.service.service.EnaioDMSService;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class EnaioDMSService
implements DMSService {
    private static final Logger log = LogManager.getLogger(EnaioDMSService.class);
    private static final CharMatcher DIGIT = CharMatcher.inRange((char)'0', (char)'9');
    private static final CharMatcher STR = CharMatcher.ascii().or(CharMatcher.anyOf((CharSequence)"\u00e4\u00f6\u00fc\u00df\u00c4\u00d6\u00dc")).and(CharMatcher.anyOf((CharSequence)"\n\r").negate()).and(CharMatcher.isNot((char)';')).and(CharMatcher.isNot((char)'\"')).precomputed();
    private static final CharMatcher DEC = CharMatcher.inRange((char)'0', (char)'9').or(CharMatcher.anyOf((CharSequence)",")).precomputed();
    private static final CharMatcher FILE_NAME = CharMatcher.inRange((char)'a', (char)'z').or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.inRange((char)'0', (char)'9')).or(CharMatcher.anyOf((CharSequence)"_.")).precomputed();
    private static final Joiner META_FILE_ROW_JOINER = Joiner.on((char)';');
    private static final DateTimeFormatter GERMAN_FULL_DATE = DateTimeFormatter.ofPattern("dd.MM.yyyy");
    private static final DateTimeFormatter FILE_NAME_DATE = DateTimeFormatter.ofPattern("yyyyMMdd");
    private static final DecimalFormat NUMBER_FORMAT;

    @Nonnull
    public InvoiceDMSResult pushSilent(@NonNull InvoiceDMSBucket bucket, @NonNull Path folderPath) {
        if (bucket == null) {
            throw new NullPointerException("bucket is marked non-null but is null");
        }
        if (folderPath == null) {
            throw new NullPointerException("folderPath is marked non-null but is null");
        }
        try {
            return this.push(bucket, folderPath);
        }
        catch (IOException e) {
            log.error("Error writing DMS File: {}, Error: {}", (Object)bucket, (Object)e.getMessage(), (Object)e);
            return InvoiceDMSResult.of((boolean)false, null, (String)"", (String)"", (String)e.getMessage());
        }
    }

    @Nonnull
    private InvoiceDMSResult push(@NonNull InvoiceDMSBucket bucket, @NonNull Path folderPath) throws IOException {
        if (bucket == null) {
            throw new NullPointerException("bucket is marked non-null but is null");
        }
        if (folderPath == null) {
            throw new NullPointerException("folderPath is marked non-null but is null");
        }
        log.info("Processing Invoice Bucket: {}", (Object)bucket);
        String fileName = EnaioDMSService.fileName((InvoiceDMSBucket)bucket, (String)"pdf");
        String metaFileName = EnaioDMSService.fileName((InvoiceDMSBucket)bucket, (String)"csv");
        byte[] originalFileContent = bucket.getBuffer();
        String metaFileContent = this.metaFileContent(bucket, fileName);
        if (folderPath.toFile().exists()) {
            Path filePath = Path.of(folderPath.toString(), fileName);
            Path metaFilePath = Path.of(folderPath.toString(), metaFileName);
            Path filePathR = Files.write(filePath, originalFileContent, new OpenOption[0]);
            Path metaPathR = Files.writeString(metaFilePath, (CharSequence)metaFileContent, StandardCharsets.ISO_8859_1, new OpenOption[0]);
            String fullPath = filePath.toString();
            return InvoiceDMSResult.of((boolean)true, (LocalDateTime)LocalDateTime.now(), (String)fullPath, (String)fileName, (String)"");
        }
        String msg = String.format("Cannot write File as Folder does not Exist: %s", folderPath);
        log.error(msg);
        return InvoiceDMSResult.of((boolean)false, (LocalDateTime)LocalDateTime.now(), (String)"", (String)fileName, (String)msg);
    }

    @VisibleForTesting
    static String fileName(@NonNull InvoiceDMSBucket bucket, @NonNull String suffix) {
        if (bucket == null) {
            throw new NullPointerException("bucket is marked non-null but is null");
        }
        if (suffix == null) {
            throw new NullPointerException("suffix is marked non-null but is null");
        }
        EInvoiceType invoiceType = bucket.getInvoiceType();
        EInvoiceState invoiceState = bucket.getInvoiceState();
        String creditVoucherInfix = EInvoiceType.CREDIT_VOUCHER == invoiceType ? "GUN_" : "";
        String cancelPrefix = EInvoiceState.CANCELLED == invoiceState ? "Storno_" : "";
        String invoiceNumber = bucket.getInvoiceNumber();
        LocalDate invoiceDate = bucket.getInvoiceDate();
        String fileNameDate = FILE_NAME_DATE.format(invoiceDate);
        String costUnit = bucket.getCostUnit();
        String yearAsString = Integer.toString(invoiceDate.getYear());
        String fileName = StringUtils.trimToEmpty((String)String.format("%s%s%s_%s_%s_%s.%s", cancelPrefix, creditVoucherInfix, invoiceNumber, fileNameDate, costUnit, yearAsString, suffix));
        return FILE_NAME.negate().replaceFrom((CharSequence)fileName, (CharSequence)"_");
    }

    @Nonnull
    private String metaFileContent(@NonNull InvoiceDMSBucket bucket, @NonNull String fileName) {
        if (bucket == null) {
            throw new NullPointerException("bucket is marked non-null but is null");
        }
        if (fileName == null) {
            throw new NullPointerException("fileName is marked non-null but is null");
        }
        InternalBucket internalBucket = InternalBucket.of((String)fileName, (InvoiceDMSBucket)bucket);
        ImmutableList.Builder partsBuilder = ImmutableList.builder();
        for (META meta : META.values()) {
            int maxLength = meta.getLen();
            CharMatcher charMatcher = meta.getCharMatcher();
            String originalValue = (String)MoreObjects.firstNonNull((Object)((String)meta.getFn().apply(internalBucket)), (Object)meta.getFallback());
            String cleanedValue = charMatcher.retainFrom((CharSequence)originalValue);
            String ensuredLength = StringUtils.left((String)cleanedValue, (int)maxLength);
            partsBuilder.add((Object)ensuredLength);
        }
        ImmutableList parts = partsBuilder.build();
        return META_FILE_ROW_JOINER.join((Iterable)parts);
    }

    static {
        DecimalFormat decimalFormat = new DecimalFormat("#,##0.000");
        decimalFormat.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.GERMAN));
        decimalFormat.setGroupingUsed(false);
        NUMBER_FORMAT = decimalFormat;
    }
}

