/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service;

import de.leancoders.common.helper.DateTimeHelper;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class DateTimeHelperService {
    private static final DateTimeFormatter FILE_ISO_DATE = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).toFormatter();
    private static final DateTimeFormatter FILE_ISO_DATE_TIME = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral('_').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral('-').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral('-').appendValue(ChronoField.SECOND_OF_MINUTE, 2).toFormatter();
    public static final DateTimeFormatter YY = DateTimeFormatter.ofPattern("yy");
    public final ZoneId sourceZoneId;
    public final ZoneId destinationZoneId;
    private static final Locale DE = Locale.forLanguageTag("de");
    private static final DateTimeFormatter FULL_DATE = DateTimeFormatter.ofPattern("dd. MMMM yyyy", DE);
    private static final DateTimeFormatter NORMAL_DATE = DateTimeFormatter.ofPattern("dd.MM.yyyy", DE);
    private static final DateTimeFormatter NORMAL_DATE_TIME = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm:ss", DE);
    private static final DateTimeFormatter MM_DOT_YYYY = DateTimeFormatter.ofPattern("MM.yyyy", DE);

    @Autowired
    public DateTimeHelperService(@Qualifier(value="sourceZoneId") ZoneId sourceZoneId, @Qualifier(value="destinationZoneId") ZoneId destinationZoneId) {
        this.sourceZoneId = sourceZoneId;
        this.destinationZoneId = destinationZoneId;
    }

    @Nonnull
    public LocalDateTime convertToDestination(@NonNull LocalDateTime localDateTime) {
        if (localDateTime == null) {
            throw new NullPointerException("localDateTime is marked non-null but is null");
        }
        ZonedDateTime sourceZonedDateTime = ZonedDateTime.of(localDateTime, this.sourceZoneId);
        ZonedDateTime destinationZonedDateTime = sourceZonedDateTime.withZoneSameInstant(this.destinationZoneId);
        return destinationZonedDateTime.toLocalDateTime();
    }

    @Nullable
    public LocalDateTime convertToUTCNullSafe(@Nullable LocalDateTime localDateTime) {
        return null != localDateTime ? this.convertToUTC(localDateTime) : null;
    }

    @Nonnull
    public LocalDateTime convertToUTC(@NonNull LocalDateTime localDateTime) {
        if (localDateTime == null) {
            throw new NullPointerException("localDateTime is marked non-null but is null");
        }
        ZonedDateTime sourceZonedDateTime = ZonedDateTime.of(localDateTime, this.destinationZoneId);
        ZonedDateTime destinationZonedDateTime = sourceZonedDateTime.withZoneSameInstant(this.sourceZoneId);
        return destinationZonedDateTime.toLocalDateTime();
    }

    @Nonnull
    public String dateForFile() {
        LocalDateTime localDateTime = this.convertToDestination(DateTimeHelper.now());
        return FILE_ISO_DATE.format(localDateTime);
    }

    public String timeStampForFile() {
        LocalDateTime localDateTime = this.convertToDestination(DateTimeHelper.now());
        return FILE_ISO_DATE_TIME.format(localDateTime);
    }

    @Nonnull
    public static String germanFullDate(@NonNull LocalDate date) {
        if (date == null) {
            throw new NullPointerException("date is marked non-null but is null");
        }
        return FULL_DATE.format(date);
    }

    @Nonnull
    public static String germanDate(@NonNull LocalDate date) {
        if (date == null) {
            throw new NullPointerException("date is marked non-null but is null");
        }
        return NORMAL_DATE.format(date);
    }

    @Nonnull
    public static Optional<LocalDate> parseGermanDate(@NonNull String input) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        try {
            return Optional.of(LocalDate.from(NORMAL_DATE.parse(input)));
        }
        catch (DateTimeException dateTimeException) {
            return Optional.empty();
        }
    }

    @Nonnull
    public static String germanDateTime(@NonNull LocalDateTime dateTime) {
        if (dateTime == null) {
            throw new NullPointerException("dateTime is marked non-null but is null");
        }
        return NORMAL_DATE_TIME.format(dateTime);
    }

    @Nonnull
    public static String germanMonthDotYear(@NonNull LocalDate date) {
        if (date == null) {
            throw new NullPointerException("date is marked non-null but is null");
        }
        return MM_DOT_YYYY.format(date);
    }

    @Nonnull
    public static String dateYY() {
        return DateTimeHelper.today().format(YY);
    }
}

