/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service;

import de.qfm.erp.service.configuration.CompanyConfig;
import de.qfm.erp.service.model.jpa.configuration.ConfigurationGeneric;
import de.qfm.erp.service.service.handler.ConfigurationGenericHandler;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConfigService {
    private final CompanyConfig companyConfig;
    private final ConfigurationGenericHandler configurationGenericHandler;
    private Optional<String> stageOrEntityNumberPrefix = Optional.empty();

    @Autowired
    public ConfigService(@Nonnull CompanyConfig companyConfig, @Nonnull ConfigurationGenericHandler configurationGenericHandler) {
        this.companyConfig = companyConfig;
        this.configurationGenericHandler = configurationGenericHandler;
    }

    public void refresh() {
        this.stageOrEntityNumberPrefix = Optional.empty();
    }

    @Nonnull
    public String getStageOrEntityNumberPrefix() {
        if (this.stageOrEntityNumberPrefix.isEmpty()) {
            this.stageOrEntityNumberPrefix = Optional.of(this.readStageOrEntityNumberPrefix());
        }
        return (String)this.stageOrEntityNumberPrefix.get();
    }

    @Nonnull
    private String readStageOrEntityNumberPrefix() {
        return this.configurationGenericHandler.getDefaultNotFailing().map(ConfigurationGeneric::getEntityAndStageNumberPrefix).orElse(this.companyConfig.getContractNumberPrefixDefault());
    }
}

