/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.security.impl;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import de.qfm.erp.service.helper.UserHelper;
import de.qfm.erp.service.model.jpa.user.EPrivilege;
import de.qfm.erp.service.model.jpa.user.Role;
import de.qfm.erp.service.model.jpa.user.RolePrivilege;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.model.jpa.user.UserPrivilege;
import de.qfm.erp.service.service.security.PrivilegeService;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.springframework.stereotype.Service;

@Service
public class PrivilegeServiceImpl
implements PrivilegeService {
    private static final Set<EPrivilege> ALL = ImmutableSet.copyOf((Object[])EPrivilege.values());

    @Nonnull
    public Set<EPrivilege> privileges(@NonNull User user) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        ImmutableSet userPrivileges = ImmutableSet.copyOf((Iterable)this.userPrivileges(user));
        ImmutableSet rolePrivileges = ImmutableSet.copyOf((Iterable)this.rolePrivileges(user));
        if (userPrivileges.contains(EPrivilege.UNRESTRICTED) || rolePrivileges.contains(EPrivilege.UNRESTRICTED)) {
            return ALL;
        }
        return Sets.union((Set)userPrivileges, (Set)rolePrivileges);
    }

    @Nonnull
    public Iterable<EPrivilege> privileges(@NonNull Role role) {
        if (role == null) {
            throw new NullPointerException("role is marked non-null but is null");
        }
        Iterable rolePrivileges = (Iterable)MoreObjects.firstNonNull((Object)role.getRolePrivileges(), (Object)ImmutableList.of());
        return (Iterable)Streams.stream((Iterable)rolePrivileges).map(RolePrivilege::getPrivilege).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
    }

    @Nonnull
    public Iterable<EPrivilege> rolePrivileges(@NonNull User user) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        Iterable allRoles = UserHelper.allRoles((User)user);
        return (Iterable)Streams.stream((Iterable)allRoles).flatMap(item -> Streams.stream((Iterable)this.privileges(item))).collect(ImmutableSet.toImmutableSet());
    }

    @Nonnull
    public Iterable<EPrivilege> userPrivileges(@NonNull User user) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        Iterable userPrivileges = (Iterable)MoreObjects.firstNonNull((Object)user.getUserPrivileges(), (Object)ImmutableSet.of());
        return (Iterable)Streams.stream((Iterable)userPrivileges).map(UserPrivilege::getPrivilege).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
    }
}

