/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.route.impl;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import de.leancoders.common.helper.DateTimeHelper;
import de.qfm.erp.common.request.user.EmployeeContractModificationItem;
import de.qfm.erp.common.request.user.EmployeeContractUpdateItem;
import de.qfm.erp.common.request.user.UserCostCenterUpdateItem;
import de.qfm.erp.common.request.user.UserDisableRequest;
import de.qfm.erp.common.request.user.UserPasswordUpdateRequest;
import de.qfm.erp.common.request.user.UserPrivilegeUpdateItem;
import de.qfm.erp.common.request.user.UserRoleUpdateItem;
import de.qfm.erp.common.request.user.UserUniqueAttributeCheckRequest;
import de.qfm.erp.common.request.user.UserUniqueNameGenerateRequest;
import de.qfm.erp.common.request.user.UserUpdateRequest;
import de.qfm.erp.common.response.user.EmployeeContractListCommon;
import de.qfm.erp.common.response.user.UserBusinessUnitListCommon;
import de.qfm.erp.common.response.user.UserCommon;
import de.qfm.erp.common.response.user.UserPageCommon;
import de.qfm.erp.common.response.user.UserUniqueAttributeCheckResponse;
import de.qfm.erp.common.response.user.UserUniqueNameResponse;
import de.qfm.erp.service.configuration.ApplicationConfig;
import de.qfm.erp.service.model.exception.request.MissingPrivilegeException;
import de.qfm.erp.service.model.exception.request.UpdateRejectException;
import de.qfm.erp.service.model.exception.response.ResourceNotFoundException;
import de.qfm.erp.service.model.internal.MergedBucket;
import de.qfm.erp.service.model.internal.UserGetBucket;
import de.qfm.erp.service.model.internal.UserUpdateBucket;
import de.qfm.erp.service.model.internal.eventbus.UserChangeMessage;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.internal.message.EMessageKey;
import de.qfm.erp.service.model.internal.message.Message;
import de.qfm.erp.service.model.internal.user.EUniqueUserAttribute;
import de.qfm.erp.service.model.internal.user.EmployeeContractUpdateBucket;
import de.qfm.erp.service.model.internal.user.EmployeeContractsUpdateBucket;
import de.qfm.erp.service.model.internal.user.UserCostCenterUpdateBucket;
import de.qfm.erp.service.model.internal.user.UserCostCentersUpdateBucket;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.businessunit.UserCostCenter;
import de.qfm.erp.service.model.jpa.employee.contract.EmployeeContract;
import de.qfm.erp.service.model.jpa.employee.contract.LaborUnionContract;
import de.qfm.erp.service.model.jpa.employee.contract.LaborUnionWageGroup;
import de.qfm.erp.service.model.jpa.employee.payroll.WageAccount;
import de.qfm.erp.service.model.jpa.measurement.type.EMeasurementOrigin;
import de.qfm.erp.service.model.jpa.queue.EReferenceType;
import de.qfm.erp.service.model.jpa.sync.SyncLog;
import de.qfm.erp.service.model.jpa.user.EPrivilege;
import de.qfm.erp.service.model.jpa.user.Role;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.service.calculator.user.UserNameGenerator;
import de.qfm.erp.service.service.handler.EntityFactory;
import de.qfm.erp.service.service.handler.LaborUnionContractHandler;
import de.qfm.erp.service.service.handler.LaborUnionWageGroupHandler;
import de.qfm.erp.service.service.handler.RoleHandler;
import de.qfm.erp.service.service.handler.SyncLogService;
import de.qfm.erp.service.service.handler.UserHandler;
import de.qfm.erp.service.service.mapper.UserMapper;
import de.qfm.erp.service.service.route.UserRoute;
import de.qfm.erp.service.service.route.impl.UserRouteImpl;
import de.qfm.erp.service.service.security.AuthenticationHelper;
import de.qfm.erp.service.service.security.UserService;
import de.qfm.erp.service.service.service.Q1Service;
import de.qfm.erp.service.service.validator.Validators;
import java.io.IOException;
import java.net.http.HttpResponse;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.http.HttpStatus;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserRouteImpl
implements UserRoute {
    private static final Logger log = LogManager.getLogger(UserRouteImpl.class);
    private static final Joiner ID_JOINER = Joiner.on((String)", ").skipNulls();
    private final ApplicationConfig applicationConfig;
    private final AuthenticationHelper authenticationHelper;
    private final PasswordEncoder passwordEncoder;
    private final EntityFactory entityFactory;
    private final ApplicationEventPublisher applicationEventPublisher;
    private final LaborUnionContractHandler laborUnionContractHandler;
    private final LaborUnionWageGroupHandler laborUnionWageGroupHandler;
    private final Q1Service q1Service;
    private final SyncLogService syncLogService;
    private final RoleHandler roleHandler;
    private final UserMapper mapper;
    private final UserHandler handler;
    private final UserService userService;
    private final UserNameGenerator userNameGenerator;
    private final Validators validators;

    @Nonnull
    @Transactional(readOnly=true)
    public UserCommon byId(long userId) {
        return this.mapper.mapUser(this.handler.userGetBucket((User)this.handler.byIdFailing(Long.valueOf(userId))));
    }

    @Nonnull
    @Transactional(readOnly=true)
    public UserCommon byReferenceId(@NonNull String referenceId) {
        if (referenceId == null) {
            throw new NullPointerException("referenceId is marked non-null but is null");
        }
        return this.mapper.mapUser(this.handler.userGetBucket(this.handler.byReferenceIdFailing(referenceId)));
    }

    @Nonnull
    @Transactional(readOnly=true)
    public UserPageCommon page(@NonNull String filterText, int page, int size) {
        if (filterText == null) {
            throw new NullPointerException("filterText is marked non-null but is null");
        }
        Page userPage = this.handler.page(page, size, filterText);
        ImmutableList userGetBuckets = (ImmutableList)userPage.stream().map(arg_0 -> ((UserHandler)this.handler).userGetBucket(arg_0)).collect(ImmutableList.toImmutableList());
        PageImpl userGetBucketPage = new PageImpl((List)userGetBuckets, userPage.getPageable(), userPage.getTotalElements());
        return this.mapper.mapUser((Page)userGetBucketPage);
    }

    @Nonnull
    @Transactional
    public UserCommon create(@NonNull UserUpdateRequest userUpdateRequest) {
        if (userUpdateRequest == null) {
            throw new NullPointerException("userUpdateRequest is marked non-null but is null");
        }
        this.userService.checkPrivilege(EPrivilege.SECURITY_USER_WRITE);
        User user = this.entityFactory.user();
        this.validators.beforeUserUpdate(user, userUpdateRequest).valid().validate();
        return this.mergeAndPersist(userUpdateRequest, user);
    }

    @Nonnull
    @Transactional
    public UserCommon update(long id, @NonNull UserUpdateRequest userUpdateRequest) {
        if (userUpdateRequest == null) {
            throw new NullPointerException("userUpdateRequest is marked non-null but is null");
        }
        this.userService.checkPrivilege(EPrivilege.SECURITY_USER_WRITE);
        User user = (User)this.handler.byIdFailing(Long.valueOf(id));
        this.validators.beforeUserUpdate(user, userUpdateRequest).valid().validate();
        return this.mergeAndPersist(userUpdateRequest, user);
    }

    @Nonnull
    @Transactional(readOnly=true)
    public UserBusinessUnitListCommon userBusinessUnits(long id) {
        User user = (User)this.handler.byIdFailing(Long.valueOf(id));
        Iterable userBusinessUnits = (Iterable)MoreObjects.firstNonNull((Object)user.getUserBusinessUnits(), (Object)ImmutableList.of());
        return this.mapper.mapUserBusinessUnits(userBusinessUnits);
    }

    @Nonnull
    @Transactional(readOnly=true)
    public EmployeeContractListCommon employeeContracts(long id) {
        User user = (User)this.handler.byIdFailing(Long.valueOf(id));
        Iterable employeeContracts = (Iterable)MoreObjects.firstNonNull((Object)user.getEmployeeContracts(), (Object)ImmutableList.of());
        return this.mapper.mapEmployeeContracts(employeeContracts);
    }

    @Nonnull
    @Transactional
    public UserCommon update(long id, @NonNull UserPasswordUpdateRequest updateRequest) {
        boolean userHasPermissionForeign;
        boolean userHasPermissionOwn;
        if (updateRequest == null) {
            throw new NullPointerException("updateRequest is marked non-null but is null");
        }
        String password = updateRequest.getPassword();
        boolean passwordsMatch = Objects.equals(password, updateRequest.getPasswordConfirmation());
        if (!passwordsMatch) {
            throw new UpdateRejectException((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.PASSWORD), (Object)"Password Validation", "The passwords in request do not match", Message.of((EMessageKey)EMessageKey.SECURITY__USER_PASSWORD_CHANGE__DO_NOT_MATCH));
        }
        User userToChangePWD = (User)this.handler.byIdFailing(Long.valueOf(id));
        User user = this.userService.authenticatedUser();
        boolean userIsMe = Objects.equals(userToChangePWD.getId(), user.getId());
        if (userIsMe && !(userHasPermissionOwn = this.userService.hasPrivilege(EPrivilege.SECURITY_CHANGE_OWN_PASSWORD))) {
            throw new MissingPrivilegeException(String.format("Missing Privilege: %s to change password for User: %s", EPrivilege.SECURITY_CHANGE_OWN_PASSWORD, userToChangePWD), Message.of((EMessageKey)EMessageKey.SECURITY__USER_PASSWORD_CHANGE__NOT_ALLOWED), EPrivilege.SECURITY_CHANGE_OWN_PASSWORD);
        }
        if (!userIsMe && !(userHasPermissionForeign = this.userService.hasPrivilege(EPrivilege.SECURITY_CHANGE_FOREIGN_PASSWORD))) {
            throw new MissingPrivilegeException(String.format("Missing Privilege: %s to change password for User: %s", EPrivilege.SECURITY_CHANGE_FOREIGN_PASSWORD, userToChangePWD), Message.of((EMessageKey)EMessageKey.SECURITY__USER_PASSWORD_CHANGE__NOT_ALLOWED), EPrivilege.SECURITY_CHANGE_FOREIGN_PASSWORD);
        }
        String decodePassword = this.authenticationHelper.decodePassword(password);
        String encryptedPassword = this.passwordEncoder.encode((CharSequence)decodePassword);
        userToChangePWD.setPassword(encryptedPassword);
        User userPasswordUpdated = this.updateAndEmitMessage(userToChangePWD);
        UserGetBucket userGetBucket = this.handler.userGetBucket(userPasswordUpdated);
        return this.mapper.mapUser(userGetBucket);
    }

    @Nonnull
    @Transactional(readOnly=true)
    public UserUniqueAttributeCheckResponse uniqueAttributeCheck(@NonNull UserUniqueAttributeCheckRequest request) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        String uniqueUserAttributeString = StringUtils.trimToEmpty((String)request.getAttribute());
        Long id = request.getId();
        String value = request.getValue();
        EUniqueUserAttribute uniqueUserAttribute = EUniqueUserAttribute.lookupFailing((String)uniqueUserAttributeString);
        switch (1.$SwitchMap$de$qfm$erp$service$model$internal$user$EUniqueUserAttribute[uniqueUserAttribute.ordinal()]) {
            case 1: {
                Integer personalNumber = Integer.parseInt(value);
                Optional userWithSamePNr = this.handler.userWithSamePersonalNumber(id, personalNumber);
                return userWithSamePNr.map(user -> UserUniqueAttributeCheckResponse.of((Long)id, (String)uniqueUserAttributeString, (String)value, (boolean)false, (Long)user.getId(), (String)user.getFullName())).orElse(UserUniqueAttributeCheckResponse.of((Long)id, (String)uniqueUserAttributeString, (String)value, (boolean)true, null, null));
            }
            case 2: {
                String userName = StringUtils.trimToEmpty((String)value);
                Optional userWithSameUsername = this.handler.userWithSameUsername(id, userName);
                return userWithSameUsername.map(user -> UserUniqueAttributeCheckResponse.of((Long)id, (String)uniqueUserAttributeString, (String)value, (boolean)false, (Long)user.getId(), (String)user.getFullName())).orElse(UserUniqueAttributeCheckResponse.of((Long)id, (String)uniqueUserAttributeString, (String)value, (boolean)true, null, null));
            }
        }
        return UserUniqueAttributeCheckResponse.of((Long)id, (String)uniqueUserAttributeString, (String)value, (boolean)true, null, null);
    }

    @Nonnull
    @Transactional(readOnly=true)
    public UserUniqueNameResponse generateUserName(@NonNull UserUniqueNameGenerateRequest request) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        Long userId = request.getId();
        String firstName = StringUtils.trimToEmpty((String)request.getFirstName());
        String lastName = StringUtils.trimToEmpty((String)request.getLastName());
        String generatedUserName = this.userNameGenerator.generate(userId, firstName, lastName);
        return UserUniqueNameResponse.of((Long)userId, (String)firstName, (String)lastName, (String)generatedUserName);
    }

    @Transactional
    public boolean pushToQ1(@NonNull Long referenceId) {
        if (referenceId == null) {
            throw new NullPointerException("referenceId is marked non-null but is null");
        }
        User user = (User)this.handler.byIdFailing(referenceId);
        return this.pushToQ1(user);
    }

    @Nonnull
    @Transactional
    public UserCommon disable(@NonNull User user, @NonNull LocalDate referenceDate) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (referenceDate == null) {
            throw new NullPointerException("referenceDate is marked non-null but is null");
        }
        boolean userHasPermissionOwn = this.userService.hasPrivilege(EPrivilege.SECURITY_USER_DISABLE);
        if (!userHasPermissionOwn) {
            String userName = user.getFullName();
            throw new MissingPrivilegeException(String.format("Missing Privilege: %s to disable User: %s", EPrivilege.SECURITY_USER_DISABLE, userName), Message.of((EMessageKey)EMessageKey.SECURITY__USER_PASSWORD_CHANGE__NOT_ALLOWED, (List)ImmutableList.of((Object)EPrivilege.SECURITY_USER_DISABLE, (Object)userName)), EPrivilege.SECURITY_USER_DISABLE);
        }
        User userDisabled = this.internalDisable(user, referenceDate, true);
        UserGetBucket userGetBucket = this.handler.userGetBucket(userDisabled);
        return this.mapper.mapUser(userGetBucket);
    }

    @Nonnull
    private User internalDisable(User user, LocalDate referenceDate, boolean refreshUpdated) {
        Set userCostCenters;
        Set userRoles = (Set)MoreObjects.firstNonNull((Object)user.getUserRoles(), (Object)ImmutableSet.of());
        if (!userRoles.isEmpty()) {
            for (Object userRole : userRoles) {
                userRole.setUser(null);
            }
            userRoles.clear();
        }
        user.setAllowedToLogin(Boolean.valueOf(false));
        Set employeeContracts = (Set)MoreObjects.firstNonNull((Object)user.getEmployeeContracts(), (Object)ImmutableSet.of());
        if (!employeeContracts.isEmpty()) {
            for (EmployeeContract employeeContract : employeeContracts) {
                LocalDate validEnd;
                LocalDate validBegin = employeeContract.getValidBegin();
                if (validBegin.isAfter(referenceDate)) {
                    employeeContract.setValidBegin(referenceDate);
                }
                if (!(validEnd = employeeContract.getValidEnd()).isAfter(referenceDate)) continue;
                employeeContract.setValidEnd(referenceDate);
            }
        }
        if (!(userCostCenters = (Set)MoreObjects.firstNonNull((Object)user.getUserCostCenters(), (Object)ImmutableSet.of())).isEmpty()) {
            for (UserCostCenter userCostCenter : userCostCenters) {
                LocalDate validEnd;
                LocalDate validBegin = userCostCenter.getValidBegin();
                if (validBegin.isAfter(referenceDate)) {
                    userCostCenter.setValidBegin(referenceDate);
                }
                if (!(validEnd = userCostCenter.getValidEnd()).isAfter(referenceDate)) continue;
                userCostCenter.setValidEnd(referenceDate);
            }
        }
        user.setDisableDate(null);
        user.setDisableAtDate(referenceDate);
        return this.updateAndEmitMessage(user, refreshUpdated);
    }

    @Nonnull
    @Transactional
    public UserCommon disable(long id, @NonNull UserDisableRequest userDisableRequest) {
        if (userDisableRequest == null) {
            throw new NullPointerException("userDisableRequest is marked non-null but is null");
        }
        this.userService.checkPrivilege(EPrivilege.SECURITY_USER_WRITE);
        LocalDate disableDate = (LocalDate)MoreObjects.firstNonNull((Object)userDisableRequest.getDisableDate(), (Object)DateTimeHelper.today());
        boolean runImmediate = disableDate.isBefore(DateTimeHelper.today()) || disableDate.isEqual(DateTimeHelper.today());
        User user = (User)this.handler.byIdFailing(Long.valueOf(id));
        if (runImmediate) {
            return this.disable(user, disableDate);
        }
        user.setDisableDate(disableDate);
        User userUpdated = (User)this.handler.update((EntityBase)user);
        UserGetBucket userGetBucket = this.handler.userGetBucket(userUpdated);
        return this.mapper.mapUser(userGetBucket);
    }

    @Transactional
    public boolean disableUsers() {
        LocalDate referenceDate = DateTimeHelper.today();
        Iterable usersToBeDisabled = this.handler.usersWithDisableDateLTE(referenceDate);
        for (User user : usersToBeDisabled) {
            log.info("Disabling User: {}", (Object)user);
            User user2 = this.internalDisable(user, user.getDisableDate(), false);
        }
        return true;
    }

    private boolean pushToQ1(@NonNull User user) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        Long id = user.getId();
        try {
            HttpResponse httpResponse = this.q1Service.push(user);
            String message = StringUtils.trimToEmpty((String)((String)httpResponse.body()));
            SyncLog syncLog = this.syncLogService.log(EMeasurementOrigin.QUANTE_V2, EReferenceType.USER, id, message);
            return HttpStatus.OK.value() == httpResponse.statusCode();
        }
        catch (IOException | InterruptedException | KeyManagementException | NoSuchAlgorithmException e) {
            e.printStackTrace();
            String message = StringUtils.trimToEmpty((String)e.getMessage());
            SyncLog syncLog = this.syncLogService.log(EMeasurementOrigin.QUANTE_V2, EReferenceType.USER, id, message);
            return false;
        }
    }

    @Nonnull
    private UserCommon mergeAndPersist(@NonNull UserUpdateRequest userUpdateRequest, @NonNull User user) {
        if (userUpdateRequest == null) {
            throw new NullPointerException("userUpdateRequest is marked non-null but is null");
        }
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        String safePassword = StringUtils.trimToEmpty((String)userUpdateRequest.getPassword());
        boolean changePassword = StringUtils.isNotBlank((CharSequence)safePassword);
        String decodePassword = this.authenticationHelper.decodePassword(safePassword);
        String encryptedPassword = this.passwordEncoder.encode((CharSequence)decodePassword);
        User existing = this.handler.byNameNotFailing(userUpdateRequest.getUsername()).orElse(null);
        Long roleId = userUpdateRequest.getRoleId();
        Role role = null != roleId ? (Role)this.roleHandler.byIdFailing(roleId) : null;
        Set userRoleUpdateItems = (Set)MoreObjects.firstNonNull((Object)userUpdateRequest.getRoles(), (Object)ImmutableSet.of());
        ImmutableSet userRoleIds = (ImmutableSet)userRoleUpdateItems.stream().map(UserRoleUpdateItem::getId).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
        Iterable userRolesInUpdate = this.roleHandler.byIdsFailing((Iterable)userRoleIds);
        ImmutableSet.Builder userPrivilegesBuilder = ImmutableSet.builder();
        Set userPrivilegeUpdateItems = (Set)MoreObjects.firstNonNull((Object)userUpdateRequest.getUserPrivileges(), (Object)ImmutableSet.of());
        for (UserPrivilegeUpdateItem userPrivilegeUpdateItem : userPrivilegeUpdateItems) {
            String userPrivilegeString = userPrivilegeUpdateItem.getPrivilege();
            EPrivilege privilege = EPrivilege.lookupFailing((String)userPrivilegeString);
            userPrivilegesBuilder.add((Object)privilege);
        }
        ImmutableSet userPrivileges = userPrivilegesBuilder.build();
        List safeUserCostCentersUpdateItems = (List)MoreObjects.firstNonNull((Object)userUpdateRequest.getUserCostCenters(), (Object)ImmutableList.of());
        UserCostCentersUpdateBucket userCostCentersUpdateBucket = this.userUserCostCentersUpdateBucket(user, (Iterable)safeUserCostCentersUpdateItems);
        MergedBucket userCostCentersMerged = this.mapper.mergeUserCostCenters(userCostCentersUpdateBucket);
        Iterable safeEmployeeContractUpdateItems = (Iterable)MoreObjects.firstNonNull((Object)userUpdateRequest.getEmployeeContracts(), (Object)ImmutableList.of());
        EmployeeContractsUpdateBucket employeeContractsUpdateBucket = this.employeeContractUpdateBucket(user, safeEmployeeContractUpdateItems);
        MergedBucket employeeContractsMerged = this.mapper.mergeEmployeeContracts(employeeContractsUpdateBucket);
        Long squadLeaderUserId = userUpdateRequest.getSquadLeaderUserId();
        User squadLeader = null != squadLeaderUserId ? (User)this.handler.byIdFailing(squadLeaderUserId) : null;
        WageAccount wageAccount = (WageAccount)MoreObjects.firstNonNull((Object)user.getWageAccount(), (Object)this.entityFactory.wageAccount(user, this.applicationConfig.getUserWageAccountDefaultLimit()));
        UserUpdateBucket userUpdateBucket = UserUpdateBucket.of((UserUpdateRequest)userUpdateRequest, (User)user, (User)existing, (boolean)changePassword, (String)encryptedPassword, (User)squadLeader, (Role)role, (WageAccount)wageAccount, (Iterable)userRolesInUpdate, (Iterable)userPrivileges);
        User userMerged = this.mapper.merge(userUpdateBucket);
        User userUpdated = this.updateAndEmitMessage(userMerged);
        UserGetBucket userGetBucket = this.handler.userGetBucket(userUpdated);
        return this.mapper.mapUser(userGetBucket);
    }

    @Nonnull
    private User updateAndEmitMessage(@NonNull User user) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        return this.updateAndEmitMessage(user, true);
    }

    @Nonnull
    private User updateAndEmitMessage(@NonNull User user, boolean refreshUpdated) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        User userUpdated = (User)this.handler.update((EntityBase)user, refreshUpdated);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)UserChangeMessage.of((Object)this, (User)userUpdated));
        return userUpdated;
    }

    @Nonnull
    private UserCostCentersUpdateBucket userUserCostCentersUpdateBucket(@NonNull User user, @NonNull Iterable<UserCostCenterUpdateItem> userCostCenterUpdateItems) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (userCostCenterUpdateItems == null) {
            throw new NullPointerException("userCostCenterUpdateItems is marked non-null but is null");
        }
        Iterable safeUpdateItems = (Iterable)MoreObjects.firstNonNull(userCostCenterUpdateItems, (Object)ImmutableList.of());
        ImmutableList sortedCostCenters = ImmutableList.sortedCopyOf((l, r) -> Comparator.reverseOrder().compare(l.getValidBegin(), r.getValidBegin()), (Iterable)safeUpdateItems);
        ImmutableList.Builder userCostCenterUpdateBucketBuilder = ImmutableList.builder();
        LocalDate currentEnd = this.applicationConfig.getDefaultEndDate();
        for (UserCostCenterUpdateItem userCostCenterUpdateItem : sortedCostCenters) {
            LocalDate validBegin = userCostCenterUpdateItem.getValidBegin();
            userCostCenterUpdateBucketBuilder.add((Object)UserCostCenterUpdateBucket.of((Long)userCostCenterUpdateItem.getId(), (UserCostCenterUpdateItem)userCostCenterUpdateItem, (LocalDate)validBegin, (LocalDate)currentEnd));
            currentEnd = validBegin.minusDays(1L);
        }
        ImmutableList userCostCenterUpdateBuckets = userCostCenterUpdateBucketBuilder.build();
        return UserCostCentersUpdateBucket.of((User)user, (Iterable)userCostCenterUpdateBuckets);
    }

    @Nonnull
    private EmployeeContractsUpdateBucket employeeContractUpdateBucket(@NonNull User user, @NonNull Iterable<EmployeeContractUpdateItem> employeeContractUpdateItems) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (employeeContractUpdateItems == null) {
            throw new NullPointerException("employeeContractUpdateItems is marked non-null but is null");
        }
        ImmutableSet requiredLabourUnionContractIds = (ImmutableSet)Streams.stream(employeeContractUpdateItems).map(EmployeeContractModificationItem::getLaborUnionContractId).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
        Iterable laborUnionContractsForIds = this.laborUnionContractHandler.allByIds((Iterable)requiredLabourUnionContractIds);
        Map<Long, LaborUnionContract> laborUnionContractsExistingById = Streams.stream((Iterable)laborUnionContractsForIds).collect(Collectors.toMap(LaborUnionContract::getId, item -> item));
        Set<Long> laborUnionContractIdsExisting = laborUnionContractsExistingById.keySet();
        Sets.SetView laborUnionContractIdsMissing = Sets.difference(laborUnionContractIdsExisting, (Set)requiredLabourUnionContractIds);
        if (!laborUnionContractIdsMissing.isEmpty()) {
            String idsMissingMsg = ID_JOINER.join((Iterable)laborUnionContractIdsMissing);
            throw ResourceNotFoundException.of((String)LaborUnionContract.class.getSimpleName(), (FieldName)FieldNamesFactory.simpleFieldName((EField)EField.ID), (String)idsMissingMsg);
        }
        ImmutableSet requiredLaborUnionWageGroupIds = (ImmutableSet)Streams.stream(employeeContractUpdateItems).map(EmployeeContractModificationItem::getLaborUnionWageGroupId).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
        Iterable laborUnionWageGroupsForIds = this.laborUnionWageGroupHandler.allByIds((Iterable)requiredLaborUnionWageGroupIds);
        Map<Long, LaborUnionWageGroup> laborUnionWageGroupsExistingById = Streams.stream((Iterable)laborUnionWageGroupsForIds).collect(Collectors.toMap(LaborUnionWageGroup::getId, item -> item));
        Set<Long> laborUnionWageGroupIdsExisting = laborUnionWageGroupsExistingById.keySet();
        Sets.SetView laborUnionWageGroupIdsMissing = Sets.difference(laborUnionWageGroupIdsExisting, (Set)requiredLaborUnionWageGroupIds);
        if (!laborUnionWageGroupIdsMissing.isEmpty()) {
            String idsMissingMsg = ID_JOINER.join((Iterable)laborUnionWageGroupIdsMissing);
            throw ResourceNotFoundException.of((String)LaborUnionWageGroup.class.getSimpleName(), (FieldName)FieldNamesFactory.simpleFieldName((EField)EField.ID), (String)idsMissingMsg);
        }
        ImmutableList sortedCostCenters = ImmutableList.sortedCopyOf((l, r) -> Comparator.reverseOrder().compare(l.getValidBegin(), r.getValidBegin()), employeeContractUpdateItems);
        ImmutableList.Builder employeeContractUpdateBucketBuilder = ImmutableList.builder();
        LocalDate currentEnd = this.applicationConfig.getDefaultEndDate();
        for (EmployeeContractUpdateItem employeeContractUpdateItem : sortedCostCenters) {
            Long id = employeeContractUpdateItem.getId();
            Long laborUnionContractId = employeeContractUpdateItem.getLaborUnionContractId();
            LaborUnionContract laborUnionContract = laborUnionContractsExistingById.get(laborUnionContractId);
            if (null == laborUnionContract) {
                throw new UpdateRejectException((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.USER__LABOR_UNION_CONTRACT), (Object)employeeContractUpdateItem, String.format("User Update does not have Labor Union Contract for: %s", employeeContractUpdateItem), Message.of((EMessageKey)EMessageKey.USER_UPDATE__MISSING_LABOR_UNION_CONTRACT, (List)ImmutableList.of()));
            }
            Long laborUnionWageGroupId = employeeContractUpdateItem.getLaborUnionWageGroupId();
            LaborUnionWageGroup laborUnionWageGroup = laborUnionWageGroupsExistingById.get(laborUnionWageGroupId);
            if (null == laborUnionWageGroup) {
                throw new UpdateRejectException((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.USER__LABOR_UNION_WAGE_GROUP), (Object)employeeContractUpdateItem, String.format("User Update does not have Labor Union Wage Group for: %s", employeeContractUpdateItem), Message.of((EMessageKey)EMessageKey.USER_UPDATE__MISSING_LABOR_UNION_WAGE_GROUP, (List)ImmutableList.of()));
            }
            LocalDate validBegin = employeeContractUpdateItem.getValidBegin();
            LocalDate validEnd = currentEnd;
            employeeContractUpdateBucketBuilder.add((Object)EmployeeContractUpdateBucket.of((Long)id, (LaborUnionContract)laborUnionContract, (LaborUnionWageGroup)laborUnionWageGroup, (LocalDate)validBegin, (LocalDate)validEnd, (EmployeeContractModificationItem)employeeContractUpdateItem));
            currentEnd = validBegin.minusDays(1L);
        }
        ImmutableList employeeContractUpdateBuckets = employeeContractUpdateBucketBuilder.build();
        return EmployeeContractsUpdateBucket.of((User)user, (Iterable)laborUnionContractsForIds, (Iterable)laborUnionWageGroupsForIds, (Iterable)employeeContractUpdateBuckets);
    }

    public UserRouteImpl(ApplicationConfig applicationConfig, AuthenticationHelper authenticationHelper, PasswordEncoder passwordEncoder, EntityFactory entityFactory, ApplicationEventPublisher applicationEventPublisher, LaborUnionContractHandler laborUnionContractHandler, LaborUnionWageGroupHandler laborUnionWageGroupHandler, Q1Service q1Service, SyncLogService syncLogService, RoleHandler roleHandler, UserMapper mapper, UserHandler handler, UserService userService, UserNameGenerator userNameGenerator, Validators validators) {
        this.applicationConfig = applicationConfig;
        this.authenticationHelper = authenticationHelper;
        this.passwordEncoder = passwordEncoder;
        this.entityFactory = entityFactory;
        this.applicationEventPublisher = applicationEventPublisher;
        this.laborUnionContractHandler = laborUnionContractHandler;
        this.laborUnionWageGroupHandler = laborUnionWageGroupHandler;
        this.q1Service = q1Service;
        this.syncLogService = syncLogService;
        this.roleHandler = roleHandler;
        this.mapper = mapper;
        this.handler = handler;
        this.userService = userService;
        this.userNameGenerator = userNameGenerator;
        this.validators = validators;
    }
}

