/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.route.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import de.leancoders.common.helper.DateTimeHelper;
import de.leancoders.common.helper.IterableHelper;
import de.leancoders.common.response.reporting.ReportResponse;
import de.qfm.erp.common.request.quotation.QStageStateArchiveUpdateItem;
import de.qfm.erp.common.request.quotation.QStageStateCommissionUpdateItem;
import de.qfm.erp.common.request.quotation.StageAliasUpdateRequest;
import de.qfm.erp.common.request.quotation.StageFulfilmentFilterKVEntry;
import de.qfm.erp.common.request.quotation.StageFulfilmentFilterRequest;
import de.qfm.erp.common.request.quotation.StageInvoiceSupplementUpdateItem;
import de.qfm.erp.common.request.quotation.StagePositionModificationItem;
import de.qfm.erp.common.request.quotation.StagePositionUpdateItem;
import de.qfm.erp.common.request.quotation.StageProjectUpdateRequest;
import de.qfm.erp.common.request.quotation.StageStateUpdateRequest;
import de.qfm.erp.common.request.quotation.StageUpdateRequest;
import de.qfm.erp.common.request.quotation.StageVersionUpdateRequest;
import de.qfm.erp.common.response.StringListResponse;
import de.qfm.erp.common.response.quotation.GaebImportResultListCommon;
import de.qfm.erp.common.response.quotation.QEntityFileCommon;
import de.qfm.erp.common.response.quotation.StageAutoCompleteResponse;
import de.qfm.erp.common.response.quotation.StageBudgetCommon;
import de.qfm.erp.common.response.quotation.StageCommon;
import de.qfm.erp.common.response.quotation.StageFileListCommon;
import de.qfm.erp.common.response.quotation.StageFulfilmentDegreeSimpleCommon;
import de.qfm.erp.common.response.quotation.StageListCommon;
import de.qfm.erp.common.response.quotation.StagePageCommon;
import de.qfm.erp.common.response.quotation.StagePositionCommon;
import de.qfm.erp.common.response.quotation.StagePositionPageCommon;
import de.qfm.erp.common.response.validation.ValidationResultCommon;
import de.qfm.erp.service.configuration.ApplicationConfig;
import de.qfm.erp.service.configuration.CompanyConfig;
import de.qfm.erp.service.configuration.StageConfig;
import de.qfm.erp.service.helper.BigDecimalHelper;
import de.qfm.erp.service.helper.CustomerHelper;
import de.qfm.erp.service.helper.DateRangeHelper;
import de.qfm.erp.service.helper.ER2Helper;
import de.qfm.erp.service.helper.FileHelper;
import de.qfm.erp.service.helper.MapsHelper;
import de.qfm.erp.service.helper.PrintOptionHelper;
import de.qfm.erp.service.helper.QEntityHelper;
import de.qfm.erp.service.helper.QuotationHelper;
import de.qfm.erp.service.helper.StageHelper;
import de.qfm.erp.service.helper.StagePositionHelper;
import de.qfm.erp.service.helper.comparator.quotation.QuotationPositionGroupingLevelComparator;
import de.qfm.erp.service.model.exception.request.BusinessRuleValidationException;
import de.qfm.erp.service.model.exception.request.ConflictException;
import de.qfm.erp.service.model.exception.request.RequestValidationException;
import de.qfm.erp.service.model.exception.request.UpdateRejectException;
import de.qfm.erp.service.model.exception.response.PDFGenerationException;
import de.qfm.erp.service.model.external.gaeb.EGaebType;
import de.qfm.erp.service.model.internal.EYearMonthDateRange;
import de.qfm.erp.service.model.internal.MeasurementMoveBucket;
import de.qfm.erp.service.model.internal.MergedBucket;
import de.qfm.erp.service.model.internal.StageMergeResult;
import de.qfm.erp.service.model.internal.StageSwitchResult;
import de.qfm.erp.service.model.internal.StageVersionResult;
import de.qfm.erp.service.model.internal.WageMoveBucket;
import de.qfm.erp.service.model.internal.dashboard.ReportDateBigDecimal;
import de.qfm.erp.service.model.internal.dashboard.ReportDateBigDecimalBigDecimal;
import de.qfm.erp.service.model.internal.eventbus.QEntityChangeMessage;
import de.qfm.erp.service.model.internal.eventbus.QStageChangeMessage;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.internal.gaeb.GaebExtractResult;
import de.qfm.erp.service.model.internal.gaeb.GaebImportResult;
import de.qfm.erp.service.model.internal.gaeb.GaebPosition;
import de.qfm.erp.service.model.internal.gaeb.GaebX84ExportResult;
import de.qfm.erp.service.model.internal.gaeb.ItemFormat;
import de.qfm.erp.service.model.internal.history.EStageHistoryField;
import de.qfm.erp.service.model.internal.history.StageHistorySnapShot;
import de.qfm.erp.service.model.internal.invoice.EPdfExtractType;
import de.qfm.erp.service.model.internal.measurement.MeasurementDashboard;
import de.qfm.erp.service.model.internal.measurement.MeasurementFilter;
import de.qfm.erp.service.model.internal.message.EMessageKey;
import de.qfm.erp.service.model.internal.message.Message;
import de.qfm.erp.service.model.internal.message.Translatable;
import de.qfm.erp.service.model.internal.payroll.EExportFileName;
import de.qfm.erp.service.model.internal.print.EPrintFontSize;
import de.qfm.erp.service.model.internal.print.qentity.EStagePrintFeature;
import de.qfm.erp.service.model.internal.print.qentity.QStagePrintConfiguration;
import de.qfm.erp.service.model.internal.print.qentity.QStagePrintInfo;
import de.qfm.erp.service.model.internal.quotation.BillOfQuantitiesMeasurementExport;
import de.qfm.erp.service.model.internal.quotation.ECostUnitCEViewMode;
import de.qfm.erp.service.model.internal.quotation.EQStageAutoCompleteMode;
import de.qfm.erp.service.model.internal.quotation.EQuotationHint;
import de.qfm.erp.service.model.internal.quotation.EQuotationPositionSortOption;
import de.qfm.erp.service.model.internal.quotation.EStagePositionSortOption;
import de.qfm.erp.service.model.internal.quotation.EntityCreateBucket;
import de.qfm.erp.service.model.internal.quotation.QStagePositionUpdateBucket;
import de.qfm.erp.service.model.internal.quotation.QStagePositionsUpdateBucket;
import de.qfm.erp.service.model.internal.quotation.QStageStateUpdateBucket;
import de.qfm.erp.service.model.internal.quotation.QuotationBucket;
import de.qfm.erp.service.model.internal.quotation.StageBudget;
import de.qfm.erp.service.model.internal.quotation.StageBudgetResult;
import de.qfm.erp.service.model.internal.quotation.StageER2Bucket;
import de.qfm.erp.service.model.internal.quotation.StageER2Result;
import de.qfm.erp.service.model.internal.quotation.StageIdTypeState;
import de.qfm.erp.service.model.internal.quotation.StageInvoiceSupplementBucket;
import de.qfm.erp.service.model.internal.quotation.StageNotifyBucket;
import de.qfm.erp.service.model.internal.quotation.StageResponsibleBucket;
import de.qfm.erp.service.model.internal.quotation.StageSignatureBucket;
import de.qfm.erp.service.model.internal.quotation.StageTypeAndState;
import de.qfm.erp.service.model.internal.quotation.StageUpdateBucket;
import de.qfm.erp.service.model.internal.reporting.EReportType;
import de.qfm.erp.service.model.internal.validation.ValidationResult;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.configuration.ConfigurationCompany;
import de.qfm.erp.service.model.jpa.customer.Address;
import de.qfm.erp.service.model.jpa.customer.ContactPerson;
import de.qfm.erp.service.model.jpa.customer.Customer;
import de.qfm.erp.service.model.jpa.customer.ECustomerType;
import de.qfm.erp.service.model.jpa.filestore.FileStore;
import de.qfm.erp.service.model.jpa.generic.EBoilerPlateKey;
import de.qfm.erp.service.model.jpa.history.type.EEntityClass;
import de.qfm.erp.service.model.jpa.invoice.EInvoiceType;
import de.qfm.erp.service.model.jpa.invoice.EntityNumber;
import de.qfm.erp.service.model.jpa.invoice.Invoice;
import de.qfm.erp.service.model.jpa.invoice.StageNumber;
import de.qfm.erp.service.model.jpa.invoice.TaxKey;
import de.qfm.erp.service.model.jpa.measurement.Measurement;
import de.qfm.erp.service.model.jpa.measurement.MeasurementPosition;
import de.qfm.erp.service.model.jpa.measurement.ReleaseOrder;
import de.qfm.erp.service.model.jpa.measurement.type.EMeasurementState;
import de.qfm.erp.service.model.jpa.project.Project;
import de.qfm.erp.service.model.jpa.project.SubProject;
import de.qfm.erp.service.model.jpa.quotation.ECommissionType;
import de.qfm.erp.service.model.jpa.quotation.EER2ExportState;
import de.qfm.erp.service.model.jpa.quotation.EInquiryReceiveType;
import de.qfm.erp.service.model.jpa.quotation.EInquiryType;
import de.qfm.erp.service.model.jpa.quotation.EQEntityState;
import de.qfm.erp.service.model.jpa.quotation.EQStageState;
import de.qfm.erp.service.model.jpa.quotation.EQStageType;
import de.qfm.erp.service.model.jpa.quotation.EQuotationSubmissionType;
import de.qfm.erp.service.model.jpa.quotation.EStageOrigin;
import de.qfm.erp.service.model.jpa.quotation.EStagePrintBoilerPlate;
import de.qfm.erp.service.model.jpa.quotation.EStagePropagationItemType;
import de.qfm.erp.service.model.jpa.quotation.QEntity;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.quotation.QuotationBoQ;
import de.qfm.erp.service.model.jpa.quotation.QuotationPosition;
import de.qfm.erp.service.model.jpa.quotation.StageNotifyUser;
import de.qfm.erp.service.model.jpa.quotation.StagePropagation;
import de.qfm.erp.service.model.jpa.quotation.StagePropagationItem;
import de.qfm.erp.service.model.jpa.quotation.StageResponsibleUser;
import de.qfm.erp.service.model.jpa.quotation.StageSignatureUser;
import de.qfm.erp.service.model.jpa.shared.EAlternativePositionType;
import de.qfm.erp.service.model.jpa.shared.EPositionType;
import de.qfm.erp.service.model.jpa.user.EPrivilege;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.service.calculator.quotation.StageCalculators;
import de.qfm.erp.service.service.handler.AddressHandler;
import de.qfm.erp.service.service.handler.BoilerPlateHandler;
import de.qfm.erp.service.service.handler.ConfigurationCompanyHandler;
import de.qfm.erp.service.service.handler.ContactPersonHandler;
import de.qfm.erp.service.service.handler.CustomerHandler;
import de.qfm.erp.service.service.handler.EntityFactory;
import de.qfm.erp.service.service.handler.EntityHandler;
import de.qfm.erp.service.service.handler.FileStoreHandler;
import de.qfm.erp.service.service.handler.InvoiceHandler;
import de.qfm.erp.service.service.handler.MeasurementHandler;
import de.qfm.erp.service.service.handler.PersonAutoCompleteHandler;
import de.qfm.erp.service.service.handler.ProjectHandler;
import de.qfm.erp.service.service.handler.StageHandler;
import de.qfm.erp.service.service.handler.StagePositionHandler;
import de.qfm.erp.service.service.handler.StagePropagationHandler;
import de.qfm.erp.service.service.handler.SubProjectHandler;
import de.qfm.erp.service.service.handler.TaxKeyHandler;
import de.qfm.erp.service.service.handler.UserHandler;
import de.qfm.erp.service.service.history.StageHistoryPreparer;
import de.qfm.erp.service.service.mapper.FileStoreMapper;
import de.qfm.erp.service.service.mapper.QEntityMapper;
import de.qfm.erp.service.service.mapper.QStagePrintMapper;
import de.qfm.erp.service.service.mapper.ReportingMapper;
import de.qfm.erp.service.service.mapper.StageMapper;
import de.qfm.erp.service.service.mapper.StagePositionMapper;
import de.qfm.erp.service.service.mapper.StageUserMapper;
import de.qfm.erp.service.service.mapper.ValidationMapper;
import de.qfm.erp.service.service.route.HistoryItemRoute;
import de.qfm.erp.service.service.route.StageRoute;
import de.qfm.erp.service.service.route.impl.PrintHelper;
import de.qfm.erp.service.service.route.impl.StageRouteImpl;
import de.qfm.erp.service.service.security.UserService;
import de.qfm.erp.service.service.service.DataAggregationService;
import de.qfm.erp.service.service.service.DateTimeHelperService;
import de.qfm.erp.service.service.service.DiamantER2Service;
import de.qfm.erp.service.service.service.MessageService;
import de.qfm.erp.service.service.service.PayrollMonthHelperService;
import de.qfm.erp.service.service.service.QNumberService;
import de.qfm.erp.service.service.service.StageHelperService;
import de.qfm.erp.service.service.service.er2.StageER2CostUnitExportService;
import de.qfm.erp.service.service.service.gaeb.GaebX83ImportService;
import de.qfm.erp.service.service.service.gaeb.GaebX84ExportService;
import de.qfm.erp.service.service.service.gaeb.GaebX84ImportService;
import de.qfm.erp.service.service.service.print.PDFHelperService;
import de.qfm.erp.service.service.service.print.QStageCalculationPrintService;
import de.qfm.erp.service.service.service.print.QStageCostEstimatePrintService;
import de.qfm.erp.service.service.service.print.QStageQuotationPrintService;
import de.qfm.erp.service.service.service.print.QStageWagesPrintService;
import de.qfm.erp.service.service.service.xls.BillOfQuantitiesMeasurementXlsExportService;
import de.qfm.erp.service.service.service.xls.StageXlsExportService;
import de.qfm.erp.service.service.validator.Validators;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.time.Clock;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationListener;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class StageRouteImpl
implements StageRoute,
ApplicationListener<QStageChangeMessage> {
    private static final Logger log = LogManager.getLogger(StageRouteImpl.class);
    private static final Set<String> MALE_TITLES = ImmutableSet.of((Object)"herr");
    private static final Set<String> FEMALE_TITLES = ImmutableSet.of((Object)"frau");
    private final ApplicationEventPublisher applicationEventPublisher;
    private final ApplicationConfig applicationConfig;
    private final StageConfig entityConfig;
    private final EntityFactory entityFactory;
    private final FileStoreMapper fileStoreMapper;
    private final QEntityMapper entityMapper;
    private final StageMapper mapper;
    private final StageUserMapper stageUserMapper;
    private final StagePositionMapper positionMapper;
    private final ReportingMapper reportingMapper;
    private final ValidationMapper validationMapper;
    private final StageHandler stageHandler;
    private final StagePositionHandler stagePositionHandler;
    private final QStagePrintMapper stagePrintMapper;
    private final EntityHandler entityHandler;
    private final DataAggregationService dataAggregationService;
    private final PayrollMonthHelperService payrollMonthHelperService;
    private final PersonAutoCompleteHandler personAutoCompleteHandler;
    private final StageHistoryPreparer stageHistoryPreparer;
    private final HistoryItemRoute historyItemRoute;
    private final AddressHandler addressHandler;
    private final BoilerPlateHandler boilerPlateHandler;
    private final CustomerHandler customerHandler;
    private final ContactPersonHandler contactPersonHandler;
    private final FileStoreHandler fileStoreHandler;
    private final ConfigurationCompanyHandler configurationCompanyHandler;
    private final UserHandler userHandler;
    private final ProjectHandler projectHandler;
    private final SubProjectHandler subProjectHandler;
    private final TaxKeyHandler taxKeyHandler;
    private final MeasurementHandler measurementHandler;
    private final InvoiceHandler invoiceHandler;
    private final StagePropagationHandler stagePropagationHandler;
    private final DateTimeHelperService dateTimeHelperService;
    private final GaebX84ExportService gaebX84ExportService;
    private final StageXlsExportService stageXlsExportService;
    private final GaebX83ImportService gaebX83ImportService;
    private final GaebX84ImportService gaebX84ImportService;
    private final MessageService messageService;
    private final QNumberService qNumberService;
    private final UserService userService;
    private final DiamantER2Service diamantER2Service;
    private final StageER2CostUnitExportService stageEr2CostUnitExportService;
    private final StageCalculators stageCalculators;
    private final Validators validators;
    private final BillOfQuantitiesMeasurementXlsExportService billOfQuantitiesMeasurementXlsExportService;
    private final QStageCostEstimatePrintService costEstimatePrintService;
    private final QStageQuotationPrintService stagePrintService;
    private final QStageCalculationPrintService calculationPrintService;
    private final QStageWagesPrintService wagesPrintService;
    private final PDFHelperService pdfHelperService;
    private final StageHelperService stageHelperService;
    private final CompanyConfig companyConfig;
    private static final Map<Pair<EQStageType, EQStageState>, EQEntityState> MAP = ImmutableMap.builder().put((Object)Pair.of((Object)EQStageType.INQUIRY, (Object)EQStageState.TEMPORARY), (Object)EQEntityState.INQUIRY_TEMPORARY).put((Object)Pair.of((Object)EQStageType.INQUIRY, (Object)EQStageState.ARCHIVED), (Object)EQEntityState.INQUIRY_ARCHIVED).put((Object)Pair.of((Object)EQStageType.INQUIRY, (Object)EQStageState.NOTIFIED), (Object)EQEntityState.INQUIRY_NOTIFIED).put((Object)Pair.of((Object)EQStageType.CALCULATION, (Object)EQStageState.ARCHIVED), (Object)EQEntityState.CALCULATION_ARCHIVED).put((Object)Pair.of((Object)EQStageType.CALCULATION, (Object)EQStageState.TEMPORARY), (Object)EQEntityState.CALCULATION_TEMPORARY).put((Object)Pair.of((Object)EQStageType.QUOTATION, (Object)EQStageState.ARCHIVED), (Object)EQEntityState.QUOTATION_ARCHIVED).put((Object)Pair.of((Object)EQStageType.QUOTATION, (Object)EQStageState.APPROVED), (Object)EQEntityState.QUOTATION_APPROVED).put((Object)Pair.of((Object)EQStageType.QUOTATION, (Object)EQStageState.DESIGNATED_COMMISSION), (Object)EQEntityState.QUOTATION_DESIGNATED_COMMISSION).put((Object)Pair.of((Object)EQStageType.QUOTATION, (Object)EQStageState.SUBMITTED), (Object)EQEntityState.QUOTATION_SUBMITTED).put((Object)Pair.of((Object)EQStageType.QUOTATION, (Object)EQStageState.TEMPORARY), (Object)EQEntityState.QUOTATION_TEMPORARY).put((Object)Pair.of((Object)EQStageType.COMMISSION, (Object)EQStageState.ACTIVE), (Object)EQEntityState.COMMISSION_ACTIVE).put((Object)Pair.of((Object)EQStageType.COMMISSION, (Object)EQStageState.ARCHIVED), (Object)EQEntityState.COMMISSION_ARCHIVED).put((Object)Pair.of((Object)EQStageType.COMMISSION, (Object)EQStageState.TEMPORARY), (Object)EQEntityState.COMMISSION_TEMPORARY).put((Object)Pair.of((Object)EQStageType.COMMISSION, (Object)EQStageState.CLOSED), (Object)EQEntityState.COMMISSION_CLOSED).put((Object)Pair.of((Object)EQStageType.COMMISSION, (Object)EQStageState.REWORK), (Object)EQEntityState.COMMISSION_REWORK).build();
    private static final Set<String> GAEB_FILE_SUFFIXES = ImmutableSet.of((Object)"x83", (Object)"x84", (Object)"gaeb", (Object)"xml");
    private static final Set<String> GAEB_CONTENT_TYPES = ImmutableSet.of((Object)"text/xml", (Object)"application/xhtml+xml", (Object)"application/xml", (Object)"application/octet-stream");
    static final int DIAMANT_PUSH__BATCH_SIZE = 3;

    @Nonnull
    @Transactional(readOnly=true)
    public StageCommon byId(long stageId, boolean includeAllPositions, boolean ignoreVersionFlag, @NonNull String costUnitCEViewModeCandidate, @NonNull String sortOptionsCandidate) {
        Object stages;
        if (costUnitCEViewModeCandidate == null) {
            throw new NullPointerException("costUnitCEViewModeCandidate is marked non-null but is null");
        }
        if (sortOptionsCandidate == null) {
            throw new NullPointerException("sortOptionsCandidate is marked non-null but is null");
        }
        ECostUnitCEViewMode desiredCEViewMode = ECostUnitCEViewMode.lookup((String)costUnitCEViewModeCandidate, (ECostUnitCEViewMode)ECostUnitCEViewMode.COMMISSION);
        ECostUnitCEViewMode costUnitCEViewMode = this.userService.hasPrivilege(EPrivilege.OP_MEASUREMENT_COST_ESTIMATE_VIEW) ? desiredCEViewMode : ECostUnitCEViewMode.COMMISSION;
        EQuotationPositionSortOption sortOption = EQuotationPositionSortOption.lookup((String)sortOptionsCandidate, (EQuotationPositionSortOption)EQuotationPositionSortOption.SEQUENTIAL_NUMBER_ASC);
        Quotation stage = (Quotation)this.stageHandler.byIdFailing(Long.valueOf(stageId));
        QEntity qEntity = stage.getQEntity();
        if (includeAllPositions) {
            Map quotationIterableMap = this.stageHandler.allPositionStages(stage, costUnitCEViewMode, includeAllPositions);
            stages = quotationIterableMap.keySet();
        } else {
            stages = ImmutableSet.of((Object)stage);
        }
        Iterable quotationPositions = (Iterable)Streams.stream((Iterable)stages).flatMap(item -> item.getQuotationPositions().stream()).collect(ImmutableList.toImmutableList());
        Iterable iAddendumDiscounts = this.stageHandler.allStageDiscounts(stage);
        Iterable quotationHints = StageRouteImpl.hints((Quotation)stage, (Iterable)quotationPositions, (boolean)includeAllPositions);
        String absoluteClientHomeFolder = null != qEntity ? StringUtils.trimToEmpty((String)qEntity.getAbsoluteClientHomeFolder()) : "";
        String absoluteServerHomeFolder = null != qEntity ? StringUtils.trimToEmpty((String)qEntity.getAbsoluteServerHomeFolder()) : "";
        return this.mapper.mapToCommon(QuotationBucket.of((ECostUnitCEViewMode)costUnitCEViewMode, (EQuotationPositionSortOption)sortOption, (Quotation)stage, (String)absoluteClientHomeFolder, (String)absoluteServerHomeFolder, (Iterable)iAddendumDiscounts, (Iterable)quotationPositions, (Iterable)quotationHints), includeAllPositions);
    }

    @Transactional(readOnly=true)
    @Nonnull
    public StageBudgetCommon budgetById(long id) {
        Quotation stage = (Quotation)this.stageHandler.byIdFailing(Long.valueOf(id));
        StageBudgetResult stageBudgetResult = this.stageHelperService.budgets(stage);
        Iterable stageBudgets = stageBudgetResult.getStageBudgets();
        Iterable measurementBudgets = stageBudgetResult.getMeasurementBudgets();
        Iterable stageIds = (Iterable)Streams.stream((Iterable)measurementBudgets).map(StageBudget::getStageId).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
        Iterable measurementAccountData = this.measurementHandler.measurementAccountData(stageIds);
        return this.mapper.map(stage, stageBudgets, measurementAccountData);
    }

    @Transactional(readOnly=true)
    @Nonnull
    public StagePageCommon list(int page, int size, @NonNull String filterText, @Nullable Long filterCustomerId, boolean flagIncludeArchived) {
        if (filterText == null) {
            throw new NullPointerException("filterText is marked non-null but is null");
        }
        ImmutableList filterCustomers = null != filterCustomerId ? ImmutableList.of((Object)((Customer)this.customerHandler.byIdFailing(filterCustomerId))) : ImmutableList.of();
        Iterable relevantStates = StageHelper.allStates((boolean)flagIncludeArchived);
        Page stages = this.stageHandler.stages((Iterable)ImmutableList.of(), (Iterable)ImmutableList.of(), (Iterable)ImmutableList.of(), (Iterable)filterCustomers, relevantStates, filterText, (Pageable)PageRequest.of((int)page, (int)size, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"qNumber"}));
        return this.mapper.mapToPage(stages, true);
    }

    @Nonnull
    @VisibleForTesting
    static Iterable<EQuotationHint> hints(@NonNull Quotation quotation, @NonNull Iterable<QuotationPosition> quotationPositions, boolean includeAllPositions) {
        if (quotation == null) {
            throw new NullPointerException("quotation is marked non-null but is null");
        }
        if (quotationPositions == null) {
            throw new NullPointerException("quotationPositions is marked non-null but is null");
        }
        ImmutableSet.Builder quotationHintBuilder = ImmutableSet.builder();
        if (includeAllPositions && Iterables.isEmpty(quotationPositions) && QuotationHelper.isQuotationCommissionNumberPresentAndNeeded((Quotation)quotation)) {
            quotationHintBuilder.add((Object)EQuotationHint.MEASUREMENT_WITHOUT_COMMISSION_NUMBER_NOT_ALLOWED);
        }
        if (QuotationHelper.isQuotationEnded((Quotation)quotation)) {
            quotationHintBuilder.add((Object)EQuotationHint.QUOTATION_ORDER_END);
        }
        LocalDate projectExecutionStartDate = quotation.getProjectExecutionStartDate();
        LocalDate projectExecutionEndDate = quotation.getProjectExecutionEndDate();
        if (null != projectExecutionStartDate && null != projectExecutionEndDate) {
            if (projectExecutionStartDate.isAfter(projectExecutionEndDate)) {
                quotationHintBuilder.add((Object)EQuotationHint.QUOTATION_PROJECT_EXECUTION_INVALID_RANGE);
            } else {
                LocalDate now;
                Range validRange = Range.closed((Comparable)projectExecutionStartDate, (Comparable)projectExecutionEndDate);
                if (!validRange.contains((Comparable)(now = LocalDate.now(Clock.systemUTC())))) {
                    if (now.isBefore(projectExecutionStartDate)) {
                        quotationHintBuilder.add((Object)EQuotationHint.QUOTATION_PROJECT_EXECUTION_NOT_STARTED);
                    } else if (now.isAfter(projectExecutionEndDate)) {
                        quotationHintBuilder.add((Object)EQuotationHint.QUOTATION_PROJECT_EXECUTION_FINISHED);
                    }
                }
            }
        } else {
            quotationHintBuilder.add((Object)EQuotationHint.QUOTATION_PROJECT_EXECUTION_MISSING);
        }
        return quotationHintBuilder.build();
    }

    @Transactional(readOnly=true)
    @Nonnull
    public ValidationResultCommon validateUpdateStateForId(long id, @NonNull String newStateCandidate, int rowVersion) {
        if (newStateCandidate == null) {
            throw new NullPointerException("newStateCandidate is marked non-null but is null");
        }
        Quotation stage = (Quotation)this.stageHandler.byIdFailing(Long.valueOf(id));
        EQStageState qstageStateOld = (EQStageState)MoreObjects.firstNonNull((Object)stage.getStageState(), (Object)EQStageState.UNKNOWN);
        EQStageState qstageStateNew = EQStageState.lookup((String)newStateCandidate, (EQStageState)EQStageState.UNKNOWN);
        StageStateUpdateRequest stateUpdateRequest = new StageStateUpdateRequest();
        stateUpdateRequest.setRowVersion(rowVersion);
        QStageStateUpdateBucket stageStateUpdateBucket = QStageStateUpdateBucket.of((StageStateUpdateRequest)stateUpdateRequest, (Quotation)stage);
        ValidationResult validationResult = this.validateStateSwitch(qstageStateOld, qstageStateNew, stage, stateUpdateRequest, false);
        return this.validationMapper.map(validationResult);
    }

    @Transactional(readOnly=true)
    @Nonnull
    public ValidationResultCommon validateChangeInQuantity(long id, @NonNull StagePositionUpdateItem updateItem) {
        if (updateItem == null) {
            throw new NullPointerException("updateItem is marked non-null but is null");
        }
        Quotation stage = (Quotation)this.stageHandler.byIdFailing(Long.valueOf(id));
        QEntity entity = stage.getQEntity();
        Set stages = (Set)MoreObjects.firstNonNull((Object)entity.getStages(), (Object)ImmutableSet.of());
        ImmutableList positions = ImmutableList.of((Object)updateItem);
        ImmutableList positionUpdateBuckets = (ImmutableList)positions.stream().map((? super T item) -> {
            EPositionType positionType = EPositionType.lookup((String)StringUtils.trimToEmpty((String)item.getPositionType()), (EPositionType)EPositionType.STANDARD);
            EAlternativePositionType alternativePositionType = EAlternativePositionType.lookup((String)StringUtils.trimToEmpty((String)item.getAlternativePositionType()), (EAlternativePositionType)EAlternativePositionType.UNKNOWN);
            return QStagePositionUpdateBucket.of((Long)item.getId(), (EPositionType)positionType, (EPositionType)EPositionType.UNKNOWN, (EAlternativePositionType)alternativePositionType, (StagePositionUpdateItem)item, null, (Iterable)ImmutableSet.of());
        }).collect(ImmutableList.toImmutableList());
        Iterable errors = this.validateChangeInQuantityNotFailing(stage, (Iterable)positionUpdateBuckets, (Iterable)stages);
        ValidationResult validationResult = ValidationResult.from((Iterable)errors);
        return this.validationMapper.map(validationResult);
    }

    @Transactional
    @Nonnull
    public StageCommon updateStateForId(long id, @NonNull String newStateCandidate, @NonNull StageStateUpdateRequest stateUpdateRequest) {
        if (newStateCandidate == null) {
            throw new NullPointerException("newStateCandidate is marked non-null but is null");
        }
        if (stateUpdateRequest == null) {
            throw new NullPointerException("stateUpdateRequest is marked non-null but is null");
        }
        Quotation currentStage = (Quotation)this.stageHandler.byIdFailing(Long.valueOf(id));
        StageHistorySnapShot stageHistorySnapShot = this.historyItemRoute.snapShot(currentStage);
        EQStageType currentStageType = currentStage.getStageType();
        EQStageState stageStateOld = (EQStageState)MoreObjects.firstNonNull((Object)currentStage.getStageState(), (Object)EQStageState.UNKNOWN);
        EQStageState stageStateNew = EQStageState.lookup((String)newStateCandidate, (EQStageState)EQStageState.UNKNOWN);
        boolean flagForceArchive = StageRouteImpl.determineFlagForceArchive((StageStateUpdateRequest)stateUpdateRequest);
        ValidationResult validationResult = this.validateStateSwitch(stageStateOld, stageStateNew, currentStage, stateUpdateRequest, flagForceArchive);
        if (stageStateOld != stageStateNew) {
            if (!validationResult.isSuccess()) {
                String mainMessage = this.messageService.get(EMessageKey.RULE_STAGE_ARCHIVE__VALIDATION_ERROR);
                List messages = (List)Streams.stream((Iterable)validationResult.getMessages()).map((? super T item) -> {
                    String msgText = this.messageService.get(item);
                    return RequestValidationException.Detail.of((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.STAGE_STATE), (Object)stageStateNew, (String)msgText, (Message)item, (List)ImmutableList.of());
                }).collect(ImmutableList.toImmutableList());
                throw new BusinessRuleValidationException(mainMessage, messages);
            }
            ArrayList stagesChanged = Lists.newArrayList();
            ArrayList wageMoveBuckets = Lists.newArrayList();
            ArrayList measurementMoveBuckets = Lists.newArrayList();
            if (stageStateNew == EQStageState.NOTIFIED) {
                if (currentStageType == EQStageType.INQUIRY && stageStateOld == EQStageState.TEMPORARY) {
                    stagesChanged.add(this.switchStateWithoutCopy(currentStage, EQStageState.NOTIFIED));
                }
            } else if (stageStateNew == EQStageState.REWORK) {
                if (currentStageType == EQStageType.COMMISSION && stageStateOld == EQStageState.ACTIVE) {
                    stagesChanged.add(this.switchStateWithoutCopy(currentStage, EQStageState.REWORK));
                } else if (currentStageType == EQStageType.COMMISSION__COST_UNIT && stageStateOld == EQStageState.ACTIVE) {
                    stagesChanged.add(this.switchStateWithoutCopy(currentStage, EQStageState.REWORK));
                } else if (currentStageType == EQStageType.COMMISSION__COST_UNIT__CE && stageStateOld == EQStageState.ACTIVE) {
                    stagesChanged.add(this.switchStateWithoutCopy(currentStage, EQStageState.REWORK));
                }
                if (currentStageType == EQStageType.COMMISSION__ADDENDUM && stageStateOld == EQStageState.ACTIVE) {
                    stagesChanged.add(this.switchStateWithoutCopy(currentStage, EQStageState.REWORK));
                } else if (currentStageType == EQStageType.COST_UNIT__ADDENDUM && stageStateOld == EQStageState.ACTIVE) {
                    stagesChanged.add(this.switchStateWithoutCopy(currentStage, EQStageState.REWORK));
                }
            } else if (stageStateNew == EQStageState.SUBMITTED) {
                if (currentStageType == EQStageType.QUOTATION && stageStateOld == EQStageState.TEMPORARY) {
                    Quotation quotation = this.switchStateWithoutCopy(currentStage, EQStageState.SUBMITTED);
                    stagesChanged.add(quotation);
                    LocalDate submissionOfBidDateNew = (LocalDate)MoreObjects.firstNonNull((Object)quotation.getSubmissionOfBidDate(), (Object)DateTimeHelper.today());
                    quotation.setSubmissionOfBidDate(submissionOfBidDateNew);
                    if (quotation.getFlagMeasurementWithoutCommissionNumberAllowed() == Boolean.TRUE) {
                        this.dirtyER2(quotation);
                    }
                } else if (currentStageType == EQStageType.QUOTATION && stageStateOld == EQStageState.APPROVED) {
                    stagesChanged.add(this.switchStateWithoutCopy(currentStage, EQStageState.SUBMITTED));
                    currentStage.setSubmissionOfBidDate(DateTimeHelper.today());
                } else if (currentStageType == EQStageType.COMMISSION__ADDENDUM && stageStateOld == EQStageState.TEMPORARY) {
                    stagesChanged.add(this.switchStateWithoutCopy(currentStage, EQStageState.SUBMITTED));
                    currentStage.setSubmissionOfBidDate(DateTimeHelper.today());
                } else if (currentStageType == EQStageType.COST_UNIT__ADDENDUM && stageStateOld == EQStageState.TEMPORARY) {
                    stagesChanged.add(this.switchStateWithoutCopy(currentStage, EQStageState.SUBMITTED));
                    currentStage.setSubmissionOfBidDate(DateTimeHelper.today());
                } else if (currentStageType == EQStageType.COMMISSION__COST_ESTIMATE && stageStateOld == EQStageState.TEMPORARY) {
                    stagesChanged.add(this.switchStateWithoutCopy(currentStage, EQStageState.SUBMITTED));
                    currentStage.setSubmissionOfBidDate(DateTimeHelper.today());
                }
            } else if (stageStateNew == EQStageState.APPROVED) {
                if (currentStageType == EQStageType.QUOTATION && stageStateOld == EQStageState.TEMPORARY) {
                    stagesChanged.add(this.switchStateWithoutCopy(currentStage, EQStageState.APPROVED));
                }
            } else if (stageStateNew == EQStageState.ACCEPTED) {
                Quotation costUnit;
                Quotation commission;
                if (currentStageType == EQStageType.COMMISSION && stageStateOld == EQStageState.REWORK) {
                    commission = this.switchStateWithoutCopy(currentStage, EQStageState.ACTIVE);
                    stagesChanged.add(commission);
                    this.dirtyER2(commission);
                } else if (currentStageType == EQStageType.COMMISSION__COST_UNIT && stageStateOld == EQStageState.REWORK) {
                    costUnit = this.switchStateWithoutCopy(currentStage, EQStageState.ACTIVE);
                    stagesChanged.add(costUnit);
                    this.dirtyER2(costUnit);
                } else if (currentStageType == EQStageType.COMMISSION__COST_UNIT__CE && stageStateOld == EQStageState.REWORK) {
                    stagesChanged.add(this.switchStateWithoutCopy(currentStage, EQStageState.ACTIVE));
                }
                if (currentStageType == EQStageType.COMMISSION__ADDENDUM && stageStateOld == EQStageState.REWORK) {
                    stagesChanged.add(this.switchStateWithoutCopy(currentStage, EQStageState.ACTIVE));
                } else if (currentStageType == EQStageType.COST_UNIT__ADDENDUM && stageStateOld == EQStageState.REWORK) {
                    stagesChanged.add(this.switchStateWithoutCopy(currentStage, EQStageState.ACTIVE));
                } else if (currentStageType == EQStageType.INQUIRY && stageStateOld == EQStageState.NOTIFIED) {
                    entity = currentStage.getQEntity();
                    String currentEntityNumberAsString = entity.getQNumber();
                    if (StringUtils.isBlank((CharSequence)currentEntityNumberAsString)) {
                        EntityNumber entityNumber = this.qNumberService.determineNextQNumber();
                        String entityNumberAsString = this.qNumberService.format(entityNumber);
                        entity.setQNumber(entityNumberAsString);
                        entity.setAlias(entityNumberAsString);
                        QEntity qEntity = this.updateAndEmitChangeMessage(entity);
                    }
                    StageSwitchResult switchResult = this.switchStateWithCopy(currentStage, EQStageState.ACTIVE, EQStageType.CALCULATION, EQStageState.TEMPORARY);
                    Quotation inquiry = switchResult.getStageOld();
                    Quotation calculation = switchResult.getStageNew();
                    this.applyCustomerData(calculation);
                    this.renameInquiryFolder(entity);
                    stagesChanged.add(inquiry);
                    stagesChanged.add(calculation);
                } else if (currentStageType == EQStageType.CALCULATION && stageStateOld == EQStageState.TEMPORARY) {
                    switchResult = this.switchStateWithCopy(currentStage, EQStageState.ACTIVE, EQStageType.QUOTATION, EQStageState.TEMPORARY);
                    Quotation calculation = switchResult.getStageOld();
                    Quotation quotation = switchResult.getStageNew();
                    Customer customer = quotation.getCustomer();
                    CustomerHelper.firstActiveQuotationAddress((Customer)customer).ifPresent(arg_0 -> ((Quotation)quotation).setAddress(arg_0));
                    quotation.setFlagPositionGridLocked(Boolean.valueOf(true));
                    stagesChanged.add(calculation);
                    stagesChanged.add(quotation);
                } else if (currentStageType == EQStageType.QUOTATION && stageStateOld == EQStageState.SUBMITTED) {
                    switchResult = this.switchStateWithCopy(currentStage, EQStageState.COMMISSIONED, EQStageType.COMMISSION, EQStageState.ACTIVE);
                    original = switchResult.getStageOld();
                    Quotation commission2 = switchResult.getStageNew();
                    this.applyCommissionRequestData(stateUpdateRequest, commission2);
                    stagesChanged.add(original);
                    stagesChanged.add(commission2);
                    this.dirtyER2(commission2);
                    Map positionMap = switchResult.getPositionMap();
                    Set measurements = (Set)MoreObjects.firstNonNull((Object)original.getMeasurements(), (Object)ImmutableSet.of());
                    Iterator iterator = measurements.iterator();
                    while (iterator.hasNext()) {
                        Measurement measurement = (Measurement)iterator.next();
                        measurementMoveBuckets.add(MeasurementMoveBucket.of((Measurement)measurement, (Quotation)original, (Quotation)commission2, (Map)positionMap));
                    }
                    wageMoveBuckets.add(WageMoveBucket.of((Quotation)original, (Quotation)commission2));
                } else if (currentStageType == EQStageType.QUOTATION && stageStateOld == EQStageState.DESIGNATED_COMMISSION) {
                    switchResult = this.switchStateWithCopy(currentStage, EQStageState.COMMISSIONED, EQStageType.COMMISSION, EQStageState.ACTIVE);
                    original = switchResult.getStageOld();
                    Quotation commission3 = switchResult.getStageNew();
                    this.applyCommissionRequestData(stateUpdateRequest, commission3);
                    stagesChanged.add(original);
                    stagesChanged.add(commission3);
                    this.dirtyER2(commission3);
                } else if (currentStageType == EQStageType.COMMISSION__ADDENDUM && stageStateOld == EQStageState.SUBMITTED) {
                    addendumActive = this.switchStateWithoutCopy(currentStage, EQStageState.ACTIVE);
                    this.applyAddendumCommissionRequestData(stateUpdateRequest, addendumActive);
                    stagesChanged.add(addendumActive);
                } else if (currentStageType == EQStageType.COMMISSION__ADDENDUM && stageStateOld == EQStageState.DESIGNATED_COMMISSION) {
                    addendum = this.switchStateWithoutCopy(currentStage, EQStageState.ACTIVE);
                    this.applyAddendumCommissionRequestData(stateUpdateRequest, addendum);
                    stagesChanged.add(addendum);
                } else if (currentStageType == EQStageType.COST_UNIT__ADDENDUM && stageStateOld == EQStageState.SUBMITTED) {
                    addendumActive = this.switchStateWithoutCopy(currentStage, EQStageState.ACTIVE);
                    this.applyAddendumCommissionRequestData(stateUpdateRequest, addendumActive);
                    stagesChanged.add(addendumActive);
                } else if (currentStageType == EQStageType.COST_UNIT__ADDENDUM && stageStateOld == EQStageState.DESIGNATED_COMMISSION) {
                    addendum = this.switchStateWithoutCopy(currentStage, EQStageState.ACTIVE);
                    this.applyAddendumCommissionRequestData(stateUpdateRequest, addendum);
                    stagesChanged.add(addendum);
                } else if (currentStageType == EQStageType.COMMISSION__COST_ESTIMATE && stageStateOld == EQStageState.SUBMITTED) {
                    Optional costUnitCand = this.stageHandler.costUnitsForCostEstimate(currentStage);
                    if (costUnitCand.isPresent()) {
                        Quotation costUnit2 = (Quotation)costUnitCand.get();
                        Quotation costEstimateCommissioned = this.switchStateWithoutCopy(currentStage, EQStageState.COMMISSIONED);
                        Quotation costUnitActive = this.switchStateWithoutCopy(costUnit2, EQStageState.ACTIVE);
                        this.applyCommissionCERequestData(stateUpdateRequest, costEstimateCommissioned);
                        this.applyCommissionCERequestData(stateUpdateRequest, costUnitActive);
                        stagesChanged.add(costEstimateCommissioned);
                        stagesChanged.add(costUnitActive);
                    }
                } else if (currentStageType == EQStageType.COMMISSION__COST_UNIT && stageStateOld == EQStageState.TEMPORARY) {
                    costUnit = this.switchStateWithoutCopy(currentStage, EQStageState.ACTIVE);
                    stagesChanged.add(costUnit);
                    this.dirtyER2(costUnit);
                } else if (currentStageType == EQStageType.COMMISSION__COST_UNIT__CE && stageStateOld == EQStageState.TEMPORARY) {
                    stagesChanged.add(this.switchStateWithoutCopy(currentStage, EQStageState.ACTIVE));
                } else if (currentStageType == EQStageType.COMMISSION && stageStateOld == EQStageState.TEMPORARY) {
                    commission = this.switchStateWithoutCopy(currentStage, EQStageState.ACTIVE);
                    stagesChanged.add(commission);
                    this.dirtyER2(commission);
                }
            } else if (stageStateNew == EQStageState.DESIGNATED_COMMISSION) {
                if (currentStageType == EQStageType.QUOTATION && stageStateOld == EQStageState.SUBMITTED) {
                    calculation = currentStage.getReference();
                    if (null != calculation && EQStageType.CALCULATION == calculation.getStageType()) {
                        stagesChanged.add(this.switchStateWithoutCopy(calculation, EQStageState.ARCHIVED));
                    }
                    switchResult = this.switchStateWithCopy(currentStage, EQStageState.ARCHIVED, EQStageType.QUOTATION, EQStageState.DESIGNATED_COMMISSION);
                    Quotation original = switchResult.getStageOld();
                    designatedCommission = switchResult.getStageNew();
                    this.applyCommissionRequestData(stateUpdateRequest, designatedCommission);
                    stagesChanged.add(original);
                    stagesChanged.add(designatedCommission);
                } else if (currentStageType == EQStageType.COMMISSION__ADDENDUM && stageStateOld == EQStageState.SUBMITTED) {
                    calculation = currentStage.getReference();
                    if (null != calculation && EQStageType.CALCULATION == calculation.getStageType()) {
                        stagesChanged.add(this.switchStateWithoutCopy(calculation, EQStageState.ARCHIVED));
                    }
                    switchResult = this.switchStateWithCopy(currentStage, EQStageState.ARCHIVED, EQStageType.COMMISSION__ADDENDUM, EQStageState.DESIGNATED_COMMISSION);
                    Quotation original = switchResult.getStageOld();
                    designatedCommission = switchResult.getStageNew();
                    this.applyAddendumCommissionRequestData(stateUpdateRequest, designatedCommission);
                    stagesChanged.add(original);
                    stagesChanged.add(designatedCommission);
                } else if (currentStageType == EQStageType.COST_UNIT__ADDENDUM && stageStateOld == EQStageState.SUBMITTED) {
                    calculation = currentStage.getReference();
                    if (null != calculation && EQStageType.CALCULATION == calculation.getStageType()) {
                        stagesChanged.add(this.switchStateWithoutCopy(calculation, EQStageState.ARCHIVED));
                    }
                    switchResult = this.switchStateWithCopy(currentStage, EQStageState.ARCHIVED, EQStageType.COST_UNIT__ADDENDUM, EQStageState.DESIGNATED_COMMISSION);
                    Quotation original = switchResult.getStageOld();
                    designatedCommission = switchResult.getStageNew();
                    this.applyAddendumCommissionRequestData(stateUpdateRequest, designatedCommission);
                    stagesChanged.add(original);
                    stagesChanged.add(designatedCommission);
                }
            } else if (stageStateNew == EQStageState.ARCHIVED) {
                Optional costUnitOpt;
                entity = currentStage.getQEntity();
                Quotation primaryStage = entity.getPrimaryStage();
                boolean currentStageIsPrimary = Objects.equals(currentStage, primaryStage);
                if (currentStageIsPrimary) {
                    Iterable allStages = (Iterable)MoreObjects.firstNonNull((Object)entity.getStages(), (Object)ImmutableSet.of());
                    for (Quotation stage : allStages) {
                        if (Objects.equals(stage.getId(), currentStage.getId())) continue;
                        stagesChanged.add(this.switchStateWithoutCopy(stage, EQStageState.ARCHIVED));
                    }
                    quotationArchived = this.switchStateWithoutCopy(currentStage, EQStageState.ARCHIVED);
                    stagesChanged.add(quotationArchived);
                    this.applyArchiveRequestData(stateUpdateRequest, (Quotation)quotationArchived);
                } else if (currentStageType == EQStageType.INQUIRY && stageStateOld == EQStageState.NOTIFIED) {
                    stagesChanged.add(this.switchStateWithoutCopy(currentStage, EQStageState.ARCHIVED));
                } else if (currentStageType == EQStageType.CALCULATION && stageStateOld == EQStageState.TEMPORARY) {
                    Quotation stage = this.switchStateWithoutCopy(currentStage, EQStageState.ARCHIVED);
                    stagesChanged.add(stage);
                    this.applyArchiveRequestData(stateUpdateRequest, stage);
                } else if (currentStageType == EQStageType.QUOTATION && (stageStateOld == EQStageState.TEMPORARY || stageStateOld == EQStageState.SUBMITTED)) {
                    Quotation supposedCalculation = currentStage.getReference();
                    if (null != supposedCalculation && supposedCalculation.getStageType() == EQStageType.CALCULATION) {
                        Quotation calculationArchived = this.switchStateWithoutCopy(supposedCalculation, EQStageState.ARCHIVED);
                        stagesChanged.add(calculationArchived);
                        this.applyArchiveRequestData(stateUpdateRequest, calculationArchived);
                    }
                    quotationArchived = this.switchStateWithoutCopy(currentStage, EQStageState.ARCHIVED);
                    stagesChanged.add(quotationArchived);
                    this.applyArchiveRequestData(stateUpdateRequest, (Quotation)quotationArchived);
                } else if (currentStageType == EQStageType.COMMISSION && (stageStateOld == EQStageState.ACTIVE || stageStateOld == EQStageState.CLOSED)) {
                    Set children = this.children(currentStage, true);
                    for (Quotation childStage : children) {
                        stagesChanged.add(this.switchStateWithoutCopy(childStage, EQStageState.ARCHIVED));
                    }
                    stagesChanged.add(this.switchStateWithoutCopy(currentStage, EQStageState.ARCHIVED));
                } else if (currentStageType == EQStageType.COMMISSION__COST_UNIT && (stageStateOld == EQStageState.ACTIVE || stageStateOld == EQStageState.CLOSED)) {
                    stagesChanged.add(this.switchStateWithoutCopy(currentStage, EQStageState.ARCHIVED));
                } else if (currentStageType == EQStageType.COMMISSION__COST_UNIT__CE && (stageStateOld == EQStageState.ACTIVE || stageStateOld == EQStageState.CLOSED)) {
                    stagesChanged.add(this.switchStateWithoutCopy(currentStage, EQStageState.ARCHIVED));
                    Quotation referenceStage = currentStage.getReference();
                    EQStageType referenceStageType = referenceStage.getStageType();
                    if (EQStageType.COMMISSION__COST_ESTIMATE == referenceStageType) {
                        stagesChanged.add(this.switchStateWithoutCopy(referenceStage, EQStageState.ARCHIVED));
                    }
                } else if (currentStageType == EQStageType.COMMISSION__ADDENDUM && stageStateOld == EQStageState.SUBMITTED) {
                    stagesChanged.add(this.switchStateWithoutCopy(currentStage, EQStageState.ARCHIVED));
                } else if (currentStageType == EQStageType.COST_UNIT__ADDENDUM && stageStateOld == EQStageState.SUBMITTED) {
                    stagesChanged.add(this.switchStateWithoutCopy(currentStage, EQStageState.ARCHIVED));
                } else if (currentStageType == EQStageType.COMMISSION__COST_ESTIMATE && stageStateOld == EQStageState.SUBMITTED && (costUnitOpt = this.findCostUnitForCostEstimate(currentStage)).isPresent()) {
                    Quotation costUnit = (Quotation)costUnitOpt.get();
                    stagesChanged.add(this.switchStateWithoutCopy(currentStage, EQStageState.ARCHIVED));
                    stagesChanged.add(this.switchStateWithoutCopy(costUnit, EQStageState.ARCHIVED));
                }
            } else if (stageStateNew == EQStageState.ACTIVE) {
                if (stageStateOld == EQStageState.CLOSED) {
                    stagesChanged.add(this.switchStateWithoutCopy(currentStage, EQStageState.ACTIVE));
                }
            } else if (stageStateNew == EQStageState.CLOSED) {
                this.userService.checkPrivilege(EPrivilege.Q_MODULE__STAGE__STATE__CLOSED);
                if (stageStateOld == EQStageState.ACTIVE) {
                    entity = currentStage.getQEntity();
                    Iterable allStages = (Iterable)MoreObjects.firstNonNull((Object)entity.getStages(), (Object)ImmutableSet.of());
                    Optional<Quotation> otherActiveCommissions = Streams.stream((Iterable)allStages).filter(item -> item.getStageType() == EQStageType.COMMISSION).filter(item -> !Objects.equals(item.getId(), currentStage.getId())).findFirst();
                    Quotation stageWithClosedState = this.switchStateWithoutCopy(currentStage, EQStageState.CLOSED);
                    if (otherActiveCommissions.isEmpty()) {
                        stagesChanged.add(stageWithClosedState);
                    }
                }
            }
            if (!Iterables.isEmpty((Iterable)stagesChanged)) {
                Quotation lastStage = null;
                for (Quotation stage : stagesChanged) {
                    this.validateQNumber(stage).ifPresent(item -> {
                        stage.setQNumber(item);
                        if (Boolean.TRUE != stage.getAliasChanged()) {
                            stage.setAlias(item);
                        }
                    });
                    this.stageCalculators.standard().calculateAndApply(stage);
                    lastStage = this.updateAndEmitChangeMessage(stage);
                }
                Iterable currentStageHI = this.historyItemRoute.persistChanges(stageHistorySnapShot, currentStage);
                if (null != lastStage) {
                    QEntity qEntity = this.refreshQEntity(lastStage);
                }
                for (MeasurementMoveBucket measurementMoveBucket : measurementMoveBuckets) {
                    Measurement measurement = measurementMoveBucket.getMeasurement();
                    Quotation stageNew = measurementMoveBucket.getTargetStage();
                    Map positionMap = measurementMoveBucket.getPositionMap();
                    measurement.setQuotation(stageNew);
                    List measurementPositions = (List)MoreObjects.firstNonNull((Object)measurement.getMeasurementPositions(), (Object)ImmutableList.of());
                    for (MeasurementPosition measurementPosition : measurementPositions) {
                        ReleaseOrder releaseOrder;
                        measurementPosition.setQuotation(stageNew);
                        QuotationPosition qpOld = measurementPosition.getQuotationPosition();
                        QuotationPosition qpNew = (QuotationPosition)positionMap.get(qpOld);
                        measurementPosition.setQuotationPosition(qpNew);
                        QuotationPosition oldJumbo = measurementPosition.getJumboQuotationPosition();
                        if (null == oldJumbo) {
                            Optional jumboPositionNew = StageHelper.determineJumboPosition((QuotationPosition)qpNew);
                            measurementPosition.setJumboQuotationPosition((QuotationPosition)jumboPositionNew.orElse(null));
                            if (jumboPositionNew.isPresent()) {
                                QuotationPosition jumboQuotationPosition = (QuotationPosition)jumboPositionNew.get();
                                measurementPosition.setJumboPositionUnit(jumboQuotationPosition.getUnit());
                                measurementPosition.setJumboPositionSurrogatePositionNumber(jumboQuotationPosition.getSurrogatePositionNumber());
                                measurementPosition.setJumboPositionPricePerUnit(jumboQuotationPosition.getPricePerUnit());
                                measurementPosition.setJumboPositionShortText(jumboQuotationPosition.getShortText());
                            }
                        }
                        if (null == (releaseOrder = measurement.getReleaseOrder())) continue;
                        releaseOrder.setQuotation(stageNew);
                        releaseOrder.setPssReleaseOrder(null);
                    }
                    this.measurementHandler.update((EntityBase)measurement);
                }
                this.payrollMonthHelperService.moveWage((Iterable)wageMoveBuckets);
                return this.mapper.mapToCommon(this.stageBucket(lastStage));
            }
        }
        return this.mapper.mapToCommon(this.stageBucket(currentStage));
    }

    @Nonnull
    private Optional<Quotation> findCostUnitForCostEstimate(@NonNull Quotation stage) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        EQStageType stageType = stage.getStageType();
        if (stageType == EQStageType.COMMISSION__COST_ESTIMATE) {
            return this.stageHandler.costUnitsForCostEstimate(stage);
        }
        return Optional.empty();
    }

    @Nonnull
    private Set<Quotation> children(@NonNull Quotation stage, boolean cascade) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        Set children = (Set)MoreObjects.firstNonNull((Object)stage.getChildren(), (Object)ImmutableSet.of());
        ImmutableSet.Builder allChildrenBuild = ImmutableSet.builder();
        allChildrenBuild.addAll((Iterable)children);
        if (cascade) {
            children.forEach(item -> allChildrenBuild.addAll((Iterable)this.children(item, cascade)));
        }
        return allChildrenBuild.build();
    }

    private static boolean determineFlagForceArchive(StageStateUpdateRequest updateRequest) {
        QStageStateArchiveUpdateItem archive = updateRequest.getArchive();
        return null != archive ? (Boolean)MoreObjects.firstNonNull((Object)archive.getFlagForceArchive(), (Object)false) : false;
    }

    @Nonnull
    private QEntity refreshQEntity(@NonNull Quotation stage) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        QEntity entity = stage.getQEntity();
        if (null == entity.getQEntityState()) {
            entity.setQEntityState(EQEntityState.UNKNOWN);
        }
        if (null == entity.getPrimaryStage()) {
            entity.setPrimaryStage(stage);
        }
        StageRouteImpl.applyPrimaryStage((Quotation)stage, (QEntity)entity, arg_0 -> ((StageHandler)this.stageHandler).byIdFailing(arg_0), (arg_0, arg_1) -> ((StageHandler)this.stageHandler).fetchStageIdTypeState(arg_0, arg_1));
        return this.updateAndEmitChangeMessage(entity);
    }

    @VisibleForTesting
    static boolean applyPrimaryStage(@NonNull Quotation stage, @NonNull QEntity entity, @NonNull com.google.common.base.Function<Long, Quotation> stageByIdFN, @NonNull BiFunction<QEntity, Iterable<EQStageType>, Iterable<StageIdTypeState>> stageIdTypeStateFN) {
        boolean stateIsRework;
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        if (stageByIdFN == null) {
            throw new NullPointerException("stageByIdFN is marked non-null but is null");
        }
        if (stageIdTypeStateFN == null) {
            throw new NullPointerException("stageIdTypeStateFN is marked non-null but is null");
        }
        EQEntityState currentQEntityState = entity.getQEntityState();
        EQStageState stageState = stage.getStageState();
        EQStageType stageType = stage.getStageType();
        Pair key = Pair.of((Object)stageType, (Object)stageState);
        EQEntityState desiredQEntityState = MAP.getOrDefault(key, EQEntityState.UNKNOWN);
        boolean bl = stateIsRework = desiredQEntityState == EQEntityState.COMMISSION_REWORK;
        if (desiredQEntityState != EQEntityState.UNKNOWN) {
            boolean stageSupposedVersioned;
            Quotation currentPrimaryStage = entity.getPrimaryStage();
            Long currentPrimaryStageId = currentPrimaryStage.getId();
            Long currentStageId = stage.getId();
            Integer currentPrimaryStageVersion = (Integer)MoreObjects.firstNonNull((Object)currentPrimaryStage.getVersion(), (Object)0);
            Integer currentStageVersion = (Integer)MoreObjects.firstNonNull((Object)stage.getVersion(), (Object)0);
            boolean currentStageIsPrimary = Objects.equals(currentPrimaryStageId, currentStageId);
            boolean stateIsHigher = desiredQEntityState.higher(currentQEntityState);
            boolean stateIsEqual = desiredQEntityState.equal(currentQEntityState);
            boolean stageIsNewer = currentPrimaryStageId < currentStageId;
            boolean stageGotArchived = stageState == EQStageState.ARCHIVED;
            boolean versionIsHigher = currentPrimaryStageVersion < currentStageVersion;
            boolean bl2 = stageSupposedVersioned = versionIsHigher && stageType == EQStageType.COMMISSION && stageState == EQStageState.TEMPORARY;
            if (stateIsRework && currentStageIsPrimary) {
                entity.setQEntityState(desiredQEntityState);
                return true;
            }
            if (stageIsNewer && stageSupposedVersioned) {
                entity.setPrimaryStage(stage);
                entity.setQEntityState(desiredQEntityState);
                return true;
            }
            if (stageGotArchived && currentStageIsPrimary) {
                Iterable<StageIdTypeState> allStageIdTypeAndStates = stageIdTypeStateFN.apply(entity, (Iterable<EQStageType>)ImmutableSet.of((Object)stageType));
                boolean found = false;
                EQEntityState localDesiredState = EQEntityState.UNKNOWN;
                long localDesiredId = 0L;
                for (StageIdTypeState allStageIdTypeAndState : allStageIdTypeAndStates) {
                    EQStageState localStageState;
                    Long localId = allStageIdTypeAndState.getId();
                    EQStageType localStageType = allStageIdTypeAndState.getStageType();
                    Pair localKey = Pair.of((Object)localStageType, (Object)(localStageState = allStageIdTypeAndState.getStageState()));
                    EQEntityState desiredLocalState = MAP.getOrDefault(localKey, EQEntityState.UNKNOWN);
                    if (desiredLocalState.higher(localDesiredState)) {
                        localDesiredState = desiredLocalState;
                        localDesiredId = localId;
                        found = true;
                        continue;
                    }
                    if (!desiredLocalState.equal(localDesiredState) || localId <= localDesiredId) continue;
                    localDesiredId = localId;
                    found = true;
                }
                if (found) {
                    Quotation primaryStageFallback = (Quotation)stageByIdFN.apply((Object)localDesiredId);
                    entity.setPrimaryStage(primaryStageFallback);
                    entity.setQEntityState(localDesiredState);
                    return true;
                }
                entity.setPrimaryStage(stage);
                entity.setQEntityState(desiredQEntityState);
                return true;
            }
            if (stageIsNewer && stateIsEqual || stateIsHigher) {
                entity.setQEntityState(desiredQEntityState);
                entity.setPrimaryStage(stage);
                return true;
            }
        }
        return false;
    }

    private void applyCustomerData(@NonNull Quotation stage) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        Customer customer = stage.getCustomer();
        if (null != customer) {
            BigDecimal supposedVAT;
            EInvoiceType supposedInvoiceType;
            ECustomerType customerType = (ECustomerType)MoreObjects.firstNonNull((Object)customer.getCustomerType(), (Object)ECustomerType.UNKNOWN);
            if (ECustomerType.INTERNAL == customerType) {
                supposedInvoiceType = EInvoiceType.INTERNAL_INVOICE;
                supposedVAT = BigDecimal.ZERO;
            } else if (ECustomerType.EXTERNAL == customerType) {
                supposedInvoiceType = EInvoiceType.INVOICE;
                supposedVAT = BigDecimal.valueOf(19L);
            } else if (ECustomerType.SUBCONTRACTOR == customerType) {
                supposedInvoiceType = EInvoiceType.CREDIT_VOUCHER;
                supposedVAT = BigDecimal.valueOf(0L);
            } else {
                supposedInvoiceType = EInvoiceType.UNKNOWN;
                supposedVAT = BigDecimal.valueOf(19L);
            }
            Optional taxKey = this.taxKeyHandler.byInvoiceTypeAndVAT(supposedInvoiceType, supposedVAT, customer.getFlagSubContractorAsExternalServiceAccounting().booleanValue(), customer.getFlagCompanyGroup().booleanValue());
            stage.setFinanceDefaultInvoiceType(supposedInvoiceType);
            stage.setVatPercent(supposedVAT);
            stage.setFinanceTaxKey((TaxKey)taxKey.orElse(null));
            stage.setFinanceTaxKeyValue(taxKey.map(TaxKey::getTaxKey).orElse(""));
        }
    }

    private void applyArchiveRequestData(@NonNull StageStateUpdateRequest updateRequest, @NonNull Quotation stage) {
        if (updateRequest == null) {
            throw new NullPointerException("updateRequest is marked non-null but is null");
        }
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        QStageStateArchiveUpdateItem archive = updateRequest.getArchive();
        if (null != archive) {
            String reason = StringUtils.trimToEmpty((String)archive.getReason());
            stage.setArchiveReason(reason);
        }
    }

    private void applyCommissionRequestData(@NonNull StageStateUpdateRequest updateRequest, @NonNull Quotation commission) {
        if (updateRequest == null) {
            throw new NullPointerException("updateRequest is marked non-null but is null");
        }
        if (commission == null) {
            throw new NullPointerException("commission is marked non-null but is null");
        }
        QStageStateCommissionUpdateItem commissionUpdateItem = updateRequest.getCommission();
        if (null != commissionUpdateItem) {
            Long customerIdToValidate;
            Customer customerToValidate;
            boolean changedCustomer;
            String commissionTypeString = commissionUpdateItem.getCommissionType();
            ECommissionType commissionType = ECommissionType.lookup((String)commissionTypeString, (ECommissionType)ECommissionType.UNKNOWN);
            LocalDate commissionDate = commissionUpdateItem.getCommissionDate();
            LocalDate projectExecutionEndDate = commissionUpdateItem.getProjectExecutionEndDate();
            Boolean flagCommissionIdenticalToQuotation = (Boolean)MoreObjects.firstNonNull((Object)commissionUpdateItem.getFlagCommissionIdenticalToQuotation(), (Object)false);
            Boolean flagB2B = (Boolean)MoreObjects.firstNonNull((Object)commissionUpdateItem.getFlagB2B(), (Object)false);
            String orderNumber = StringUtils.trimToEmpty((String)commissionUpdateItem.getOrderNumber());
            BigDecimal orderValue = commissionUpdateItem.getOrderValue();
            BigDecimal orderValueEstimate = commissionUpdateItem.getOrderValueEstimate();
            String orderDescriptionCustomer = StringUtils.trimToEmpty((String)commissionUpdateItem.getOrderDescriptionCustomer());
            List responsibleUserIds = (List)MoreObjects.firstNonNull((Object)commissionUpdateItem.getResponsibleUserIds(), (Object)ImmutableList.of());
            Long projectId = commissionUpdateItem.getProjectId();
            Long customerId = commissionUpdateItem.getCustomerId();
            Long contactPersonId = commissionUpdateItem.getContactPersonId();
            Long addendumNumber = (Long)MoreObjects.firstNonNull((Object)commissionUpdateItem.getAddendumNumber(), (Object)QEntityHelper.determineAvailableAddendumNumber((Quotation)commission));
            commission.setAddendumNumber(addendumNumber);
            commission.setStageStateSince(DateTimeHelper.now());
            commission.setCommissionType(commissionType);
            commission.setCommissionDate(commissionDate);
            commission.setProjectExecutionEndDate(projectExecutionEndDate);
            commission.setOrderNumber(orderNumber);
            commission.setOrderValue(orderValue);
            commission.setOrderValueEstimate(orderValueEstimate);
            commission.setFlagB2B(flagB2B);
            commission.setFlagOrderEqualsQuotation(flagCommissionIdenticalToQuotation);
            commission.setFlagBudgetRelevant(Boolean.valueOf(true));
            commission.setOrderDescriptionCustomer(orderDescriptionCustomer);
            Project project = null != projectId ? (Project)this.projectHandler.byIdFailing(projectId) : null;
            commission.setProject(project);
            Set stageResponsibleUsers = (Set)MoreObjects.firstNonNull((Object)commission.getStageResponsibleUsers(), (Object)ImmutableSet.of());
            for (StageResponsibleUser stageResponsibleUser : stageResponsibleUsers) {
                stageResponsibleUser.setQuotation(null);
            }
            commission.getStageResponsibleUsers().clear();
            Iterable qStageResponsibleBuckets = this.responsibleBuckets(commission, (Iterable)responsibleUserIds);
            MergedBucket stageResponsibleUserMergedBucket = this.stageUserMapper.mergeResponsibleUsers(commission, qStageResponsibleBuckets);
            Customer existingCustomer = commission.getCustomer();
            Long existingCustomerId = null != existingCustomer ? existingCustomer.getId() : null;
            boolean bl = changedCustomer = !Objects.equals(existingCustomerId, customerId);
            if (changedCustomer) {
                Customer customer;
                Customer customer2 = customer = null != customerId ? (Customer)this.customerHandler.byIdFailing(customerId) : null;
                if (null != customer) {
                    commission.setCustomer(customer);
                    Address primaryAddress = CustomerHelper.firstValidPrimaryAddress((Customer)customer).orElse(null);
                    commission.setAddress(primaryAddress);
                }
                customerToValidate = customer;
                customerIdToValidate = customerId;
            } else {
                customerToValidate = existingCustomer;
                customerIdToValidate = existingCustomerId;
            }
            ContactPerson contactPerson = null != contactPersonId ? (ContactPerson)this.contactPersonHandler.byIdFailing(contactPersonId) : null;
            commission.setContactPerson(contactPerson);
            StageRouteImpl.checkContactPersonValidy((Quotation)commission, (Customer)customerToValidate, (Long)customerIdToValidate, (Long)contactPersonId);
        }
    }

    private static void checkContactPersonValidy(Quotation commission, Customer existingCustomer, Long existingCustomerId, Long contactPersonId) {
        ContactPerson contactPersonToCheck = commission.getContactPerson();
        if (null != contactPersonToCheck && null != existingCustomer && contactPersonToCheck.getCustomer() != existingCustomer) {
            Long contactPersonToCheckId = contactPersonToCheck.getId();
            String message = String.format("Stage cannot be commissioned, Customer: %s does not fit to Contact Person: %s", existingCustomerId, contactPersonId);
            Set contactPersons = (Set)MoreObjects.firstNonNull((Object)existingCustomer.getContactPersons(), (Object)ImmutableSet.of());
            ImmutableList contactPersonIds = (ImmutableList)contactPersons.stream().map(ContactPerson::getId).distinct().map((? super T item) -> Long.toString(item)).collect(ImmutableList.toImmutableList());
            throw new ConflictException(message, (List)ImmutableList.of((Object)RequestValidationException.Detail.of((FieldName)FieldNamesFactory.stageContactPerson(), (Object)contactPersonId, (String)message, (Message)Message.of((EMessageKey)EMessageKey.STAGE__CONFLICT__CUSTOMER_AND_CONTACT_PERSON_DO_NOT_MATCH, (List)ImmutableList.of((Object)Long.toString(existingCustomerId), (Object)Long.toString(contactPersonToCheckId))), (List)contactPersonIds)));
        }
    }

    @Nonnull
    private Quotation applyAddendumCommissionRequestData(@NonNull StageStateUpdateRequest updateRequest, @NonNull Quotation stage) {
        if (updateRequest == null) {
            throw new NullPointerException("updateRequest is marked non-null but is null");
        }
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        QStageStateCommissionUpdateItem commissionUpdateItem = updateRequest.getCommission();
        if (null != commissionUpdateItem) {
            LocalDate projectExecutionStartDate = (LocalDate)MoreObjects.firstNonNull((Object)stage.getQuotationProjectExecutionStartDate(), (Object)DateTimeHelper.today());
            LocalDate projectExecutionEndDate = commissionUpdateItem.getProjectExecutionEndDate();
            LocalDate commissionDate = commissionUpdateItem.getCommissionDate();
            Boolean flagCommissionIdenticalToQuotation = (Boolean)MoreObjects.firstNonNull((Object)commissionUpdateItem.getFlagCommissionIdenticalToQuotation(), (Object)false);
            Boolean flagBudgetRelevant = (Boolean)MoreObjects.firstNonNull((Object)commissionUpdateItem.getFlagBudgetRelevant(), (Object)false);
            BigDecimal orderValue = commissionUpdateItem.getOrderValue();
            String orderNumber = StringUtils.trimToEmpty((String)commissionUpdateItem.getOrderNumber());
            String orderDescriptionCustomer = StringUtils.trimToEmpty((String)commissionUpdateItem.getOrderDescriptionCustomer());
            List responsibleUserIds = (List)MoreObjects.firstNonNull((Object)commissionUpdateItem.getResponsibleUserIds(), (Object)ImmutableList.of());
            Long addendumNumber = (Long)MoreObjects.firstNonNull((Object)commissionUpdateItem.getAddendumNumber(), (Object)QEntityHelper.determineAvailableAddendumNumber((Quotation)stage));
            this.validateAddendumNumber(stage, addendumNumber);
            stage.setAddendumNumber(addendumNumber);
            stage.setStageStateSince(DateTimeHelper.now());
            stage.setCommissionDate(commissionDate);
            stage.setProjectExecutionStartDate(projectExecutionStartDate);
            stage.setProjectExecutionEndDate(projectExecutionEndDate);
            stage.setOrderNumber(orderNumber);
            stage.setOrderValue(orderValue);
            stage.setFlagOrderEqualsQuotation(flagCommissionIdenticalToQuotation);
            stage.setFlagBudgetRelevant(flagBudgetRelevant);
            stage.setOrderDescriptionCustomer(orderDescriptionCustomer);
            Set stageResponsibleUsers = (Set)MoreObjects.firstNonNull((Object)stage.getStageResponsibleUsers(), (Object)ImmutableSet.of());
            for (StageResponsibleUser stageResponsibleUser : stageResponsibleUsers) {
                stageResponsibleUser.setQuotation(null);
            }
            stage.getStageResponsibleUsers().clear();
            Iterable qStageResponsibleBuckets = this.responsibleBuckets(stage, (Iterable)responsibleUserIds);
            MergedBucket mergedBucket = this.stageUserMapper.mergeResponsibleUsers(stage, qStageResponsibleBuckets);
        }
        return stage;
    }

    @Nonnull
    private Quotation applyCommissionCERequestData(@NonNull StageStateUpdateRequest updateRequest, @NonNull Quotation stage) {
        if (updateRequest == null) {
            throw new NullPointerException("updateRequest is marked non-null but is null");
        }
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        QStageStateCommissionUpdateItem commissionUpdateItem = updateRequest.getCommission();
        if (null != commissionUpdateItem) {
            LocalDate commissionDate = commissionUpdateItem.getCommissionDate();
            String orderDescriptionCustomer = StringUtils.trimToEmpty((String)commissionUpdateItem.getOrderDescriptionCustomer());
            String orderNumber = StringUtils.trimToEmpty((String)commissionUpdateItem.getOrderNumber());
            BigDecimal orderValue = commissionUpdateItem.getOrderValue();
            LocalDate projectExecutionEndDate = commissionUpdateItem.getProjectExecutionEndDate();
            Long contactPersonId = commissionUpdateItem.getContactPersonId();
            List responsibleUserIds = (List)MoreObjects.firstNonNull((Object)commissionUpdateItem.getResponsibleUserIds(), (Object)ImmutableList.of());
            stage.setStageStateSince(DateTimeHelper.now());
            stage.setCommissionDate(commissionDate);
            stage.setProjectExecutionEndDate(projectExecutionEndDate);
            stage.setOrderNumber(orderNumber);
            stage.setOrderValue(orderValue);
            stage.setOrderDescriptionCustomer(orderDescriptionCustomer);
            Set stageResponsibleUsers = (Set)MoreObjects.firstNonNull((Object)stage.getStageResponsibleUsers(), (Object)ImmutableSet.of());
            for (StageResponsibleUser stageResponsibleUser : stageResponsibleUsers) {
                stageResponsibleUser.setQuotation(null);
            }
            stage.getStageResponsibleUsers().clear();
            Iterable qStageResponsibleBuckets = this.responsibleBuckets(stage, (Iterable)responsibleUserIds);
            MergedBucket stageResponsibleUserMergedBucket = this.stageUserMapper.mergeResponsibleUsers(stage, qStageResponsibleBuckets);
            ContactPerson contactPerson = null != contactPersonId ? (ContactPerson)this.contactPersonHandler.byIdFailing(contactPersonId) : null;
            stage.setContactPerson(contactPerson);
        }
        return stage;
    }

    @Nonnull
    private StageSwitchResult switchStateWithCopy(@NonNull Quotation stageCurrent, @NonNull EQStageState currentStageState, @NonNull EQStageType stageTypeNew, @NonNull EQStageState newStateState) {
        if (stageCurrent == null) {
            throw new NullPointerException("stageCurrent is marked non-null but is null");
        }
        if (currentStageState == null) {
            throw new NullPointerException("currentStageState is marked non-null but is null");
        }
        if (stageTypeNew == null) {
            throw new NullPointerException("stageTypeNew is marked non-null but is null");
        }
        if (newStateState == null) {
            throw new NullPointerException("newStateState is marked non-null but is null");
        }
        this.switchStateWithoutCopy(stageCurrent, currentStageState);
        boolean resetAddendumNumber = EQStageType.COMMISSION__ADDENDUM == stageTypeNew || EQStageType.COST_UNIT__ADDENDUM == stageTypeNew;
        Quotation stageNew = this.entityFactory.stage();
        EStageOrigin supposedOrigin = (EStageOrigin)MoreObjects.firstNonNull((Object)stageCurrent.getOrigin(), (Object)stageNew.getOrigin());
        stageNew.setOrigin(supposedOrigin);
        StageMergeResult stageMergeResult = this.mapper.mergeInto(stageCurrent, stageNew, stageTypeNew, true, resetAddendumNumber);
        Quotation stageMerged = stageMergeResult.getStage();
        Map positionMap = stageMergeResult.getPositionMap();
        stageMerged.setStageType(stageTypeNew);
        this.switchStateWithoutCopy(stageMerged, newStateState);
        this.stageCalculators.standard().calculateAndApply(stageNew);
        return StageSwitchResult.of((Quotation)stageCurrent, (Quotation)stageNew, (Map)positionMap);
    }

    @Nonnull
    private Quotation switchStateWithoutCopy(@NonNull Quotation stage, @NonNull EQStageState newStateState) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        if (newStateState == null) {
            throw new NullPointerException("newStateState is marked non-null but is null");
        }
        stage.setStageState(newStateState);
        stage.setStageStateSince(DateTimeHelper.now());
        return stage;
    }

    @Nonnull
    private Quotation dirtyER2(@NonNull Quotation stage) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        stage.setEr2ExportState(EER2ExportState.NOT_EXPORTED);
        stage.setEr2ExportedToPath("");
        stage.setEr2ExportedOn(null);
        return stage;
    }

    @Nonnull
    private Optional<String> validateQNumber(@NonNull Quotation stage) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        EQStageType stageType = stage.getStageType();
        EQStageState stageState = stage.getStageState();
        String stageNumberString = stage.getQNumber();
        if (StringUtils.isBlank((CharSequence)stageNumberString)) {
            boolean costEstimate;
            boolean isInquiryTemporary = stageType == EQStageType.INQUIRY && stageState == EQStageState.TEMPORARY;
            boolean isInquiryActive = stageType == EQStageType.INQUIRY && stageState == EQStageState.ACTIVE;
            boolean isCalculationTemporary = stageType == EQStageType.CALCULATION && stageState == EQStageState.TEMPORARY;
            boolean isQuotation = stageType == EQStageType.QUOTATION;
            boolean commission = stageType == EQStageType.COMMISSION;
            boolean addendum = Iterables.contains((Iterable)EQStageType.ADDENDUM_TYPES, (Object)stageType);
            boolean costUnit = Iterables.contains((Iterable)EQStageType.COST_UNIT_TYPES, (Object)stageType);
            boolean bl = costEstimate = stageType == EQStageType.COMMISSION__COST_ESTIMATE;
            if (isInquiryTemporary || isInquiryActive) {
                QEntity qEntity = stage.getQEntity();
                String qNumberString = qEntity.getQNumber();
                return Optional.of(qNumberString);
            }
            if (isCalculationTemporary || isQuotation || costUnit || addendum || commission || costEstimate) {
                QEntity qEntity = stage.getQEntity();
                String qNumberString = qEntity.getQNumber();
                StageNumber stageNumber = this.qNumberService.determineNextQNumber(qNumberString, stageType);
                String entityNumber = QNumberService.format((StageNumber)stageNumber);
                return Optional.of(entityNumber);
            }
        }
        return Optional.empty();
    }

    @Transactional
    @Nonnull
    public StageCommon createStageByStageId(long id, @NonNull String newStageCandidate, boolean flagCopyPositions) {
        boolean resetAddendumNumber;
        EQStageType stageTypeNew;
        if (newStageCandidate == null) {
            throw new NullPointerException("newStageCandidate is marked non-null but is null");
        }
        Quotation stageCurrent = (Quotation)this.stageHandler.byIdFailing(Long.valueOf(id));
        QEntity entity = stageCurrent.getQEntity();
        Quotation primaryStage = entity.getPrimaryStage();
        EQStageType stageTypeOld = stageCurrent.getStageType();
        boolean stageSwitch = stageTypeOld != (stageTypeNew = EQStageType.lookup((String)newStageCandidate, (EQStageType)EQStageType.UNKNOWN));
        boolean stageCopy = EQStageType.STAGE_COPY_ALLOWED_TYPES.contains((Object)stageTypeOld);
        boolean stageCopyPositions = flagCopyPositions && EQStageType.STAGE_COPY_POSITION_TYPES.contains((Object)stageTypeOld);
        boolean bl = resetAddendumNumber = EQStageType.COMMISSION__ADDENDUM == stageTypeNew || EQStageType.COST_UNIT__ADDENDUM == stageTypeNew;
        if (stageSwitch || stageCopy) {
            Quotation createdStage = this.createStage(stageCurrent, stageTypeNew, stageCopyPositions, resetAddendumNumber);
            this.validateQNumber(createdStage).ifPresent(item -> {
                createdStage.setQNumber(item);
                if (Boolean.TRUE != createdStage.getAliasChanged()) {
                    createdStage.setAlias(item);
                }
                Map boilerPlates = this.boilerPlateHandler.byKeysAsMap((Iterable)ImmutableSet.copyOf((Object[])EBoilerPlateKey.values()));
                this.validateOrInitCoverLetter(createdStage, primaryStage, boilerPlates);
            });
            StageHelper.ensureQuotationNumber((Quotation)createdStage);
            Quotation createdStageUpdated = this.updateAndEmitChangeMessage(createdStage);
            this.historyItemRoute.persistChanges(createdStageUpdated);
            QEntity entityRefreshed = this.refreshQEntity(createdStageUpdated);
            this.createCostUnitFolder(createdStageUpdated);
            if (EQStageType.COMMISSION__COST_ESTIMATE == stageTypeNew) {
                Quotation createdSecondaryStage = this.createStage(createdStageUpdated, EQStageType.COMMISSION__COST_UNIT__CE, false, false);
                createdSecondaryStage.setStageState(EQStageState.DESIGNATED_COST_UNIT);
                createdSecondaryStage.setStageStateSince(DateTimeHelper.now());
                createdSecondaryStage.setQNumber(createdStageUpdated.getQNumber());
                createdSecondaryStage.setAlias(createdStageUpdated.getAlias());
                createdSecondaryStage.setAliasChanged(createdStageUpdated.getAliasChanged());
                createdSecondaryStage.setQuotationNumber(createdStageUpdated.getQuotationNumber());
                Quotation createdSecondaryStageUpdated = this.updateAndEmitChangeMessage(createdSecondaryStage);
                this.historyItemRoute.persistChanges(createdSecondaryStageUpdated);
            }
            return this.mapper.mapToCommon(this.stageBucket(createdStageUpdated));
        }
        return this.mapper.mapToCommon(this.stageBucket(stageCurrent));
    }

    @Nonnull
    private Quotation createStage(@NonNull Quotation stageCurrent, @NonNull EQStageType stageTypeNew, boolean stageCopyPositions, boolean resetAddendumNumber) {
        if (stageCurrent == null) {
            throw new NullPointerException("stageCurrent is marked non-null but is null");
        }
        if (stageTypeNew == null) {
            throw new NullPointerException("stageTypeNew is marked non-null but is null");
        }
        Quotation stageNew = this.entityFactory.stage();
        StageMergeResult stageMergeResult = this.mapper.mergeInto(stageCurrent, stageNew, stageTypeNew, stageCopyPositions, resetAddendumNumber);
        Quotation stageMerged = stageMergeResult.getStage();
        Quotation stagePostProcessed = this.postProcessMerge(stageCurrent, stageMerged, stageTypeNew);
        this.stageCalculators.standard().calculateAndApply(stagePostProcessed);
        return stagePostProcessed;
    }

    @Transactional(readOnly=true)
    public StageListCommon versionStagesByStageId(@NonNull Long stageId) {
        if (stageId == null) {
            throw new NullPointerException("stageId is marked non-null but is null");
        }
        Quotation stage = (Quotation)this.stageHandler.byIdFailing(stageId);
        Set children = (Set)((Set)MoreObjects.firstNonNull((Object)stage.getChildren(), (Object)ImmutableSet.of())).stream().filter(item -> Iterables.contains((Iterable)EQStageType.VERSIONABLE_CHILDS, (Object)item.getStageType())).filter(item -> Iterables.contains((Iterable)EQStageState.VERSIONABLE_CHILD_STATES, (Object)item.getStageState())).collect(ImmutableSet.toImmutableSet());
        return this.mapper.mapToList((Iterable)children, false);
    }

    @Transactional
    @Nonnull
    public StageCommon createVersionByStageId(long id, @NonNull StageVersionUpdateRequest stageVersionUpdateRequest) {
        if (stageVersionUpdateRequest == null) {
            throw new NullPointerException("stageVersionUpdateRequest is marked non-null but is null");
        }
        Boolean flagCrossVersionOrderValue = (Boolean)MoreObjects.firstNonNull((Object)stageVersionUpdateRequest.getFlagCrossVersionOrderValue(), (Object)Boolean.FALSE);
        LocalDate gracePeriod = (LocalDate)MoreObjects.firstNonNull((Object)stageVersionUpdateRequest.getGracePeriodDate(), (Object)DateTimeHelper.today());
        Quotation stageCurrent = (Quotation)this.stageHandler.byIdFailing(Long.valueOf(id));
        EQStageType stageTypeCurrent = stageCurrent.getStageType();
        boolean versionPossible = Iterables.contains((Iterable)EQStageType.VERSIONABLE, (Object)stageTypeCurrent);
        if (versionPossible) {
            QEntity entity = stageCurrent.getQEntity();
            Iterable all = (Iterable)MoreObjects.firstNonNull((Object)entity.getStages(), (Object)ImmutableSet.of());
            Map allById = (Map)Streams.stream((Iterable)all).collect(ImmutableMap.toImmutableMap(Quotation::getId, item -> item));
            Integer currentVersion = this.stageHandler.maxVersion(entity.getId()).orElse(0);
            StageVersionResult stageVersionResult = this.createVersion(stageCurrent, currentVersion, gracePeriod, flagCrossVersionOrderValue);
            Quotation stageVersioned = stageVersionResult.getStageVersioned();
            Map stageVersionedPositionMap = stageVersionResult.getPositionMap();
            Quotation stageCurrentUpdated = this.updateAndEmitChangeMessage(stageCurrent);
            Quotation stageVersionedUpdated = this.stageHandler.update(stageVersioned);
            this.historyItemRoute.persistChanges(stageVersionedUpdated);
            QEntity qEntityRefreshed = this.refreshQEntity(stageVersionedUpdated);
            LinkedHashMap versionedStages = Maps.newLinkedHashMap();
            LinkedHashMap versionedChildStage = Maps.newLinkedHashMap();
            ImmutableSet includeStageIds = ImmutableSet.copyOf((Collection)((Collection)MoreObjects.firstNonNull((Object)stageVersionUpdateRequest.getIncludeStageIds(), (Object)ImmutableList.of())));
            for (Object includeStageId : includeStageIds) {
                Quotation childStage = (Quotation)allById.get(includeStageId);
                if (null == childStage) continue;
                StageVersionResult childStageVersionedResult = this.createVersion(childStage, currentVersion, gracePeriod, flagCrossVersionOrderValue);
                Quotation childStageVersioned = childStageVersionedResult.getStageVersioned();
                Map childStageVersionedPositionMap = childStageVersionedResult.getPositionMap();
                Map<QuotationPosition, QuotationPosition> childStageVersionedPositionMapInversed = childStageVersionedPositionMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
                Set versionedStagePositions = (Set)MoreObjects.firstNonNull((Object)childStageVersioned.getQuotationPositions(), (Object)ImmutableSet.of());
                for (QuotationPosition versionedStagePosition : versionedStagePositions) {
                    QuotationPosition quotationPosition = childStageVersionedPositionMapInversed.get(versionedStagePosition);
                    QuotationPosition referencePosition = quotationPosition.getReferencePosition();
                    QuotationPosition referencePositionNew = (QuotationPosition)stageVersionedPositionMap.get(referencePosition);
                    versionedStagePosition.setReferencePosition(referencePositionNew);
                }
                childStageVersioned.setReference(childStage);
                versionedStages.put(childStageVersioned, stageVersionedUpdated);
                versionedChildStage.put(childStage, childStageVersionedResult);
            }
            Set childrenOfTypeAddendum = (Set)((Set)MoreObjects.firstNonNull((Object)stageCurrent.getChildren(), (Object)ImmutableSet.of())).stream().filter(item -> item.getStageType() == EQStageType.COMMISSION__ADDENDUM).filter(item -> item.getStageState() == EQStageState.ACTIVE).collect(ImmutableSet.toImmutableSet());
            for (Object addendum : childrenOfTypeAddendum) {
                StageVersionResult addendumVersionResult = this.createVersion((Quotation)addendum, currentVersion, gracePeriod, flagCrossVersionOrderValue);
                Quotation addendumCurrent = addendumVersionResult.getStageOriginal();
                Quotation addendumCurrentUpdated = this.updateAndEmitChangeMessage(addendumCurrent);
                Quotation addendumVersioned = addendumVersionResult.getStageVersioned();
                addendumVersioned.setReference((Quotation)addendum);
                versionedStages.put(addendumVersioned, stageVersionedUpdated);
            }
            Set childrenOfTypeCostUnitAddendum = (Set)Streams.stream((Iterable)all).filter(item -> item.getStageType() == EQStageType.COST_UNIT__ADDENDUM).filter(item -> item.getStageState() == EQStageState.ACTIVE).collect(ImmutableSet.toImmutableSet());
            for (Quotation addendum : childrenOfTypeCostUnitAddendum) {
                EQStageType newStageType;
                Quotation newParent;
                Quotation supposedParentCostUnit = addendum.getParent();
                if (versionedChildStage.containsKey(supposedParentCostUnit)) {
                    newParent = ((StageVersionResult)versionedChildStage.get(supposedParentCostUnit)).getStageVersioned();
                    newStageType = addendum.getStageType();
                } else {
                    newParent = stageVersioned;
                    newStageType = EQStageType.COMMISSION__ADDENDUM;
                }
                StageVersionResult addendumVersionResult = this.createVersion(addendum, currentVersion, gracePeriod, flagCrossVersionOrderValue);
                Quotation addendumCurrent = addendumVersionResult.getStageOriginal();
                Quotation addendumCurrentUpdated = this.updateAndEmitChangeMessage(addendumCurrent);
                Quotation addendumVersioned = addendumVersionResult.getStageVersioned();
                addendumVersioned.setReference(addendum);
                addendumVersioned.setParent(newParent);
                addendumVersioned.setStageType(newStageType);
                versionedStages.put(addendumVersioned, newParent);
            }
            versionedStages.forEach(Quotation::setParent);
            this.stageHandler.update(versionedStages.keySet());
            Quotation stageNewUpdated2 = this.updateAndEmitChangeMessage(stageVersionedUpdated);
            return this.mapper.mapToCommon(this.stageBucket(stageNewUpdated2));
        }
        return this.mapper.mapToCommon(this.stageBucket(stageCurrent));
    }

    @Nonnull
    private StageVersionResult createVersion(@NonNull Quotation stage, @NonNull Integer currentVersion, @NonNull LocalDate gracePeriod, @NonNull Boolean flagCrossVersionOrderValue) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        if (currentVersion == null) {
            throw new NullPointerException("currentVersion is marked non-null but is null");
        }
        if (gracePeriod == null) {
            throw new NullPointerException("gracePeriod is marked non-null but is null");
        }
        if (flagCrossVersionOrderValue == null) {
            throw new NullPointerException("flagCrossVersionOrderValue is marked non-null but is null");
        }
        EQStageType stageTypeNew = stage.getStageType();
        EStageOrigin sourceOrigin = stage.getOrigin();
        Quotation stageNew = this.entityFactory.stage();
        StageMergeResult stageMergeResult = this.mapper.mergeInto(stage, stageNew, stageTypeNew, true, false);
        Quotation stageMerged = stageMergeResult.getStage();
        Map positionMap = stageMergeResult.getPositionMap();
        stageMerged.setQNumber(stage.getQNumber());
        stageMerged.setAlias(stage.getAlias());
        stageMerged.setStageType(stageTypeNew);
        stageMerged.setStageState(EQStageState.TEMPORARY);
        stageMerged.setProjectExecutionStartDate(DateTimeHelper.today());
        stageMerged.setProjectExecutionEndDate(stage.getProjectExecutionEndDate());
        stage.setVersion(currentVersion);
        stage.setVersionSince(DateTimeHelper.now());
        stageMerged.setVersion(Integer.valueOf(1 + currentVersion));
        stageMerged.setVersionSince(DateTimeHelper.now());
        stage.setFlagCrossVersionOrderValue(flagCrossVersionOrderValue);
        stageMerged.setFlagCrossVersionOrderValue(flagCrossVersionOrderValue);
        stageMerged.setOrigin(sourceOrigin);
        if (sourceOrigin != EStageOrigin.QUANTE_V1) {
            stageMerged.setQuotationNumber(stage.getQNumber());
        }
        stageMerged.setAddendumNumber(stage.getAddendumNumber());
        if (null == stage.getProjectExecutionStartDate()) {
            stage.setProjectExecutionStartDate(stage.getCommissionDate());
        }
        stage.setProjectExecutionEndDate(gracePeriod);
        stage.setGracePeriodDate(gracePeriod);
        this.stageCalculators.standard().calculateAndApply(stageMerged);
        return StageVersionResult.of((Quotation)stage, (Quotation)stageMerged, (Map)positionMap);
    }

    @Nonnull
    private Quotation postProcessMerge(@NonNull Quotation stageFrom, @NonNull Quotation stageCreated, @NonNull EQStageType stageTypeNew) {
        if (stageFrom == null) {
            throw new NullPointerException("stageFrom is marked non-null but is null");
        }
        if (stageCreated == null) {
            throw new NullPointerException("stageCreated is marked non-null but is null");
        }
        if (stageTypeNew == null) {
            throw new NullPointerException("stageTypeNew is marked non-null but is null");
        }
        EQStageType stageTypeOld = stageFrom.getStageType();
        stageCreated.setStageType(stageTypeNew);
        stageCreated.setStageState(EQStageState.TEMPORARY);
        stageCreated.setStageStateSince(DateTimeHelper.now());
        stageCreated.setParent(stageFrom);
        if (Iterables.contains((Iterable)EQStageType.ADDENDUM_TYPES, (Object)stageTypeNew)) {
            stageCreated.setAddendumNumber(null);
            stageCreated.setOrderValue(null);
            stageCreated.setOrderValueEstimate(null);
            stageCreated.setBudgetAllowedOverdraftPercent(null);
            stageCreated.setBudgetAllowedOverdraftValue(null);
            stageCreated.setCommissionDate(null);
            stageCreated.setFlagMeasurementWithoutCommissionNumberAllowed(Boolean.valueOf(false));
            stageCreated.setQuotationSubmissionType(EQuotationSubmissionType.UNKNOWN);
            stageCreated.setGeneralDiscount(BigDecimal.ZERO);
            stageCreated.setSubmissionOfBidDate(null);
            stageCreated.setSubProject(null);
            stageCreated.setFlagDiscountFeePositions(Boolean.valueOf(false));
            stageCreated.setAddress(null);
            stageCreated.setAgentAddress(null);
            stageCreated.setAgentInvoiceAddress(null);
            stageCreated.setCustomerInvoiceAddress(null);
        }
        if (EQStageType.COMMISSION__COST_ESTIMATE != stageTypeOld || EQStageType.COMMISSION__COST_ESTIMATE == stageTypeNew) {
            stageCreated.setOrderValue(null);
            stageCreated.setOrderValueEstimate(null);
            stageCreated.setBudgetAllowedOverdraftPercent(null);
            stageCreated.setBudgetAllowedOverdraftValue(null);
            stageCreated.setGeneralDiscount(BigDecimal.ZERO);
            stageCreated.setOtherDiscount(BigDecimal.ZERO);
        }
        if (EQStageType.COMMISSION__COST_UNIT == stageTypeNew) {
            stageCreated.setFlagDiscountFeePositions(Boolean.valueOf(false));
            stageCreated.setOrderNumber("");
        }
        if (EQStageType.COMMISSION__COST_ESTIMATE == stageTypeNew) {
            stageCreated.setSubmissionOfBidDate(null);
            stageCreated.setBindingPeriodDate(null);
            stageCreated.setCommissionDate(null);
            stageCreated.setFlagDiscountFeePositions(Boolean.valueOf(false));
            stageCreated.setStagePositionSortOption(EStagePositionSortOption.MANUAL);
            stageCreated.setQuotationSubmissionType(EQuotationSubmissionType.UNKNOWN);
            stageCreated.setFlagMeasurementWithoutCommissionNumberAllowed(Boolean.valueOf(false));
            stageCreated.setMaterialPercentageMin(this.applicationConfig.getStageMaterialPercentageMin());
            stageCreated.setMaterialPercentageStandard(this.applicationConfig.getStageMaterialPercentageStandard());
            stageCreated.setWagePercentageMin(this.applicationConfig.getStageWagePercentageMin());
            stageCreated.setWagePercentageStandard(this.applicationConfig.getStageWagePercentageStandard());
            stageCreated.setOrderNumber("");
            stageCreated.setOrderDescriptionCustomer("");
            stageCreated.setOrderDescriptionInternal("");
        }
        boolean lockedState = EQStageType.DEFAULT_LOCKED_STAGE_TYPE.contains((Object)stageTypeNew);
        stageCreated.setFlagPositionGridLocked(Boolean.valueOf(lockedState));
        return stageCreated;
    }

    @Nonnull
    private Quotation updateAndEmitChangeMessage(@NonNull Quotation stage) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        Quotation stageUpdated1 = this.stageHandler.update(stage);
        this.stageCalculators.postUpdate().calculateAndApply(stageUpdated1);
        Quotation stageUpdated2 = this.stageHandler.update(stageUpdated1);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)QStageChangeMessage.of((Object)this, (Quotation)stageUpdated2));
        return stageUpdated2;
    }

    @Nonnull
    private QEntity updateAndEmitChangeMessage(@NonNull QEntity qEntity) {
        if (qEntity == null) {
            throw new NullPointerException("qEntity is marked non-null but is null");
        }
        QEntity qEntityUpdated = (QEntity)this.entityHandler.update((EntityBase)qEntity);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)QEntityChangeMessage.of((Object)this, (QEntity)qEntity));
        return qEntityUpdated;
    }

    public void onApplicationEvent(@NonNull QStageChangeMessage changeMessage) {
        if (changeMessage == null) {
            throw new NullPointerException("changeMessage is marked non-null but is null");
        }
    }

    @Nonnull
    private Iterable<StageNotifyBucket> stageNotifyBuckets(@NonNull Quotation quotation, @NonNull StageUpdateRequest updateRequest) {
        if (quotation == null) {
            throw new NullPointerException("quotation is marked non-null but is null");
        }
        if (updateRequest == null) {
            throw new NullPointerException("updateRequest is marked non-null but is null");
        }
        Iterable notifyUserIDs = (Iterable)((List)MoreObjects.firstNonNull((Object)updateRequest.getNotifyUserIds(), (Object)ImmutableList.of())).stream().filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
        Iterable notifyUsers = this.userHandler.allByIds(notifyUserIDs);
        Set existingStageNotifyUsers = (Set)MoreObjects.firstNonNull((Object)quotation.getStageNotifyUsers(), (Object)ImmutableSet.of());
        Map existingNotifyUserByUser = MapsHelper.mapFirst((Iterable)existingStageNotifyUsers, StageNotifyUser::getUser);
        Set existingNotifyUsers = existingNotifyUserByUser.keySet();
        Sets.SetView toBeAdded = Sets.difference((Set)ImmutableSet.copyOf((Iterable)notifyUsers), existingNotifyUsers);
        Sets.SetView toBeUpdated = Sets.intersection((Set)ImmutableSet.copyOf((Iterable)notifyUsers), existingNotifyUsers);
        ImmutableList.Builder bucketBuilder = ImmutableList.builder();
        for (User user : toBeAdded) {
            bucketBuilder.add((Object)StageNotifyBucket.of(null, (Quotation)quotation, (User)user));
        }
        for (User user : toBeUpdated) {
            StageNotifyUser stageNotifyUser = (StageNotifyUser)existingNotifyUserByUser.get(user);
            bucketBuilder.add((Object)StageNotifyBucket.of((Long)stageNotifyUser.getId(), (Quotation)quotation, (User)user));
        }
        return bucketBuilder.build();
    }

    @Nonnull
    private Iterable<StageResponsibleBucket> responsibleBuckets(@NonNull Quotation quotation, @NonNull Iterable<Long> responsibleUserIDs) {
        if (quotation == null) {
            throw new NullPointerException("quotation is marked non-null but is null");
        }
        if (responsibleUserIDs == null) {
            throw new NullPointerException("responsibleUserIDs is marked non-null but is null");
        }
        Iterable responsibleUserIds = (Iterable)Streams.stream(responsibleUserIDs).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
        Iterable responsibleUsers = this.userHandler.allByIds(responsibleUserIds);
        Set existingStageResponsibleUsers = (Set)MoreObjects.firstNonNull((Object)quotation.getStageResponsibleUsers(), (Object)ImmutableSet.of());
        Map existingResponsibleUserByUser = MapsHelper.mapFirst((Iterable)existingStageResponsibleUsers, StageResponsibleUser::getUser);
        Set existingResponsibleUsers = existingResponsibleUserByUser.keySet();
        Sets.SetView toBeAdded = Sets.difference((Set)ImmutableSet.copyOf((Iterable)responsibleUsers), existingResponsibleUsers);
        Sets.SetView toBeUpdated = Sets.intersection((Set)ImmutableSet.copyOf((Iterable)responsibleUsers), existingResponsibleUsers);
        ImmutableList.Builder bucketBuilder = ImmutableList.builder();
        for (User user : toBeAdded) {
            bucketBuilder.add((Object)StageResponsibleBucket.of(null, (Quotation)quotation, (User)user));
        }
        for (User user : toBeUpdated) {
            StageResponsibleUser stageResponsibleUser = (StageResponsibleUser)existingResponsibleUserByUser.get(user);
            bucketBuilder.add((Object)StageResponsibleBucket.of((Long)stageResponsibleUser.getId(), (Quotation)quotation, (User)user));
        }
        return bucketBuilder.build();
    }

    @Nonnull
    private Iterable<StageSignatureBucket> signatureBuckets(@NonNull Quotation quotation, @NonNull StageUpdateRequest updateRequest) {
        if (quotation == null) {
            throw new NullPointerException("quotation is marked non-null but is null");
        }
        if (updateRequest == null) {
            throw new NullPointerException("updateRequest is marked non-null but is null");
        }
        Iterable userIds = (Iterable)((List)MoreObjects.firstNonNull((Object)updateRequest.getSignatureUserIds(), (Object)ImmutableList.of())).stream().filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
        Iterable users = this.userHandler.allByIds(userIds);
        Set existingStageSignatureUsers = (Set)MoreObjects.firstNonNull((Object)quotation.getStageSignatureUsers(), (Object)ImmutableSet.of());
        Map existingUsersByUser = MapsHelper.mapFirst((Iterable)existingStageSignatureUsers, StageSignatureUser::getUser);
        Set existingUsers = existingUsersByUser.keySet();
        Sets.SetView toBeAdded = Sets.difference((Set)ImmutableSet.copyOf((Iterable)users), existingUsers);
        Sets.SetView toBeUpdated = Sets.intersection((Set)ImmutableSet.copyOf((Iterable)users), existingUsers);
        ImmutableList.Builder bucketBuilder = ImmutableList.builder();
        for (User user : toBeAdded) {
            bucketBuilder.add((Object)StageSignatureBucket.of(null, (Quotation)quotation, (User)user));
        }
        for (User user : toBeUpdated) {
            StageSignatureUser stageSignatureUser = (StageSignatureUser)existingUsersByUser.get(user);
            bucketBuilder.add((Object)StageSignatureBucket.of((Long)stageSignatureUser.getId(), (Quotation)quotation, (User)user));
        }
        return bucketBuilder.build();
    }

    @Nonnull
    private Iterable<StageInvoiceSupplementBucket> invoiceSupplementBuckets(@NonNull Quotation stage, @NonNull StageUpdateRequest updateRequest) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        if (updateRequest == null) {
            throw new NullPointerException("updateRequest is marked non-null but is null");
        }
        List invoiceSupplements = (List)MoreObjects.firstNonNull((Object)updateRequest.getInvoiceSupplements(), (Object)ImmutableList.of());
        return (Iterable)invoiceSupplements.stream().map((? super T item) -> StageInvoiceSupplementBucket.of((Long)item.getId(), (StageInvoiceSupplementUpdateItem)item, (Quotation)stage)).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    @Transactional
    public StageCommon createInquiry(@NonNull StageUpdateRequest updateRequest) {
        if (updateRequest == null) {
            throw new NullPointerException("updateRequest is marked non-null but is null");
        }
        Quotation stage = this.entityFactory.stage();
        stage.setStageType(EQStageType.INQUIRY);
        stage.setStageState(EQStageState.TEMPORARY);
        stage.setStageStateSince(DateTimeHelper.now());
        stage.setFlagDiscountFeePositions(Boolean.valueOf(false));
        stage.setFlagB2B(Boolean.valueOf(false));
        stage.setFlagMeasurementWithoutCommissionNumberAllowed(Boolean.valueOf(false));
        stage.setFlagDiscountFeePositions(Boolean.valueOf(false));
        stage.setFlagPositionGridLocked(Boolean.valueOf(false));
        stage.setFlagConstantCompanyWage(Boolean.valueOf(true));
        stage.setFlagOrderEnd(Boolean.valueOf(false));
        stage.setFlagOrderEqualsQuotation(Boolean.valueOf(false));
        stage.setFlagSquadIsAllowedToCreateReleaseOrder(Boolean.valueOf(true));
        stage.setFlagReleaseOrderOrderNumberMandatory(Boolean.valueOf(false));
        stage.setFlagAutomaticWageAssignmentAllowed(Boolean.valueOf(false));
        QEntity entity = this.entityFactory.qEntity();
        Long customerId = updateRequest.getCustomerId();
        Customer customer = null != customerId ? (Customer)this.customerHandler.byIdFailing(customerId) : null;
        String customerName = null != customer ? customer.getName() : "n/a";
        String inquiryAlias = String.format("Anfrage: %s vom %s", customerName, DateTimeHelperService.germanDateTime((LocalDateTime)this.dateTimeHelperService.convertToDestination(DateTimeHelper.now())));
        Long contactPersonId = updateRequest.getContactPersonId();
        ContactPerson contactPerson = null != contactPersonId ? (ContactPerson)this.contactPersonHandler.byIdFailing(contactPersonId) : null;
        Long addressId = updateRequest.getAddressId();
        Address address = null != addressId ? (Address)this.addressHandler.byIdFailing(addressId) : null;
        Long customerInvoiceId = updateRequest.getCustomerInvoiceId();
        Customer customerInvoice = null != customerInvoiceId ? (Customer)this.customerHandler.byIdFailing(customerInvoiceId) : null;
        Long invoiceCustomerAddressId = updateRequest.getCustomerInvoiceAddressId();
        Address invoiceCustomerAddress = null != invoiceCustomerAddressId ? (Address)this.addressHandler.byIdFailing(invoiceCustomerAddressId) : null;
        Long agentInvoiceId = updateRequest.getAgentInvoiceId();
        Customer agentInvoice = null != agentInvoiceId ? (Customer)this.customerHandler.byIdFailing(agentInvoiceId) : null;
        Long agentInvoiceAddressId = updateRequest.getAgentInvoiceAddressId();
        Address agentInvoiceAddress = null != agentInvoiceAddressId ? (Address)this.addressHandler.byIdFailing(agentInvoiceAddressId) : null;
        String inquiryTypeString = StringUtils.trimToEmpty((String)updateRequest.getInquiryType());
        EInquiryType inquiryType = EInquiryType.lookup((String)inquiryTypeString, (EInquiryType)EInquiryType.UNKNOWN);
        String inquiryReceiveTypeString = StringUtils.trimToEmpty((String)updateRequest.getInquiryReceiveType());
        EInquiryReceiveType inquiryReceiveType = EInquiryReceiveType.lookup((String)inquiryReceiveTypeString, (EInquiryReceiveType)EInquiryReceiveType.UNKNOWN);
        String quotationSubmissionTypeString = StringUtils.trimToEmpty((String)updateRequest.getQuotationSubmissionType());
        EQuotationSubmissionType quotationSubmissionType = EQuotationSubmissionType.lookup((String)quotationSubmissionTypeString, (EQuotationSubmissionType)EQuotationSubmissionType.UNKNOWN);
        String commissionTypeString = StringUtils.trimToEmpty((String)updateRequest.getCommissionType());
        ECommissionType commissionType = ECommissionType.lookup((String)commissionTypeString, (ECommissionType)ECommissionType.UNKNOWN);
        String defaultInvoiceTypeString = StringUtils.trimToEmpty((String)updateRequest.getFinanceDefaultInvoiceType());
        EInvoiceType defaultInvoiceType = EInvoiceType.lookup((String)defaultInvoiceTypeString, (EInvoiceType)EInvoiceType.UNKNOWN);
        String pdfExtractTypeTxt = StringUtils.trimToEmpty((String)updateRequest.getPdfExtractType());
        EPdfExtractType pdfExtractType = EPdfExtractType.lookup((String)pdfExtractTypeTxt, (EPdfExtractType)EPdfExtractType.NONE);
        String stagePositionSortOptionTxt = StringUtils.trimToEmpty((String)updateRequest.getStagePositionSortOption());
        EStagePositionSortOption stagePositionSortOption = EStagePositionSortOption.lookup((String)stagePositionSortOptionTxt, (EStagePositionSortOption)EStagePositionSortOption.AUTOMATIC);
        Long taxKeyId = updateRequest.getFinanceTaxKeyId();
        TaxKey taxKey = null != taxKeyId ? (TaxKey)this.taxKeyHandler.byIdFailing(taxKeyId) : null;
        Long subProjectId = updateRequest.getSubProjectId();
        SubProject subProject = null != subProjectId ? (SubProject)this.subProjectHandler.byIdFailing(subProjectId) : null;
        Iterable stageNotifyBuckets = this.stageNotifyBuckets(stage, updateRequest);
        List responsibleUserIDs = (List)MoreObjects.firstNonNull((Object)updateRequest.getResponsibleUserIds(), (Object)ImmutableList.of());
        Iterable stageResponsibleBuckets = this.responsibleBuckets(stage, (Iterable)responsibleUserIDs);
        Iterable stageSignatureBuckets = this.signatureBuckets(stage, updateRequest);
        Iterable stageInvoiceSupplementBuckets = this.invoiceSupplementBuckets(stage, updateRequest);
        EntityCreateBucket updateBucket = EntityCreateBucket.of((StageUpdateRequest)updateRequest, (SubProject)subProject, (String)"", (EQEntityState)EQEntityState.INQUIRY_TEMPORARY, (String)inquiryAlias, (Customer)customer, null, (ECommissionType)commissionType, (Iterable)ImmutableSet.of((Object)stage));
        QEntity entityMerged = this.entityMapper.merge(entity, updateBucket);
        BigDecimal materialPercentageMin = this.applicationConfig.getStageMaterialPercentageMin();
        BigDecimal materialPercentageStandard = this.applicationConfig.getStageMaterialPercentageStandard();
        BigDecimal wagePercentageMin = this.applicationConfig.getStageWagePercentageMin();
        BigDecimal wagePercentageStandard = this.applicationConfig.getStageWagePercentageStandard();
        StageUpdateBucket stageUpdateBucket = StageUpdateBucket.of((StageUpdateRequest)updateRequest, (Quotation)stage, (Quotation)stage, (TaxKey)taxKey, (Customer)customer, (Address)address, (ContactPerson)contactPerson, (Customer)customerInvoice, (Address)invoiceCustomerAddress, (Customer)agentInvoice, (Address)agentInvoiceAddress, (SubProject)subProject, (BigDecimal)materialPercentageMin, (BigDecimal)materialPercentageStandard, (BigDecimal)wagePercentageMin, (BigDecimal)wagePercentageStandard, (EInquiryType)inquiryType, (EInquiryReceiveType)inquiryReceiveType, (EQuotationSubmissionType)quotationSubmissionType, (ECommissionType)commissionType, (EInvoiceType)defaultInvoiceType, (EPdfExtractType)pdfExtractType, (EStagePositionSortOption)stagePositionSortOption, (Iterable)stageNotifyBuckets, (Iterable)stageResponsibleBuckets, (Iterable)stageSignatureBuckets, (Iterable)stageInvoiceSupplementBuckets);
        if (null == entityMerged.getStages()) {
            entityMerged.setStages((Set)Sets.newHashSet());
        }
        entityMerged.getStages().add(stage);
        stage.setQEntity(entityMerged);
        Quotation stageMerged = this.mapper.mergeStage(stageUpdateBucket);
        List positions = (List)MoreObjects.firstNonNull((Object)updateRequest.getPositions(), (Object)ImmutableList.of());
        ImmutableList positionUpdateBuckets = (ImmutableList)positions.stream().map((? super T item) -> {
            EPositionType positionType = EPositionType.lookup((String)StringUtils.trimToEmpty((String)item.getPositionType()), (EPositionType)EPositionType.STANDARD);
            EAlternativePositionType alternativePositionType = EAlternativePositionType.lookup((String)StringUtils.trimToEmpty((String)item.getAlternativePositionType()), (EAlternativePositionType)EAlternativePositionType.UNKNOWN);
            return QStagePositionUpdateBucket.of((Long)item.getId(), (EPositionType)positionType, (EPositionType)EPositionType.UNKNOWN, (EAlternativePositionType)alternativePositionType, (StagePositionUpdateItem)item, null, (Iterable)ImmutableSet.of());
        }).collect(ImmutableList.toImmutableList());
        QStagePositionsUpdateBucket qStagePositionsUpdateBucket = QStagePositionsUpdateBucket.of((Quotation)stageMerged, (Iterable)positionUpdateBuckets);
        MergedBucket quotationPositionMergedBucket = this.mapper.mergePositions(qStagePositionsUpdateBucket);
        this.stageCalculators.standard().calculateAndApply(stageMerged);
        QEntity entityUpdated = this.updateAndEmitChangeMessage(entityMerged);
        stageMerged.setQNumber("");
        stageMerged.setAlias(inquiryAlias);
        stageMerged.setAliasChanged(Boolean.valueOf(false));
        Quotation stageUpdated = this.updateAndEmitChangeMessage(stageMerged);
        this.historyItemRoute.persistChanges(stageUpdated);
        entityUpdated.setPrimaryStage(stageUpdated);
        boolean entityModified = this.createInquiryFolder(entityUpdated);
        QEntity entityUpdated2 = this.updateAndEmitChangeMessage(entityUpdated);
        return this.mapper.mapToCommon(this.stageBucket(stageUpdated));
    }

    @Nonnull
    @Transactional
    public StageCommon update(@NonNull Long id, @NonNull StageUpdateRequest updateRequest) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (updateRequest == null) {
            throw new NullPointerException("updateRequest is marked non-null but is null");
        }
        Quotation stage = (Quotation)this.stageHandler.byIdFailing(id);
        QEntity entity = stage.getQEntity();
        Quotation primaryStage = entity.getPrimaryStage();
        Set stages = (Set)MoreObjects.firstNonNull((Object)entity.getStages(), (Object)ImmutableSet.of());
        StageHistorySnapShot stageHistorySnapShotInit = this.historyItemRoute.snapShot(stage);
        Long customerId = updateRequest.getCustomerId();
        Customer customer = null != customerId ? (Customer)this.customerHandler.byIdFailing(customerId) : null;
        Long contactPersonId = updateRequest.getContactPersonId();
        ContactPerson contactPerson = null != contactPersonId ? (ContactPerson)this.contactPersonHandler.byIdFailing(contactPersonId) : null;
        Long addressId = updateRequest.getAddressId();
        Address address = null != addressId ? (Address)this.addressHandler.byIdFailing(addressId) : null;
        Long customerInvoiceId = updateRequest.getCustomerInvoiceId();
        Customer customerInvoice = null != customerInvoiceId ? (Customer)this.customerHandler.byIdFailing(customerInvoiceId) : null;
        Long invoiceCustomerAddressId = updateRequest.getCustomerInvoiceAddressId();
        Address invoiceCustomerAddress = null != invoiceCustomerAddressId ? (Address)this.addressHandler.byIdFailing(invoiceCustomerAddressId) : null;
        Long agentInvoiceId = updateRequest.getAgentInvoiceId();
        Customer agentInvoice = null != agentInvoiceId ? (Customer)this.customerHandler.byIdFailing(agentInvoiceId) : null;
        Long agentInvoiceAddressId = updateRequest.getAgentInvoiceAddressId();
        Address agentInvoiceAddress = null != agentInvoiceAddressId ? (Address)this.addressHandler.byIdFailing(agentInvoiceAddressId) : null;
        Long taxKeyId = updateRequest.getFinanceTaxKeyId();
        TaxKey taxKey = null != taxKeyId ? (TaxKey)this.taxKeyHandler.byIdFailing(taxKeyId) : null;
        Long subProjectId = updateRequest.getSubProjectId();
        SubProject subProject = null != subProjectId ? (SubProject)this.subProjectHandler.byIdFailing(subProjectId) : null;
        String inquiryTypeString = StringUtils.trimToEmpty((String)updateRequest.getInquiryType());
        EInquiryType inquiryType = EInquiryType.lookup((String)inquiryTypeString, (EInquiryType)EInquiryType.UNKNOWN);
        String inquiryReceiveTypeString = StringUtils.trimToEmpty((String)updateRequest.getInquiryReceiveType());
        EInquiryReceiveType inquiryReceiveType = EInquiryReceiveType.lookup((String)inquiryReceiveTypeString, (EInquiryReceiveType)EInquiryReceiveType.UNKNOWN);
        String quotationSubmissionTypeString = StringUtils.trimToEmpty((String)updateRequest.getQuotationSubmissionType());
        EQuotationSubmissionType quotationSubmissionType = EQuotationSubmissionType.lookup((String)quotationSubmissionTypeString, (EQuotationSubmissionType)EQuotationSubmissionType.UNKNOWN);
        String commissionTypeString = StringUtils.trimToEmpty((String)updateRequest.getCommissionType());
        ECommissionType commissionType = ECommissionType.lookup((String)commissionTypeString, (ECommissionType)ECommissionType.UNKNOWN);
        String defaultInvoiceTypeString = StringUtils.trimToEmpty((String)updateRequest.getFinanceDefaultInvoiceType());
        EInvoiceType defaultInvoiceType = EInvoiceType.lookup((String)defaultInvoiceTypeString, (EInvoiceType)EInvoiceType.UNKNOWN);
        String pdfExtractTypeTxt = StringUtils.trimToEmpty((String)updateRequest.getPdfExtractType());
        EPdfExtractType pdfExtractType = EPdfExtractType.lookup((String)pdfExtractTypeTxt, (EPdfExtractType)EPdfExtractType.NONE);
        String stagePositionSortOptionTxt = StringUtils.trimToEmpty((String)updateRequest.getStagePositionSortOption());
        EStagePositionSortOption stagePositionSortOption = EStagePositionSortOption.lookup((String)stagePositionSortOptionTxt, (EStagePositionSortOption)EStagePositionSortOption.NONE);
        Iterable stageNotifyBuckets = this.stageNotifyBuckets(stage, updateRequest);
        List responsibleUserIDs = (List)MoreObjects.firstNonNull((Object)updateRequest.getResponsibleUserIds(), (Object)ImmutableList.of());
        Iterable stageResponsibleBuckets = this.responsibleBuckets(stage, (Iterable)responsibleUserIDs);
        Iterable stageSignatureBuckets = this.signatureBuckets(stage, updateRequest);
        Iterable stageInvoiceSupplementBuckets = this.invoiceSupplementBuckets(stage, updateRequest);
        BigDecimal materialPercentageMin = (BigDecimal)MoreObjects.firstNonNull((Object)updateRequest.getMaterialPercentageMin(), (Object)BigDecimal.valueOf(110L));
        BigDecimal materialPercentageStandard = (BigDecimal)MoreObjects.firstNonNull((Object)updateRequest.getMaterialPercentageStandard(), (Object)BigDecimal.valueOf(110L));
        BigDecimal wagePercentageMin = (BigDecimal)MoreObjects.firstNonNull((Object)updateRequest.getWagePercentageMin(), (Object)BigDecimal.valueOf(400L));
        BigDecimal wagePercentageStandard = (BigDecimal)MoreObjects.firstNonNull((Object)updateRequest.getWagePercentageStandard(), (Object)BigDecimal.valueOf(400L));
        Long addendumNumberToBeSet = updateRequest.getAddendumNumber();
        this.validateAddendumNumber(stage, addendumNumberToBeSet);
        StageUpdateBucket stageUpdateBucket = StageUpdateBucket.of((StageUpdateRequest)updateRequest, (Quotation)stage, (Quotation)stage, (TaxKey)taxKey, (Customer)customer, (Address)address, (ContactPerson)contactPerson, (Customer)customerInvoice, (Address)invoiceCustomerAddress, (Customer)agentInvoice, (Address)agentInvoiceAddress, (SubProject)subProject, (BigDecimal)materialPercentageMin, (BigDecimal)materialPercentageStandard, (BigDecimal)wagePercentageMin, (BigDecimal)wagePercentageStandard, (EInquiryType)inquiryType, (EInquiryReceiveType)inquiryReceiveType, (EQuotationSubmissionType)quotationSubmissionType, (ECommissionType)commissionType, (EInvoiceType)defaultInvoiceType, (EPdfExtractType)pdfExtractType, (EStagePositionSortOption)stagePositionSortOption, (Iterable)stageNotifyBuckets, (Iterable)stageResponsibleBuckets, (Iterable)stageSignatureBuckets, (Iterable)stageInvoiceSupplementBuckets);
        Quotation stageMerged = this.mapper.mergeStage(stageUpdateBucket);
        ArrayList positionMergeBuckets = Lists.newArrayList();
        if (stage.getStageType() != EQStageType.INQUIRY) {
            ImmutableMap existingPositionsById;
            List positions = (List)MoreObjects.firstNonNull((Object)updateRequest.getPositions(), (Object)ImmutableList.of());
            ImmutableSet referencePositionIds = (ImmutableSet)positions.stream().map(StagePositionModificationItem::getReferencePositionId).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
            if (EQStageType.COMMISSION__COST_ESTIMATE == stage.getStageType()) {
                existingPositionsById = (ImmutableMap)stages.stream().filter(item -> item.getStageType() == EQStageType.COMMISSION || item.getStageType() == EQStageType.COMMISSION__ADDENDUM).flatMap(item -> ((Set)MoreObjects.firstNonNull((Object)item.getQuotationPositions(), (Object)ImmutableSet.of())).stream()).collect(ImmutableMap.toImmutableMap(QuotationPosition::getId, item -> item));
                ImmutableSet longs = existingPositionsById.keySet();
                Sets.SetView difference = Sets.difference((Set)referencePositionIds, (Set)longs);
                if (!difference.isEmpty() && EQStageType.COMMISSION__COST_ESTIMATE == stage.getStageType()) {
                    String differenceIDsAsString = Joiner.on((char)',').skipNulls().join((Iterable)difference);
                    throw new UpdateRejectException((FieldName)FieldNamesFactory.stagePositionReferenceId(), (Object)differenceIDsAsString, String.format("Cost Estimate cannot be Updated, Reference Position(s): %s are not found in Commission or Addendum", differenceIDsAsString), Message.of((EMessageKey)EMessageKey.Q_ENTITY__MISSING_REFERENCE_IDS_IN_COMMISSION, (List)ImmutableList.of((Object)differenceIDsAsString)));
                }
            } else {
                List quotationPositions = this.stagePositionHandler.byIds((Iterable)referencePositionIds);
                existingPositionsById = (ImmutableMap)Streams.stream((Iterable)quotationPositions).collect(ImmutableMap.toImmutableMap(QuotationPosition::getId, item -> item));
            }
            Iterable positionUpdateBuckets = this.positionUpdateBuckets((Map)existingPositionsById, (Iterable)positions);
            this.validateChangeInQuantityFailing(stageMerged, positionUpdateBuckets, (Iterable)stages);
            QStagePositionsUpdateBucket stagePositionsUpdateBucket = QStagePositionsUpdateBucket.of((Quotation)stageMerged, (Iterable)positionUpdateBuckets);
            MergedBucket stagePositionMergedBucket = this.mapper.mergePositions(stagePositionsUpdateBucket);
            positionMergeBuckets.add(stagePositionMergedBucket);
            this.stageCalculators.standard().calculateAndApply(stageMerged);
            Map boilerPlates = this.boilerPlateHandler.byKeysAsMap((Iterable)ImmutableSet.copyOf((Object[])EBoilerPlateKey.values()));
            this.validateOrInitCoverLetter(stageMerged, primaryStage, boilerPlates);
        }
        boolean validate = this.validators.stageValidation(stageUpdateBucket).validBase().validate();
        boolean isInquiry = stageMerged.getStageType() == EQStageType.INQUIRY && stageMerged.getStageState() == EQStageState.TEMPORARY;
        this.validateQNumber(stageMerged).ifPresent(item -> {
            stageMerged.setQNumber(item);
            if (!isInquiry && Boolean.TRUE != stageMerged.getAliasChanged()) {
                stageMerged.setAlias(item);
            }
        });
        Quotation stageUpdated = this.updateAndEmitChangeMessage(stageMerged);
        this.historyItemRoute.persistChanges(stageHistorySnapShotInit, stageUpdated);
        StageHistorySnapShot stageHistorySnapShotPost = this.historyItemRoute.snapShot(stageUpdated);
        StageRouteImpl.mapQEntityRemarks((StageUpdateRequest)updateRequest, (Quotation)stageUpdated);
        QEntity entityRefreshed = this.refreshQEntity(stageUpdated);
        Map positionsState1 = stageHistorySnapShotInit.getPositionsState();
        Map positionsState2 = stageHistorySnapShotPost.getPositionsState();
        Iterable unequalPositionIds = this.unequal(positionsState1, positionsState2);
        Sets.SetView addedPositionIds = Sets.difference(positionsState2.keySet(), positionsState1.keySet());
        Sets.SetView removedPositionIds = Sets.difference(positionsState1.keySet(), positionsState2.keySet());
        List positionsAdded = this.stagePositionHandler.byIds((Iterable)addedPositionIds);
        List positionsRemoved = this.stagePositionHandler.byIds((Iterable)removedPositionIds);
        Long batch = System.currentTimeMillis();
        HashSet allAffectedStages = Sets.newHashSet();
        EQStageType stageType = stageUpdated.getStageType();
        if (!(Iterables.isEmpty((Iterable)positionsAdded) && Iterables.isEmpty((Iterable)removedPositionIds) && Iterables.isEmpty((Iterable)unequalPositionIds) && EQStageType.COMMISSION__COST_ESTIMATE != stageType)) {
            Set quotationPositions = stageUpdated.getQuotationPositions();
            Map<Long, QuotationPosition> positionsById = quotationPositions.stream().collect(Collectors.toMap(QuotationPosition::getId, item -> item));
            ImmutableSet positionsUpdated = (ImmutableSet)Streams.stream((Iterable)unequalPositionIds).map(positionsById::get).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
            if (EQStageType.COMMISSION__COST_ESTIMATE == stageType) {
                this.stageHandler.costUnitsForCostEstimate(stageUpdated).ifPresent(allAffectedStages::add);
                for (Quotation affectedStage : allAffectedStages) {
                    this.createStagePropagation(stageUpdated, affectedStage, batch, (Iterable)positionsAdded, (Iterable)positionsUpdated, (Iterable)positionsRemoved);
                }
            } else {
                allAffectedStages.addAll(this.stageHandler.allWithReferencePositionForStagePropagation(entityRefreshed, (Iterable)positionsUpdated));
                allAffectedStages.addAll(this.stageHandler.allWithReferencePositionForStagePropagation(entityRefreshed, (Iterable)positionsRemoved));
                for (Quotation affectedStage : allAffectedStages) {
                    this.createStagePropagation(stageUpdated, affectedStage, batch, (Iterable)ImmutableList.of(), (Iterable)positionsUpdated, (Iterable)positionsRemoved);
                }
            }
        }
        if (Iterables.contains((Iterable)EQStageType.STAGE_PROPAGATION_SENDERS, (Object)stageType)) {
            boolean changesFound;
            Map stageState2;
            Map stageState1 = stageHistorySnapShotInit.getStageState();
            Iterable differencesBetweenStates = this.stageHistoryPreparer.snapShotDifferences(stageState1, stageState2 = stageHistorySnapShotPost.getStageState());
            boolean bl = changesFound = !Iterables.isEmpty((Iterable)differencesBetweenStates);
            if (changesFound) {
                Sets.SetView difference = Sets.difference((Set)stages, (Set)allAffectedStages);
                ImmutableSet headStages = (ImmutableSet)difference.stream().filter(item -> Iterables.contains((Iterable)EQStageType.STAGE_PROPAGATION_RECIPIENTS, (Object)item.getStageType())).collect(ImmutableSet.toImmutableSet());
                for (Quotation headStage : headStages) {
                    this.createStagePropagation(stageUpdated, headStage, batch, (Iterable)ImmutableList.of(), (Iterable)ImmutableList.of(), (Iterable)ImmutableList.of());
                }
            }
        }
        return this.mapper.mapToCommon(this.stageBucket(stageUpdated));
    }

    @Nonnull
    private Iterable<QStagePositionUpdateBucket> positionUpdateBuckets(@NonNull Map<Long, QuotationPosition> existingPositionsById, @NonNull Iterable<StagePositionUpdateItem> updateItems) {
        if (existingPositionsById == null) {
            throw new NullPointerException("existingPositionsById is marked non-null but is null");
        }
        if (updateItems == null) {
            throw new NullPointerException("updateItems is marked non-null but is null");
        }
        ImmutableList positionUpdateBuckets = (ImmutableList)Streams.stream(updateItems).map((? super T item) -> {
            Long referencePositionId = item.getReferencePositionId();
            QuotationPosition referencePosition = existingPositionsById.getOrDefault(referencePositionId, null);
            EPositionType positionType = EPositionType.lookup((String)StringUtils.trimToEmpty((String)item.getPositionType()), (EPositionType)EPositionType.STANDARD);
            EAlternativePositionType alternativePositionType = EAlternativePositionType.lookup((String)StringUtils.trimToEmpty((String)item.getAlternativePositionType()), (EAlternativePositionType)EAlternativePositionType.NO);
            List children = (List)MoreObjects.firstNonNull((Object)item.getChildren(), (Object)ImmutableList.of());
            Iterable childrenUpdateBuckets = this.positionUpdateBuckets(existingPositionsById, (Iterable)children);
            EPositionType jumboPositionType = Iterables.isEmpty((Iterable)childrenUpdateBuckets) ? EPositionType.UNKNOWN : ((QStagePositionUpdateBucket)childrenUpdateBuckets.iterator().next()).getPositionType();
            return QStagePositionUpdateBucket.of((Long)item.getId(), (EPositionType)positionType, (EPositionType)jumboPositionType, (EAlternativePositionType)alternativePositionType, (StagePositionUpdateItem)item, (QuotationPosition)referencePosition, (Iterable)childrenUpdateBuckets);
        }).collect(ImmutableList.toImmutableList());
        positionUpdateBuckets.stream().filter(updateBucket -> EPositionType.JUMBO == updateBucket.getPositionType()).filter(updateBucket -> !Iterables.isEmpty((Iterable)updateBucket.getChildren())).filter(updateBucket -> {
            EPositionType jumboPositionType = updateBucket.getJumboPositionType();
            return Streams.stream((Iterable)updateBucket.getChildren()).anyMatch(child -> child.getPositionType() != jumboPositionType);
        }).findAny().ifPresent(item -> {
            throw new BusinessRuleValidationException("Unterposition enth\u00e4lt unterschiedliche Unterpositionstypen", (List)ImmutableList.of());
        });
        return positionUpdateBuckets;
    }

    private static void mapQEntityRemarks(@NonNull StageUpdateRequest updateRequest, @NonNull Quotation stageUpdated) {
        if (updateRequest == null) {
            throw new NullPointerException("updateRequest is marked non-null but is null");
        }
        if (stageUpdated == null) {
            throw new NullPointerException("stageUpdated is marked non-null but is null");
        }
        QEntity prepareQEntity = stageUpdated.getQEntity();
        prepareQEntity.setRemarksAddendum(updateRequest.getRemarksAddendum());
        prepareQEntity.setRemarksCalculation(updateRequest.getRemarksCalculation());
        prepareQEntity.setRemarksCommission(updateRequest.getRemarksCommission());
        prepareQEntity.setRemarksCostEstimate(updateRequest.getRemarksCostEstimate());
        prepareQEntity.setRemarksInquiry(updateRequest.getRemarksInquiry());
        prepareQEntity.setRemarksQuotation(updateRequest.getRemarksQuotation());
    }

    private void validateChangeInQuantityFailing(@NonNull Quotation stageMerged, @NonNull Iterable<QStagePositionUpdateBucket> positionUpdateBuckets, @NonNull Iterable<Quotation> stages) {
        if (stageMerged == null) {
            throw new NullPointerException("stageMerged is marked non-null but is null");
        }
        if (positionUpdateBuckets == null) {
            throw new NullPointerException("positionUpdateBuckets is marked non-null but is null");
        }
        if (stages == null) {
            throw new NullPointerException("stages is marked non-null but is null");
        }
        Iterable failingDetails = this.validateChangeInQuantityNotFailing(stageMerged, positionUpdateBuckets, stages);
        if (!Iterables.isEmpty((Iterable)failingDetails)) {
            String detail = StringUtils.join((Iterable)failingDetails, (String)", ");
            int amount = Iterables.size((Iterable)failingDetails);
            String message = this.messageService.get((Translatable)EMessageKey.RULE_STAGE__POSITION__CHANGE_IN_QUANTITY__IS_NOT_EQUAL, new Object[]{amount, detail});
            List messages = (List)Streams.stream((Iterable)failingDetails).map((? super T item) -> {
                String msgText = this.messageService.get(item);
                return RequestValidationException.Detail.of((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.STAGE_POSITION__TYPE), (Object)EPositionType.CHANGE_IN_QUANTITY, (String)msgText, (Message)item, (List)ImmutableList.of());
            }).collect(ImmutableList.toImmutableList());
            throw new BusinessRuleValidationException(message, messages);
        }
    }

    @Nonnull
    private Iterable<Message> validateChangeInQuantityNotFailing(@NonNull Quotation stageMerged, @NonNull Iterable<QStagePositionUpdateBucket> positionUpdateBuckets, @NonNull Iterable<Quotation> stages) {
        ImmutableList changeInQuantityCandidates;
        if (stageMerged == null) {
            throw new NullPointerException("stageMerged is marked non-null but is null");
        }
        if (positionUpdateBuckets == null) {
            throw new NullPointerException("positionUpdateBuckets is marked non-null but is null");
        }
        if (stages == null) {
            throw new NullPointerException("stages is marked non-null but is null");
        }
        ImmutableList.Builder failingBuilder = ImmutableList.builder();
        EQStageType stageType = stageMerged.getStageType();
        if (Iterables.contains((Iterable)EQStageType.ADDENDUM_TYPES, (Object)stageType) && !Iterables.isEmpty((Iterable)(changeInQuantityCandidates = (ImmutableList)Streams.stream(positionUpdateBuckets).filter(item -> EPositionType.CHANGE_IN_QUANTITY == item.getPositionType()).collect(ImmutableList.toImmutableList())))) {
            Set stagesForAddendumCheck = (Set)Streams.stream(stages).filter(item -> item != stageMerged).filter(item -> Iterables.contains((Iterable)EQStageType.CHANGE_IN_QUANTITY_VALIDATION_STAGE_TYPES, (Object)item.getStageType())).collect(ImmutableSet.toImmutableSet());
            Collection allRelevantPos = (Collection)stagesForAddendumCheck.stream().flatMap(item -> ((Set)MoreObjects.firstNonNull((Object)item.getQuotationPositions(), (Object)ImmutableSet.of())).stream()).collect(ImmutableSet.toImmutableSet());
            ImmutableMap byId = Maps.uniqueIndex((Iterable)allRelevantPos, QuotationPosition::getId);
            for (QStagePositionUpdateBucket changeInQuantityCandidate : changeInQuantityCandidates) {
                Long referencePositionId = changeInQuantityCandidate.getUpdateItem().getReferencePositionId();
                QuotationPosition mainPosition = (QuotationPosition)byId.get(referencePositionId);
                String positionNumber = changeInQuantityCandidate.getUpdateItem().getPositionNumber();
                String shortText = changeInQuantityCandidate.getUpdateItem().getShortText();
                if (null == mainPosition) {
                    failingBuilder.add((Object)Message.of((EMessageKey)EMessageKey.RULE_STAGE__POSITION__CHANGE_IN_QUANTITY__NOT_EXISTING, (String)(positionNumber + "/" + shortText)));
                    continue;
                }
                boolean equal = StagePositionHelper.changeInQuantityEquality((QuotationPosition)mainPosition, (QStagePositionUpdateBucket)changeInQuantityCandidate);
                if (equal) continue;
                failingBuilder.add((Object)Message.of((EMessageKey)EMessageKey.RULE_STAGE__POSITION__CHANGE_IN_QUANTITY__IS_NOT_EQUAL, (String)(positionNumber + "/" + shortText)));
            }
        }
        return failingBuilder.build();
    }

    @Nonnull
    private Optional<StagePropagation> createStagePropagation(@NonNull Quotation source, @NonNull Quotation target, @NonNull Long batch, @NonNull Iterable<QuotationPosition> addedPositions, @NonNull Iterable<QuotationPosition> updatedPositions, @NonNull Iterable<QuotationPosition> removedPositions) {
        StagePropagationItem stagePropagationItem;
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (batch == null) {
            throw new NullPointerException("batch is marked non-null but is null");
        }
        if (addedPositions == null) {
            throw new NullPointerException("addedPositions is marked non-null but is null");
        }
        if (updatedPositions == null) {
            throw new NullPointerException("updatedPositions is marked non-null but is null");
        }
        if (removedPositions == null) {
            throw new NullPointerException("removedPositions is marked non-null but is null");
        }
        if (Objects.equals(source.getId(), target.getId())) {
            return Optional.empty();
        }
        StagePropagation stagePropagation = this.entityFactory.stagePropagation(batch);
        stagePropagation.setStageFrom(source);
        stagePropagation.setStageTo(target);
        ArrayList stagePropagationItems = Lists.newArrayList();
        for (QuotationPosition position : addedPositions) {
            stagePropagationItem = this.entityFactory.stagePropagationItem(position, EStagePropagationItemType.ADD);
            stagePropagationItems.add(stagePropagationItem);
        }
        for (QuotationPosition updatedPosition : updatedPositions) {
            stagePropagationItem = this.entityFactory.stagePropagationItem(updatedPosition, EStagePropagationItemType.UPDATE);
            stagePropagationItems.add(stagePropagationItem);
        }
        for (QuotationPosition position : removedPositions) {
            stagePropagationItem = this.entityFactory.stagePropagationItem(position, EStagePropagationItemType.REMOVE);
            stagePropagationItems.add(stagePropagationItem);
        }
        stagePropagationItems.forEach(item -> item.setStagePropagation(stagePropagation));
        stagePropagation.getItems().addAll(stagePropagationItems);
        return Optional.of((StagePropagation)this.stagePropagationHandler.update((EntityBase)stagePropagation));
    }

    @Nonnull
    private Iterable<Long> unequal(@NonNull Map<Long, Map<EStageHistoryField, Object>> left, @NonNull Map<Long, Map<EStageHistoryField, Object>> right) {
        if (left == null) {
            throw new NullPointerException("left is marked non-null but is null");
        }
        if (right == null) {
            throw new NullPointerException("right is marked non-null but is null");
        }
        ImmutableSet.Builder unequalBuilder = ImmutableSet.builder();
        Set<Long> leftKeys = left.keySet();
        Set<Long> rightKeys = right.keySet();
        Sets.SetView keys = Sets.intersection(leftKeys, rightKeys);
        block0: for (Long key : keys) {
            Map<EStageHistoryField, Object> leftValues = left.get(key);
            Map<EStageHistoryField, Object> rightValues = right.get(key);
            Set<EStageHistoryField> leftValuesKeys = leftValues.keySet();
            Set<EStageHistoryField> rightValuesKeys = rightValues.keySet();
            Sets.SetView valuesKeys = Sets.intersection(leftValuesKeys, rightValuesKeys);
            for (EStageHistoryField valuesKey : valuesKeys) {
                Object valueLeft = leftValues.get(valuesKey);
                Object valueRight = rightValues.get(valuesKey);
                boolean equal = valueLeft instanceof BigDecimal && valueRight instanceof BigDecimal ? 0 == ((BigDecimal)valueLeft).compareTo((BigDecimal)valueRight) : com.google.common.base.Objects.equal((Object)valueLeft, (Object)valueRight);
                if (equal) continue;
                unequalBuilder.add((Object)key);
                continue block0;
            }
        }
        return unequalBuilder.build();
    }

    @VisibleForTesting
    void validateOrInitCoverLetter(@NonNull Quotation stage, @Nullable Quotation primaryStage, @NonNull Map<Pair<EBoilerPlateKey, EQStageType>, String> boilerPlates) {
        boolean coverLetterBody3Changed;
        boolean coverLetterBody2Changed;
        boolean coverLetterBody1Changed;
        String coverLetterSubject1st;
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        if (boilerPlates == null) {
            throw new NullPointerException("boilerPlates is marked non-null but is null");
        }
        String stageNumber = stage.getQNumber();
        EQStageType stageType = stage.getStageType();
        if (stageType == EQStageType.COMMISSION__ADDENDUM || stageType == EQStageType.COST_UNIT__ADDENDUM) {
            String commissionStageNumber = null != primaryStage ? StringUtils.trimToEmpty((String)primaryStage.getQNumber()) : "";
            coverLetterSubject1st = this.messageService.get(EStagePrintBoilerPlate.STAGE__ADDENDUM_SUBJECT_1ST, new Object[]{stageNumber, commissionStageNumber});
        } else {
            String stageTypeAsText = this.messageService.get((Translatable)stageType, new Object[0]);
            coverLetterSubject1st = StringUtils.joinWith((String)" ", (Object[])new Object[]{stageTypeAsText, stageNumber});
        }
        boolean coverLetterSubject1stChanged = (Boolean)MoreObjects.firstNonNull((Object)stage.getCoverLetterSubject1stChanged(), (Object)false);
        if (!coverLetterSubject1stChanged) {
            stage.setCoverLetterSubject1st(coverLetterSubject1st);
        }
        String orderDescriptionCustomer = stage.getOrderDescriptionCustomer();
        boolean coverLetterSubject2ndChanged = (Boolean)MoreObjects.firstNonNull((Object)stage.getCoverLetterSubject2ndChanged(), (Object)false);
        if (!coverLetterSubject2ndChanged) {
            stage.setCoverLetterSubject2nd(orderDescriptionCustomer);
        }
        ContactPerson contactPerson = stage.getContactPerson();
        boolean coverLetterTitleChanged = (Boolean)MoreObjects.firstNonNull((Object)stage.getCoverLetterTitleChanged(), (Object)false);
        if (!coverLetterTitleChanged) {
            if (null != contactPerson) {
                String boilerPlateValueNoSex = boilerPlates.getOrDefault(Pair.of((Object)EBoilerPlateKey.STAGE__COVER_LETTER_TITLE_SEX_UNKNOWN, (Object)stageType), "");
                String boilerPlateValueMale = boilerPlates.getOrDefault(Pair.of((Object)EBoilerPlateKey.STAGE__COVER_LETTER_TITLE_SEX_MALE, (Object)stageType), "");
                String boilerPlateValueFemale = boilerPlates.getOrDefault(Pair.of((Object)EBoilerPlateKey.STAGE__COVER_LETTER_TITLE_SEX_FEMALE, (Object)stageType), "");
                String salutation = StringUtils.trimToEmpty((String)contactPerson.getSalutation());
                boolean isMale = MALE_TITLES.contains(StringUtils.trimToEmpty((String)StringUtils.lowerCase((String)salutation)));
                boolean isFemale = FEMALE_TITLES.contains(StringUtils.trimToEmpty((String)StringUtils.lowerCase((String)salutation)));
                String joinedValues = CustomerHelper.contactPersonText((ContactPerson)contactPerson, (boolean)false);
                String pattern = isMale ? boilerPlateValueMale : (isFemale ? boilerPlateValueFemale : boilerPlateValueNoSex);
                String coverletterTitle = String.format(pattern + ",", joinedValues);
                stage.setCoverLetterTitle(coverletterTitle);
            } else {
                String boilerPlateValueFemale = boilerPlates.getOrDefault(Pair.of((Object)EBoilerPlateKey.STAGE__COVER_LETTER_TITLE_NO_CONTACT_PERSON, (Object)stageType), "");
                String coverletterTitle = boilerPlateValueFemale + ",";
                stage.setCoverLetterTitle(coverletterTitle);
            }
        }
        if (!(coverLetterBody1Changed = ((Boolean)MoreObjects.firstNonNull((Object)stage.getCoverLetterBody1Changed(), (Object)false)).booleanValue())) {
            String boilerPlateValue = boilerPlates.getOrDefault(Pair.of((Object)EBoilerPlateKey.STAGE__COVER_LETTER_BODY_1, (Object)stageType), "");
            stage.setCoverLetterBody1(boilerPlateValue);
        }
        if (!(coverLetterBody2Changed = ((Boolean)MoreObjects.firstNonNull((Object)stage.getCoverLetterBody2Changed(), (Object)false)).booleanValue())) {
            String boilerPlateValue = boilerPlates.getOrDefault(Pair.of((Object)EBoilerPlateKey.STAGE__COVER_LETTER_BODY_2, (Object)stageType), "");
            BigDecimal financeVAT = (BigDecimal)MoreObjects.firstNonNull((Object)stage.getVatPercent(), (Object)BigDecimal.ZERO);
            String financeVATTxt = PrintHelper.asString((BigDecimal)financeVAT, (String)"0,00", (boolean)true);
            BigDecimal priceWithDiscountSum = stage.getPriceWithDiscountSum();
            BigDecimal vatValueWithDiscountSum = stage.getVatValueWithDiscountSum();
            BigDecimal valueGross = priceWithDiscountSum.add(vatValueWithDiscountSum);
            String valueGrossTxt = PrintHelper.asString((BigDecimal)valueGross, (String)"0,00", (boolean)true);
            String boilerPlateWithValue = MessageFormat.format(boilerPlateValue, financeVATTxt, valueGrossTxt);
            stage.setCoverLetterBody2(boilerPlateWithValue);
        }
        if (!(coverLetterBody3Changed = ((Boolean)MoreObjects.firstNonNull((Object)stage.getCoverLetterBody3Changed(), (Object)false)).booleanValue())) {
            String boilerPlateValue = boilerPlates.getOrDefault(Pair.of((Object)EBoilerPlateKey.STAGE__COVER_LETTER_BODY_3, (Object)stageType), "");
            stage.setCoverLetterBody3(boilerPlateValue);
        }
    }

    @Transactional
    @Nonnull
    public StageCommon update(@NonNull Long id, @NonNull StageAliasUpdateRequest aliasUpdateRequest) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (aliasUpdateRequest == null) {
            throw new NullPointerException("aliasUpdateRequest is marked non-null but is null");
        }
        Quotation stage = (Quotation)this.stageHandler.byIdFailing(id);
        ArrayList stagesToPatch = Lists.newArrayList();
        stagesToPatch.add(stage);
        EQStageType stageType = stage.getStageType();
        if (EQStageType.COMMISSION__COST_ESTIMATE == stageType) {
            this.stageHandler.costUnitsForCostEstimate(stage).ifPresent(stagesToPatch::add);
        } else if (EQStageType.COMMISSION__COST_UNIT__CE == stageType) {
            Quotation reference = stage.getReference();
            stagesToPatch.add(reference);
        }
        stagesToPatch.forEach(stageToPatch -> this.patchAlias(stageToPatch, aliasUpdateRequest));
        return this.mapper.mapToCommon(this.stageBucket(stage));
    }

    private void patchAlias(@NonNull Quotation stage, @NonNull StageAliasUpdateRequest aliasUpdateRequest) {
        int affectedRows;
        String aliasOld;
        boolean aliasChanged;
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        if (aliasUpdateRequest == null) {
            throw new NullPointerException("aliasUpdateRequest is marked non-null but is null");
        }
        Long id = stage.getId();
        StageHistorySnapShot stageHistorySnapShot = this.historyItemRoute.snapShot(stage);
        String aliasNew = StringUtils.trimToEmpty((String)aliasUpdateRequest.getAlias());
        boolean bl = aliasChanged = !StringUtils.equals((CharSequence)aliasNew, (CharSequence)(aliasOld = StringUtils.trimToEmpty((String)stage.getAlias())));
        if (aliasChanged && (affectedRows = this.stageHandler.patchAlias(id, aliasNew, Boolean.valueOf(aliasChanged))) > 0) {
            stage.setAlias(aliasNew);
            stage.setAliasChanged(Boolean.valueOf(aliasChanged));
        }
        this.historyItemRoute.persistChanges(stageHistorySnapShot, stage);
    }

    @Transactional
    @Nonnull
    public StageCommon update(@NonNull Long id, @NonNull StageProjectUpdateRequest projectUpdateRequest) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (projectUpdateRequest == null) {
            throw new NullPointerException("projectUpdateRequest is marked non-null but is null");
        }
        Boolean propagateProjectToAllStages = (Boolean)MoreObjects.firstNonNull((Object)projectUpdateRequest.getPropagateProjectToAllStages(), (Object)false);
        Long projectId = projectUpdateRequest.getProjectId();
        boolean hasIndividualPermission = this.userService.hasPrivilege(EPrivilege.Q_MODULE__STAGE__INDIVIDUAL_PROJECT_ASSIGNMENT);
        if (!propagateProjectToAllStages.booleanValue() && !hasIndividualPermission) {
            String privilegeTranslated = this.messageService.get((Translatable)EPrivilege.Q_MODULE__STAGE__INDIVIDUAL_PROJECT_ASSIGNMENT, new Object[0]);
            String message = this.messageService.get((Translatable)EMessageKey.SECURITY__QSTAGE__INDIVIDUAL_PROJECT__MISSING_PRIVILEGE, new Object[]{privilegeTranslated});
            throw new BusinessRuleValidationException(message, (List)ImmutableList.of());
        }
        Quotation stage = (Quotation)this.stageHandler.byIdFailing(id);
        Project project = null != projectId ? (Project)this.projectHandler.byIdFailing(projectId) : null;
        ImmutableSet.Builder stagesAffectedBuilder = ImmutableSet.builder();
        if (propagateProjectToAllStages.booleanValue()) {
            QEntity entity = stage.getQEntity();
            Set stages = (Set)MoreObjects.firstNonNull((Object)entity.getStages(), (Object)ImmutableSet.of());
            stagesAffectedBuilder.addAll((Iterable)stages);
        } else {
            stagesAffectedBuilder.add((Object)stage);
        }
        ImmutableSet stagesAffected = stagesAffectedBuilder.build();
        stagesAffected.forEach(item -> {
            StageHistorySnapShot stageHistorySnapShot = this.historyItemRoute.snapShot(item);
            int affectedRows = this.stageHandler.patchProject(id, project);
            if (affectedRows > 0) {
                item.setProject(project);
            }
            this.historyItemRoute.persistChanges(stageHistorySnapShot, item);
        });
        return this.mapper.mapToCommon(this.stageBucket(stage));
    }

    @Transactional
    @Nonnull
    public GaebImportResultListCommon fromFile(long id, @NonNull MultipartFile[] multiPartFiles, boolean optionAppend) {
        if (multiPartFiles == null) {
            throw new NullPointerException("multiPartFiles is marked non-null but is null");
        }
        ImmutableList.Builder gaebImportResultsBuilder = ImmutableList.builder();
        for (MultipartFile multipartFile : multiPartFiles) {
            this.handleMultiPart(Long.valueOf(id), multipartFile, optionAppend).ifPresent(arg_0 -> ((ImmutableList.Builder)gaebImportResultsBuilder).add(arg_0));
        }
        ImmutableList gaebExtractResults = gaebImportResultsBuilder.build();
        GaebImportResultListCommon gaebImportResultListCommon = this.mapper.mapGaeb((Iterable)gaebExtractResults);
        return gaebImportResultListCommon;
    }

    @Transactional
    @Nonnull
    public Pair<String, byte[]> printStage(long id, boolean preview, boolean flagPrintQuotation, boolean flagPrintCalculation, boolean flagPrintPaySheet, boolean flagPrintCostEstimate, @NonNull Map<String, String> allRequestParams, LocalDate overrideSubmissionOfBidDate) {
        if (allRequestParams == null) {
            throw new NullPointerException("allRequestParams is marked non-null but is null");
        }
        Class<StageRouteImpl> clazz = StageRouteImpl.class;
        synchronized (StageRouteImpl.class) {
            Pair wageResult;
            LocalDate submissionBidDate;
            this.validateReadAccess();
            Quotation stage = (Quotation)this.stageHandler.byIdFailing(Long.valueOf(id));
            LocalDate submissionOfBidOld = stage.getSubmissionOfBidDate();
            if (null != overrideSubmissionOfBidDate) {
                if (!Objects.equals(submissionOfBidOld, overrideSubmissionOfBidDate)) {
                    if (!preview) {
                        stage.setSubmissionOfBidDate(overrideSubmissionOfBidDate);
                        stage = this.stageHandler.update(stage);
                    }
                    submissionBidDate = overrideSubmissionOfBidDate;
                } else {
                    submissionBidDate = stage.getSubmissionOfBidDate();
                }
            } else {
                submissionBidDate = stage.getSubmissionOfBidDate();
            }
            Iterable printFeatures = PrintOptionHelper.stagePrintOptions(allRequestParams);
            ArrayList pdfDocuments = Lists.newArrayList();
            if (flagPrintQuotation) {
                Pair stageResult = this.generateStagePDF(stage, () -> submissionBidDate, printFeatures);
                pdfDocuments.add((byte[])stageResult.getValue());
            }
            if (flagPrintCalculation) {
                wageResult = this.generateCalculationPDF(stage, () -> submissionBidDate, printFeatures);
                pdfDocuments.add((byte[])wageResult.getValue());
            }
            if (flagPrintPaySheet) {
                wageResult = this.generateWagePDF(stage, () -> submissionBidDate, printFeatures);
                pdfDocuments.add((byte[])wageResult.getValue());
            }
            if (flagPrintCostEstimate) {
                wageResult = this.generateCostEstimatePDF(stage, () -> submissionBidDate, printFeatures);
                pdfDocuments.add((byte[])wageResult.getValue());
            }
            String stageIdString = Long.toString(stage.getId());
            String qNumber = stage.getQNumber();
            String dateForFile = this.dateTimeHelperService.dateForFile();
            String fileName = this.messageService.get((Translatable)EExportFileName.QSTAGE_AS_PDF, new Object[]{dateForFile, qNumber, stageIdString});
            try {
                ImmutableList documentsToMerge = ImmutableList.copyOf((Collection)pdfDocuments);
                User user = this.userService.authenticatedUser();
                String fullName = StringUtils.trimToEmpty((String)user.getFullName());
                byte[] merge = this.pdfHelperService.merge(fileName, fileName, fullName, (Iterable)ImmutableSet.copyOf((Collection)documentsToMerge));
                // ** MonitorExit[var10_9] (shouldn't be in output)
                return Pair.of((Object)fileName, (Object)merge);
            }
            catch (IOException e) {
                throw new PDFGenerationException("Could not merge Stage Documents");
            }
        }
    }

    @Transactional(readOnly=true)
    @Nonnull
    public Pair<String, byte[]> exportAsX84(@NonNull Long id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        Quotation stage = (Quotation)this.stageHandler.byIdFailing(id);
        String stageIdString = Long.toString(stage.getId());
        String qNumber = stage.getQNumber();
        String dateForFile = this.dateTimeHelperService.dateForFile();
        String fileName = this.messageService.get((Translatable)EExportFileName.QSTAGE_AS_X84, new Object[]{dateForFile, qNumber, stageIdString});
        GaebX84ExportResult result = this.gaebX84ExportService.generateX84(stage);
        byte[] buffer = result.getBuffer();
        return Pair.of((Object)fileName, (Object)buffer);
    }

    @Transactional(readOnly=true)
    @Nonnull
    public Pair<String, byte[]> exportAsXLSX(long id) throws IOException {
        ImmutableList stagesToBeExported;
        Quotation stage = (Quotation)this.stageHandler.byIdFailing(Long.valueOf(id));
        QEntity entity = stage.getQEntity();
        String stageIdString = Long.toString(stage.getId());
        String qNumber = stage.getQNumber();
        String dateForFile = this.dateTimeHelperService.dateForFile();
        String fileName = this.messageService.get((Translatable)EExportFileName.QSTAGE_AS_XLSX, new Object[]{dateForFile, qNumber, stageIdString});
        EQStageType stageType = stage.getStageType();
        if (stageType == EQStageType.COMMISSION) {
            TYPES_TO_BE_EXPORTED = ImmutableSet.of((Object)EQStageType.COMMISSION, (Object)EQStageType.COMMISSION__ADDENDUM, (Object)EQStageType.COST_UNIT__ADDENDUM);
            allStages = (Set)MoreObjects.firstNonNull((Object)entity.getStages(), (Object)ImmutableSet.of());
            stagesToBeExported = (ImmutableList)allStages.stream().filter(item -> TYPES_TO_BE_EXPORTED.contains((Object)item.getStageType())).filter(item -> Iterables.contains((Iterable)EQStageState.ALL_STATES_WITHOUT_ARCHIVED, (Object)item.getStageState())).collect(ImmutableList.toImmutableList());
        } else if (Iterables.contains((Iterable)EQStageType.COST_UNIT_TYPES, (Object)stageType)) {
            TYPES_TO_BE_EXPORTED = ImmutableSet.of((Object)EQStageType.COMMISSION__COST_UNIT, (Object)EQStageType.COST_UNIT__ADDENDUM);
            allStages = (Set)MoreObjects.firstNonNull((Object)entity.getStages(), (Object)ImmutableSet.of());
            stagesToBeExported = (ImmutableList)allStages.stream().filter(item -> TYPES_TO_BE_EXPORTED.contains((Object)item.getStageType())).filter(item -> Iterables.contains((Iterable)EQStageState.ACCOUNTABLE_STAGE_STATES, (Object)item.getStageState())).collect(ImmutableList.toImmutableList());
        } else {
            stagesToBeExported = ImmutableList.of((Object)stage);
        }
        String sheetName = stage.getQNumber();
        SXSSFWorkbook sheets = this.stageXlsExportService.detailXLS((Iterable)stagesToBeExported, sheetName);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        sheets.write((OutputStream)byteArrayOutputStream);
        byte[] buffer = byteArrayOutputStream.toByteArray();
        return Pair.of((Object)fileName, (Object)buffer);
    }

    @Transactional(readOnly=true)
    @Nonnull
    public StageAutoCompleteResponse standardAutoComplete(@Nullable Long stageId, @NonNull String filterText, @NonNull String autoCompleteModeCandidate, boolean includeAddendum) {
        if (filterText == null) {
            throw new NullPointerException("filterText is marked non-null but is null");
        }
        if (autoCompleteModeCandidate == null) {
            throw new NullPointerException("autoCompleteModeCandidate is marked non-null but is null");
        }
        EQStageAutoCompleteMode autoCompleteMode = EQStageAutoCompleteMode.lookup((String)autoCompleteModeCandidate, (EQStageAutoCompleteMode)EQStageAutoCompleteMode.ALL);
        ImmutableSet.Builder filterQEntitiesBuilder = ImmutableSet.builder();
        ImmutableSet.Builder filterVersionBuilder = ImmutableSet.builder();
        ImmutableSet.Builder stageTypeAndStatesBuilder = ImmutableSet.builder();
        if (EQStageAutoCompleteMode.ALL == autoCompleteMode) {
            stageTypeAndStatesBuilder.addAll(StageTypeAndState.from((Multimap)StageHelper.STAGE__ALL__COMMISSION_TYPE_AND_STATES));
        } else if (EQStageAutoCompleteMode.MEASUREMENT_ACTIVE == autoCompleteMode) {
            stageTypeAndStatesBuilder.addAll(StageTypeAndState.from((Multimap)StageHelper.MEASUREMENT_ACTIVE__QUOTATION_TYPE_AND_STATES, (boolean)true));
            stageTypeAndStatesBuilder.addAll(StageTypeAndState.from((Multimap)StageHelper.MEASUREMENT_ACTIVE__COMMISSION_TYPE_AND_STATES));
        } else if (EQStageAutoCompleteMode.MEASUREMENT_ALL == autoCompleteMode) {
            stageTypeAndStatesBuilder.addAll(StageTypeAndState.from((Multimap)StageHelper.MEASUREMENT_ALL__QUOTATION_TYPE_AND_STATES));
            stageTypeAndStatesBuilder.addAll(StageTypeAndState.from((Multimap)StageHelper.MEASUREMENT_ALL__COMMISSION_TYPE_AND_STATES));
        } else if (EQStageAutoCompleteMode.NAL == autoCompleteMode) {
            stageTypeAndStatesBuilder.addAll(StageTypeAndState.from((Multimap)StageHelper.NAL__QUOTATION_TYPE_AND_STATES));
            stageTypeAndStatesBuilder.addAll(StageTypeAndState.from((Multimap)StageHelper.NAL__COMMISSION_TYPE_AND_STATES));
        } else if (EQStageAutoCompleteMode.REPORT == autoCompleteMode) {
            if (includeAddendum) {
                stageTypeAndStatesBuilder.addAll(StageTypeAndState.from((Multimap)StageHelper.REPORT__QUOTATION_TYPES_AND_STATES));
                stageTypeAndStatesBuilder.addAll(StageTypeAndState.from((Multimap)StageHelper.REPORT__COMMISSION_WITH_ADDENDUM_TYPES_AND_STATES));
            } else {
                stageTypeAndStatesBuilder.addAll(StageTypeAndState.from((Multimap)StageHelper.REPORT__QUOTATION_TYPES_AND_STATES));
                stageTypeAndStatesBuilder.addAll(StageTypeAndState.from((Multimap)StageHelper.REPORT__COMMISSION_WITHOUT_ADDENDUM_TYPES_AND_STATES));
            }
        } else if (EQStageAutoCompleteMode.ACCOUNTING == autoCompleteMode) {
            stageTypeAndStatesBuilder.addAll(StageTypeAndState.from((Multimap)StageHelper.ACCOUNTING_COMMISSION_TYPES_AND_STATES));
        } else if (EQStageAutoCompleteMode.IMPORT == autoCompleteMode && null != stageId) {
            ImmutableSet versions;
            Quotation stage = (Quotation)this.stageHandler.byIdFailing(stageId);
            EQStageType stageType = stage.getStageType();
            Integer version = stage.getVersion();
            ImmutableSet immutableSet = versions = null != version ? ImmutableSet.of((Object)version) : ImmutableSet.of();
            if (EQStageType.CALCULATION == stageType || EQStageType.QUOTATION == stageType || EQStageType.COMMISSION__ADDENDUM == stageType || EQStageType.COST_UNIT__ADDENDUM == stageType) {
                stageTypeAndStatesBuilder.addAll(StageTypeAndState.from((Multimap)StageHelper.STAGE__IMPORT__CALCULATION_OR_QUOTATION__ADDENDUM__COMMISSION_TYPE_AND_STATES));
            } else if (Iterables.contains((Iterable)EQStageType.COST_UNIT_TYPES, (Object)stageType)) {
                filterQEntitiesBuilder.add((Object)stage.getQEntity());
                filterVersionBuilder.addAll((Iterable)versions);
                stageTypeAndStatesBuilder.addAll(StageTypeAndState.from((Multimap)StageHelper.STAGE__IMPORT__COST_UNIT__COMMISSION_TYPE_AND_STATES));
            } else if (EQStageType.COMMISSION__COST_ESTIMATE == stageType) {
                filterQEntitiesBuilder.add((Object)stage.getQEntity());
                filterVersionBuilder.addAll((Iterable)versions);
                stageTypeAndStatesBuilder.addAll(StageTypeAndState.from((Multimap)StageHelper.STAGE__IMPORT__COST_ESTIMATE__COMMISSION_TYPE_AND_STATES));
            }
        }
        ImmutableSet filterQEntities = filterQEntitiesBuilder.build();
        ImmutableSet filterVersions = filterVersionBuilder.build();
        ImmutableSet stageTypeAndStates = stageTypeAndStatesBuilder.build();
        Page stages = this.stageHandler.autoComplete(filterText, (Iterable)filterQEntities, (Iterable)filterVersions, (Iterable)stageTypeAndStates);
        return this.mapper.mapToAutoComplete(stages);
    }

    @Transactional(readOnly=true)
    @Nonnull
    public StagePositionPageCommon positions(@Nullable Long filterByStageId, @NonNull String filterStageText, @NonNull String filterText, @NonNull String sortOptionsCandidate) {
        if (filterStageText == null) {
            throw new NullPointerException("filterStageText is marked non-null but is null");
        }
        if (filterText == null) {
            throw new NullPointerException("filterText is marked non-null but is null");
        }
        if (sortOptionsCandidate == null) {
            throw new NullPointerException("sortOptionsCandidate is marked non-null but is null");
        }
        EQuotationPositionSortOption sortOption = EQuotationPositionSortOption.lookup((String)sortOptionsCandidate, (EQuotationPositionSortOption)EQuotationPositionSortOption.SEQUENTIAL_NUMBER_ASC);
        ImmutableSet filterStageIDs = null != filterByStageId ? ImmutableSet.of((Object)filterByStageId) : ImmutableSet.of();
        Page positions = this.stagePositionHandler.positions((Iterable)filterStageIDs, (Iterable)EQStageType.STAGE_IMPORTABLE_POSITION_TYPES, filterStageText, filterText);
        return this.positionMapper.mapToPageCommon(positions, sortOption);
    }

    @Transactional(readOnly=true)
    @Nonnull
    public StageFulfilmentDegreeSimpleCommon degreeOfFulfilment(@NonNull StageFulfilmentFilterRequest filterRequest) {
        boolean noStageSet;
        if (filterRequest == null) {
            throw new NullPointerException("filterRequest is marked non-null but is null");
        }
        boolean optionMergePositions = (Boolean)MoreObjects.firstNonNull((Object)filterRequest.getOptionMergePositions(), (Object)false);
        boolean optionMergeChangeInQuantity = (Boolean)MoreObjects.firstNonNull((Object)filterRequest.getOptionMergeChangeInQuantity(), (Object)false);
        boolean optionDisableDiscount = (Boolean)MoreObjects.firstNonNull((Object)filterRequest.getOptionDisableDiscount(), (Object)false);
        Range projectExecutionDateRange = DateRangeHelper.dateRange((LocalDate)filterRequest.getFilterProjectExecutionStart(), (LocalDate)filterRequest.getFilterProjectExecutionEnd());
        Iterable entityIds = StageRouteImpl.entryIdsOfType((StageFulfilmentFilterRequest)filterRequest, (EEntityClass)EEntityClass.ENTITY);
        Iterable stageIds = StageRouteImpl.entryIdsOfType((StageFulfilmentFilterRequest)filterRequest, (EEntityClass)EEntityClass.STAGE);
        Iterable subProjectIds = StageRouteImpl.entryIdsOfType((StageFulfilmentFilterRequest)filterRequest, (EEntityClass)EEntityClass.SUB_PROJECT);
        Iterable filterCostCenters = (Iterable)MoreObjects.firstNonNull((Object)filterRequest.getFilterCostCenters(), (Object)ImmutableList.of());
        Iterable assignedUserIds = (Iterable)MoreObjects.firstNonNull((Object)filterRequest.getFilterAssignedUserIds(), (Object)ImmutableList.of());
        Iterable stagePositions = (Iterable)MoreObjects.firstNonNull((Object)filterRequest.getQuotationPositionIds(), (Object)ImmutableList.of());
        boolean bl = noStageSet = Iterables.isEmpty((Iterable)entityIds) && Iterables.isEmpty((Iterable)stageIds) && Iterables.isEmpty((Iterable)subProjectIds);
        if (noStageSet) {
            return StageFulfilmentDegreeSimpleCommon.empty();
        }
        ImmutableSet.Builder allStagesBuilder = ImmutableSet.builder();
        Iterable entities = this.entityHandler.allByIds(entityIds);
        for (Object entity : entities) {
            Iterable stages = (Iterable)MoreObjects.firstNonNull((Object)entity.getStages(), (Object)ImmutableSet.of());
            for (Quotation stage : stages) {
                EQStageType stageType = stage.getStageType();
                if (!Iterables.contains((Iterable)EQStageType.DEGREE_OF_FULFILMENT_TYPES_ENTITY, (Object)stageType)) continue;
                allStagesBuilder.add((Object)stage);
            }
        }
        Iterable stages = this.stageHandler.allByIds(stageIds);
        allStagesBuilder.addAll(stages);
        for (Object stage : stages) {
            EQStageType stageType = stage.getStageType();
            if (!Iterables.contains((Iterable)EQStageType.COST_UNIT_TYPES, (Object)stageType) && EQStageType.COMMISSION != stageType) continue;
            QEntity stageEntity = stage.getQEntity();
            Set stageEntityStages = stageEntity.getStages();
            allStagesBuilder.addAll((Iterable)stageEntityStages.stream().filter(item -> Iterables.contains((Iterable)EQStageType.ADDENDUM_TYPES, (Object)item.getStageType())).collect(ImmutableList.toImmutableList()));
        }
        Iterable subProjects = this.subProjectHandler.allByIds(subProjectIds);
        block3: for (SubProject subProject : subProjects) {
            Set subProjectStages = subProject.getStages();
            allStagesBuilder.addAll((Iterable)subProjectStages);
            for (Quotation subProjectStage : subProjectStages) {
                EQStageType stageType = subProjectStage.getStageType();
                if (!Iterables.contains((Iterable)EQStageType.COST_UNIT_TYPES, (Object)stageType) && EQStageType.COMMISSION != stageType) continue;
                QEntity stageEntity = subProjectStage.getQEntity();
                Set stageEntityStages = stageEntity.getStages();
                allStagesBuilder.addAll((Iterable)stageEntityStages.stream().filter(item -> Iterables.contains((Iterable)EQStageType.ADDENDUM_TYPES, (Object)item.getStageType())).collect(ImmutableList.toImmutableList()));
                continue block3;
            }
        }
        ImmutableSet allStages = allStagesBuilder.build();
        if (!Iterables.isEmpty((Iterable)allStages)) {
            boolean stagesContainsEntity = !Iterables.isEmpty((Iterable)entityIds);
            return this.dataAggregationService.stageFulfilmentDegree((Iterable)allStages, stagePositions, assignedUserIds, projectExecutionDateRange, filterCostCenters, optionMergePositions, optionMergeChangeInQuantity, optionDisableDiscount, stagesContainsEntity);
        }
        return StageFulfilmentDegreeSimpleCommon.empty();
    }

    @Nonnull
    private static Iterable<Long> entryIdsOfType(@NonNull StageFulfilmentFilterRequest filterRequest, @NonNull EEntityClass entityClass) {
        if (filterRequest == null) {
            throw new NullPointerException("filterRequest is marked non-null but is null");
        }
        if (entityClass == null) {
            throw new NullPointerException("entityClass is marked non-null but is null");
        }
        List entries = (List)MoreObjects.firstNonNull((Object)filterRequest.getEntries(), (Object)ImmutableList.of());
        return (Iterable)entries.stream().filter(item -> StringUtils.equalsAnyIgnoreCase((CharSequence)item.getType(), (CharSequence[])new CharSequence[]{entityClass.getValue()})).map(StageFulfilmentFilterKVEntry::getId).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
    }

    @Transactional(readOnly=true)
    @Nonnull
    public StageFulfilmentDegreeSimpleCommon degreeOfFulfilment(long stageId, @NonNull StageFulfilmentFilterRequest filterRequest) {
        if (filterRequest == null) {
            throw new NullPointerException("filterRequest is marked non-null but is null");
        }
        boolean optionMergePositions = (Boolean)MoreObjects.firstNonNull((Object)filterRequest.getOptionMergePositions(), (Object)false);
        boolean optionMergeChangeInQuantity = (Boolean)MoreObjects.firstNonNull((Object)filterRequest.getOptionMergeChangeInQuantity(), (Object)false);
        boolean optionDisableDiscount = (Boolean)MoreObjects.firstNonNull((Object)filterRequest.getOptionDisableDiscount(), (Object)false);
        Iterable stagePositions = (Iterable)MoreObjects.firstNonNull((Object)filterRequest.getQuotationPositionIds(), (Object)ImmutableList.of());
        Range projectExecutionDateRange = DateRangeHelper.dateRange((LocalDate)filterRequest.getFilterProjectExecutionStart(), (LocalDate)filterRequest.getFilterProjectExecutionEnd());
        Quotation stage = (Quotation)this.stageHandler.byIdFailing(Long.valueOf(stageId));
        QEntity entity = stage.getQEntity();
        Iterable allStages = (Iterable)MoreObjects.firstNonNull((Object)entity.getStages(), (Object)ImmutableSet.of());
        return this.dataAggregationService.stageFulfilmentDegree(allStages, stagePositions, (Iterable)ImmutableList.of(), projectExecutionDateRange, (Iterable)ImmutableList.of(), optionMergePositions, optionMergeChangeInQuantity, optionDisableDiscount, false);
    }

    @Transactional(readOnly=true)
    public ReportResponse<?, ?> reportResponse(@NonNull Long stageId, @NonNull String reportCandidate) {
        if (stageId == null) {
            throw new NullPointerException("stageId is marked non-null but is null");
        }
        if (reportCandidate == null) {
            throw new NullPointerException("reportCandidate is marked non-null but is null");
        }
        Optional lookup = EReportType.lookup((String)reportCandidate);
        if (lookup.isPresent()) {
            EReportType reportType = (EReportType)lookup.get();
            switch (1.$SwitchMap$de$qfm$erp$service$model$internal$reporting$EReportType[reportType.ordinal()]) {
                case 1: {
                    Iterable measurementValues = this.measurementHandler.valueOverallOverTime(stageId);
                    Iterable invoiceValues = this.invoiceHandler.valueOverallOverTime(stageId);
                    ImmutableMap measurementValuesByMonth = Maps.uniqueIndex((Iterable)measurementValues, ReportDateBigDecimal::getReferenceDate);
                    ImmutableMap invoiceValuesByMonth = Maps.uniqueIndex((Iterable)invoiceValues, ReportDateBigDecimal::getReferenceDate);
                    ImmutableSortedSet allKeys = ImmutableSortedSet.naturalOrder().addAll((Iterable)measurementValuesByMonth.keySet()).addAll((Iterable)invoiceValuesByMonth.keySet()).build();
                    ImmutableList.Builder allValuesBuilder = ImmutableList.builder();
                    BigDecimal measurementValue = BigDecimal.ZERO;
                    BigDecimal invoiceValue = BigDecimal.ZERO;
                    for (LocalDate key : allKeys) {
                        ReportDateBigDecimal measurement = (ReportDateBigDecimal)measurementValuesByMonth.get((Object)key);
                        ReportDateBigDecimal invoice = (ReportDateBigDecimal)invoiceValuesByMonth.get((Object)key);
                        if (null != measurement) {
                            measurementValue = measurementValue.add(measurement.getValue());
                        }
                        if (null != invoice) {
                            invoiceValue = invoiceValue.add(invoice.getValue());
                        }
                        allValuesBuilder.add((Object)new ReportDateBigDecimalBigDecimal(key, measurementValue, invoiceValue));
                    }
                    ImmutableList allValues = allValuesBuilder.build();
                    return this.reportingMapper.map(reportType, (Iterable)allValues, "Aufma\u00dfe", ReportDateBigDecimalBigDecimal::getValue1, "Rechnungen", ReportDateBigDecimalBigDecimal::getValue2);
                }
            }
        }
        return ReportResponse.of((String)"unknown", (List)ImmutableList.of(), (List)ImmutableList.of(), (List)ImmutableList.of());
    }

    @Nonnull
    private Pair<String, byte[]> generateStagePDF(@NonNull Quotation stage, @NonNull Supplier<LocalDate> submissionOfBidDateSupplier, @NonNull Iterable<EStagePrintFeature> printFeatures) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        if (submissionOfBidDateSupplier == null) {
            throw new NullPointerException("submissionOfBidDateSupplier is marked non-null but is null");
        }
        if (printFeatures == null) {
            throw new NullPointerException("printFeatures is marked non-null but is null");
        }
        long qStageId = stage.getId();
        EStagePositionSortOption stagePositionSortOption = stage.getStagePositionSortOption();
        boolean printChild = Iterables.contains(printFeatures, (Object)EStagePrintFeature.OPTION_QUOTATION_PRINT_CHILD);
        com.google.common.base.Function printGroupFunction = stagePositionSortOption == EStagePositionSortOption.AUTOMATIC ? item -> this.stagePrintMapper.printGroupsGrouped(item, printChild) : item -> this.stagePrintMapper.printGroupsUngrouped(item, printChild);
        ConfigurationCompany configurationCompany = this.configurationCompanyHandler.getDefaultFailing();
        User user = this.userService.authenticatedUser();
        QStagePrintInfo printInfo = this.stagePrintMapper.stagePrintInfo(configurationCompany, stage, user, submissionOfBidDateSupplier, printFeatures, (Function)printGroupFunction);
        QStagePrintConfiguration printConfiguration = QStagePrintConfiguration.of((Color)Color.BLACK, (Iterable)ImmutableList.of(), (LocalDate)DateTimeHelper.today());
        byte[] stagePdf = this.stagePrintService.generatePDF(printInfo, printConfiguration, EPrintFontSize.DEFAULT, configurationCompany);
        String qNumber = stage.getQNumber();
        String dateForFile = this.dateTimeHelperService.dateForFile();
        String fileName = this.messageService.get((Translatable)EExportFileName.QSTAGE_AS_PDF, new Object[]{dateForFile, qNumber, qStageId});
        return Pair.of((Object)fileName, (Object)stagePdf);
    }

    @Nonnull
    private Pair<String, byte[]> generateCalculationPDF(@NonNull Quotation quotation, @NonNull Supplier<LocalDate> submissionOfBidDateSupplier, @NonNull Iterable<EStagePrintFeature> printFeatures) {
        if (quotation == null) {
            throw new NullPointerException("quotation is marked non-null but is null");
        }
        if (submissionOfBidDateSupplier == null) {
            throw new NullPointerException("submissionOfBidDateSupplier is marked non-null but is null");
        }
        if (printFeatures == null) {
            throw new NullPointerException("printFeatures is marked non-null but is null");
        }
        long qStageId = quotation.getId();
        ConfigurationCompany configurationCompany = this.configurationCompanyHandler.getDefaultFailing();
        User user = this.userService.authenticatedUser();
        boolean printChild = Iterables.contains(printFeatures, (Object)EStagePrintFeature.OPTION_QUOTATION_PRINT_CHILD);
        com.google.common.base.Function printGroupFunction = item -> this.stagePrintMapper.printGroupsGrouped(item, printChild);
        QStagePrintInfo printInfo = this.stagePrintMapper.stagePrintInfo(configurationCompany, quotation, user, submissionOfBidDateSupplier, printFeatures, (Function)printGroupFunction);
        QStagePrintConfiguration printConfiguration = QStagePrintConfiguration.of((Color)Color.BLACK, (Iterable)ImmutableList.of(), (LocalDate)DateTimeHelper.today());
        byte[] wagePDF = this.calculationPrintService.generatePDF(printInfo, printConfiguration, EPrintFontSize.DEFAULT, configurationCompany);
        String qNumber = quotation.getQNumber();
        String dateForFile = this.dateTimeHelperService.dateForFile();
        String fileName = this.messageService.get((Translatable)EExportFileName.QSTAGE_AS_PDF, new Object[]{dateForFile, qNumber, qStageId});
        return Pair.of((Object)fileName, (Object)wagePDF);
    }

    @Nonnull
    private Pair<String, byte[]> generateWagePDF(@NonNull Quotation quotation, @NonNull Supplier<LocalDate> submissionOfBidDateSupplier, @NonNull Iterable<EStagePrintFeature> printFeatures) {
        if (quotation == null) {
            throw new NullPointerException("quotation is marked non-null but is null");
        }
        if (submissionOfBidDateSupplier == null) {
            throw new NullPointerException("submissionOfBidDateSupplier is marked non-null but is null");
        }
        if (printFeatures == null) {
            throw new NullPointerException("printFeatures is marked non-null but is null");
        }
        long qStageId = quotation.getId();
        ConfigurationCompany configurationCompany = this.configurationCompanyHandler.getDefaultFailing();
        User user = this.userService.authenticatedUser();
        boolean printChild = Iterables.contains(printFeatures, (Object)EStagePrintFeature.OPTION_QUOTATION_PRINT_CHILD);
        com.google.common.base.Function printGroupFunction = item -> this.stagePrintMapper.printGroupsGrouped(item, printChild);
        QStagePrintInfo printInfo = this.stagePrintMapper.stagePrintInfo(configurationCompany, quotation, user, submissionOfBidDateSupplier, printFeatures, (Function)printGroupFunction);
        QStagePrintConfiguration printConfiguration = QStagePrintConfiguration.of((Color)Color.BLACK, (Iterable)ImmutableList.of(), (LocalDate)DateTimeHelper.today());
        byte[] wagePDF = this.wagesPrintService.generatePDF(printInfo, printConfiguration, EPrintFontSize.DEFAULT, configurationCompany);
        String qNumber = quotation.getQNumber();
        String dateForFile = this.dateTimeHelperService.dateForFile();
        String fileName = this.messageService.get((Translatable)EExportFileName.QSTAGE_AS_PDF, new Object[]{dateForFile, qNumber, qStageId});
        return Pair.of((Object)fileName, (Object)wagePDF);
    }

    @Nonnull
    private Pair<String, byte[]> generateCostEstimatePDF(@NonNull Quotation quotation, @NonNull Supplier<LocalDate> submissionOfBidDateSupplier, @NonNull Iterable<EStagePrintFeature> printFeatures) {
        if (quotation == null) {
            throw new NullPointerException("quotation is marked non-null but is null");
        }
        if (submissionOfBidDateSupplier == null) {
            throw new NullPointerException("submissionOfBidDateSupplier is marked non-null but is null");
        }
        if (printFeatures == null) {
            throw new NullPointerException("printFeatures is marked non-null but is null");
        }
        long qStageId = quotation.getId();
        ConfigurationCompany configurationCompany = this.configurationCompanyHandler.getDefaultFailing();
        User user = this.userService.authenticatedUser();
        boolean printChild = Iterables.contains(printFeatures, (Object)EStagePrintFeature.OPTION_QUOTATION_PRINT_CHILD);
        com.google.common.base.Function printGroupFunction = item -> this.stagePrintMapper.printGroupsUngrouped(item, printChild);
        QStagePrintInfo printInfo = this.stagePrintMapper.stagePrintInfo(configurationCompany, quotation, user, submissionOfBidDateSupplier, printFeatures, (Function)printGroupFunction);
        QStagePrintConfiguration printConfiguration = QStagePrintConfiguration.of((Color)Color.BLACK, (Iterable)ImmutableList.of(), (LocalDate)DateTimeHelper.today());
        byte[] wagePDF = this.costEstimatePrintService.generatePDF(printInfo, printConfiguration, EPrintFontSize.DEFAULT, configurationCompany);
        String qNumber = quotation.getQNumber();
        String dateForFile = this.dateTimeHelperService.dateForFile();
        String fileName = this.messageService.get((Translatable)EExportFileName.QSTAGE_AS_PDF, new Object[]{dateForFile, qNumber, qStageId});
        return Pair.of((Object)fileName, (Object)wagePDF);
    }

    @Nonnull
    private Optional<GaebImportResult> handleMultiPart(Long qStageId, @NonNull MultipartFile multiPartFile, boolean optionAppend) {
        if (multiPartFile == null) {
            throw new NullPointerException("multiPartFile is marked non-null but is null");
        }
        Quotation quotation = (Quotation)this.stageHandler.byIdFailing(qStageId);
        log.info("QState.BOQ: Received File: {}, size: {}", (Object)multiPartFile.getOriginalFilename(), (Object)multiPartFile.getSize());
        try {
            String originalFilename = StringUtils.trimToEmpty((String)multiPartFile.getOriginalFilename());
            String contentType = multiPartFile.getContentType();
            byte[] bytes = multiPartFile.getBytes();
            log.info("originalFilename: {}", (Object)originalFilename);
            log.info("contentType: {}", (Object)contentType);
            EGaebType gaebType = StageRouteImpl.detectGaebType((String)originalFilename, (String)contentType, (byte[])bytes);
            if (EGaebType.X83 == gaebType || EGaebType.X81 == gaebType) {
                return this.handleGaebX81orX83(multiPartFile, quotation, originalFilename, optionAppend);
            }
            if (EGaebType.X84 == gaebType) {
                return this.handleGaebX84(multiPartFile, quotation, originalFilename, optionAppend);
            }
            QuotationBoQ quotationBoQ = this.entityFactory.quotationBoQ();
            FileStore fileStore = this.fileStoreMapper.merge(this.entityFactory.fileStore(), multiPartFile);
            FileStore fileStoreUpdated = (FileStore)this.fileStoreHandler.update((EntityBase)fileStore);
            quotationBoQ.setBoqFile(fileStoreUpdated);
            quotationBoQ.setBoqProjectName(originalFilename + " nicht lesbar");
            quotationBoQ.setBoqProjectLabel(originalFilename + " nicht lesbar");
            quotationBoQ.setBoqDescription(originalFilename + " nicht lesbar");
            if (null == quotation.getQuotationBoQs()) {
                quotation.setQuotationBoQs((Set)Sets.newHashSet());
            }
            Set quotationBoQs = quotation.getQuotationBoQs();
            quotationBoQs.add(quotationBoQ);
            quotationBoQ.setQuotation(quotation);
            quotation.setLastQuotationBoQ(quotationBoQ);
            Quotation quotation2 = this.updateAndEmitChangeMessage(quotation);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return Optional.empty();
    }

    @Nonnull
    private static EGaebType detectGaebType(@NonNull String fileName, @NonNull String contentType, byte[] buffer) {
        if (fileName == null) {
            throw new NullPointerException("fileName is marked non-null but is null");
        }
        if (contentType == null) {
            throw new NullPointerException("contentType is marked non-null but is null");
        }
        boolean correctContentType = GAEB_CONTENT_TYPES.contains(contentType);
        boolean correctFileSuffix = GAEB_FILE_SUFFIXES.contains(StringUtils.lowerCase((String)StringUtils.substringAfterLast((String)fileName, (String)".")));
        log.info("correctContentType: {}", (Object)correctContentType);
        log.info("correctFileSuffix: {}", (Object)correctFileSuffix);
        int maxLength = Math.min(buffer.length, 2500);
        String supposedHeader = new String(buffer, 0, maxLength, StandardCharsets.UTF_8);
        boolean hasHeader = StringUtils.contains((CharSequence)supposedHeader, (CharSequence)"<GAEB");
        log.info("hasHeader: {}", (Object)hasHeader);
        boolean isX81 = StringUtils.contains((CharSequence)supposedHeader, (CharSequence)"<DP>81</DP>");
        boolean isX83 = StringUtils.contains((CharSequence)supposedHeader, (CharSequence)"<DP>83</DP>");
        boolean isX84 = StringUtils.contains((CharSequence)supposedHeader, (CharSequence)"<DP>84</DP>");
        if (hasHeader && isX81) {
            return EGaebType.X81;
        }
        if (hasHeader && isX83) {
            return EGaebType.X83;
        }
        if (hasHeader && isX84) {
            return EGaebType.X84;
        }
        return EGaebType.UNKNOWN;
    }

    @Nonnull
    public Optional<GaebImportResult> handleGaebX81orX83(@NonNull MultipartFile multiPartFile, @NonNull Quotation quotation, @NonNull String originalFilename, boolean optionAppend) throws IOException {
        if (multiPartFile == null) {
            throw new NullPointerException("multiPartFile is marked non-null but is null");
        }
        if (quotation == null) {
            throw new NullPointerException("quotation is marked non-null but is null");
        }
        if (originalFilename == null) {
            throw new NullPointerException("originalFilename is marked non-null but is null");
        }
        byte[] fileContent = multiPartFile.getBytes();
        GaebExtractResult gaebExtractResult = this.gaebX83ImportService.handleX83(fileContent);
        log.info("QState.BOQ: Read File to GAEB");
        return this.handleGaeb(multiPartFile, quotation, originalFilename, gaebExtractResult, optionAppend);
    }

    @Nonnull
    public Optional<GaebImportResult> handleGaebX84(@NonNull MultipartFile multiPartFile, @NonNull Quotation quotation, @NonNull String originalFilename, boolean optionAppend) throws IOException {
        if (multiPartFile == null) {
            throw new NullPointerException("multiPartFile is marked non-null but is null");
        }
        if (quotation == null) {
            throw new NullPointerException("quotation is marked non-null but is null");
        }
        if (originalFilename == null) {
            throw new NullPointerException("originalFilename is marked non-null but is null");
        }
        byte[] fileContent = multiPartFile.getBytes();
        GaebExtractResult gaebExtractResult = this.gaebX84ImportService.handleX84(fileContent);
        log.info("QState.BOQ: Read File to GAEB");
        return this.handleGaeb(multiPartFile, quotation, originalFilename, gaebExtractResult, optionAppend);
    }

    @Transactional(readOnly=true)
    @Nonnull
    public Pair<String, byte[]> billOfQuantitiesMeasurementTemplateById(long id) throws IOException {
        this.userService.checkPrivilege(EPrivilege.QUOTATION__BOQ_MEASUREMENT_DOWNLOAD_ALLOW);
        Quotation stage = (Quotation)this.stageHandler.byIdFailing(Long.valueOf(id));
        Map quotationIterableMap = this.stageHandler.allPositionStages(stage, ECostUnitCEViewMode.COMMISSION__COST_UNIT_CE, true);
        Stream<BillOfQuantitiesMeasurementExport> boqStream = quotationIterableMap.values().stream().flatMap(IterableHelper::stream).sorted(QuotationPositionGroupingLevelComparator.of((boolean)true)).map(arg_0 -> this.map(arg_0));
        try (InputStream fis = FileHelper.fisFromResource(this.getClass(), (String)"/xls/BillOfQuantities_Measurement_XLS_Template.xlsx");){
            Pair pair;
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                XSSFWorkbook template = new XSSFWorkbook(fis);
                String companyName = this.companyConfig.getCompanyName();
                String quotationNumber = StageHelper.quotationOrStageNumber((Quotation)stage);
                String stageAlias = StringUtils.trimToEmpty((String)stage.getAlias());
                Integer stageVersion = stage.getVersion();
                String stageVersionText = null != stageVersion ? Integer.toString(stageVersion) : "";
                XSSFWorkbook sxssfWorkbook = this.billOfQuantitiesMeasurementXlsExportService.detailXLS(template, companyName, "Aufmass", "Positionen", quotationNumber, stageAlias, stageVersionText, boqStream);
                sxssfWorkbook.setActiveSheet(0);
                sxssfWorkbook.write((OutputStream)bos);
                byte[] bytes = bos.toByteArray();
                String dateForFile = this.dateTimeHelperService.dateForFile();
                String fileName = this.messageService.get((Translatable)EExportFileName.QUOTATION__BOQ_MEASUREMENT_TEMPLATE_AS_XLSX, new Object[]{dateForFile, quotationNumber});
                pair = Pair.of((Object)fileName, (Object)bytes);
            }
            return pair;
        }
    }

    @Nonnull
    @Transactional
    public StageCommon ensureCorrectionPosition(long stageId) {
        Quotation stage = (Quotation)this.stageHandler.byIdFailing(Long.valueOf(stageId));
        QEntity entity = stage.getQEntity();
        Quotation primaryStage = entity.getPrimaryStage();
        Quotation relevantStage = (Quotation)MoreObjects.firstNonNull((Object)primaryStage, (Object)stage);
        Pair quotationWithCPPosition = this.internalEnsureCorrectionPosition(relevantStage);
        QuotationBucket quotationBucket = this.stageBucket((Quotation)quotationWithCPPosition.getLeft());
        return this.mapper.mapToCommon(quotationBucket);
    }

    @Transactional
    @Nonnull
    public List<StagePositionCommon> correctionPosition(long stageId) {
        Quotation stage = (Quotation)this.stageHandler.byIdFailing(Long.valueOf(stageId));
        QEntity entity = stage.getQEntity();
        Quotation primaryStage = entity.getPrimaryStage();
        Quotation relevantStage = (Quotation)MoreObjects.firstNonNull((Object)primaryStage, (Object)stage);
        Pair quotationWithCPPosition = this.internalEnsureCorrectionPosition(relevantStage);
        Quotation stageWithCP = (Quotation)quotationWithCPPosition.getLeft();
        Iterable cpPositions = (Iterable)quotationWithCPPosition.getRight();
        return ImmutableList.copyOf((Iterable)this.positionMapper.mapCPPositions(stageWithCP, cpPositions));
    }

    @Transactional(readOnly=true)
    @Nonnull
    public StringListResponse personResponsibleAtClient(long id, @NonNull String filterText) {
        if (filterText == null) {
            throw new NullPointerException("filterText is marked non-null but is null");
        }
        List usedInQuotation = this.personAutoCompleteHandler.quotationContactPerson(id, filterText);
        List usedInMeasurements = this.personAutoCompleteHandler.personResponsibleAtClientInMeasurementWithQuotation(id, filterText);
        ImmutableSet.Builder allBuilder = ImmutableSet.builder();
        allBuilder.addAll((Iterable)usedInQuotation);
        allBuilder.addAll((Iterable)usedInMeasurements);
        ImmutableSet all = allBuilder.build();
        return new StringListResponse(all.size(), (List)ImmutableList.sortedCopyOf((Iterable)all));
    }

    @Transactional
    public Pair<String, byte[]> downloadNotExportedER2() {
        ArrayList allRows = Lists.newArrayList();
        Iterable stagesNotPushed = this.stageHandler.notExportedToDMS(1000);
        for (Quotation stage : stagesNotPushed) {
            Pair export = this.export(stage, false);
            Iterable right = (Iterable)export.getRight();
            right.forEach(allRows::add);
        }
        byte[] bytes = ER2Helper.asBytes((Iterable)allRows);
        String fileName = DateTimeHelper.toIsoDate((LocalDate)DateTimeHelper.today()) + "_KTR.er2";
        return Pair.of((Object)fileName, (Object)bytes);
    }

    @Transactional
    public boolean pushToDMS() {
        Iterable stagesNotPushed = this.stageHandler.notExportedToDMS(3);
        for (Quotation stage : stagesNotPushed) {
            this.export(stage, true);
        }
        return true;
    }

    @Transactional
    @Nonnull
    public StageFileListCommon filesById(@NonNull Long id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        Quotation stage = (Quotation)this.stageHandler.byIdFailing(id);
        return this.filesByStage(stage);
    }

    @Nonnull
    public Pair<String, byte[]> urlFile(@NonNull Long id, @NonNull String referencePath) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (referencePath == null) {
            throw new NullPointerException("referencePath is marked non-null but is null");
        }
        Quotation stage = (Quotation)this.stageHandler.byIdFailing(id);
        QEntity entity = stage.getQEntity();
        EQStageType stageType = stage.getStageType();
        String referencePathUse = StringUtils.isBlank((CharSequence)referencePath) && Iterables.contains((Iterable)EQStageType.STAGE_FOLDER_TYPES, (Object)stageType) ? stage.getQNumber() : referencePath;
        String absoluteClientHomeFolder = entity.getAbsoluteClientHomeFolder();
        String absoluteServerHomeFolder = entity.getAbsoluteServerHomeFolder();
        Path serverUrlPath = Path.of(absoluteServerHomeFolder, referencePathUse);
        Path clientUrlPath = serverUrlPath.toFile().exists() ? Path.of(absoluteClientHomeFolder, referencePathUse) : Path.of(absoluteClientHomeFolder, new String[0]);
        String clientFolderPath = clientUrlPath.toString();
        String normalizedClientFolderPath = StringUtils.replace((String)clientFolderPath, (String)"\\", (String)"/");
        String content = "[InternetShortcut]\nURL=file://" + normalizedClientFolderPath;
        return Pair.of((Object)("Q-" + id + ".url"), (Object)content.getBytes(StandardCharsets.UTF_8));
    }

    @Nonnull
    private Pair<Quotation, Iterable<Iterable<String>>> export(@NonNull Quotation stage, boolean pushToDiamant) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        Iterable er2Rows = this.stageEr2CostUnitExportService.generate(stage);
        long id = stage.getId();
        String stageNumber = stage.getQNumber();
        EQStageType stageType = stage.getStageType();
        EQStageState stageState = stage.getStageState();
        if (pushToDiamant) {
            byte[] bytes = ER2Helper.asBytes((Iterable)er2Rows);
            StageER2Bucket stageER2Bucket = StageER2Bucket.of((long)id, (EQStageType)stageType, (EQStageState)stageState, (String)stageNumber, (byte[])bytes);
            StageER2Result stageER2Result = this.diamantER2Service.pushSilent(stageER2Bucket);
            if (stageER2Result.isStored()) {
                stage.setEr2ExportedOn(DateTimeHelper.now());
                stage.setEr2ExportedToPath(stageER2Result.getFullPath());
                stage.setEr2ExportState(EER2ExportState.EXPORTED);
                this.stageHandler.patchER2(Long.valueOf(id), stage.getEr2ExportedOn(), stage.getEr2ExportedToPath(), stage.getEr2ExportState());
            }
        } else {
            stage.setEr2ExportedOn(DateTimeHelper.now());
            stage.setEr2ExportedToPath("[downloaded]");
            stage.setEr2ExportState(EER2ExportState.EXPORTED);
            this.stageHandler.patchER2(Long.valueOf(id), stage.getEr2ExportedOn(), stage.getEr2ExportedToPath(), stage.getEr2ExportState());
        }
        return Pair.of((Object)stage, (Object)er2Rows);
    }

    @Nonnull
    private Pair<Quotation, Iterable<QuotationPosition>> internalEnsureCorrectionPosition(@NonNull Quotation stage) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        Iterable quotationPositions = (Iterable)MoreObjects.firstNonNull((Object)stage.getQuotationPositions(), (Object)ImmutableList.of());
        Iterable correctionPositions = (Iterable)Streams.stream((Iterable)quotationPositions).filter(item -> EPositionType.CORRECTION == item.getPositionType()).collect(ImmutableList.toImmutableList());
        if (Iterables.isEmpty((Iterable)correctionPositions)) {
            QuotationPosition stagePosition = this.entityFactory.quotationPosition();
            stagePosition.setAlternativePositionType(EAlternativePositionType.YES__EXCLUDE_FROM_CALCULATION);
            stagePosition.setPositionType(EPositionType.CORRECTION);
            stagePosition.setJumboPositionType(EPositionType.UNKNOWN);
            stagePosition.setPricePerUnit(BigDecimal.ONE);
            stagePosition.setMaterialSellingPricePerUnit(BigDecimal.ONE);
            stagePosition.setMaterialSellingPriceAggregated(BigDecimal.ONE);
            stagePosition.setMaterialPercentage(BigDecimal.ZERO);
            stagePosition.setAggregatedPercentage(BigDecimal.ZERO);
            stagePosition.setPriceAggregated(BigDecimal.ZERO);
            stagePosition.setWagePerUnit(BigDecimal.ZERO);
            stagePosition.setOrderedAmount(BigDecimal.ZERO);
            stagePosition.setWagePercentage(BigDecimal.ZERO);
            stagePosition.setCompanyWagePerItem(BigDecimal.ZERO);
            stagePosition.setCompanyWageAggregated(BigDecimal.ZERO);
            stagePosition.setMaterialWholesalePriceDiscount(BigDecimal.ZERO);
            stagePosition.setMaterialWholesalePriceIncludingDiscountPerItem(BigDecimal.ZERO);
            stagePosition.setMaterialWholesalePriceExcludingDiscountPerItem(BigDecimal.ZERO);
            stagePosition.setMaterialWholesalePriceIncludingDiscountAggregated(BigDecimal.ZERO);
            stagePosition.setMaterialWholesalePriceExcludingDiscountAggregated(BigDecimal.ZERO);
            stagePosition.setInternalWageAggregated(BigDecimal.ZERO);
            stagePosition.setSquadWagePerUnit(BigDecimal.ZERO);
            stagePosition.setWagePerUnit(BigDecimal.ZERO);
            stagePosition.setExternalServicePurchasePricePerUnit(BigDecimal.ZERO);
            stagePosition.setExternalServicePurchasePriceAggregated(BigDecimal.ZERO);
            stagePosition.setExternalServicePercentage(BigDecimal.ZERO);
            stagePosition.setExternalServiceSellingPricePerUnit(BigDecimal.ZERO);
            stagePosition.setExternalServiceSellingPriceAggregated(BigDecimal.ZERO);
            stagePosition.setShortText("Korrektur Position 1 EUR");
            stagePosition.setLongText("Korrektur Position 1 EUR");
            stagePosition.setPositionNumber("KP_1EUR");
            stagePosition.setUnitAmount(BigDecimal.ONE);
            stagePosition.setUnit("");
            stagePosition.setSurrogatePositionNumber("KP_1EUR");
            stagePosition.setSequenceNumberQuotationStandard(Integer.valueOf(Integer.MAX_VALUE));
            stagePosition.setQuotation(stage);
            stage.getQuotationPositions().add(stagePosition);
            Quotation quotationUpdated = this.stageHandler.update(stage);
            Iterable quotationPositionsUpdated = (Iterable)MoreObjects.firstNonNull((Object)quotationUpdated.getQuotationPositions(), (Object)ImmutableList.of());
            Iterable correctionPositionsUpdated = (Iterable)Streams.stream((Iterable)quotationPositionsUpdated).filter(item -> EPositionType.CORRECTION == item.getPositionType()).collect(ImmutableList.toImmutableList());
            return Pair.of((Object)quotationUpdated, (Object)correctionPositionsUpdated);
        }
        return Pair.of((Object)stage, (Object)correctionPositions);
    }

    @Nonnull
    private Optional<GaebImportResult> handleGaeb(@NonNull MultipartFile multiPartFile, @NonNull Quotation stage, @NonNull String originalFilename, @NonNull GaebExtractResult gaebExtractResult, boolean optionAppend) throws IOException {
        Object quotationPositions;
        if (multiPartFile == null) {
            throw new NullPointerException("multiPartFile is marked non-null but is null");
        }
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        if (originalFilename == null) {
            throw new NullPointerException("originalFilename is marked non-null but is null");
        }
        if (gaebExtractResult == null) {
            throw new NullPointerException("gaebExtractResult is marked non-null but is null");
        }
        QuotationBoQ quotationBoQ = this.entityFactory.quotationBoQ();
        FileStore fileStore = this.fileStoreMapper.merge(this.entityFactory.fileStore(), multiPartFile);
        FileStore fileStoreUpdated = (FileStore)this.fileStoreHandler.update((EntityBase)fileStore);
        quotationBoQ.setBoqFile(fileStoreUpdated);
        log.info("QState.BOQ: Stored File: {}", (Object)fileStore.getUuid());
        LinkedHashSet importErrors = Sets.newLinkedHashSet();
        String projectName = gaebExtractResult.getProjectName();
        String projectLabel = gaebExtractResult.getProjectLabel();
        String projectCurrency = gaebExtractResult.getProjectCurrency();
        String projectCurrencyLabel = gaebExtractResult.getProjectCurrencyLabel();
        quotationBoQ.setBoqProjectName(projectName);
        quotationBoQ.setBoqProjectLabel(projectLabel);
        stage.setX83ProjectName(projectName);
        stage.setX83ProjectLabel(projectLabel);
        stage.setX83ProjectCurrency(projectCurrency);
        stage.setX83ProjectCurrencyLabel(projectCurrencyLabel);
        LocalDate boqInfoDate = gaebExtractResult.getBoqDate();
        stage.setX83BoqInfoDate(boqInfoDate);
        String awardInfoCurrency = gaebExtractResult.getAwardInfoCurrency();
        String awardInfoCurrencyLabel = gaebExtractResult.getAwardInfoCurrencyLabel();
        stage.setX83BoqAwardCurrency(awardInfoCurrency);
        stage.setX83BoqAwardCurrencyLabel(awardInfoCurrencyLabel);
        Iterable levelFormats = gaebExtractResult.getLevelFormats();
        int i = 0;
        for (Object levelFormat : levelFormats) {
            if (1 == ++i) {
                stage.setHeadlineG1Set(Boolean.TRUE);
                stage.setHeadlineG1(levelFormat.getName());
                stage.setHeadlineG1IsNumeric(Boolean.valueOf(levelFormat.isNumeric()));
                stage.setHeadlineG1Align(levelFormat.getAlign());
                stage.setHeadlineG1Length(Integer.valueOf(levelFormat.getLength()));
                continue;
            }
            if (2 == i) {
                stage.setHeadlineG2Set(Boolean.TRUE);
                stage.setHeadlineG2(levelFormat.getName());
                stage.setHeadlineG2IsNumeric(Boolean.valueOf(levelFormat.isNumeric()));
                stage.setHeadlineG2Align(levelFormat.getAlign());
                stage.setHeadlineG2Length(Integer.valueOf(levelFormat.getLength()));
                continue;
            }
            if (3 == i) {
                stage.setHeadlineG3Set(Boolean.TRUE);
                stage.setHeadlineG3(levelFormat.getName());
                stage.setHeadlineG3IsNumeric(Boolean.valueOf(levelFormat.isNumeric()));
                stage.setHeadlineG3Align(levelFormat.getAlign());
                stage.setHeadlineG3Length(Integer.valueOf(levelFormat.getLength()));
                continue;
            }
            if (4 == i) {
                stage.setHeadlineG4Set(Boolean.TRUE);
                stage.setHeadlineG4(levelFormat.getName());
                stage.setHeadlineG4IsNumeric(Boolean.valueOf(levelFormat.isNumeric()));
                stage.setHeadlineG4Align(levelFormat.getAlign());
                stage.setHeadlineG4Length(Integer.valueOf(levelFormat.getLength()));
                continue;
            }
            if (5 != i) continue;
            stage.setHeadlineG5Set(Boolean.TRUE);
            stage.setHeadlineG5(levelFormat.getName());
            stage.setHeadlineG5IsNumeric(Boolean.valueOf(levelFormat.isNumeric()));
            stage.setHeadlineG5Align(levelFormat.getAlign());
            stage.setHeadlineG5Length(Integer.valueOf(levelFormat.getLength()));
        }
        Iterable itemFormats = gaebExtractResult.getItemFormats();
        i = 0;
        for (ItemFormat levelFormat : itemFormats) {
            if (1 == ++i) {
                stage.setItemFormatG1Set(Boolean.TRUE);
                stage.setItemFormatG1(levelFormat.getName());
                stage.setItemFormatG1IsNumeric(Boolean.valueOf(levelFormat.isNumeric()));
                stage.setItemFormatG1Align(levelFormat.getAlign());
                stage.setItemFormatG1Length(Integer.valueOf(levelFormat.getLength()));
                continue;
            }
            if (2 != i) continue;
            stage.setItemFormatG2Set(Boolean.TRUE);
            stage.setItemFormatG2(levelFormat.getName());
            stage.setItemFormatG2IsNumeric(Boolean.valueOf(levelFormat.isNumeric()));
            stage.setItemFormatG2Align(levelFormat.getAlign());
            stage.setItemFormatG2Length(Integer.valueOf(levelFormat.getLength()));
        }
        Iterable descriptions = gaebExtractResult.getDescriptions();
        StringBuilder sb = new StringBuilder();
        for (Pair description : descriptions) {
            sb.append((String)description.getLeft());
            sb.append("\n");
            sb.append((String)description.getRight());
            sb.append("\n\n\n");
        }
        quotationBoQ.setBoqDescription(sb.toString());
        List gaebPositions = gaebExtractResult.getGaebPositions();
        ImmutableList.Builder quotationPositionsBuilder = ImmutableList.builder();
        AtomicInteger sequenceNumberStandard = new AtomicInteger(1);
        if (!optionAppend) {
            quotationPositions = (Set)MoreObjects.firstNonNull((Object)stage.getQuotationPositions(), (Object)Sets.newHashSet());
            quotationPositions.forEach(item -> item.setQuotation(null));
            quotationPositions.clear();
        }
        for (GaebPosition gaebPosition : gaebPositions) {
            QuotationPosition quotationPosition = this.entityFactory.quotationPosition();
            QuotationPosition quotationPositionMerged = this.positionMapper.mergeQStagePosition(stage, sequenceNumberStandard, quotationPosition, gaebExtractResult, gaebPosition);
            quotationPositionsBuilder.add((Object)quotationPositionMerged);
        }
        quotationPositions = quotationPositionsBuilder.build();
        log.info("QState.BOQ: Converted GAEB Positions");
        Iterable quotationPositionsUpdated = this.stagePositionHandler.update((Iterable)quotationPositions);
        log.info("QState.BOQ: Stored GAEB Positions");
        if (null == stage.getQuotationPositions()) {
            stage.setQuotationPositions((Set)Sets.newHashSet());
        }
        Set quotationPositionsOfQ = stage.getQuotationPositions();
        quotationPositionsUpdated.forEach(quotationPositionsOfQ::add);
        for (QuotationPosition quotationPosition : quotationPositionsUpdated) {
            quotationPosition.setQuotation(stage);
        }
        if (null == stage.getQuotationBoQs()) {
            stage.setQuotationBoQs((Set)Sets.newHashSet());
        }
        Set quotationBoQs = stage.getQuotationBoQs();
        quotationBoQs.add(quotationBoQ);
        quotationBoQ.setQuotation(stage);
        stage.setLastQuotationBoQ(quotationBoQ);
        log.info("QState.BOQ: Attached Positions to Stage");
        Quotation quotationUpdated = this.updateAndEmitChangeMessage(stage);
        log.info("QState.BOQ: Saved Stage");
        return Optional.of(GaebImportResult.of((String)originalFilename, (GaebExtractResult)gaebExtractResult, (Quotation)quotationUpdated, (Iterable)quotationPositions, (Iterable)importErrors));
    }

    @Nonnull
    private QuotationBucket stageBucket(@NonNull Quotation stage) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        QEntity entity = stage.getQEntity();
        String absoluteClientHomeFolder = StringUtils.trimToEmpty((String)entity.getAbsoluteClientHomeFolder());
        String absoluteServerHomeFolder = StringUtils.trimToEmpty((String)entity.getAbsoluteServerHomeFolder());
        Iterable iAddendumDiscounts = this.stageHandler.allStageDiscounts(stage);
        return QuotationBucket.of((ECostUnitCEViewMode)ECostUnitCEViewMode.COMMISSION__COST_UNIT_CE, (EQuotationPositionSortOption)EQuotationPositionSortOption.DEFAULT, (Quotation)stage, (String)absoluteClientHomeFolder, (String)absoluteServerHomeFolder, (Iterable)iAddendumDiscounts, (Iterable)((Iterable)MoreObjects.firstNonNull((Object)stage.getQuotationPositions(), (Object)ImmutableSet.of())), (Iterable)ImmutableList.of());
    }

    private void validateReadAccess() {
    }

    @Nonnull
    private ValidationResult validateStateSwitch(@NonNull EQStageState stageStateOld, @NonNull EQStageState stageStateNew, @NonNull Quotation stage, @NonNull StageStateUpdateRequest updateRequest, boolean flagForceArchive) {
        if (stageStateOld == null) {
            throw new NullPointerException("stageStateOld is marked non-null but is null");
        }
        if (stageStateNew == null) {
            throw new NullPointerException("stageStateNew is marked non-null but is null");
        }
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        if (updateRequest == null) {
            throw new NullPointerException("updateRequest is marked non-null but is null");
        }
        Long stageId = stage.getId();
        EQStageType stageType = stage.getStageType();
        try {
            this.validators.stageValidation(QStageStateUpdateBucket.of((StageStateUpdateRequest)updateRequest, (Quotation)stage)).validBase().validate();
        }
        catch (BusinessRuleValidationException businessRuleValidationException) {
            ImmutableList messages = (ImmutableList)businessRuleValidationException.getDetails().stream().map(RequestValidationException.Detail::getMessage).collect(ImmutableList.toImmutableList());
            ImmutableSet.Builder errorsBuilder = ImmutableSet.builder();
            errorsBuilder.addAll((Iterable)messages);
            ImmutableSet errors = errorsBuilder.build();
            return ValidationResult.from((Iterable)errors);
        }
        if (stageStateOld != stageStateNew) {
            if (EQStageType.QUOTATION == stageType && (stageStateNew == EQStageState.ACCEPTED || stageStateNew == EQStageState.DESIGNATED_COMMISSION)) {
                QEntity qEntity = stage.getQEntity();
                Set allStages = qEntity.getStages();
                ImmutableListMultimap index = Multimaps.index((Iterable)allStages, Quotation::getStageType);
                Iterable quotationsInDesignatedCommission = (Iterable)index.get((Object)EQStageType.QUOTATION).stream().filter(item -> !Objects.equals(item.getId(), stageId)).filter(item -> EQStageState.DESIGNATED_COMMISSION == item.getStageState()).collect(ImmutableList.toImmutableList());
                Iterable quotationsInCommission = (Iterable)index.get((Object)EQStageType.QUOTATION).stream().filter(item -> !Objects.equals(item.getId(), stageId)).filter(item -> EQStageState.COMMISSIONED == item.getStageState()).collect(ImmutableList.toImmutableList());
                ImmutableSet.Builder errorsBuilder = ImmutableSet.builder();
                if (!Iterables.isEmpty((Iterable)quotationsInDesignatedCommission)) {
                    for (Quotation quotation : quotationsInDesignatedCommission) {
                        errorsBuilder.add((Object)Message.of((EMessageKey)EMessageKey.RULE_STAGE__STATE_IS_DESIGNATED_COMMISSION, (String)quotation.getQNumber()));
                    }
                }
                if (!Iterables.isEmpty((Iterable)quotationsInCommission)) {
                    for (Quotation quotation : quotationsInCommission) {
                        errorsBuilder.add((Object)Message.of((EMessageKey)EMessageKey.RULE_STAGE__STATE_IS_COMMISSIONED, (String)quotation.getQNumber()));
                    }
                }
                ImmutableSet errors = errorsBuilder.build();
                return ValidationResult.from((Iterable)errors);
            }
            if ((stageType == EQStageType.COMMISSION || stageType == EQStageType.COMMISSION__COST_UNIT || stageType == EQStageType.COMMISSION__COST_UNIT__CE || stageType == EQStageType.QUOTATION || stageType == EQStageType.COMMISSION__COST_ESTIMATE) && stageStateNew == EQStageState.ARCHIVED) {
                ImmutableSet stages;
                Quotation stageToBeValidated = this.findCostUnitForCostEstimate(stage).orElse(stage);
                ImmutableList.Builder errorsBuilder = ImmutableList.builder();
                QEntity entity = stageToBeValidated.getQEntity();
                Integer version = stageToBeValidated.getVersion();
                ImmutableSet versions = null != version ? ImmutableSet.of((Object)version) : ImmutableSet.of();
                Quotation primaryStage = entity.getPrimaryStage();
                if (stageType == EQStageType.COMMISSION && !Objects.equals(primaryStage, stage)) {
                    errorsBuilder.add((Object)Message.of((EMessageKey)EMessageKey.RULE_STAGE_ARCHIVE__FOUND_OTHER_VERSIONS));
                }
                if (Objects.equals(primaryStage, stageToBeValidated)) {
                    ImmutableSet stageTypesAndStates = ImmutableSet.of((Object)StageTypeAndState.of((Iterable)ImmutableList.of((Object)EQStageType.COMMISSION), (Iterable)EQStageState.ACCOUNTABLE_STAGE_STATES, (boolean)false));
                    Page commissionStages = this.stageHandler.stages((Iterable)ImmutableSet.of((Object)entity), (Iterable)versions, (Iterable)ImmutableList.of(), (Iterable)ImmutableList.of(), (Iterable)stageTypesAndStates, "", Pageable.unpaged());
                    if (Iterables.size((Iterable)commissionStages) > 1) {
                        errorsBuilder.add((Object)Message.of((EMessageKey)EMessageKey.RULE_STAGE_ARCHIVE__FOUND_OTHER_VERSIONS));
                    }
                }
                if (Iterables.contains((Iterable)EQStageType.COST_UNIT_TYPES, (Object)stageToBeValidated.getStageType())) {
                    stages = ImmutableSet.of((Object)stageToBeValidated);
                } else {
                    Iterable stageTypeAndStates = StageHelper.archiveValidationStates((Quotation)stageToBeValidated);
                    Page stagesFetched = this.stageHandler.stages((Iterable)ImmutableSet.of((Object)entity), (Iterable)versions, (Iterable)ImmutableList.of(), (Iterable)ImmutableList.of(), stageTypeAndStates, "", Pageable.unpaged());
                    stages = ImmutableSet.copyOf((Collection)stagesFetched.getContent());
                }
                Iterable stageIds = (Iterable)Streams.stream((Iterable)stages).map(Quotation::getId).collect(ImmutableSet.toImmutableSet());
                Iterable stageNumbers = (Iterable)Streams.stream((Iterable)stages).map(Quotation::getQNumber).collect(ImmutableSet.toImmutableSet());
                if (!flagForceArchive && !Iterables.isEmpty((Iterable)stages)) {
                    Iterable quotationWages = this.payrollMonthHelperService.determineStageWages((Iterable)ImmutableSet.of(), DateTimeHelper.thisMonth().withDayOfMonth(1), Long.valueOf(Long.MAX_VALUE), stageNumbers, EYearMonthDateRange.ALL, true);
                    for (Object stageWage : quotationWages) {
                        String wageAvailableOverallSum = BigDecimalHelper.asString((BigDecimal)stageWage.getWageAvailableOverallSum());
                        errorsBuilder.add((Object)Message.of((EMessageKey)EMessageKey.RULE_STAGE_ARCHIVE__UNPAID_SQUAD_WAGE, (String)wageAvailableOverallSum));
                    }
                }
                if (!Iterables.isEmpty((Iterable)stageIds)) {
                    Object stageWage;
                    MeasurementFilter measurementFilter = MeasurementFilter.of((boolean)true, (boolean)true, (boolean)true, (String)"", (String)"", (Iterable)ImmutableList.of(), (Iterable)ImmutableList.of(), (Iterable)ImmutableList.of(), (Iterable)ImmutableList.of(), (Iterable)ImmutableSet.of(), (Iterable)stageIds, (Iterable)ImmutableSet.of(), (Pageable)PageRequest.of((int)0, (int)50), (Iterable)ImmutableSet.of(), (Range)Range.all(), (Range)Range.all(), (Range)Range.all(), (Iterable)ImmutableList.of(), (Iterable)ImmutableSet.copyOf((Collection)EMeasurementState.NOT_ACCOUNTED_STATES));
                    Iterator notAccounted = this.measurementHandler.notAccounted(measurementFilter);
                    stageWage = notAccounted.iterator();
                    while (stageWage.hasNext()) {
                        MeasurementDashboard measurementDashboard = (MeasurementDashboard)stageWage.next();
                        String measurementNumber = measurementDashboard.getMeasurementNumber();
                        errorsBuilder.add((Object)Message.of((EMessageKey)EMessageKey.RULE_STAGE_ARCHIVE__NOT_ACCOUNTED_MEASUREMENT, (String)measurementNumber));
                    }
                }
                if (!Iterables.isEmpty((Iterable)stages)) {
                    Page notAccountedInvoices = this.invoiceHandler.notAccounted((Iterable)stages);
                    for (Invoice notAccountedInvoice : notAccountedInvoices) {
                        String orderDescription = notAccountedInvoice.getOrderDescription();
                        errorsBuilder.add((Object)Message.of((EMessageKey)EMessageKey.RULE_STAGE_ARCHIVE__NOT_ACCOUNTED_INVOICE, (String)orderDescription));
                    }
                }
                if (!Iterables.isEmpty((Iterable)stages)) {
                    Page partialWithoutFinal = this.invoiceHandler.partialWithoutFinal((Iterable)stages);
                    for (Invoice invoice : partialWithoutFinal) {
                        String invoiceNumber = invoice.getInvoiceNumber();
                        String orderDescription = invoice.getOrderDescription();
                        String txt = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{invoiceNumber}) ? invoiceNumber : orderDescription;
                        errorsBuilder.add((Object)Message.of((EMessageKey)EMessageKey.RULE_STAGE_ARCHIVE__PARTIAL_WITHOUT_FINAL_INVOICE, (String)txt));
                    }
                }
                if (!flagForceArchive && !Iterables.isEmpty((Iterable)stages)) {
                    LocalDate referenceDate = DateTimeHelper.today().minusMonths(6L);
                    Page tooYoungInvoices = this.invoiceHandler.invoiceWithDateGreaterThanOrInAccounting((Iterable)stages, referenceDate);
                    for (Invoice invoice : tooYoungInvoices) {
                        String invoiceNumber = invoice.getInvoiceNumber();
                        errorsBuilder.add((Object)Message.of((EMessageKey)EMessageKey.RULE_STAGE_ARCHIVE__INVOICE_TOO_YOUNG, (String)invoiceNumber));
                    }
                }
                ImmutableList errors = errorsBuilder.build();
                return ValidationResult.from((Iterable)errors);
            }
        }
        return ValidationResult.NO_ERROR;
    }

    private void validateAddendumNumber(@NonNull Quotation stage, @Nullable Long addendumNumberToBeSet) {
        Collection conflictingStages;
        Multimap existingAddendumNumbers;
        Set existingAddendumNumbersLong;
        boolean addendumNumberUsed;
        EQStageType stageType;
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        if (null != addendumNumberToBeSet && Iterables.contains((Iterable)EQStageType.ADDENDUM_TYPES, (Object)(stageType = stage.getStageType())) && (addendumNumberUsed = Iterables.contains((Iterable)(existingAddendumNumbersLong = (existingAddendumNumbers = QEntityHelper.existingAddendumNumbers((Quotation)stage, (Iterable)ImmutableSet.of((Object)stage))).keySet()), (Object)addendumNumberToBeSet)) && !Iterables.isEmpty((Iterable)(conflictingStages = existingAddendumNumbers.get((Object)addendumNumberToBeSet)))) {
            Quotation conflictingStage = (Quotation)conflictingStages.iterator().next();
            String number = conflictingStage.getQNumber();
            String alias = conflictingStage.getAlias();
            String message = this.messageService.get((Translatable)EMessageKey.RULE_STAGE__DUPLICATE_ADDENDUM_NUMBER, new Object[]{addendumNumberToBeSet, number, alias});
            throw new BusinessRuleValidationException(message, (List)ImmutableList.of((Object)RequestValidationException.Detail.of((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.QUOTATION__ADDENDUM_NUMBER), (Object)addendumNumberToBeSet, (String)message, (Message)Message.of((EMessageKey)EMessageKey.RULE_STAGE__DUPLICATE_ADDENDUM_NUMBER, (List)ImmutableList.of((Object)addendumNumberToBeSet, (Object)number, (Object)alias)), (List)ImmutableList.of())));
        }
    }

    @Nonnull
    private BillOfQuantitiesMeasurementExport map(@NonNull QuotationPosition quotationPosition) {
        if (quotationPosition == null) {
            throw new NullPointerException("quotationPosition is marked non-null but is null");
        }
        BillOfQuantitiesMeasurementExport boq = new BillOfQuantitiesMeasurementExport();
        boq.setUnit(quotationPosition.getUnit());
        boq.setShortText(quotationPosition.getShortText());
        boq.setSurrogatePositionNumber(quotationPosition.getSurrogatePositionNumber());
        boq.setPricePerUnit(quotationPosition.getPricePerUnit());
        boq.setRemarks(quotationPosition.getRemarks());
        boq.setPriceAggregated(quotationPosition.getPriceAggregated());
        boq.setProduct(quotationPosition.getOrderedAmount());
        boq.setDiscount(BigDecimal.ZERO);
        return boq;
    }

    private boolean createInquiryFolder(@NonNull QEntity entity) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        EQEntityState entityState = entity.getQEntityState();
        if (entityState == EQEntityState.INQUIRY_TEMPORARY || entityState == EQEntityState.INQUIRY_ARCHIVED || entityState == EQEntityState.INQUIRY_NOTIFIED) {
            Path clientHomeFolderPath = this.entityConfig.getClientHomeFolderPath();
            Path serverHomeFolderPath = this.entityConfig.getServerHomeFolderPath();
            Iterable stageFilesFoldersAllPaths = this.entityConfig.getStageFilesFoldersAllPaths();
            Path clientInquiryPath = StageHelper.inquiryPath((Path)clientHomeFolderPath, (QEntity)entity);
            Path serverInquiryPath = StageHelper.inquiryPath((Path)serverHomeFolderPath, (QEntity)entity);
            Iterable pathsToUse = stageFilesFoldersAllPaths;
            Path clientRoot = clientInquiryPath;
            Path serverRoot = serverInquiryPath;
            Pair entityRootFolders = StageRouteImpl.prepareEntityOrStageFolders((Path)serverRoot, (Iterable)pathsToUse);
            StageRouteImpl.ensureRequiredFolders((Iterable)((Iterable)entityRootFolders.getRight()));
            String absoluteClientHomeFolder = clientRoot.toAbsolutePath().toString();
            String absoluteServerHomeFolder = serverRoot.toAbsolutePath().toString();
            entity.setAbsoluteClientHomeFolder(absoluteClientHomeFolder);
            entity.setAbsoluteServerHomeFolder(absoluteServerHomeFolder);
            return true;
        }
        return false;
    }

    public boolean renameInquiryFolder(@NonNull QEntity entity) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        Path clientHomeFolderPath = this.entityConfig.getClientHomeFolderPath();
        Path serverHomeFolderPath = this.entityConfig.getServerHomeFolderPath();
        Path entityServerHomeFolderPath = Path.of(entity.getAbsoluteServerHomeFolder(), new String[0]);
        Path fileName = entityServerHomeFolderPath.getFileName();
        Path clientAllPath = StageHelper.allPath((Path)clientHomeFolderPath, (QEntity)entity);
        Path serverInquiryPath = Path.of(serverHomeFolderPath.toAbsolutePath().toString(), fileName.toString());
        Path serverAllPath = StageHelper.allPath((Path)serverHomeFolderPath, (QEntity)entity);
        String entityNumber = entity.getQNumber();
        Path mainCostUnitPath = StageHelper.mainCostUnitPath((Path)serverHomeFolderPath, (String)entityNumber);
        File serverInquiryDir = serverInquiryPath.toAbsolutePath().toFile();
        File serverAllDir = serverAllPath.toAbsolutePath().toFile();
        File mainCostUnitDir = mainCostUnitPath.toAbsolutePath().toFile();
        if (serverInquiryDir.exists() && serverInquiryDir.isDirectory() && !serverAllDir.exists()) {
            boolean renamedInquiryFolder = serverInquiryDir.renameTo(serverAllDir);
            File[] existingFiles = serverAllDir.listFiles();
            if (existingFiles != null) {
                if (!mainCostUnitDir.exists()) {
                    boolean bl = mainCostUnitDir.mkdirs();
                }
                for (File file : existingFiles) {
                    Path sourcePath = Path.of(file.getAbsolutePath(), new String[0]);
                    Path targetPath = Path.of(mainCostUnitPath.toString(), sourcePath.getFileName().toString());
                    File sourceFile = sourcePath.toFile();
                    File targetFile = targetPath.toFile();
                    boolean bl = sourceFile.renameTo(targetFile);
                }
            }
            String absoluteClientHomeFolder = clientAllPath.toAbsolutePath().toString();
            String absoluteServerHomeFolder = serverAllPath.toAbsolutePath().toString();
            entity.setAbsoluteClientHomeFolder(absoluteClientHomeFolder);
            entity.setAbsoluteServerHomeFolder(absoluteServerHomeFolder);
            this.entityHandler.update((EntityBase)entity);
            return true;
        }
        return false;
    }

    public boolean createCostUnitFolder(@NonNull Quotation stage) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        EQStageType stageType = stage.getStageType();
        if (Iterables.contains((Iterable)EQStageType.STAGE_FOLDER_TYPES, (Object)stageType)) {
            QEntity entity = stage.getQEntity();
            String entityNumber = entity.getQNumber();
            String stageNumber = stage.getQNumber();
            Path serverHomeFolderPath = this.entityConfig.getServerHomeFolderPath();
            Iterable stageFilesFoldersAllPaths = this.entityConfig.getStageFilesFoldersAllPaths();
            Path stagePath = StageHelper.costUnitPath((Path)serverHomeFolderPath, (String)entityNumber, (String)stageNumber);
            File stageDir = stagePath.toAbsolutePath().toFile();
            if (!stageDir.exists()) {
                boolean stageDirCreated = stageDir.mkdirs();
                Pair stageFoldersExpected = StageRouteImpl.prepareEntityOrStageFolders((Path)stagePath, (Iterable)stageFilesFoldersAllPaths);
                StageRouteImpl.ensureRequiredFolders((Iterable)((Iterable)stageFoldersExpected.getRight()));
                return true;
            }
        }
        return false;
    }

    @Nonnull
    private Quotation ensureStageFiles(@NonNull Quotation stage) {
        Path serverRoot;
        Path clientRoot;
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        QEntity entity = stage.getQEntity();
        Path clientHomeFolderPath = this.entityConfig.getClientHomeFolderPath();
        Path serverHomeFolderPath = this.entityConfig.getServerHomeFolderPath();
        Path clientInquiryPath = StageHelper.inquiryPath((Path)clientHomeFolderPath, (QEntity)entity);
        Path clientAllPath = StageHelper.allPath((Path)clientHomeFolderPath, (QEntity)entity);
        Path serverInquiryPath = StageHelper.inquiryPath((Path)serverHomeFolderPath, (QEntity)entity);
        Path serverAllPath = StageHelper.allPath((Path)serverHomeFolderPath, (QEntity)entity);
        boolean updateEntity = false;
        EQEntityState entityState = entity.getQEntityState();
        Iterable stageFilesFoldersAllPaths = this.entityConfig.getStageFilesFoldersAllPaths();
        if (entityState == EQEntityState.INQUIRY_TEMPORARY || entityState == EQEntityState.INQUIRY_ARCHIVED || entityState == EQEntityState.INQUIRY_NOTIFIED) {
            Iterable pathsToUse = stageFilesFoldersAllPaths;
            clientRoot = clientInquiryPath;
            serverRoot = serverInquiryPath;
            Pair entityRootFolders = StageRouteImpl.prepareEntityOrStageFolders((Path)serverRoot, (Iterable)pathsToUse);
            updateEntity = StageRouteImpl.ensureRequiredFolders((Iterable)((Iterable)entityRootFolders.getRight()));
        } else {
            String stageNumber;
            Path stagePath;
            File stageDir;
            EQStageType stageType;
            clientRoot = clientAllPath;
            serverRoot = serverAllPath;
            String entityNumber = entity.getQNumber();
            Path mainCostUnitPath = StageHelper.mainCostUnitPath((Path)serverHomeFolderPath, (String)entityNumber);
            File serverInquiryDir = serverRoot.toAbsolutePath().toFile();
            File serverAllDir = serverAllPath.toAbsolutePath().toFile();
            File mainCostUnitDir = mainCostUnitPath.toAbsolutePath().toFile();
            if (serverInquiryDir.exists() && serverInquiryDir.isDirectory() && !serverAllDir.exists()) {
                updateEntity = serverInquiryDir.renameTo(serverAllDir);
                File[] existingFiles = serverAllDir.listFiles();
                if (existingFiles != null) {
                    if (!mainCostUnitDir.exists()) {
                        boolean bl = mainCostUnitDir.mkdirs();
                    }
                    for (File file : existingFiles) {
                        Path sourcePath = Path.of(file.getAbsolutePath(), new String[0]);
                        Path targetPath = Path.of(mainCostUnitPath.toString(), sourcePath.getFileName().toString());
                        File sourceFile = sourcePath.toFile();
                        File targetFile = targetPath.toFile();
                        boolean bl = sourceFile.renameTo(targetFile);
                    }
                }
            }
            if (Iterables.contains((Iterable)EQStageType.STAGE_FOLDER_TYPES, (Object)(stageType = stage.getStageType())) && !(stageDir = (stagePath = StageHelper.costUnitPath((Path)serverHomeFolderPath, (String)entityNumber, (String)(stageNumber = stage.getQNumber()))).toAbsolutePath().toFile()).exists()) {
                boolean stageDirCreated = stageDir.mkdirs();
                Pair stageFoldersExpected = StageRouteImpl.prepareEntityOrStageFolders((Path)stagePath, (Iterable)stageFilesFoldersAllPaths);
                updateEntity = StageRouteImpl.ensureRequiredFolders((Iterable)((Iterable)stageFoldersExpected.getRight()));
            }
        }
        if (updateEntity) {
            String absoluteClientHomeFolder = clientRoot.toAbsolutePath().toString();
            String absoluteServerHomeFolder = serverRoot.toAbsolutePath().toString();
            entity.setAbsoluteClientHomeFolder(absoluteClientHomeFolder);
            entity.setAbsoluteServerHomeFolder(absoluteServerHomeFolder);
            this.entityHandler.update((EntityBase)entity);
        }
        return stage;
    }

    @Nonnull
    public StageFileListCommon filesByStage(@NonNull Quotation stage) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        QEntity entity = stage.getQEntity();
        String serverHomeFolder = entity.getAbsoluteServerHomeFolder();
        Path serverHomePath = Path.of(serverHomeFolder, new String[0]);
        File serverHomeDir = serverHomePath.toFile();
        File[] rootFolders = (File[])MoreObjects.firstNonNull((Object)serverHomeDir.listFiles(), (Object)new File[0]);
        ImmutableList.Builder entityFileCommonBuilder = ImmutableList.builder();
        for (File eachFolder : rootFolders) {
            File[] files = eachFolder.listFiles();
            if (null != files && files.length > 0) {
                for (File file : files) {
                    QEntityFileCommon qEntityFileCommon = this.entityMapper.mapToCommon(serverHomePath, file);
                    entityFileCommonBuilder.add((Object)qEntityFileCommon);
                }
                continue;
            }
            QEntityFileCommon qEntityFileCommon = this.entityMapper.mapToCommon(serverHomePath, eachFolder);
            entityFileCommonBuilder.add((Object)qEntityFileCommon);
        }
        ImmutableList qEntityFileCommons = entityFileCommonBuilder.build();
        return new StageFileListCommon(qEntityFileCommons.size(), (List)qEntityFileCommons);
    }

    @Nonnull
    private static Pair<Path, Iterable<File>> prepareEntityOrStageFolders(@NonNull Path rootFolder, @NonNull Iterable<Path> foldersDefaultPaths) {
        if (rootFolder == null) {
            throw new NullPointerException("rootFolder is marked non-null but is null");
        }
        if (foldersDefaultPaths == null) {
            throw new NullPointerException("foldersDefaultPaths is marked non-null but is null");
        }
        ImmutableSet.Builder expectedFoldersBuilder = ImmutableSet.builder();
        for (Path foldersDefaultPath : foldersDefaultPaths) {
            Path expectedFolder = Path.of(rootFolder.toString(), foldersDefaultPath.toString());
            expectedFoldersBuilder.add((Object)expectedFolder.toFile());
        }
        ImmutableSet allChildFolders = expectedFoldersBuilder.build();
        return Pair.of((Object)rootFolder, (Object)allChildFolders);
    }

    private static boolean ensureRequiredFolders(@NonNull Iterable<File> expectedFolders) {
        if (expectedFolders == null) {
            throw new NullPointerException("expectedFolders is marked non-null but is null");
        }
        boolean result = true;
        for (File expectedFolder : expectedFolders) {
            if (!expectedFolder.exists()) {
                boolean folderCreated = expectedFolder.mkdirs();
                if (folderCreated) continue;
                log.error("Could not create default Folder for: {}", (Object)expectedFolder.toString());
                result = false;
                continue;
            }
            if (!expectedFolder.isFile()) continue;
            log.error("File: {} is required to be a Folder", (Object)expectedFolder.toString());
            result = false;
        }
        return result;
    }

    public StageRouteImpl(ApplicationEventPublisher applicationEventPublisher, ApplicationConfig applicationConfig, StageConfig entityConfig, EntityFactory entityFactory, FileStoreMapper fileStoreMapper, QEntityMapper entityMapper, StageMapper mapper, StageUserMapper stageUserMapper, StagePositionMapper positionMapper, ReportingMapper reportingMapper, ValidationMapper validationMapper, StageHandler stageHandler, StagePositionHandler stagePositionHandler, QStagePrintMapper stagePrintMapper, EntityHandler entityHandler, DataAggregationService dataAggregationService, PayrollMonthHelperService payrollMonthHelperService, PersonAutoCompleteHandler personAutoCompleteHandler, StageHistoryPreparer stageHistoryPreparer, HistoryItemRoute historyItemRoute, AddressHandler addressHandler, BoilerPlateHandler boilerPlateHandler, CustomerHandler customerHandler, ContactPersonHandler contactPersonHandler, FileStoreHandler fileStoreHandler, ConfigurationCompanyHandler configurationCompanyHandler, UserHandler userHandler, ProjectHandler projectHandler, SubProjectHandler subProjectHandler, TaxKeyHandler taxKeyHandler, MeasurementHandler measurementHandler, InvoiceHandler invoiceHandler, StagePropagationHandler stagePropagationHandler, DateTimeHelperService dateTimeHelperService, GaebX84ExportService gaebX84ExportService, StageXlsExportService stageXlsExportService, GaebX83ImportService gaebX83ImportService, GaebX84ImportService gaebX84ImportService, MessageService messageService, QNumberService qNumberService, UserService userService, DiamantER2Service diamantER2Service, StageER2CostUnitExportService stageEr2CostUnitExportService, StageCalculators stageCalculators, Validators validators, BillOfQuantitiesMeasurementXlsExportService billOfQuantitiesMeasurementXlsExportService, QStageCostEstimatePrintService costEstimatePrintService, QStageQuotationPrintService stagePrintService, QStageCalculationPrintService calculationPrintService, QStageWagesPrintService wagesPrintService, PDFHelperService pdfHelperService, StageHelperService stageHelperService, CompanyConfig companyConfig) {
        this.applicationEventPublisher = applicationEventPublisher;
        this.applicationConfig = applicationConfig;
        this.entityConfig = entityConfig;
        this.entityFactory = entityFactory;
        this.fileStoreMapper = fileStoreMapper;
        this.entityMapper = entityMapper;
        this.mapper = mapper;
        this.stageUserMapper = stageUserMapper;
        this.positionMapper = positionMapper;
        this.reportingMapper = reportingMapper;
        this.validationMapper = validationMapper;
        this.stageHandler = stageHandler;
        this.stagePositionHandler = stagePositionHandler;
        this.stagePrintMapper = stagePrintMapper;
        this.entityHandler = entityHandler;
        this.dataAggregationService = dataAggregationService;
        this.payrollMonthHelperService = payrollMonthHelperService;
        this.personAutoCompleteHandler = personAutoCompleteHandler;
        this.stageHistoryPreparer = stageHistoryPreparer;
        this.historyItemRoute = historyItemRoute;
        this.addressHandler = addressHandler;
        this.boilerPlateHandler = boilerPlateHandler;
        this.customerHandler = customerHandler;
        this.contactPersonHandler = contactPersonHandler;
        this.fileStoreHandler = fileStoreHandler;
        this.configurationCompanyHandler = configurationCompanyHandler;
        this.userHandler = userHandler;
        this.projectHandler = projectHandler;
        this.subProjectHandler = subProjectHandler;
        this.taxKeyHandler = taxKeyHandler;
        this.measurementHandler = measurementHandler;
        this.invoiceHandler = invoiceHandler;
        this.stagePropagationHandler = stagePropagationHandler;
        this.dateTimeHelperService = dateTimeHelperService;
        this.gaebX84ExportService = gaebX84ExportService;
        this.stageXlsExportService = stageXlsExportService;
        this.gaebX83ImportService = gaebX83ImportService;
        this.gaebX84ImportService = gaebX84ImportService;
        this.messageService = messageService;
        this.qNumberService = qNumberService;
        this.userService = userService;
        this.diamantER2Service = diamantER2Service;
        this.stageEr2CostUnitExportService = stageEr2CostUnitExportService;
        this.stageCalculators = stageCalculators;
        this.validators = validators;
        this.billOfQuantitiesMeasurementXlsExportService = billOfQuantitiesMeasurementXlsExportService;
        this.costEstimatePrintService = costEstimatePrintService;
        this.stagePrintService = stagePrintService;
        this.calculationPrintService = calculationPrintService;
        this.wagesPrintService = wagesPrintService;
        this.pdfHelperService = pdfHelperService;
        this.stageHelperService = stageHelperService;
        this.companyConfig = companyConfig;
    }
}

