/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.route.impl;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import de.qfm.erp.common.request.role.RoleUpdateRequest;
import de.qfm.erp.common.response.role.RoleCommon;
import de.qfm.erp.common.response.role.RolePageCommon;
import de.qfm.erp.service.model.internal.role.RoleUpdateBucket;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.user.EPrivilege;
import de.qfm.erp.service.model.jpa.user.Role;
import de.qfm.erp.service.service.handler.EntityFactory;
import de.qfm.erp.service.service.handler.RoleHandler;
import de.qfm.erp.service.service.mapper.RoleMapper;
import de.qfm.erp.service.service.route.RoleRoute;
import de.qfm.erp.service.service.validator.user.RoleUpdateRequestValidator;
import java.util.Set;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RoleRouteImpl
implements RoleRoute {
    private final EntityFactory entityFactory;
    private final RoleMapper mapper;
    private final RoleHandler handler;
    private final RoleUpdateRequestValidator updateRequestValidator;

    @Nonnull
    @Transactional(readOnly=true)
    public RoleCommon byId(long id) {
        return this.mapper.map((Role)this.handler.byIdFailing(Long.valueOf(id)));
    }

    @Nonnull
    @Transactional(readOnly=true)
    public RoleCommon byName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.mapper.map(this.handler.byNameFailing(name));
    }

    @Nonnull
    @Transactional(readOnly=true)
    public RolePageCommon page(int page, int size) {
        return this.mapper.map(this.handler.page(page, size));
    }

    @Nonnull
    @Transactional
    public RoleCommon create(@NonNull RoleUpdateRequest updateRequest) {
        if (updateRequest == null) {
            throw new NullPointerException("updateRequest is marked non-null but is null");
        }
        Role role = this.entityFactory.role();
        this.updateRequestValidator.validate(role, updateRequest);
        return this.mergeAndPersist(updateRequest, role);
    }

    @Nonnull
    public RoleCommon update(long id, @NonNull RoleUpdateRequest updateRequest) {
        if (updateRequest == null) {
            throw new NullPointerException("updateRequest is marked non-null but is null");
        }
        Role role = (Role)this.handler.byIdFailing(Long.valueOf(id));
        this.updateRequestValidator.validate(role, updateRequest);
        return this.mergeAndPersist(updateRequest, role);
    }

    @Nonnull
    private RoleCommon mergeAndPersist(@NonNull RoleUpdateRequest updateRequest, @NonNull Role role) {
        if (updateRequest == null) {
            throw new NullPointerException("updateRequest is marked non-null but is null");
        }
        if (role == null) {
            throw new NullPointerException("role is marked non-null but is null");
        }
        Set privilegeCandidateStrings = (Set)MoreObjects.firstNonNull((Object)updateRequest.getPrivileges(), (Object)ImmutableSet.of());
        ImmutableSet.Builder privilegesBuilder = ImmutableSet.builder();
        for (String privilegeCandidateString : privilegeCandidateStrings) {
            privilegesBuilder.add((Object)EPrivilege.lookupFailing((String)privilegeCandidateString));
        }
        ImmutableSet privileges = privilegesBuilder.build();
        RoleUpdateBucket updateBucket = RoleUpdateBucket.of((RoleUpdateRequest)updateRequest, (Role)role, (Role)role, (Iterable)privileges);
        Role roleMerged = this.mapper.merge(updateBucket);
        Role roleUpdated = (Role)this.handler.update((EntityBase)roleMerged);
        return this.mapper.map(roleUpdated);
    }

    public RoleRouteImpl(EntityFactory entityFactory, RoleMapper mapper, RoleHandler handler, RoleUpdateRequestValidator updateRequestValidator) {
        this.entityFactory = entityFactory;
        this.mapper = mapper;
        this.handler = handler;
        this.updateRequestValidator = updateRequestValidator;
    }
}

