/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.route.impl;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import de.qfm.erp.service.configuration.NodeConfig;
import de.qfm.erp.service.model.jpa.invoice.Invoice;
import de.qfm.erp.service.model.search.EIndexEntryType;
import de.qfm.erp.service.model.search.EInvoiceIndexField;
import de.qfm.erp.service.model.search.IndexDocument;
import de.qfm.erp.service.model.search.IndexField;
import de.qfm.erp.service.model.search.IndexResult;
import de.qfm.erp.service.service.handler.InvoiceHandler;
import de.qfm.erp.service.service.mapper.InvoiceSearchMapper;
import de.qfm.erp.service.service.mapper.search.InternalQueryHelper;
import de.qfm.erp.service.service.route.AbstractSyncable;
import de.qfm.erp.service.service.service.search.IndexService;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.Query;
import org.springframework.stereotype.Service;

@Service
public class InvoiceSearchRoute
extends AbstractSyncable<Invoice> {
    private static final Logger log = LogManager.getLogger(InvoiceSearchRoute.class);
    private final InvoiceHandler invoiceHandler;
    private final InvoiceSearchMapper invoiceSearchMapper;
    private final IndexService indexService;

    public InvoiceSearchRoute(@NonNull NodeConfig nodeConfig, @NonNull InvoiceHandler invoiceHandler, @NonNull InvoiceSearchMapper invoiceSearchMapper, @NonNull IndexService indexService) {
        super(nodeConfig);
        if (nodeConfig == null) {
            throw new NullPointerException("nodeConfig is marked non-null but is null");
        }
        if (invoiceHandler == null) {
            throw new NullPointerException("invoiceHandler is marked non-null but is null");
        }
        if (invoiceSearchMapper == null) {
            throw new NullPointerException("invoiceSearchMapper is marked non-null but is null");
        }
        if (indexService == null) {
            throw new NullPointerException("indexService is marked non-null but is null");
        }
        this.invoiceHandler = invoiceHandler;
        this.invoiceSearchMapper = invoiceSearchMapper;
        this.indexService = indexService;
    }

    @Nonnull
    public EIndexEntryType indexEntryType() {
        return EIndexEntryType.INVOICE;
    }

    @Nonnull
    public Iterable<Invoice> refresh(@NonNull Iterable<Invoice> itemStream) {
        if (itemStream == null) {
            throw new NullPointerException("itemStream is marked non-null but is null");
        }
        ImmutableList.Builder entriesUpdatedBuilder = ImmutableList.builder();
        itemStream.forEach(item -> this.refresh(item).ifPresent(arg_0 -> ((ImmutableList.Builder)entriesUpdatedBuilder).add(arg_0)));
        return entriesUpdatedBuilder.build();
    }

    @Nonnull
    public Optional<Invoice> refresh(@NonNull Invoice invoice) {
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        String entryId = invoice.getReferenceId();
        try {
            IndexResult index = this.index(invoice);
            log.debug("Refreshed Entity: {} in Index", (Object)invoice);
            return Optional.of(invoice);
        }
        catch (Exception ioe) {
            log.error("Error Refreshing Index for EntryId: {}, Entry: {}", (Object)entryId, (Object)invoice, (Object)ioe);
            return Optional.empty();
        }
    }

    public boolean dirty() {
        return this.invoiceHandler.dirty();
    }

    @Nonnull
    public Iterable<Invoice> streamDirty(int max) {
        return this.invoiceHandler.dirtyPage(max);
    }

    @Nonnull
    public Long id(@NonNull Invoice item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item.getId();
    }

    @Nonnull
    public Iterable<Long> ids(@NonNull Iterable<Invoice> items) {
        if (items == null) {
            throw new NullPointerException("items is marked non-null but is null");
        }
        return (Iterable)Streams.stream(items).map(Invoice::getId).collect(ImmutableSet.toImmutableSet());
    }

    public void start() {
        log.info("Detected Dirty Entries (Invoice) - refreshing Entries in Index");
    }

    public void finish(@NonNull Iterable<Invoice> itemsProcessed, @NonNull Stopwatch stopwatch) {
        if (itemsProcessed == null) {
            throw new NullPointerException("itemsProcessed is marked non-null but is null");
        }
        if (stopwatch == null) {
            throw new NullPointerException("stopwatch is marked non-null but is null");
        }
        int size = Iterables.size(itemsProcessed);
        long elapsedInMs = stopwatch.elapsed(TimeUnit.MILLISECONDS);
        int markedAsIndexed = this.invoiceHandler.markIndexed(itemsProcessed);
        log.info("Finished Refreshing Dirty Entries (Invoice), amount: {}, took: {} ms", (Object)size, (Object)elapsedInMs);
    }

    @Nonnull
    private Optional<String> delete(@NonNull Invoice invoice) {
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        try {
            String documentId = InvoiceSearchMapper.documentId((EIndexEntryType)this.indexEntryType(), (Long)invoice.getId());
            long indexGeneration = this.indexService.deleteFromIndex((Query)InternalQueryHelper.termQuery((IndexField)EInvoiceIndexField._ID, (String)documentId));
            log.debug("Deleted Entity: {}", (Object)invoice);
            return Optional.of(invoice.getReferenceId());
        }
        catch (IOException e) {
            log.error("Error Deleting Entry (Invoice) from Index, error: {}", (Object)e.getMessage());
            return Optional.of(e.getMessage());
        }
    }

    @Nonnull
    private IndexResult index(@NonNull Invoice invoice) throws IOException {
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        IndexDocument indexDocument = this.invoiceSearchMapper.mapToDocument(invoice, this.indexEntryType());
        return this.indexService.updateIndex(indexDocument);
    }

    @Nonnull
    private Iterable<IndexResult> index(@NonNull Iterable<Invoice> invoices) throws IOException {
        if (invoices == null) {
            throw new NullPointerException("invoices is marked non-null but is null");
        }
        Iterable indexDocuments = this.invoiceSearchMapper.mapToDocument(invoices, this.indexEntryType());
        return this.indexService.updateIndex(indexDocuments);
    }
}

