/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.route.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Range;
import de.qfm.erp.common.request.dashboard.DashboardFilterDateRange;
import de.qfm.erp.common.request.dashboard.DashboardFilterMeasurement;
import de.qfm.erp.common.request.dashboard.DashboardFilterRequest;
import de.qfm.erp.common.response.dashboard.DashboardTableResponse;
import de.qfm.erp.common.response.dashboard.EDashboardFeature;
import de.qfm.erp.common.response.dashboard.EDashboardKey;
import de.qfm.erp.common.response.dashboard.ENotAccountedMeasurementGroupKey;
import de.qfm.erp.common.response.quotation.StageFulfilmentDegreeSimpleCommon;
import de.qfm.erp.service.configuration.DashboardConfig;
import de.qfm.erp.service.model.annotation.ProofOfConcept;
import de.qfm.erp.service.model.exception.response.ResourceNotFoundException;
import de.qfm.erp.service.model.internal.dashboard.EUseCase;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.internal.measurement.MeasurementFilter;
import de.qfm.erp.service.model.internal.message.Translatable;
import de.qfm.erp.service.model.internal.payroll.EExportFileName;
import de.qfm.erp.service.model.jpa.measurement.type.EMeasurementState;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.service.handler.MeasurementHandler;
import de.qfm.erp.service.service.handler.StageHandler;
import de.qfm.erp.service.service.mapper.DashboardMapper;
import de.qfm.erp.service.service.route.DashboardRoute;
import de.qfm.erp.service.service.route.impl.DashboardRouteImpl;
import de.qfm.erp.service.service.service.DataAggregationService;
import de.qfm.erp.service.service.service.DateTimeHelperService;
import de.qfm.erp.service.service.service.MessageService;
import de.qfm.erp.service.service.service.xls.NalXlsExportService;
import de.qfm.erp.service.service.validator.Validator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DashboardRouteImpl
implements DashboardRoute {
    private final DashboardConfig dashboardConfig;
    private final DateTimeHelperService dateTimeHelperService;
    private final MeasurementHandler measurementHandler;
    private final StageHandler stageHandler;
    private final DashboardMapper dashboardMapper;
    private final DataAggregationService dataAggregationServiceV1;
    private final MessageService messageService;
    private final NalXlsExportService nalXlsExportService;

    @Nonnull
    @Transactional(readOnly=true)
    public DashboardTableResponse byDashboardKeyCandidate(@NonNull String dashboardKeyCandidate, @NonNull DashboardFilterRequest dashboardFilterRequest) {
        if (dashboardKeyCandidate == null) {
            throw new NullPointerException("dashboardKeyCandidate is marked non-null but is null");
        }
        if (dashboardFilterRequest == null) {
            throw new NullPointerException("dashboardFilterRequest is marked non-null but is null");
        }
        Optional dashboardKeyOptional = EDashboardKey.lookup((String)dashboardKeyCandidate);
        if (dashboardKeyOptional.isPresent()) {
            EDashboardKey eDashboardKey = (EDashboardKey)dashboardKeyOptional.get();
            switch (1.$SwitchMap$de$qfm$erp$common$response$dashboard$EDashboardKey[eDashboardKey.ordinal()]) {
                case 1: {
                    return this.recentMeasurements();
                }
                case 2: {
                    return this.notAccountedMeasurements(dashboardFilterRequest);
                }
                case 3: {
                    return this.constructionSiteList(dashboardFilterRequest);
                }
            }
        }
        throw Validator.throwEnumException((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.DASHBOARD_KEY), (String)dashboardKeyCandidate, EDashboardKey.class, EDashboardKey::allowedKeys);
    }

    @Nonnull
    private DashboardTableResponse constructionSiteList(@NonNull DashboardFilterRequest dashboardFilterRequest) {
        if (dashboardFilterRequest == null) {
            throw new NullPointerException("dashboardFilterRequest is marked non-null but is null");
        }
        DashboardFilterMeasurement dashboardFilterMeasurement = dashboardFilterRequest.getMeasurement();
        DashboardFilterDateRange accountingMonth = dashboardFilterMeasurement.getAccountingMonth();
        Set assignedUserIds = dashboardFilterMeasurement.getAssignedUserIds();
        Boolean all = (Boolean)ObjectUtils.firstNonNull((Object[])new Boolean[]{dashboardFilterMeasurement.getAll(), Boolean.FALSE});
        String useCaseCandidate = StringUtils.trimToEmpty((String)dashboardFilterRequest.getUseCase());
        EUseCase useCase = EUseCase.lookup((String)useCaseCandidate, (EUseCase)EUseCase.UNKNOWN);
        boolean assignedUserIdsSet = null != assignedUserIds && !assignedUserIds.isEmpty();
        boolean accountingMonthSet = null != accountingMonth && (null != accountingMonth.getFrom() || null != accountingMonth.getTo());
        boolean anyFilterSet = accountingMonthSet || assignedUserIdsSet;
        int constructionSiteUnfilteredMaxPageSize = all != false ? this.dashboardConfig.getConstructionSiteAllPageSize() : this.dashboardConfig.getConstructionSiteUnfilteredMaxPageSize();
        int constructionSiteFilteredMaxPageSize = all != false ? this.dashboardConfig.getConstructionSiteAllPageSize() : this.dashboardConfig.getConstructionSiteFilteredMaxPageSize();
        PageRequest pageRequest = anyFilterSet ? PageRequest.of((int)0, (int)constructionSiteFilteredMaxPageSize) : PageRequest.of((int)0, (int)constructionSiteUnfilteredMaxPageSize);
        MeasurementFilter measurementFilter = this.dashboardMapper.measurementFilter((Pageable)pageRequest, dashboardFilterRequest, (Iterable)EMeasurementState.CONSTRUCTION_SITE, false, false);
        Page measurementsPage = this.measurementHandler.dashboard(measurementFilter);
        ImmutableSet dashboardFeatures = useCase == EUseCase.WIDGET ? ImmutableSet.of((Object)EDashboardFeature.HIDE_ASSIGNED_USER_COLUMNS) : ImmutableSet.of();
        return this.dashboardMapper.map(EDashboardKey.CONSTRUCTION_SITES, measurementsPage, (Iterable)dashboardFeatures, useCase);
    }

    @Nonnull
    @Transactional(readOnly=true)
    public DashboardTableResponse notAccountedMeasurements(@NonNull DashboardFilterRequest dashboardFilterRequest) {
        if (dashboardFilterRequest == null) {
            throw new NullPointerException("dashboardFilterRequest is marked non-null but is null");
        }
        Pageable pageRequest = Pageable.unpaged();
        MeasurementFilter measurementFilter = this.dashboardMapper.measurementFilter(pageRequest, dashboardFilterRequest, (Iterable)EMeasurementState.NOT_ACCOUNTED_STATES, true, true);
        String useCaseCandidate = StringUtils.trimToEmpty((String)dashboardFilterRequest.getUseCase());
        EUseCase useCase = EUseCase.lookup((String)useCaseCandidate, (EUseCase)EUseCase.UNKNOWN);
        Page measurementsPage = this.measurementHandler.notAccounted(measurementFilter);
        return this.dashboardMapper.map(EDashboardKey.NOT_ACCOUNTED_MEASUREMENTS, measurementsPage, (Iterable)ImmutableSet.of(), useCase);
    }

    @Nonnull
    @Transactional(readOnly=true)
    public DashboardTableResponse recentMeasurements() {
        MeasurementFilter measurementFilter = MeasurementFilter.of((boolean)false, (boolean)false, (boolean)false, (String)"", (String)"", (Iterable)ImmutableList.of(), (Iterable)ImmutableList.of(), (Iterable)ImmutableList.of(), (Iterable)ImmutableList.of(), (Iterable)ImmutableList.of(), (Iterable)ImmutableList.of(), (Iterable)ImmutableList.of(), (Pageable)PageRequest.of((int)0, (int)25), (Iterable)ImmutableList.of(), (Range)Range.all(), (Range)Range.all(), (Range)Range.all(), (Iterable)ImmutableSet.of(), (Iterable)ImmutableSet.of());
        Page all = this.measurementHandler.dashboard(measurementFilter);
        return this.dashboardMapper.map(EDashboardKey.RECENT_MEASUREMENTS, all, (Iterable)ImmutableSet.of((Object)EDashboardFeature.HIDE_ASSIGNED_USER_COLUMNS), EUseCase.PAGE);
    }

    @Nonnull
    @ProofOfConcept(value="Quotation Fulfilment for Dashboards")
    public StageFulfilmentDegreeSimpleCommon quotationFulfilmentDegree(@NonNull Long stageId) {
        if (stageId == null) {
            throw new NullPointerException("stageId is marked non-null but is null");
        }
        Quotation stage = (Quotation)this.stageHandler.byIdFailing(stageId);
        return this.dataAggregationServiceV1.stageFulfilmentDegree((Iterable)ImmutableList.of((Object)stage), (Iterable)ImmutableList.of(), (Iterable)ImmutableList.of(), Range.all(), (Iterable)ImmutableList.of(), false, false, false, false);
    }

    @Nonnull
    public Pair<String, byte[]> xlsByDashboardKeyCandidate(@NonNull String dashboardKeyCandidate, @NonNull String groupKeyCandidate, @NonNull DashboardFilterRequest dashboardFilterRequest) throws IOException {
        if (dashboardKeyCandidate == null) {
            throw new NullPointerException("dashboardKeyCandidate is marked non-null but is null");
        }
        if (groupKeyCandidate == null) {
            throw new NullPointerException("groupKeyCandidate is marked non-null but is null");
        }
        if (dashboardFilterRequest == null) {
            throw new NullPointerException("dashboardFilterRequest is marked non-null but is null");
        }
        Optional dashboardKeyOptional = EDashboardKey.lookup((String)dashboardKeyCandidate);
        Optional groupKeyOptional = ENotAccountedMeasurementGroupKey.lookup((String)groupKeyCandidate);
        if (dashboardKeyOptional.isPresent() && groupKeyOptional.isPresent()) {
            EDashboardKey dashboardKey = (EDashboardKey)dashboardKeyOptional.get();
            ENotAccountedMeasurementGroupKey groupKey = (ENotAccountedMeasurementGroupKey)groupKeyOptional.get();
            if (dashboardKey == EDashboardKey.NOT_ACCOUNTED_MEASUREMENTS) {
                MeasurementFilter measurementFilter = this.dashboardMapper.measurementFilter(Pageable.unpaged(), dashboardFilterRequest, (Iterable)EMeasurementState.NOT_ACCOUNTED_STATES, true, true);
                Page measurementsPage = this.measurementHandler.notAccounted(measurementFilter);
                if (groupKey == ENotAccountedMeasurementGroupKey.UNGROUPED) {
                    Iterable ungrouped = this.dashboardMapper.mapToXLSUngrouped(measurementsPage);
                    SXSSFWorkbook nal = this.nalXlsExportService.ungroupedXLS(ungrouped, "NAL");
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    nal.write((OutputStream)byteArrayOutputStream);
                    nal.close();
                    byte[] bytes = byteArrayOutputStream.toByteArray();
                    String dateForFile = this.dateTimeHelperService.dateForFile();
                    String fileName = this.messageService.getDE((Translatable)EExportFileName.NAL_UNGROUPED_AS_XLSX, new Object[]{dateForFile});
                    return Pair.of((Object)fileName, (Object)bytes);
                }
                if (groupKey == ENotAccountedMeasurementGroupKey.GROUPED_BY_QUOTATION_NUMBER) {
                    Iterable grouped = this.dashboardMapper.mapToXLSGroupedByStageNumber(measurementsPage);
                    SXSSFWorkbook nal = this.nalXlsExportService.groupedXLS(grouped, "NAL");
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    nal.write((OutputStream)byteArrayOutputStream);
                    byte[] bytes = byteArrayOutputStream.toByteArray();
                    nal.close();
                    String dateForFile = this.dateTimeHelperService.dateForFile();
                    String fileName = this.messageService.getDE((Translatable)EExportFileName.NAL_GROUPED_AS_XLSX, new Object[]{dateForFile});
                    return Pair.of((Object)fileName, (Object)bytes);
                }
                throw Validator.throwEnumException((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.GROUP_KEY), (String)dashboardKeyCandidate, ENotAccountedMeasurementGroupKey.class, ENotAccountedMeasurementGroupKey::allowedKeys);
            }
            throw Validator.throwEnumException((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.DASHBOARD_KEY), (String)dashboardKeyCandidate, EDashboardKey.class, EDashboardKey::allowedKeys);
        }
        throw ResourceNotFoundException.of((String)"Dashboard/XLS", () -> "dashboardKey / groupKey", (String)(dashboardKeyCandidate + " / " + groupKeyCandidate));
    }

    public DashboardRouteImpl(DashboardConfig dashboardConfig, DateTimeHelperService dateTimeHelperService, MeasurementHandler measurementHandler, StageHandler stageHandler, DashboardMapper dashboardMapper, DataAggregationService dataAggregationServiceV1, MessageService messageService, NalXlsExportService nalXlsExportService) {
        this.dashboardConfig = dashboardConfig;
        this.dateTimeHelperService = dateTimeHelperService;
        this.measurementHandler = measurementHandler;
        this.stageHandler = stageHandler;
        this.dashboardMapper = dashboardMapper;
        this.dataAggregationServiceV1 = dataAggregationServiceV1;
        this.messageService = messageService;
        this.nalXlsExportService = nalXlsExportService;
    }
}

