/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.route.impl;

import de.qfm.erp.common.response.businessunit.BusinessUnitsResponse;
import de.qfm.erp.common.response.businessunit.BusinessUnitsTreeResponse;
import de.qfm.erp.service.model.internal.businessunit.BusinessUnitTree;
import de.qfm.erp.service.service.handler.BusinessUnitHandler;
import de.qfm.erp.service.service.mapper.BusinessUnitMapper;
import de.qfm.erp.service.service.route.impl.BusinessUnitRoute;
import de.qfm.erp.service.service.service.BusinessUnitService;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BusinessUnitRouteImpl
implements BusinessUnitRoute {
    private static final Logger log = LogManager.getLogger(BusinessUnitRouteImpl.class);
    private final BusinessUnitHandler businessUnitHandler;
    private final BusinessUnitMapper businessUnitMapper;
    private final BusinessUnitService businessUnitService;

    @Transactional(readOnly=true)
    @Nonnull
    public BusinessUnitsResponse list(boolean includeDeleted) {
        Iterable all = this.businessUnitHandler.findAll(includeDeleted);
        return this.businessUnitMapper.mapToResponse(all);
    }

    @Transactional(readOnly=true)
    @Nullable
    public BusinessUnitsTreeResponse tree(long id, int maxLevels) {
        BusinessUnitTree businessUnitTree = this.businessUnitService.tree(id, maxLevels);
        return this.businessUnitMapper.mapToResponse(businessUnitTree);
    }

    public BusinessUnitRouteImpl(BusinessUnitHandler businessUnitHandler, BusinessUnitMapper businessUnitMapper, BusinessUnitService businessUnitService) {
        this.businessUnitHandler = businessUnitHandler;
        this.businessUnitMapper = businessUnitMapper;
        this.businessUnitService = businessUnitService;
    }
}

