/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.route.impl;

import de.qfm.erp.common.request.generic.BankingHolidayUpdateRequest;
import de.qfm.erp.common.response.DeleteResponse;
import de.qfm.erp.common.response.generic.BankingHolidayCommon;
import de.qfm.erp.common.response.generic.BankingHolidayPageCommon;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.generic.BankingHoliday;
import de.qfm.erp.service.model.jpa.generic.EFederalState;
import de.qfm.erp.service.service.handler.BankingHolidayHandler;
import de.qfm.erp.service.service.handler.EntityFactory;
import de.qfm.erp.service.service.mapper.BankingHolidayMapper;
import de.qfm.erp.service.service.route.BankingHolidayRoute;
import de.qfm.erp.service.service.validator.Validator;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class BankingHolidayRouteImpl
implements BankingHolidayRoute {
    private static final Logger log = LogManager.getLogger(BankingHolidayRouteImpl.class);
    private final EntityFactory entityFactory;
    private final BankingHolidayHandler handler;
    private final BankingHolidayMapper mapper;

    @Nonnull
    public BankingHolidayPageCommon page(int page, int size) {
        return this.mapper.map(this.handler.page((Pageable)PageRequest.of((int)page, (int)size)));
    }

    @Nonnull
    public BankingHolidayCommon byId(long id) {
        return this.mapper.map((BankingHoliday)this.handler.byIdFailing(Long.valueOf(id)));
    }

    @Nonnull
    public BankingHolidayCommon create(@NonNull BankingHolidayUpdateRequest updateRequest) {
        if (updateRequest == null) {
            throw new NullPointerException("updateRequest is marked non-null but is null");
        }
        BankingHoliday bankingHolidayCreated = this.entityFactory.bankingHoliday();
        return this.mergeAndPersist(bankingHolidayCreated, updateRequest);
    }

    @Nonnull
    public BankingHolidayCommon update(long id, @NonNull BankingHolidayUpdateRequest updateRequest) {
        if (updateRequest == null) {
            throw new NullPointerException("updateRequest is marked non-null but is null");
        }
        BankingHoliday bankingHolidayExisting = (BankingHoliday)this.handler.byIdFailing(Long.valueOf(id));
        return this.mergeAndPersist(bankingHolidayExisting, updateRequest);
    }

    @Nonnull
    public DeleteResponse deleteById(long id) {
        BankingHoliday bankingHoliday = (BankingHoliday)this.handler.byIdFailing(Long.valueOf(id));
        BankingHoliday deletedBankingHoliday = (BankingHoliday)this.handler.delete((EntityBase)bankingHoliday);
        return DeleteResponse.of((Long)id, (String)"ok");
    }

    @Nonnull
    private BankingHolidayCommon mergeAndPersist(@NonNull BankingHoliday entity, @NonNull BankingHolidayUpdateRequest updateRequest) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        if (updateRequest == null) {
            throw new NullPointerException("updateRequest is marked non-null but is null");
        }
        String federalStateCandidate = updateRequest.getFederalState();
        EFederalState federalState = EFederalState.lookup((String)federalStateCandidate, (EFederalState)EFederalState.UNKNOWN);
        if (EFederalState.UNKNOWN == federalState) {
            throw Validator.throwEnumException((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.BANKING_HOLIDAY__FEDERAL_STATE), (String)federalStateCandidate, EFederalState.class, EFederalState::allowedKeys);
        }
        BankingHoliday bankingHolidayMerged = this.mapper.merge(entity, updateRequest, federalState);
        BankingHoliday bankingHolidayUpdated = (BankingHoliday)this.handler.update((EntityBase)bankingHolidayMerged);
        return this.mapper.map(bankingHolidayUpdated);
    }

    public BankingHolidayRouteImpl(EntityFactory entityFactory, BankingHolidayHandler handler, BankingHolidayMapper mapper) {
        this.entityFactory = entityFactory;
        this.handler = handler;
        this.mapper = mapper;
    }
}

