/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.queue;

import de.qfm.erp.service.model.jpa.queue.EQueueItemType;
import de.qfm.erp.service.model.jpa.queue.EReferenceType;
import de.qfm.erp.service.model.jpa.queue.QueueItem;
import de.qfm.erp.service.service.queue.PssReleaseOrderNameChangeProcessor;
import de.qfm.erp.service.service.queue.QueueProcessor;
import de.qfm.erp.service.service.route.MeasurementRoute;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class PssReleaseOrderNameChangeProcessor
implements QueueProcessor {
    private static final Logger log = LogManager.getLogger(PssReleaseOrderNameChangeProcessor.class);
    private final MeasurementRoute measurementRoute;

    @Nonnull
    public EReferenceType referenceType() {
        return EReferenceType.PSS_RELEASE_ORDER;
    }

    public boolean process(@NonNull QueueItem queueItem) {
        if (queueItem == null) {
            throw new NullPointerException("queueItem is marked non-null but is null");
        }
        try {
            Long referenceId = queueItem.getReferenceId();
            EReferenceType referenceType = queueItem.getReferenceType();
            EQueueItemType queueItemType = queueItem.getQueueItemType();
            switch (1.$SwitchMap$de$qfm$erp$service$model$jpa$queue$EQueueItemType[queueItemType.ordinal()]) {
                case 1: {
                    return this.measurementRoute.handlePssReleaseOrderUpdate(referenceId);
                }
                case 2: 
                case 3: {
                    return true;
                }
            }
        }
        catch (Exception e) {
            log.error("Error Processing QueueItem, Error: {}", (Object)e.getMessage(), (Object)e);
            return false;
        }
        return true;
    }

    public PssReleaseOrderNameChangeProcessor(MeasurementRoute measurementRoute) {
        this.measurementRoute = measurementRoute;
    }
}

