/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper.search;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import de.qfm.erp.service.model.search.UserIndexEntry;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class UserIndexEntrySerializer {
    private static final Logger log = LogManager.getLogger(UserIndexEntrySerializer.class);
    private final ObjectMapper objectMapper;

    @NonNull
    @VisibleForTesting
    public String serialize(@NonNull UserIndexEntry item) throws JsonProcessingException {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return this.objectMapper.writeValueAsString((Object)item);
    }

    @Nonnull
    public Optional<UserIndexEntry> unSerialize(@NonNull String json) {
        if (json == null) {
            throw new NullPointerException("json is marked non-null but is null");
        }
        try {
            return Optional.of((UserIndexEntry)this.objectMapper.readValue(json, UserIndexEntry.class));
        }
        catch (JsonProcessingException e) {
            log.error("Cannot Unserialize UserIndexEntry from value: {}, Error: {}", (Object)json, (Object)e.getMessage());
            return Optional.empty();
        }
    }

    public UserIndexEntrySerializer(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

