/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import de.qfm.erp.common.response.EntityBaseCommon;
import de.qfm.erp.common.response.user.WageAccountCommon;
import de.qfm.erp.service.model.internal.MergedBucket;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.EntityState;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonthItem;
import de.qfm.erp.service.model.jpa.employee.payroll.WageAccount;
import de.qfm.erp.service.model.jpa.employee.payroll.WageAccountTransaction;
import de.qfm.erp.service.service.handler.EntityFactory;
import de.qfm.erp.service.service.mapper.BaseMapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.springframework.stereotype.Service;

@Service
public class WageAccountMapper {
    private final EntityFactory entityFactory;

    @Nonnull
    public MergedBucket<WageAccountTransaction> merge(@NonNull WageAccount wageAccount, @NonNull MergedBucket<PayrollMonthItem> wageAccountPayrollItemsMerged) {
        if (wageAccount == null) {
            throw new NullPointerException("wageAccount is marked non-null but is null");
        }
        if (wageAccountPayrollItemsMerged == null) {
            throw new NullPointerException("wageAccountPayrollItemsMerged is marked non-null but is null");
        }
        ImmutableList.Builder addedBuilder = ImmutableList.builder();
        Iterable added = wageAccountPayrollItemsMerged.getAdded();
        for (PayrollMonthItem payrollMonthItem : added) {
            WageAccountTransaction wageAccountTransaction = this.entityFactory.wageAccountTransaction();
            BigDecimal amountOld = BigDecimal.ZERO;
            BigDecimal amountNew = ((BigDecimal)MoreObjects.firstNonNull((Object)payrollMonthItem.getValue(), (Object)BigDecimal.ZERO)).negate();
            BigDecimal balanceOld = wageAccount.getBalance().setScale(2, RoundingMode.HALF_UP);
            BigDecimal balanceNew = balanceOld.subtract(amountOld).add(amountNew).setScale(2, RoundingMode.HALF_UP);
            wageAccount.setBalance(balanceNew);
            wageAccountTransaction.setSender(payrollMonthItem.getSender());
            wageAccountTransaction.setRecipient(payrollMonthItem.getRecipient());
            wageAccountTransaction.setOriginalStage(payrollMonthItem.getQuotation());
            wageAccountTransaction.setBalanceOld(balanceOld);
            wageAccountTransaction.setBalanceNew(balanceNew);
            wageAccountTransaction.setAmount(amountNew);
            wageAccountTransaction.setWageAccount(wageAccount);
            wageAccountTransaction.setWageAccountOriginal(null);
            payrollMonthItem.setWageAccountTransaction(wageAccountTransaction);
            addedBuilder.add((Object)wageAccountTransaction);
        }
        ImmutableList wageAccountTransactionsAdded = addedBuilder.build();
        ImmutableList.Builder updatedBuilder = ImmutableList.builder();
        Iterable updated = wageAccountPayrollItemsMerged.getUpdated();
        for (PayrollMonthItem payrollMonthItem : updated) {
            WageAccountTransaction wageAccountTransaction = payrollMonthItem.getWageAccountTransaction();
            BigDecimal amountOld = (BigDecimal)MoreObjects.firstNonNull((Object)wageAccountTransaction.getAmount(), (Object)BigDecimal.ZERO);
            BigDecimal amountNew = ((BigDecimal)MoreObjects.firstNonNull((Object)payrollMonthItem.getValue(), (Object)BigDecimal.ZERO)).negate();
            BigDecimal balanceOld = wageAccount.getBalance().setScale(2, RoundingMode.HALF_UP);
            BigDecimal balanceNew = balanceOld.subtract(amountOld).add(amountNew).setScale(2, RoundingMode.HALF_UP);
            wageAccount.setBalance(balanceNew);
            wageAccountTransaction.setSender(payrollMonthItem.getSender());
            wageAccountTransaction.setRecipient(payrollMonthItem.getRecipient());
            wageAccountTransaction.setOriginalStage(payrollMonthItem.getQuotation());
            wageAccountTransaction.setBalanceOld(balanceOld);
            wageAccountTransaction.setBalanceNew(balanceNew);
            wageAccountTransaction.setAmount(amountNew);
            payrollMonthItem.setWageAccountTransaction(wageAccountTransaction);
            updatedBuilder.add((Object)wageAccountTransaction);
        }
        ImmutableList wageAccountTransactionsUpdated = updatedBuilder.build();
        ImmutableList.Builder deletedBuilder = ImmutableList.builder();
        Iterable deleted = wageAccountPayrollItemsMerged.getDeleted();
        for (PayrollMonthItem payrollMonthItem : deleted) {
            WageAccountTransaction wageAccountTransaction = payrollMonthItem.getWageAccountTransaction();
            BigDecimal amountOld = (BigDecimal)MoreObjects.firstNonNull((Object)wageAccountTransaction.getAmount(), (Object)BigDecimal.ZERO);
            BigDecimal amountNew = BigDecimal.ZERO;
            BigDecimal balanceOld = wageAccount.getBalance().setScale(2, RoundingMode.HALF_UP);
            BigDecimal balanceNew = balanceOld.subtract(amountOld).add(amountNew).setScale(2, RoundingMode.HALF_UP);
            wageAccount.setBalance(balanceNew);
            wageAccountTransaction.setSender(payrollMonthItem.getSender());
            wageAccountTransaction.setRecipient(payrollMonthItem.getRecipient());
            wageAccountTransaction.setOriginalStage(payrollMonthItem.getQuotation());
            wageAccountTransaction.setBalanceOld(balanceOld);
            wageAccountTransaction.setBalanceNew(balanceNew);
            wageAccountTransaction.setAmount(amountNew);
            wageAccountTransaction.setOriginalAmount(amountOld);
            wageAccountTransaction.setWageAccount(null);
            wageAccountTransaction.setWageAccountOriginal(wageAccount);
            wageAccountTransaction.setEntityState(EntityState.DELETED);
            payrollMonthItem.setWageAccountTransaction(null);
            deletedBuilder.add((Object)wageAccountTransaction);
        }
        ImmutableList wageAccountTransactionsDeleted = deletedBuilder.build();
        return MergedBucket.of((Iterable)wageAccountTransactionsAdded, (Iterable)wageAccountTransactionsUpdated, (Iterable)wageAccountTransactionsDeleted);
    }

    @Nonnull
    public WageAccountCommon map(@NonNull WageAccount entity) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        WageAccountCommon common = new WageAccountCommon();
        BaseMapper.map((EntityBase)entity, (EntityBaseCommon)common);
        common.setId(entity.getId());
        common.setLimit((BigDecimal)MoreObjects.firstNonNull((Object)entity.getLimit(), (Object)BigDecimal.ZERO));
        common.setBalance((BigDecimal)MoreObjects.firstNonNull((Object)entity.getBalance(), (Object)BigDecimal.ZERO));
        return common;
    }

    public WageAccountMapper(EntityFactory entityFactory) {
        this.entityFactory = entityFactory;
    }
}

