/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import com.google.common.collect.Lists;
import de.qfm.erp.common.request.tracking.TrackingPointPayloadItem;
import de.qfm.erp.common.response.tracking.TrackingPointCommon;
import de.qfm.erp.service.model.internal.tracking.TrackingPointBucket;
import de.qfm.erp.service.model.jpa.tracking.ETrackingCategory;
import de.qfm.erp.service.model.jpa.tracking.TrackingPoint;
import de.qfm.erp.service.model.jpa.tracking.TrackingPointPayload;
import java.util.List;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class TrackingPointMapper {
    private static final Logger log = LogManager.getLogger(TrackingPointMapper.class);

    @Nonnull
    public TrackingPointCommon map(@NonNull TrackingPoint trackingPoint) {
        if (trackingPoint == null) {
            throw new NullPointerException("trackingPoint is marked non-null but is null");
        }
        TrackingPointCommon common = new TrackingPointCommon();
        common.setCategory(trackingPoint.getCategory().name());
        common.setKey(trackingPoint.getKey());
        return common;
    }

    @Nonnull
    public TrackingPoint merge(@NonNull TrackingPointBucket trackingPointBucket) {
        if (trackingPointBucket == null) {
            throw new NullPointerException("trackingPointBucket is marked non-null but is null");
        }
        TrackingPoint trackingPoint = trackingPointBucket.getTrackingPoint();
        String key = trackingPointBucket.getKey();
        ETrackingCategory category = trackingPointBucket.getCategory();
        Iterable payload = trackingPointBucket.getPayload();
        trackingPoint.setKey(key);
        trackingPoint.setCategory(category);
        if (null == trackingPoint.getPayload()) {
            trackingPoint.setPayload((List)Lists.newArrayList());
        }
        payload.forEach(item -> item.setTrackingPoint(trackingPoint));
        payload.forEach(item -> trackingPoint.getPayload().add(item));
        return trackingPoint;
    }

    @Nonnull
    public TrackingPointPayload merge(@NonNull TrackingPointPayload entity, @NonNull TrackingPointPayloadItem request) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        entity.setKey(request.getKey());
        entity.setValue(request.getValue());
        return entity;
    }
}

