/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Longs;
import de.qfm.erp.common.request.taxkey.TaxKeyUpdateRequest;
import de.qfm.erp.common.response.EntityBaseCommon;
import de.qfm.erp.common.response.taxkey.TaxKeyCommon;
import de.qfm.erp.common.response.taxkey.TaxKeyPageCommon;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.invoice.EInvoiceType;
import de.qfm.erp.service.model.jpa.invoice.TaxKey;
import de.qfm.erp.service.service.mapper.BaseMapper;
import java.util.List;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class TaxKeyMapper {
    private static final Logger log = LogManager.getLogger(TaxKeyMapper.class);

    @Nonnull
    public TaxKeyCommon map(@NonNull TaxKey entity) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        TaxKeyCommon common = new TaxKeyCommon();
        BaseMapper.map((EntityBase)entity, (EntityBaseCommon)common);
        common.setId(entity.getId());
        common.setName(entity.getName());
        EInvoiceType invoiceType = (EInvoiceType)MoreObjects.firstNonNull((Object)entity.getInvoiceType(), (Object)EInvoiceType.UNKNOWN);
        common.setInvoiceType(invoiceType.name());
        common.setTaxKey(entity.getTaxKey());
        common.setVat(entity.getVat());
        common.setAccount(entity.getAccount());
        common.setCounterAccount(entity.getCounterAccount());
        common.setWarrantySecurityRetentionAccount(entity.getWarrantySecurityRetentionAccount());
        common.setFulfillmentSecurityRetentionAccount(entity.getFulfillmentSecurityRetentionAccount());
        common.setFlagSubContractorAsExternalServiceAccounting((Boolean)MoreObjects.firstNonNull((Object)entity.getFlagSubContractorAsExternalServiceAccounting(), (Object)false));
        common.setFlagCompanyGroup((Boolean)MoreObjects.firstNonNull((Object)entity.getFlagCompanyGroup(), (Object)false));
        return common;
    }

    @Nonnull
    public TaxKeyPageCommon map(@NonNull Page<TaxKey> page) {
        if (page == null) {
            throw new NullPointerException("page is marked non-null but is null");
        }
        long totalElements = page.getTotalElements();
        int totalPages = page.getTotalPages();
        Pageable pageable = page.getPageable();
        int pageSize = pageable.getPageSize();
        int pageNumber = pageable.getPageNumber();
        List content = page.getContent();
        List itemsCommon = (List)content.stream().map(arg_0 -> this.map(arg_0)).sorted((l, r) -> Longs.compare((long)l.getId(), (long)r.getId())).collect(ImmutableList.toImmutableList());
        return new TaxKeyPageCommon(pageNumber, pageSize, totalPages, totalElements, itemsCommon);
    }

    @Nonnull
    public TaxKey merge(@NonNull TaxKeyUpdateRequest updateRequest, @NonNull EInvoiceType invoiceType, @NonNull TaxKey taxKey) {
        if (updateRequest == null) {
            throw new NullPointerException("updateRequest is marked non-null but is null");
        }
        if (invoiceType == null) {
            throw new NullPointerException("invoiceType is marked non-null but is null");
        }
        if (taxKey == null) {
            throw new NullPointerException("taxKey is marked non-null but is null");
        }
        taxKey.setName(StringUtils.trimToEmpty((String)updateRequest.getName()));
        taxKey.setTaxKey(StringUtils.trimToEmpty((String)updateRequest.getTaxKey()));
        taxKey.setVat(updateRequest.getVat());
        taxKey.setAccount(StringUtils.trimToEmpty((String)updateRequest.getAccount()));
        taxKey.setCounterAccount(StringUtils.trimToEmpty((String)updateRequest.getCounterAccount()));
        taxKey.setWarrantySecurityRetentionAccount(StringUtils.trimToEmpty((String)updateRequest.getWarrantySecurityRetentionAccount()));
        taxKey.setFulfillmentSecurityRetentionAccount(StringUtils.trimToEmpty((String)updateRequest.getFulfillmentSecurityRetentionAccount()));
        taxKey.setFlagSubContractorAsExternalServiceAccounting((Boolean)MoreObjects.firstNonNull((Object)updateRequest.getFlagSubContractorAsExternalServiceAccounting(), (Object)false));
        taxKey.setFlagCompanyGroup((Boolean)MoreObjects.firstNonNull((Object)updateRequest.getFlagCompanyGroup(), (Object)false));
        taxKey.setInvoiceType(invoiceType);
        return taxKey;
    }
}

