/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import com.google.common.collect.ImmutableList;
import de.leancoders.common.helper.IterableHelper;
import de.qfm.erp.common.response.synclog.SyncLogCommon;
import de.qfm.erp.common.response.synclog.SyncLogPageCommon;
import de.qfm.erp.service.model.jpa.sync.SyncLog;
import java.util.List;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class SyncLogMapper {
    @Nonnull
    public SyncLogPageCommon map(@NonNull Page<SyncLog> syncLogs) {
        if (syncLogs == null) {
            throw new NullPointerException("syncLogs is marked non-null but is null");
        }
        ImmutableList commons = ImmutableList.copyOf(IterableHelper.stream(syncLogs).map(arg_0 -> this.map(arg_0)).iterator());
        Pageable pageable = syncLogs.getPageable();
        int page = pageable.getPageNumber();
        int size = pageable.getPageSize();
        int totalPages = syncLogs.getTotalPages();
        long totalElements = syncLogs.getTotalElements();
        return new SyncLogPageCommon(page, size, totalPages, totalElements, (List)commons);
    }

    @Nonnull
    public SyncLogCommon map(@NonNull SyncLog syncLog) {
        if (syncLog == null) {
            throw new NullPointerException("syncLog is marked non-null but is null");
        }
        SyncLogCommon common = new SyncLogCommon();
        common.setId((long)syncLog.getId());
        common.setOrigin(syncLog.getOrigin().name());
        common.setReferenceType(syncLog.getReferenceType().name());
        common.setReferenceId(syncLog.getReferenceId());
        common.setMessage(syncLog.getMessage());
        return common;
    }
}

