/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import de.qfm.erp.service.model.internal.MergedBucket;
import de.qfm.erp.service.model.internal.quotation.StageNotifyBucket;
import de.qfm.erp.service.model.internal.quotation.StageResponsibleBucket;
import de.qfm.erp.service.model.internal.quotation.StageSignatureBucket;
import de.qfm.erp.service.model.internal.quotation.StageUpdateBucket;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.quotation.StageNotifyUser;
import de.qfm.erp.service.model.jpa.quotation.StageResponsibleUser;
import de.qfm.erp.service.model.jpa.quotation.StageSignatureUser;
import de.qfm.erp.service.service.handler.EntityFactory;
import de.qfm.erp.service.service.mapper.BaseMapper;
import de.qfm.erp.service.service.security.AuthenticationHelper;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class StageUserMapper {
    private static final Logger log = LogManager.getLogger(StageUserMapper.class);
    private final AuthenticationHelper authenticationHelper;
    private final EntityFactory entityFactory;
    @NonNull
    public static final BiConsumer<StageNotifyUser, StageNotifyBucket> NOOP_QSNU = (entity, updateItem) -> {};
    @NonNull
    public static final BiConsumer<StageResponsibleUser, StageResponsibleBucket> NOOP_QSRU = (entity, updateItem) -> {};
    @NonNull
    public static final BiConsumer<StageSignatureUser, StageSignatureBucket> NOOP_QSSU = (entity, updateItem) -> {};

    @Nonnull
    public MergedBucket<StageNotifyUser> mergeNotifyUsers(@NonNull StageUpdateBucket stageUpdateBucket) {
        if (stageUpdateBucket == null) {
            throw new NullPointerException("stageUpdateBucket is marked non-null but is null");
        }
        Quotation quotation = (Quotation)stageUpdateBucket.getEntity();
        Iterable notifyUsers = stageUpdateBucket.getNotifyUsers();
        MergedBucket mergedBucket = BaseMapper.merge((EntityBase)quotation, Quotation::getStageNotifyUsers, arg_0 -> ((Quotation)quotation).setStageNotifyUsers(arg_0), (Iterable)notifyUsers, StageNotifyBucket::getId, StageNotifyUser::getId, () -> ((EntityFactory)this.entityFactory).stageNotifyUser(), (arg_0, arg_1) -> this.mergeStateNotifyUser(arg_0, arg_1), StageNotifyUser::setQuotation, () -> ((AuthenticationHelper)this.authenticationHelper).currentUserName(), (BiConsumer)NOOP_QSNU);
        MergedBucket.printMergeBucket((Object)quotation, StageNotifyUser.class, (MergedBucket)mergedBucket);
        return mergedBucket;
    }

    @Nonnull
    public StageNotifyUser mergeStateNotifyUser(@NonNull StageNotifyUser stageNotifyUser, @NonNull StageNotifyBucket updateBucket) {
        if (stageNotifyUser == null) {
            throw new NullPointerException("stageNotifyUser is marked non-null but is null");
        }
        if (updateBucket == null) {
            throw new NullPointerException("updateBucket is marked non-null but is null");
        }
        stageNotifyUser.setUser(updateBucket.getUser());
        return stageNotifyUser;
    }

    @Nonnull
    public MergedBucket<StageResponsibleUser> mergeResponsibleUsers(@NonNull Quotation quotation, Iterable<StageResponsibleBucket> responsibleBuckets) {
        if (quotation == null) {
            throw new NullPointerException("quotation is marked non-null but is null");
        }
        MergedBucket mergedBucket = BaseMapper.merge((EntityBase)quotation, Quotation::getStageResponsibleUsers, arg_0 -> ((Quotation)quotation).setStageResponsibleUsers(arg_0), responsibleBuckets, StageResponsibleBucket::getId, StageResponsibleUser::getId, () -> ((EntityFactory)this.entityFactory).stageResponsibleUser(), (arg_0, arg_1) -> this.mergeStateNotifyUser(arg_0, arg_1), StageResponsibleUser::setQuotation, () -> ((AuthenticationHelper)this.authenticationHelper).currentUserName(), (BiConsumer)NOOP_QSRU);
        MergedBucket.printMergeBucket((Object)quotation, StageResponsibleUser.class, (MergedBucket)mergedBucket);
        return mergedBucket;
    }

    @Nonnull
    public StageResponsibleUser mergeStateNotifyUser(@NonNull StageResponsibleUser stageNotifyUser, @NonNull StageResponsibleBucket updateBucket) {
        if (stageNotifyUser == null) {
            throw new NullPointerException("stageNotifyUser is marked non-null but is null");
        }
        if (updateBucket == null) {
            throw new NullPointerException("updateBucket is marked non-null but is null");
        }
        stageNotifyUser.setUser(updateBucket.getUser());
        return stageNotifyUser;
    }

    @Nonnull
    public MergedBucket<StageSignatureUser> mergeStageSignatureUsers(@NonNull StageUpdateBucket stageUpdateBucket) {
        if (stageUpdateBucket == null) {
            throw new NullPointerException("stageUpdateBucket is marked non-null but is null");
        }
        Quotation quotation = (Quotation)stageUpdateBucket.getEntity();
        Iterable buckets = stageUpdateBucket.getSignatureUsers();
        MergedBucket mergedBucket = BaseMapper.merge((EntityBase)quotation, Quotation::getStageSignatureUsers, arg_0 -> ((Quotation)quotation).setStageSignatureUsers(arg_0), (Iterable)buckets, StageSignatureBucket::getId, StageSignatureUser::getId, () -> ((EntityFactory)this.entityFactory).stageSignatureUser(), (arg_0, arg_1) -> this.mergeStateNotifyUser(arg_0, arg_1), StageSignatureUser::setQuotation, () -> ((AuthenticationHelper)this.authenticationHelper).currentUserName(), (BiConsumer)NOOP_QSSU);
        MergedBucket.printMergeBucket((Object)quotation, StageSignatureUser.class, (MergedBucket)mergedBucket);
        return mergedBucket;
    }

    @Nonnull
    public StageSignatureUser mergeStateNotifyUser(@NonNull StageSignatureUser stageNotifyUser, @NonNull StageSignatureBucket updateBucket) {
        if (stageNotifyUser == null) {
            throw new NullPointerException("stageNotifyUser is marked non-null but is null");
        }
        if (updateBucket == null) {
            throw new NullPointerException("updateBucket is marked non-null but is null");
        }
        stageNotifyUser.setUser(updateBucket.getUser());
        return stageNotifyUser;
    }

    public StageUserMapper(AuthenticationHelper authenticationHelper, EntityFactory entityFactory) {
        this.authenticationHelper = authenticationHelper;
        this.entityFactory = entityFactory;
    }
}

