/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import de.leancoders.common.helper.IterableHelper;
import de.qfm.erp.common.request.quotation.StagePositionUpdateItem;
import de.qfm.erp.common.response.EntityBaseCommon;
import de.qfm.erp.common.response.quotation.StagePositionCommon;
import de.qfm.erp.common.response.quotation.StagePositionPageCommon;
import de.qfm.erp.service.helper.StagePositionHelper;
import de.qfm.erp.service.helper.comparator.quotation.QuotationPositionComparator;
import de.qfm.erp.service.model.internal.MergedBucket;
import de.qfm.erp.service.model.internal.gaeb.EGaebPositionType;
import de.qfm.erp.service.model.internal.gaeb.GaebExtractResult;
import de.qfm.erp.service.model.internal.gaeb.GaebPosition;
import de.qfm.erp.service.model.internal.gaeb.ItemFormat;
import de.qfm.erp.service.model.internal.quotation.EQuotationPositionSortOption;
import de.qfm.erp.service.model.internal.quotation.EStagePositionMergeOption;
import de.qfm.erp.service.model.internal.quotation.QStagePositionUpdateBucket;
import de.qfm.erp.service.model.internal.quotation.QuotationBucket;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.quotation.EQStageType;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.quotation.QuotationPosition;
import de.qfm.erp.service.model.jpa.shared.EAlternativePositionType;
import de.qfm.erp.service.model.jpa.shared.EPositionType;
import de.qfm.erp.service.model.jpa.user.EPrivilege;
import de.qfm.erp.service.service.calculator.SurrogatePositionNumberHelper;
import de.qfm.erp.service.service.handler.EntityFactory;
import de.qfm.erp.service.service.mapper.BaseMapper;
import de.qfm.erp.service.service.security.AuthenticationHelper;
import de.qfm.erp.service.service.security.UserService;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class StagePositionMapper {
    public static final Quotation FAKE_QUOTATION = new Quotation();
    public static final String COMMENT_INDICATOR = "*";
    public static final String REMARK_INDICATOR = "#";
    @NonNull
    public static final BiConsumer<QuotationPosition, QStagePositionUpdateBucket> NOOP = (x, y) -> {};
    private final AuthenticationHelper authenticationHelper;
    private final UserService userService;
    private final EntityFactory entityFactory;
    private static final Function<QuotationPosition, Boolean> FN_IMPORTABLE_POSITION = position -> {
        EPositionType positionType = position.getPositionType();
        EPositionType jumboPositionType = position.getJumboPositionType();
        boolean contains = EQStageType.MEASUREMENT_IMPORTABLE_POSITION_TYPES.contains((Object)positionType);
        if (contains && EPositionType.JUMBO_INTERNAL_TYPE_B == jumboPositionType && EPositionType.JUMBO == positionType) {
            return false;
        }
        return contains;
    };
    private static final Iterable<Pair<String, String>> TEXT_REPLACE = ImmutableSet.of((Object)Pair.of((Object)"\u2264", (Object)"<="), (Object)Pair.of((Object)"\u2265", (Object)">="));

    @Nonnull
    public List<StagePositionCommon> mapPositionItemToCommon(@NonNull QuotationBucket bucket, boolean includeAllPos) {
        if (bucket == null) {
            throw new NullPointerException("bucket is marked non-null but is null");
        }
        boolean hasValuePrivilege = this.userService.hasPrivilege(EPrivilege.QUOTATION__ALL_ATTRIBUTES_VISIBLE);
        Quotation stage = bucket.getQuotation();
        EQuotationPositionSortOption quotationPositionSortOption = bucket.getQuotationPositionSortOption();
        Iterable positions = StagePositionHelper.automaticShuffle((Quotation)stage, (EQuotationPositionSortOption)quotationPositionSortOption, (Iterable)bucket.getPositions());
        return ImmutableList.copyOf(IterableHelper.stream((Iterable)positions).filter(item -> !includeAllPos && item.getParent() == null || includeAllPos && (Boolean)FN_IMPORTABLE_POSITION.apply(item) != false).map(item -> this.mapPositionItemToCommon(item, stage, hasValuePrivilege, (Comparator)EQuotationPositionSortOption.SEQUENTIAL_NUMBER_ASC.getComparator())).iterator());
    }

    @Nonnull
    public StagePositionCommon mapPositionItemToCommon(@NonNull QuotationPosition position, @NonNull Quotation quotation, boolean hasValuePrivilege, Comparator<QuotationPosition> comparator) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        if (quotation == null) {
            throw new NullPointerException("quotation is marked non-null but is null");
        }
        StagePositionCommon common = new StagePositionCommon();
        BaseMapper.map((EntityBase)position, (EntityBaseCommon)common);
        common.setId(position.getId());
        common.setStageId(quotation.getId());
        Quotation positionStage = position.getQuotation();
        if (null != positionStage) {
            common.setQentityNumber(StringUtils.trimToEmpty((String)positionStage.getQNumber()));
            common.setAlias(StringUtils.trimToEmpty((String)positionStage.getAlias()));
            common.setAddendumNumber(positionStage.getAddendumNumber());
        }
        common.setPositionNumber(StringUtils.trimToEmpty((String)position.getPositionNumber()));
        common.setSubPositionNumber(position.getSubPositionNumber());
        String flagAlternativePositionString = ((EAlternativePositionType)MoreObjects.firstNonNull((Object)position.getAlternativePositionType(), (Object)EAlternativePositionType.NO)).name();
        common.setAlternativePositionType(flagAlternativePositionString);
        common.setSurrogatePositionNumber(StringUtils.trimToEmpty((String)position.getSurrogatePositionNumber()));
        common.setPositionNumberExternal(StringUtils.trimToEmpty((String)position.getPositionNumberExternal()));
        common.setGroupingElementLevel1(StringUtils.trimToEmpty((String)position.getGroupingElementLevel1()));
        common.setGroupingElementLevel2(StringUtils.trimToEmpty((String)position.getGroupingElementLevel2()));
        common.setGroupingElementLevel3(StringUtils.trimToEmpty((String)position.getGroupingElementLevel3()));
        common.setGroupingElementLevel4(StringUtils.trimToEmpty((String)position.getGroupingElementLevel4()));
        common.setSequentialNumber(position.getSequenceNumberQuotationStandard());
        common.setShortText(StringUtils.trimToEmpty((String)position.getShortText()));
        common.setLongText(StringUtils.trimToEmpty((String)position.getLongText()));
        common.setHasBidderComplement(((Boolean)MoreObjects.firstNonNull((Object)position.getHasBidderComplement(), (Object)false)).booleanValue());
        common.setBidderComplement(StringUtils.trimToEmpty((String)position.getBidderComplement()));
        common.setBidderComplementOriginal(StringUtils.trimToEmpty((String)position.getBidderComplementOriginal()));
        common.setRemarks(StringUtils.trimToEmpty((String)position.getRemarks()));
        common.setOrderedAmount(position.getOrderedAmount());
        common.setUnit(StringUtils.trimToEmpty((String)position.getUnit()));
        common.setSquadWagePerUnit(position.getSquadWagePerUnit());
        common.setSquadWageAggregated(position.getSquadWageAggregated());
        if (hasValuePrivilege) {
            common.setWagePercentage(position.getWagePercentage());
            common.setCompanyWagePerUnit(position.getCompanyWagePerItem());
            common.setCompanyWageAggregated(position.getCompanyWageAggregated());
            common.setInternalWagePerUnit(position.getWagePerUnit());
            common.setInternalWageAggregated(position.getInternalWageAggregated());
            common.setMaterialPurchasePricePerUnit(position.getMaterialWholesalePriceIncludingDiscountPerItem());
            common.setMaterialPercentage(position.getMaterialPercentage());
            common.setMaterialSellingPricePerUnit(position.getMaterialSellingPricePerUnit());
            common.setMaterialPurchasePriceAggregated(position.getMaterialWholesalePriceIncludingDiscountAggregated());
            common.setMaterialSellingPriceAggregated(position.getMaterialSellingPriceAggregated());
            common.setExternalServicePurchasePricePerUnit(position.getExternalServicePurchasePricePerUnit());
            common.setExternalServicePercentage(position.getExternalServicePercentage());
            common.setExternalServiceSellingPricePerUnit(position.getExternalServiceSellingPricePerUnit());
            common.setExternalServicePurchasePriceAggregated(position.getExternalServicePurchasePriceAggregated());
            common.setExternalServiceSellingPriceAggregated(position.getExternalServiceSellingPriceAggregated());
            common.setPricePerUnit(position.getPricePerUnit());
            common.setPriceAggregated(position.getPriceAggregated());
            common.setPercentageAggregated(position.getAggregatedPercentage());
        }
        common.setFlagFeePosition(position.getFlagFeePosition());
        common.setLockedCellsBitmask((Long)MoreObjects.firstNonNull((Object)position.getLockedCellsBitmask(), (Object)0L));
        QuotationPosition referencePosition = position.getReferencePosition();
        if (null != referencePosition) {
            common.setReferencePositionId(referencePosition.getId());
        }
        EPositionType positionType = (EPositionType)MoreObjects.firstNonNull((Object)position.getPositionType(), (Object)EPositionType.UNKNOWN);
        common.setPositionType(positionType.name());
        EPositionType jumboPositionType = (EPositionType)MoreObjects.firstNonNull((Object)position.getJumboPositionType(), (Object)EPositionType.UNKNOWN);
        common.setJumboPositionType(jumboPositionType.name());
        common.setFlagFeePosition((Boolean)MoreObjects.firstNonNull((Object)position.getFlagFeePosition(), (Object)false));
        common.setFlagFormatBold(position.getFlagFormatBold());
        common.setFlagFormatColor(position.getFlagFormatColor());
        common.setFormatColorCodeHex(position.getFormatColorCodeHex());
        QuotationPosition parent = position.getParent();
        if (null != parent) {
            common.setParentPositionId(parent.getId());
        }
        Set children = (Set)MoreObjects.firstNonNull((Object)position.getChildren(), (Object)ImmutableSet.of());
        List collect = (List)children.stream().sorted(comparator).map(item -> this.mapPositionItemToCommon(item, quotation, hasValuePrivilege, comparator)).collect(ImmutableList.toImmutableList());
        common.setChildren(collect);
        return common;
    }

    @Nonnull
    public QuotationPosition mergeQStagePosition(@NonNull QuotationPosition position, @NonNull QStagePositionUpdateBucket updateBucket) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        if (updateBucket == null) {
            throw new NullPointerException("updateBucket is marked non-null but is null");
        }
        position.setReferenceId(UUID.randomUUID().toString());
        StagePositionUpdateItem updateItem = updateBucket.getUpdateItem();
        QuotationPosition referencePosition = updateBucket.getReferencePosition();
        position.setSequenceNumberQuotationStandard((Integer)MoreObjects.firstNonNull((Object)updateItem.getSequentialNumber(), (Object)0));
        EPositionType positionType = updateBucket.getPositionType();
        position.setPositionType(positionType);
        EPositionType jumboPositionType = updateBucket.getJumboPositionType();
        position.setJumboPositionType(jumboPositionType);
        position.setPositionNumber(StringUtils.trimToEmpty((String)updateItem.getPositionNumber()));
        position.setGroupingElementLevel1(StringUtils.trimToEmpty((String)updateItem.getGroupingElementLevel1()));
        position.setGroupingElementLevel2(StringUtils.trimToEmpty((String)updateItem.getGroupingElementLevel2()));
        position.setGroupingElementLevel3(StringUtils.trimToEmpty((String)updateItem.getGroupingElementLevel3()));
        position.setGroupingElementLevel4(StringUtils.trimToEmpty((String)updateItem.getGroupingElementLevel4()));
        position.setAlternativePositionType(updateBucket.getAlternativePositionType());
        position.setSubPositionNumber(updateItem.getSubPositionNumber());
        position.setPositionNumberExternal(StringUtils.trimToEmpty((String)updateItem.getPositionNumberExternal()));
        position.setShortText(StringUtils.trimToEmpty((String)updateItem.getShortText()));
        position.setLongText(StringUtils.trimToEmpty((String)updateItem.getLongText()));
        position.setBidderComplement(StringUtils.trimToEmpty((String)updateItem.getBidderComplement()));
        if (null != referencePosition) {
            position.setHasBidderComplement(referencePosition.getHasBidderComplement());
            position.setBidderComplementOriginal(StringUtils.trimToEmpty((String)referencePosition.getBidderComplementOriginal()));
        }
        position.setOrderedAmount(updateItem.getOrderedAmount());
        position.setUnit(StringUtils.trimToEmpty((String)updateItem.getUnit()));
        position.setSquadWagePerUnit(updateItem.getSquadWagePerUnit());
        position.setSquadWageAggregated(updateItem.getSquadWageAggregated());
        position.setWagePercentage(updateItem.getWagePercentage());
        position.setWagePerUnit(updateItem.getInternalWagePerUnit());
        position.setInternalWageAggregated(updateItem.getInternalWageAggregated());
        position.setCompanyWagePerItem(updateItem.getCompanyWagePerUnit());
        position.setCompanyWageAggregated(updateItem.getCompanyWageAggregated());
        position.setExternalServicePurchasePricePerUnit(updateItem.getExternalServicePurchasePricePerUnit());
        position.setExternalServicePercentage(updateItem.getExternalServicePercentage());
        position.setExternalServiceSellingPricePerUnit(updateItem.getExternalServiceSellingPricePerUnit());
        position.setExternalServicePurchasePriceAggregated(updateItem.getExternalServicePurchasePriceAggregated());
        position.setExternalServiceSellingPriceAggregated(updateItem.getExternalServiceSellingPriceAggregated());
        position.setMaterialWholesalePriceIncludingDiscountPerItem(updateItem.getMaterialPurchasePricePerUnit());
        position.setMaterialPercentage(updateItem.getMaterialPercentage());
        position.setMaterialSellingPricePerUnit(updateItem.getMaterialSellingPricePerUnit());
        position.setMaterialWholesalePriceIncludingDiscountAggregated(updateItem.getMaterialPurchasePriceAggregated());
        position.setMaterialSellingPriceAggregated(updateItem.getMaterialSellingPriceAggregated());
        position.setPricePerUnit(updateItem.getPricePerUnit());
        position.setPriceAggregated(updateItem.getPriceAggregated());
        position.setAggregatedPercentage(updateItem.getPercentageAggregated());
        position.setFlagFeePosition(updateItem.getFlagFeePosition());
        position.setLockedCellsBitmask((Long)MoreObjects.firstNonNull((Object)updateItem.getLockedCellsBitmask(), (Object)0L));
        position.setRemarks(updateItem.getRemarks());
        position.setReferencePosition(referencePosition);
        position.setFlagFormatBold(updateItem.getFlagFormatBold());
        position.setFlagFormatColor(updateItem.getFlagFormatColor());
        position.setFormatColorCodeHex(updateItem.getFormatColorCodeHex());
        Iterable children = updateBucket.getChildren();
        MergedBucket childrenMergeBucket = BaseMapper.merge((EntityBase)position, QuotationPosition::getChildren, arg_0 -> ((QuotationPosition)position).setChildren(arg_0), (Iterable)children, QStagePositionUpdateBucket::getId, QuotationPosition::getId, () -> ((EntityFactory)this.entityFactory).quotationPosition(), (arg_0, arg_1) -> this.mergeQStagePosition(arg_0, arg_1), QuotationPosition::setParent, () -> ((AuthenticationHelper)this.authenticationHelper).currentUserName(), (BiConsumer)NOOP);
        for (QuotationPosition child : childrenMergeBucket.existent()) {
            child.setGroupingElementLevel1(position.getGroupingElementLevel1());
            child.setGroupingElementLevel2(position.getGroupingElementLevel2());
            child.setGroupingElementLevel3(position.getGroupingElementLevel3());
            child.setGroupingElementLevel4(position.getGroupingElementLevel4());
            child.setPositionNumber(position.getPositionNumber());
            child.setAlternativePositionType(position.getAlternativePositionType());
        }
        MergedBucket.printMergeBucket((Object)position, QuotationPosition.class, (MergedBucket)childrenMergeBucket);
        return position;
    }

    @Nonnull
    public QuotationPosition mergeQStagePositionForAddendumCA(@NonNull QuotationPosition position, @NonNull QStagePositionUpdateBucket updateBucket) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        if (updateBucket == null) {
            throw new NullPointerException("updateBucket is marked non-null but is null");
        }
        return this.mergeQStagePositionForAddendum(position, updateBucket, EQStageType.COMMISSION__ADDENDUM);
    }

    @Nonnull
    public QuotationPosition mergeQStagePositionForAddendumCUA(@NonNull QuotationPosition position, @NonNull QStagePositionUpdateBucket updateBucket) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        if (updateBucket == null) {
            throw new NullPointerException("updateBucket is marked non-null but is null");
        }
        return this.mergeQStagePositionForAddendum(position, updateBucket, EQStageType.COST_UNIT__ADDENDUM);
    }

    @Nonnull
    private QuotationPosition mergeQStagePositionForAddendum(@NonNull QuotationPosition position, @NonNull QStagePositionUpdateBucket updateBucket, @NonNull EQStageType stageType) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        if (updateBucket == null) {
            throw new NullPointerException("updateBucket is marked non-null but is null");
        }
        if (stageType == null) {
            throw new NullPointerException("stageType is marked non-null but is null");
        }
        StagePositionUpdateItem updateItem = updateBucket.getUpdateItem();
        QuotationPosition referencePosition = updateBucket.getReferencePosition();
        EPositionType desiredPositionType = updateBucket.getPositionType();
        if (null != referencePosition && EPositionType.CHANGE_IN_QUANTITY == desiredPositionType) {
            this.mergeInto(referencePosition, position, stageType, (Iterable)ImmutableSet.of());
            position.setReferencePosition(referencePosition);
            position.setPositionType(desiredPositionType);
            position.setJumboPositionType(EPositionType.UNKNOWN);
        } else {
            this.mergeQStagePosition(position, updateBucket);
        }
        position.setBidderComplement(Strings.nullToEmpty((String)updateItem.getBidderComplement()));
        position.setOrderedAmount(updateItem.getOrderedAmount());
        position.setRemarks(updateItem.getRemarks());
        return position;
    }

    @Nonnull
    public QuotationPosition mergeInto(@NonNull QuotationPosition source, @NonNull QuotationPosition target, @NonNull EQStageType targetStageType, @NonNull Iterable<EStagePositionMergeOption> mergeOptions) {
        boolean mergeAmount;
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (targetStageType == null) {
            throw new NullPointerException("targetStageType is marked non-null but is null");
        }
        if (mergeOptions == null) {
            throw new NullPointerException("mergeOptions is marked non-null but is null");
        }
        boolean addendumStageType = Iterables.contains((Iterable)EQStageType.ADDENDUM_TYPES, (Object)targetStageType);
        target.setReferenceId(source.getReferenceId());
        target.setPositionNumber(source.getPositionNumber());
        target.setSubPositionNumber(source.getSubPositionNumber());
        target.setSurrogatePositionNumber(source.getSurrogatePositionNumber());
        target.setPositionNumberExternal(source.getPositionNumberExternal());
        EPositionType sourcePositionType = source.getPositionType();
        target.setPositionType(sourcePositionType);
        target.setJumboPositionType(source.getJumboPositionType());
        target.setFlagAlternativePosition(source.getFlagAlternativePosition());
        target.setAlternativePositionType(source.getAlternativePositionType());
        target.setAddendumNumber(source.getAddendumNumber());
        target.setGroupingElementLevel1(source.getGroupingElementLevel1());
        target.setGroupingElementLevel2(source.getGroupingElementLevel2());
        target.setGroupingElementLevel3(source.getGroupingElementLevel3());
        target.setGroupingElementLevel4(source.getGroupingElementLevel4());
        target.setSequenceNumberQuotationStandard(source.getSequenceNumberQuotationStandard());
        boolean bl = mergeAmount = !Iterables.contains(mergeOptions, (Object)EStagePositionMergeOption.EXCLUDE_AMOUNT) && !addendumStageType;
        if (mergeAmount) {
            target.setOrderedAmount(source.getOrderedAmount());
        }
        target.setUnit(source.getUnit());
        target.setUnitAmount(source.getUnitAmount());
        target.setArticleCode(source.getArticleCode());
        target.setArticleName(source.getArticleName());
        target.setSupplierCode(source.getSupplierCode());
        target.setShortText(source.getShortText());
        target.setLongText(source.getLongText());
        target.setPricePerUnit(source.getPricePerUnit());
        target.setWagePerUnit(source.getWagePerUnit());
        target.setSquadWagePerUnit(source.getSquadWagePerUnit());
        target.setSquadWageAggregated(source.getSquadWageAggregated());
        target.setInternalWageAggregated(source.getInternalWageAggregated());
        target.setMaterialWholesalePriceExcludingDiscountAggregated(source.getMaterialWholesalePriceExcludingDiscountAggregated());
        target.setMaterialWholesalePriceIncludingDiscountAggregated(source.getMaterialWholesalePriceIncludingDiscountAggregated());
        target.setMaterialWholesalePriceExcludingDiscountPerItem(source.getMaterialWholesalePriceExcludingDiscountPerItem());
        target.setMaterialWholesalePriceIncludingDiscountPerItem(source.getMaterialWholesalePriceIncludingDiscountPerItem());
        target.setMaterialWholesalePriceDiscount(source.getMaterialWholesalePriceDiscount());
        target.setMaterialSellingPricePerUnit(source.getMaterialSellingPricePerUnit());
        target.setMaterialSellingPriceAggregated(source.getMaterialSellingPriceAggregated());
        target.setCompanyWagePerItem(source.getCompanyWagePerItem());
        target.setCompanyWageAggregated(source.getCompanyWageAggregated());
        target.setExternalServicePurchasePricePerUnit(source.getExternalServicePurchasePricePerUnit());
        target.setExternalServicePurchasePriceAggregated(source.getExternalServicePurchasePriceAggregated());
        target.setExternalServiceSellingPricePerUnit(source.getExternalServiceSellingPricePerUnit());
        target.setExternalServiceSellingPriceAggregated(source.getExternalServiceSellingPriceAggregated());
        target.setMaterialFactor(source.getMaterialFactor());
        target.setWageFactor(source.getWageFactor());
        target.setFactorAggregated(source.getFactorAggregated());
        target.setMaterialPercentage(source.getMaterialPercentage());
        target.setWagePercentage(source.getWagePercentage());
        target.setExternalServicePercentage(source.getExternalServicePercentage());
        target.setAggregatedPercentage(source.getAggregatedPercentage());
        target.setPriceAggregated(source.getPriceAggregated());
        target.setFlagFlatRate(source.getFlagFlatRate());
        target.setFlagFeePosition(source.getFlagFeePosition());
        target.setLockedCellsBitmask((Long)MoreObjects.firstNonNull((Object)source.getLockedCellsBitmask(), (Object)0L));
        target.setFlagFormatBold((Boolean)MoreObjects.firstNonNull((Object)source.getFlagFormatBold(), (Object)false));
        target.setFlagFormatColor((Boolean)MoreObjects.firstNonNull((Object)source.getFlagFormatColor(), (Object)false));
        target.setFormatColorCodeHex(source.getFormatColorCodeHex());
        target.setHasBidderComplement(source.getHasBidderComplement());
        target.setBidderComplementOriginal(source.getBidderComplementOriginal());
        if (!addendumStageType) {
            target.setBidderComplement(source.getBidderComplement());
            target.setRemarks(source.getRemarks());
        }
        return target;
    }

    @Nonnull
    public QuotationPosition mergeQStagePosition(@NonNull Quotation stage, @NonNull AtomicInteger sequenceNumber, @NonNull QuotationPosition quotationPosition, @NonNull GaebExtractResult gaebExtractResult, @NonNull GaebPosition gaebPosition) {
        String g4;
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        if (sequenceNumber == null) {
            throw new NullPointerException("sequenceNumber is marked non-null but is null");
        }
        if (quotationPosition == null) {
            throw new NullPointerException("quotationPosition is marked non-null but is null");
        }
        if (gaebExtractResult == null) {
            throw new NullPointerException("gaebExtractResult is marked non-null but is null");
        }
        if (gaebPosition == null) {
            throw new NullPointerException("gaebPosition is marked non-null but is null");
        }
        Iterable itemFormats = gaebExtractResult.getItemFormats();
        ItemFormat positionFormat = Iterables.isEmpty((Iterable)itemFormats) ? ItemFormat.DEFAULT_POS_FORMAT : (ItemFormat)Iterables.get((Iterable)itemFormats, (int)0);
        Iterable levelFormats = gaebExtractResult.getLevelFormats();
        ImmutableMap levelFormatsMap = Maps.uniqueIndex((Iterable)levelFormats, ItemFormat::getLevel);
        boolean structureLvl = gaebPosition.isStructureLvl();
        boolean remark = EGaebPositionType.REMARK == gaebPosition.getPositionType();
        boolean groupingMark = structureLvl || remark;
        String mark = structureLvl ? "*" : "#";
        boolean g1Set = null != gaebPosition.getL1();
        boolean g2Set = null != gaebPosition.getL2();
        boolean g3Set = null != gaebPosition.getL3();
        boolean g4Set = null != gaebPosition.getL4();
        boolean g5Set = null != gaebPosition.getL5();
        boolean starSet = false;
        String g1 = g1Set ? StagePositionMapper.groupingLvl((Map)levelFormatsMap, (Pair)gaebPosition.getL1()) : (structureLvl ? "*" : "");
        String g2 = g2Set ? StagePositionMapper.groupingLvl((Map)levelFormatsMap, (Pair)gaebPosition.getL2()) : (!(starSet |= StringUtils.equalsIgnoreCase((CharSequence)g1, (CharSequence)"*")) && structureLvl ? "*" : "");
        String g3 = g3Set ? StagePositionMapper.groupingLvl((Map)levelFormatsMap, (Pair)gaebPosition.getL3()) : (!(starSet |= StringUtils.equalsIgnoreCase((CharSequence)g2, (CharSequence)"*")) && structureLvl ? "*" : "");
        String string = g4Set ? StagePositionMapper.groupingLvl((Map)levelFormatsMap, (Pair)gaebPosition.getL4()) : (g4 = !(starSet |= StringUtils.equalsIgnoreCase((CharSequence)g3, (CharSequence)"*")) && structureLvl ? "*" : "");
        String posNr = !starSet && groupingMark ? mark : (groupingMark ? "" : StringUtils.leftPad((String)StringUtils.trimToEmpty((String)gaebPosition.getRno()), (int)positionFormat.getLength(), (char)'0'));
        quotationPosition.setGroupingElementLevel1(g1);
        quotationPosition.setGroupingElementLevel2(g2);
        quotationPosition.setGroupingElementLevel3(g3);
        quotationPosition.setGroupingElementLevel4(g4);
        quotationPosition.setPositionNumber(posNr);
        quotationPosition.setSurrogatePositionNumber(SurrogatePositionNumberHelper.surrogatePositionNumber((QuotationPosition)quotationPosition));
        String shortText = StringUtils.trimToEmpty((String)StringUtils.left((String)gaebPosition.getShortText(), (int)500));
        String shortTextCleaned = StagePositionMapper.clean((String)shortText);
        quotationPosition.setShortText(shortTextCleaned);
        quotationPosition.setShortTextOriginal(shortTextCleaned);
        String longText = StringUtils.trimToEmpty((String)gaebPosition.getLongText());
        String longTextCleaned = StagePositionMapper.clean((String)longText);
        quotationPosition.setLongText(longTextCleaned);
        quotationPosition.setLongTextOriginal(longTextCleaned);
        quotationPosition.setOrderedAmount(gaebPosition.getAmount());
        EAlternativePositionType alternativePositionType = gaebPosition.getAlternativePositionType();
        String alternatePositionStr = EAlternativePositionType.YES__EXCLUDE_FROM_CALCULATION == alternativePositionType ? "x" : "";
        quotationPosition.setFlagAlternativePosition(alternatePositionStr);
        quotationPosition.setAlternativePositionType(alternativePositionType);
        quotationPosition.setUnit(StringUtils.trimToEmpty((String)gaebPosition.getUnit()));
        quotationPosition.setSequenceNumberQuotationStandard(Integer.valueOf(sequenceNumber.getAndIncrement()));
        quotationPosition.setHasBidderComplement(Boolean.valueOf(gaebPosition.isHasBidderComplement()));
        quotationPosition.setBidderComplementOriginal(StringUtils.trimToEmpty((String)gaebPosition.getBidderComplement()));
        quotationPosition.setBidderComplement(StringUtils.trimToEmpty((String)gaebPosition.getBidderComplement()));
        quotationPosition.setPricePerUnit(gaebPosition.getPricePerUnit());
        quotationPosition.setPriceAggregated(gaebPosition.getPriceOverall());
        BigDecimal materialPercentageStandard = (BigDecimal)MoreObjects.firstNonNull((Object)stage.getMaterialPercentageStandard(), (Object)BigDecimal.ZERO);
        quotationPosition.setMaterialPercentage(materialPercentageStandard);
        BigDecimal wagePercentage = (BigDecimal)MoreObjects.firstNonNull((Object)stage.getWagePercentageStandard(), (Object)BigDecimal.ZERO);
        quotationPosition.setWagePercentage(wagePercentage);
        quotationPosition.setExternalServicePercentage(materialPercentageStandard);
        quotationPosition.setFlagFeePosition(Boolean.valueOf(false));
        EPositionType positionType = structureLvl ? EPositionType.COMMENT : (remark ? EPositionType.REMARK : EPositionType.STANDARD);
        quotationPosition.setPositionType(positionType);
        quotationPosition.setJumboPositionType(EPositionType.UNKNOWN);
        return quotationPosition;
    }

    @Nonnull
    @VisibleForTesting
    static String clean(@Nonnull String text) {
        String result = StringUtils.trimToEmpty((String)text);
        for (Pair tuple : TEXT_REPLACE) {
            result = StringUtils.replace((String)result, (String)((String)tuple.getLeft()), (String)((String)tuple.getRight()));
        }
        return result;
    }

    @Nonnull
    @VisibleForTesting
    static String groupingLvl(@NonNull Map<Integer, ItemFormat> levelFormatsMap, @Nullable Pair<String, String> pair) {
        String valueToPad;
        if (levelFormatsMap == null) {
            throw new NullPointerException("levelFormatsMap is marked non-null but is null");
        }
        if (null != pair && null != (valueToPad = (String)pair.getRight())) {
            ItemFormat itemFormat = levelFormatsMap.get(valueToPad);
            int padding = null != itemFormat ? itemFormat.getLength() : ItemFormat.DEFAULT_LEVEL_FORMAT.getLength();
            return StringUtils.leftPad((String)valueToPad, (int)padding, (char)'0');
        }
        return "";
    }

    @Nonnull
    public StagePositionPageCommon mapToPageCommon(@NonNull Page<QuotationPosition> page, @NonNull EQuotationPositionSortOption sortOption) {
        if (page == null) {
            throw new NullPointerException("page is marked non-null but is null");
        }
        if (sortOption == null) {
            throw new NullPointerException("sortOption is marked non-null but is null");
        }
        boolean hasValuePrivilege = this.userService.hasPrivilege(EPrivilege.QUOTATION__ALL_ATTRIBUTES_VISIBLE);
        QuotationPositionComparator comparator = sortOption.getComparator();
        long totalElements = page.getTotalElements();
        int totalPages = page.getTotalPages();
        Pageable pageable = page.getPageable();
        int pageSize = pageable.isPaged() ? pageable.getPageSize() : 0;
        int pageNumber = pageable.isPaged() ? pageable.getPageNumber() : 0;
        List content = page.getContent();
        List commons = (List)content.stream().sorted(comparator).map(arg_0 -> this.lambda$mapToPageCommon$5(hasValuePrivilege, (Comparator)comparator, arg_0)).collect(ImmutableList.toImmutableList());
        return new StagePositionPageCommon(pageNumber, pageSize, totalPages, totalElements, commons);
    }

    @Nonnull
    public Iterable<StagePositionCommon> mapCPPositions(@NonNull Quotation quotation, @NonNull Iterable<QuotationPosition> quotationPositions) {
        if (quotation == null) {
            throw new NullPointerException("quotation is marked non-null but is null");
        }
        if (quotationPositions == null) {
            throw new NullPointerException("quotationPositions is marked non-null but is null");
        }
        QuotationPositionComparator comparator = EQuotationPositionSortOption.SEQUENTIAL_NUMBER_ASC.getComparator();
        return ImmutableList.copyOf(IterableHelper.stream(quotationPositions).sorted(comparator).map(arg_0 -> this.lambda$mapCPPositions$6(quotation, (Comparator)comparator, arg_0)).iterator());
    }

    public StagePositionMapper(AuthenticationHelper authenticationHelper, UserService userService, EntityFactory entityFactory) {
        this.authenticationHelper = authenticationHelper;
        this.userService = userService;
        this.entityFactory = entityFactory;
    }

    private /* synthetic */ StagePositionCommon lambda$mapCPPositions$6(Quotation quotation, Comparator comparator, QuotationPosition item) {
        return this.mapPositionItemToCommon(item, quotation, true, comparator);
    }

    private /* synthetic */ StagePositionCommon lambda$mapToPageCommon$5(boolean hasValuePrivilege, Comparator comparator, QuotationPosition item) {
        return this.mapPositionItemToCommon(item, FAKE_QUOTATION, hasValuePrivilege, comparator);
    }
}

